/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.fightarena;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.FIGHT_ARENA)
public class FightArena
extends BasicQuestHelper {
    ItemRequirement coins;
    ItemRequirement khazardHelmet;
    ItemRequirement khazardPlatebody;
    ItemRequirement khazardHelmetEquipped;
    ItemRequirement khazardPlatebodyEquipped;
    ItemRequirement khaliBrew;
    ItemRequirement cellKeys;
    ItemRequirement combatGear;
    Requirement hasKhazardArmour;
    Requirement inArena;
    Requirement inArenaWithOgre;
    Requirement inArenaWithScorpion;
    Requirement inArenaWithBouncer;
    Requirement inCell;
    QuestStep startQuest;
    QuestStep searchChest;
    QuestStep talkToGuard;
    QuestStep buyKhaliBrew;
    QuestStep giveKhaliBrew;
    QuestStep getCellKeys;
    QuestStep openCell;
    QuestStep talkToSammy;
    QuestStep killOgre;
    QuestStep talkToKhazard;
    QuestStep talkToHengrad;
    QuestStep talkToSammyForScorpion;
    QuestStep killScorpion;
    QuestStep talkToSammyForBouncer;
    QuestStep killBouncer;
    QuestStep leaveArena;
    QuestStep endQuest;
    Zone arena1;
    Zone cell;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.startQuest);
        steps.put(1, this.searchChest);
        ConditionalStep talkToGuardSteps = new ConditionalStep((QuestHelper)this, this.searchChest, new Requirement[0]);
        talkToGuardSteps.addStep(this.hasKhazardArmour, this.talkToGuard);
        steps.put(2, talkToGuardSteps);
        ConditionalStep giveKhaliBrewSteps = new ConditionalStep((QuestHelper)this, this.searchChest, new Requirement[0]);
        giveKhaliBrewSteps.addStep(new Conditions(this.hasKhazardArmour, this.khaliBrew), this.giveKhaliBrew);
        giveKhaliBrewSteps.addStep(new Conditions(this.hasKhazardArmour), this.buyKhaliBrew);
        steps.put(3, giveKhaliBrewSteps);
        ConditionalStep openCellSteps = new ConditionalStep((QuestHelper)this, this.searchChest, new Requirement[0]);
        openCellSteps.addStep(new Conditions(this.hasKhazardArmour, this.cellKeys), this.openCell);
        openCellSteps.addStep(new Conditions(this.hasKhazardArmour), this.getCellKeys);
        steps.put(4, openCellSteps);
        steps.put(5, openCellSteps);
        ConditionalStep killOgreSteps = new ConditionalStep((QuestHelper)this, this.talkToSammy, new Requirement[0]);
        killOgreSteps.addStep(new Conditions(this.inArenaWithOgre), this.killOgre);
        steps.put(6, killOgreSteps);
        steps.put(7, this.talkToKhazard);
        steps.put(8, this.talkToKhazard);
        ConditionalStep inPrisonAndKillScorpionSteps = new ConditionalStep((QuestHelper)this, this.talkToSammyForScorpion, new Requirement[0]);
        inPrisonAndKillScorpionSteps.addStep(this.inCell, this.talkToHengrad);
        inPrisonAndKillScorpionSteps.addStep(new Conditions(this.inArenaWithScorpion), this.killScorpion);
        steps.put(9, inPrisonAndKillScorpionSteps);
        ConditionalStep killBouncerSteps = new ConditionalStep((QuestHelper)this, this.talkToSammyForBouncer, new Requirement[0]);
        killBouncerSteps.addStep(new Conditions(this.inArenaWithBouncer), this.killBouncer);
        steps.put(10, killBouncerSteps);
        ConditionalStep endQuestSteps = new ConditionalStep((QuestHelper)this, this.endQuest, new Requirement[0]);
        endQuestSteps.addStep(this.inArena, this.leaveArena);
        steps.put(11, endQuestSteps);
        steps.put(12, endQuestSteps);
        steps.put(13, endQuestSteps);
        steps.put(14, endQuestSteps);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS, 5);
        this.khazardHelmet = new ItemRequirement("Khazard helmet", 74);
        this.khazardPlatebody = new ItemRequirement("Khazard armour", 75);
        this.khazardHelmetEquipped = new ItemRequirement("Khazard helmet", 74, 1, true);
        this.khazardPlatebodyEquipped = new ItemRequirement("Khazard armour", 75, 1, true);
        this.khaliBrew = new ItemRequirement("Khali brew", 77);
        this.cellKeys = new ItemRequirement("Khazard cell keys", 76);
        this.cellKeys.setHighlightInInventory(true);
        this.combatGear = new ItemRequirement("Combat equipment and food (magic/ranged if you want to safe spot)", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
    }

    public void setupZones() {
        this.arena1 = new Zone(new WorldPoint(2583, 3152, 0), new WorldPoint(2606, 3170, 0));
        this.cell = new Zone(new WorldPoint(2597, 3142, 0), new WorldPoint(2601, 3144, 0));
    }

    public void setupConditions() {
        this.hasKhazardArmour = new ItemRequirements(this.khazardHelmet, this.khazardPlatebody);
        this.inCell = new ZoneRequirement(this.cell);
        this.inArena = new ZoneRequirement(this.arena1);
        this.inArenaWithOgre = new Conditions(this.inArena, new NpcCondition(1225, this.arena1));
        this.inArenaWithScorpion = new Conditions(this.inArena, new NpcCondition(1226, this.arena1));
        this.inArenaWithBouncer = new Conditions(this.inArena, new NpcCondition(1224, this.arena1));
    }

    public void setupSteps() {
        this.startQuest = new NpcStep((QuestHelper)this, 12029, new WorldPoint(2565, 3199, 0), "Talk to Lady Servil, west-southwest of the Monastery south of Ardougne.", new Requirement[0]);
        this.startQuest.addDialogStep(2, "Can I help you?");
        this.searchChest = new ObjectStep((QuestHelper)this, 75, new WorldPoint(2613, 3189, 0), "Search the chest to the east for some Khazard armour.", new Requirement[0]);
        ((ObjectStep)this.searchChest).addAlternateObjects(76);
        this.talkToGuard = new NpcStep((QuestHelper)this, 1209, new WorldPoint(2615, 3143, 0), "Equip Khazard armour, talk to the Khazard Guard in the southeast of the prison.", this.khazardHelmetEquipped, this.khazardPlatebodyEquipped);
        this.buyKhaliBrew = new NpcStep((QuestHelper)this, 1214, new WorldPoint(2567, 3140, 0), "Buy Khali brew for 5 coins from the nearby bar to the west.", this.coins);
        this.buyKhaliBrew.addDialogStep(2, "I'd like a Khali brew please.");
        this.giveKhaliBrew = new NpcStep((QuestHelper)this, 1209, new WorldPoint(2615, 3143, 0), "Take the brew back to the Khazard Guard.", this.khazardHelmetEquipped, this.khazardPlatebodyEquipped, this.khaliBrew);
        this.getCellKeys = new NpcStep((QuestHelper)this, 1209, new WorldPoint(2615, 3143, 0), "Get another set of keys from the Khazard Guard", this.khazardHelmetEquipped, this.khazardPlatebodyEquipped);
        this.openCell = new ObjectStep((QuestHelper)this, 80, new WorldPoint(2617, 3167, 0), "Get ready to fight the monsters (all safespottable), starting with Khazard Ogre (level 63). Use the keys on Sammy's cell door to free him.", this.combatGear, this.cellKeys);
        this.openCell.addIcon(76);
        this.talkToSammy = new NpcStep((QuestHelper)this, 12031, new WorldPoint(2602, 3153, 0), "Talk to Sammy, then fight the ogre.", new Requirement[0]);
        this.killOgre = new NpcStep((QuestHelper)this, 1225, new WorldPoint(2601, 3163, 0), "Kill the Ogre. You can lure it behind a skeleton to safespot it.", this.combatGear);
        this.killOgre.addSubSteps(this.talkToSammy);
        this.talkToKhazard = new NpcStep((QuestHelper)this, 12025, new WorldPoint(2605, 3153, 0), "Talk to General Khazard.", new Requirement[0]);
        this.talkToHengrad = new NpcStep((QuestHelper)this, 1218, new WorldPoint(2599, 3143, 0), "Talk to Hengrad.", new Requirement[0]);
        this.talkToHengrad.addSubSteps(this.talkToKhazard);
        this.talkToSammyForScorpion = new NpcStep((QuestHelper)this, 12031, new WorldPoint(2602, 3153, 0), "Talk to Sammy, then fight the scorpion.", new Requirement[0]);
        this.killScorpion = new NpcStep((QuestHelper)this, 1226, new WorldPoint(2601, 3163, 0), "Kill the Scorpion. You can lure it behind a skeleton to safespot it.", this.combatGear);
        this.killScorpion.addSubSteps(this.talkToSammyForScorpion);
        this.talkToSammyForBouncer = new NpcStep((QuestHelper)this, 12031, new WorldPoint(2602, 3153, 0), "Talk to Sammy, then fight Bouncer.", new Requirement[0]);
        this.killBouncer = new NpcStep((QuestHelper)this, 1224, new WorldPoint(2601, 3163, 0), "Kill Bouncer. You can lure it behind a skeleton to safespot it. Warning: After Bouncer is killed, you will be unable to re-enter the arena.", this.combatGear);
        this.killBouncer.addSubSteps(this.talkToSammyForBouncer);
        this.leaveArena = new ObjectStep((QuestHelper)this, 82, new WorldPoint(2606, 3152, 0), "Exit the arena (can ignore General Khazard). Warning: You will be unable to re-enter the arena.", new Requirement[0]);
        this.endQuest = new NpcStep((QuestHelper)this, 12029, new WorldPoint(2565, 3199, 0), "Go back to Lady Servil to end the quest.", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Collections.singletonList(this.coins);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Collections.singletonList(this.combatGear);
    }

    @Override
    public List<String> getCombatRequirements() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("Khazard Scorpion (level 44) (safespottable)");
        reqs.add("Khazard Ogre (level 63) (safespottable)");
        reqs.add("Bouncer (level 137) (safespottable)");
        reqs.add("General Khazard (level 142) (safespottable) (optional)");
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.ATTACK, 12175), new ExperienceReward(Skill.THIEVING, 2175));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Coins", 995, 1000), new ItemReward("Khazard Armor", 75, 1));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Start quest", Arrays.asList(this.startQuest, this.searchChest, this.talkToGuard, this.buyKhaliBrew, this.giveKhaliBrew), this.coins));
        allSteps.add(new PanelDetails("Fight!", Arrays.asList(this.getCellKeys, this.openCell, this.killOgre, this.talkToHengrad, this.killScorpion, this.killBouncer), this.combatGear));
        allSteps.add(new PanelDetails("Finish quest", Arrays.asList(this.leaveArena, this.endQuest), new Requirement[0]));
        return allSteps;
    }
}

