/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.familycrest;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.ObjectCondition;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.FAMILY_CREST)
public class FamilyCrest
extends BasicQuestHelper {
    ItemRequirement shrimp;
    ItemRequirement salmon;
    ItemRequirement tuna;
    ItemRequirement bass;
    ItemRequirement swordfish;
    ItemRequirement pickaxe;
    ItemRequirement ruby;
    ItemRequirement ruby2;
    ItemRequirement ringMould;
    ItemRequirement necklaceMould;
    ItemRequirement antipoison;
    ItemRequirement runesForBlasts;
    ItemRequirement gold2;
    ItemRequirement gold;
    ItemRequirement perfectRing;
    ItemRequirement perfectNecklace;
    ItemRequirement goldBar;
    ItemRequirement goldBar2;
    ItemRequirement crestPiece1;
    ItemRequirement crestPiece2;
    ItemRequirement crestPiece3;
    ItemRequirement crest;
    ItemRequirement varrockTele;
    ItemRequirement faladorTele;
    ItemRequirement ardyTele;
    ItemRequirement alkharidTele;
    ItemRequirement catherbyTele;
    ItemRequirement dwarvenMineTele;
    Requirement inDwarvenMines;
    Requirement inHobgoblinDungeon;
    Requirement northWallUp;
    Requirement southRoomUp;
    Requirement northRoomUp;
    Requirement northWallDown;
    Requirement southRoomDown;
    Requirement northRoomDown;
    Requirement inJollyBoar;
    Requirement inEdgevilleDungeon;
    Requirement crest3Nearby;
    NpcStep talkToDimintheis;
    NpcStep talkToCaleb;
    NpcStep talkToCalebWithFish;
    NpcStep talkToCalebOnceMore;
    NpcStep talkToGemTrader;
    NpcStep talkToMan;
    ObjectStep enterDwarvenMine;
    NpcStep talkToBoot;
    ObjectStep enterWitchavenDungeon;
    ObjectStep pullNorthLever;
    ObjectStep pullSouthRoomLever;
    ObjectStep pullNorthLeverAgain;
    ObjectStep pullNorthRoomLever;
    ObjectStep pullNorthLever3;
    ObjectStep pullSouthRoomLever2;
    QuestStep followPathAroundEast;
    QuestStep mineGold;
    ObjectStep smeltGold;
    QuestStep makeRing;
    QuestStep makeNecklace;
    QuestStep returnToMan;
    ObjectStep goUpToJohnathon;
    QuestStep talkToJohnathon;
    QuestStep giveJohnathonAntipoison;
    QuestStep killChronizon;
    QuestStep pickUpCrest3;
    QuestStep repairCrest;
    QuestStep returnCrest;
    ObjectStep goDownToChronizon;
    Zone dwarvenMines;
    Zone hobgoblinDungeon;
    Zone jollyBoar;
    Zone edgevilleDungeon;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToDimintheis);
        steps.put(1, this.talkToCaleb);
        steps.put(2, this.talkToCalebWithFish);
        steps.put(3, this.talkToCalebOnceMore);
        steps.put(4, this.talkToGemTrader);
        steps.put(5, this.talkToMan);
        ConditionalStep goTalkToBoot = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterDwarvenMine, new Requirement[0]);
        goTalkToBoot.addStep(this.inDwarvenMines, this.talkToBoot);
        steps.put(6, goTalkToBoot);
        ConditionalStep getGold = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterWitchavenDungeon, new Requirement[0]);
        getGold.addStep(new Conditions(this.perfectNecklace.alsoCheckBank(this.questBank), this.perfectRing.alsoCheckBank(this.questBank)), this.returnToMan);
        getGold.addStep(this.perfectNecklace.alsoCheckBank(this.questBank), this.makeRing);
        getGold.addStep(new Conditions(this.gold.alsoCheckBank(this.questBank), this.goldBar.alsoCheckBank(this.questBank)), this.smeltGold);
        getGold.addStep(this.goldBar.alsoCheckBank(this.questBank), this.makeNecklace);
        getGold.addStep(this.gold2.alsoCheckBank(this.questBank), this.smeltGold);
        getGold.addStep(new Conditions(this.northRoomUp, this.southRoomDown), this.mineGold);
        getGold.addStep(new Conditions(this.northRoomUp, this.northWallUp), this.pullSouthRoomLever2);
        getGold.addStep(new Conditions(this.northRoomUp, this.northWallDown), this.pullNorthLever3);
        getGold.addStep(new Conditions(this.northWallDown, this.southRoomUp), this.pullNorthRoomLever);
        getGold.addStep(this.southRoomUp, this.pullNorthLeverAgain);
        getGold.addStep(this.northWallUp, this.pullSouthRoomLever);
        getGold.addStep(this.northWallDown, this.pullNorthLever);
        getGold.addStep(this.inHobgoblinDungeon, this.followPathAroundEast);
        steps.put(7, getGold);
        ConditionalStep goTalkToJohnathon = new ConditionalStep((QuestHelper)this, (QuestStep)this.goUpToJohnathon, new Requirement[0]);
        goTalkToJohnathon.addStep(this.inJollyBoar, this.talkToJohnathon);
        steps.put(8, goTalkToJohnathon);
        ConditionalStep goGiveAntipoisonToJohnathon = new ConditionalStep((QuestHelper)this, (QuestStep)this.goUpToJohnathon, new Requirement[0]);
        goGiveAntipoisonToJohnathon.addStep(this.inJollyBoar, this.giveJohnathonAntipoison);
        steps.put(9, goGiveAntipoisonToJohnathon);
        ConditionalStep goKillChronizon = new ConditionalStep((QuestHelper)this, (QuestStep)this.goDownToChronizon, new Requirement[0]);
        goKillChronizon.addStep(this.crest.alsoCheckBank(this.questBank), this.returnCrest);
        goKillChronizon.addStep(this.crestPiece3.alsoCheckBank(this.questBank), this.repairCrest);
        goKillChronizon.addStep(this.crest3Nearby, this.pickUpCrest3);
        goKillChronizon.addStep(this.inEdgevilleDungeon, this.killChronizon);
        steps.put(10, goKillChronizon);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.varrockTele = new ItemRequirement("Varrock Teleports", 8007, 2);
        this.faladorTele = new ItemRequirement("Falador Teleport", 8009);
        this.ardyTele = new ItemRequirement("Ardougne Teleport", 8011);
        this.alkharidTele = new ItemRequirement("Al-Kharid Teleport", ItemCollections.RING_OF_DUELINGS, 2);
        this.alkharidTele.setChargedItem(true);
        this.catherbyTele = new ItemRequirement("Camelot/Catherby Teleport", 24961);
        this.dwarvenMineTele = new ItemRequirement("Teleport to the Dwarven Mine (Combat Bracelet [3], Skills Necklace [2])", ItemCollections.SKILLS_NECKLACES);
        this.dwarvenMineTele.addAlternates(ItemCollections.COMBAT_BRACELETS);
        this.varrockTele.addAlternates(19476, 13069);
        this.varrockTele.addAlternates(ItemCollections.RING_OF_WEALTHS);
        this.ardyTele.addAlternates(ItemCollections.ARDY_CLOAKS);
        this.alkharidTele.addAlternates(ItemCollections.AMULET_OF_GLORIES);
        this.catherbyTele.addAlternates(8010);
        this.shrimp = new ItemRequirement("Shrimps", 315);
        this.salmon = new ItemRequirement("Salmon", 329);
        this.tuna = new ItemRequirement("Tuna", 361);
        this.bass = new ItemRequirement("Bass", 365);
        this.swordfish = new ItemRequirement("Swordfish", 373);
        this.pickaxe = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES).isNotConsumed();
        this.ruby = new ItemRequirement("Ruby", 1603);
        this.ruby2 = new ItemRequirement("Ruby", 1603, 2);
        this.ringMould = new ItemRequirement("Ring mould", 1592).isNotConsumed();
        this.necklaceMould = new ItemRequirement("Necklace mould", 1597).isNotConsumed();
        this.antipoison = new ItemRequirement("At least one dose of antipoison or superantipoison", ItemCollections.ANTIPOISONS);
        this.runesForBlasts = new ItemRequirement("Runes for casting each of the 4 blast spells", -1, -1);
        this.runesForBlasts.setDisplayItemId(560);
        this.gold = new ItemRequirement("'perfect' gold ore", 446);
        this.gold2 = new ItemRequirement("'perfect' gold ore", 446, 2);
        this.goldBar = new ItemRequirement("'perfect' gold bar", 2365);
        this.goldBar2 = new ItemRequirement("'perfect' gold bar", 2365, 2);
        this.perfectRing = new ItemRequirement("'perfect' ring", 773);
        this.perfectNecklace = new ItemRequirement("'perfect' necklace", 774);
        this.crest = new ItemRequirement("Family crest", 782);
        this.crestPiece1 = new ItemRequirement("Crest part", 779);
        this.crestPiece1.setTooltip("You can get another from Caleb in Catherby");
        this.crestPiece2 = new ItemRequirement("Crest part", 780);
        this.crestPiece2.setTooltip("You can get another from Avan north of Al Kharid");
        this.crestPiece3 = new ItemRequirement("Crest part", 781);
    }

    public void loadZones() {
        this.dwarvenMines = new Zone(new WorldPoint(2960, 9696, 0), new WorldPoint(3062, 9854, 0));
        this.hobgoblinDungeon = new Zone(new WorldPoint(2691, 9665, 0), new WorldPoint(2749, 9720, 0));
        this.jollyBoar = new Zone(new WorldPoint(3271, 3485, 1), new WorldPoint(3288, 3511, 1));
        this.edgevilleDungeon = new Zone(new WorldPoint(3073, 9820, 0), new WorldPoint(3287, 10000, 0));
    }

    public void setupConditions() {
        this.inDwarvenMines = new ZoneRequirement(this.dwarvenMines);
        this.inHobgoblinDungeon = new ZoneRequirement(this.hobgoblinDungeon);
        this.northWallUp = new ObjectCondition(2422, new WorldPoint(2722, 9710, 0));
        this.southRoomUp = new ObjectCondition(2424, new WorldPoint(2724, 9669, 0));
        this.northRoomUp = new ObjectCondition(2426, new WorldPoint(2722, 9718, 0));
        this.northWallDown = new ObjectCondition(2421, new WorldPoint(2722, 9710, 0));
        this.southRoomDown = new ObjectCondition(2423, new WorldPoint(2724, 9669, 0));
        this.northRoomDown = new ObjectCondition(2425, new WorldPoint(2722, 9718, 0));
        this.inJollyBoar = new ZoneRequirement(this.jollyBoar);
        this.inEdgevilleDungeon = new ZoneRequirement(this.edgevilleDungeon);
        this.crest3Nearby = new ItemOnTileRequirement(this.crestPiece3);
    }

    public void setupSteps() {
        this.talkToDimintheis = new NpcStep((QuestHelper)this, 4984, new WorldPoint(3280, 3402, 0), "Talk to Dimintheis in south east Varrock.", new Requirement[0]);
        this.talkToDimintheis.addDialogStep("Why would a nobleman live in a dump like this?");
        this.talkToDimintheis.addDialogStep("So where is this crest?");
        this.talkToDimintheis.addDialogStep("Ok, I will help you.");
        this.talkToCaleb = new NpcStep((QuestHelper)this, 4317, new WorldPoint(2819, 3452, 0), "Talk to Caleb in Catherby.", new Requirement[0]);
        this.talkToCaleb.addDialogStep("Are you Caleb Fitzharmon?");
        this.talkToCaleb.addDialogStep("So can I have your bit?");
        this.talkToCaleb.addDialogStep("Ok, I will get those.");
        this.talkToCaleb.addTeleport(this.catherbyTele);
        this.talkToCalebWithFish = new NpcStep((QuestHelper)this, 4317, new WorldPoint(2819, 3452, 0), "Talk to Caleb again with the required fish.", this.shrimp, this.salmon, this.tuna, this.bass, this.swordfish);
        this.talkToCalebOnceMore = new NpcStep((QuestHelper)this, 4317, new WorldPoint(2819, 3452, 0), "Talk to Caleb in Catherby once more.", new Requirement[0]);
        this.talkToCalebOnceMore.addDialogStep("Uh.. what happened to the rest of the crest?");
        this.talkToGemTrader = new NpcStep((QuestHelper)this, 2874, new WorldPoint(3286, 3211, 0), "Talk to the Gem Trader in Al Kharid.", new Requirement[0]);
        this.talkToGemTrader.addDialogStep("I'm in search of a man named Avan Fitzharmon.");
        this.talkToGemTrader.addTeleport(this.alkharidTele.quantity(1));
        this.talkToMan = new NpcStep((QuestHelper)this, 385, new WorldPoint(3295, 3275, 0), "Talk to the man south of the Al Kharid mine.", new Requirement[0]);
        this.talkToMan.addDialogStep("I'm looking for a man named Avan Fitzharmon.");
        this.enterDwarvenMine = new ObjectStep((QuestHelper)this, 11867, new WorldPoint(3019, 3450, 0), "Talk to Boot in the south western Dwarven Mines.", new Requirement[0]);
        this.enterDwarvenMine.addTeleport(this.dwarvenMineTele);
        this.talkToBoot = new NpcStep((QuestHelper)this, 4985, new WorldPoint(2984, 9810, 0), "Talk to Boot in the south western Dwarven Mines.", new Requirement[0]);
        this.talkToBoot.addDialogStep("Hello. I'm in search of very high quality gold.");
        this.talkToBoot.addSubSteps(this.enterDwarvenMine);
        this.enterWitchavenDungeon = new ObjectStep((QuestHelper)this, 18270, new WorldPoint(2696, 3283, 0), "Enter the old ruin entrance west of Witchaven.", new Requirement[0]);
        this.enterWitchavenDungeon.addTeleport(this.ardyTele);
        this.pullNorthLever = new ObjectStep((QuestHelper)this, 2421, new WorldPoint(2722, 9710, 0), "Follow the path around, and pull the lever on the wall in the north east corner.", new Requirement[0]);
        this.pullSouthRoomLever = new ObjectStep((QuestHelper)this, 2423, new WorldPoint(2724, 9669, 0), "Pull the lever in the south room up.", new Requirement[0]);
        this.pullNorthLeverAgain = new ObjectStep((QuestHelper)this, 2422, new WorldPoint(2722, 9710, 0), "Pull the north wall lever again.", new Requirement[0]);
        this.pullNorthRoomLever = new ObjectStep((QuestHelper)this, 2425, new WorldPoint(2722, 9718, 0), "Pull the lever in the north room up.", new Requirement[0]);
        this.pullNorthLever3 = new ObjectStep((QuestHelper)this, 2421, new WorldPoint(2722, 9710, 0), "Pull the north wall lever again.", new Requirement[0]);
        this.pullSouthRoomLever2 = new ObjectStep((QuestHelper)this, 2424, new WorldPoint(2724, 9669, 0), "Pull the lever in the south room down.", new Requirement[0]);
        this.followPathAroundEast = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2721, 9700, 0), "Follow the dungeon around to the east.", new Requirement[0]);
        this.mineGold = new ObjectStep((QuestHelper)this, 11371, new WorldPoint(2732, 9680, 0), "Mine 2 perfect gold in the east room.", true, this.pickaxe, this.gold2);
        ((ObjectStep)this.mineGold).setMaxObjectDistance(5000);
        this.smeltGold = new ObjectStep((QuestHelper)this, 24009, new WorldPoint(3273, 3186, 0), "Smelt the perfect gold ore into bars.", this.gold2.highlighted());
        this.smeltGold.addIcon(444);
        this.smeltGold.addTeleport(this.alkharidTele.quantity(1));
        this.makeNecklace = new ObjectStep((QuestHelper)this, 24009, "Make a perfect ruby necklace at a furnace. Make sure to only craft one.", this.goldBar, this.ruby, this.necklaceMould);
        this.makeRing = new ObjectStep((QuestHelper)this, 24009, "Make a perfect ruby ring at a furnace. Make sure to only craft one.", this.goldBar, this.ruby, this.ringMould);
        this.returnToMan = new NpcStep((QuestHelper)this, 386, new WorldPoint(3295, 3275, 0), "Return to the man south of the Al Kharid mine.", this.perfectRing, this.perfectNecklace);
        this.goUpToJohnathon = new ObjectStep((QuestHelper)this, 11797, new WorldPoint(3286, 3494, 0), "Go upstairs in the Jolly Boar Inn north east of Varrock and talk to Johnathon.", this.antipoison);
        this.goUpToJohnathon.addTeleport(this.varrockTele.quantity(1));
        this.talkToJohnathon = new NpcStep((QuestHelper)this, 5443, new WorldPoint(3277, 3504, 1), "Talk to Johnathon.", this.antipoison);
        this.giveJohnathonAntipoison = new NpcStep((QuestHelper)this, 5443, new WorldPoint(3277, 3504, 1), "Give Johnathon some antipoison.", this.antipoison.highlighted());
        this.giveJohnathonAntipoison.addIcon(175);
        this.goUpToJohnathon.addSubSteps(this.talkToJohnathon);
        this.goDownToChronizon = new ObjectStep((QuestHelper)this, 1581, new WorldPoint(3097, 3468, 0), "Enter the Edgeville Wilderness Dungeon, ready to kill Chronozon. Other players will be able to attack you.", this.runesForBlasts);
        this.goDownToChronizon.addAlternateObjects(1579);
        this.killChronizon = new NpcStep((QuestHelper)this, 4987, new WorldPoint(3087, 9936, 0), "Kill Chronozon in the south west corner of the Edgeville Wilderness Dungeon. You need to hit him at least once with all 4 elemental blast spell.", this.runesForBlasts);
        this.killChronizon.addSubSteps(this.goDownToChronizon);
        this.pickUpCrest3 = new ItemStep((QuestHelper)this, "Pick up the crest part.", this.crestPiece3);
        this.killChronizon.addSubSteps(this.pickUpCrest3);
        this.repairCrest = new DetailedQuestStep((QuestHelper)this, "Combine the 3 crest parts together.", this.crestPiece1.highlighted(), this.crestPiece2.highlighted(), this.crestPiece3.highlighted());
        this.returnCrest = new NpcStep((QuestHelper)this, 4984, new WorldPoint(3280, 3402, 0), "Return the family crest to Dimintheis in south east Varrock.", this.crest);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.shrimp);
        reqs.add(this.salmon);
        reqs.add(this.tuna);
        reqs.add(this.bass);
        reqs.add(this.swordfish);
        reqs.add(this.pickaxe);
        reqs.add(this.ruby2);
        reqs.add(this.ringMould);
        reqs.add(this.necklaceMould);
        reqs.add(this.antipoison);
        reqs.add(this.runesForBlasts);
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.varrockTele, this.catherbyTele, this.faladorTele, this.ardyTele, this.alkharidTele, this.dwarvenMineTele);
    }

    @Override
    public List<String> getNotes() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("The final boss of this quest is in the Edgeville WILDERNESS dungeon, where other players can kill you. Make sure when you go there you aren't risking anything you'd not be willing to lose.");
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("Chronozon (level 170, in the Wilderness)");
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("A pair of Steel Gauntlets", 778, 1));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Collections.singletonList(this.talkToDimintheis), new Requirement[0]));
        allSteps.add(new PanelDetails("Caleb's piece", Arrays.asList(this.talkToCaleb, this.talkToCalebWithFish, this.talkToCalebOnceMore), this.shrimp, this.salmon, this.tuna, this.bass, this.swordfish));
        allSteps.add(new PanelDetails("Avan's piece", Arrays.asList(this.talkToGemTrader, this.talkToMan, this.talkToBoot, this.enterWitchavenDungeon, this.pullNorthLever, this.pullSouthRoomLever, this.pullNorthLeverAgain, this.pullNorthRoomLever, this.pullNorthLever3, this.pullSouthRoomLever2, this.mineGold, this.smeltGold, this.makeNecklace, this.makeRing, this.returnToMan), this.pickaxe, this.ruby2, this.necklaceMould, this.ringMould));
        allSteps.add(new PanelDetails("Johnathon's piece", Arrays.asList(this.goUpToJohnathon, this.giveJohnathonAntipoison, this.killChronizon), this.runesForBlasts, this.antipoison));
        allSteps.add(new PanelDetails("Return the crest", Arrays.asList(this.repairCrest, this.returnCrest), new Requirement[0]));
        return allSteps;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new SkillRequirement(Skill.MINING, 40, true));
        req.add(new SkillRequirement(Skill.SMITHING, 40, true));
        req.add(new SkillRequirement(Skill.MAGIC, 59, true));
        req.add(new SkillRequirement(Skill.CRAFTING, 40, true));
        return req;
    }
}

