/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.fairytaleii;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.questinfo.QuestVarbits;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.FAIRYTALE_II__CURE_A_QUEEN)
public class FairytaleII
extends BasicQuestHelper {
    ItemRequirement dramenOrLunarStaff;
    ItemRequirement vialOfWater;
    ItemRequirement pestleAndMortar;
    ItemRequirement combatGear;
    ItemRequirement food;
    ItemRequirement fairyCertificate;
    ItemRequirement queensSecateurs;
    ItemRequirement starFlower;
    ItemRequirement gorakClaw;
    ItemRequirement gorakClawPowder;
    ItemRequirement magicEssenceUnf;
    ItemRequirement magicEssence;
    Zone zanaris;
    Zone hideout;
    Zone starPlane;
    Zone gorakPlane;
    Requirement inZanaris;
    Requirement inHideout;
    Requirement inStarPlane;
    Requirement inGorakPlane;
    Requirement hasReadSign;
    Requirement hasInvestigatedCertificate;
    Requirement talkedToGodfather;
    Requirement pickedStarFlower;
    Requirement starflowerNearby;
    Requirement clawNearby;
    Requirement herbReq;
    Requirement farmReq;
    Requirement thievingReq;
    Requirement addedFlowerCorrectly;
    Requirement addedClawCorrectly;
    Requirement starflowerOrUnfCorrectlyMade;
    QuestStep talkToMartin;
    QuestStep waitForMartin;
    QuestStep talkToMartinAgain;
    QuestStep enterZanaris;
    QuestStep takeCertificate;
    QuestStep studyCertificate;
    QuestStep readSign;
    QuestStep talkToGodfather;
    QuestStep goToHideout;
    QuestStep goToHideoutSurface;
    QuestStep talkToNuff;
    QuestStep returnToZanarisFromBase;
    QuestStep goToZanarisToPickpocket;
    QuestStep pickpocketGodfather;
    QuestStep goToHideoutWithSec;
    QuestStep goToHideoutSurfaceWithSec;
    QuestStep giveSecateursToNuff;
    QuestStep goToHideoutAfterSec;
    QuestStep goToHideoutSurfaceAfterSec;
    QuestStep talkToNuffAfterSec;
    QuestStep goToCkp;
    QuestStep waitForStarFlower;
    QuestStep pickStarFlower;
    QuestStep goToDir;
    QuestStep killGorak;
    QuestStep pickupGorakClaw;
    QuestStep goToHideout2;
    QuestStep useStarFlowerOnVial;
    QuestStep usePestleOnClaw;
    QuestStep usePowderOnPotion;
    QuestStep usePotionOnQueen;
    QuestStep goToHideoutToFinish;
    QuestStep talkToQueen;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToMartin);
        steps.put(5, this.waitForMartin);
        steps.put(10, this.talkToMartinAgain);
        ConditionalStep goInvestigate = new ConditionalStep((QuestHelper)this, this.enterZanaris, new Requirement[0]);
        goInvestigate.addStep(new Conditions(this.inHideout), this.talkToNuff);
        goInvestigate.addStep(new Conditions(this.inZanaris, this.hasInvestigatedCertificate, this.hasReadSign, this.talkedToGodfather), this.goToHideout);
        goInvestigate.addStep(new Conditions(this.hasInvestigatedCertificate, this.hasReadSign, this.talkedToGodfather), this.goToHideoutSurface);
        goInvestigate.addStep(new Conditions(this.inZanaris, this.hasInvestigatedCertificate, this.hasReadSign), this.talkToGodfather);
        goInvestigate.addStep(new Conditions(this.inZanaris, this.hasInvestigatedCertificate), this.readSign);
        goInvestigate.addStep(new Conditions(this.inZanaris, this.fairyCertificate.alsoCheckBank(this.questBank)), this.studyCertificate);
        goInvestigate.addStep(this.inZanaris, this.takeCertificate);
        steps.put(20, goInvestigate);
        steps.put(30, goInvestigate);
        steps.put(40, goInvestigate);
        steps.put(45, goInvestigate);
        ConditionalStep goGetSecateurs = new ConditionalStep((QuestHelper)this, this.goToZanarisToPickpocket, new Requirement[0]);
        goGetSecateurs.addStep(new Conditions(this.inHideout, this.queensSecateurs.alsoCheckBank(this.questBank)), this.giveSecateursToNuff);
        goGetSecateurs.addStep(new Conditions(this.inZanaris, this.queensSecateurs.alsoCheckBank(this.questBank)), this.goToHideoutWithSec);
        goGetSecateurs.addStep(this.queensSecateurs.alsoCheckBank(this.questBank), this.goToHideoutSurfaceWithSec);
        goGetSecateurs.addStep(this.inHideout, this.returnToZanarisFromBase);
        goGetSecateurs.addStep(this.inZanaris, this.pickpocketGodfather);
        steps.put(50, goGetSecateurs);
        steps.put(60, goGetSecateurs);
        ConditionalStep goTalkNuffAfterSec = new ConditionalStep((QuestHelper)this, this.goToHideoutSurfaceAfterSec, new Requirement[0]);
        goTalkNuffAfterSec.addStep(this.inHideout, this.talkToNuffAfterSec);
        goTalkNuffAfterSec.addStep(this.inZanaris, this.goToHideoutAfterSec);
        steps.put(65, goTalkNuffAfterSec);
        ConditionalStep goMakePotion = new ConditionalStep((QuestHelper)this, this.goToCkp, new Requirement[0]);
        goMakePotion.addStep(new Conditions(this.addedClawCorrectly, this.magicEssence.alsoCheckBank(this.questBank), this.inHideout), this.usePotionOnQueen);
        goMakePotion.addStep(new Conditions(this.addedClawCorrectly, this.magicEssence.alsoCheckBank(this.questBank)), this.goToHideout2);
        goMakePotion.addStep(new Conditions(this.addedFlowerCorrectly, this.gorakClawPowder.alsoCheckBank(this.questBank), this.magicEssenceUnf.alsoCheckBank(this.questBank)), this.usePowderOnPotion);
        goMakePotion.addStep(new Conditions(this.addedFlowerCorrectly, this.gorakClaw.alsoCheckBank(this.questBank), this.magicEssenceUnf.alsoCheckBank(this.questBank)), this.usePestleOnClaw);
        goMakePotion.addStep(new Conditions(this.gorakClaw.alsoCheckBank(this.questBank), this.starFlower.alsoCheckBank(this.questBank)), this.useStarFlowerOnVial);
        goMakePotion.addStep(new Conditions(this.clawNearby, this.starflowerOrUnfCorrectlyMade), this.pickupGorakClaw);
        goMakePotion.addStep(new Conditions(this.inGorakPlane, this.starflowerOrUnfCorrectlyMade), this.killGorak);
        goMakePotion.addStep(this.starflowerOrUnfCorrectlyMade, this.goToDir);
        goMakePotion.addStep(this.starflowerNearby, this.pickStarFlower);
        goMakePotion.addStep(this.inStarPlane, this.waitForStarFlower);
        steps.put(70, goMakePotion);
        steps.put(72, goMakePotion);
        steps.put(73, goMakePotion);
        ConditionalStep goFinish = new ConditionalStep((QuestHelper)this, this.goToHideoutToFinish, new Requirement[0]);
        goFinish.addStep(this.inHideout, this.talkToQueen);
        steps.put(75, goFinish);
        steps.put(80, goFinish);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.dramenOrLunarStaff = new ItemRequirement("Dramen or lunar staff", 772).isNotConsumed();
        this.dramenOrLunarStaff.addAlternates(9084);
        this.dramenOrLunarStaff.setDisplayMatchedItemName(true);
        this.vialOfWater = new ItemRequirement("Vial of water", 227);
        this.pestleAndMortar = new ItemRequirement("Pestle and mortar", 233).isNotConsumed();
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.fairyCertificate = new ItemRequirement("Nuff's certificate", 9025);
        this.fairyCertificate.setTooltip("You can get another from Nuff's room in north west Zanaris");
        this.starFlower = new ItemRequirement("Star flower", 9017);
        this.gorakClaw = new ItemRequirement("Gorak claws", 9016);
        this.gorakClawPowder = new ItemRequirement("Gorak claw powder", 9018);
        this.magicEssenceUnf = new ItemRequirement("Magic essence (unf)", 9019);
        this.magicEssence = new ItemRequirement("Magic essence", 9024);
        this.magicEssence.addAlternates(9023, 9022, 9021);
        this.queensSecateurs = new ItemRequirement("Queen's secateurs", 9020);
    }

    public void setupZones() {
        this.zanaris = new Zone(new WorldPoint(2368, 4353, 0), new WorldPoint(2495, 4479, 0));
        this.hideout = new Zone(new WorldPoint(2324, 4420, 0), new WorldPoint(2367, 4468, 0));
        this.starPlane = new Zone(new WorldPoint(2060, 4806, 0), new WorldPoint(2098, 4862, 0));
        this.gorakPlane = new Zone(new WorldPoint(3009, 5312, 0), new WorldPoint(3072, 5380, 0));
    }

    public void setupConditions() {
        this.inZanaris = new ZoneRequirement(this.zanaris);
        this.inHideout = new ZoneRequirement(this.hideout);
        this.inStarPlane = new ZoneRequirement(this.starPlane);
        this.inGorakPlane = new ZoneRequirement(this.gorakPlane);
        this.thievingReq = new SkillRequirement(Skill.THIEVING, 40);
        this.farmReq = new SkillRequirement(Skill.FARMING, 49, true);
        this.herbReq = new SkillRequirement(Skill.HERBLORE, 57, true);
        this.hasReadSign = new VarbitRequirement(2338, 4);
        this.hasInvestigatedCertificate = new VarbitRequirement(2336, 1);
        this.talkedToGodfather = new VarbitRequirement(QuestVarbits.QUEST_FAIRYTALE_II_CURE_A_QUEEN.getId(), 40, Operation.GREATER_EQUAL);
        this.addedFlowerCorrectly = new VarbitRequirement(QuestVarbits.QUEST_FAIRYTALE_II_CURE_A_QUEEN.getId(), 72, Operation.GREATER_EQUAL);
        this.addedClawCorrectly = new VarbitRequirement(QuestVarbits.QUEST_FAIRYTALE_II_CURE_A_QUEEN.getId(), 73, Operation.GREATER_EQUAL);
        this.starflowerNearby = new NpcCondition(1857);
        this.pickedStarFlower = new VarbitRequirement(2330, 1);
        this.clawNearby = new ItemOnTileRequirement(this.gorakClaw);
        this.starflowerOrUnfCorrectlyMade = new Conditions(LogicType.OR, this.starFlower.alsoCheckBank(this.questBank), new Conditions(this.addedFlowerCorrectly, this.magicEssenceUnf.alsoCheckBank(this.questBank)));
    }

    public void setupSteps() {
        this.talkToMartin = new NpcStep((QuestHelper)this, 5832, new WorldPoint(3078, 3256, 0), "Talk to Martin in the Draynor Market.", new Requirement[0]);
        this.talkToMartin.addDialogSteps("Ask about the quest.");
        this.waitForMartin = new DetailedQuestStep((QuestHelper)this, "Wait 5 minutes.", new Requirement[0]);
        this.talkToMartinAgain = new NpcStep((QuestHelper)this, 5832, new WorldPoint(3078, 3256, 0), "Return to Martin in the Draynor Market.", new Requirement[0]);
        this.talkToMartinAgain.addDialogSteps("Ask about the quest.", "I suppose I'd better go and see what the problem is then.");
        this.takeCertificate = new ObjectStep((QuestHelper)this, 16315, new WorldPoint(2389, 4471, 0), "Search the healing certificate in Fairy Nuff's room.", new Requirement[0]);
        this.studyCertificate = new DetailedQuestStep((QuestHelper)this, "Right-click study the certificate.", this.fairyCertificate.highlighted());
        this.readSign = new ObjectStep((QuestHelper)this, 16307, new WorldPoint(2409, 4369, 0), "Read the sign near the Cosmic Temple in the south of Zanaris.", new Requirement[0]);
        this.talkToGodfather = new NpcStep((QuestHelper)this, 5837, new WorldPoint(2447, 4430, 0), "Talk to the Fairy Godfather in the Throne Room.", new Requirement[0]);
        this.talkToGodfather.addDialogSteps("Where is the Fairy Queen?", "Where could she have been taken to?", "Yes, okay.");
        this.enterZanaris = new ObjectStep((QuestHelper)this, 2406, new WorldPoint(3202, 3169, 0), "Travel to Zanaris.", this.dramenOrLunarStaff.equipped());
        this.goToHideout = new ObjectStep((QuestHelper)this, 29560, new WorldPoint(2412, 4434, 0), "Use the Fairy Rings to travel to A.I.R., D.L.R., D.J.Q. then A.J.S.", this.dramenOrLunarStaff.equipped(), this.fairyCertificate);
        this.goToHideoutSurface = new ObjectStep((QuestHelper)this, 29495, "Use the Fairy Rings to travel to A.I.R., D.L.R., D.J.Q. then A.J.S.", this.dramenOrLunarStaff.equipped(), this.fairyCertificate);
        this.goToHideout.addSubSteps(this.goToHideoutSurface);
        this.talkToNuff = new NpcStep((QuestHelper)this, 1841, new WorldPoint(2355, 4455, 0), "Talk to Fairy Nuff.", new Requirement[0]);
        this.returnToZanarisFromBase = new ObjectStep((QuestHelper)this, 29495, new WorldPoint(2328, 4426, 0), "Pickpocket the Fairy Godfather in the Zanaris Throne Room.", this.dramenOrLunarStaff.equipped());
        this.goToZanarisToPickpocket = new ObjectStep((QuestHelper)this, 2406, new WorldPoint(3202, 3169, 0), "Pickpocket the Fairy Godfather in the Zanaris Throne Room.", this.dramenOrLunarStaff.equipped());
        this.pickpocketGodfather = new NpcStep((QuestHelper)this, 1840, new WorldPoint(2447, 4430, 0), "Pickpocket the Fairy Godfather in the Zanaris Throne Room.", this.thievingReq);
        this.pickpocketGodfather.addSubSteps(this.returnToZanarisFromBase, this.goToZanarisToPickpocket);
        this.goToHideoutWithSec = new ObjectStep((QuestHelper)this, 29560, new WorldPoint(2412, 4434, 0), "Use the Fairy Rings to travel to A.I.R., D.L.R., D.J.Q. then A.J.S.", this.dramenOrLunarStaff.equipped(), this.fairyCertificate, this.queensSecateurs);
        this.goToHideoutSurfaceWithSec = new ObjectStep((QuestHelper)this, 29495, "Use the Fairy Rings to travel to A.I.R., D.L.R., D.J.Q. then A.J.S.", this.dramenOrLunarStaff.equipped(), this.fairyCertificate, this.queensSecateurs);
        this.giveSecateursToNuff = new NpcStep((QuestHelper)this, 1841, new WorldPoint(2355, 4455, 0), "Give Fairy Nuff the Queen's Secateurs.", this.queensSecateurs);
        this.goToHideoutAfterSec = new ObjectStep((QuestHelper)this, 29560, new WorldPoint(2412, 4434, 0), "Use the Fairy Rings to travel to A.I.R., D.L.R., D.J.Q. then A.J.S.", this.dramenOrLunarStaff.equipped(), this.fairyCertificate);
        this.goToHideoutSurfaceAfterSec = new ObjectStep((QuestHelper)this, 29495, "Use the Fairy Rings to travel to A.I.R., D.L.R., D.J.Q. then A.J.S.", this.dramenOrLunarStaff.equipped(), this.fairyCertificate);
        this.talkToNuffAfterSec = new NpcStep((QuestHelper)this, 1841, new WorldPoint(2355, 4455, 0), "Talk to Fairy Nuff.", new Requirement[0]);
        this.giveSecateursToNuff.addSubSteps(this.goToHideoutWithSec, this.goToHideoutSurfaceWithSec, this.goToHideoutAfterSec, this.goToHideoutSurfaceAfterSec, this.talkToNuffAfterSec);
        this.goToCkp = new ObjectStep((QuestHelper)this, 29560, "Travel to C.K.P with a Fairy Ring. Even if you've already made a magic essence (unf), you'll need to make another.", this.dramenOrLunarStaff.equipped());
        ((ObjectStep)this.goToCkp).addAlternateObjects(29495);
        this.waitForStarFlower = new DetailedQuestStep((QuestHelper)this, "Wait for a star flower to appear.", new Requirement[0]);
        this.pickStarFlower = new NpcStep((QuestHelper)this, 1857, new WorldPoint(2070, 4841, 0), "Pick a star flower.", true, this.farmReq);
        this.goToDir = new ObjectStep((QuestHelper)this, 29560, "Travel to D.I.R. with a Fairy Ring, ready to kill a Gorak. Goraks can hit through protection prayers.", this.dramenOrLunarStaff.equipped(), this.combatGear);
        ((ObjectStep)this.goToDir).addAlternateObjects(29495);
        this.killGorak = new NpcStep((QuestHelper)this, 1834, "Kill Goraks for their claws.", true, new Requirement[0]);
        this.pickupGorakClaw = new ItemStep((QuestHelper)this, "Pickup the gorak's claws.", this.gorakClaw);
        this.useStarFlowerOnVial = new DetailedQuestStep((QuestHelper)this, "Add the star flower to a vial of water.", this.starFlower.highlighted(), this.vialOfWater.highlighted(), this.herbReq);
        this.usePestleOnClaw = new DetailedQuestStep((QuestHelper)this, "Use a pestle and mortar on the gorak claws.", this.pestleAndMortar.highlighted(), this.gorakClaw.highlighted());
        this.usePowderOnPotion = new DetailedQuestStep((QuestHelper)this, "Add the gorak claw powder on the unfinished potion.", this.gorakClawPowder.highlighted(), this.magicEssenceUnf.highlighted(), this.herbReq);
        this.goToHideout2 = new ObjectStep((QuestHelper)this, 29495, "Use the Fairy Rings to travel to A.I.R., D.L.R., D.J.Q. then A.J.S.", this.dramenOrLunarStaff.equipped(), this.fairyCertificate, this.magicEssence);
        ((ObjectStep)this.goToHideout2).addAlternateObjects(29560);
        this.usePotionOnQueen = new ObjectStep((QuestHelper)this, 16316, new WorldPoint(2352, 4457, 0), "Use the magic essence on the fairy queen.", this.magicEssence.highlighted());
        this.usePotionOnQueen.addIcon(9022);
        this.goToHideoutToFinish = new ObjectStep((QuestHelper)this, 29495, "Use the Fairy Rings to travel to A.I.R., D.L.R., D.J.Q. then A.J.S.", this.dramenOrLunarStaff.equipped(), this.fairyCertificate);
        ((ObjectStep)this.goToHideoutToFinish).addAlternateObjects(29560);
        this.talkToQueen = new NpcStep((QuestHelper)this, 1842, new WorldPoint(2354, 4455, 0), "Talk to the Fairy Queen.", new Requirement[0]);
        this.talkToQueen.addSubSteps(this.goToHideoutToFinish);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.dramenOrLunarStaff, this.vialOfWater, this.pestleAndMortar);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Collections.singletonList(this.combatGear);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new QuestRequirement(QuestHelperQuest.FAIRYTALE_I__GROWING_PAINS, QuestState.FINISHED));
        reqs.add(this.thievingReq);
        reqs.add(this.farmReq);
        reqs.add(this.herbReq);
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("At least 1 Gorak (level 145)");
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.HERBLORE, 3500), new ExperienceReward(Skill.THIEVING, 2500));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("2,500 Experience Lamps (Any skill over level 30.)", 4447, 2));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Access to Fairy Rings."), new UnlockReward("Access to Fairy Fixit's Fairy Enhancement Store."));
    }

    public ArrayList<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.talkToMartin, this.waitForMartin, this.talkToMartinAgain), new Requirement[0]));
        allSteps.add(new PanelDetails("Betrayal", Arrays.asList(this.enterZanaris, this.takeCertificate, this.studyCertificate, this.readSign, this.talkToGodfather, this.goToHideout, this.talkToNuff, this.pickpocketGodfather, this.giveSecateursToNuff), this.dramenOrLunarStaff, this.vialOfWater, this.pestleAndMortar));
        allSteps.add(new PanelDetails("Making a cure", Arrays.asList(this.goToCkp, this.waitForStarFlower, this.pickStarFlower, this.goToDir, this.killGorak, this.pickupGorakClaw, this.useStarFlowerOnVial, this.usePestleOnClaw, this.usePowderOnPotion, this.goToHideout2, this.usePotionOnQueen, this.talkToQueen), this.dramenOrLunarStaff, this.vialOfWater, this.pestleAndMortar));
        return allSteps;
    }
}

