/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.fairytalei;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.npc.DialogRequirement;
import com.questhelper.requirements.player.InInstanceRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.widget.WidgetTextRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DigStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.FAIRYTALE_I__GROWING_PAINS)
public class FairytaleI
extends BasicQuestHelper {
    ItemRequirement secateurs;
    ItemRequirement draynorSkull;
    ItemRequirement spade;
    ItemRequirement ghostspeak;
    ItemRequirement dramenOrLunarStaff;
    ItemRequirement randomItems;
    ItemRequirement varrockTeleport;
    ItemRequirement faladorTeleport;
    ItemRequirement lumbridgeTeleport;
    ItemRequirement moryTele;
    ItemRequirement food;
    ItemRequirement symptomsList;
    ItemRequirement magicSecateurs;
    ItemRequirement magicSecateursEquipped;
    ItemRequirement queensSecateurs;
    ItemRequirement items3;
    ItemRequirement skullOrSpade;
    Zone zanaris;
    Zone towerF1;
    Zone towerF2;
    Zone grotto;
    Zone tanglefootRoom;
    Requirement inZanaris;
    Requirement inTowerF1;
    Requirement inTowerF2;
    Requirement inGrotto;
    Requirement inTanglefootRoom;
    Requirement talkedToFarmers;
    Requirement secateursNearby;
    QuestStep talkToMartin;
    QuestStep talkToFarmers;
    QuestStep talkToMartinAgain;
    QuestStep enterZanaris;
    QuestStep talkToGodfather;
    QuestStep talkToNuff;
    QuestStep climbTowerF0ToF1;
    QuestStep climbTowerF1ToF2;
    QuestStep talkToZandar;
    QuestStep talkToMortifer;
    QuestStep getSkull;
    QuestStep giveMortiferItems;
    QuestStep enterGrotto;
    QuestStep talkToSpirit;
    QuestStep enterZanarisForFight;
    QuestStep enterTanglefootRoom;
    QuestStep killTanglefoot;
    QuestStep pickUpSecateurs;
    QuestStep enterZanarisForEnd;
    QuestStep talkToGodfatherToFinish;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToMartin);
        ConditionalStep goTalkToFarmers = new ConditionalStep((QuestHelper)this, this.talkToFarmers, new Requirement[0]);
        goTalkToFarmers.addStep(this.talkedToFarmers, this.talkToMartinAgain);
        steps.put(10, goTalkToFarmers);
        ConditionalStep goTalkToGodfather = new ConditionalStep((QuestHelper)this, this.enterZanaris, new Requirement[0]);
        goTalkToGodfather.addStep(this.inZanaris, this.talkToGodfather);
        steps.put(20, goTalkToGodfather);
        ConditionalStep goTalkToNuff = new ConditionalStep((QuestHelper)this, this.enterZanaris, new Requirement[0]);
        goTalkToNuff.addStep(this.inZanaris, this.talkToNuff);
        steps.put(30, goTalkToNuff);
        ConditionalStep goTalkToZandar = new ConditionalStep((QuestHelper)this, this.climbTowerF0ToF1, new Requirement[0]);
        goTalkToZandar.addStep(this.inTowerF2, this.talkToZandar);
        goTalkToZandar.addStep(this.inTowerF1, this.climbTowerF1ToF2);
        steps.put(40, goTalkToZandar);
        ConditionalStep goTalkToMortifer = new ConditionalStep((QuestHelper)this, this.getSkull, new Requirement[0]);
        goTalkToMortifer.addStep(this.draynorSkull, this.talkToMortifer);
        steps.put(50, goTalkToMortifer);
        ConditionalStep goEnchantSecateurs = new ConditionalStep((QuestHelper)this, this.enterGrotto, new Requirement[0]);
        goEnchantSecateurs.addStep(this.inGrotto, this.talkToSpirit);
        steps.put(60, goEnchantSecateurs);
        ConditionalStep goKillTanglefoot = new ConditionalStep((QuestHelper)this, this.enterZanarisForFight, new Requirement[0]);
        goKillTanglefoot.addStep(this.secateursNearby, this.pickUpSecateurs);
        goKillTanglefoot.addStep(this.inTanglefootRoom, this.killTanglefoot);
        goKillTanglefoot.addStep(this.inZanaris, this.enterTanglefootRoom);
        steps.put(70, goKillTanglefoot);
        ConditionalStep finishQuest = new ConditionalStep((QuestHelper)this, this.enterZanarisForEnd, new Requirement[0]);
        finishQuest.addStep(this.inZanaris, this.talkToGodfatherToFinish);
        steps.put(80, finishQuest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.secateurs = new ItemRequirement("Secateurs", 5329);
        this.draynorSkull = new ItemRequirement("Draynor skull", 7408);
        this.draynorSkull.canBeObtainedDuringQuest();
        this.skullOrSpade = new ItemRequirement("Draynor skull or a spade to get it", 7408);
        this.skullOrSpade.addAlternates(952);
        this.spade = new ItemRequirement("Spade", 952).isNotConsumed();
        this.ghostspeak = new ItemRequirement("Ghostspeak amulet", ItemCollections.GHOSTSPEAK, 1, true).isNotConsumed();
        this.ghostspeak.setTooltip("You can get another from Father Urhney in the Lumbridge Swamp");
        this.dramenOrLunarStaff = new ItemRequirement("Dramen or lunar staff", 772, 1, true).isNotConsumed();
        this.dramenOrLunarStaff.addAlternates(9084);
        this.dramenOrLunarStaff.setDisplayMatchedItemName(true);
        this.randomItems = new ItemRequirement("3 random items requested by Malignius", -1);
        this.varrockTeleport = new ItemRequirement("Varrock teleport", 8007);
        this.faladorTeleport = new ItemRequirement("Falador teleport", 8009);
        this.lumbridgeTeleport = new ItemRequirement("Lumbridge teleport", 8008);
        this.moryTele = new ItemRequirement("Teleport to Morytania", 12406);
        this.moryTele.addAlternates(19629, 4251);
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.symptomsList = new ItemRequirement("Symptoms list", 7411);
        this.symptomsList.setTooltip("You can get another from Fairy Nuff");
        this.magicSecateurs = new ItemRequirement("Magic secateurs", 7409);
        this.magicSecateurs.setTooltip("If you lost these you'll need to have the Nature Spirit enchant another secateur");
        this.magicSecateursEquipped = new ItemRequirement("Magic secateurs", 7409, 1, true);
        this.magicSecateursEquipped.setTooltip("If you lost these you'll need to have the Nature Spirit enchant another secateur");
        this.queensSecateurs = new ItemRequirement("Queen's secateurs", 7410);
        this.queensSecateurs.setTooltip("You can get another by killing another Tanglefoot");
        this.items3 = new ItemRequirement("3 items Mortifer told you to get", -1, -1);
    }

    public void setupZones() {
        this.zanaris = new Zone(new WorldPoint(2368, 4353, 0), new WorldPoint(2495, 4479, 0));
        this.towerF1 = new Zone(new WorldPoint(2900, 3324, 1), new WorldPoint(2914, 3341, 1));
        this.towerF2 = new Zone(new WorldPoint(2900, 3324, 2), new WorldPoint(2914, 3341, 2));
        this.grotto = new Zone(new WorldPoint(3435, 9733, 1), new WorldPoint(3448, 9746, 1));
        this.tanglefootRoom = new Zone(new WorldPoint(2368, 4353, 0), new WorldPoint(2402, 4399, 0));
    }

    public void setupConditions() {
        this.inZanaris = new ZoneRequirement(this.zanaris);
        this.inTowerF1 = new ZoneRequirement(this.towerF1);
        this.inTowerF2 = new ZoneRequirement(this.towerF2);
        this.inGrotto = new ZoneRequirement(this.grotto);
        this.inTanglefootRoom = new Conditions(new InInstanceRequirement(), new ZoneRequirement(this.tanglefootRoom));
        this.talkedToFarmers = new Conditions(true, LogicType.OR, new WidgetTextRequirement(119, 3, true, "back and talk to <col=800000>Martin"), new DialogRequirement("Right, well thanks for your input."), new DialogRequirement("I don't think the crops ARE failing"));
        this.secateursNearby = new ItemOnTileRequirement(this.queensSecateurs);
    }

    public void setupSteps() {
        this.talkToMartin = new NpcStep((QuestHelper)this, 5832, new WorldPoint(3078, 3256, 0), "Talk to Martin in the Draynor Market.", new Requirement[0]);
        this.talkToMartin.addDialogSteps("Ask about the quest.", "Anything I can help with?", "Now that I think about it, you're right!");
        this.talkToFarmers = new NpcStep((QuestHelper)this, 2663, "Talk to 5 farmers, then return to Martin in Draynor Village. The recommended 5 are: Frizzy in Port Sarim.", new Requirement[0]);
        this.talkToFarmers.addText("Elstan north west of Draynor.");
        this.talkToFarmers.addText("Heskel in Falador Park.");
        this.talkToFarmers.addText("Treznor south of Varrock Castle.");
        this.talkToFarmers.addText("Dreven south of Varrock, next to the Champions' Guild.");
        this.talkToFarmers.addDialogStep("Are you a member of the Group of Advanced Gardeners?");
        ((NpcStep)this.talkToFarmers).addAlternateNpcs(2684, 2679, 2674, 2681, 11957);
        this.talkToMartinAgain = new NpcStep((QuestHelper)this, 5832, new WorldPoint(3078, 3256, 0), "Return to Martin in the Draynor Market.", new Requirement[0]);
        this.talkToMartinAgain.addDialogStep("Ask about the quest.");
        this.talkToFarmers.addSubSteps(this.talkToMartinAgain);
        this.enterZanaris = new ObjectStep((QuestHelper)this, 2406, new WorldPoint(3202, 3169, 0), "Travel to Zanaris.", this.dramenOrLunarStaff);
        this.talkToGodfather = new NpcStep((QuestHelper)this, 5837, new WorldPoint(2447, 4430, 0), "Talk to the Fairy Godfather in the Throne Room.", new Requirement[0]);
        this.talkToGodfather.addDialogStep("Where's the Fairy Queen?");
        this.talkToNuff = new NpcStep((QuestHelper)this, 1841, new WorldPoint(2386, 4472, 0), "Talk to Fairy Nuff in north west Zanaris.", new Requirement[0]);
        this.climbTowerF0ToF1 = new ObjectStep((QuestHelper)this, 11888, new WorldPoint(2908, 3335, 0), "Talk to Zandar in the Dark Wizards' Tower west of Falador.", this.symptomsList);
        this.climbTowerF1ToF2 = new ObjectStep((QuestHelper)this, 11889, new WorldPoint(2908, 3335, 1), "Talk to Zandar in the Dark Wizards' Tower west of Falador.", this.symptomsList);
        this.climbTowerF1ToF2.addDialogStep("Climb up");
        this.talkToZandar = new NpcStep((QuestHelper)this, 5841, new WorldPoint(2907, 3335, 2), "Talk to Zandar in the Dark Wizards' Tower west of Falador.", this.symptomsList);
        this.talkToZandar.addSubSteps(this.climbTowerF1ToF2, this.climbTowerF0ToF1);
        this.talkToMortifer = new NpcStep((QuestHelper)this, 1783, new WorldPoint(2991, 3270, 0), "Talk to Malignius Mortifer west of Port Sarim.", this.draynorSkull);
        this.talkToMortifer.addDialogSteps("I need help with fighting a Tanglefoot.", "I was asking you about fighting a Tanglefoot...");
        this.getSkull = new DigStep((QuestHelper)this, new WorldPoint(3106, 3383, 0), "Dig for a skull in the north of Draynor Manor.", new Requirement[0]);
        this.giveMortiferItems = new NpcStep((QuestHelper)this, 1783, new WorldPoint(2991, 3270, 0), "Give Malignius Mortifer the items he wanted.", new Requirement[0]);
        this.enterGrotto = new ObjectStep((QuestHelper)this, 3516, new WorldPoint(3440, 3337, 0), "Get the items Mortifer tells you to get, and enter the Grotto in the south of Mort Myre.", this.ghostspeak, this.secateurs, this.items3);
        this.talkToSpirit = new NpcStep((QuestHelper)this, 944, new WorldPoint(3441, 9738, 1), "Talk to the Nature Spirit.", this.ghostspeak, this.secateurs, this.items3);
        this.enterZanarisForFight = new ObjectStep((QuestHelper)this, 2406, new WorldPoint(3202, 3169, 0), "Travel to Zanaris, ready to fight the Tanglefoot.", this.dramenOrLunarStaff, this.magicSecateurs);
        this.enterTanglefootRoom = new ObjectStep((QuestHelper)this, 11999, new WorldPoint(2399, 4379, 0), "Enter the tanglefoot lair in the south of Zanaris, near the cosmic altar.", this.magicSecateursEquipped, this.food);
        this.killTanglefoot = new NpcStep((QuestHelper)this, 5848, new WorldPoint(2375, 4385, 0), "Kill the large Tanglefoot with the Magic Secateurs. You can flinch it on a corner.", this.magicSecateursEquipped);
        this.pickUpSecateurs = new ItemStep((QuestHelper)this, "Pick up the queen's secateurs.", this.queensSecateurs);
        this.enterZanarisForEnd = new ObjectStep((QuestHelper)this, 2406, new WorldPoint(3202, 3169, 0), "Talk to the Fairy Godfather in Zanaris to finish the quest.", this.dramenOrLunarStaff, this.queensSecateurs);
        this.talkToGodfatherToFinish = new NpcStep((QuestHelper)this, 5837, new WorldPoint(2447, 4430, 0), "Talk to the Fairy Godfather to finish the quest.", this.queensSecateurs);
        this.talkToGodfatherToFinish.addSubSteps(this.enterZanarisForEnd);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.secateurs, this.spade, this.ghostspeak, this.dramenOrLunarStaff, this.draynorSkull);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.varrockTeleport, this.faladorTeleport, this.lumbridgeTeleport, this.moryTele, this.food);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new QuestRequirement(QuestHelperQuest.LOST_CITY, QuestState.FINISHED));
        reqs.add(new QuestRequirement(QuestHelperQuest.NATURE_SPIRIT, QuestState.FINISHED));
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Tanglefoot (level 111)");
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.FARMING, 3500), new ExperienceReward(Skill.ATTACK, 2000), new ExperienceReward(Skill.MAGIC, 1000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Magic Secateurs", 7409, 1));
    }

    public ArrayList<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Investigating", Arrays.asList(this.talkToMartin, this.talkToFarmers, this.talkToMartinAgain), new Requirement[0]));
        allSteps.add(new PanelDetails("Unnatural events", Arrays.asList(this.enterZanaris, this.talkToGodfather, this.talkToNuff, this.talkToZandar), this.dramenOrLunarStaff));
        allSteps.add(new PanelDetails("Finding a cure", Arrays.asList(this.getSkull, this.talkToMortifer), this.skullOrSpade));
        allSteps.add(new PanelDetails("Enchanting secateurs", Arrays.asList(this.enterGrotto, this.talkToSpirit), this.ghostspeak, this.secateurs, this.items3));
        allSteps.add(new PanelDetails("Defeat the Tanglefoot", Arrays.asList(this.enterZanarisForFight, this.enterTanglefootRoom, this.killTanglefoot, this.talkToGodfatherToFinish), this.dramenOrLunarStaff, this.magicSecateurs, this.food));
        return allSteps;
    }
}

