/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.ernestthechicken;

import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.ChatMessageRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.ERNEST_THE_CHICKEN)
public class ErnestTheChicken
extends BasicQuestHelper {
    ItemRequirement spade;
    ItemRequirement fishFood;
    ItemRequirement poison;
    ItemRequirement poisonedFishFood;
    ItemRequirement pressureGauge;
    ItemRequirement oilCan;
    ItemRequirement rubberTube;
    ItemRequirement key;
    Requirement inFirstFloor;
    Requirement inGroundFloor;
    Requirement inSecondFloor;
    Requirement killedFish;
    Requirement inSecretRoom;
    Requirement isLeverADown;
    Requirement isLeverBDown;
    Requirement isLeverCDown;
    Requirement isLeverDDown;
    Requirement isLeverEDown;
    Requirement isLeverFDown;
    Requirement isLeverAUp;
    Requirement isLeverBUp;
    Requirement isLeverCUp;
    Requirement isLeverDUp;
    Requirement isLeverEUp;
    Requirement isLeverFUp;
    Requirement inBasement;
    Requirement inRoomCD;
    Requirement inEmptyRoom;
    QuestStep talkToVeronica;
    QuestStep enterManor;
    QuestStep goToFirstFloor;
    QuestStep pickupPoison;
    QuestStep goToSecondFloor;
    QuestStep pickupFishFood;
    QuestStep usePoisonOnFishFood;
    QuestStep goDownToGroundFloor;
    QuestStep pickupSpade;
    QuestStep searchCompost;
    QuestStep useFishFoodOnFountain;
    QuestStep searchFountain;
    QuestStep enterManorWithKey;
    QuestStep getTube;
    QuestStep searchBookcase;
    QuestStep goDownLadder;
    QuestStep pullDownLeverA;
    QuestStep pullDownLeverB;
    QuestStep pullDownLeverC;
    QuestStep pullDownLeverD;
    QuestStep pullDownLeverE;
    QuestStep pullDownLeverF;
    QuestStep pullUpLeverA;
    QuestStep pullUpLeverB;
    QuestStep pullUpLeverC;
    QuestStep pullUpLeverD;
    QuestStep pullUpLeverE;
    QuestStep pickupOilCan;
    QuestStep goUpFromBasement;
    QuestStep pullLeverToLeave;
    QuestStep goToFirstFloorToFinish;
    QuestStep talkToOddenstein;
    QuestStep talkToOddenteinAgain;
    ConditionalStep getGaugeAndTube;
    ConditionalStep getCan;
    Zone manorGround1;
    Zone secretRoom;
    Zone manorGround3;
    Zone firstFloor;
    Zone secondFloor;
    Zone basement;
    Zone roomCD;
    Zone emptyRoom;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToVeronica);
        this.getGaugeAndTube = new ConditionalStep((QuestHelper)this, this.enterManor, new Requirement[0]);
        this.getGaugeAndTube.addStep(new Conditions(this.key, this.pressureGauge, this.inGroundFloor), this.getTube);
        this.getGaugeAndTube.addStep(new Conditions(this.key, this.pressureGauge), this.enterManorWithKey);
        this.getGaugeAndTube.addStep(new Conditions(this.killedFish, this.key), this.searchFountain);
        this.getGaugeAndTube.addStep(new Conditions(this.poisonedFishFood, this.key), this.useFishFoodOnFountain);
        this.getGaugeAndTube.addStep(new Conditions(this.poisonedFishFood, this.spade), this.searchCompost);
        this.getGaugeAndTube.addStep(new Conditions(this.poisonedFishFood), this.pickupSpade);
        this.getGaugeAndTube.addStep(new Conditions(this.fishFood, this.poison), this.usePoisonOnFishFood);
        this.getGaugeAndTube.addStep(new Conditions(this.inGroundFloor, this.fishFood), this.pickupPoison);
        this.getGaugeAndTube.addStep(new Conditions(this.inFirstFloor, this.fishFood), this.goDownToGroundFloor);
        this.getGaugeAndTube.addStep(this.inFirstFloor, this.pickupFishFood);
        this.getGaugeAndTube.addStep(this.inGroundFloor, this.goToFirstFloor);
        this.getGaugeAndTube.setLockingCondition(new Conditions(this.pressureGauge, this.rubberTube));
        this.getCan = new ConditionalStep((QuestHelper)this, this.enterManor, new Requirement[0]);
        this.getCan.addStep(new Conditions(this.isLeverADown, this.isLeverEDown), this.pullUpLeverE);
        this.getCan.addStep(new Conditions(this.isLeverBDown, this.isLeverCDown, this.isLeverDDown, this.isLeverFDown, this.isLeverEDown), this.pullUpLeverB);
        this.getCan.addStep(new Conditions(this.isLeverEDown, this.isLeverFDown, this.isLeverDUp), this.pullUpLeverD);
        this.getCan.addStep(new Conditions(new Conditions(LogicType.NAND, this.inRoomCD), this.isLeverBUp, this.isLeverCDown, this.isLeverFUp), this.pullDownLeverF);
        this.getCan.addStep(new Conditions(this.isLeverFDown, this.isLeverEDown, this.isLeverCDown), this.pullUpLeverE);
        this.getCan.addStep(new Conditions(this.isLeverFDown, this.isLeverEUp, this.isLeverCDown), this.pickupOilCan);
        this.getCan.addStep(new Conditions(this.isLeverEDown, this.isLeverFDown), this.pullDownLeverC);
        this.getCan.addStep(new Conditions(this.inRoomCD, this.isLeverCDown), this.pullUpLeverC);
        this.getCan.addStep(new Conditions(new Conditions(LogicType.OR, this.inRoomCD, this.inEmptyRoom), this.isLeverDUp), this.pullDownLeverD);
        this.getCan.addStep(new Conditions(this.isLeverBDown, this.isLeverDDown), this.pullUpLeverB);
        this.getCan.addStep(new Conditions(this.isLeverADown, this.isLeverDDown), this.pullUpLeverA);
        this.getCan.addStep(new Conditions(this.isLeverDDown, this.isLeverEDown), this.pullDownLeverF);
        this.getCan.addStep(new Conditions(this.isLeverDDown), this.pullDownLeverE);
        this.getCan.addStep(new Conditions(this.isLeverADown, this.isLeverBDown), this.pullDownLeverD);
        this.getCan.addStep(new Conditions(this.isLeverADown), this.pullDownLeverB);
        this.getCan.addStep(this.inBasement, this.pullDownLeverA);
        this.getCan.addStep(this.inSecretRoom, this.goDownLadder);
        this.getCan.addStep(this.inGroundFloor, this.searchBookcase);
        this.getCan.setLockingCondition(this.oilCan);
        ConditionalStep initialOddensteinConversation = new ConditionalStep((QuestHelper)this, this.goToFirstFloorToFinish, new Requirement[0]);
        initialOddensteinConversation.addStep(this.inSecondFloor, this.talkToOddenstein);
        initialOddensteinConversation.addStep(this.inFirstFloor, this.goToSecondFloor);
        initialOddensteinConversation.addStep(this.inSecretRoom, this.pullLeverToLeave);
        initialOddensteinConversation.addStep(this.inBasement, this.goUpFromBasement);
        ConditionalStep finishOddensteinConversation = new ConditionalStep((QuestHelper)this, this.goToFirstFloorToFinish, new Requirement[0]);
        finishOddensteinConversation.addStep(this.inSecondFloor, this.talkToOddenteinAgain);
        finishOddensteinConversation.addStep(this.inFirstFloor, this.goToSecondFloor);
        finishOddensteinConversation.addStep(this.inSecretRoom, this.pullLeverToLeave);
        finishOddensteinConversation.addStep(this.inBasement, this.goUpFromBasement);
        ConditionalStep getAllItems = new ConditionalStep((QuestHelper)this, (QuestStep)this.getGaugeAndTube, new Requirement[0]);
        getAllItems.addStep(new Conditions(this.pressureGauge, this.rubberTube, this.oilCan), initialOddensteinConversation);
        getAllItems.addStep(new Conditions(this.pressureGauge, this.rubberTube), this.getCan);
        ConditionalStep completeQuest = new ConditionalStep((QuestHelper)this, (QuestStep)this.getGaugeAndTube, new Requirement[0]);
        completeQuest.addStep(new Conditions(this.pressureGauge, this.rubberTube, this.oilCan), finishOddensteinConversation);
        completeQuest.addStep(new Conditions(this.pressureGauge, this.rubberTube), this.getCan);
        steps.put(1, getAllItems);
        steps.put(2, completeQuest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.spade = new ItemRequirement("Spade", 952).isNotConsumed();
        this.fishFood = new ItemRequirement("Fish food", 272);
        this.fishFood.setHighlightInInventory(true);
        this.poison = new ItemRequirement("Poison", 273);
        this.poison.setHighlightInInventory(true);
        this.poisonedFishFood = new ItemRequirement("Poisoned fish food", 274);
        this.poisonedFishFood.setHighlightInInventory(true);
        this.oilCan = new ItemRequirement("Oil can", 277);
        this.pressureGauge = new ItemRequirement("Pressure gauge", 271);
        this.rubberTube = new ItemRequirement("Rubber tube", 276);
        this.key = new ItemRequirement("Key", 275);
    }

    public void setupConditions() {
        this.inFirstFloor = new ZoneRequirement(this.firstFloor);
        this.inSecondFloor = new ZoneRequirement(this.secondFloor);
        this.inGroundFloor = new ZoneRequirement(this.manorGround1, this.secretRoom, this.manorGround3);
        this.inSecretRoom = new ZoneRequirement(this.secretRoom);
        this.killedFish = new ChatMessageRequirement("... then die and float to the surface.");
        this.isLeverADown = new VarbitRequirement(1788, 1);
        this.isLeverBDown = new VarbitRequirement(1789, 1);
        this.isLeverCDown = new VarbitRequirement(1790, 1);
        this.isLeverDDown = new VarbitRequirement(1791, 1);
        this.isLeverEDown = new VarbitRequirement(1792, 1);
        this.isLeverFDown = new VarbitRequirement(1793, 1);
        this.isLeverAUp = new VarbitRequirement(1788, 0);
        this.isLeverBUp = new VarbitRequirement(1789, 0);
        this.isLeverCUp = new VarbitRequirement(1790, 0);
        this.isLeverDUp = new VarbitRequirement(1791, 0);
        this.isLeverEUp = new VarbitRequirement(1792, 0);
        this.isLeverFUp = new VarbitRequirement(1793, 0);
        this.inBasement = new ZoneRequirement(this.basement);
        this.inRoomCD = new ZoneRequirement(this.roomCD);
        this.inEmptyRoom = new ZoneRequirement(this.emptyRoom);
    }

    public void setupZones() {
        this.manorGround1 = new Zone(new WorldPoint(3097, 3354, 0), new WorldPoint(3119, 3373, 0));
        this.secretRoom = new Zone(new WorldPoint(3090, 3354, 0), new WorldPoint(3096, 3363, 0));
        this.manorGround3 = new Zone(new WorldPoint(3120, 3354, 0), new WorldPoint(3126, 3360, 0));
        this.firstFloor = new Zone(new WorldPoint(3090, 3350, 1), new WorldPoint(3126, 3374, 1));
        this.secondFloor = new Zone(new WorldPoint(3090, 3350, 2), new WorldPoint(3126, 3374, 2));
        this.basement = new Zone(new WorldPoint(3090, 9745, 0), new WorldPoint(3118, 9767, 0));
        this.roomCD = new Zone(new WorldPoint(3105, 9767, 0), new WorldPoint(3112, 9758, 0));
        this.emptyRoom = new Zone(new WorldPoint(3100, 9762, 0), new WorldPoint(3104, 9758, 0));
    }

    public void setupSteps() {
        this.talkToVeronica = new NpcStep((QuestHelper)this, 3561, new WorldPoint(3109, 3329, 0), "Talk to Veronica outside of Draynor Manor.", new Requirement[0]);
        this.talkToVeronica.addDialogStep("Aha, sounds like a quest. I'll help.");
        this.enterManor = new ObjectStep((QuestHelper)this, 134, new WorldPoint(3108, 3353, 0), "Enter Draynor Manor's ground floor.", new Requirement[0]);
        this.goToFirstFloor = new ObjectStep((QuestHelper)this, 11498, new WorldPoint(3109, 3364, 0), "Go upstairs and pick up the fish food.", new Requirement[0]);
        this.pickupFishFood = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3108, 3356, 1), "Pick up the fish food in the south room.", this.fishFood);
        this.goDownToGroundFloor = new ObjectStep((QuestHelper)this, 11499, new WorldPoint(3109, 3365, 1), "Go back downstairs and pick up the poison from the north west room.", new Requirement[0]);
        this.pickupPoison = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3097, 3366, 0), "Pick up the poison from the north west room.", this.poison);
        this.usePoisonOnFishFood = new DetailedQuestStep((QuestHelper)this, "Use the poison on the fish food", this.poison, this.fishFood);
        this.pickupSpade = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3120, 3359, 0), "Pick up the spade in the east room. Exit the manor through the door in the same room.", this.spade);
        this.searchCompost = new ObjectStep((QuestHelper)this, 152, new WorldPoint(3085, 3361, 0), "Search the compost heap west of the manor.", this.spade);
        this.useFishFoodOnFountain = new ObjectStep((QuestHelper)this, 153, new WorldPoint(3088, 3335, 0), "Use the poisoned fish food on the fountain south west of the manor.", this.poisonedFishFood);
        this.searchFountain = new ObjectStep((QuestHelper)this, 153, new WorldPoint(3088, 3335, 0), "Search the fountain.", new Requirement[0]);
        this.enterManorWithKey = new ObjectStep((QuestHelper)this, 134, new WorldPoint(3108, 3353, 0), "Go back into the manor's ground floor.", new Requirement[0]);
        this.getTube = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3111, 3367, 0), "Enter the small room north of the staircase with the key and pick up the rubber tube.", this.rubberTube);
        this.searchBookcase = new ObjectStep((QuestHelper)this, 155, new WorldPoint(3097, 3358, 0), "Search the bookcase in the west room to enter the secret room.", new Requirement[0]);
        this.goDownLadder = new ObjectStep((QuestHelper)this, 133, new WorldPoint(3092, 3362, 0), "Climb down the ladder into the basement.", new Requirement[0]);
        this.pullDownLeverA = new ObjectStep((QuestHelper)this, 146, new WorldPoint(3108, 9745, 0), "Pull down lever A.", new Requirement[0]);
        this.pullDownLeverB = new ObjectStep((QuestHelper)this, 147, new WorldPoint(3118, 9752, 0), "Pull down lever B.", new Requirement[0]);
        this.pullDownLeverC = new ObjectStep((QuestHelper)this, 148, new WorldPoint(3112, 9760, 0), "Pull down lever C.", new Requirement[0]);
        this.pullDownLeverD = new ObjectStep((QuestHelper)this, 149, new WorldPoint(3108, 9767, 0), "Pull down lever D.", new Requirement[0]);
        this.pullDownLeverE = new ObjectStep((QuestHelper)this, 150, new WorldPoint(3097, 9767, 0), "Pull down lever E.", new Requirement[0]);
        this.pullDownLeverF = new ObjectStep((QuestHelper)this, 151, new WorldPoint(3096, 9765, 0), "Pull down lever F.", new Requirement[0]);
        this.pullUpLeverA = new ObjectStep((QuestHelper)this, 146, new WorldPoint(3108, 9745, 0), "Pull up lever A.", new Requirement[0]);
        this.pullUpLeverB = new ObjectStep((QuestHelper)this, 147, new WorldPoint(3118, 9752, 0), "Pull up lever B.", new Requirement[0]);
        this.pullUpLeverC = new ObjectStep((QuestHelper)this, 148, new WorldPoint(3112, 9760, 0), "Pull up lever C.", new Requirement[0]);
        this.pullUpLeverD = new ObjectStep((QuestHelper)this, 149, new WorldPoint(3108, 9767, 0), "Pull up lever D.", new Requirement[0]);
        this.pullUpLeverE = new ObjectStep((QuestHelper)this, 150, new WorldPoint(3097, 9767, 0), "Pull up lever E.", new Requirement[0]);
        this.pickupOilCan = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3092, 9755, 0), "Pick up the oil can in the west room.", this.oilCan);
        this.goUpFromBasement = new ObjectStep((QuestHelper)this, 132, new WorldPoint(3117, 9754, 0), "Climb out of the basement.", new Requirement[0]);
        this.pullLeverToLeave = new ObjectStep((QuestHelper)this, 160, new WorldPoint(3096, 3357, 0), "Pull the lever to leave the secret room", new Requirement[0]);
        this.goToFirstFloorToFinish = new ObjectStep((QuestHelper)this, 11498, new WorldPoint(3109, 3364, 0), "Bring all the items to Oddenstein on the top floor.", this.oilCan, this.rubberTube, this.pressureGauge);
        this.goToSecondFloor = new ObjectStep((QuestHelper)this, 11511, new WorldPoint(3105, 3363, 1), "Bring all the items to Oddenstein on the top floor.", this.oilCan, this.rubberTube, this.pressureGauge);
        this.talkToOddenstein = new NpcStep((QuestHelper)this, 3562, new WorldPoint(3116, 3364, 2), "Talk to Professor Oddenstein on the top floor.", new Requirement[0]);
        this.talkToOddenstein.addDialogStep("I'm looking for a guy called Ernest.");
        this.talkToOddenstein.addDialogStep("Change him back this instant!");
        this.talkToOddenstein.addSubSteps(this.goUpFromBasement, this.pullLeverToLeave, this.goToFirstFloorToFinish, this.goToSecondFloor);
        this.talkToOddenteinAgain = new NpcStep((QuestHelper)this, 3562, new WorldPoint(3116, 3364, 2), "Give Professor Oddenstein the items to finish.", this.oilCan, this.rubberTube, this.pressureGauge);
    }

    @Override
    public List<String> getCombatRequirements() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("Able to survive a skeleton (level 22) attacking you");
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(4);
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Coins", 995, 300));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Access to the Killerwatt plane (Members Only)."), new UnlockReward("Ability to be assigned Killerwatts as a Slayer task."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Collections.singletonList(this.talkToVeronica), new Requirement[0]));
        PanelDetails getGaugeAndTubePanel = new PanelDetails("Get the Gauge and Tube", Arrays.asList(this.enterManor, this.goToFirstFloor, this.pickupFishFood, this.goDownToGroundFloor, this.pickupPoison, this.usePoisonOnFishFood, this.pickupSpade, this.searchCompost, this.useFishFoodOnFountain, this.searchFountain, this.enterManorWithKey, this.getTube), new Requirement[0]);
        getGaugeAndTubePanel.setLockingStep(this.getGaugeAndTube);
        allSteps.add(getGaugeAndTubePanel);
        PanelDetails getCanPanel = new PanelDetails("Get the oil can", Arrays.asList(this.searchBookcase, this.goDownLadder, this.pullDownLeverA, this.pullDownLeverB, this.pullDownLeverD, this.pullUpLeverB, this.pullUpLeverA, this.pullDownLeverF, this.pullDownLeverE, this.pullDownLeverC, this.pullUpLeverE, this.pickupOilCan), new Requirement[0]);
        getCanPanel.setLockingStep(this.getCan);
        allSteps.add(getCanPanel);
        allSteps.add(new PanelDetails("Bring items to Oddenstein", Arrays.asList(this.talkToOddenstein, this.talkToOddenteinAgain), new Requirement[0]));
        return allSteps;
    }
}

