/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.entertheabyss;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.ENTER_THE_ABYSS)
public class EnterTheAbyss
extends BasicQuestHelper {
    ItemRequirement varrockTeleport;
    ItemRequirement ardougneTeleport;
    ItemRequirement edgevilleTeleport;
    ItemRequirement passageTeleport;
    ItemRequirement scryingOrb;
    ItemRequirement scryingOrbCharged;
    Requirement inWizardBasement;
    Requirement teleportedFromVarrock;
    Requirement teleportedFromArdougne;
    Requirement teleportedFromWizardsTower;
    Requirement teleportedFromGnome;
    Requirement teleportedFromDistentor;
    QuestStep talkToMageInWildy;
    QuestStep talkToMageInVarrock;
    QuestStep talkToAubury;
    QuestStep goDownInWizardsTower;
    QuestStep talkToSedridor;
    QuestStep talkToCromperty;
    QuestStep talkToMageAfterTeleports;
    QuestStep talkToMageToFinish;
    Zone wizardBasement;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToMageInWildy);
        steps.put(1, this.talkToMageInVarrock);
        ConditionalStep locateEssenceMine = new ConditionalStep((QuestHelper)this, this.talkToAubury, new Requirement[0]);
        locateEssenceMine.addStep(new Conditions(this.scryingOrbCharged), this.talkToMageAfterTeleports);
        locateEssenceMine.addStep(new Conditions(this.teleportedFromVarrock, this.teleportedFromWizardsTower), this.talkToCromperty);
        locateEssenceMine.addStep(new Conditions(this.teleportedFromVarrock, this.inWizardBasement), this.talkToSedridor);
        locateEssenceMine.addStep(this.teleportedFromVarrock, this.goDownInWizardsTower);
        steps.put(2, locateEssenceMine);
        steps.put(3, this.talkToMageToFinish);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.varrockTeleport = new ItemRequirement("Teleports to Varrock", 8007, 2);
        this.ardougneTeleport = new ItemRequirement("Teleport to Ardougne", 8011);
        this.edgevilleTeleport = new ItemRequirement("Teleport to Edgeville", ItemCollections.AMULET_OF_GLORIES);
        this.passageTeleport = new ItemRequirement("Teleport to Wizards' Tower", ItemCollections.NECKLACE_OF_PASSAGES);
        this.scryingOrb = new ItemRequirement("Scrying orb", 5519);
        this.scryingOrb.setTooltip("You can get another from the Mage of Zamorak in south east Varrock");
        this.scryingOrbCharged = new ItemRequirement("Scrying orb", 5518);
        this.scryingOrbCharged.setTooltip("You can get another from the Mage of Zamorak in south east Varrock");
    }

    public void loadZones() {
        this.wizardBasement = new Zone(new WorldPoint(3094, 9553, 0), new WorldPoint(3125, 9582, 0));
    }

    public void setupConditions() {
        this.inWizardBasement = new ZoneRequirement(this.wizardBasement);
        this.teleportedFromWizardsTower = new VarbitRequirement(2314, 1);
        this.teleportedFromVarrock = new VarbitRequirement(2315, 1);
        this.teleportedFromArdougne = new VarbitRequirement(2316, 1);
        this.teleportedFromDistentor = new VarbitRequirement(2317, 1);
        this.teleportedFromGnome = new VarbitRequirement(2318, 1);
    }

    public void setupSteps() {
        this.talkToMageInWildy = new NpcStep((QuestHelper)this, 2580, new WorldPoint(3102, 3557, 0), "Talk to the Mage of Zamorak in the Wilderness north of Edgeville. BRING NOTHING AS YOU CAN BE KILLED BY OTHER PLAYERS HERE.", new Requirement[0]);
        this.talkToMageInVarrock = new NpcStep((QuestHelper)this, 2582, new WorldPoint(3259, 3383, 0), "Talk to the Mage of Zamorak in south east Varrock.", new Requirement[0]);
        this.talkToMageInVarrock.addDialogSteps("Where do you get your runes from?", "Maybe I could make it worth your while?", "Yes, but I can still help you as well.", "I did it so that I could then steal their secrets.", "Deal.", "But I'm a loyal servant of Zamorak as well!", "Okay, fine. I don't really serve Zamorak.", "Because I can still help you.");
        this.talkToAubury = new NpcStep((QuestHelper)this, 11435, new WorldPoint(3253, 3401, 0), "Teleport to the essence mine with Aubury in south east Varrock.", this.scryingOrb);
        this.talkToAubury.addDialogStep("Can you teleport me to the Rune Essence Mine?");
        this.goDownInWizardsTower = new ObjectStep((QuestHelper)this, 2147, new WorldPoint(3104, 3162, 0), "Teleport to the essence mine with Sedridor in the Wizard Tower's basement.", this.scryingOrb);
        this.goDownInWizardsTower.addDialogStep("Wizard's Tower");
        this.talkToSedridor = new NpcStep((QuestHelper)this, 11432, new WorldPoint(3104, 9571, 0), "Teleport to the essence mine with Sedridor in the Wizard Tower's basement.", this.scryingOrb);
        this.talkToSedridor.addDialogStep("Can you teleport me to the Rune Essence Mine?");
        this.talkToSedridor.addSubSteps(this.goDownInWizardsTower);
        this.talkToCromperty = new NpcStep((QuestHelper)this, 8480, new WorldPoint(2684, 3323, 0), "Teleport to the essence mine with Wizard Cromperty in East Ardougne.", this.scryingOrb);
        this.talkToCromperty.addDialogStep("Can you teleport me to the Rune Essence Mine?");
        this.talkToMageAfterTeleports = new NpcStep((QuestHelper)this, 2582, new WorldPoint(3259, 3383, 0), "Talk to the Mage of Zamorak in south east Varrock.", this.scryingOrbCharged);
        this.talkToMageToFinish = new NpcStep((QuestHelper)this, 2582, new WorldPoint(3259, 3383, 0), "Talk to the Mage of Zamorak again.", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.edgevilleTeleport, this.varrockTeleport, this.passageTeleport, this.ardougneTeleport);
    }

    @Override
    public List<String> getNotes() {
        return Collections.singletonList("The start of this miniquest is in the Wilderness. Other players can attack you there, so make sure to not bring anything there!");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.RUNE_MYSTERIES, QuestState.FINISHED));
        return req;
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.RUNECRAFT, 1000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("A small rune pouch", 5509, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Ability to enter The Abyss"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Helping the Zamorakians", Arrays.asList(this.talkToMageInWildy, this.talkToMageInVarrock, this.talkToAubury, this.talkToSedridor, this.talkToCromperty, this.talkToMageAfterTeleports, this.talkToMageToFinish), new Requirement[0]));
        return allSteps;
    }
}

