/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.enlightenedjourney;

import com.questhelper.helpers.quests.enlightenedjourney.BalloonFlightStep;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;

@QuestDescriptor(quest=QuestHelperQuest.BALLOON_TRANSPORT_GRAND_TREE)
public class GrandTreeBalloonFlight
extends ComplexStateQuestHelper {
    BalloonFlightStep fly;
    ItemRequirement magicLogs;

    @Override
    public QuestStep loadStep() {
        this.setupRequirements();
        HashMap<Integer, List<Integer>> sections = new HashMap<Integer, List<Integer>>();
        List<Integer> section1 = Arrays.asList(8, 8, 8, 8, 8, 8, 8, 8, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7);
        List<Integer> section2 = Arrays.asList(7, 7, 8, 7, 8, 7, 8, 8, 8, 9, 8, 8, 8, 10, 10, 10, 8, 8, 7, 7);
        List<Integer> section3 = Arrays.asList(7, 7, 8, 9, 10, 10, 10, 9, 10, 10, 10, 10, 10, 10, 8, 8, 6, 5, 5, 5);
        sections.put(7, section1);
        sections.put(8, section2);
        sections.put(9, section3);
        this.fly = new BalloonFlightStep((QuestHelper)this, "Navigate the balloon on Entrana to the Grand Tree.", sections, this.magicLogs);
        return this.fly;
    }

    @Override
    public void setupRequirements() {
        this.magicLogs = new ItemRequirement("Magic logs", 1513, 3);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Collections.singletonList(this.magicLogs);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new QuestRequirement(QuestHelperQuest.ENLIGHTENED_JOURNEY, QuestState.FINISHED));
        reqs.add(new SkillRequirement(Skill.FIREMAKING, 60));
        return reqs;
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.FIREMAKING, 2000));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Ability to fly via balloon to the Grand Tree with 1 magic log"));
    }

    public ArrayList<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Flying to the Grand Tree", Collections.singletonList(this.fly), this.magicLogs));
        return allSteps;
    }
}

