/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.enlightenedjourney;

import com.questhelper.collections.ItemCollections;
import com.questhelper.helpers.quests.enlightenedjourney.GiveAugusteItems;
import com.questhelper.helpers.quests.enlightenedjourney.TaverleyBalloonFlight;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestPointRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.widget.WidgetTextRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedOwnerStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.ENLIGHTENED_JOURNEY)
public class EnlightenedJourney
extends BasicQuestHelper {
    ItemRequirement papyrus3;
    ItemRequirement ballOfWool;
    ItemRequirement sackOfPotatoes;
    ItemRequirement emptySack8;
    ItemRequirement unlitCandle;
    ItemRequirement yellowDye;
    ItemRequirement redDye;
    ItemRequirement silk10;
    ItemRequirement bowl;
    ItemRequirement logs10;
    ItemRequirement tinderbox;
    ItemRequirement willowBranches12;
    ItemRequirement papyrus;
    ItemRequirement papyrus2;
    ItemRequirement draynorTeleport;
    ItemRequirement balloonStructure;
    ItemRequirement origamiBalloon;
    ItemRequirement sandbag8;
    Requirement onEntrana;
    Requirement hasSandbags;
    Requirement flying;
    Zone entrana;
    QuestStep travelToEntrana;
    QuestStep talkToAuguste;
    QuestStep usePapyrusOnWool;
    QuestStep useCandleOnBalloon;
    QuestStep talkToAugusteAgain;
    QuestStep talkToAugusteWithPapyrus;
    QuestStep talkToAugusteAfterMob;
    QuestStep fillSacks;
    QuestStep talkToAugusteWithDye;
    QuestStep talkToAugusteWithBranches;
    QuestStep talkToAugusteWithLogsAndTinderbox;
    QuestStep talkToAugusteToFinish;
    DetailedOwnerStep doPuzzle;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep startingOff = new ConditionalStep((QuestHelper)this, this.travelToEntrana, new Requirement[0]);
        startingOff.addStep(this.onEntrana, this.talkToAuguste);
        steps.put(0, startingOff);
        steps.put(5, startingOff);
        steps.put(6, startingOff);
        steps.put(10, startingOff);
        ConditionalStep makingPrototype = new ConditionalStep((QuestHelper)this, this.usePapyrusOnWool, new Requirement[0]);
        makingPrototype.addStep(this.origamiBalloon, this.talkToAugusteAgain);
        makingPrototype.addStep(this.balloonStructure, this.useCandleOnBalloon);
        steps.put(20, makingPrototype);
        steps.put(40, this.talkToAugusteWithPapyrus);
        steps.put(60, this.talkToAugusteAfterMob);
        ConditionalStep gettingFinalMaterials = new ConditionalStep((QuestHelper)this, this.fillSacks, new Requirement[0]);
        gettingFinalMaterials.addStep(this.hasSandbags, this.talkToAugusteWithDye);
        steps.put(70, gettingFinalMaterials);
        steps.put(80, this.talkToAugusteWithBranches);
        ConditionalStep flight = new ConditionalStep((QuestHelper)this, this.talkToAugusteWithLogsAndTinderbox, new Requirement[0]);
        flight.addStep(this.flying, this.doPuzzle);
        steps.put(90, flight);
        steps.put(100, this.talkToAugusteToFinish);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.papyrus3 = new ItemRequirement("Papyrus", 970, 3);
        this.papyrus2 = new ItemRequirement("Papyrus", 970, 2);
        this.papyrus = new ItemRequirement("Papyrus", 970);
        this.ballOfWool = new ItemRequirement("Ball of wool", 1759);
        this.sackOfPotatoes = new ItemRequirement("Sack of potatoes (10)", 5438);
        this.emptySack8 = new ItemRequirement("Empty sack", 5418, 8);
        this.emptySack8.addAlternates(9943);
        this.unlitCandle = new ItemRequirement("Unlit candle", 36);
        this.unlitCandle.addAlternates(38);
        this.yellowDye = new ItemRequirement("Yellow dye", 1765);
        this.redDye = new ItemRequirement("Red dye", 1763);
        this.silk10 = new ItemRequirement("Silk", 950, 10);
        this.bowl = new ItemRequirement("Bowl", 1923);
        this.logs10 = new ItemRequirement("Logs", 1511, 10);
        this.tinderbox = new ItemRequirement("Tinderbox", 590).isNotConsumed();
        this.willowBranches12 = new ItemRequirement("Willow branches", 5933, 12);
        this.willowBranches12.setTooltip("You can get these by using secateurs on a willow tree you've grown. Auguste will give you a sapling to grow during the quest if you need one");
        this.draynorTeleport = new ItemRequirement("Draynor/Port Sarim teleport", 13127);
        this.draynorTeleport.addAlternates(13128, 19615);
        this.draynorTeleport.addAlternates(ItemCollections.AMULET_OF_GLORIES);
        this.balloonStructure = new ItemRequirement("Balloon structure", 9933);
        this.origamiBalloon = new ItemRequirement("Origami balloon", 9934);
        this.sandbag8 = new ItemRequirement("Sandbag", 9943, 8);
    }

    public void setupZones() {
        this.entrana = new Zone(new WorldPoint(2798, 3327, 0), new WorldPoint(2878, 3394, 1));
    }

    public void setupConditions() {
        this.onEntrana = new ZoneRequirement(this.entrana);
        this.hasSandbags = new Conditions(LogicType.OR, new VarbitRequirement(2875, 1), this.sandbag8);
        this.flying = new WidgetTextRequirement(471, 1, "Balloon Controls");
    }

    public void setupSteps() {
        this.travelToEntrana = new NpcStep((QuestHelper)this, 1167, new WorldPoint(3047, 3236, 0), "Bank all weapons and armour you have, and go to Port Sarim to get a boat to Entrana.", new Requirement[0]);
        this.talkToAuguste = new NpcStep((QuestHelper)this, 4715, new WorldPoint(2809, 3354, 0), "Talk to Auguste on Entrana 3 times.", this.papyrus3, this.ballOfWool);
        this.talkToAuguste.addDialogSteps("Yes! Sign me up.", "Umm, yes. What's your point?", "Yes.");
        this.usePapyrusOnWool = new DetailedQuestStep((QuestHelper)this, "Use papyrus on a ball of wool.", this.papyrus.highlighted(), this.ballOfWool.highlighted());
        this.useCandleOnBalloon = new DetailedQuestStep((QuestHelper)this, "Use a candle on the balloon.", this.unlitCandle.highlighted(), this.balloonStructure.highlighted());
        this.talkToAugusteAgain = new NpcStep((QuestHelper)this, 4715, new WorldPoint(2809, 3354, 0), "Talk to Auguste again.", this.origamiBalloon);
        this.talkToAugusteAgain.addDialogSteps("Yes, I have them here.");
        this.talkToAugusteWithPapyrus = new NpcStep((QuestHelper)this, 4715, new WorldPoint(2809, 3354, 0), "Talk to Auguste with 2 papyrus and a sack of potatoes.", this.papyrus2, this.sackOfPotatoes);
        this.talkToAugusteWithPapyrus.addDialogStep("Yes, I have them here.");
        this.talkToAugusteAfterMob = new NpcStep((QuestHelper)this, 4715, new WorldPoint(2809, 3354, 0), "Talk to Auguste after the flash mob.", new Requirement[0]);
        this.fillSacks = new ObjectStep((QuestHelper)this, 14890, new WorldPoint(2817, 3342, 0), "Fill your empty sacks on the sand pit south of Auguste.", this.emptySack8.highlighted());
        this.fillSacks.addIcon(5418);
        this.talkToAugusteWithDye = new GiveAugusteItems(this);
        this.talkToAugusteWithDye.addDialogSteps("Yes, I want to give you some items.", "Dye.", "Sandbags.", "Silk.", "Bowl.");
        this.talkToAugusteWithBranches = new ObjectStep((QuestHelper)this, 19133, new WorldPoint(2807, 3356, 0), "Get 12 willow branches and use them to make the basket.", this.willowBranches12.highlighted());
        this.talkToAugusteWithBranches.addIcon(5933);
        this.talkToAugusteWithLogsAndTinderbox = new NpcStep((QuestHelper)this, 4715, new WorldPoint(2809, 3354, 0), "Talk to Auguste to fly.", this.logs10, this.tinderbox);
        this.talkToAugusteWithLogsAndTinderbox.addDialogSteps("Okay.");
        this.doPuzzle = new TaverleyBalloonFlight(this);
        this.talkToAugusteToFinish = new NpcStep((QuestHelper)this, 4715, new WorldPoint(2937, 3421, 0), "Talk to Auguste in Taverley to finish the quest.", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.papyrus3, this.ballOfWool, this.sackOfPotatoes, this.emptySack8, this.unlitCandle, this.yellowDye, this.redDye, this.silk10, this.bowl, this.logs10, this.tinderbox, this.willowBranches12);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Collections.singletonList(this.draynorTeleport);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new QuestPointRequirement(20));
        reqs.add(new SkillRequirement(Skill.FIREMAKING, 20));
        reqs.add(new SkillRequirement(Skill.FARMING, 30, true));
        reqs.add(new SkillRequirement(Skill.CRAFTING, 36, true));
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.CRAFTING, 2000), new ExperienceReward(Skill.FARMING, 3000), new ExperienceReward(Skill.WOODCUTTING, 1500), new ExperienceReward(Skill.FIREMAKING, 4000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("Bomber Jacket", 9944, 1), new ItemReward("Bomber Cap", 9945, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Access to the Hot Air Balloon transport system."), new UnlockReward("Ability to make origami balloons."));
    }

    public ArrayList<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Making a balloon", Arrays.asList(this.travelToEntrana, this.talkToAuguste, this.usePapyrusOnWool, this.useCandleOnBalloon, this.talkToAugusteAgain, this.talkToAugusteWithPapyrus, this.talkToAugusteAfterMob, this.fillSacks, this.talkToAugusteWithDye), this.papyrus3, this.ballOfWool, this.unlitCandle, this.sackOfPotatoes, this.emptySack8, this.yellowDye, this.redDye, this.silk10, this.bowl));
        allSteps.add(new PanelDetails("Flying", Arrays.asList(this.talkToAugusteWithBranches, this.talkToAugusteWithLogsAndTinderbox, this.doPuzzle, this.talkToAugusteToFinish), this.willowBranches12, this.logs10, this.tinderbox));
        return allSteps;
    }
}

