/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.enlightenedjourney;

import com.questhelper.helpers.quests.enlightenedjourney.BalloonFlightStep;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;

@QuestDescriptor(quest=QuestHelperQuest.BALLOON_TRANSPORT_CASTLE_WARS)
public class CastleWarsBalloonFlight
extends ComplexStateQuestHelper {
    BalloonFlightStep fly;
    ItemRequirement yewLogs;

    @Override
    public QuestStep loadStep() {
        this.setupRequirements();
        HashMap<Integer, List<Integer>> sections = new HashMap<Integer, List<Integer>>();
        List<Integer> section1 = Arrays.asList(5, 7, 9, 10, 10, 10, 10, 10, 10, 8, 9, 9, 9, 7, 7, 7, 8, 9, 9, 9, 9);
        List<Integer> section2 = Arrays.asList(9, 10, 10, 10, 8, 7, 7, 7, 7, 7, 7, 7, 7, 7, 9, 9, 9, 7, 8, 7, 7);
        List<Integer> section3 = Arrays.asList(7, 8, 8, 8, 7, 7, 7, 7, 7, 8, 6, 6, 6, 6, 6, 8, 6, 6, 6, 5);
        sections.put(10, section1);
        sections.put(11, section2);
        sections.put(12, section3);
        this.fly = new BalloonFlightStep((QuestHelper)this, "Fly the balloon on Entrana to Castle Wars.", sections, this.yewLogs);
        return this.fly;
    }

    @Override
    public void setupRequirements() {
        this.yewLogs = new ItemRequirement("Yew logs", 1515, 10);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Collections.singletonList(this.yewLogs);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new QuestRequirement(QuestHelperQuest.ENLIGHTENED_JOURNEY, QuestState.FINISHED));
        reqs.add(new SkillRequirement(Skill.FIREMAKING, 50));
        return reqs;
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.FIREMAKING, 2000));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Ability to fly via balloon to Castle Wars with 1 yew log"));
    }

    public ArrayList<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Flying to Castle Wars", Collections.singletonList(this.fly), this.yewLogs));
        return allSteps;
    }
}

