/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.enlightenedjourney;

import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.widget.WidgetTextRequirement;
import com.questhelper.steps.DetailedOwnerStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.steps.WidgetStep;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.eventbus.Subscribe;

public class BalloonFlightStep
extends DetailedOwnerStep {
    WidgetStep dropSand;
    WidgetStep burnLog;
    WidgetStep pullRope;
    WidgetStep pullRedRope;
    WidgetStep goStraight;
    NpcStep startFlight;
    HashMap<Integer, List<Integer>> sections;
    WidgetTextRequirement flying;

    public BalloonFlightStep(QuestHelper questHelper, String text, HashMap<Integer, List<Integer>> sections, ItemRequirement ... itemRequirements) {
        super(questHelper, text, (Requirement[])itemRequirements);
        this.sections = sections;
        this.flying = new WidgetTextRequirement(471, 1, "Balloon Controls");
    }

    @Override
    protected void setupSteps() {
        this.startFlight = new NpcStep(this.getQuestHelper(), 4715, new WorldPoint(2809, 3354, 0), "", new Requirement[0]);
        this.dropSand = new WidgetStep(this.getQuestHelper(), "Drop a sandbag.", 471, 2);
        this.burnLog = new WidgetStep(this.getQuestHelper(), "Burn a log.", 471, 3);
        this.pullRope = new WidgetStep(this.getQuestHelper(), "Pull the brown rope.", 471, 6);
        this.pullRedRope = new WidgetStep(this.getQuestHelper(), "Pull the red rope.", 471, 9);
        this.goStraight = new WidgetStep(this.getQuestHelper(), "Press relax.", 471, 4);
    }

    @Override
    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        super.onVarbitChanged(varbitChanged);
        this.updateSteps();
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.updateSteps();
    }

    @Override
    protected void updateSteps() {
        if (!this.flying.check(this.client)) {
            this.startUpStep(this.startFlight);
            return;
        }
        int section = this.client.getVarbitValue(2884);
        int xPos = this.client.getVarbitValue(2882);
        int yPos = this.client.getVarbitValue(2883);
        if (this.sections.get(section) == null) {
            return;
        }
        if (this.sections.get(section).size() <= xPos + 1) {
            return;
        }
        int diffBetweenCurrentAndNextPos = this.sections.get(section).get(xPos + 1) - yPos;
        if (diffBetweenCurrentAndNextPos == 0) {
            this.startUpStep(this.goStraight);
        } else if (diffBetweenCurrentAndNextPos == 1) {
            this.startUpStep(this.burnLog);
        } else if (diffBetweenCurrentAndNextPos > 1) {
            this.startUpStep(this.dropSand);
        } else if (diffBetweenCurrentAndNextPos == -1) {
            this.startUpStep(this.pullRope);
        } else {
            this.startUpStep(this.pullRedRope);
        }
    }

    @Override
    public Collection<QuestStep> getSteps() {
        return Arrays.asList(this.startFlight, this.dropSand, this.burnLog, this.pullRope, this.pullRedRope, this.goStraight);
    }
}

