/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.enakhraslament;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.player.PrayerRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.player.SpellbookRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Spellbook;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Prayer;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.ENAKHRAS_LAMENT)
public class EnakhrasLament
extends BasicQuestHelper {
    ItemRequirement pickaxe;
    ItemRequirement chiselHighlighted;
    ItemRequirement sandstone32;
    ItemRequirement sandstone20;
    ItemRequirement base;
    ItemRequirement body;
    ItemRequirement head;
    ItemRequirement granite2;
    ItemRequirement granite;
    ItemRequirement leftArm;
    ItemRequirement rightArm;
    ItemRequirement leftLeg;
    ItemRequirement rightLeg;
    ItemRequirement kSigil;
    ItemRequirement rSigil;
    ItemRequirement mSigil;
    ItemRequirement zSigil;
    ItemRequirement softClay;
    ItemRequirement camelMould;
    ItemRequirement camelHead;
    ItemRequirement breadOrCake;
    ItemRequirement fireSpellRunes;
    ItemRequirement airSpellRunes;
    ItemRequirement mapleLog;
    ItemRequirement log;
    ItemRequirement oakLog;
    ItemRequirement willowLog;
    ItemRequirement coal;
    ItemRequirement candle;
    ItemRequirement air2;
    ItemRequirement chaos;
    ItemRequirement earth2;
    ItemRequirement sandstone5;
    ItemRequirement tinderbox;
    ItemRequirement crumbleUndeadRunes;
    ItemRequirement sandstone52;
    ItemRequirement airStaff;
    ItemRequirement airRuneOrStaff;
    ItemRequirement earthRuneOrStaff;
    ItemRequirement earthStaff;
    SpellbookRequirement onNormals;
    Requirement hasPlacedBase;
    Requirement hasTalkedToLazimAfterBase;
    Requirement hasPlacedBody;
    Requirement chiseledStatue;
    Requirement canChooseHead;
    Requirement inTempleEntranceRoom;
    Requirement inTempleGroundFloor;
    Requirement startedTemple;
    Requirement gottenLimbs;
    Requirement openedDoor1;
    Requirement openedDoor2;
    Requirement openedDoor3;
    Requirement openedDoor4;
    Requirement mPlaced;
    Requirement kPlaced;
    Requirement rPlaced;
    Requirement zPlaced;
    Requirement goneUpstairs;
    Requirement hasGottenRightArm;
    Requirement hasGottenRightLeg;
    Requirement inCentreRoom;
    Requirement inPuzzleFloor;
    Requirement fedBread;
    Requirement meltedFountain;
    Requirement cleanedFurnace;
    Requirement litBraziers;
    Requirement litLog;
    Requirement litOak;
    Requirement litWillow;
    Requirement litMaple;
    Requirement litCandle;
    Requirement litCoal;
    Requirement inNorthPuzzleRoom;
    Requirement inTopRoom;
    Requirement inLastRoom;
    Requirement wallNeedsChisel;
    Requirement finishedWall;
    Requirement protectFromMelee;
    DetailedQuestStep talkToLazim;
    DetailedQuestStep bringLazim32Sandstone;
    DetailedQuestStep useChiselOn32Sandstone;
    DetailedQuestStep placeBase;
    DetailedQuestStep bringLazim20Sandstone;
    DetailedQuestStep useChiselOn20Sandstone;
    DetailedQuestStep placeBody;
    DetailedQuestStep talkToLazimToChooseHead;
    DetailedQuestStep getGranite;
    DetailedQuestStep craftHead;
    DetailedQuestStep talkToLazimAboutBody;
    DetailedQuestStep chiselStatue;
    DetailedQuestStep giveLazimHead;
    DetailedQuestStep talkToLazimInTemple;
    DetailedQuestStep enterTemple;
    DetailedQuestStep enterTempleDownLadder;
    DetailedQuestStep cutOffLimb;
    DetailedQuestStep takeM;
    DetailedQuestStep talkToLazimForHead;
    DetailedQuestStep enterDoor1;
    DetailedQuestStep enterDoor2;
    DetailedQuestStep enterDoor3;
    DetailedQuestStep enterDoor4;
    DetailedQuestStep enterKDoor;
    DetailedQuestStep enterRDoor;
    DetailedQuestStep enterMDoor;
    DetailedQuestStep enterZDoor;
    DetailedQuestStep takeZ;
    DetailedQuestStep takeK;
    DetailedQuestStep takeR;
    DetailedQuestStep useStoneHeadOnPedestal;
    DetailedQuestStep useSoftClayOnPedestal;
    DetailedQuestStep useChiselOnGranite;
    DetailedQuestStep goUpToPuzzles;
    DetailedQuestStep useBread;
    DetailedQuestStep castAirSpell;
    DetailedQuestStep castFireSpell;
    DetailedQuestStep useMapleLog;
    DetailedQuestStep useOakLog;
    DetailedQuestStep useLog;
    DetailedQuestStep useWillowLog;
    DetailedQuestStep useCoal;
    DetailedQuestStep useCandle;
    DetailedQuestStep passBarrier;
    DetailedQuestStep goUpFromPuzzleRoom;
    DetailedQuestStep castCrumbleUndead;
    DetailedQuestStep goDownToFinalRoom;
    DetailedQuestStep protectThenTalk;
    DetailedQuestStep repairWall;
    DetailedQuestStep useChiselOnWall;
    DetailedQuestStep talkToAkthankos;
    Zone templeEntranceRoom;
    Zone templeGroundFloor;
    Zone centreRoom;
    Zone puzzleFloor;
    Zone northPuzzleRoom;
    Zone topRoom;
    Zone lastRoom;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToLazim);
        ConditionalStep makeAndPlaceBase = new ConditionalStep((QuestHelper)this, (QuestStep)this.bringLazim32Sandstone, new Requirement[0]);
        makeAndPlaceBase.addStep(new Conditions(this.head, this.granite), this.giveLazimHead);
        makeAndPlaceBase.addStep(new Conditions(this.granite2, this.canChooseHead), this.craftHead);
        makeAndPlaceBase.addStep(this.canChooseHead, this.getGranite);
        makeAndPlaceBase.addStep(this.chiseledStatue, this.talkToLazimToChooseHead);
        makeAndPlaceBase.addStep(this.hasPlacedBody, this.chiselStatue);
        makeAndPlaceBase.addStep(this.body, this.placeBody);
        makeAndPlaceBase.addStep(this.sandstone20, this.useChiselOn20Sandstone);
        makeAndPlaceBase.addStep(this.hasTalkedToLazimAfterBase, this.bringLazim20Sandstone);
        makeAndPlaceBase.addStep(this.hasPlacedBase, this.talkToLazimAboutBody);
        makeAndPlaceBase.addStep(this.base, this.placeBase);
        makeAndPlaceBase.addStep(this.sandstone32, this.useChiselOn32Sandstone);
        steps.put(10, makeAndPlaceBase);
        ConditionalStep exploreBottomLayer = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterTemple, new Requirement[0]);
        exploreBottomLayer.addStep(new Conditions(this.camelHead, this.inPuzzleFloor), this.useStoneHeadOnPedestal);
        exploreBottomLayer.addStep(this.camelMould, this.useChiselOnGranite);
        exploreBottomLayer.addStep(this.inPuzzleFloor, this.useSoftClayOnPedestal);
        exploreBottomLayer.addStep(new Conditions(this.gottenLimbs, this.inTempleGroundFloor, this.openedDoor1, this.openedDoor2, this.openedDoor3, this.openedDoor4), this.goUpToPuzzles);
        exploreBottomLayer.addStep(new Conditions(this.gottenLimbs, this.inTempleGroundFloor, this.openedDoor1, this.openedDoor2, this.openedDoor3, this.rSigil), this.enterDoor4);
        exploreBottomLayer.addStep(new Conditions(this.gottenLimbs, this.inTempleGroundFloor, this.openedDoor1, this.openedDoor2, this.openedDoor3), this.takeR);
        exploreBottomLayer.addStep(new Conditions(this.gottenLimbs, this.inTempleGroundFloor, this.openedDoor1, this.openedDoor2, this.kSigil), this.enterDoor3);
        exploreBottomLayer.addStep(new Conditions(this.gottenLimbs, this.inTempleGroundFloor, this.openedDoor1, this.openedDoor2), this.takeK);
        exploreBottomLayer.addStep(new Conditions(this.gottenLimbs, this.inTempleGroundFloor, this.openedDoor1, this.zSigil), this.enterDoor2);
        exploreBottomLayer.addStep(new Conditions(this.gottenLimbs, this.inTempleGroundFloor, this.openedDoor1), this.takeZ);
        exploreBottomLayer.addStep(new Conditions(this.gottenLimbs, this.inTempleGroundFloor, this.mSigil), this.enterDoor1);
        exploreBottomLayer.addStep(new Conditions(this.gottenLimbs, this.inTempleGroundFloor), this.takeM);
        exploreBottomLayer.addStep(new Conditions(this.startedTemple, this.inTempleGroundFloor), this.cutOffLimb);
        exploreBottomLayer.addStep(this.inTempleGroundFloor, this.talkToLazimInTemple);
        exploreBottomLayer.addStep(this.inTempleEntranceRoom, this.enterTempleDownLadder);
        steps.put(20, exploreBottomLayer);
        ConditionalStep puzzles = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterTemple, new Requirement[0]);
        puzzles.addStep(new Conditions(this.fedBread, this.inPuzzleFloor, this.meltedFountain, this.cleanedFurnace, this.litLog, this.litOak, this.litWillow, this.litMaple, this.litCandle), this.useCoal);
        puzzles.addStep(new Conditions(this.fedBread, this.inPuzzleFloor, this.meltedFountain, this.cleanedFurnace, this.litLog, this.litOak, this.litWillow, this.litMaple), this.useCandle);
        puzzles.addStep(new Conditions(this.fedBread, this.inPuzzleFloor, this.meltedFountain, this.cleanedFurnace, this.litLog, this.litOak, this.litWillow), this.useMapleLog);
        puzzles.addStep(new Conditions(this.fedBread, this.inPuzzleFloor, this.meltedFountain, this.cleanedFurnace, this.litLog, this.litOak), this.useWillowLog);
        puzzles.addStep(new Conditions(this.fedBread, this.inPuzzleFloor, this.meltedFountain, this.cleanedFurnace, this.litLog), this.useOakLog);
        puzzles.addStep(new Conditions(this.fedBread, this.inPuzzleFloor, this.meltedFountain, this.cleanedFurnace), this.useLog);
        puzzles.addStep(new Conditions(this.fedBread, this.inPuzzleFloor, this.meltedFountain), this.castAirSpell);
        puzzles.addStep(new Conditions(this.fedBread, this.inPuzzleFloor), this.castFireSpell);
        puzzles.addStep(this.inPuzzleFloor, this.useBread);
        puzzles.addStep(this.inTempleGroundFloor, this.goUpToPuzzles);
        puzzles.addStep(this.inTempleEntranceRoom, this.enterTempleDownLadder);
        steps.put(30, puzzles);
        ConditionalStep topFloorPuzzle = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterTemple, new Requirement[0]);
        topFloorPuzzle.addStep(this.inTopRoom, this.castCrumbleUndead);
        topFloorPuzzle.addStep(this.inNorthPuzzleRoom, this.goUpFromPuzzleRoom);
        topFloorPuzzle.addStep(this.inPuzzleFloor, this.passBarrier);
        topFloorPuzzle.addStep(this.inTempleGroundFloor, this.goUpToPuzzles);
        topFloorPuzzle.addStep(this.inTempleEntranceRoom, this.enterTempleDownLadder);
        steps.put(40, topFloorPuzzle);
        ConditionalStep protectMeleePuzzle = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterTemple, new Requirement[0]);
        protectMeleePuzzle.addStep(this.inLastRoom, this.protectThenTalk);
        protectMeleePuzzle.addStep(this.inTopRoom, this.goDownToFinalRoom);
        protectMeleePuzzle.addStep(this.inNorthPuzzleRoom, this.goUpFromPuzzleRoom);
        protectMeleePuzzle.addStep(this.inPuzzleFloor, this.passBarrier);
        protectMeleePuzzle.addStep(this.inTempleGroundFloor, this.goUpToPuzzles);
        protectMeleePuzzle.addStep(this.inTempleEntranceRoom, this.enterTempleDownLadder);
        steps.put(50, protectMeleePuzzle);
        ConditionalStep repairWallForAkthankos = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterTemple, new Requirement[0]);
        repairWallForAkthankos.addStep(new Conditions(this.inLastRoom, this.wallNeedsChisel), this.useChiselOnWall);
        repairWallForAkthankos.addStep(new Conditions(this.inLastRoom, this.finishedWall), this.talkToAkthankos);
        repairWallForAkthankos.addStep(this.inLastRoom, this.repairWall);
        repairWallForAkthankos.addStep(this.inTopRoom, this.goDownToFinalRoom);
        repairWallForAkthankos.addStep(this.inNorthPuzzleRoom, this.goUpFromPuzzleRoom);
        repairWallForAkthankos.addStep(this.inPuzzleFloor, this.passBarrier);
        repairWallForAkthankos.addStep(this.inTempleGroundFloor, this.goUpToPuzzles);
        repairWallForAkthankos.addStep(this.inTempleEntranceRoom, this.enterTempleDownLadder);
        steps.put(60, repairWallForAkthankos);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.pickaxe = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES).isNotConsumed();
        this.chiselHighlighted = new ItemRequirement("Chisel", 1755).isNotConsumed();
        this.chiselHighlighted.setHighlightInInventory(true);
        this.sandstone52 = new ItemRequirement("52 kg of sandstone", -1, -1);
        this.sandstone52.setDisplayItemId(6975);
        this.sandstone32 = new ItemRequirement("Sandstone 32kg", 6986);
        this.sandstone32.setHighlightInInventory(true);
        this.sandstone20 = new ItemRequirement("Sandstone 20kg", 6985);
        this.sandstone20.setHighlightInInventory(true);
        this.base = new ItemRequirement("Sandstone base", 6988);
        this.base.setHighlightInInventory(true);
        this.body = new ItemRequirement("Sandstone body", 6987);
        this.body.setHighlightInInventory(true);
        this.granite2 = new ItemRequirement("Granite (5kg)", 6983, 2);
        this.granite = new ItemRequirement("Granite (5kg)", 6983);
        this.granite.setHighlightInInventory(true);
        this.head = new ItemRequirement("Stone head", 6989);
        this.head.addAlternates(6990, 6991, 6992);
        this.mSigil = new ItemRequirement("M sigil", 6994);
        this.zSigil = new ItemRequirement("Z sigil", 6993);
        this.kSigil = new ItemRequirement("K sigil", 6996);
        this.rSigil = new ItemRequirement("R sigil", 6995);
        this.leftLeg = new ItemRequirement("Stone left leg", 6999);
        this.leftLeg.setTooltip("You can get another from Lazim");
        this.leftArm = new ItemRequirement("Stone left arm", 6997);
        this.leftArm.setTooltip("You can get another from Lazim");
        this.rightLeg = new ItemRequirement("Stone right leg", 7000);
        this.rightLeg.setTooltip("You can get another from Lazim");
        this.rightArm = new ItemRequirement("Stone right arm", 6998);
        this.rightArm.setTooltip("You can get another from Lazim");
        this.softClay = new ItemRequirement("Soft clay", 1761);
        this.camelMould = new ItemRequirement("Camel mould (p)", 7001);
        this.camelHead = new ItemRequirement("Stone head", 7002);
        this.camelHead.setHighlightInInventory(true);
        this.breadOrCake = new ItemRequirement("Bread or cake", 2309);
        this.breadOrCake.addAlternates(1891);
        this.breadOrCake.setHighlightInInventory(true);
        this.breadOrCake.setDisplayMatchedItemName(true);
        this.airSpellRunes = new ItemRequirement("Runes to cast Wind Bolt or stronger", -1, -1);
        this.airSpellRunes.setDisplayItemId(556);
        this.fireSpellRunes = new ItemRequirement("Runes to cast Fire Bolt or stronger", -1, -1);
        this.fireSpellRunes.setDisplayItemId(554);
        this.crumbleUndeadRunes = new ItemRequirement("Runes for crumble undead spell", -1, -1);
        this.crumbleUndeadRunes.setDisplayItemId(964);
        this.log = new ItemRequirement("Logs", 1511);
        this.log.setHighlightInInventory(true);
        this.mapleLog = new ItemRequirement("Maple logs", 1517);
        this.mapleLog.setHighlightInInventory(true);
        this.willowLog = new ItemRequirement("Willow logs", 1519);
        this.willowLog.setHighlightInInventory(true);
        this.oakLog = new ItemRequirement("Oak logs", 1521);
        this.oakLog.setHighlightInInventory(true);
        this.coal = new ItemRequirement("Coal", 453);
        this.coal.setHighlightInInventory(true);
        this.candle = new ItemRequirement("Candle", 36);
        this.candle.setHighlightInInventory(true);
        this.air2 = new ItemRequirement("Air rune", ItemCollections.AIR_RUNE, 2);
        this.airStaff = new ItemRequirement("Air staff", ItemCollections.AIR_STAFF, 1, true);
        this.airRuneOrStaff = new ItemRequirements(LogicType.OR, "2 air runes", this.air2, this.airStaff);
        this.earth2 = new ItemRequirement("Earth rune", ItemCollections.EARTH_RUNE, 2);
        this.earthStaff = new ItemRequirement("Air staff", ItemCollections.EARTH_STAFF, 1, true);
        this.earthRuneOrStaff = new ItemRequirements(LogicType.OR, "2 earth runes", this.earth2, this.earthStaff);
        this.chaos = new ItemRequirement("Chaos rune", 562);
        this.sandstone5 = new ItemRequirement("Sandstone (5kg)", 6975);
        this.sandstone5.setHighlightInInventory(true);
        this.tinderbox = new ItemRequirement("Tinderbox", 590).isNotConsumed();
        this.onNormals = new SpellbookRequirement(Spellbook.NORMAL);
    }

    public void loadZones() {
        this.templeEntranceRoom = new Zone(new WorldPoint(3124, 9328, 1), new WorldPoint(3128, 9330, 1));
        this.templeGroundFloor = new Zone(new WorldPoint(3074, 9282, 0), new WorldPoint(3133, 9341, 0));
        this.centreRoom = new Zone(new WorldPoint(3098, 9306, 0), new WorldPoint(3110, 9318, 0));
        this.puzzleFloor = new Zone(new WorldPoint(3086, 9305, 1), new WorldPoint(3121, 9326, 1));
        this.northPuzzleRoom = new Zone(new WorldPoint(2095, 9319, 1), new WorldPoint(3112, 9335, 1));
        this.topRoom = new Zone(new WorldPoint(3097, 9299, 2), new WorldPoint(3113, 9334, 2));
        this.lastRoom = new Zone(new WorldPoint(3096, 9291, 1), new WorldPoint(3112, 9302, 1));
    }

    public void setupConditions() {
        this.hasPlacedBase = new VarbitRequirement(1593, 1);
        this.hasPlacedBody = new VarbitRequirement(1593, 2);
        this.chiseledStatue = new VarbitRequirement(1593, 3);
        this.canChooseHead = new VarbitRequirement(1563, 1);
        this.hasTalkedToLazimAfterBase = new VarbitRequirement(1562, 1);
        this.hasGottenRightArm = new VarbitRequirement(1590, 1);
        this.hasGottenRightLeg = new VarbitRequirement(1592, 1);
        this.inTempleEntranceRoom = new ZoneRequirement(this.templeEntranceRoom);
        this.inTempleGroundFloor = new ZoneRequirement(this.templeGroundFloor);
        this.inCentreRoom = new ZoneRequirement(this.centreRoom);
        this.inPuzzleFloor = new ZoneRequirement(this.puzzleFloor);
        this.inNorthPuzzleRoom = new ZoneRequirement(this.northPuzzleRoom);
        this.inTopRoom = new ZoneRequirement(this.topRoom);
        this.inLastRoom = new ZoneRequirement(this.lastRoom);
        this.startedTemple = new VarbitRequirement(1566, 1);
        this.gottenLimbs = new VarbitRequirement(1587, 63);
        this.openedDoor1 = new VarbitRequirement(1608, 1);
        this.openedDoor2 = new VarbitRequirement(1609, 1);
        this.openedDoor3 = new VarbitRequirement(1607, 1);
        this.openedDoor4 = new VarbitRequirement(1610, 1);
        this.zPlaced = new VarbitRequirement(1611, 1);
        this.mPlaced = new VarbitRequirement(1612, 1);
        this.rPlaced = new VarbitRequirement(1613, 1);
        this.kPlaced = new VarbitRequirement(1614, 1);
        this.goneUpstairs = new VarbitRequirement(1618, 1);
        this.fedBread = new VarbitRequirement(1576, 1);
        this.meltedFountain = new VarbitRequirement(1577, 1);
        this.cleanedFurnace = new VarbitRequirement(1578, 1);
        this.litBraziers = new VarbitRequirement(1579, 1);
        this.litLog = new VarbitRequirement(1581, 1);
        this.litOak = new VarbitRequirement(1582, 1);
        this.litWillow = new VarbitRequirement(1583, 1);
        this.litMaple = new VarbitRequirement(1584, 1);
        this.litCandle = new VarbitRequirement(1585, 1);
        this.litCoal = new VarbitRequirement(1586, 1);
        this.wallNeedsChisel = new VarbitRequirement(1620, 1);
        this.finishedWall = new VarbitRequirement(1602, 3);
        this.protectFromMelee = new PrayerRequirement("Protect from Melee", Prayer.PROTECT_FROM_MELEE);
    }

    public void setupSteps() {
        this.talkToLazim = new NpcStep((QuestHelper)this, 3580, new WorldPoint(3190, 2925, 0), "Before you begin, ensure that you have enough prayer points to use Protect from Melee for around five seconds (you will need this later in the temple). Talk to Lazim in the quarry south of the Bandit Camp.", this.pickaxe, this.onNormals);
        this.talkToLazim.addDialogStep("Of course!");
        this.bringLazim32Sandstone = new NpcStep((QuestHelper)this, 3580, new WorldPoint(3190, 2925, 0), "Get 32kg of sandstone and give it to Lazim. This can be done in batches, and you can mine some nearby.", new Requirement[0]);
        this.bringLazim32Sandstone.addDialogStep("Okay, I'll get on with it.");
        this.bringLazim32Sandstone.addDialogStep("Yes, I have more stone.");
        this.bringLazim32Sandstone.addDialogStep("Here's a large 10 kg block.");
        this.bringLazim32Sandstone.addDialogStep("Here's a medium 5 kg block.");
        this.bringLazim32Sandstone.addDialogStep("Here's a small 2 kg block.");
        this.bringLazim32Sandstone.addDialogStep("Here's a tiny 1 kg block.");
        this.useChiselOn32Sandstone = new DetailedQuestStep((QuestHelper)this, "Use a chisel on the sandstone 32kg.", this.chiselHighlighted, this.sandstone32);
        this.placeBase = new ObjectStep((QuestHelper)this, 10952, new WorldPoint(3190, 2926, 0), "Place the base on the flat ground nearby.", this.base);
        this.talkToLazimAboutBody = new NpcStep((QuestHelper)this, 3580, new WorldPoint(3190, 2925, 0), "Talk to Lazim again.", new Requirement[0]);
        this.talkToLazimAboutBody.addDialogStep("I'll do it right away!");
        this.bringLazim20Sandstone = new NpcStep((QuestHelper)this, 3580, new WorldPoint(3190, 2925, 0), "Get 20kg of sandstone and give it to Lazim. This can be done in batches, and you can mine some nearby.", new Requirement[0]);
        this.bringLazim20Sandstone.addDialogStep("I'll do it right away!");
        this.bringLazim20Sandstone.addDialogStep("Yes, I have more stone.");
        this.bringLazim20Sandstone.addDialogStep("Here's a large 10 kg block.");
        this.bringLazim20Sandstone.addDialogStep("Here's a medium 5 kg block.");
        this.bringLazim20Sandstone.addDialogStep("Here's a small 2 kg block.");
        this.bringLazim20Sandstone.addDialogStep("Here's a tiny 1 kg block.");
        this.useChiselOn20Sandstone = new DetailedQuestStep((QuestHelper)this, "Use a chisel on the sandstone 20kg.", this.chiselHighlighted, this.sandstone20);
        this.placeBody = new ObjectStep((QuestHelper)this, 10952, new WorldPoint(3190, 2926, 0), "Place the body on the sandstone base.", this.body);
        this.talkToLazimToChooseHead = new NpcStep((QuestHelper)this, 3580, new WorldPoint(3190, 2925, 0), "Talk to Lazim and choose the head you'd like the statue to have.", new Requirement[0]);
        this.getGranite = new NpcStep((QuestHelper)this, 3580, new WorldPoint(3190, 2925, 0), "Get 2 x granite 5kg, and then craft one into the head you chose. You can mine some nearby.", this.granite2);
        this.craftHead = new DetailedQuestStep((QuestHelper)this, "Use a chisel on a piece of granite 5kg, and choose the head you decided on to craft.", this.chiselHighlighted, this.granite);
        this.chiselStatue = new ObjectStep((QuestHelper)this, 10952, new WorldPoint(3190, 2926, 0), "Use a chisel on the headless statue.", this.chiselHighlighted);
        this.chiselStatue.addIcon(1755);
        this.giveLazimHead = new NpcStep((QuestHelper)this, 3580, new WorldPoint(3190, 2925, 0), "Give Lazim the head.", this.head);
        this.enterTemple = new ObjectStep((QuestHelper)this, 11046, new WorldPoint(3194, 2925, 0), "Enter the temple south of the Bandit's Camp.", new Requirement[0]);
        this.enterTempleDownLadder = new ObjectStep((QuestHelper)this, 11042, new WorldPoint(3127, 9329, 1), "Enter the temple south of the Bandit's Camp.", new Requirement[0]);
        this.talkToLazimInTemple = new NpcStep((QuestHelper)this, 3580, new WorldPoint(3127, 9324, 0), "Talk to Lazim in the temple.", new Requirement[0]);
        this.cutOffLimb = new ObjectStep((QuestHelper)this, 10970, new WorldPoint(3130, 9326, 0), "Use a chisel on the fallen statue to get all its limbs.", this.chiselHighlighted);
        this.cutOffLimb.addDialogSteps("Remove the statue's left arm", "Remove the statue's right arm", "Remove the statue's left leg", "Remove the statue's right leg");
        this.takeM = new ObjectStep((QuestHelper)this, 11061, new WorldPoint(3128, 9319, 0), "Take the M sigil from the pedestal in the room.", new Requirement[0]);
        this.takeZ = new ObjectStep((QuestHelper)this, 11060, new WorldPoint(3097, 9336, 0), "Take the Z sigil from the pedestal in the north room.", new Requirement[0]);
        this.takeK = new ObjectStep((QuestHelper)this, 11063, new WorldPoint(3080, 9305, 0), "Take the K sigil from the pedestal in the west room.", new Requirement[0]);
        this.takeR = new ObjectStep((QuestHelper)this, 11062, new WorldPoint(3111, 9288, 0), "Take the R sigil from the pedestal in the south room.", new Requirement[0]);
        this.talkToLazimForHead = new NpcStep((QuestHelper)this, 3580, new WorldPoint(3127, 9324, 0), "Talk to Lazim in the temple for the stone head.", new Requirement[0]);
        this.talkToLazimForHead.addDialogStep("Do you know where the statue's head is?");
        this.enterDoor1 = new ObjectStep((QuestHelper)this, 11066, new WorldPoint(3126, 9337, 0), "Enter the right arm door.", this.rightArm.highlighted());
        this.enterDoor1.addIcon(6998);
        this.enterDoor2 = new ObjectStep((QuestHelper)this, 11068, new WorldPoint(3079, 9334, 0), "Enter the left leg door.", this.leftLeg.highlighted());
        this.enterDoor2.addIcon(6999);
        this.enterDoor3 = new ObjectStep((QuestHelper)this, 11064, new WorldPoint(3082, 9287, 0), "Enter the left arm door.", this.leftArm.highlighted());
        this.enterDoor3.addIcon(6997);
        this.enterDoor4 = new ObjectStep((QuestHelper)this, 11070, new WorldPoint(3129, 9290, 0), "Enter the right leg door.", this.rightLeg.highlighted());
        this.enterDoor4.addIcon(7000);
        this.enterKDoor = new ObjectStep((QuestHelper)this, 11057, new WorldPoint(3111, 9312, 0), "Enter the door with a K.", this.kSigil);
        this.enterRDoor = new ObjectStep((QuestHelper)this, 11055, new WorldPoint(3104, 9319, 0), "Enter the door with an R.", this.rSigil);
        this.enterMDoor = new ObjectStep((QuestHelper)this, 11053, new WorldPoint(3097, 9312, 0), "Enter the door with an M.", this.mSigil);
        this.enterZDoor = new ObjectStep((QuestHelper)this, 11051, new WorldPoint(3104, 9305, 0), "Enter the door with a Z.", this.zSigil);
        this.goUpToPuzzles = new ObjectStep((QuestHelper)this, 11041, new WorldPoint(3104, 9309, 0), "Open the central room's doors using the metal letters. Go up the ladder in the central room.", new Requirement[0]);
        this.useSoftClayOnPedestal = new ObjectStep((QuestHelper)this, 10987, new WorldPoint(3104, 9312, 1), "Use soft clay on the pedestal.", this.softClay.highlighted());
        this.useChiselOnGranite = new DetailedQuestStep((QuestHelper)this, "Use a chisel on granite (5kg).", this.granite, this.chiselHighlighted);
        this.useStoneHeadOnPedestal = new ObjectStep((QuestHelper)this, 10987, new WorldPoint(3104, 9312, 1), "Use the camel stone head on the pedestal.", this.camelHead);
        this.useStoneHeadOnPedestal.addIcon(7002);
        this.useBread = new NpcStep((QuestHelper)this, 3568, new WorldPoint(3091, 9324, 1), "Right-click use bread or cake on Pentyn.", this.breadOrCake.highlighted());
        this.castFireSpell = new NpcStep((QuestHelper)this, 3573, new WorldPoint(3092, 9308, 1), "Cast a fire spell on the frozen fountain.", this.fireSpellRunes, this.onNormals);
        this.castAirSpell = new NpcStep((QuestHelper)this, 3574, new WorldPoint(3116, 9323, 1), "Cast an air spell on the furnace.", this.airSpellRunes, this.onNormals);
        this.useMapleLog = new ObjectStep((QuestHelper)this, 11014, new WorldPoint(3114, 9309, 1), "Use a maple log on the north west brazier.", this.mapleLog);
        this.useMapleLog.addIcon(1517);
        this.useOakLog = new ObjectStep((QuestHelper)this, 11012, new WorldPoint(3116, 9306, 1), "Use an oak log on the south brazier.", this.oakLog);
        this.useOakLog.addIcon(1521);
        this.useLog = new ObjectStep((QuestHelper)this, 11011, new WorldPoint(3114, 9306, 1), "Use a normal log on the south east brazier.", this.log);
        this.useLog.addIcon(1511);
        this.useWillowLog = new ObjectStep((QuestHelper)this, 11013, new WorldPoint(3118, 9306, 1), "Use a willow log on the south west brazier.", this.willowLog);
        this.useWillowLog.addIcon(1519);
        this.useCoal = new ObjectStep((QuestHelper)this, 11016, new WorldPoint(3118, 9309, 1), "Use coal on the north east brazier.", this.coal);
        this.useCoal.addIcon(453);
        this.useCandle = new ObjectStep((QuestHelper)this, 11015, new WorldPoint(3116, 9309, 1), "Use a candle on the north brazier.", this.candle);
        this.useCandle.addIcon(36);
        this.passBarrier = new ObjectStep((QuestHelper)this, 11005, new WorldPoint(3104, 9319, 1), "Pass through the magic barrier and go up the ladder.", new Requirement[0]);
        this.goUpFromPuzzleRoom = new ObjectStep((QuestHelper)this, 11041, new WorldPoint(3104, 9332, 1), "Go up the ladder.", new Requirement[0]);
        this.passBarrier.addSubSteps(this.goUpFromPuzzleRoom);
        this.castCrumbleUndead = new NpcStep((QuestHelper)this, 3570, new WorldPoint(3104, 9307, 2), "Cast crumble undead on the Boneguard.", this.earth2, this.airRuneOrStaff, this.chaos, this.onNormals);
        this.goDownToFinalRoom = new ObjectStep((QuestHelper)this, 11044, new WorldPoint(3105, 9300, 2), "Climb down the stone ladder past the Boneguard.", new Requirement[0]);
        this.protectThenTalk = new NpcStep((QuestHelper)this, 3577, new WorldPoint(3105, 9297, 1), "Put on Protect from Melee, then talk to the Boneguard.", this.protectFromMelee);
        this.repairWall = new ObjectStep((QuestHelper)this, 11027, new WorldPoint(3107, 9291, 1), "Take sandstone from the nearby rubble, and use it to repair the south wall. For each piece added, use a chisel on the wall.", this.sandstone5);
        this.repairWall.addDialogSteps("Of course, I'll help you out.", "Okay, I'll start building.");
        this.repairWall.addIcon(6975);
        this.useChiselOnWall = new ObjectStep((QuestHelper)this, 11027, new WorldPoint(3107, 9291, 1), "Use a chisel on the wall.", this.chiselHighlighted);
        this.useChiselOnWall.addDialogSteps("Of course, I'll help you out.", "Okay, I'll start building.");
        this.useChiselOnWall.addIcon(1755);
        this.repairWall.addSubSteps(this.useChiselOnWall);
        this.talkToAkthankos = new NpcStep((QuestHelper)this, 3577, new WorldPoint(3105, 9297, 1), "Talk to the Boneguard to finish the quest.", new Requirement[0]);
        ((NpcStep)this.talkToAkthankos).addAlternateNpcs(3578);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.pickaxe);
        reqs.add(this.chiselHighlighted);
        reqs.add(this.softClay);
        reqs.add(this.breadOrCake);
        reqs.add(this.tinderbox);
        reqs.add(this.log);
        reqs.add(this.oakLog);
        reqs.add(this.willowLog);
        reqs.add(this.mapleLog);
        reqs.add(this.candle);
        reqs.add(this.coal);
        reqs.add(this.fireSpellRunes);
        reqs.add(this.airSpellRunes);
        reqs.add(this.crumbleUndeadRunes);
        int miningLevel = this.client.getRealSkillLevel(Skill.MINING);
        if (miningLevel < 45) {
            reqs.add(this.granite2);
        }
        if (miningLevel < 35) {
            reqs.add(this.sandstone52);
        }
        return reqs;
    }

    @Override
    public List<Requirement> getGeneralRecommended() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(this.onNormals);
        return req;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new SkillRequirement(Skill.CRAFTING, 50));
        req.add(new SkillRequirement(Skill.FIREMAKING, 45, true));
        req.add(new SkillRequirement(Skill.PRAYER, 43));
        req.add(new SkillRequirement(Skill.MAGIC, 39));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.CRAFTING, 7000), new ExperienceReward(Skill.MINING, 7000), new ExperienceReward(Skill.FIREMAKING, 7000), new ExperienceReward(Skill.MAGIC, 7000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Akthanakos's Camulet", 6707, 1));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Collections.singletonList(this.talkToLazim), new Requirement[0]));
        allSteps.add(new PanelDetails("Craft a statue", Arrays.asList(this.bringLazim32Sandstone, this.useChiselOn32Sandstone, this.placeBase, this.talkToLazimAboutBody, this.bringLazim20Sandstone, this.useChiselOn20Sandstone, this.placeBody, this.chiselStatue, this.talkToLazimToChooseHead, this.getGranite, this.craftHead, this.giveLazimHead), this.pickaxe, this.chiselHighlighted, this.softClay, this.breadOrCake, this.tinderbox, this.log, this.oakLog, this.willowLog, this.mapleLog, this.candle, this.coal, this.fireSpellRunes, this.airSpellRunes, this.earth2, this.air2, this.chaos));
        allSteps.add(new PanelDetails("Explore the ground floor", Arrays.asList(this.talkToLazimInTemple, this.cutOffLimb, this.takeM, this.enterDoor1, this.enterDoor2, this.enterMDoor, this.goUpToPuzzles), new Requirement[0]));
        allSteps.add(new PanelDetails("Solve the puzzles", Arrays.asList(this.useSoftClayOnPedestal, this.useChiselOnGranite, this.useStoneHeadOnPedestal, this.useBread, this.castFireSpell, this.castAirSpell, this.useLog, this.useOakLog, this.useWillowLog, this.useMapleLog, this.useCandle, this.useCoal), new Requirement[0]));
        allSteps.add(new PanelDetails("Free Akthankos", Arrays.asList(this.passBarrier, this.goUpFromPuzzleRoom, this.castCrumbleUndead, this.goDownToFinalRoom, this.protectThenTalk, this.repairWall, this.talkToAkthankos), new Requirement[0]));
        return allSteps;
    }
}

