/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.elementalworkshopii;

import com.questhelper.collections.ItemCollections;
import com.questhelper.collections.KeyringCollection;
import com.questhelper.helpers.quests.elementalworkshopii.ConnectPipes;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.item.KeyringRequirement;
import com.questhelper.requirements.npc.NpcInteractingRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.widget.WidgetModelRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.ELEMENTAL_WORKSHOP_II)
public class ElementalWorkshopII
extends BasicQuestHelper {
    ItemRequirement pickaxe;
    ItemRequirement hammer;
    ItemRequirement coal;
    ItemRequirement batteredKey;
    ItemRequirement camelotTeleport;
    ItemRequirement digsiteTeleport;
    ItemRequirement elementalOre;
    ItemRequirement elementalBar;
    ItemRequirement mindBar;
    ItemRequirement primedBar;
    ItemRequirement beatenBook;
    ItemRequirement scroll;
    ItemRequirement key;
    ItemRequirement craneSchematic;
    ItemRequirement claw;
    ItemRequirement smallCog;
    ItemRequirement mediumCog;
    ItemRequirement largeCog;
    ItemRequirement pipe;
    Requirement magic20;
    Requirement inWorkshop;
    Requirement inMindWorkshop;
    Requirement onCatwalk;
    Requirement earthNearby;
    Requirement elementalOreNearby;
    Requirement has2Ores;
    Requirement has2Bars;
    Requirement hasSmallCog;
    Requirement hasMediumCog;
    Requirement hasLargeCog;
    Requirement hasPipe;
    Requirement hasCogsAndPipe;
    Requirement smallCogPlaced;
    Requirement mediumCogPlaced;
    Requirement largeCogPlaced;
    Requirement inBasement;
    Requirement craneLowered;
    Requirement repairedClaw;
    Requirement inPipePuzzle;
    Requirement sortedPipes;
    Requirement repairedPipe;
    Requirement placedBar;
    Requirement craneRaised;
    Requirement craneAboveLava;
    Requirement craneInLava;
    Requirement barHotOnJig;
    Requirement craneHoldingBar;
    Requirement barUnderPress;
    Requirement barOutsideTank;
    Requirement barInTunnel;
    Requirement craneHoldingHotBar;
    Requirement flatHotBarOnJig;
    Requirement barOutsideLava;
    Requirement airCoolFlatBarOnJig;
    Requirement tankOpen;
    Requirement tankClosed;
    Requirement grabberOut;
    Requirement grabberInWithHotFlatBarDoorOpen;
    Requirement waterInOpen;
    Requirement waterInClosed;
    Requirement waterOutClosed;
    Requirement waterOutOpen;
    Requirement waterInTank;
    Requirement grabberOutWithCoolFlatBar;
    Requirement grabberInWithCoolFlatBarDoorClosed;
    Requirement coolFlatBarOnJig;
    Requirement grabberInWithHotFlatBarDoorClosed;
    Requirement grabberInWithCoolFlatBarDoorOpened;
    Requirement grabberOutWithHotFlatBarDoorOpen;
    Requirement fanOff;
    Requirement fanOn;
    Requirement primedBarPlaced;
    Requirement mindBarPlaced;
    Zone workshop;
    Zone mindWorkshop;
    Zone catwalk;
    Zone basement;
    QuestStep searchBookcase;
    QuestStep readBook;
    QuestStep readScroll;
    QuestStep enterWorkshop;
    QuestStep searchMachinery;
    QuestStep mineRock;
    QuestStep killRock;
    QuestStep pickUpOre;
    QuestStep forgeBars;
    QuestStep openHatch;
    QuestStep enterHatch;
    QuestStep takeSchematics;
    QuestStep goUpHatch;
    QuestStep makeClaw;
    QuestStep lowerClaw;
    QuestStep repairClaw;
    QuestStep climbStairs;
    QuestStep climbDownStairs;
    QuestStep openJunctionBox;
    QuestStep connectPipes;
    QuestStep getCogsAndPipe;
    QuestStep repairPipe;
    QuestStep placeSmallCog;
    QuestStep placeMediumCog;
    QuestStep placeLargeCog;
    QuestStep placeBar;
    QuestStep lowerCraneOntoBar;
    QuestStep raiseCraneWithBar;
    QuestStep rotateCraneToLava;
    QuestStep lowerBarIntoLava;
    QuestStep raiseBarOutOfLava;
    QuestStep rotateCraneFromLava;
    QuestStep lowerCraneWithBar;
    QuestStep raiseCraneFromBar;
    QuestStep pullLeverToMoveToPress;
    QuestStep lowerPress;
    QuestStep pullLeverToMoveToTank;
    QuestStep pullLeverToOpenTankDoor;
    QuestStep turnCorkscrew;
    QuestStep turnCorkscrewAgain;
    QuestStep pullLeverToCloseTankDoor;
    QuestStep turnWestValve;
    QuestStep turnEastValve;
    QuestStep turnEastValveAgain;
    QuestStep turnWestValveAgain;
    QuestStep pullLeverToOpenTankDoorAgain;
    QuestStep turnCorkscrewToRetrieve;
    QuestStep turnCorkscrewToRetrieveAgain;
    QuestStep pullLeverToCloseTankDoorAgain;
    QuestStep pullLeverToMoveToFan;
    QuestStep pullFanLever;
    QuestStep pullFanLeverAgain;
    QuestStep pullLeverToMoveToLava;
    QuestStep pickUpBar;
    QuestStep goDownToBasement;
    QuestStep useBarOnGun;
    QuestStep operateHat;
    QuestStep takeMindBar;
    QuestStep goUpFromBasement;
    QuestStep makeMindHelmet;
    ConditionalStep getKey;
    ConditionalStep unlockHatch;
    ConditionalStep goRepairCrane;
    ConditionalStep goMakeClaw;
    ConditionalStep goSortTubes;
    ConditionalStep goGetCogsAndPipes;
    ConditionalStep goRepairPipe;
    ConditionalStep goPlaceCogs;
    ConditionalStep goMakeMindHelmet;
    ConditionalStep goToWorkshopTopFloor;
    ConditionalStep goToWorkshopMiddleFloor;
    ConditionalStep goToWorkshopBottomFloor;
    ConditionalStep goToWorkshopCatwalk;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.searchBookcase);
        steps.put(1, this.readBook);
        steps.put(2, this.readScroll);
        this.getKey = new ConditionalStep((QuestHelper)this, (QuestStep)this.goToWorkshopTopFloor, "Search the machinery in the north of the elemental workshop.", new Requirement[0]);
        this.getKey.addStep(this.inWorkshop, this.searchMachinery);
        steps.put(3, this.getKey);
        this.unlockHatch = new ConditionalStep((QuestHelper)this, (QuestStep)this.goToWorkshopTopFloor, "Unlock the hatch the middle of the workshop.", this.key);
        this.unlockHatch.addStep(this.inWorkshop, this.openHatch);
        steps.put(4, this.unlockHatch);
        this.goRepairCrane = new ConditionalStep((QuestHelper)this, (QuestStep)this.goToWorkshopMiddleFloor, "Go back down to the deeper workshop and use the claw on the crane.", new Requirement[0]);
        this.goRepairCrane.addStep(new Conditions(this.inMindWorkshop, this.craneLowered), this.repairClaw);
        this.goRepairCrane.addStep(this.inMindWorkshop, this.lowerClaw);
        this.goMakeClaw = new ConditionalStep((QuestHelper)this, (QuestStep)this.goToWorkshopTopFloor, "Make a claw from an elemental bar.", new Requirement[0]);
        this.goMakeClaw.addStep(new Conditions(this.inWorkshop, this.has2Bars), this.makeClaw);
        this.goMakeClaw.addStep(new Conditions(this.inWorkshop, this.has2Ores), this.forgeBars);
        this.goMakeClaw.addStep(new Conditions(this.inWorkshop, this.elementalOreNearby), this.pickUpOre);
        this.goMakeClaw.addStep(new Conditions(this.inWorkshop, this.earthNearby), this.killRock);
        this.goMakeClaw.addStep(this.inWorkshop, this.mineRock);
        this.goSortTubes = new ConditionalStep((QuestHelper)this, (QuestStep)this.goToWorkshopCatwalk, "Sort the pipes in the junction box on the catwalk.", new Requirement[0]);
        this.goSortTubes.addStep(new Conditions(this.onCatwalk, this.inPipePuzzle), this.connectPipes);
        this.goSortTubes.addStep(this.onCatwalk, this.openJunctionBox);
        this.goGetCogsAndPipes = new ConditionalStep((QuestHelper)this, (QuestStep)this.goToWorkshopCatwalk, new Requirement[0]);
        this.goGetCogsAndPipes.addStep(this.onCatwalk, this.getCogsAndPipe);
        this.goGetCogsAndPipes.addStep(this.inMindWorkshop, this.getCogsAndPipe);
        this.goRepairPipe = new ConditionalStep((QuestHelper)this, (QuestStep)this.goToWorkshopCatwalk, "Use the pipe on the broken pipe to the north of the catwalk.", new Requirement[0]);
        this.goRepairPipe.addStep(this.onCatwalk, this.repairPipe);
        this.goPlaceCogs = new ConditionalStep((QuestHelper)this, (QuestStep)this.goToWorkshopMiddleFloor, "Place cogs on the pegs outside the wind tunnel.", new Requirement[0]);
        this.goPlaceCogs.addStep(new Conditions(this.inMindWorkshop, this.smallCogPlaced, this.mediumCogPlaced), this.placeLargeCog);
        this.goPlaceCogs.addStep(new Conditions(this.inMindWorkshop, this.smallCogPlaced), this.placeMediumCog);
        this.goPlaceCogs.addStep(this.inMindWorkshop, this.placeSmallCog);
        ConditionalStep primingInWorkshop = new ConditionalStep((QuestHelper)this, this.placeBar, new Requirement[0]);
        primingInWorkshop.addStep(new Conditions(this.airCoolFlatBarOnJig, this.barOutsideLava), this.pickUpBar);
        primingInWorkshop.addStep(new Conditions(this.airCoolFlatBarOnJig, this.barInTunnel, this.fanOff), this.pullLeverToMoveToLava);
        primingInWorkshop.addStep(new Conditions(this.airCoolFlatBarOnJig, this.barInTunnel, this.fanOn), this.pullFanLeverAgain);
        primingInWorkshop.addStep(new Conditions(this.coolFlatBarOnJig, this.barInTunnel, this.fanOff), this.pullFanLever);
        primingInWorkshop.addStep(new Conditions(this.coolFlatBarOnJig, this.barOutsideTank, this.tankClosed), this.pullLeverToMoveToFan);
        primingInWorkshop.addStep(new Conditions(this.coolFlatBarOnJig, this.barOutsideTank, this.tankOpen, this.grabberOut), this.turnCorkscrewToRetrieveAgain);
        primingInWorkshop.addStep(new Conditions(this.coolFlatBarOnJig, this.barOutsideTank, this.tankOpen), this.pullLeverToCloseTankDoorAgain);
        primingInWorkshop.addStep(new Conditions(this.grabberOutWithCoolFlatBar), this.turnCorkscrewToRetrieveAgain);
        primingInWorkshop.addStep(new Conditions(this.grabberInWithCoolFlatBarDoorOpened), this.turnCorkscrewToRetrieve);
        primingInWorkshop.addStep(new Conditions(this.grabberInWithCoolFlatBarDoorClosed, this.waterInClosed, this.waterOutOpen), this.pullLeverToOpenTankDoorAgain);
        primingInWorkshop.addStep(new Conditions(this.grabberInWithCoolFlatBarDoorClosed, this.waterInOpen, this.waterOutOpen), this.turnWestValveAgain);
        primingInWorkshop.addStep(new Conditions(this.grabberInWithCoolFlatBarDoorClosed, this.waterOutClosed), this.turnEastValveAgain);
        primingInWorkshop.addStep(new Conditions(this.grabberInWithHotFlatBarDoorClosed, this.waterInOpen), this.turnEastValve);
        primingInWorkshop.addStep(new Conditions(this.grabberInWithHotFlatBarDoorClosed), this.turnWestValve);
        primingInWorkshop.addStep(new Conditions(this.grabberInWithHotFlatBarDoorOpen), this.pullLeverToCloseTankDoor);
        primingInWorkshop.addStep(new Conditions(this.grabberOutWithHotFlatBarDoorOpen), this.turnCorkscrewAgain);
        primingInWorkshop.addStep(new Conditions(this.flatHotBarOnJig, this.barOutsideTank, this.grabberOut), this.turnCorkscrewAgain);
        primingInWorkshop.addStep(new Conditions(this.flatHotBarOnJig, this.barOutsideTank, this.tankOpen), this.turnCorkscrew);
        primingInWorkshop.addStep(new Conditions(this.flatHotBarOnJig, this.barOutsideTank, this.waterInTank, this.waterOutClosed), this.turnEastValve);
        primingInWorkshop.addStep(new Conditions(this.flatHotBarOnJig, this.barOutsideTank, this.waterInOpen), this.turnWestValve);
        primingInWorkshop.addStep(new Conditions(this.flatHotBarOnJig, this.barOutsideTank), this.pullLeverToOpenTankDoor);
        primingInWorkshop.addStep(new Conditions(this.flatHotBarOnJig, this.barUnderPress), this.pullLeverToMoveToTank);
        primingInWorkshop.addStep(new Conditions(this.barHotOnJig, this.barUnderPress), this.lowerPress);
        primingInWorkshop.addStep(new Conditions(new Conditions(LogicType.OR, this.barHotOnJig, this.flatHotBarOnJig, this.coolFlatBarOnJig), this.barOutsideLava), this.pullLeverToMoveToPress);
        primingInWorkshop.addStep(new Conditions(this.barInTunnel, this.fanOn), this.pullFanLeverAgain);
        primingInWorkshop.addStep(this.barInTunnel, this.pullLeverToMoveToLava);
        primingInWorkshop.addStep(new Conditions(this.barOutsideTank, this.grabberOut), this.turnCorkscrew);
        primingInWorkshop.addStep(new Conditions(this.barOutsideTank, this.tankOpen), this.pullLeverToCloseTankDoor);
        primingInWorkshop.addStep(this.barOutsideTank, this.pullLeverToMoveToFan);
        primingInWorkshop.addStep(this.barUnderPress, this.pullLeverToMoveToTank);
        primingInWorkshop.addStep(new Conditions(this.placedBar, this.craneInLava), this.raiseBarOutOfLava);
        primingInWorkshop.addStep(new Conditions(this.placedBar, this.craneAboveLava), this.rotateCraneFromLava);
        primingInWorkshop.addStep(new Conditions(this.placedBar, this.craneLowered), this.raiseCraneWithBar);
        primingInWorkshop.addStep(new Conditions(this.craneHoldingHotBar, this.craneLowered), this.raiseCraneFromBar);
        primingInWorkshop.addStep(new Conditions(this.craneHoldingHotBar, this.craneRaised), this.lowerCraneWithBar);
        primingInWorkshop.addStep(new Conditions(this.craneHoldingHotBar, this.craneAboveLava), this.rotateCraneFromLava);
        primingInWorkshop.addStep(new Conditions(this.craneHoldingHotBar, this.craneInLava), this.raiseBarOutOfLava);
        primingInWorkshop.addStep(new Conditions(this.craneHoldingBar, this.craneAboveLava), this.lowerBarIntoLava);
        primingInWorkshop.addStep(new Conditions(this.craneHoldingBar, this.craneRaised), this.rotateCraneToLava);
        primingInWorkshop.addStep(new Conditions(this.craneHoldingBar, this.craneLowered), this.raiseCraneWithBar);
        primingInWorkshop.addStep(this.placedBar, this.lowerCraneOntoBar);
        ConditionalStep primingABar = new ConditionalStep((QuestHelper)this, (QuestStep)this.goToWorkshopMiddleFloor, new Requirement[0]);
        primingABar.addStep(this.inMindWorkshop, primingInWorkshop);
        ConditionalStep goMakeMindBar = new ConditionalStep((QuestHelper)this, (QuestStep)this.goToWorkshopBottomFloor, new Requirement[0]);
        goMakeMindBar.addStep(new Conditions(this.inBasement, this.mindBarPlaced), this.takeMindBar);
        goMakeMindBar.addStep(new Conditions(this.inBasement, this.primedBarPlaced), this.operateHat);
        goMakeMindBar.addStep(this.inBasement, this.useBarOnGun);
        this.goMakeMindHelmet = new ConditionalStep((QuestHelper)this, (QuestStep)this.goToWorkshopTopFloor, "Make the mind helm.", new Requirement[0]);
        this.goMakeMindHelmet.addStep(this.inWorkshop, this.makeMindHelmet);
        ConditionalStep makingAHelm = new ConditionalStep((QuestHelper)this, (QuestStep)this.goToWorkshopMiddleFloor, new Requirement[0]);
        makingAHelm.addStep(this.mindBar, this.goMakeMindHelmet);
        makingAHelm.addStep(new Conditions(LogicType.OR, this.primedBar, this.primedBarPlaced, this.mindBarPlaced), goMakeMindBar);
        makingAHelm.addStep(new Conditions(this.sortedPipes, this.repairedClaw, this.repairedPipe, this.smallCogPlaced, this.mediumCogPlaced, this.largeCogPlaced), primingABar);
        makingAHelm.addStep(new Conditions(this.sortedPipes, this.repairedClaw, this.hasCogsAndPipe, this.repairedPipe), this.goPlaceCogs);
        makingAHelm.addStep(new Conditions(this.sortedPipes, this.repairedClaw, this.hasCogsAndPipe), this.goRepairPipe);
        makingAHelm.addStep(new Conditions(this.sortedPipes, this.repairedClaw), this.goGetCogsAndPipes);
        makingAHelm.addStep(this.repairedClaw, this.goSortTubes);
        makingAHelm.addStep(this.claw, this.goRepairCrane);
        makingAHelm.addStep(this.craneSchematic, this.goMakeClaw);
        makingAHelm.addStep(this.inMindWorkshop, this.takeSchematics);
        steps.put(5, makingAHelm);
        steps.put(6, makingAHelm);
        steps.put(7, makingAHelm);
        steps.put(8, makingAHelm);
        steps.put(9, makingAHelm);
        steps.put(10, makingAHelm);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.pickaxe = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES).isNotConsumed();
        this.hammer = new ItemRequirement("Hammer", ItemCollections.HAMMER).isNotConsumed();
        this.coal = new ItemRequirement("Coal", 453, 8);
        this.batteredKey = new KeyringRequirement("Battered Key", this.configManager, KeyringCollection.BATTERED_KEY);
        this.batteredKey.setTooltip("You can get another by searching the bookcase in the house south of the elemental workshop's entrance");
        this.camelotTeleport = new ItemRequirement("Camelot teleport", 8010);
        this.digsiteTeleport = new ItemRequirement("Digsite teleport", ItemCollections.DIGSITE_PENDANTS);
        this.digsiteTeleport.addAlternates(12403);
        this.elementalOre = new ItemRequirement("Elemental ore", 2892);
        this.elementalOre.addAlternates(2893);
        this.elementalBar = new ItemRequirement("Elemental metal", 2893);
        this.mindBar = new ItemRequirement("Primed mind bar", 9728);
        this.primedBar = new ItemRequirement("Primed bar", 9727);
        this.beatenBook = new ItemRequirement("Beaten book", 9717);
        this.beatenBook.setTooltip("You can get another from a bookcase in the Exam Center");
        this.scroll = new ItemRequirement("Scroll", 9721);
        this.scroll.setTooltip("You can get another by searching the beaten book");
        this.key = new ItemRequirement("Key", 9722);
        this.key.setTooltip("You can get another from the machinery in the north of the elemental workshop");
        this.craneSchematic = new ItemRequirement("Crane schematic", 9718);
        this.claw = new ItemRequirement("Crane claw", 9720);
        this.smallCog = new ItemRequirement("Small cog", 9726);
        this.mediumCog = new ItemRequirement("Medium cog", 9725);
        this.largeCog = new ItemRequirement("Large cog", 9724);
        this.pipe = new ItemRequirement("Pipe", 9723);
        this.magic20 = new SkillRequirement(Skill.MAGIC, 20, true);
    }

    public void setupZones() {
        this.workshop = new Zone(new WorldPoint(2682, 9862, 0), new WorldPoint(2747, 9927, 0));
        this.mindWorkshop = new Zone(new WorldPoint(1946, 5147, 2), new WorldPoint(1961, 5162, 2));
        this.catwalk = new Zone(new WorldPoint(1936, 5140, 3), new WorldPoint(1971, 5172, 3));
        this.basement = new Zone(new WorldPoint(1946, 5129, 0), new WorldPoint(1972, 5164, 0));
    }

    public void setupConditions() {
        this.inWorkshop = new ZoneRequirement(this.workshop);
        this.inMindWorkshop = new ZoneRequirement(this.mindWorkshop);
        this.onCatwalk = new ZoneRequirement(this.catwalk);
        this.inBasement = new ZoneRequirement(this.basement);
        this.earthNearby = new NpcInteractingRequirement(1367);
        this.elementalOreNearby = new ItemOnTileRequirement(this.elementalOre);
        this.has2Ores = new ItemRequirements(this.elementalOre.quantity(2));
        this.has2Bars = new ItemRequirements(this.elementalBar.quantity(2));
        this.repairedClaw = new VarbitRequirement(2644, 1, Operation.GREATER_EQUAL);
        this.inPipePuzzle = new WidgetModelRequirement(262, 37, 18794);
        this.sortedPipes = new Conditions(new Conditions(LogicType.OR, new VarbitRequirement(2646, 5), new VarbitRequirement(2647, 5), new VarbitRequirement(2648, 5)), new Conditions(LogicType.OR, new VarbitRequirement(2646, 6), new VarbitRequirement(2647, 6), new VarbitRequirement(2648, 6)), new Conditions(LogicType.OR, new VarbitRequirement(2646, 13), new VarbitRequirement(2647, 13), new VarbitRequirement(2648, 13)));
        this.repairedPipe = new VarbitRequirement(2650, 1);
        this.hasSmallCog = new Conditions(LogicType.OR, this.smallCog, new VarbitRequirement(2655, 1), new VarbitRequirement(2656, 1), new VarbitRequirement(2657, 1));
        this.hasMediumCog = new Conditions(LogicType.OR, this.mediumCog, new VarbitRequirement(2655, 2), new VarbitRequirement(2656, 2), new VarbitRequirement(2657, 2));
        this.hasLargeCog = new Conditions(LogicType.OR, this.largeCog, new VarbitRequirement(2655, 3), new VarbitRequirement(2656, 3), new VarbitRequirement(2657, 3));
        this.hasPipe = new Conditions(LogicType.OR, this.repairedPipe, this.pipe);
        this.hasCogsAndPipe = new Conditions(this.hasSmallCog, this.hasMediumCog, this.hasLargeCog, this.hasPipe);
        this.smallCogPlaced = new VarbitRequirement(2655, 1);
        this.mediumCogPlaced = new VarbitRequirement(2656, 2);
        this.largeCogPlaced = new VarbitRequirement(2657, 3);
        this.placedBar = new VarbitRequirement(2643, 1);
        this.barHotOnJig = new VarbitRequirement(2643, 2);
        this.flatHotBarOnJig = new VarbitRequirement(2643, 3);
        this.coolFlatBarOnJig = new VarbitRequirement(2643, 4);
        this.airCoolFlatBarOnJig = new VarbitRequirement(2643, 5);
        this.craneLowered = new VarbitRequirement(2645, 1);
        this.craneRaised = new VarbitRequirement(2645, 0);
        this.craneHoldingBar = new VarbitRequirement(2644, 2);
        this.craneAboveLava = new VarbitRequirement(2645, 2);
        this.craneInLava = new VarbitRequirement(2645, 3);
        this.barOutsideLava = new VarbitRequirement(2642, 0);
        this.barUnderPress = new VarbitRequirement(2642, 1);
        this.barOutsideTank = new VarbitRequirement(2642, 2);
        this.barInTunnel = new VarbitRequirement(2642, 3);
        this.craneHoldingHotBar = new VarbitRequirement(2644, 3);
        this.tankClosed = new VarbitRequirement(2653, 0);
        this.tankOpen = new VarbitRequirement(2653, 1);
        this.grabberOut = new VarbitRequirement(2653, 2);
        this.grabberInWithHotFlatBarDoorOpen = new VarbitRequirement(2653, 4);
        this.grabberInWithHotFlatBarDoorClosed = new VarbitRequirement(2653, 3);
        this.grabberOutWithHotFlatBarDoorOpen = new VarbitRequirement(2653, 5);
        this.grabberInWithCoolFlatBarDoorClosed = new VarbitRequirement(2653, 6);
        this.grabberInWithCoolFlatBarDoorOpened = new VarbitRequirement(2653, 7);
        this.grabberOutWithCoolFlatBar = new VarbitRequirement(2653, 8);
        this.waterInOpen = new VarbitRequirement(2651, 1);
        this.waterInClosed = new VarbitRequirement(2651, 0);
        this.waterOutClosed = new VarbitRequirement(2652, 0);
        this.waterOutOpen = new VarbitRequirement(2652, 1);
        this.waterInTank = new VarbitRequirement(2654, 1);
        this.fanOff = new VarbitRequirement(2660, 0);
        this.fanOn = new VarbitRequirement(2660, 1);
        this.primedBarPlaced = new VarbitRequirement(2662, 1);
        this.mindBarPlaced = new VarbitRequirement(2662, 2);
    }

    public void setupSteps() {
        this.searchBookcase = new ObjectStep((QuestHelper)this, 17382, new WorldPoint(3367, 3335, 0), "Search the marked bookcase in the Exam Centre in the Dig Site.", new Requirement[0]);
        this.searchBookcase.addDialogStep("Yes.");
        this.readBook = new DetailedQuestStep((QuestHelper)this, "Read the beaten book.", this.beatenBook.highlighted());
        this.readScroll = new DetailedQuestStep((QuestHelper)this, "Read the scroll.", this.scroll.highlighted());
        this.enterWorkshop = new ObjectStep((QuestHelper)this, 3415, new WorldPoint(2711, 3498, 0), "Enter the elemental workshop.", this.batteredKey, this.beatenBook);
        this.searchMachinery = new ObjectStep((QuestHelper)this, 18593, new WorldPoint(2715, 9903, 0), "", new Requirement[0]);
        this.openHatch = new ObjectStep((QuestHelper)this, 3413, new WorldPoint(2720, 9891, 0), "", new Requirement[0]);
        this.enterHatch = new ObjectStep((QuestHelper)this, 3413, new WorldPoint(2720, 9891, 0), "Enter the hatch the middle of the workshop.", new Requirement[0]);
        this.takeSchematics = new ObjectStep((QuestHelper)this, 18711, new WorldPoint(1952, 5148, 2), "Take crane schematics from the crate to the south.", new Requirement[0]);
        this.takeSchematics.addDialogSteps("Crane schematic");
        this.goUpHatch = new ObjectStep((QuestHelper)this, 18598, new WorldPoint(1954, 5155, 2), "Go up the stairs.", new Requirement[0]);
        this.mineRock = new NpcStep((QuestHelper)this, 1368, new WorldPoint(2703, 9894, 0), "You need 2 elemental bars. Mine one of the elemental rocks in the west room, ready to fight a level 35.", true, this.pickaxe);
        this.killRock = new NpcStep((QuestHelper)this, 1367, new WorldPoint(2703, 9897, 0), "Kill the rock elemental that appeared.", new Requirement[0]);
        this.pickUpOre = new ItemStep((QuestHelper)this, "Pick up the elemental ore.", this.elementalOre);
        this.forgeBars = new ObjectStep((QuestHelper)this, 3410, new WorldPoint(2726, 9875, 0), "Use the elemental ores on the furnace in the south room.", this.elementalOre.quantity(2), this.coal.quantity(8));
        this.forgeBars.addIcon(2892);
        this.makeClaw = new ObjectStep((QuestHelper)this, 3402, new WorldPoint(2717, 9888, 0), "Use the bar on one of the workbenches in the central room to make a claw.", this.elementalBar.highlighted(), this.hammer, this.batteredKey, this.craneSchematic);
        this.makeClaw.addDialogStep("An elemental claw.");
        this.makeClaw.addIcon(2893);
        this.lowerClaw = new ObjectStep((QuestHelper)this, 18622, new WorldPoint(1953, 5148, 2), "Pull the south west lever to lower the claw.", new Requirement[0]);
        Integer[] craneIDs = new Integer[]{18624, 18625, 18626, 18627, 18628, 18629, 18630, 18631, 18632, 18633, 18634, 18635, 18636, 18637, 18638};
        this.repairClaw = new ObjectStep((QuestHelper)this, 18623, new WorldPoint(1954, 5145, 2), "Use the claw on the crane to the south.", this.claw.highlighted());
        this.repairClaw.addIcon(9720);
        ((ObjectStep)this.repairClaw).addAlternateObjects(craneIDs);
        this.repairClaw.addDialogStep("An elemental claw.");
        this.climbStairs = new ObjectStep((QuestHelper)this, 18610, new WorldPoint(1949, 5149, 2), "Climb up to the catwalk.", new Requirement[0]);
        this.climbDownStairs = new ObjectStep((QuestHelper)this, 18611, new WorldPoint(1949, 5149, 2), "Climb down from the catwalk.", new Requirement[0]);
        this.openJunctionBox = new ObjectStep((QuestHelper)this, 18641, new WorldPoint(1943, 5154, 3), "Open the junction box.", new Requirement[0]);
        this.connectPipes = new ConnectPipes(this);
        this.getCogsAndPipe = new ObjectStep((QuestHelper)this, 18612, "Search the various marked crates on the catwalk and below for 3 cogs and a pipe.", this.smallCog, this.mediumCog, this.largeCog, this.pipe);
        ((ObjectStep)this.getCogsAndPipe).addAlternateObjects(18613, 18614, 18615, 18616, 18617, 18618, 18619);
        ((ObjectStep)this.getCogsAndPipe).setRevalidateObjects(true);
        this.repairPipe = new ObjectStep((QuestHelper)this, 3414, new WorldPoint(1953, 5168, 3), "", this.pipe.highlighted());
        this.repairPipe.addIcon(9723);
        this.placeSmallCog = new ObjectStep((QuestHelper)this, 18665, new WorldPoint(1959, 5157, 2), "Place the small cog on the top left peg.", this.smallCog.highlighted());
        this.placeMediumCog = new ObjectStep((QuestHelper)this, 18664, new WorldPoint(1959, 5157, 2), "Place the medium cog on the bottom left peg.", this.mediumCog.highlighted());
        this.placeLargeCog = new ObjectStep((QuestHelper)this, 18666, new WorldPoint(1959, 5157, 2), "Place the large cog on the right peg.", this.largeCog.highlighted());
        this.placeBar = new NpcStep((QuestHelper)this, 5221, new WorldPoint(1954, 5147, 2), "Place the elemental bar on the jig cart.", this.elementalBar.highlighted());
        this.placeBar.addIcon(2893);
        this.lowerCraneOntoBar = new ObjectStep((QuestHelper)this, 18622, new WorldPoint(1953, 5148, 2), "Pull the south west lever to lower the claw.", new Requirement[0]);
        this.raiseCraneWithBar = new ObjectStep((QuestHelper)this, 18622, new WorldPoint(1953, 5148, 2), "Pull the south west lever to raise the claw.", new Requirement[0]);
        this.rotateCraneToLava = new ObjectStep((QuestHelper)this, 18621, new WorldPoint(1955, 5148, 2), "Pull the south east lever to rotate the claw.", new Requirement[0]);
        this.lowerBarIntoLava = new ObjectStep((QuestHelper)this, 18622, new WorldPoint(1953, 5148, 2), "Pull the south west lever to lower the claw into the lava.", new Requirement[0]);
        this.raiseBarOutOfLava = new ObjectStep((QuestHelper)this, 18622, new WorldPoint(1953, 5148, 2), "Pull the south west lever to raise the claw out of the lava.", new Requirement[0]);
        this.rotateCraneFromLava = new ObjectStep((QuestHelper)this, 18621, new WorldPoint(1955, 5148, 2), "Pull the south east lever to rotate the claw back.", new Requirement[0]);
        this.lowerCraneWithBar = new ObjectStep((QuestHelper)this, 18622, new WorldPoint(1953, 5148, 2), "Pull the south west lever to lower the bar back onto the jig.", new Requirement[0]);
        this.raiseCraneFromBar = new ObjectStep((QuestHelper)this, 18622, new WorldPoint(1953, 5148, 2), "Pull the south west lever to raise the claw once more.", new Requirement[0]);
        this.pullLeverToMoveToPress = new ObjectStep((QuestHelper)this, 18620, new WorldPoint(1953, 5151, 2), "Pull the central lever to move the jig to the press.", new Requirement[0]);
        this.lowerPress = new ObjectStep((QuestHelper)this, 18640, new WorldPoint(1950, 5153, 2), "Pull the west lever to move the jig to the press.", new Requirement[0]);
        this.pullLeverToMoveToTank = new ObjectStep((QuestHelper)this, 18620, new WorldPoint(1953, 5151, 2), "Pull the central lever to move the jig to the water tank.", new Requirement[0]);
        this.pullLeverToOpenTankDoor = new ObjectStep((QuestHelper)this, 18648, new WorldPoint(1953, 5161, 2), "Pull the north lever to open the water tank.", new Requirement[0]);
        this.turnCorkscrew = new ObjectStep((QuestHelper)this, 18649, new WorldPoint(1955, 5161, 2), "Turn the corkscrew.", new Requirement[0]);
        this.turnCorkscrewAgain = new ObjectStep((QuestHelper)this, 18649, new WorldPoint(1955, 5161, 2), "Turn the corkscrew again.", new Requirement[0]);
        this.pullLeverToCloseTankDoor = new ObjectStep((QuestHelper)this, 18648, new WorldPoint(1953, 5161, 2), "Pull the north lever to close the water tank.", new Requirement[0]);
        this.turnWestValve = new ObjectStep((QuestHelper)this, 18646, new WorldPoint(1949, 5161, 2), "Turn the north west water valve.", new Requirement[0]);
        this.turnEastValve = new ObjectStep((QuestHelper)this, 18647, new WorldPoint(1957, 5161, 2), "Turn the north east water valve.", new Requirement[0]);
        this.turnEastValveAgain = new ObjectStep((QuestHelper)this, 18647, new WorldPoint(1957, 5161, 2), "Turn the north east water valve again.", new Requirement[0]);
        this.turnWestValveAgain = new ObjectStep((QuestHelper)this, 18646, new WorldPoint(1949, 5161, 2), "Turn the north west water valve again.", new Requirement[0]);
        this.pullLeverToOpenTankDoorAgain = new ObjectStep((QuestHelper)this, 18648, new WorldPoint(1953, 5161, 2), "Pull the north lever to open the water tank again.", new Requirement[0]);
        this.turnCorkscrewToRetrieve = new ObjectStep((QuestHelper)this, 18649, new WorldPoint(1955, 5161, 2), "Turn the corkscrew.", new Requirement[0]);
        this.turnCorkscrewToRetrieveAgain = new ObjectStep((QuestHelper)this, 18649, new WorldPoint(1955, 5161, 2), "Turn the corkscrew once more.", new Requirement[0]);
        this.pullLeverToCloseTankDoorAgain = new ObjectStep((QuestHelper)this, 18648, new WorldPoint(1953, 5161, 2), "Pull the north lever to close the water tank.", new Requirement[0]);
        this.pullLeverToMoveToFan = new ObjectStep((QuestHelper)this, 18620, new WorldPoint(1953, 5151, 2), "Pull the central lever to move the jig to the wind tunnel.", new Requirement[0]);
        this.pullFanLever = new ObjectStep((QuestHelper)this, 18663, new WorldPoint(1959, 5154, 2), "Pull the east lever to start the wind tunnel.", new Requirement[0]);
        this.pullFanLeverAgain = new ObjectStep((QuestHelper)this, 18663, new WorldPoint(1959, 5154, 2), "Pull the east lever to stop the wind tunnel.", new Requirement[0]);
        this.pullLeverToMoveToLava = new ObjectStep((QuestHelper)this, 18620, new WorldPoint(1953, 5151, 2), "Pull the central lever to move the jig back to the start.", new Requirement[0]);
        this.pickUpBar = new NpcStep((QuestHelper)this, 5226, new WorldPoint(1954, 5147, 2), "Pick up the primed bar.", new Requirement[0]);
        this.goDownToBasement = new ObjectStep((QuestHelper)this, 18597, new WorldPoint(1949, 5159, 2), "Go down from the priming room.", new Requirement[0]);
        this.useBarOnGun = new ObjectStep((QuestHelper)this, 18725, new WorldPoint(1962, 5148, 0), "Use the primed bar on the extractor gun in the east room.", this.primedBar.highlighted());
        this.useBarOnGun.addIcon(9727);
        this.operateHat = new ObjectStep((QuestHelper)this, 18690, new WorldPoint(1962, 5150, 0), "Sit in the extractor chair.", this.magic20);
        this.takeMindBar = new ObjectStep((QuestHelper)this, 18725, new WorldPoint(1962, 5148, 0), "Take the mind bar.", new Requirement[0]);
        this.goUpFromBasement = new ObjectStep((QuestHelper)this, 18599, new WorldPoint(1949, 5160, 0), "Go up the stairs.", new Requirement[0]);
        this.makeMindHelmet = new ObjectStep((QuestHelper)this, 3402, new WorldPoint(2717, 9888, 0), "Use the mind bar on one of the workbenches in the central room.", this.mindBar.highlighted(), this.hammer, this.beatenBook);
        this.makeMindHelmet.addIcon(9728);
        this.goToWorkshopTopFloor = new ConditionalStep((QuestHelper)this, this.enterWorkshop, new Requirement[0]);
        this.goToWorkshopTopFloor.addStep(this.inBasement, this.goUpFromBasement);
        this.goToWorkshopTopFloor.addStep(this.onCatwalk, this.climbDownStairs);
        this.goToWorkshopTopFloor.addStep(this.inMindWorkshop, this.goUpHatch);
        this.goToWorkshopMiddleFloor = new ConditionalStep((QuestHelper)this, this.enterWorkshop, new Requirement[0]);
        this.goToWorkshopMiddleFloor.addStep(this.inBasement, this.goUpFromBasement);
        this.goToWorkshopMiddleFloor.addStep(this.onCatwalk, this.climbDownStairs);
        this.goToWorkshopMiddleFloor.addStep(this.inWorkshop, this.enterHatch);
        this.goToWorkshopCatwalk = new ConditionalStep((QuestHelper)this, this.enterWorkshop, new Requirement[0]);
        this.goToWorkshopCatwalk.addStep(this.inBasement, this.goUpFromBasement);
        this.goToWorkshopCatwalk.addStep(this.inMindWorkshop, this.climbStairs);
        this.goToWorkshopCatwalk.addStep(this.inWorkshop, this.enterHatch);
        this.goToWorkshopBottomFloor = new ConditionalStep((QuestHelper)this, this.enterWorkshop, new Requirement[0]);
        this.goToWorkshopBottomFloor.addStep(this.onCatwalk, this.climbDownStairs);
        this.goToWorkshopBottomFloor.addStep(this.inMindWorkshop, this.goDownToBasement);
        this.goToWorkshopBottomFloor.addStep(this.inWorkshop, this.enterHatch);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.pickaxe, this.hammer, this.coal, this.batteredKey);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.digsiteTeleport, this.camelotTeleport);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("2 Earth elementals (level 35)");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new QuestRequirement(QuestHelperQuest.ELEMENTAL_WORKSHOP_I, QuestState.FINISHED));
        reqs.add(new SkillRequirement(Skill.MAGIC, 20, true));
        reqs.add(new SkillRequirement(Skill.SMITHING, 30, true));
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.CRAFTING, 7500), new ExperienceReward(Skill.SMITHING, 7500));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("A Mind Helmet", 9733, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Ability to craft and equip Mind Elemental Equipment"));
    }

    public ArrayList<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.searchBookcase, this.readBook, this.readScroll), new Requirement[0]));
        allSteps.add(new PanelDetails("Unlocking the Hatch", Arrays.asList(this.getKey, this.unlockHatch), this.batteredKey, this.pickaxe, this.coal.quantity(8), this.hammer));
        allSteps.add(new PanelDetails("Repairing the crane", Arrays.asList(this.takeSchematics, this.goMakeClaw, this.goRepairCrane), new Requirement[0]));
        allSteps.add(new PanelDetails("Repairing the workshop", Arrays.asList(this.goSortTubes, this.getCogsAndPipe, this.goRepairPipe, this.goPlaceCogs), new Requirement[0]));
        allSteps.add(new PanelDetails("Priming a bar", Arrays.asList(this.placeBar, this.lowerCraneOntoBar, this.raiseCraneWithBar, this.rotateCraneToLava, this.lowerBarIntoLava, this.raiseBarOutOfLava, this.rotateCraneFromLava, this.lowerCraneWithBar, this.raiseCraneFromBar, this.pullLeverToMoveToPress, this.lowerPress, this.pullLeverToMoveToTank, this.pullLeverToOpenTankDoor, this.turnCorkscrew, this.turnCorkscrewAgain, this.pullLeverToCloseTankDoor, this.turnWestValve, this.turnEastValve, this.turnEastValveAgain, this.turnWestValveAgain, this.pullLeverToOpenTankDoorAgain, this.turnCorkscrewToRetrieve, this.turnCorkscrewToRetrieveAgain, this.pullLeverToCloseTankDoorAgain, this.pullLeverToMoveToFan, this.pullFanLever, this.pullFanLeverAgain, this.pullLeverToMoveToLava, this.pickUpBar), this.elementalBar));
        allSteps.add(new PanelDetails("Making a Mind Helm", Arrays.asList(this.goDownToBasement, this.useBarOnGun, this.operateHat, this.takeMindBar, this.goMakeMindHelmet), this.primedBar, this.hammer, this.beatenBook));
        return allSteps;
    }
}

