/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.elementalworkshopi;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.collections.KeyringCollection;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.ComplexStateQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.KeyringRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.ELEMENTAL_WORKSHOP_I)
public class ElementalWorkshopI
extends ComplexStateQuestHelper {
    ItemRequirement knife;
    ItemRequirement pickaxe;
    ItemRequirement needle;
    ItemRequirement thread;
    ItemRequirement leather;
    ItemRequirement hammer;
    ItemRequirement coal4;
    ItemRequirement combatGear;
    ItemRequirement batteredBook;
    ItemRequirement elementalOre;
    ItemRequirement elementalBar;
    ItemRequirement batteredKey;
    ItemRequirement stoneBowlHighlighted;
    ItemRequirement lavaBowlHighlighted;
    ItemRequirement slashedBook;
    QuestStep searchBookcase;
    QuestStep readBook;
    QuestStep useKnifeOnBook;
    QuestStep openOddWall;
    QuestStep goDownStairs;
    QuestStep turnEastControl;
    QuestStep turnWestControl;
    QuestStep pullLever;
    QuestStep searchLeatherCrate;
    QuestStep searchNeedleCrate;
    QuestStep fixBellows;
    QuestStep pullBellowsLever;
    QuestStep getStoneBowl;
    QuestStep useBowlOnLava;
    QuestStep useLavaOnFurnace;
    QuestStep mineRock;
    QuestStep killRock;
    QuestStep pickUpOre;
    QuestStep forgeBar;
    QuestStep smithShield;
    Requirement inWorkshop;
    Requirement inStairwell;
    Requirement hasSlashedBook;
    Requirement hasReadBook;
    Requirement enteredWall;
    Requirement foundLeather;
    Requirement turnedValve1;
    Requirement turnedValve2;
    Requirement solvedWater;
    Requirement hasLeatherOrSearched;
    Requirement elementalOreNearby;
    Requirement earthNearby;
    Requirement solvedAir;
    Requirement solvedFire;
    Requirement fixedBellow;
    Zone workshop;
    Zone stairwell;

    @Override
    public QuestStep loadStep() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        ConditionalStep goReadBook = new ConditionalStep((QuestHelper)this, this.searchBookcase, new Requirement[0]);
        goReadBook.addStep(this.batteredBook, this.readBook);
        ConditionalStep enterElementalWorkshop = new ConditionalStep((QuestHelper)this, this.searchBookcase, new Requirement[0]);
        enterElementalWorkshop.addStep(this.inStairwell, this.goDownStairs);
        enterElementalWorkshop.addStep(this.batteredKey, this.openOddWall);
        enterElementalWorkshop.addStep(this.batteredBook, this.useKnifeOnBook);
        ConditionalStep goSolveWater = new ConditionalStep((QuestHelper)this, this.openOddWall, new Requirement[0]);
        goSolveWater.addStep(new Conditions(this.inWorkshop, this.turnedValve1, this.turnedValve2), this.pullLever);
        goSolveWater.addStep(new Conditions(this.inWorkshop, this.turnedValve1), this.turnWestControl);
        goSolveWater.addStep(this.inWorkshop, this.turnEastControl);
        goSolveWater.addStep(this.inStairwell, this.goDownStairs);
        ConditionalStep goSolveAir = new ConditionalStep((QuestHelper)this, this.openOddWall, new Requirement[0]);
        goSolveAir.addStep(new Conditions(this.needle, this.hasLeatherOrSearched, this.fixedBellow, this.inWorkshop), this.pullBellowsLever);
        goSolveAir.addStep(new Conditions(this.needle, this.hasLeatherOrSearched, this.inWorkshop), this.fixBellows);
        goSolveAir.addStep(new Conditions(this.needle, this.inWorkshop), this.searchLeatherCrate);
        goSolveAir.addStep(this.inWorkshop, this.searchNeedleCrate);
        goSolveAir.addStep(this.inStairwell, this.goDownStairs);
        ConditionalStep goSolveFire = new ConditionalStep((QuestHelper)this, this.openOddWall, new Requirement[0]);
        goSolveFire.addStep(new Conditions(this.lavaBowlHighlighted, this.inWorkshop), this.useLavaOnFurnace);
        goSolveFire.addStep(new Conditions(this.stoneBowlHighlighted, this.inWorkshop), this.useBowlOnLava);
        goSolveFire.addStep(this.inWorkshop, this.getStoneBowl);
        goSolveFire.addStep(this.inStairwell, this.goDownStairs);
        ConditionalStep goMakeShield = new ConditionalStep((QuestHelper)this, this.openOddWall, new Requirement[0]);
        goMakeShield.addStep(new Conditions(this.inWorkshop, this.elementalBar), this.smithShield);
        goMakeShield.addStep(new Conditions(this.inWorkshop, this.elementalOre), this.forgeBar);
        goMakeShield.addStep(new Conditions(this.elementalOreNearby), this.pickUpOre);
        goMakeShield.addStep(new Conditions(this.earthNearby), this.killRock);
        goMakeShield.addStep(this.inWorkshop, this.mineRock);
        goMakeShield.addStep(this.inStairwell, this.goDownStairs);
        ConditionalStep quest = new ConditionalStep((QuestHelper)this, (QuestStep)goReadBook, new Requirement[0]);
        quest.addStep(new Conditions(this.solvedWater, this.solvedAir, this.solvedFire), goMakeShield);
        quest.addStep(new Conditions(this.solvedWater, this.solvedAir), goSolveFire);
        quest.addStep(this.solvedWater, goSolveAir);
        quest.addStep(this.enteredWall, goSolveWater);
        quest.addStep(this.hasReadBook, enterElementalWorkshop);
        return quest;
    }

    @Override
    public void setupRequirements() {
        this.knife = new ItemRequirement("Knife", 946).isNotConsumed();
        this.knife.setHighlightInInventory(true);
        this.pickaxe = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES).isNotConsumed();
        this.needle = new ItemRequirement("Needle", 1733).isNotConsumed();
        this.needle.setTooltip("You can obtain this during the quest");
        this.thread = new ItemRequirement("Thread", 1734);
        this.leather = new ItemRequirement("Leather", 1741);
        this.leather.setTooltip("You can obtain this during the quest");
        this.hammer = new ItemRequirement("Hammer", ItemCollections.HAMMER).isNotConsumed();
        this.coal4 = new ItemRequirement("Coal", 453, 4);
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.batteredBook = new ItemRequirement("Battered book", 2886);
        this.batteredBook.setHighlightInInventory(true);
        this.slashedBook = new ItemRequirement("Slashed book", 9715);
        this.slashedBook.setTooltip("If you've lost it you can get another by searching the bookcase in the building south of the odd wall");
        this.batteredKey = new KeyringRequirement("Battered Key", this.configManager, KeyringCollection.BATTERED_KEY);
        this.batteredKey.setTooltip("If you've lost it you can get another by searching the bookcase in the building south of the odd wall");
        this.elementalOre = new ItemRequirement("Elemental ore", 2892);
        this.elementalOre.setHighlightInInventory(true);
        this.elementalBar = new ItemRequirement("Elemental bar", 2893);
        this.elementalBar.setHighlightInInventory(true);
        this.stoneBowlHighlighted = new ItemRequirement("A stone bowl", 2888);
        this.stoneBowlHighlighted.setHighlightInInventory(true);
        this.lavaBowlHighlighted = new ItemRequirement("A stone bowl", 2889);
        this.lavaBowlHighlighted.setHighlightInInventory(true);
    }

    public void setupSteps() {
        this.searchBookcase = new ObjectStep((QuestHelper)this, 26113, new WorldPoint(2716, 3482, 0), "Search the marked bookcase in Seers' Village.", new Requirement[0]);
        this.readBook = new DetailedQuestStep((QuestHelper)this, "Read the battered book.", this.batteredBook);
        this.readBook.addDialogStep("Yes.");
        this.useKnifeOnBook = new DetailedQuestStep((QuestHelper)this, "Use a knife on the battered book.", this.knife, this.batteredBook);
        this.openOddWall = new ObjectStep((QuestHelper)this, 26115, new WorldPoint(2709, 3495, 0), "Open the odd wall to the north of the bookcase.", this.batteredKey, this.slashedBook);
        this.goDownStairs = new ObjectStep((QuestHelper)this, 3415, new WorldPoint(2711, 3498, 0), "Climb down the staircase.", new Requirement[0]);
        this.turnEastControl = new ObjectStep((QuestHelper)this, 3403, new WorldPoint(2726, 9908, 0), "Turn the marked water control in the north room.", new Requirement[0]);
        this.turnWestControl = new ObjectStep((QuestHelper)this, 3404, new WorldPoint(2713, 9908, 0), "Turn the other marked water control in the north room.", new Requirement[0]);
        this.pullLever = new ObjectStep((QuestHelper)this, 3406, new WorldPoint(2722, 9906, 0), "Pull the lever in the north room.", new Requirement[0]);
        this.searchLeatherCrate = new ObjectStep((QuestHelper)this, 3394, new WorldPoint(2717, 9894, 0), "Search the marked crate for some leather.", new Requirement[0]);
        this.searchNeedleCrate = new ObjectStep((QuestHelper)this, 3395, new WorldPoint(2700, 9887, 0), "Search the stacked crates in the west room for a needle.", new Requirement[0]);
        this.fixBellows = new ObjectStep((QuestHelper)this, 3407, new WorldPoint(2735, 9884, 0), "Repair the bellows in the east room.", this.needle, this.thread, this.leather);
        this.fixBellows.addSubSteps(this.searchLeatherCrate, this.searchNeedleCrate);
        this.pullBellowsLever = new ObjectStep((QuestHelper)this, 3409, new WorldPoint(2734, 9887, 0), "Pull the lever next to the bellows.", new Requirement[0]);
        this.getStoneBowl = new ObjectStep((QuestHelper)this, 3397, new WorldPoint(2724, 9894, 0), "Search the boxes in the north east of the central room.", new Requirement[0]);
        this.useBowlOnLava = new ObjectStep((QuestHelper)this, 18520, new WorldPoint(2717, 9871, 0), "Use the stone bowl on the lava trough in the south room.", this.stoneBowlHighlighted);
        this.useBowlOnLava.addIcon(2888);
        this.useLavaOnFurnace = new ObjectStep((QuestHelper)this, 3410, new WorldPoint(2726, 9875, 0), "Use the lava-filled bowl on the furnace.", this.lavaBowlHighlighted);
        this.useLavaOnFurnace.addIcon(2889);
        this.mineRock = new NpcStep((QuestHelper)this, 1368, new WorldPoint(2703, 9894, 0), "Mine one of the elemental rocks in the west room, ready to fight a level 35.", true, this.pickaxe);
        this.killRock = new NpcStep((QuestHelper)this, 1367, new WorldPoint(2703, 9897, 0), "Kill the rock elemental that appeared.", new Requirement[0]);
        this.pickUpOre = new ItemStep((QuestHelper)this, "Pick up the elemental ore.", this.elementalOre);
        this.forgeBar = new ObjectStep((QuestHelper)this, 3410, new WorldPoint(2726, 9875, 0), "Use the elemental ore on the furnace in the south room.", this.elementalOre, this.coal4);
        this.forgeBar.addIcon(2892);
        this.smithShield = new ObjectStep((QuestHelper)this, 3402, new WorldPoint(2717, 9888, 0), "Use the bar on one of the workbenches in the central room to complete the quest.", this.elementalBar, this.hammer, this.slashedBook);
        this.smithShield.addIcon(2893);
    }

    public void setupConditions() {
        this.inStairwell = new ZoneRequirement(this.stairwell);
        this.inWorkshop = new ZoneRequirement(this.workshop);
        this.hasSlashedBook = new VarbitRequirement(2057, 1);
        this.hasReadBook = new VarplayerRequirement(299, true, 1);
        this.enteredWall = new VarplayerRequirement(299, true, 15);
        this.foundLeather = new VarbitRequirement(2066, 1);
        this.turnedValve1 = new VarbitRequirement(2059, 1);
        this.turnedValve2 = new VarbitRequirement(2058, 1);
        this.solvedWater = new VarbitRequirement(2060, 1);
        this.hasLeatherOrSearched = new Conditions(LogicType.OR, this.foundLeather, this.leather);
        this.solvedAir = new VarbitRequirement(2063, 1);
        this.fixedBellow = new VarbitRequirement(2061, 1);
        this.solvedFire = new VarbitRequirement(2062, 1);
        this.elementalOreNearby = new ItemOnTileRequirement(this.elementalOre);
        this.earthNearby = new NpcCondition(1367);
    }

    public void loadZones() {
        this.stairwell = new Zone(new WorldPoint(2709, 3496, 0), new WorldPoint(2711, 3498, 0));
        this.workshop = new Zone(new WorldPoint(2682, 9862, 0), new WorldPoint(2747, 9927, 0));
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.knife, this.pickaxe, this.needle, this.thread, this.leather, this.hammer, this.coal4);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Collections.singletonList(this.combatGear);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Earth elemental (level 35)");
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.CRAFTING, 5000), new ExperienceReward(Skill.SMITHING, 5000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("An Elemental Shield", 2890, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Access to the Elemental Workshop."), new UnlockReward("Ability to craft and wield Elemental equipment."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Forging a Shield", Arrays.asList(this.searchBookcase, this.readBook, this.useKnifeOnBook, this.openOddWall, this.goDownStairs, this.turnEastControl, this.turnWestControl, this.pullLever, this.fixBellows, this.pullBellowsLever, this.getStoneBowl, this.useBowlOnLava, this.useLavaOnFurnace, this.mineRock, this.killRock, this.pickUpOre, this.forgeBar, this.smithShield), this.knife, this.pickaxe, this.needle, this.thread, this.leather, this.hammer, this.coal4));
        return allSteps;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new SkillRequirement(Skill.MINING, 20));
        req.add(new SkillRequirement(Skill.SMITHING, 20));
        req.add(new SkillRequirement(Skill.CRAFTING, 20));
        return req;
    }
}

