/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.eaglespeak;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.ObjectCondition;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.EAGLES_PEAK)
public class EaglesPeak
extends BasicQuestHelper {
    ItemRequirement yellowDye;
    ItemRequirement coins;
    ItemRequirement tar;
    ItemRequirement birdBook;
    ItemRequirement metalFeather;
    ItemRequirement tenEagleFeathers;
    ItemRequirement fakeBeak;
    ItemRequirement eagleCape;
    ItemRequirement bronzeFeather;
    ItemRequirement silverFeather;
    ItemRequirement goldFeather;
    ItemRequirement birdFeed6;
    ItemRequirement ferret;
    ItemRequirement metalFeatherHighlighted;
    ItemRequirement birdFeed;
    ItemRequirement bronzeFeatherHighlighted;
    ItemRequirement silverFeatherHighlighted;
    ItemRequirement goldFeatherHighlighted;
    ItemRequirement eaglesPeakTeleport;
    ItemRequirement varrockTeleport;
    ItemRequirement ardougneTeleport;
    Requirement inMainCavern;
    Requirement spokenToNickolaus;
    Requirement spokenOnceToAsyff;
    Requirement spokenTwiceToAsyff;
    Requirement inBronzeRoom;
    Requirement bronzeRoomPedestalUp;
    Requirement bronzeRoomPedestalLowered;
    Requirement winch1NotDone;
    Requirement winch2NotDone;
    Requirement winch3NotDone;
    Requirement winch4NotDone;
    Requirement hasInspectedSilverPedestal;
    Requirement inSilverRoom;
    Requirement hasInspectedRocks1;
    Requirement hasInspectedRocks2;
    Requirement hasInspectedOpening;
    Requirement threatenedKebbit;
    Requirement inGoldRoom;
    Requirement lever1OriginalPosition;
    Requirement lever1Pulled;
    Requirement lever2Pulled;
    Requirement lever3Pulled;
    Requirement lever4Pulled;
    Requirement bird1Moved;
    Requirement bird2Moved;
    Requirement bird3Moved;
    Requirement bird4Moved;
    Requirement bird5Moved;
    Requirement hasInsertedBronzeFeather;
    Requirement hasInsertedSilverFeather;
    Requirement hasInsertedGoldFeather;
    Requirement silverFeatherNearby;
    Requirement hasSolvedBronze;
    DetailedQuestStep speakToCharlie;
    DetailedQuestStep inspectBooks;
    DetailedQuestStep clickBook;
    DetailedQuestStep inspectBooksForFeather;
    DetailedQuestStep useFeatherOnDoor;
    DetailedQuestStep enterPeak;
    DetailedQuestStep shoutAtNickolaus;
    DetailedQuestStep pickupFeathers;
    DetailedQuestStep enterEastCave;
    DetailedQuestStep goToFancyStore;
    DetailedQuestStep speakAsyffAgain;
    DetailedQuestStep returnToEaglesPeak;
    DetailedQuestStep enterBronzeRoom;
    DetailedQuestStep attemptToTakeBronzeFeather;
    DetailedQuestStep winch1;
    DetailedQuestStep winch2;
    DetailedQuestStep winch3;
    DetailedQuestStep winch4;
    DetailedQuestStep grabBronzeFeather;
    DetailedQuestStep enterMainCavernFromBronze;
    DetailedQuestStep enterSilverRoom;
    DetailedQuestStep inspectSilverPedestal;
    DetailedQuestStep enterMainCavernFromSilver;
    DetailedQuestStep enterGoldRoom;
    DetailedQuestStep inspectRocks1;
    DetailedQuestStep inspectRocks2;
    DetailedQuestStep inspectOpening;
    DetailedQuestStep threatenKebbit;
    DetailedQuestStep pickupSilverFeather;
    DetailedQuestStep collectFeed;
    DetailedQuestStep pullLever1Down;
    DetailedQuestStep pushLever1Up;
    DetailedQuestStep pullLever2Down;
    DetailedQuestStep pullLever3Down;
    DetailedQuestStep pullLever4Down;
    DetailedQuestStep fillFeeder1;
    DetailedQuestStep fillFeeder2;
    DetailedQuestStep fillFeeder3;
    DetailedQuestStep fillFeeder4;
    DetailedQuestStep fillFeeder5;
    DetailedQuestStep fillFeeder6;
    DetailedQuestStep fillFeeder4Again;
    DetailedQuestStep fillFeeder7;
    DetailedQuestStep grabGoldFeather;
    DetailedQuestStep enterMainCavernFromGold;
    DetailedQuestStep useFeathersOnStoneDoor;
    DetailedQuestStep useSilverFeathersOnStoneDoor;
    DetailedQuestStep useBronzeFeathersOnStoneDoor;
    DetailedQuestStep useGoldFeathersOnStoneDoor;
    DetailedQuestStep useGoldBronzeFeathersOnStoneDoor;
    DetailedQuestStep useGoldSilverFeathersOnStoneDoor;
    DetailedQuestStep useBronzeSilverFeathersOnStoneDoor;
    DetailedQuestStep sneakPastEagle;
    DetailedQuestStep speakToNickolaus;
    DetailedQuestStep speakToNickolausInTheCamp;
    DetailedQuestStep speakToCharlieAgain;
    DetailedQuestStep pickUpActualSilverFeather;
    DetailedQuestStep leavePeak;
    Zone inMainCave;
    Zone inSilverRoomZone;
    Zone inGoldRoomZone1;
    Zone inGoldRoomZone2;
    Zone inNest;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.speakToCharlie);
        ConditionalStep getFeatherKey = new ConditionalStep((QuestHelper)this, (QuestStep)this.inspectBooks, new Requirement[0]);
        getFeatherKey.addStep(this.birdBook, this.clickBook);
        steps.put(5, getFeatherKey);
        ConditionalStep enterEaglesPeak = new ConditionalStep((QuestHelper)this, (QuestStep)this.inspectBooksForFeather, new Requirement[0]);
        enterEaglesPeak.addStep(this.metalFeather, this.useFeatherOnDoor);
        steps.put(10, enterEaglesPeak);
        Conditions hasGoldFeatherOrUsed = new Conditions(LogicType.OR, this.goldFeather, this.hasInsertedGoldFeather);
        Conditions hasSilverFeatherOrUsed = new Conditions(LogicType.OR, this.silverFeather, this.hasInsertedSilverFeather);
        Conditions hasBronzeFeatherOrUsed = new Conditions(LogicType.OR, this.bronzeFeather, this.hasInsertedBronzeFeather);
        ConditionalStep createDisguises = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterPeak, new Requirement[0]);
        createDisguises.addStep(new Conditions(this.inMainCavern, this.hasInsertedGoldFeather, this.hasInsertedBronzeFeather, hasSilverFeatherOrUsed), this.useSilverFeathersOnStoneDoor);
        createDisguises.addStep(new Conditions(this.inMainCavern, this.hasInsertedGoldFeather, hasBronzeFeatherOrUsed, this.hasInsertedSilverFeather), this.useBronzeFeathersOnStoneDoor);
        createDisguises.addStep(new Conditions(this.inMainCavern, hasGoldFeatherOrUsed, this.hasInsertedBronzeFeather, this.hasInsertedSilverFeather), this.useGoldFeathersOnStoneDoor);
        createDisguises.addStep(new Conditions(this.inMainCavern, hasGoldFeatherOrUsed, hasBronzeFeatherOrUsed, this.hasInsertedSilverFeather), this.useGoldBronzeFeathersOnStoneDoor);
        createDisguises.addStep(new Conditions(this.inMainCavern, hasGoldFeatherOrUsed, this.hasInsertedBronzeFeather, hasSilverFeatherOrUsed), this.useGoldSilverFeathersOnStoneDoor);
        createDisguises.addStep(new Conditions(this.inMainCavern, this.hasInsertedGoldFeather, hasBronzeFeatherOrUsed, hasSilverFeatherOrUsed), this.useBronzeSilverFeathersOnStoneDoor);
        createDisguises.addStep(new Conditions(this.inMainCavern, hasGoldFeatherOrUsed, hasBronzeFeatherOrUsed, hasSilverFeatherOrUsed), this.useFeathersOnStoneDoor);
        createDisguises.addStep(new Conditions(this.inGoldRoom, hasGoldFeatherOrUsed), this.enterMainCavernFromGold);
        createDisguises.addStep(new Conditions(this.inGoldRoom, this.bird5Moved), this.grabGoldFeather);
        createDisguises.addStep(new Conditions(this.inGoldRoom, this.lever3Pulled, this.lever4Pulled, this.bird3Moved), this.fillFeeder6);
        createDisguises.addStep(new Conditions(this.inGoldRoom, this.lever3Pulled, this.lever4Pulled), this.fillFeeder4Again);
        createDisguises.addStep(new Conditions(this.inGoldRoom, this.lever4Pulled), this.pullLever3Down);
        createDisguises.addStep(new Conditions(this.inGoldRoom, this.lever1OriginalPosition, this.lever2Pulled, this.lever3Pulled, this.bird4Moved), this.pullLever4Down);
        createDisguises.addStep(new Conditions(this.inGoldRoom, this.lever1OriginalPosition, this.lever2Pulled, this.lever3Pulled), this.fillFeeder5);
        createDisguises.addStep(new Conditions(this.inGoldRoom, this.lever1OriginalPosition, this.lever2Pulled, this.bird3Moved), this.pullLever3Down);
        createDisguises.addStep(new Conditions(this.inGoldRoom, this.lever1OriginalPosition, this.lever2Pulled), this.fillFeeder4);
        createDisguises.addStep(new Conditions(this.inGoldRoom, this.lever1Pulled, this.lever2Pulled, this.bird4Moved), this.fillFeeder7);
        createDisguises.addStep(new Conditions(this.inGoldRoom, this.lever1Pulled, this.lever2Pulled), this.pushLever1Up);
        createDisguises.addStep(new Conditions(this.inGoldRoom, this.lever1Pulled, this.bird1Moved, this.bird2Moved), this.pullLever2Down);
        createDisguises.addStep(new Conditions(this.inGoldRoom, this.lever1Pulled, this.bird2Moved), this.fillFeeder3);
        createDisguises.addStep(new Conditions(this.inGoldRoom, this.lever1Pulled, this.bird1Moved), this.fillFeeder2);
        createDisguises.addStep(new Conditions(this.inGoldRoom, this.lever1Pulled), this.fillFeeder1);
        createDisguises.addStep(new Conditions(this.inGoldRoom, this.birdFeed6), this.pullLever1Down);
        createDisguises.addStep(new Conditions(this.inGoldRoom), this.collectFeed);
        createDisguises.addStep(new Conditions(this.inMainCavern, hasSilverFeatherOrUsed, hasBronzeFeatherOrUsed), this.enterGoldRoom);
        createDisguises.addStep(new Conditions(this.inSilverRoom, hasSilverFeatherOrUsed), this.enterMainCavernFromSilver);
        createDisguises.addStep(new Conditions(this.inSilverRoom, this.silverFeatherNearby), this.pickUpActualSilverFeather);
        createDisguises.addStep(new Conditions(this.inSilverRoom, this.threatenedKebbit), this.pickupSilverFeather);
        createDisguises.addStep(new Conditions(this.inSilverRoom, this.hasInspectedOpening), this.threatenKebbit);
        createDisguises.addStep(new Conditions(this.inSilverRoom, this.hasInspectedRocks2), this.inspectOpening);
        createDisguises.addStep(new Conditions(this.inSilverRoom, this.hasInspectedRocks1), this.inspectRocks2);
        createDisguises.addStep(new Conditions(this.inSilverRoom, this.hasInspectedSilverPedestal), this.inspectRocks1);
        createDisguises.addStep(new Conditions(this.inSilverRoom), this.inspectSilverPedestal);
        createDisguises.addStep(new Conditions(this.inMainCavern, hasBronzeFeatherOrUsed), this.enterSilverRoom);
        createDisguises.addStep(new Conditions(this.bronzeRoomPedestalLowered, hasBronzeFeatherOrUsed), this.enterMainCavernFromBronze);
        createDisguises.addStep(new Conditions(this.hasSolvedBronze, this.bronzeRoomPedestalLowered), this.grabBronzeFeather);
        createDisguises.addStep(new Conditions(this.bronzeRoomPedestalUp, this.winch4NotDone), this.winch4);
        createDisguises.addStep(new Conditions(this.bronzeRoomPedestalUp, this.winch3NotDone), this.winch3);
        createDisguises.addStep(new Conditions(this.bronzeRoomPedestalUp, this.winch2NotDone), this.winch2);
        createDisguises.addStep(new Conditions(this.bronzeRoomPedestalUp, this.winch1NotDone), this.winch1);
        createDisguises.addStep(new Conditions(this.inBronzeRoom, this.spokenTwiceToAsyff), this.attemptToTakeBronzeFeather);
        createDisguises.addStep(new Conditions(new ZoneRequirement(this.inMainCave), this.spokenTwiceToAsyff), this.enterBronzeRoom);
        createDisguises.addStep(new Conditions(this.spokenTwiceToAsyff), this.returnToEaglesPeak);
        createDisguises.addStep(new Conditions(this.spokenOnceToAsyff, this.tenEagleFeathers), this.speakAsyffAgain);
        createDisguises.addStep(new Conditions(this.spokenToNickolaus, this.tenEagleFeathers), this.goToFancyStore);
        createDisguises.addStep(new Conditions(this.spokenToNickolaus, this.inMainCavern), this.pickupFeathers);
        createDisguises.addStep(this.inMainCavern, this.shoutAtNickolaus);
        steps.put(15, createDisguises);
        ConditionalStep freeNickolaus = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterPeak, new Requirement[0]);
        freeNickolaus.addStep(new Conditions(new ZoneRequirement(this.inNest)), this.speakToNickolaus);
        freeNickolaus.addStep(new Conditions(this.inMainCavern), this.sneakPastEagle);
        steps.put(20, freeNickolaus);
        ConditionalStep goTalkToNeckInCamp = new ConditionalStep((QuestHelper)this, (QuestStep)this.speakToNickolausInTheCamp, new Requirement[0]);
        goTalkToNeckInCamp.addStep(this.inMainCavern, this.leavePeak);
        steps.put(25, goTalkToNeckInCamp);
        steps.put(30, goTalkToNeckInCamp);
        steps.put(35, this.speakToCharlieAgain);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.yellowDye = new ItemRequirement("Yellow dye", 1765);
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS, 50);
        this.tar = new ItemRequirement("Swamp tar", 1939);
        this.birdBook = new ItemRequirement("Bird book", 10173);
        this.birdBook.setHighlightInInventory(true);
        this.metalFeatherHighlighted = new ItemRequirement("Metal feather", 10174);
        this.metalFeatherHighlighted.setHighlightInInventory(true);
        this.metalFeatherHighlighted.setTooltip("You can get another Metal Feather by searching the books in the camp north of Eagles' Peak");
        this.metalFeather = new ItemRequirement("Metal feather", 10174);
        this.metalFeather.setTooltip("You can get another Metal Feather by searching the books in the camp north of Eagles' Peak");
        this.tenEagleFeathers = new ItemRequirement("Eagle feather", 10167, 10);
        this.fakeBeak = new ItemRequirement("Fake beak", 10172, 2);
        this.fakeBeak.setTooltip("If you lose one of your beaks you'll need to have Azyff make you a new one.");
        this.eagleCape = new ItemRequirement("Eagle cape", 10171, 2);
        this.eagleCape.setTooltip("If you lose one of your capes you'll need to have Azyff make you a new one.");
        this.bronzeFeather = new ItemRequirement("Bronze feather", 10177);
        this.silverFeather = new ItemRequirement("Silver feather", 10176);
        this.goldFeather = new ItemRequirement("Golden feather", 10175);
        this.varrockTeleport = new ItemRequirement("Varrock teleport", 8007);
        this.ardougneTeleport = new ItemRequirement("Ardougne teleport", 8011);
        this.eaglesPeakTeleport = new ItemRequirement("Teleport to Eagle's Peak. Fairy ring (AKQ), Necklace of passage (The Outpost [2])", ItemCollections.FAIRY_STAFF).isNotConsumed();
        this.eaglesPeakTeleport.addAlternates(ItemCollections.NECKLACE_OF_PASSAGES);
        this.bronzeFeatherHighlighted = new ItemRequirement("Bronze feather", 10177);
        this.bronzeFeatherHighlighted.setHighlightInInventory(true);
        this.silverFeatherHighlighted = new ItemRequirement("Silver feather", 10176);
        this.silverFeatherHighlighted.setHighlightInInventory(true);
        this.goldFeatherHighlighted = new ItemRequirement("Golden feather", 10175);
        this.goldFeatherHighlighted.setHighlightInInventory(true);
        this.birdFeed6 = new ItemRequirement("Odd bird seed", 10178, 6);
        this.birdFeed = new ItemRequirement("Odd bird seed", 10178);
        this.birdFeed.setHighlightInInventory(true);
        this.ferret = new ItemRequirement("Ferret", 10092);
        this.ferret.setTooltip("If you lose your ferret you'll need to catch a new one with a box trap north of Eagles' Peak.");
    }

    public void loadZones() {
        this.inMainCave = new Zone(new WorldPoint(1983, 4940, 3), new WorldPoint(2035, 4987, 3));
        this.inSilverRoomZone = new Zone(new WorldPoint(1925, 4863, 2), new WorldPoint(1976, 4884, 2));
        this.inGoldRoomZone1 = new Zone(new WorldPoint(1924, 4890, 2), new WorldPoint(1959, 4921, 2));
        this.inGoldRoomZone2 = new Zone(new WorldPoint(1959, 4890, 2), new WorldPoint(1985, 4901, 2));
        this.inNest = new Zone(new WorldPoint(2002, 4956, 3), new WorldPoint(2010, 4962, 3));
    }

    public void setupConditions() {
        this.inBronzeRoom = new ObjectCondition(19980);
        this.bronzeRoomPedestalUp = new ObjectCondition(19981);
        this.bronzeRoomPedestalLowered = new ObjectCondition(19984);
        this.inMainCavern = new ZoneRequirement(this.inMainCave);
        this.spokenToNickolaus = new VarbitRequirement(3110, 3);
        this.spokenOnceToAsyff = new VarbitRequirement(3110, 4);
        this.spokenTwiceToAsyff = new VarbitRequirement(3110, 5);
        this.winch1NotDone = new VarbitRequirement(3101, 0);
        this.winch2NotDone = new VarbitRequirement(3102, 0);
        this.winch3NotDone = new VarbitRequirement(3103, 0);
        this.winch4NotDone = new VarbitRequirement(3104, 0);
        this.hasSolvedBronze = new VarbitRequirement(3105, 0);
        this.hasInspectedSilverPedestal = new VarbitRequirement(3099, 1);
        this.hasInspectedRocks1 = new VarbitRequirement(3099, 2);
        this.hasInspectedRocks2 = new VarbitRequirement(3099, 3);
        this.hasInspectedOpening = new VarbitRequirement(3099, 4);
        this.threatenedKebbit = new VarbitRequirement(3099, 5);
        this.inSilverRoom = new ZoneRequirement(this.inSilverRoomZone);
        this.inGoldRoom = new ZoneRequirement(this.inGoldRoomZone1, this.inGoldRoomZone2);
        this.lever1OriginalPosition = new VarbitRequirement(3092, 0);
        this.lever1Pulled = new VarbitRequirement(3092, 1);
        this.lever2Pulled = new VarbitRequirement(3093, 1);
        this.lever3Pulled = new VarbitRequirement(3090, 1);
        this.lever4Pulled = new VarbitRequirement(3091, 1);
        this.bird1Moved = new VarbitRequirement(3098, 1);
        this.bird2Moved = new VarbitRequirement(3097, 1);
        this.bird3Moved = new VarbitRequirement(3095, 1);
        this.bird4Moved = new VarbitRequirement(3094, 1);
        this.bird5Moved = new VarbitRequirement(3096, 1);
        this.hasInsertedBronzeFeather = new VarbitRequirement(3108, 1);
        this.hasInsertedSilverFeather = new VarbitRequirement(3099, 6);
        this.hasInsertedGoldFeather = new VarbitRequirement(3107, 1);
        this.silverFeatherNearby = new ItemOnTileRequirement(this.silverFeather);
    }

    public void setupSteps() {
        this.speakToCharlie = new NpcStep((QuestHelper)this, 1495, new WorldPoint(2607, 3264, 0), "Speak to Charlie in the Ardougne Zoo.", new Requirement[0]);
        this.speakToCharlie.addTeleport(this.ardougneTeleport);
        this.speakToCharlie.addDialogSteps("Ah, you sound like someone who needs a quest doing!", "Sure.  Any idea where I should start looking?", "Yes.");
        this.inspectBooks = new ObjectStep((QuestHelper)this, 19787, new WorldPoint(2319, 3506, 0), "Go to the camp north of Eagles' Peak and search the pile of books for a Bird Book. The closest fairy ring is AKQ or teleport to The Outpost using the Necklace of Passage.", new Requirement[0]);
        this.inspectBooks.addTeleport(this.eaglesPeakTeleport);
        this.clickBook = new DetailedQuestStep((QuestHelper)this, "Click the Bird Book for a Metal Feather.", this.birdBook);
        this.inspectBooksForFeather = new ObjectStep((QuestHelper)this, 19886, new WorldPoint(2319, 3506, 0), "Go to the camp north of Eagles' Peak and search the pile of books to get the Metal Feather back.", new Requirement[0]);
        this.useFeatherOnDoor = new ObjectStep((QuestHelper)this, 19790, new WorldPoint(2329, 3495, 0), "Use the Metal Feather on the Rocky Outcrop on Eagles' Peak.", this.metalFeatherHighlighted);
        this.useFeatherOnDoor.addIcon(10174);
        this.enterPeak = new ObjectStep((QuestHelper)this, 19790, new WorldPoint(2329, 3495, 0), "Enter Eagles' Peak through the Rocky Outcrop.", new Requirement[0]);
        this.shoutAtNickolaus = new NpcStep((QuestHelper)this, 1484, new WorldPoint(2006, 4960, 3), "Shout to Nickolaus from across the chasm.", new Requirement[0]);
        this.shoutAtNickolaus.addDialogStep("The Ardougne zookeeper sent me to find you.");
        this.shoutAtNickolaus.addDialogStep("Well if you gave me a ferret I could take it back for you.");
        this.shoutAtNickolaus.addDialogStep("Could I help at all?");
        this.pickupFeathers = new ObjectStep((QuestHelper)this, 19922, new WorldPoint(2005, 4972, 3), "Pick up 10 Eagle feathers from the piles in the main cavern.", this.tenEagleFeathers);
        this.goToFancyStore = new NpcStep((QuestHelper)this, 2887, new WorldPoint(3281, 3398, 0), "Go speak to Asyff in south-east Varrock to have a disguise made.", this.yellowDye, this.coins, this.tar, this.tenEagleFeathers);
        this.goToFancyStore.addDialogStep("Well, specifically I'm after a couple of bird costumes.");
        this.goToFancyStore.addTeleport(this.varrockTeleport);
        this.speakAsyffAgain = new NpcStep((QuestHelper)this, 2887, new WorldPoint(3281, 3398, 0), "Speak to Asyff again.", this.yellowDye, this.coins, this.tar, this.tenEagleFeathers);
        this.speakAsyffAgain.addDialogStep("I've got the feathers and materials you requested.");
        this.speakAsyffAgain.addDialogStep("Okay, here are the materials. Eagle me up.");
        this.returnToEaglesPeak = new ObjectStep((QuestHelper)this, 19790, new WorldPoint(2329, 3495, 0), "Enter Eagles' Peak through the Rocky Outcrop.", this.fakeBeak, this.eagleCape);
        this.returnToEaglesPeak.addTeleport(this.eaglesPeakTeleport);
        this.enterEastCave = new ObjectStep((QuestHelper)this, 19897, new WorldPoint(2023, 4982, 3), "Enter the eastern cavern of Eagles' Peak.", new Requirement[0]);
        this.enterBronzeRoom = new ObjectStep((QuestHelper)this, 19909, new WorldPoint(1986, 4949, 3), "Enter the south-western cavern of Eagles' Peak.", new Requirement[0]);
        this.attemptToTakeBronzeFeather = new ObjectStep((QuestHelper)this, 19980, new WorldPoint(1974, 4915, 2), "Try to take the feather from the pedestal.", new Requirement[0]);
        this.winch1 = new ObjectStep((QuestHelper)this, 19976, new WorldPoint(1970, 4919, 2), "Use the winches in the corners of the room.", new Requirement[0]);
        this.winch2 = new ObjectStep((QuestHelper)this, 19977, new WorldPoint(1978, 4919, 2), "Use the winches in the corners of the room.", new Requirement[0]);
        this.winch3 = new ObjectStep((QuestHelper)this, 19978, new WorldPoint(1970, 4910, 2), "Use the winches in the corners of the room.", new Requirement[0]);
        this.winch4 = new ObjectStep((QuestHelper)this, 19979, new WorldPoint(1978, 4910, 2), "Use the winches in the corners of the room.", new Requirement[0]);
        this.grabBronzeFeather = new ObjectStep((QuestHelper)this, 19984, new WorldPoint(1974, 4915, 2), "Take the feather from the pedestal.", new Requirement[0]);
        this.enterMainCavernFromBronze = new ObjectStep((QuestHelper)this, 19906, new WorldPoint(1974, 4907, 2), "Return the main cavern.", new Requirement[0]);
        this.enterSilverRoom = new ObjectStep((QuestHelper)this, 19903, new WorldPoint(1986, 4972, 3), "Enter the north-western cavern of Eagles' Peak.", new Requirement[0]);
        this.inspectSilverPedestal = new ObjectStep((QuestHelper)this, 19974, new WorldPoint(1947, 4873, 2), "Inspect the Stone Pedestal here.", new Requirement[0]);
        this.enterMainCavernFromSilver = new ObjectStep((QuestHelper)this, 19900, new WorldPoint(1947, 4867, 2), "Return to the main cavern.", new Requirement[0]);
        this.inspectRocks1 = new ObjectStep((QuestHelper)this, 19969, new WorldPoint(1961, 4875, 2), "Inspect the rocks east of the pedestal.", new Requirement[0]);
        this.inspectRocks2 = new ObjectStep((QuestHelper)this, 19970, new WorldPoint(1967, 4879, 2), "Inspect the rocks north east of the last rock.", new Requirement[0]);
        this.inspectOpening = new ObjectStep((QuestHelper)this, 19967, new WorldPoint(1971, 4886, 2), "Inspect the opening north of the second rock.", new Requirement[0]);
        this.threatenKebbit = new NpcStep((QuestHelper)this, 1494, new WorldPoint(1971, 4880, 2), "Right-click threaten the Kebbit that appears. If the kebbit's gone, re-inspect the opening.", new Requirement[0]);
        this.threatenKebbit.addDialogStep("Taunt the kebbit.");
        this.pickupSilverFeather = new ObjectStep((QuestHelper)this, 19967, new WorldPoint(1971, 4886, 2), "Pick up the silver feather. If it's despawned, inspect the opening to get it.", new Requirement[0]);
        this.pickUpActualSilverFeather = new ItemStep((QuestHelper)this, "Pick up the silver feather.", this.silverFeather);
        this.enterGoldRoom = new ObjectStep((QuestHelper)this, 19897, new WorldPoint(2023, 4982, 3), "Enter the tunnel in the north east of the main cavern.", new Requirement[0]);
        this.collectFeed = new ObjectStep((QuestHelper)this, 19919, new WorldPoint(1958, 4906, 2), "Collect 6 birdseed from the Birdseed holder.", this.birdFeed6);
        this.pullLever1Down = new ObjectStep((QuestHelper)this, 19948, new WorldPoint(1943, 4911, 2), "Pull the lever west of the entrance down.", new Requirement[0]);
        this.pushLever1Up = new ObjectStep((QuestHelper)this, 19948, new WorldPoint(1943, 4911, 2), "Push the lever west of the entrance up.", new Requirement[0]);
        this.pullLever2Down = new ObjectStep((QuestHelper)this, 19949, new WorldPoint(1978, 4891, 2), "Pull the lever in the south east corner down.", new Requirement[0]);
        this.pullLever3Down = new ObjectStep((QuestHelper)this, 19946, new WorldPoint(1935, 4902, 2), "Pull the lever in the south west corner down.", new Requirement[0]);
        this.pullLever4Down = new ObjectStep((QuestHelper)this, 19947, new WorldPoint(1925, 4915, 2), "Pull the lever in the north west corner down.", new Requirement[0]);
        this.fillFeeder1 = new ObjectStep((QuestHelper)this, 19939, new WorldPoint(1966, 4890, 2), "Use the odd bird seed on the Bird feeder in the far south eastern corner.", this.birdFeed);
        this.fillFeeder1.addIcon(10178);
        this.fillFeeder2 = new ObjectStep((QuestHelper)this, 19938, new WorldPoint(1962, 4894, 2), "Use the odd bird seed on the marked Bird feeder.", this.birdFeed);
        this.fillFeeder2.addIcon(10178);
        this.fillFeeder3 = new ObjectStep((QuestHelper)this, 19943, new WorldPoint(1962, 4901, 2), "Use the odd bird seed on the marked Bird feeder, as you've moved the wrong bird.", this.birdFeed);
        this.fillFeeder3.addIcon(10178);
        this.fillFeeder4 = new ObjectStep((QuestHelper)this, 19937, new WorldPoint(1947, 4898, 2), "Put odd bird feed into the feeder in the north east of the room.", this.birdFeed);
        this.fillFeeder4.addIcon(10178);
        this.fillFeeder5 = new ObjectStep((QuestHelper)this, 19936, new WorldPoint(1945, 4915, 2), "Put odd bird feed into the feeder in the south of the room.", this.birdFeed);
        this.fillFeeder5.addIcon(10178);
        this.fillFeeder6 = new ObjectStep((QuestHelper)this, 19941, new WorldPoint(1935, 4897, 2), "Put odd bird feed into the feeder in the south west of the room", this.birdFeed);
        this.fillFeeder6.addIcon(10178);
        this.fillFeeder4Again = new ObjectStep((QuestHelper)this, 19937, new WorldPoint(1947, 4898, 2), "Put odd bird feed into the feeder in the south of the room.", this.birdFeed);
        this.fillFeeder4Again.addIcon(10178);
        this.fillFeeder7 = new ObjectStep((QuestHelper)this, 19940, new WorldPoint(1931, 4916, 2), "Put odd bird feed in the feeder in the north west of the room.", this.birdFeed);
        this.fillFeeder7.addIcon(10178);
        this.grabGoldFeather = new ObjectStep((QuestHelper)this, 19950, new WorldPoint(1928, 4907, 2), "Grab the Golden feather from the pedestal.", new Requirement[0]);
        this.enterMainCavernFromGold = new ObjectStep((QuestHelper)this, 19894, new WorldPoint(1957, 4909, 2), "Return to the main cavern.", new Requirement[0]);
        this.useFeathersOnStoneDoor = new ObjectStep((QuestHelper)this, 19991, new WorldPoint(2003, 4948, 3), "Use all three feathers on the door.", this.goldFeatherHighlighted, this.silverFeatherHighlighted, this.bronzeFeatherHighlighted);
        this.useFeathersOnStoneDoor.addIcon(2950);
        this.useBronzeFeathersOnStoneDoor = new ObjectStep((QuestHelper)this, 19991, new WorldPoint(2003, 4948, 3), "Use the bronze feather on the door.", this.bronzeFeatherHighlighted);
        this.useBronzeFeathersOnStoneDoor.addIcon(10177);
        this.useSilverFeathersOnStoneDoor = new ObjectStep((QuestHelper)this, 19991, new WorldPoint(2003, 4948, 3), "Use the silver feather on the door.", this.silverFeatherHighlighted);
        this.useSilverFeathersOnStoneDoor.addIcon(10176);
        this.useGoldFeathersOnStoneDoor = new ObjectStep((QuestHelper)this, 19991, new WorldPoint(2003, 4948, 3), "Use the golden feather on the door.", this.goldFeatherHighlighted);
        this.useGoldFeathersOnStoneDoor.addIcon(2950);
        this.useBronzeSilverFeathersOnStoneDoor = new ObjectStep((QuestHelper)this, 19991, new WorldPoint(2003, 4948, 3), "Use the bronze and silver feathers on the door.", this.silverFeatherHighlighted, this.bronzeFeatherHighlighted);
        this.useBronzeSilverFeathersOnStoneDoor.addIcon(10176);
        this.useGoldBronzeFeathersOnStoneDoor = new ObjectStep((QuestHelper)this, 19991, new WorldPoint(2003, 4948, 3), "Use the bronze and golden feathers on the door.", this.goldFeatherHighlighted, this.bronzeFeatherHighlighted);
        this.useGoldBronzeFeathersOnStoneDoor.addIcon(2950);
        this.useGoldSilverFeathersOnStoneDoor = new ObjectStep((QuestHelper)this, 19991, new WorldPoint(2003, 4948, 3), "Use the silver and golden feathers on the door.", this.goldFeatherHighlighted, this.silverFeatherHighlighted, this.bronzeFeatherHighlighted);
        this.useGoldSilverFeathersOnStoneDoor.addIcon(2950);
        this.sneakPastEagle = new NpcStep((QuestHelper)this, 1490, new WorldPoint(2008, 4955, 3), "Go through the feather door and sneak past the Eagle whilst wearing your eagle disguise.", this.fakeBeak.equipped(), this.eagleCape.equipped());
        this.speakToNickolaus = new NpcStep((QuestHelper)this, 1485, new WorldPoint(2006, 4960, 3), "Speak to Nickolaus.", this.fakeBeak, this.eagleCape);
        this.speakToNickolausInTheCamp = new NpcStep((QuestHelper)this, 1485, new WorldPoint(2317, 3504, 0), "Speak to Nickolaus in his camp north of Eagles' Peak.", new Requirement[0]);
        this.speakToNickolausInTheCamp.addDialogStep("Well I was originally sent to find you because of a ferret.");
        this.speakToNickolausInTheCamp.addDialogStep("That sounds good to me.");
        this.speakToCharlieAgain = new NpcStep((QuestHelper)this, 1495, new WorldPoint(2607, 3264, 0), "Bring the ferret back to Charlie in Ardougne Zoo.", this.ferret);
        this.speakToCharlieAgain.addTeleport(this.ardougneTeleport);
        this.leavePeak = new ObjectStep((QuestHelper)this, 19891, new WorldPoint(1993, 4983, 3), "Speak to Nickolaus in his camp north of Eagles' Peak.", new Requirement[0]);
        this.speakToNickolausInTheCamp.addSubSteps(this.leavePeak);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.yellowDye);
        reqs.add(this.coins);
        reqs.add(this.tar);
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.eaglesPeakTeleport.quantity(2));
        reqs.add(this.varrockTeleport);
        reqs.add(this.ardougneTeleport.quantity(2));
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.HUNTER, 2500));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Ability to use Box Traps"), new UnlockReward("Ability to use Eagle Transport System"), new UnlockReward("Ability to hunt Rabbits."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Start the quest", Collections.singletonList(this.speakToCharlie), null, Collections.singletonList(this.ardougneTeleport)));
        allSteps.add(new PanelDetails("Go to Eagles' Peak", Arrays.asList(this.inspectBooks, this.clickBook, this.useFeatherOnDoor), null, Collections.singletonList(this.eaglesPeakTeleport)));
        allSteps.add(new PanelDetails("In Eagles' Peak", Arrays.asList(this.enterPeak, this.shoutAtNickolaus, this.pickupFeathers), new Requirement[0]));
        allSteps.add(new PanelDetails("Make a disguise", Arrays.asList(this.goToFancyStore, this.speakAsyffAgain), Arrays.asList(this.yellowDye, this.coins, this.tar, this.tenEagleFeathers), Arrays.asList(this.varrockTeleport, this.eaglesPeakTeleport)));
        allSteps.add(new PanelDetails("Return to Eagles' Peak", Collections.singletonList(this.returnToEaglesPeak), Arrays.asList(this.fakeBeak, this.eagleCape), Collections.singletonList(this.eaglesPeakTeleport)));
        allSteps.add(new PanelDetails("Get the bronze feather", Arrays.asList(this.enterBronzeRoom, this.attemptToTakeBronzeFeather, this.winch1, this.grabBronzeFeather), new Requirement[0]));
        allSteps.add(new PanelDetails("Get the silver feather", Arrays.asList(this.enterSilverRoom, this.inspectSilverPedestal, this.inspectRocks1, this.inspectRocks2, this.inspectOpening, this.threatenKebbit, this.pickupSilverFeather), new Requirement[0]));
        allSteps.add(new PanelDetails("Get the golden feather", Arrays.asList(this.enterGoldRoom, this.collectFeed, this.pullLever1Down, this.fillFeeder1, this.fillFeeder2, this.pullLever2Down, this.pushLever1Up, this.fillFeeder4, this.pullLever3Down, this.fillFeeder5, this.pullLever4Down, this.fillFeeder6, this.fillFeeder4Again, this.grabGoldFeather), new Requirement[0]));
        allSteps.add(new PanelDetails("Free Nickolaus", Arrays.asList(this.useFeathersOnStoneDoor, this.sneakPastEagle, this.speakToNickolaus), new Requirement[0]));
        allSteps.add(new PanelDetails("Learn how to catch ferrets", Arrays.asList(this.speakToNickolausInTheCamp, this.speakToCharlieAgain), null, Collections.singletonList(this.ardougneTeleport)));
        return allSteps;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        return Collections.singletonList(new SkillRequirement(Skill.HUNTER, 27, true));
    }
}

