/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.dwarfcannon;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.DWARF_CANNON)
public class DwarfCannon
extends BasicQuestHelper {
    ItemRequirement staminas;
    ItemRequirement teleToAsg;
    ItemRequirement teleToKand;
    ItemRequirement hammer;
    ItemRequirement railing;
    ItemRequirement dwarfRemains;
    ItemRequirement toolkit;
    ItemRequirement cannonballMould;
    ItemRequirement nulodionsNotes;
    Requirement upTower1;
    Requirement upTower2;
    Requirement inCave;
    Requirement bar1;
    Requirement bar2;
    Requirement bar3;
    Requirement bar4;
    Requirement bar5;
    Requirement bar6;
    Requirement nearLawgof;
    Requirement springFixed;
    Requirement safetyFixed;
    Requirement cannonFixed;
    QuestStep talkToCaptainLawgof;
    QuestStep talkToCaptainLawgof2;
    QuestStep gotoTower;
    QuestStep goToTower2;
    QuestStep talkToCaptainLawgof3;
    QuestStep gotoCave;
    QuestStep inspectRailings1;
    QuestStep inspectRailings2;
    QuestStep inspectRailings3;
    QuestStep inspectRailings4;
    QuestStep inspectRailings5;
    QuestStep inspectRailings6;
    QuestStep getRemainsStep;
    QuestStep downTower;
    QuestStep downTower2;
    QuestStep searchCrates;
    QuestStep talkToCaptainLawgof4;
    QuestStep useToolkit;
    QuestStep talkToCaptainLawgof5;
    QuestStep talkToNulodion;
    QuestStep talkToCaptainLawgof6;
    Zone cave;
    Zone tower1;
    Zone tower2;
    Zone lawgofArea;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToCaptainLawgof);
        ConditionalStep fixedRailings = new ConditionalStep((QuestHelper)this, this.inspectRailings1, new Requirement[0]);
        fixedRailings.addStep(new Conditions(this.bar6), this.talkToCaptainLawgof2);
        fixedRailings.addStep(new Conditions(this.hammer, this.railing, this.bar5), this.inspectRailings6);
        fixedRailings.addStep(new Conditions(this.hammer, this.railing, this.bar4), this.inspectRailings5);
        fixedRailings.addStep(new Conditions(this.hammer, this.railing, this.bar3), this.inspectRailings4);
        fixedRailings.addStep(new Conditions(this.hammer, this.railing, this.bar2), this.inspectRailings3);
        fixedRailings.addStep(new Conditions(this.hammer, this.railing, this.bar1), this.inspectRailings2);
        steps.put(1, fixedRailings);
        ConditionalStep getRemains = new ConditionalStep((QuestHelper)this, this.gotoTower, new Requirement[0]);
        getRemains.addStep(new Conditions(this.dwarfRemains, this.nearLawgof), this.talkToCaptainLawgof3);
        getRemains.addStep(new Conditions(this.dwarfRemains, this.upTower1), this.downTower2);
        getRemains.addStep(new Conditions(this.dwarfRemains, this.upTower2), this.downTower);
        getRemains.addStep(this.upTower2, this.getRemainsStep);
        getRemains.addStep(this.upTower1, this.goToTower2);
        steps.put(2, getRemains);
        steps.put(3, getRemains);
        ConditionalStep findLollk = new ConditionalStep((QuestHelper)this, this.gotoCave, new Requirement[0]);
        findLollk.addStep(this.inCave, this.searchCrates);
        steps.put(4, findLollk);
        steps.put(5, findLollk);
        steps.put(6, this.talkToCaptainLawgof4);
        steps.put(7, this.useToolkit);
        steps.put(8, this.talkToCaptainLawgof5);
        ConditionalStep captainLawgofFinal = new ConditionalStep((QuestHelper)this, this.talkToNulodion, new Requirement[0]);
        captainLawgofFinal.addStep(new Conditions(this.nulodionsNotes, this.cannonballMould), this.talkToCaptainLawgof6);
        steps.put(9, captainLawgofFinal);
        steps.put(10, captainLawgofFinal);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.staminas = new ItemRequirement("Stamina Potions", ItemCollections.STAMINA_POTIONS);
        this.teleToAsg = new ItemRequirement("Teleport to Falador, Amulet of Glory, or Combat Bracelet", 8009);
        this.teleToAsg.addAlternates(ItemCollections.AMULET_OF_GLORIES);
        this.teleToAsg.addAlternates(ItemCollections.COMBAT_BRACELETS);
        this.teleToKand = new ItemRequirement("Teleport to Ardougne, Skills Necklace, or Games Necklace", ItemCollections.GAMES_NECKLACES);
        this.teleToKand.addAlternates(ItemCollections.SKILLS_NECKLACES);
        this.teleToKand.addAlternates(8011);
        this.hammer = new ItemRequirement("Hammer", ItemCollections.HAMMER).isNotConsumed();
        this.railing = new ItemRequirement("Railing", 14);
        this.railing.setTooltip("You can get more from Captain Lawgof");
        this.toolkit = new ItemRequirement("Toolkit", 1);
        this.toolkit.setHighlightInInventory(true);
        this.dwarfRemains = new ItemRequirement("Dwarf Remains", 0);
        this.cannonballMould = new ItemRequirement("Cannonball Mould", 4);
        this.nulodionsNotes = new ItemRequirement("Nulodion's Notes", 3);
    }

    public void setupConditions() {
        this.bar1 = new VarbitRequirement(2240, 1);
        this.bar2 = new VarbitRequirement(2241, 1);
        this.bar3 = new VarbitRequirement(2242, 1);
        this.bar4 = new VarbitRequirement(2243, 1);
        this.bar5 = new VarbitRequirement(2244, 1);
        this.bar6 = new VarbitRequirement(2245, 1);
        this.springFixed = new VarbitRequirement(2239, 1);
        this.safetyFixed = new VarbitRequirement(2238, 1);
        this.cannonFixed = new VarbitRequirement(2235, 1);
        this.upTower1 = new ZoneRequirement(this.tower1);
        this.upTower2 = new ZoneRequirement(this.tower2);
        this.inCave = new ZoneRequirement(this.cave);
        this.nearLawgof = new ZoneRequirement(this.lawgofArea);
    }

    public void setupZones() {
        this.cave = new Zone(new WorldPoint(2557, 9790, 0), new WorldPoint(2624, 9859, 0));
        this.tower1 = new Zone(new WorldPoint(2568, 3439, 1), new WorldPoint(2572, 3445, 1));
        this.tower2 = new Zone(new WorldPoint(2566, 3445, 2), new WorldPoint(2572, 3441, 2));
        this.lawgofArea = new Zone(new WorldPoint(2551, 3477, 0), new WorldPoint(2595, 3434, 0));
    }

    public void setupSteps() {
        this.talkToCaptainLawgof = new NpcStep((QuestHelper)this, 5191, new WorldPoint(2567, 3460, 0), "Talk to Captain Lawgof near the Coal Truck Mining Site (north of Fishing Guild, West of McGrubor's Wood).", new Requirement[0]);
        this.talkToCaptainLawgof.addDialogStep("Sure, I'd be honoured to join.");
        this.inspectRailings1 = new ObjectStep((QuestHelper)this, 15590, new WorldPoint(2555, 3479, 0), "Inspect the 6 damaged railings around the  camp to fix them.", this.hammer, this.railing);
        this.inspectRailings2 = new ObjectStep((QuestHelper)this, 15591, new WorldPoint(2557, 3468, 0), "Inspect the railings to fix them.", this.hammer, this.railing);
        this.inspectRailings3 = new ObjectStep((QuestHelper)this, 15592, new WorldPoint(2559, 3458, 0), "Inspect the railings to fix them.", this.hammer, this.railing);
        this.inspectRailings4 = new ObjectStep((QuestHelper)this, 15593, new WorldPoint(2563, 3457, 0), "Inspect the railings to fix them.", this.hammer, this.railing);
        this.inspectRailings5 = new ObjectStep((QuestHelper)this, 15594, new WorldPoint(2573, 3457, 0), "Inspect the railings to fix them.", this.hammer, this.railing);
        this.inspectRailings6 = new ObjectStep((QuestHelper)this, 15595, new WorldPoint(2577, 3457, 0), "Inspect the railings to fix them.", this.hammer, this.railing);
        this.inspectRailings1.addSubSteps(this.inspectRailings2, this.inspectRailings3, this.inspectRailings4, this.inspectRailings5, this.inspectRailings6);
        this.talkToCaptainLawgof2 = new NpcStep((QuestHelper)this, 5191, new WorldPoint(2567, 3460, 0), "Talk to Captain Lawgof again.  Make sure to complete the entire dialogue.", new Requirement[0]);
        this.gotoTower = new ObjectStep((QuestHelper)this, 16683, new WorldPoint(2570, 3441, 0), "Go to the top floor of the tower south of Captain Lawgof and get the remains there.", new Requirement[0]);
        this.goToTower2 = new ObjectStep((QuestHelper)this, 11, new WorldPoint(2570, 3443, 1), "Go up the second ladder.", new Requirement[0]);
        this.getRemainsStep = new ObjectStep((QuestHelper)this, 0, new WorldPoint(2567, 3444, 2), "Get the dwarf remains at the top of the tower.", new Requirement[0]);
        this.gotoTower.addSubSteps(this.goToTower2, this.getRemainsStep);
        this.downTower = new ObjectStep((QuestHelper)this, 16679, new WorldPoint(2570, 3443, 2), "Go down the first ladder.", new Requirement[0]);
        this.downTower2 = new ObjectStep((QuestHelper)this, 16679, new WorldPoint(2570, 3441, 1), "Go down the second ladder.", new Requirement[0]);
        this.talkToCaptainLawgof3 = new NpcStep((QuestHelper)this, 5191, new WorldPoint(2567, 3460, 0), "Return the remains to Captain Lawgof.", new Requirement[0]);
        this.talkToCaptainLawgof3.addSubSteps(this.downTower, this.downTower2);
        this.gotoCave = new ObjectStep((QuestHelper)this, 2, new WorldPoint(2624, 3393, 0), "Go to the cave entrance east of the Fishing Guild door.", new Requirement[0]);
        this.searchCrates = new ObjectStep((QuestHelper)this, 1, new WorldPoint(2571, 9850, 0), "Search the crates in the north west corner to find Lollk.", new Requirement[0]);
        this.talkToCaptainLawgof4 = new NpcStep((QuestHelper)this, 5191, new WorldPoint(2567, 3460, 0), "Return to Captain Lawgof.", new Requirement[0]);
        this.talkToCaptainLawgof4.addDialogStep("Okay, I'll see what I can do.");
        this.useToolkit = new ObjectStep((QuestHelper)this, 15597, new WorldPoint(2563, 3462, 0), "Use the toolkit on the broken multicannon.  Use the right tool on the spring, the middle tool on the Safety switch, and the left tool on the gear.", new Requirement[0]);
        this.useToolkit.addIcon(1);
        this.talkToCaptainLawgof5 = new NpcStep((QuestHelper)this, 5191, new WorldPoint(2567, 3460, 0), "Talk to Captain Lawgof (There will be a short pause in dialogue.  Both need to be completed.).", new Requirement[0]);
        this.talkToCaptainLawgof5.addDialogStep("Okay then, just for you!");
        this.talkToNulodion = new NpcStep((QuestHelper)this, 1400, new WorldPoint(3012, 3453, 0), "Go talk to Nulodion at the Dwarven Black Guard camp (north-east of Falador, South of Ice Mountain).", new Requirement[0]);
        this.talkToCaptainLawgof6 = new NpcStep((QuestHelper)this, 5191, new WorldPoint(2567, 3460, 0), "Finally, return to Captain Lawgof with the ammo mould and Nulodion's Notes.", this.nulodionsNotes, this.cannonballMould);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.staminas);
        reqs.add(this.teleToAsg);
        reqs.add(this.teleToKand);
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.CRAFTING, 750));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Ability to purchase and use the Dwarf Multicannon."), new UnlockReward("Ability to make cannonballs."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Collections.singletonList(this.talkToCaptainLawgof), new Requirement[0]));
        allSteps.add(new PanelDetails("Repair and Retrieval", Arrays.asList(this.inspectRailings1, this.talkToCaptainLawgof2, this.gotoTower, this.talkToCaptainLawgof3), new Requirement[0]));
        allSteps.add(new PanelDetails("Find Lollk and Fix Cannon", Arrays.asList(this.gotoCave, this.searchCrates, this.talkToCaptainLawgof4, this.useToolkit, this.talkToCaptainLawgof5), new Requirement[0]));
        allSteps.add(new PanelDetails("Get Ammo Mould", Arrays.asList(this.talkToNulodion, this.talkToCaptainLawgof6), new Requirement[0]));
        return allSteps;
    }
}

