/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.druidicritual;

import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.DRUIDIC_RITUAL)
public class DruidicRitual
extends BasicQuestHelper {
    ItemRequirement rawRat;
    ItemRequirement rawBear;
    ItemRequirement rawBeef;
    ItemRequirement rawChicken;
    ItemRequirement rawRatHighlighted;
    ItemRequirement rawBearHighlighted;
    ItemRequirement rawBeefHighlighted;
    ItemRequirement rawChickenHighlighted;
    ItemRequirement enchantedBear;
    ItemRequirement enchantedBeef;
    ItemRequirement enchantedChicken;
    ItemRequirement enchantedRat;
    Requirement inDungeon;
    Requirement inSanfewRoom;
    QuestStep talkToKaqemeex;
    QuestStep goUpToSanfew;
    QuestStep talkToSanfew;
    QuestStep enterDungeon;
    QuestStep enchantMeats;
    QuestStep useRatOnCauldron;
    QuestStep useBeefOnCauldron;
    QuestStep useBearOnCauldron;
    QuestStep useChickenOnCauldron;
    QuestStep goUpToSanfewWithMeat;
    QuestStep talkToSanfewWithMeat;
    QuestStep talkToKaqemeexToFinish;
    Zone dungeon;
    Zone sanfewRoom;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToKaqemeex);
        ConditionalStep goTalkToSanfew = new ConditionalStep((QuestHelper)this, this.goUpToSanfew, new Requirement[0]);
        goTalkToSanfew.addStep(this.inSanfewRoom, this.talkToSanfew);
        steps.put(1, goTalkToSanfew);
        ConditionalStep prepareMeats = new ConditionalStep((QuestHelper)this, this.enterDungeon, new Requirement[0]);
        prepareMeats.addStep(new Conditions(this.inSanfewRoom, this.enchantedRat, this.enchantedBear, this.enchantedBeef, this.enchantedChicken), this.talkToSanfewWithMeat);
        prepareMeats.addStep(new Conditions(this.enchantedRat, this.enchantedBear, this.enchantedBeef, this.enchantedChicken), this.goUpToSanfewWithMeat);
        prepareMeats.addStep(new Conditions(this.inDungeon, this.enchantedRat, this.enchantedBear, this.enchantedBeef), this.useChickenOnCauldron);
        prepareMeats.addStep(new Conditions(this.inDungeon, this.enchantedRat, this.enchantedBear), this.useBeefOnCauldron);
        prepareMeats.addStep(new Conditions(this.inDungeon, this.enchantedRat), this.useBearOnCauldron);
        prepareMeats.addStep(this.inDungeon, this.useRatOnCauldron);
        steps.put(2, prepareMeats);
        steps.put(3, this.talkToKaqemeexToFinish);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.rawRat = new ItemRequirement("Raw rat meat", 2134);
        this.rawRat.addAlternates(523);
        this.rawBear = new ItemRequirement("Raw bear meat", 2136);
        this.rawBear.addAlternates(524);
        this.rawBeef = new ItemRequirement("Raw beef", 2132);
        this.rawBeef.addAlternates(522);
        this.rawChicken = new ItemRequirement("Raw chicken", 2138);
        this.rawChicken.addAlternates(525);
        this.rawRatHighlighted = new ItemRequirement("Raw rat meat", 2134);
        this.rawRatHighlighted.setHighlightInInventory(true);
        this.rawBearHighlighted = new ItemRequirement("Raw bear meat", 2136);
        this.rawBearHighlighted.setHighlightInInventory(true);
        this.rawBeefHighlighted = new ItemRequirement("Raw beef", 2132);
        this.rawBeefHighlighted.setHighlightInInventory(true);
        this.rawChickenHighlighted = new ItemRequirement("Raw chicken", 2138);
        this.rawChickenHighlighted.setHighlightInInventory(true);
        this.enchantedBear = new ItemRequirement("Enchanted bear", 524);
        this.enchantedBeef = new ItemRequirement("Enchanted beef", 522);
        this.enchantedChicken = new ItemRequirement("Enchanted chicken", 525);
        this.enchantedRat = new ItemRequirement("Enchanted rat", 523);
    }

    public void loadZones() {
        this.sanfewRoom = new Zone(new WorldPoint(2893, 3423, 1), new WorldPoint(2903, 3433, 1));
        this.dungeon = new Zone(new WorldPoint(2816, 9668, 0), new WorldPoint(2973, 9855, 0));
    }

    public void setupConditions() {
        this.inSanfewRoom = new ZoneRequirement(this.sanfewRoom);
        this.inDungeon = new ZoneRequirement(this.dungeon);
    }

    public void setupSteps() {
        this.talkToKaqemeex = new NpcStep((QuestHelper)this, 5045, new WorldPoint(2925, 3486, 0), "Talk to Kaqemeex in the Druid Circle in Taverley.", new Requirement[0]);
        this.talkToKaqemeex.addDialogSteps("I'm in search of a quest.", "Okay, I will try and help.");
        this.goUpToSanfew = new ObjectStep((QuestHelper)this, 16671, new WorldPoint(2899, 3429, 0), "Talk to Sanfew upstairs in the Taverley herblore store.", new Requirement[0]);
        this.talkToSanfew = new NpcStep((QuestHelper)this, 5044, new WorldPoint(2899, 3429, 1), "Talk to Sanfew upstairs in the Taverley herblore store.", new Requirement[0]);
        this.talkToSanfew.addDialogStep("I've been sent to help purify the Varrock stone circle.");
        this.talkToSanfew.addSubSteps(this.goUpToSanfew);
        this.enterDungeon = new ObjectStep((QuestHelper)this, 16680, new WorldPoint(2884, 3397, 0), "Enter Taverley Dungeon south of Taverley.", this.rawBear, this.rawBeef, this.rawChicken, this.rawRat);
        this.enterDungeon.addDialogStep("Ok, I'll do that then.");
        this.useRatOnCauldron = new ObjectStep((QuestHelper)this, 2142, new WorldPoint(2893, 9831, 0), "Use the rat meat on the cauldron. To enter the room, spam-click the gate to get in.", this.rawRatHighlighted);
        this.useRatOnCauldron.addIcon(2134);
        this.useBeefOnCauldron = new ObjectStep((QuestHelper)this, 2142, new WorldPoint(2893, 9831, 0), "Use the beef meat on the cauldron. To enter the room, spam-click the gate to get in.", this.rawBeefHighlighted);
        this.useBeefOnCauldron.addIcon(2132);
        this.useBearOnCauldron = new ObjectStep((QuestHelper)this, 2142, new WorldPoint(2893, 9831, 0), "Use the bear meat on the cauldron. To enter the room, spam-click the gate to get in.", this.rawBearHighlighted);
        this.useBearOnCauldron.addIcon(2136);
        this.useChickenOnCauldron = new ObjectStep((QuestHelper)this, 2142, new WorldPoint(2893, 9831, 0), "Use the chicken meat on the cauldron. To enter the room, spam-click the gate to get in.", this.rawChickenHighlighted);
        this.useChickenOnCauldron.addIcon(2138);
        this.enchantMeats = new ObjectStep((QuestHelper)this, 2142, new WorldPoint(2893, 9831, 0), "Use the four meats on the cauldron. To enter the room, spam-click the gate to get in.", new Requirement[0]);
        this.enchantMeats.addSubSteps(this.useRatOnCauldron, this.useChickenOnCauldron, this.useBeefOnCauldron, this.useBearOnCauldron);
        this.goUpToSanfewWithMeat = new ObjectStep((QuestHelper)this, 16671, new WorldPoint(2899, 3429, 0), "Bring the enchanted meats to Sanfew upstairs in the Taverley herblore store.", this.enchantedBear, this.enchantedBeef, this.enchantedChicken, this.enchantedRat);
        this.talkToSanfewWithMeat = new NpcStep((QuestHelper)this, 5044, new WorldPoint(2899, 3429, 1), "Bring the enchanted meats to Sanfew upstairs in the Taverley herblore store.", this.enchantedBear, this.enchantedBeef, this.enchantedChicken, this.enchantedRat);
        this.talkToSanfewWithMeat.addSubSteps(this.goUpToSanfewWithMeat);
        this.talkToKaqemeexToFinish = new NpcStep((QuestHelper)this, 5045, new WorldPoint(2925, 3486, 0), "Return to Kaqemeex in the Druid Circle to finish the quest.", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.rawBear, this.rawBeef, this.rawChicken, this.rawRat);
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(4);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.HERBLORE, 250));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Access to the Herblore Skill"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Helping the druids", Arrays.asList(this.talkToKaqemeex, this.talkToSanfew, this.enterDungeon, this.enchantMeats, this.talkToSanfewWithMeat, this.talkToKaqemeexToFinish), this.rawBear, this.rawBeef, this.rawChicken, this.rawRat));
        return allSteps;
    }
}

