/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.dreammentor;

import com.questhelper.QuestHelperPlugin;
import com.questhelper.helpers.quests.dreammentor.CyrisusArmourSet;
import com.questhelper.helpers.quests.dreammentor.CyrisusBankItem;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.steps.QuestStep;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;

public class SelectingCombatGear
extends QuestStep {
    ArrayList<Widget> itemsToHighlight;

    public SelectingCombatGear(QuestHelper questHelper) {
        super(questHelper, "Take the marked items out of the bank.");
    }

    @Override
    public void startUp() {
        this.updateItems();
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.updateItems();
    }

    protected void updateItems() {
        Widget[] bankItems;
        ArrayList<Widget> newItemsToHighlight = new ArrayList<Widget>();
        Widget bankWidget = this.client.getWidget(260, 42);
        if (bankWidget != null && (bankItems = bankWidget.getChildren()) != null && bankItems.length > 0) {
            for (Widget bankItem : bankItems) {
                for (CyrisusBankItem item : CyrisusArmourSet.getCorrectSet(this.client).getItems()) {
                    if (item.getWidgetID() != bankItem.getItemId()) continue;
                    newItemsToHighlight.add(bankItem);
                }
            }
            this.itemsToHighlight = newItemsToHighlight;
        }
    }

    @Override
    public void makeWidgetOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        super.makeWidgetOverlayHint(graphics, plugin);
        if (this.itemsToHighlight.size() > 0) {
            for (Widget widget : this.itemsToHighlight) {
                graphics.setColor(new Color(this.questHelper.getConfig().targetOverlayColor().getRed(), this.questHelper.getConfig().targetOverlayColor().getGreen(), this.questHelper.getConfig().targetOverlayColor().getBlue(), 65));
                graphics.fill(widget.getBounds());
                graphics.setColor(this.questHelper.getConfig().targetOverlayColor());
                graphics.draw(widget.getBounds());
            }
        }
    }
}

