/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.dreammentor;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.helpers.quests.dreammentor.CyrisusBankConditional;
import com.questhelper.helpers.quests.dreammentor.SelectingCombatGear;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.CombatLevelRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.widget.WidgetTextRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.DREAM_MENTOR)
public class DreamMentor
extends BasicQuestHelper {
    ItemRequirement sealOfPassage;
    ItemRequirement dreamVial;
    ItemRequirement astralRune;
    ItemRequirement astralRuneShards;
    ItemRequirement groundAstralRune;
    ItemRequirement dreamVialWater;
    ItemRequirement dreamVialWithGoutweed;
    ItemRequirement pestleAndMortar;
    ItemRequirement dreamPotion;
    ItemRequirement foodAll1;
    ItemRequirement foodAll2;
    ItemRequirement foodAll3;
    ItemRequirement food4;
    ItemRequirement food6;
    ItemRequirement goutweed;
    ItemRequirement tinderbox;
    ItemRequirement hammer;
    ItemRequirement combatGear;
    ItemRequirement food14;
    ItemRequirement chest;
    ItemRequirement lunarIsleTeleport;
    ItemRequirement stamina;
    Requirement inLunarMine;
    Requirement inCyrisusRoom;
    Requirement at40Health;
    Requirement at70Health;
    Requirement lookingAtBank;
    Requirement gotItems;
    Requirement cyrisusDressed;
    Requirement at100Health;
    Requirement litBrazier;
    Requirement inArena;
    Requirement unlockedDream;
    Requirement inadaquacyNearby;
    Requirement everlastingNearby;
    Requirement untouchableNearby;
    Requirement illusiveNearby;
    QuestStep goDownToCyrisus;
    QuestStep enterCyrisusCave;
    QuestStep talkToCyrisus;
    QuestStep feed4Food;
    QuestStep talkToCyrisus2;
    QuestStep feed4Food2;
    QuestStep talkToCyrisus3;
    QuestStep feed6Food;
    QuestStep talkToCyrisus4;
    QuestStep leaveCave;
    QuestStep goUpToSurface;
    QuestStep talkToJack;
    QuestStep selectEquipment;
    QuestStep goBackDownToCyrisus;
    QuestStep enterCyrisusCaveAgain;
    QuestStep giveCyrisusGear;
    QuestStep useFood3;
    QuestStep goBackDownAfterGearing;
    QuestStep talkAfterHelping;
    QuestStep supportCyrisusToRecovery;
    QuestStep talkToOneiromancer;
    QuestStep fillVialWithWater;
    QuestStep addGoutweed;
    QuestStep useHammerOnAstralRune;
    QuestStep usePestleOnShards;
    QuestStep useGroundAstralOnVial;
    QuestStep lightBrazier;
    QuestStep talkToCyrisusForDream;
    QuestStep killInadaquacy;
    QuestStep killEverlasting;
    QuestStep killUntouchable;
    QuestStep killIllusive;
    QuestStep returnToOneiromancer;
    Zone lunarMine;
    Zone cyrisusRoom;
    Zone arena;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep startQuest = new ConditionalStep((QuestHelper)this, this.goDownToCyrisus, new Requirement[0]);
        startQuest.addStep(this.inCyrisusRoom, this.talkToCyrisus);
        startQuest.addStep(this.inLunarMine, this.enterCyrisusCave);
        steps.put(0, startQuest);
        steps.put(2, startQuest);
        ConditionalStep firstFeeding = new ConditionalStep((QuestHelper)this, this.goDownToCyrisus, new Requirement[0]);
        firstFeeding.addStep(this.inCyrisusRoom, this.feed4Food);
        firstFeeding.addStep(this.inLunarMine, this.enterCyrisusCave);
        steps.put(4, firstFeeding);
        ConditionalStep talkToCyrisusSteps = new ConditionalStep((QuestHelper)this, this.goDownToCyrisus, new Requirement[0]);
        talkToCyrisusSteps.addStep(this.inCyrisusRoom, this.talkToCyrisus2);
        talkToCyrisusSteps.addStep(this.inLunarMine, this.enterCyrisusCave);
        steps.put(6, talkToCyrisusSteps);
        ConditionalStep feedPhase2 = new ConditionalStep((QuestHelper)this, this.goDownToCyrisus, new Requirement[0]);
        feedPhase2.addStep(new Conditions(this.inCyrisusRoom, this.at40Health), this.talkToCyrisus3);
        feedPhase2.addStep(this.inCyrisusRoom, this.feed4Food2);
        feedPhase2.addStep(this.inLunarMine, this.enterCyrisusCave);
        steps.put(8, feedPhase2);
        steps.put(10, feedPhase2);
        ConditionalStep feedPhase3 = new ConditionalStep((QuestHelper)this, this.goDownToCyrisus, new Requirement[0]);
        feedPhase3.addStep(new Conditions(this.inCyrisusRoom, this.at70Health), this.talkToCyrisus4);
        feedPhase3.addStep(this.inCyrisusRoom, this.feed6Food);
        feedPhase3.addStep(this.inLunarMine, this.enterCyrisusCave);
        steps.put(12, feedPhase3);
        steps.put(14, feedPhase3);
        ConditionalStep goGetArmour = new ConditionalStep((QuestHelper)this, this.talkToJack, new Requirement[0]);
        goGetArmour.addStep(new Conditions(this.inCyrisusRoom, this.cyrisusDressed, this.at100Health), this.supportCyrisusToRecovery);
        goGetArmour.addStep(new Conditions(this.inLunarMine, this.cyrisusDressed, this.at100Health), this.enterCyrisusCaveAgain);
        goGetArmour.addStep(new Conditions(this.cyrisusDressed, this.at100Health), this.goBackDownAfterGearing);
        goGetArmour.addStep(new Conditions(this.inCyrisusRoom, this.cyrisusDressed), this.useFood3);
        goGetArmour.addStep(new Conditions(this.inLunarMine, this.cyrisusDressed), this.enterCyrisusCaveAgain);
        goGetArmour.addStep(new Conditions(this.cyrisusDressed), this.goBackDownAfterGearing);
        goGetArmour.addStep(new Conditions(this.inCyrisusRoom, this.gotItems), this.giveCyrisusGear);
        goGetArmour.addStep(new Conditions(this.inLunarMine, this.gotItems), this.enterCyrisusCaveAgain);
        goGetArmour.addStep(this.gotItems, this.goBackDownToCyrisus);
        goGetArmour.addStep(this.lookingAtBank, this.selectEquipment);
        goGetArmour.addStep(this.inCyrisusRoom, this.leaveCave);
        goGetArmour.addStep(this.inLunarMine, this.goUpToSurface);
        steps.put(16, goGetArmour);
        steps.put(18, this.talkAfterHelping);
        steps.put(20, this.talkToOneiromancer);
        steps.put(22, this.talkToOneiromancer);
        ConditionalStep enterDream = new ConditionalStep((QuestHelper)this, this.fillVialWithWater, new Requirement[0]);
        enterDream.addStep(new Conditions(this.inArena, this.illusiveNearby), this.killIllusive);
        enterDream.addStep(new Conditions(this.inArena, this.untouchableNearby), this.killUntouchable);
        enterDream.addStep(new Conditions(this.inArena, this.everlastingNearby), this.killEverlasting);
        enterDream.addStep(new Conditions(this.inArena, this.inadaquacyNearby), this.killInadaquacy);
        enterDream.addStep(this.inArena, this.killIllusive);
        enterDream.addStep(new Conditions(this.litBrazier, new Conditions(LogicType.OR, this.dreamPotion, this.unlockedDream)), this.talkToCyrisusForDream);
        enterDream.addStep(new Conditions(LogicType.OR, this.unlockedDream, this.dreamPotion), this.lightBrazier);
        enterDream.addStep(new Conditions(this.dreamVialWithGoutweed, this.groundAstralRune), this.useGroundAstralOnVial);
        enterDream.addStep(new Conditions(this.dreamVialWithGoutweed, this.astralRuneShards), this.usePestleOnShards);
        enterDream.addStep(this.dreamVialWithGoutweed, this.useHammerOnAstralRune);
        enterDream.addStep(this.dreamVialWater, this.addGoutweed);
        steps.put(24, enterDream);
        steps.put(26, this.returnToOneiromancer);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.sealOfPassage = new ItemRequirement("Seal of passage", 9083).isNotConsumed();
        this.dreamVial = new ItemRequirement("Dream vial (empty)", 11151);
        this.dreamVial.setHighlightInInventory(true);
        this.astralRune = new ItemRequirement("Astral rune", 9075);
        this.astralRune.setHighlightInInventory(true);
        this.astralRuneShards = new ItemRequirement("Astral rune shards", 11156);
        this.astralRuneShards.setHighlightInInventory(true);
        this.groundAstralRune = new ItemRequirement("Ground astral rune", 11155);
        this.groundAstralRune.setHighlightInInventory(true);
        this.dreamVialWater = new ItemRequirement("Dream vial (water)", 11152);
        this.dreamVialWater.setHighlightInInventory(true);
        this.dreamVialWithGoutweed = new ItemRequirement("Dream vial (herb)", 11153);
        this.dreamVialWithGoutweed.setHighlightInInventory(true);
        this.pestleAndMortar = new ItemRequirement("Pestle and mortar", 233).isNotConsumed();
        this.pestleAndMortar.setHighlightInInventory(true);
        this.hammer = new ItemRequirement("Hammer", ItemCollections.HAMMER).isNotConsumed();
        this.hammer.setHighlightInInventory(true);
        this.goutweed = new ItemRequirement("Goutweed", 3261);
        this.goutweed.setTooltip("You can get one from the Troll Kitchen's Storeroom in Trollheim");
        this.goutweed.setHighlightInInventory(true);
        this.dreamPotion = new ItemRequirement("Dream potion", 11154);
        this.foodAll1 = new ItemRequirement("some type of food", -1, 7);
        this.foodAll1.setDisplayItemId(BankSlotIcons.getFood());
        this.foodAll2 = new ItemRequirement("some other type of food", -1, 7);
        this.foodAll2.setDisplayItemId(BankSlotIcons.getFood());
        this.foodAll3 = new ItemRequirement("a third type of food", -1, 6);
        this.foodAll3.setDisplayItemId(BankSlotIcons.getFood());
        this.food14 = new ItemRequirement("food: 5x some type food, 5x some other type of food, 4x a third type of food", -1, 14);
        this.food14.setDisplayItemId(BankSlotIcons.getFood());
        this.food4 = new ItemRequirement("food: 1x some type of food, 1x some other type of food, 2x a third type of food", -1, 4);
        this.food4.setDisplayItemId(BankSlotIcons.getFood());
        this.food6 = new ItemRequirement("food: 2x some type of food, 2x some other type of food, 2x a third type of food", -1, 6);
        this.food6.setDisplayItemId(BankSlotIcons.getFood());
        this.tinderbox = new ItemRequirement("Tinderbox", 590);
        this.chest = new ItemRequirement("Cyrisus's chest", 11158);
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.lunarIsleTeleport = new ItemRequirement("Lunar isle teleport", 12405);
        this.stamina = new ItemRequirement("Stamina potion", ItemCollections.STAMINA_POTIONS);
    }

    public void loadZones() {
        this.lunarMine = new Zone(new WorldPoint(2300, 10313, 2), new WorldPoint(2370, 10354, 2));
        this.cyrisusRoom = new Zone(new WorldPoint(2337, 10356, 2), new WorldPoint(2350, 10363, 2));
        this.arena = new Zone(new WorldPoint(1806, 5135, 2), new WorldPoint(1840, 5167, 2));
    }

    public void setupConditions() {
        this.inLunarMine = new ZoneRequirement(this.lunarMine);
        this.inCyrisusRoom = new ZoneRequirement(this.cyrisusRoom);
        this.inArena = new ZoneRequirement(this.arena);
        this.at40Health = new VarbitRequirement(3621, 40, Operation.GREATER_EQUAL);
        this.at70Health = new VarbitRequirement(3621, 70, Operation.GREATER_EQUAL);
        this.at100Health = new VarbitRequirement(3621, 100, Operation.GREATER_EQUAL);
        this.lookingAtBank = new WidgetTextRequirement(260, 41, "Cyrisus's Bank");
        this.gotItems = new CyrisusBankConditional();
        this.cyrisusDressed = new VarbitRequirement(3623, 100);
        this.litBrazier = new VarbitRequirement(2430, 1);
        this.unlockedDream = new VarbitRequirement(3625, 1);
        this.inadaquacyNearby = new NpcCondition(3473);
        this.everlastingNearby = new NpcCondition(3474);
        this.untouchableNearby = new NpcCondition(3475);
        this.illusiveNearby = new Conditions(LogicType.OR, new NpcCondition(3476), new NpcCondition(3478));
    }

    public void setupSteps() {
        this.goDownToCyrisus = new ObjectStep((QuestHelper)this, 14996, new WorldPoint(2142, 3944, 0), "Enter the mine in the north east of Lunar Isle.", this.food14);
        this.enterCyrisusCave = new ObjectStep((QuestHelper)this, 11399, new WorldPoint(2335, 10346, 2), "Enter the cave entrance on the north wall.", new Requirement[0]);
        this.talkToCyrisus = new NpcStep((QuestHelper)this, 3465, new WorldPoint(2346, 10360, 2), "Attempt to talk to the fallen man.", new Requirement[0]);
        this.talkToCyrisus.addDialogStep("Yes.");
        this.feed4Food = new NpcStep((QuestHelper)this, 3465, new WorldPoint(2346, 10360, 2), "Feed the fallen man 4 food. You'll need to alternate between at least 3 different types of food.", this.food4);
        this.talkToCyrisus2 = new NpcStep((QuestHelper)this, 3466, new WorldPoint(2346, 10360, 2), "Talk to the fallen man.", new Requirement[0]);
        ((NpcStep)this.talkToCyrisus2).addAlternateNpcs(3465);
        this.feed4Food2 = new NpcStep((QuestHelper)this, 3466, new WorldPoint(2346, 10360, 2), "Feed the fallen man 4 food. You'll need to alternate between at least 3 different types of food.", this.food4);
        this.talkToCyrisus3 = new NpcStep((QuestHelper)this, 3466, new WorldPoint(2346, 10360, 2), "Talk to the fallen man.", new Requirement[0]);
        ((NpcStep)this.talkToCyrisus3).addAlternateNpcs(3467);
        this.talkToCyrisus3.addDialogSteps("You're looking better now.", "Well, you look and sound more lively.");
        this.talkToCyrisus3.addDialogSteps("Are you looking forward to getting out?", "That's the spirit!");
        this.talkToCyrisus3.addDialogSteps("You seem like a nice guy.", "Just being honest.");
        this.talkToCyrisus3.addDialogSteps("When we get out of here I'll buy you a drink!", "Whatever and wherever you want - my treat.");
        this.talkToCyrisus3.addDialogSteps("I'm very impressed you managed to get into this cave.", "I would have given up personally.");
        this.talkToCyrisus3.addDialogSteps("You'll survive this easily.", "Think of all the places you can visit when you get out!");
        this.talkToCyrisus3.addDialogSteps("Just don't worry.", "Of course.");
        this.talkToCyrisus3.addDialogSteps("What are you going to do when you get out of here?", "That's up to you. You could travel with me!");
        this.talkToCyrisus3.addDialogSteps("It's a good thing you have me to look after you.", "Not that I'm bragging or anything.");
        this.talkToCyrisus3.addDialogSteps("Not long now and you'll be back on your feet!", "On whether you mind me helping you further.");
        this.talkToCyrisus3.addDialogSteps("You're sounding much better.", "If you need anything, just let me know.");
        this.talkToCyrisus3.addDialogSteps("It's quite cosy in here.", "The perfect environment for getting back on your feet!");
        this.talkToCyrisus3.addDialogSteps("You're very safe in this little cave.", "The suqah will never fit through that tunnel.");
        this.talkToCyrisus3.addDialogSteps("Tell me a bit about yourself.", "Fishing!");
        this.feed6Food = new NpcStep((QuestHelper)this, 3467, new WorldPoint(2346, 10360, 2), "Feed Cyrisus 6 food. You'll need to alternate between at least 3 different types of food.", this.food6);
        this.talkToCyrisus4 = new NpcStep((QuestHelper)this, 3467, new WorldPoint(2346, 10360, 2), "Talk to Cyrisus.", new Requirement[0]);
        ((NpcStep)this.talkToCyrisus4).addAlternateNpcs(3468);
        this.talkToCyrisus4.addDialogSteps("You're looking better now.", "Well, you look and sound more lively.");
        this.talkToCyrisus4.addDialogSteps("Are you looking forward to getting out?", "That's the spirit!");
        this.talkToCyrisus4.addDialogSteps("You seem like a nice guy.", "Just being honest.");
        this.talkToCyrisus4.addDialogSteps("When we get out of here I'll buy you a drink!", "Whatever and wherever you want - my treat.");
        this.talkToCyrisus4.addDialogSteps("I'm very impressed you managed to get into this cave.", "I would have given up personally.");
        this.talkToCyrisus4.addDialogSteps("You'll survive this easily.", "Think of all the places you can visit when you get out!");
        this.talkToCyrisus4.addDialogSteps("Just don't worry.", "Of course.");
        this.talkToCyrisus4.addDialogSteps("What are you going to do when you get out of here?", "That's up to you. You could travel with me!");
        this.talkToCyrisus4.addDialogSteps("It's a good thing you have me to look after you.", "Not that I'm bragging or anything.");
        this.talkToCyrisus4.addDialogSteps("Not long now and you'll be back on your feet!", "On whether you mind me helping you further.");
        this.talkToCyrisus4.addDialogSteps("You're sounding much better.", "If you need anything, just let me know.");
        this.talkToCyrisus4.addDialogSteps("It's quite cosy in here.", "The perfect environment for getting back on your feet!");
        this.talkToCyrisus4.addDialogSteps("You're very safe in this little cave.", "The suqah will never fit through that tunnel.");
        this.talkToCyrisus4.addDialogSteps("Tell me a bit about yourself.", "Fishing!");
        this.leaveCave = new ObjectStep((QuestHelper)this, 11399, new WorldPoint(12437, 2955, 0), "Talk to 'Bird's-Eye' Jack in the Lunar Isle bank.", this.sealOfPassage);
        this.goUpToSurface = new ObjectStep((QuestHelper)this, 14995, new WorldPoint(2330, 10353, 2), "Talk to 'Bird's-Eye' Jack in the Lunar Isle bank.", this.sealOfPassage);
        this.selectEquipment = new SelectingCombatGear(this);
        this.talkToJack = new NpcStep((QuestHelper)this, 3472, new WorldPoint(2099, 3921, 0), "Talk to 'Bird's-Eye' Jack in the Lunar Isle bank for Cyrisus's equipment.", this.sealOfPassage);
        this.talkToJack.addDialogStep("Cyrisus in the mine");
        this.talkToJack.addSubSteps(this.leaveCave, this.goUpToSurface, this.selectEquipment);
        this.goBackDownToCyrisus = new ObjectStep((QuestHelper)this, 14996, new WorldPoint(2142, 3944, 0), "Enter the mine in the north east of Lunar Isle.", this.chest, this.food6);
        this.goBackDownAfterGearing = new ObjectStep((QuestHelper)this, 14996, new WorldPoint(2142, 3944, 0), "Enter the mine in the north east of Lunar Isle.", this.food6);
        this.enterCyrisusCaveAgain = new ObjectStep((QuestHelper)this, 11399, new WorldPoint(2335, 10346, 2), "Enter the cave entrance on the north wall.", new Requirement[0]);
        this.giveCyrisusGear = new NpcStep((QuestHelper)this, 3468, new WorldPoint(2346, 10360, 2), "Give Cyrisus his equipment.", this.chest);
        this.giveCyrisusGear.addDialogStep("Talk about the Armament");
        this.giveCyrisusGear.addSubSteps(this.goBackDownToCyrisus, this.enterCyrisusCaveAgain);
        this.useFood3 = new NpcStep((QuestHelper)this, 3468, new WorldPoint(2346, 10360, 2), "Feed Cyrisus alternating types of food.", this.food6);
        this.useFood3.addSubSteps(this.goBackDownAfterGearing);
        ((NpcStep)this.useFood3).addAlternateNpcs(3469);
        ((NpcStep)this.useFood3).addAlternateNpcs(3470);
        ((NpcStep)this.useFood3).addAlternateNpcs(3471);
        this.supportCyrisusToRecovery = new NpcStep((QuestHelper)this, 3468, new WorldPoint(2346, 10360, 2), "Talk to Cyrisus until he's fully recovered.", new Requirement[0]);
        ((NpcStep)this.supportCyrisusToRecovery).addAlternateNpcs(3469);
        ((NpcStep)this.supportCyrisusToRecovery).addAlternateNpcs(3470);
        ((NpcStep)this.supportCyrisusToRecovery).addAlternateNpcs(3471);
        this.supportCyrisusToRecovery.addDialogSteps("You're looking better now.", "Well, you look and sound more lively.");
        this.supportCyrisusToRecovery.addDialogSteps("Are you looking forward to getting out?", "That's the spirit!");
        this.supportCyrisusToRecovery.addDialogSteps("You seem like a nice guy.", "Just being honest.");
        this.supportCyrisusToRecovery.addDialogSteps("When we get out of here I'll buy you a drink!", "Whatever and wherever you want - my treat.");
        this.supportCyrisusToRecovery.addDialogSteps("I'm very impressed you managed to get into this cave.", "I would have given up personally.");
        this.supportCyrisusToRecovery.addDialogSteps("You'll survive this easily.", "Think of all the places you can visit when you get out!");
        this.supportCyrisusToRecovery.addDialogSteps("Just don't worry.", "Of course.");
        this.supportCyrisusToRecovery.addDialogSteps("What are you going to do when you get out of here?", "That's up to you. You could travel with me!");
        this.supportCyrisusToRecovery.addDialogSteps("It's a good thing you have me to look after you.", "Not that I'm bragging or anything.");
        this.supportCyrisusToRecovery.addDialogSteps("Not long now and you'll be back on your feet!", "On whether you mind me helping you further.");
        this.supportCyrisusToRecovery.addDialogSteps("You're sounding much better.", "If you need anything, just let me know.");
        this.supportCyrisusToRecovery.addDialogSteps("It's quite cosy in here.", "The perfect environment for getting back on your feet!");
        this.supportCyrisusToRecovery.addDialogSteps("You're very safe in this little cave.", "The suqah will never fit through that tunnel.");
        this.supportCyrisusToRecovery.addDialogSteps("Tell me a bit about yourself.", "Fishing!");
        this.talkAfterHelping = new NpcStep((QuestHelper)this, 3468, new WorldPoint(2346, 10360, 2), "Talk to Cyrisus.", new Requirement[0]);
        ((NpcStep)this.talkAfterHelping).addAlternateNpcs(3469, 3470, 3471);
        this.supportCyrisusToRecovery.addSubSteps(this.talkAfterHelping);
        this.talkToOneiromancer = new NpcStep((QuestHelper)this, 3835, new WorldPoint(2151, 3867, 0), "Talk to the Oneiromancer in the south east of Lunar Isle.", this.sealOfPassage);
        this.talkToOneiromancer.addDialogStep("Cyrisus.");
        this.fillVialWithWater = new ObjectStep((QuestHelper)this, 16705, new WorldPoint(2091, 3922, 0), "Fill the vial with water.", this.dreamVial);
        this.fillVialWithWater.addIcon(11151);
        this.addGoutweed = new DetailedQuestStep((QuestHelper)this, "Add a goutweed to the dream vial.", this.dreamVialWater, this.goutweed);
        this.useHammerOnAstralRune = new DetailedQuestStep((QuestHelper)this, "Use a hammer on an astral rune.", this.hammer, this.astralRune);
        this.usePestleOnShards = new DetailedQuestStep((QuestHelper)this, "Use a pestle and mortar on the astral rune shards.", this.pestleAndMortar, this.astralRuneShards);
        this.useGroundAstralOnVial = new DetailedQuestStep((QuestHelper)this, "Add the ground astral rune to the dream vial.", this.groundAstralRune, this.dreamVialWithGoutweed);
        this.lightBrazier = new ObjectStep((QuestHelper)this, 17025, new WorldPoint(2073, 3912, 0), "Equip your combat equipment, food, and light the Brazier in the west of Lunar Isle's town. The upcoming fight is hard, and you can only leave via the lecturn in the arena and cannot pray. Magic attacks are extremely effective for the fight.", this.sealOfPassage, this.tinderbox.highlighted(), this.combatGear);
        this.lightBrazier.addIcon(590);
        this.talkToCyrisusForDream = new NpcStep((QuestHelper)this, 3468, new WorldPoint(2075, 3912, 0), "Talk to Cyrisus to enter the dream.", this.combatGear, this.sealOfPassage);
        ((NpcStep)this.talkToCyrisusForDream).addAlternateNpcs(3469, 3470, 3471);
        this.talkToCyrisusForDream.addDialogStep("Yes, let's go!");
        this.killInadaquacy = new NpcStep((QuestHelper)this, 3473, new WorldPoint(1824, 5150, 2), "Kill The Inadequacy.", new Requirement[0]);
        this.killEverlasting = new NpcStep((QuestHelper)this, 3474, new WorldPoint(1824, 5150, 2), "Kill The Everlasting. You can safe spot it by the entry book.", new Requirement[0]);
        this.killUntouchable = new NpcStep((QuestHelper)this, 3475, new WorldPoint(1824, 5150, 2), "Kill The Untouchable. You can safe spot it by the entry book.", new Requirement[0]);
        this.killIllusive = new NpcStep((QuestHelper)this, 3476, new WorldPoint(1824, 5150, 2), "Kill The Illusive.", new Requirement[0]);
        this.returnToOneiromancer = new NpcStep((QuestHelper)this, 3835, new WorldPoint(2151, 3867, 0), "Talk to the Oneiromancer to finish the quest!", this.sealOfPassage);
        this.returnToOneiromancer.addDialogStep("Cyrisus.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.sealOfPassage, this.foodAll1, this.foodAll2, this.foodAll3, this.goutweed, this.astralRune, this.hammer, this.pestleAndMortar, this.tinderbox, this.combatGear);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.lunarIsleTeleport.quantity(3), this.stamina);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Arrays.asList("The Inadequacy (level 343)", "The Everlasting (level 223, safespottable)", "The Untouchable (level 274, safespottable)", "The Illusive (level 108, won't attack you)");
    }

    @Override
    public List<String> getNotes() {
        return Collections.singletonList("To handle the food you could use Sack of Potatoes(10), Sack of Cabbages(10) and Sack of Onions(10). This would allow you to carry all the food in just three inventory spaces. You will need to fight all 4 bosses in a row without prayers. It's recommended that you use magic as they all have very low magic defence.");
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.HITPOINTS, 15000), new ExperienceReward(Skill.MAGIC, 10000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("15,000 Experience Lamp (Combat, No Prayer or Attack)", 4447, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("7 New Lunar Spells"), new UnlockReward("Ability to bank without the Seal of Passage by talking to 'Birds-Eye-Jack'"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Helping Cyrisus", Arrays.asList(this.goDownToCyrisus, this.enterCyrisusCave, this.talkToCyrisus, this.feed4Food, this.talkToCyrisus2, this.feed4Food2, this.talkToCyrisus3, this.feed6Food, this.talkToCyrisus4, this.talkToJack, this.giveCyrisusGear, this.useFood3, this.supportCyrisusToRecovery), Arrays.asList(this.foodAll1, this.foodAll2, this.foodAll3, this.sealOfPassage), Arrays.asList(this.lunarIsleTeleport.quantity(3), this.stamina)));
        allSteps.add(new PanelDetails("Defeating his fear", Arrays.asList(this.talkToOneiromancer, this.fillVialWithWater, this.addGoutweed, this.useHammerOnAstralRune, this.usePestleOnShards, this.useGroundAstralOnVial, this.lightBrazier, this.talkToCyrisusForDream, this.killInadaquacy, this.killEverlasting, this.killUntouchable, this.killIllusive, this.returnToOneiromancer), this.sealOfPassage, this.goutweed, this.astralRune, this.hammer, this.pestleAndMortar, this.tinderbox, this.combatGear));
        return allSteps;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new CombatLevelRequirement(85));
        req.add(new QuestRequirement(QuestHelperQuest.LUNAR_DIPLOMACY, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.EADGARS_RUSE, QuestState.FINISHED));
        return req;
    }
}

