/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.dreammentor;

import com.questhelper.helpers.quests.dreammentor.CyrisusBankItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.runelite.api.Client;
import net.runelite.api.Skill;

enum CyrisusArmourSet {
    MELEE(0, Arrays.asList(CyrisusBankItem.DRAGON_MED_HELM, CyrisusBankItem.AHRIM_ROBETOP, CyrisusBankItem.AHRIM_SKIRT, CyrisusBankItem.RANGER_BOOTS, CyrisusBankItem.ABYSSAL_WHIP)),
    RANGED(1, Arrays.asList(CyrisusBankItem.SPLITBARK_HELM, CyrisusBankItem.KARILS_TOP, CyrisusBankItem.TORAG_LEG, CyrisusBankItem.ADAMANT_BOOTS, CyrisusBankItem.MAGIC_SHORTBOW)),
    MAGIC(2, Arrays.asList(CyrisusBankItem.ROBIN_HOOD, CyrisusBankItem.DRAGON_CHAINBODY, CyrisusBankItem.BLACK_CHAPS, CyrisusBankItem.INFINITY_BOOTS, CyrisusBankItem.ANCIENT_STAFF));

    private final int combatType;
    private final List<CyrisusBankItem> items;

    private CyrisusArmourSet(int combatType, List<CyrisusBankItem> items) {
        this.combatType = combatType;
        this.items = items;
    }

    public static CyrisusArmourSet getCorrectSet(Client client) {
        float meleeCombatLevel = client.getRealSkillLevel(Skill.ATTACK) + client.getRealSkillLevel(Skill.STRENGTH);
        float rangedCombatLevel = (float)client.getRealSkillLevel(Skill.RANGED) * 1.5f;
        float magicCombatLevel = (float)client.getRealSkillLevel(Skill.MAGIC) * 1.5f;
        if (meleeCombatLevel >= rangedCombatLevel) {
            if (meleeCombatLevel >= magicCombatLevel) {
                return MELEE;
            }
            return MAGIC;
        }
        if (rangedCombatLevel > magicCombatLevel) {
            return RANGED;
        }
        return MAGIC;
    }

    public static boolean isReady(Client client) {
        CyrisusArmourSet armourSet = CyrisusArmourSet.getCorrectSet(client);
        int currentHelmet = client.getVarbitValue(3627);
        int currentBody = client.getVarbitValue(3628);
        int currentLegs = client.getVarbitValue(3629);
        int currentBoots = client.getVarbitValue(3630);
        int currentWeapon = client.getVarbitValue(3631);
        List<Integer> currentEquipment = Arrays.asList(currentHelmet, currentBody, currentLegs, currentBoots, currentWeapon);
        ArrayList<Integer> neededEquipment = new ArrayList<Integer>();
        for (CyrisusBankItem item : armourSet.getItems()) {
            neededEquipment.add(item.getVarbitID());
        }
        return currentEquipment.equals(neededEquipment);
    }

    public int getCombatType() {
        return this.combatType;
    }

    public List<CyrisusBankItem> getItems() {
        return this.items;
    }
}

