/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.dragonslayerii;

import com.questhelper.QuestHelperPlugin;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.steps.QuestStep;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.ui.FontManager;

public class MapPuzzle
extends QuestStep {
    int[] currentPositionsVarbits = new int[]{6156, 6168, 6159, 6178, -1, 6203, 6173, 6167, 6158, 6169, 6208, 6199, 6204, 6174, 6183, 6176, 6162, -1, -1, 6179, -1, 6180, 6182, 6175, 6184, 6170, 6209, 6190, 6191, 6216, -1, 6217, 6198, 6171, 6200, 6211};
    int[] currentRotationVarbits = new int[]{6166, 6172, 6177, 6181, -1, 6197, 6201, 6202, 6160, 6161, 6163, 6164, 6165, 6205, 6206, 6207, 6185, -1, -1, 6186, -1, 6187, 6188, 6189, 6210, 6212, 6213, 6214, 6215, 6192, -1, 6193, 6194, 6195, 6196, 6218};
    int[] currentRotationValue = new int[36];
    int firstTileForSwapping = -1;
    int secondTileForSwapping = -1;

    public MapPuzzle(QuestHelper questHelper) {
        super(questHelper, "Drag to swap the highlighted tiles.");
    }

    @Override
    public void startUp() {
        this.updateSolvedPositionState();
    }

    @Override
    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        this.updateSolvedPositionState();
    }

    private void updateSolvedPositionState() {
        int i;
        int[] currentTilePositions = new int[36];
        int[] currentRotationValueTmp = new int[36];
        int nullSlotsPassed = 0;
        for (i = 0; i < 36; ++i) {
            if (this.currentPositionsVarbits[i] == -1) {
                ++nullSlotsPassed;
                continue;
            }
            currentTilePositions[i] = this.client.getVarbitValue(this.currentPositionsVarbits[i]) - 1;
            int expectedTileValue = i - nullSlotsPassed;
            if (currentTilePositions[i] == expectedTileValue) continue;
            this.firstTileForSwapping = i;
            for (int j = i + 1; j < 36; ++j) {
                if (this.currentPositionsVarbits[j] == -1) {
                    ++nullSlotsPassed;
                    continue;
                }
                currentTilePositions[j] = this.client.getVarbitValue(this.currentPositionsVarbits[j]) - 1;
                if (currentTilePositions[j] != expectedTileValue) continue;
                this.secondTileForSwapping = j;
                this.setText("Drag to swap the highlighted tiles.");
                return;
            }
        }
        this.firstTileForSwapping = -1;
        this.secondTileForSwapping = -1;
        for (i = 0; i < 36; ++i) {
            currentRotationValueTmp[i] = this.currentRotationVarbits[i] == -1 ? 0 : this.client.getVarbitValue(this.currentRotationVarbits[i]);
        }
        this.currentRotationValue = currentRotationValueTmp;
        this.setText("Click the highlighted tiles to rotate them to complete the puzzle.");
    }

    @Override
    public void makeWidgetOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        super.makeWidgetOverlayHint(graphics, plugin);
        Widget widgetWrapper = this.client.getWidget(305, 2);
        if (widgetWrapper != null) {
            if (this.firstTileForSwapping != -1 && this.secondTileForSwapping != -1) {
                Widget widget1 = widgetWrapper.getChild(this.firstTileForSwapping);
                Widget widget2 = widgetWrapper.getChild(this.secondTileForSwapping);
                if (widget1 != null) {
                    Line2D.Double line = new Line2D.Double((float)widget1.getCanvasLocation().getX() + (float)widget1.getWidth() / 2.0f, (float)widget1.getCanvasLocation().getY() + (float)widget1.getHeight() / 2.0f, (float)widget2.getCanvasLocation().getX() + (float)widget2.getWidth() / 2.0f, (float)widget2.getCanvasLocation().getY() + (float)widget2.getHeight() / 2.0f);
                    graphics.setColor(new Color(0, 255, 255, 65));
                    graphics.fill(widget1.getBounds());
                    graphics.setColor(this.questHelper.getConfig().targetOverlayColor());
                    graphics.draw(widget1.getBounds());
                    graphics.setColor(new Color(0, 255, 255, 65));
                    graphics.fill(widget2.getBounds());
                    graphics.setColor(this.questHelper.getConfig().targetOverlayColor());
                    graphics.draw(widget2.getBounds());
                    graphics.setStroke(new BasicStroke(3.0f));
                    graphics.draw(line);
                    this.drawArrowHead(graphics, line);
                }
                return;
            }
            for (int i = 0; i < 36; ++i) {
                Widget widget = widgetWrapper.getChild(i);
                if (widget == null || this.currentRotationValue[i] == 0) continue;
                graphics.setColor(new Color(this.questHelper.getConfig().targetOverlayColor().getRed(), this.questHelper.getConfig().targetOverlayColor().getGreen(), this.questHelper.getConfig().targetOverlayColor().getBlue(), 65));
                graphics.fill(widget.getBounds());
                graphics.setColor(this.questHelper.getConfig().targetOverlayColor());
                graphics.draw(widget.getBounds());
                int widgetX = widget.getCanvasLocation().getX() + widget.getWidth() / 2 - 4;
                int widgetY = widget.getCanvasLocation().getY() + widget.getHeight() / 2 + 4;
                Font font = FontManager.getRunescapeFont().deriveFont(1, 16.0f);
                graphics.setFont(font);
                graphics.drawString(Integer.toString((4 - this.currentRotationValue[i]) % 4), widgetX, widgetY);
            }
        }
    }

    private void drawArrowHead(Graphics2D g2d, Line2D.Double line) {
        AffineTransform tx = new AffineTransform();
        Polygon arrowHead = new Polygon();
        arrowHead.addPoint(0, 4);
        arrowHead.addPoint(-6, -5);
        arrowHead.addPoint(6, -5);
        tx.setToIdentity();
        double angle = Math.atan2(line.y2 - line.y1, line.x2 - line.x1);
        tx.translate(line.x2, line.y2);
        tx.rotate(angle - 1.5707963267948966);
        Graphics2D g = (Graphics2D)g2d.create();
        g.setTransform(tx);
        g.fill(arrowHead);
        g.dispose();
    }
}

