/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.dragonslayerii;

import com.google.inject.Inject;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questhelpers.QuestUtil;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.steps.DetailedOwnerStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Client;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;

public class CryptPuzzle
extends DetailedOwnerStep {
    @Inject
    protected EventBus eventBus;
    @Inject
    protected Client client;
    private final int TRISTAN = 1;
    private final int CAMORRA = 2;
    private final int AIVAS = 3;
    private final int ROBERT = 4;
    Integer northBust;
    Integer eastBust;
    Integer southBust;
    Integer westBust;
    private final HashMap<String, Integer> locations = new HashMap();
    private final HashMap<String, Integer> weaponsSouth = new HashMap();
    private final HashMap<String, Integer> weaponsWest = new HashMap();
    private final HashMap<Integer, QuestStep> getBustSteps = new HashMap();
    private final HashMap<Integer, ItemRequirement> items = new HashMap();
    private final HashMap<Integer, ItemRequirement> bustsConditions = new HashMap();
    private boolean solutionFound;
    ItemRequirement aivasBust;
    ItemRequirement camorraBust;
    ItemRequirement robertBust;
    ItemRequirement tristanBust;
    Requirement inFirstFloor;
    Requirement inBasement;
    Requirement inSecondFloor;
    Requirement hasAivasBust;
    Requirement hasRobertBust;
    Requirement hasCamorraBust;
    Requirement hasTristanBust;
    DetailedQuestStep takeCamorraBust;
    DetailedQuestStep takeAivasBust;
    DetailedQuestStep takeRobertBust;
    DetailedQuestStep takeTristanBust;
    DetailedQuestStep placeBustNorth;
    DetailedQuestStep placeBustSouth;
    DetailedQuestStep placeBustEast;
    DetailedQuestStep placeBustWest;
    DetailedQuestStep inspectTomb;
    Zone firstFloor;
    Zone basement;
    Zone secondFloor;

    public CryptPuzzle(QuestHelper questHelper) {
        super(questHelper, "Solve the bust puzzle.", new Requirement[0]);
        this.locations.put("Zartharim sat at the north of the table", 3);
        this.locations.put("Saranthium sat at the north of the table", 2);
        this.locations.put("Arkney sat at the north of the table", 4);
        this.locations.put("Karville sat at the north of the table", 1);
        this.weaponsSouth.put("opposite the one with the crossbow", 3);
        this.weaponsSouth.put("opposite the one with the axe", 2);
        this.weaponsSouth.put("opposite the one with the bow", 4);
        this.weaponsSouth.put("opposite the one with the sword", 1);
        this.weaponsWest.put("The one with a crossbow asked the", 3);
        this.weaponsWest.put("The one with an axe asked the", 2);
        this.weaponsWest.put("The one with a bow asked the", 4);
        this.weaponsWest.put("The one with a sword asked the", 1);
        this.getBustSteps.put(3, this.takeAivasBust);
        this.getBustSteps.put(2, this.takeCamorraBust);
        this.getBustSteps.put(4, this.takeRobertBust);
        this.getBustSteps.put(1, this.takeTristanBust);
        this.bustsConditions.put(3, this.aivasBust);
        this.bustsConditions.put(2, this.camorraBust);
        this.bustsConditions.put(4, this.robertBust);
        this.bustsConditions.put(1, this.tristanBust);
        this.items.put(3, this.aivasBust);
        this.items.put(2, this.camorraBust);
        this.items.put(4, this.robertBust);
        this.items.put(1, this.tristanBust);
    }

    @Override
    public void startUp() {
        this.updateSteps();
    }

    @Override
    public void shutDown() {
        this.shutDownStep();
        this.currentStep = null;
    }

    @Subscribe
    public void onGameTick(GameTick ignoredEvent) {
        this.updateSteps();
    }

    @Override
    protected void updateSteps() {
        if (!this.solutionFound) {
            this.startUpStep(this.inspectTomb);
            return;
        }
        int currentNorthBust = this.client.getVarbitValue(6152);
        int currentEastBust = this.client.getVarbitValue(6154);
        int currentSouthBust = this.client.getVarbitValue(6153);
        int currentWestBust = this.client.getVarbitValue(6155);
        if (currentNorthBust != this.northBust) {
            if (!this.bustsConditions.get(this.northBust).check(this.client)) {
                this.startUpStep(this.getBustSteps.get(this.northBust));
            } else {
                this.startUpStep(this.placeBustNorth);
            }
        } else if (currentEastBust != this.eastBust) {
            if (!this.bustsConditions.get(this.eastBust).check(this.client)) {
                this.startUpStep(this.getBustSteps.get(this.eastBust));
            } else {
                this.startUpStep(this.placeBustEast);
            }
        } else if (currentSouthBust != this.southBust) {
            if (!this.bustsConditions.get(this.southBust).check(this.client)) {
                this.startUpStep(this.getBustSteps.get(this.southBust));
            } else {
                this.startUpStep(this.placeBustSouth);
            }
        } else if (currentWestBust != this.westBust) {
            if (!this.bustsConditions.get(this.westBust).check(this.client)) {
                this.startUpStep(this.getBustSteps.get(this.westBust));
            } else {
                this.startUpStep(this.placeBustWest);
            }
        } else {
            this.startUpStep(this.inspectTomb);
        }
    }

    private void setupItemRequirements() {
        this.aivasBust = new ItemRequirement("Aivas bust", 22086);
        this.aivasBust.setHighlightInInventory(true);
        this.robertBust = new ItemRequirement("Robert bust", 22083);
        this.robertBust.setHighlightInInventory(true);
        this.tristanBust = new ItemRequirement("Trisan bust", 22085);
        this.tristanBust.setHighlightInInventory(true);
        this.camorraBust = new ItemRequirement("Camorra bust", 22084);
        this.camorraBust.setHighlightInInventory(true);
    }

    private void setupConditions() {
        this.inFirstFloor = new ZoneRequirement(this.firstFloor);
        this.inSecondFloor = new ZoneRequirement(this.secondFloor);
        this.inBasement = new ZoneRequirement(this.basement);
        this.hasAivasBust = this.aivasBust;
        this.hasRobertBust = this.robertBust;
        this.hasCamorraBust = this.camorraBust;
        this.hasTristanBust = this.tristanBust;
    }

    @Override
    protected void setupSteps() {
        this.inspectTomb = new ObjectStep(this.getQuestHelper(), 29901, new WorldPoint(1504, 9939, 1), "Inspect the tomb in the south room.", new Requirement[0]);
        this.takeTristanBust = new ObjectStep(this.getQuestHelper(), 29904, new WorldPoint(1507, 9941, 1), "Take Tristan's Bust.", new Requirement[0]);
        this.takeAivasBust = new ObjectStep(this.getQuestHelper(), 29905, new WorldPoint(1500, 9941, 1), "Take Aivas' Bust.", new Requirement[0]);
        this.takeRobertBust = new ObjectStep(this.getQuestHelper(), 29902, new WorldPoint(1500, 9936, 1), "Take Robert's Bust.", new Requirement[0]);
        this.takeCamorraBust = new ObjectStep(this.getQuestHelper(), 29903, new WorldPoint(1507, 9936, 1), "Take Camorra's Bust.", new Requirement[0]);
        this.placeBustNorth = new ObjectStep(this.getQuestHelper(), 29906, new WorldPoint(1504, 9941, 1), "Place the bust on the north plinth.", new Requirement[0]);
        this.placeBustEast = new ObjectStep(this.getQuestHelper(), 29908, new WorldPoint(1506, 9939, 1), "Place the bust on the east plinth.", new Requirement[0]);
        this.placeBustSouth = new ObjectStep(this.getQuestHelper(), 29907, new WorldPoint(1504, 9936, 1), "Place the bust on the south plinth.", new Requirement[0]);
        this.placeBustWest = new ObjectStep(this.getQuestHelper(), 29909, new WorldPoint(1501, 9939, 1), "Place the bust on the west plinth.", new Requirement[0]);
        this.setupItemRequirements();
        this.setupConditions();
    }

    @Override
    public Collection<QuestStep> getSteps() {
        return Arrays.asList(this.inspectTomb, this.takeAivasBust, this.takeCamorraBust, this.takeRobertBust, this.takeTristanBust, this.placeBustEast, this.placeBustWest, this.placeBustNorth, this.placeBustSouth);
    }

    @Override
    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        if (!this.solutionFound && widgetLoaded.getGroupId() == 748) {
            List<Integer> potentialBusts = QuestUtil.toArrayList(3, 2, 4, 1);
            Widget parentWidget = this.client.getWidget(748, 2);
            if (parentWidget == null || parentWidget.getStaticChildren() == null) {
                return;
            }
            StringBuilder storyString = new StringBuilder();
            for (Widget child : parentWidget.getStaticChildren()) {
                storyString.append(child.getText()).append(" ");
            }
            String fullStory = storyString.toString();
            this.northBust = this.locations.entrySet().stream().filter(e -> fullStory.contains((CharSequence)e.getKey())).map(Map.Entry::getValue).findFirst().orElse(null);
            this.southBust = this.weaponsSouth.entrySet().stream().filter(e -> fullStory.contains((CharSequence)e.getKey())).map(Map.Entry::getValue).findFirst().orElse(null);
            this.westBust = this.weaponsWest.entrySet().stream().filter(e -> fullStory.contains((CharSequence)e.getKey())).map(Map.Entry::getValue).findFirst().orElse(null);
            if (this.northBust == null || this.southBust == null || this.westBust == null) {
                return;
            }
            potentialBusts.remove(this.northBust);
            potentialBusts.remove(this.southBust);
            potentialBusts.remove(this.westBust);
            this.eastBust = potentialBusts.iterator().next();
            this.placeBustNorth.addItemRequirements(Collections.singletonList(this.items.get(this.northBust)));
            this.placeBustNorth.addIcon(this.items.get(this.northBust).getId());
            this.placeBustEast.addItemRequirements(Collections.singletonList(this.items.get(this.eastBust)));
            this.placeBustEast.addIcon(this.items.get(this.eastBust).getId());
            this.placeBustSouth.addItemRequirements(Collections.singletonList(this.items.get(this.southBust)));
            this.placeBustSouth.addIcon(this.items.get(this.southBust).getId());
            this.placeBustWest.addItemRequirements(Collections.singletonList(this.items.get(this.westBust)));
            this.placeBustWest.addIcon(this.items.get(this.westBust).getId());
            this.solutionFound = true;
        }
    }
}

