/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.dragonslayer;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.ObjectCondition;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.quest.QuestPointRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.DRAGON_SLAYER_I)
public class DragonSlayer
extends BasicQuestHelper {
    ItemRequirement chronicle;
    ItemRequirement edgevilleTeleport;
    ItemRequirement rimmingtonTeleport;
    ItemRequirement antidragonShieldEquipped;
    ItemRequirement antifirePotion;
    ItemRequirement ringsOfRecoil;
    ItemRequirement unfiredBowl;
    ItemRequirement mindBomb;
    ItemRequirement lobsterPot;
    ItemRequirement silk;
    ItemRequirement telegrabOrTenK;
    ItemRequirement hammer;
    ItemRequirement antidragonShield;
    ItemRequirement planks3;
    ItemRequirement planks2;
    ItemRequirement planks1;
    ItemRequirement nails90;
    ItemRequirement nails60;
    ItemRequirement nails30;
    ItemRequirement twoThousandCoins;
    ItemRequirement mapPart1;
    ItemRequirement mapPart2;
    ItemRequirement mapPart3;
    ItemRequirement fullMap;
    ItemRequirement melzarsKey;
    ItemRequirement ratKey;
    ItemRequirement ghostKey;
    ItemRequirement skeletonKey;
    ItemRequirement zombieKey;
    ItemRequirement melzarKey;
    ItemRequirement demonKey;
    ItemRequirement combatGear;
    ItemRequirement food;
    Requirement askedAboutShip;
    Requirement askedAboutShield;
    Requirement askedAboutMelzar;
    Requirement askedAboutThalzar;
    Requirement askedAboutLozar;
    Requirement askedAllQuestions;
    Requirement askedOracleAboutMap;
    Requirement inDwarvenMines;
    Requirement silkUsed;
    Requirement lobsterPotUsed;
    Requirement mindBombUsed;
    Requirement unfiredBowlUsed;
    Requirement thalzarDoorOpened;
    Requirement thalzarChest2Nearby;
    Requirement hasMapPart1;
    Requirement hasMapPart2;
    Requirement hasMapPart3;
    Requirement inMelzarsMaze;
    Requirement inRatRoom;
    Requirement inPostRatRoom;
    Requirement inGhostRoom;
    Requirement inPostGhostRoom;
    Requirement inSkeletonRoom;
    Requirement inPostSkeletonRoom;
    Requirement inLadderRoom;
    Requirement inRoomToBasement;
    Requirement inZombieRoom;
    Requirement inMelzarRoom;
    Requirement inDemonRoom;
    Requirement inLastMelzarRoom;
    Requirement hasShield;
    Requirement inShipHull;
    Requirement onShipDeck;
    Requirement hasBoughtBoat;
    Requirement hasRepairedHullOnce;
    Requirement hasRepairedHullTwice;
    Requirement fullyRepairedHull;
    Requirement onCrandorSurface;
    Requirement inCrandorUnderground;
    Requirement inElvargArea;
    Requirement inKaramjaVolcano;
    Requirement unlockedShortcut;
    ConditionalStep getLozarPiece;
    ConditionalStep getThalzarPiece;
    ConditionalStep getMelzarPiece;
    ConditionalStep getShieldSteps;
    QuestStep startQuest;
    QuestStep talkToOziach;
    QuestStep returnToGuildmaster;
    QuestStep askAboutShield;
    QuestStep askAboutMelzar;
    QuestStep askAboutThalzar;
    QuestStep askAboutLozar;
    QuestStep talkToOracle;
    QuestStep goIntoDwarvenMine;
    QuestStep useSilkOnDoor;
    QuestStep usePotOnDoor;
    QuestStep useUnfiredBowlOnDoor;
    QuestStep useMindBombOnDoor;
    QuestStep searchThalzarChest;
    QuestStep searchThalzarChest2;
    QuestStep optionsForLozarPiece;
    QuestStep enterMelzarsMaze;
    QuestStep killRat;
    QuestStep openRedDoor;
    QuestStep goUpRatLadder;
    QuestStep killGhost;
    QuestStep openOrangeDoor;
    QuestStep goUpGhostLadder;
    QuestStep killSkeleton;
    QuestStep openYellowDoor;
    QuestStep goDownSkeletonLadder;
    QuestStep goDownLadderRoomLadder;
    QuestStep goDownBasementEntryLadder;
    QuestStep openBlueDoor;
    QuestStep killZombie;
    QuestStep killMelzar;
    QuestStep openMagntaDoor;
    QuestStep killLesserDemon;
    QuestStep openGreenDoor;
    QuestStep openMelzarChest;
    QuestStep getShield;
    QuestStep talkToKlarense;
    QuestStep boardShip1;
    QuestStep boardShip2;
    QuestStep boardShip3;
    QuestStep goDownShipLadder;
    QuestStep repairShip;
    QuestStep repairShip2;
    QuestStep repairShip3;
    QuestStep repairMap;
    QuestStep talkToNed;
    QuestStep boardShipToGo;
    QuestStep talkToNedOnShip;
    QuestStep enterCrandorHole;
    QuestStep unlockShortcut;
    QuestStep returnThroughShortcut;
    QuestStep enterElvargArea;
    QuestStep goDownIntoKaramjaVolcano;
    QuestStep repairShipAgainAndSail;
    QuestStep killElvarg;
    QuestStep finishQuest;
    Zone dwarvenMines;
    Zone melzarsMaze;
    Zone melzarsBasement;
    Zone ratRoom1;
    Zone ratRoom2;
    Zone ratRoom3;
    Zone postRatRoom1;
    Zone postRatRoom2;
    Zone ghostRoom1;
    Zone ghostRoom2;
    Zone postGhostRoom1;
    Zone postGhostRoom2;
    Zone skeletonRoom1;
    Zone skeletonRoom2;
    Zone postSkeletonRoom1;
    Zone postSkeletonRoom2;
    Zone postSkeletonRoom3;
    Zone ladderRoom;
    Zone roomToBasement1;
    Zone roomToBasement2;
    Zone zombieRoom;
    Zone melzarRoom1;
    Zone melzarRoom2;
    Zone demonRoom1;
    Zone demonRoom2;
    Zone lastMelzarRoom1;
    Zone lastMelzarRoom2;
    Zone shipHull;
    Zone shipDeck;
    Zone crandorSurface;
    Zone crandorUnderground;
    Zone elvargArea;
    Zone karamjaVolcano;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.startQuest);
        steps.put(1, this.talkToOziach);
        ConditionalStep askQuestions = new ConditionalStep((QuestHelper)this, this.returnToGuildmaster, new Requirement[0]);
        askQuestions.addStep(new Conditions(this.askedAboutShip, this.askedAboutShield, this.askedAboutMelzar, this.askedAboutThalzar), this.askAboutLozar);
        askQuestions.addStep(new Conditions(this.askedAboutShip, this.askedAboutShield, this.askedAboutMelzar), this.askAboutThalzar);
        askQuestions.addStep(new Conditions(this.askedAboutShip, this.askedAboutShield), this.askAboutMelzar);
        askQuestions.addStep(this.askedAboutShip, this.askAboutShield);
        this.getThalzarPiece = new ConditionalStep((QuestHelper)this, this.talkToOracle, new Requirement[0]);
        this.getThalzarPiece.addStep(new Conditions(this.thalzarDoorOpened, this.inDwarvenMines, this.thalzarChest2Nearby), this.searchThalzarChest2);
        this.getThalzarPiece.addStep(new Conditions(this.thalzarDoorOpened, this.inDwarvenMines), this.searchThalzarChest);
        this.getThalzarPiece.addStep(new Conditions(this.inDwarvenMines, this.silkUsed, this.lobsterPotUsed, this.unfiredBowlUsed), this.useMindBombOnDoor);
        this.getThalzarPiece.addStep(new Conditions(this.inDwarvenMines, this.silkUsed, this.lobsterPotUsed), this.useUnfiredBowlOnDoor);
        this.getThalzarPiece.addStep(new Conditions(this.inDwarvenMines, this.silkUsed), this.usePotOnDoor);
        this.getThalzarPiece.addStep(new Conditions(this.askedOracleAboutMap, this.inDwarvenMines), this.useSilkOnDoor);
        this.getThalzarPiece.addStep(this.askedOracleAboutMap, this.goIntoDwarvenMine);
        this.getThalzarPiece.setLockingCondition(this.hasMapPart1);
        this.getThalzarPiece.setBlocker(true);
        this.getLozarPiece = new ConditionalStep((QuestHelper)this, this.optionsForLozarPiece, new Requirement[0]);
        this.getLozarPiece.setLockingCondition(this.hasMapPart2);
        this.getMelzarPiece = new ConditionalStep((QuestHelper)this, this.enterMelzarsMaze, new Requirement[0]);
        this.getMelzarPiece.addStep(this.inLastMelzarRoom, this.openMelzarChest);
        this.getMelzarPiece.addStep(new Conditions(this.inDemonRoom, this.demonKey), this.openGreenDoor);
        this.getMelzarPiece.addStep(this.inDemonRoom, this.killLesserDemon);
        this.getMelzarPiece.addStep(new Conditions(this.inMelzarRoom, this.melzarKey), this.openMagntaDoor);
        this.getMelzarPiece.addStep(this.inMelzarRoom, this.killMelzar);
        this.getMelzarPiece.addStep(new Conditions(this.inZombieRoom, this.zombieKey), this.openBlueDoor);
        this.getMelzarPiece.addStep(this.inZombieRoom, this.killZombie);
        this.getMelzarPiece.addStep(this.inRoomToBasement, this.goDownBasementEntryLadder);
        this.getMelzarPiece.addStep(this.inLadderRoom, this.goDownLadderRoomLadder);
        this.getMelzarPiece.addStep(this.inPostSkeletonRoom, this.goDownSkeletonLadder);
        this.getMelzarPiece.addStep(new Conditions(this.inSkeletonRoom, this.skeletonKey), this.openYellowDoor);
        this.getMelzarPiece.addStep(this.inSkeletonRoom, this.killSkeleton);
        this.getMelzarPiece.addStep(this.inPostGhostRoom, this.goUpGhostLadder);
        this.getMelzarPiece.addStep(new Conditions(this.inGhostRoom, this.ghostKey), this.openOrangeDoor);
        this.getMelzarPiece.addStep(this.inGhostRoom, this.killGhost);
        this.getMelzarPiece.addStep(this.inPostRatRoom, this.goUpRatLadder);
        this.getMelzarPiece.addStep(new Conditions(this.inRatRoom, this.ratKey), this.openRedDoor);
        this.getMelzarPiece.addStep(this.inRatRoom, this.killRat);
        this.getMelzarPiece.setLockingCondition(this.hasMapPart3);
        this.getShieldSteps = new ConditionalStep((QuestHelper)this, this.getShield, new Requirement[0]);
        this.getShieldSteps.setLockingCondition(this.hasShield);
        ConditionalStep getBoat = new ConditionalStep((QuestHelper)this, this.talkToKlarense, new Requirement[0]);
        getBoat.addStep(new Conditions(this.hasBoughtBoat, this.inShipHull, this.hasRepairedHullTwice), this.repairShip3);
        getBoat.addStep(new Conditions(this.hasBoughtBoat, this.inShipHull, this.hasRepairedHullOnce), this.repairShip2);
        getBoat.addStep(new Conditions(this.hasBoughtBoat, this.inShipHull), this.repairShip);
        getBoat.addStep(new Conditions(this.hasBoughtBoat, this.onShipDeck), this.goDownShipLadder);
        getBoat.addStep(new Conditions(this.hasBoughtBoat, this.hasRepairedHullTwice), this.boardShip3);
        getBoat.addStep(new Conditions(this.hasBoughtBoat, this.hasRepairedHullOnce), this.boardShip2);
        getBoat.addStep(new Conditions(this.hasBoughtBoat), this.boardShip1);
        getBoat.setLockingCondition(this.fullyRepairedHull);
        ConditionalStep getCaptain = new ConditionalStep((QuestHelper)this, this.repairMap, new Requirement[0]);
        getCaptain.addStep(this.fullMap, this.talkToNed);
        ConditionalStep getMapAndBoat = new ConditionalStep((QuestHelper)this, (QuestStep)askQuestions, new Requirement[0]);
        getMapAndBoat.addStep(new Conditions(this.hasMapPart1, this.hasMapPart2, this.hasMapPart3, this.askedAllQuestions, this.hasShield, this.fullyRepairedHull), getCaptain);
        getMapAndBoat.addStep(new Conditions(this.hasMapPart1, this.hasMapPart2, this.hasMapPart3, this.askedAllQuestions, this.hasShield), getBoat);
        getMapAndBoat.addStep(new Conditions(this.hasMapPart1, this.hasMapPart2, this.hasMapPart3, this.askedAllQuestions), this.getShieldSteps);
        getMapAndBoat.addStep(new Conditions(LogicType.OR, this.inMelzarsMaze, new Conditions(this.hasMapPart1, this.hasMapPart2, this.askedAllQuestions)), this.getMelzarPiece);
        getMapAndBoat.addStep(new Conditions(this.hasMapPart1, this.askedAllQuestions), this.getLozarPiece);
        getMapAndBoat.addStep(this.askedAllQuestions, this.getThalzarPiece);
        steps.put(2, getMapAndBoat);
        steps.put(3, getMapAndBoat);
        steps.put(6, getMapAndBoat);
        ConditionalStep goToCrandor = new ConditionalStep((QuestHelper)this, this.boardShipToGo, new Requirement[0]);
        goToCrandor.addStep(this.onShipDeck, this.talkToNedOnShip);
        steps.put(7, goToCrandor);
        ConditionalStep killingElvarg = new ConditionalStep((QuestHelper)this, this.repairShipAgainAndSail, new Requirement[0]);
        killingElvarg.addStep(this.inElvargArea, this.killElvarg);
        killingElvarg.addStep(new Conditions(this.inCrandorUnderground, this.unlockedShortcut), this.enterElvargArea);
        killingElvarg.addStep(new Conditions(this.inKaramjaVolcano, this.unlockedShortcut), this.returnThroughShortcut);
        killingElvarg.addStep(this.inCrandorUnderground, this.unlockShortcut);
        killingElvarg.addStep(this.onCrandorSurface, this.enterCrandorHole);
        killingElvarg.addStep(this.unlockedShortcut, this.goDownIntoKaramjaVolcano);
        steps.put(8, killingElvarg);
        steps.put(9, this.finishQuest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.unfiredBowl = new ItemRequirement("Unfired bowl", 1791);
        this.unfiredBowl.setTooltip("You can make one with soft clay at a Potter's Wheel with 8 Crafting.");
        this.mindBomb = new ItemRequirement("Wizard's mind bomb", 1907);
        this.mindBomb.setTooltip("You can buy one from the Rising Sun Inn in Falador.");
        this.lobsterPot = new ItemRequirement("Lobster pot", 301);
        this.silk = new ItemRequirement("Silk", 950);
        ItemRequirement telegrab = new ItemRequirement("Telekinetic grab", 8022, 1);
        this.telegrabOrTenK = new ItemRequirements(LogicType.OR, "Either 33 Magic for Telegrab and a ranged/mage weapon, or 10,000 coins", new ItemRequirement("Coins", ItemCollections.COINS, 10000), telegrab);
        this.ringsOfRecoil = new ItemRequirement("Rings of Recoil for Elvarg", 2550, -1);
        this.chronicle = new ItemRequirement("The Chronicle for teleports to Champions' Guild", 13660).isNotConsumed();
        this.antifirePotion = new ItemRequirement("Antifire potion for Elvarg", ItemCollections.ANTIFIRE_POTIONS, -1);
        this.edgevilleTeleport = new ItemRequirement("Teleports to Edgeville for getting to Oziach", 11964, -1);
        this.rimmingtonTeleport = new ItemRequirement("Teleports to Port Sarim/Rimmington/Draynor Village area", 11964, -1);
        this.mapPart1 = new ItemRequirement("Map part", 1537);
        this.mapPart2 = new ItemRequirement("Map part", 1536);
        this.mapPart3 = new ItemRequirement("Map part", 1535);
        this.melzarsKey = new ItemRequirement("Maze key", 1542);
        this.melzarsKey.setTooltip("You can get another maze key from the Guildmaster in the Champions' Guild.");
        this.ratKey = new ItemRequirement("Key", 1543);
        this.ghostKey = new ItemRequirement("Key", 1544);
        this.skeletonKey = new ItemRequirement("Key", 1545);
        this.zombieKey = new ItemRequirement("Key", 1546);
        this.melzarKey = new ItemRequirement("Key", 1547);
        this.demonKey = new ItemRequirement("Key", 1548);
        this.combatGear = new ItemRequirement("Combat equipment", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.antidragonShield = new ItemRequirement("Anti-dragon shield", ItemCollections.ANTIFIRE_SHIELDS);
        this.antidragonShieldEquipped = new ItemRequirement("Anti-dragon shield", ItemCollections.ANTIFIRE_SHIELDS, 1, true);
        this.planks3 = new ItemRequirement("Planks", 960, 3);
        this.planks2 = new ItemRequirement("Planks", 960, 2);
        this.planks1 = new ItemRequirement("Plank", 960);
        this.hammer = new ItemRequirement("Hammer", ItemCollections.HAMMER).isNotConsumed();
        this.nails90 = new ItemRequirement("Steel nails", 1539, 90);
        this.nails60 = new ItemRequirement("Steel nails", 1539, 60);
        this.nails30 = new ItemRequirement("Steel nails", 1539, 30);
        this.twoThousandCoins = new ItemRequirement("Coins", ItemCollections.COINS, 2000);
        this.fullMap = new ItemRequirement("Crandor map", 1538);
    }

    public void loadZones() {
        this.dwarvenMines = new Zone(new WorldPoint(2960, 9696, 0), new WorldPoint(3062, 9854, 0));
        this.ratRoom1 = new Zone(new WorldPoint(2926, 3243, 0), new WorldPoint(2937, 3254, 0));
        this.ratRoom2 = new Zone(new WorldPoint(2930, 3255, 0), new WorldPoint(2937, 3257, 0));
        this.ratRoom3 = new Zone(new WorldPoint(2938, 3246, 0), new WorldPoint(2940, 3250, 0));
        this.postRatRoom1 = new Zone(new WorldPoint(2922, 3251, 0), new WorldPoint(2925, 3255, 0));
        this.postRatRoom2 = new Zone(new WorldPoint(2923, 3255, 0), new WorldPoint(2929, 3257, 0));
        this.ghostRoom1 = new Zone(new WorldPoint(2926, 3247, 1), new WorldPoint(2930, 3257, 1));
        this.ghostRoom2 = new Zone(new WorldPoint(2921, 3250, 1), new WorldPoint(2925, 3257, 1));
        this.postGhostRoom1 = new Zone(new WorldPoint(2931, 3252, 1), new WorldPoint(2936, 3254, 1));
        this.postGhostRoom2 = new Zone(new WorldPoint(2933, 3255, 1), new WorldPoint(2936, 3256, 1));
        this.skeletonRoom1 = new Zone(new WorldPoint(2922, 3250, 2), new WorldPoint(2932, 3252, 2));
        this.skeletonRoom2 = new Zone(new WorldPoint(2921, 3253, 2), new WorldPoint(2935, 3257, 2));
        this.postSkeletonRoom1 = new Zone(new WorldPoint(2922, 3239, 2), new WorldPoint(2925, 3249, 2));
        this.postSkeletonRoom2 = new Zone(new WorldPoint(2926, 3237, 2), new WorldPoint(2940, 3241, 2));
        this.postSkeletonRoom3 = new Zone(new WorldPoint(2936, 3242, 2), new WorldPoint(2940, 3243, 2));
        this.ladderRoom = new Zone(new WorldPoint(2937, 3237, 1), new WorldPoint(2940, 3241, 1));
        this.roomToBasement1 = new Zone(new WorldPoint(2937, 3237, 0), new WorldPoint(2940, 3245, 0));
        this.roomToBasement2 = new Zone(new WorldPoint(2932, 3240, 0), new WorldPoint(2936, 3242, 0));
        this.zombieRoom = new Zone(new WorldPoint(2931, 9639, 0), new WorldPoint(2933, 9644, 0));
        this.melzarRoom1 = new Zone(new WorldPoint(2927, 9643, 0), new WorldPoint(2930, 9651, 0));
        this.melzarRoom2 = new Zone(new WorldPoint(2931, 9646, 0), new WorldPoint(2931, 9651, 0));
        this.demonRoom1 = new Zone(new WorldPoint(2924, 9652, 0), new WorldPoint(2933, 9655, 0));
        this.demonRoom2 = new Zone(new WorldPoint(2934, 9647, 0), new WorldPoint(2933, 9658, 0));
        this.melzarsMaze = new Zone(new WorldPoint(2922, 3237, 0), new WorldPoint(2942, 9658, 0));
        this.melzarsBasement = new Zone(new WorldPoint(2920, 9639, 0), new WorldPoint(1, 2, 0));
        this.lastMelzarRoom1 = new Zone(new WorldPoint(2924, 9656, 0), new WorldPoint(2942, 9656, 0));
        this.lastMelzarRoom2 = new Zone(new WorldPoint(2926, 9657, 0), new WorldPoint(2942, 9657, 0));
        this.shipDeck = new Zone(new WorldPoint(3041, 3207, 1), new WorldPoint(3050, 3209, 2));
        this.shipHull = new Zone(new WorldPoint(3041, 9639, 1), new WorldPoint(3050, 9641, 1));
        this.crandorSurface = new Zone(new WorldPoint(2810, 3228, 0), new WorldPoint(2867, 3312, 0));
        this.crandorUnderground = new Zone(new WorldPoint(2821, 9600, 0), new WorldPoint(2872, 9663, 0));
        this.elvargArea = new Zone(new WorldPoint(2846, 9625, 0), new WorldPoint(2867, 9651, 0));
        this.karamjaVolcano = new Zone(new WorldPoint(2827, 9547, 0), new WorldPoint(2867, 9599, 0));
    }

    public void setupConditions() {
        this.askedAboutMelzar = new VarplayerRequirement(177, false, 11);
        this.askedAboutThalzar = new VarplayerRequirement(177, false, 12);
        this.askedAboutLozar = new VarplayerRequirement(177, false, 13);
        this.askedAboutShip = new VarplayerRequirement(177, false, 14);
        this.askedAboutShield = new VarplayerRequirement(177, false, 15);
        this.askedAllQuestions = new Conditions(this.askedAboutShip, this.askedAboutShield, this.askedAboutMelzar, this.askedAboutThalzar, this.askedAboutLozar);
        this.askedOracleAboutMap = new VarbitRequirement(1832, 1);
        this.inDwarvenMines = new ZoneRequirement(this.dwarvenMines);
        this.silkUsed = new VarplayerRequirement(177, true, 17);
        this.unfiredBowlUsed = new VarplayerRequirement(177, true, 18);
        this.lobsterPotUsed = new VarplayerRequirement(177, true, 19);
        this.mindBombUsed = new VarplayerRequirement(177, true, 20);
        this.thalzarDoorOpened = new Conditions(this.silkUsed, this.unfiredBowlUsed, this.lobsterPotUsed, this.mindBombUsed);
        this.thalzarChest2Nearby = new ObjectCondition(2588);
        this.hasMapPart1 = new Conditions(LogicType.OR, this.fullMap, this.mapPart1);
        this.hasMapPart2 = new Conditions(LogicType.OR, this.fullMap, this.mapPart2);
        this.hasMapPart3 = new Conditions(LogicType.OR, this.fullMap, this.mapPart3);
        this.inMelzarsMaze = new ZoneRequirement(this.melzarsMaze, this.melzarsBasement);
        this.inRatRoom = new ZoneRequirement(this.ratRoom1, this.ratRoom2, this.ratRoom3);
        this.inPostRatRoom = new ZoneRequirement(this.postRatRoom1, this.postRatRoom2);
        this.inGhostRoom = new ZoneRequirement(this.ghostRoom1, this.ghostRoom2);
        this.inPostGhostRoom = new ZoneRequirement(this.postGhostRoom1, this.postGhostRoom2);
        this.inSkeletonRoom = new ZoneRequirement(this.skeletonRoom1, this.skeletonRoom2);
        this.inPostSkeletonRoom = new ZoneRequirement(this.postSkeletonRoom1, this.postSkeletonRoom2, this.postSkeletonRoom3);
        this.inLadderRoom = new ZoneRequirement(this.ladderRoom);
        this.inRoomToBasement = new ZoneRequirement(this.roomToBasement1, this.roomToBasement2);
        this.inZombieRoom = new ZoneRequirement(this.zombieRoom);
        this.inMelzarRoom = new ZoneRequirement(this.melzarRoom1, this.melzarRoom2);
        this.inDemonRoom = new ZoneRequirement(this.demonRoom1, this.demonRoom2);
        this.inLastMelzarRoom = new ZoneRequirement(this.lastMelzarRoom1, this.lastMelzarRoom2);
        this.hasShield = this.antidragonShield;
        this.onShipDeck = new ZoneRequirement(this.shipDeck);
        this.inShipHull = new ZoneRequirement(this.shipHull);
        this.hasBoughtBoat = new VarplayerRequirement(176, 3);
        this.hasRepairedHullOnce = new VarbitRequirement(1835, 1);
        this.hasRepairedHullTwice = new VarbitRequirement(1836, 1);
        this.fullyRepairedHull = new VarbitRequirement(1837, 1);
        this.onCrandorSurface = new ZoneRequirement(this.crandorSurface);
        this.inCrandorUnderground = new ZoneRequirement(this.crandorUnderground);
        this.inElvargArea = new ZoneRequirement(this.elvargArea);
        this.inKaramjaVolcano = new ZoneRequirement(this.karamjaVolcano);
        this.unlockedShortcut = new VarplayerRequirement(177, true, 6);
    }

    public void setupSteps() {
        this.startQuest = new NpcStep((QuestHelper)this, 814, new WorldPoint(3190, 3360, 0), "Talk to the Guildmaster in the Champions' Guild, south of Varrock.", new Requirement[0]);
        this.startQuest.addDialogStep("Can I have a quest?");
        this.talkToOziach = new NpcStep((QuestHelper)this, 822, new WorldPoint(3068, 3517, 0), "Talk to Oziach in his house in north western Edgeville.", new Requirement[0]);
        this.talkToOziach.addDialogStep("Can you sell me a rune platebody?");
        this.talkToOziach.addDialogStep("The Guildmaster of the Champions' Guild told me.");
        this.talkToOziach.addDialogStep("I thought you were going to give me a quest.");
        this.talkToOziach.addDialogStep("A dragon, that sounds like fun.");
        this.returnToGuildmaster = new NpcStep((QuestHelper)this, 814, new WorldPoint(3190, 3360, 0), "Return to the Guildmaster and ask him all the available questions.", new Requirement[0]);
        this.returnToGuildmaster.addDialogSteps("About my quest to kill the dragon...", "I talked to Oziach...", "Where can I find the right ship?");
        this.askAboutShield = new NpcStep((QuestHelper)this, 814, new WorldPoint(3190, 3360, 0), "Return to the Guildmaster and ask him all the available questions.", new Requirement[0]);
        this.askAboutShield.addDialogSteps("About my quest to kill the dragon...", "I talked to Oziach...", "How can I protect myself from the dragon's breath?");
        this.askAboutMelzar = new NpcStep((QuestHelper)this, 814, new WorldPoint(3190, 3360, 0), "Return to the Guildmaster and ask him all the available questions.", new Requirement[0]);
        this.askAboutMelzar.addDialogSteps("About my quest to kill the dragon...", "I talked to Oziach...", "How can I find the route to Crandor?", "Where is Melzar's map piece?");
        this.askAboutThalzar = new NpcStep((QuestHelper)this, 814, new WorldPoint(3190, 3360, 0), "Return to the Guildmaster and ask him all the available questions.", new Requirement[0]);
        this.askAboutThalzar.addDialogSteps("About my quest to kill the dragon...", "I talked to Oziach...", "How can I find the route to Crandor?", "Where is Thalzar's map piece?");
        this.askAboutLozar = new NpcStep((QuestHelper)this, 814, new WorldPoint(3190, 3360, 0), "Return to the Guildmaster and ask him all the available questions.", new Requirement[0]);
        this.askAboutLozar.addDialogSteps("About my quest to kill the dragon...", "I talked to Oziach...", "How can I find the route to Crandor?", "Where is Lozar's map piece?");
        this.returnToGuildmaster.addSubSteps(this.askAboutShield, this.askAboutMelzar, this.askAboutLozar, this.askAboutThalzar);
        this.talkToOracle = new NpcStep((QuestHelper)this, 821, new WorldPoint(3014, 3501, 0), "Talk to the Oracle on top of Ice Mountain.", this.silk, this.lobsterPot, this.mindBomb, this.unfiredBowl);
        this.talkToOracle.addDialogStep("I seek a piece of the map to the island of Crandor.");
        this.goIntoDwarvenMine = new ObjectStep((QuestHelper)this, 11867, new WorldPoint(3019, 3450, 0), "Go down the ladder in the dwarven camp to the south into the Dwarven Mines.", this.silk, this.lobsterPot, this.mindBomb, this.unfiredBowl);
        this.useSilkOnDoor = new ObjectStep((QuestHelper)this, 25115, new WorldPoint(3050, 9840, 0), "Go to the north east of the Dwarven Mines and use the silk on the magic door.", this.silk, this.lobsterPot, this.mindBomb, this.unfiredBowl);
        this.useSilkOnDoor.addIcon(950);
        this.usePotOnDoor = new ObjectStep((QuestHelper)this, 25115, new WorldPoint(3050, 9840, 0), "Go to the north east of the Dwarven Mines and use the lobster pot on the magic door.", this.lobsterPot, this.mindBomb, this.unfiredBowl);
        this.usePotOnDoor.addIcon(301);
        this.useUnfiredBowlOnDoor = new ObjectStep((QuestHelper)this, 25115, new WorldPoint(3050, 9840, 0), "Go to the north east of the Dwarven Mines and use the unfired bowl on the magic door.", this.mindBomb, this.unfiredBowl);
        this.useUnfiredBowlOnDoor.addIcon(1791);
        this.useMindBombOnDoor = new ObjectStep((QuestHelper)this, 25115, new WorldPoint(3050, 9840, 0), "Go to the north east of the Dwarven Mines and use the wizard's mind bomb on the magic door (BE CAREFUL NOT TO DRINK IT).", this.lobsterPot, this.mindBomb, this.unfiredBowl);
        this.useMindBombOnDoor.addIcon(1907);
        this.searchThalzarChest = new ObjectStep((QuestHelper)this, 2587, new WorldPoint(3057, 9841, 0), "Search the chest for Thalzar's map piece.", new Requirement[0]);
        this.searchThalzarChest2 = new ObjectStep((QuestHelper)this, 2588, new WorldPoint(3057, 9841, 0), "Search the chest for Thalzar's map piece.", new Requirement[0]);
        this.searchThalzarChest.addSubSteps(this.searchThalzarChest2);
        this.optionsForLozarPiece = new NpcStep((QuestHelper)this, 820, new WorldPoint(3015, 3195, 0), "Go to Port Sarim Jail. You can either pay Wormbrain there 10,000 coins for Lozar's map piece, or kill him with ranged/mage and telegrab it with level 33 magic.", this.telegrabOrTenK);
        this.optionsForLozarPiece.addDialogStep("I believe you've got a piece of a map that I need.");
        this.optionsForLozarPiece.addDialogStep("I suppose I could pay you for the map piece...");
        this.optionsForLozarPiece.addDialogStep("Alright then, 10,000 it is.");
        this.enterMelzarsMaze = new ObjectStep((QuestHelper)this, 2595, new WorldPoint(2941, 3248, 0), "Enter Melzar's Maze north of Rimmington. Be prepared to fight multiple monsters up to a level 82 lesser demon.", this.melzarsKey);
        this.enterMelzarsMaze.addDialogSteps("About my quest to kill the dragon...", "I talked to Oziach...", "How can I find the route to Crandor?", "Where is Melzar's map piece?");
        this.killRat = new NpcStep((QuestHelper)this, 3969, new WorldPoint(2933, 3250, 0), "Kill the marked zombie rat for a key.", new Requirement[0]);
        this.openRedDoor = new ObjectStep((QuestHelper)this, 2596, new WorldPoint(2926, 3253, 0), "Go through the north west red door", this.ratKey);
        this.goUpRatLadder = new ObjectStep((QuestHelper)this, 16683, new WorldPoint(2928, 3256, 0), "Climb up the ladder.", new Requirement[0]);
        this.killGhost = new NpcStep((QuestHelper)this, 3975, new WorldPoint(2927, 3253, 1), "Kill the marked ghost for a key.", this.ghostKey);
        this.openOrangeDoor = new ObjectStep((QuestHelper)this, 2597, new WorldPoint(2931, 3253, 1), "Go through second yellow door from the north.", this.ghostKey);
        this.goUpGhostLadder = new ObjectStep((QuestHelper)this, 16683, new WorldPoint(2934, 3254, 1), "Climb up the ladder.", new Requirement[0]);
        this.killSkeleton = new NpcStep((QuestHelper)this, 3972, new WorldPoint(2927, 3253, 2), "Kill the marked skeleton for a key", this.skeletonKey);
        this.openYellowDoor = new ObjectStep((QuestHelper)this, 2598, new WorldPoint(2924, 3249, 2), "Go through south west yellow door.", this.skeletonKey);
        this.goDownSkeletonLadder = new ObjectStep((QuestHelper)this, 16679, new WorldPoint(2940, 3240, 2), "Climb down the ladder.", new Requirement[0]);
        this.goDownLadderRoomLadder = new ObjectStep((QuestHelper)this, 16679, new WorldPoint(2937, 3240, 1), "Climb down again.", new Requirement[0]);
        this.goDownBasementEntryLadder = new ObjectStep((QuestHelper)this, 2605, new WorldPoint(2932, 3240, 0), "Climb down the ladder into the basement.", new Requirement[0]);
        this.killZombie = new NpcStep((QuestHelper)this, 3980, new WorldPoint(2932, 9643, 0), "Kill the marked zombie for a key", this.zombieKey);
        this.openBlueDoor = new ObjectStep((QuestHelper)this, 2599, new WorldPoint(2931, 9644, 0), "Go through the blue door in the north west corner.", new Requirement[0]);
        this.killMelzar = new NpcStep((QuestHelper)this, 823, new WorldPoint(2929, 9649, 0), "Kill Melzar the Mad for a magenta key.", this.melzarKey);
        this.openMagntaDoor = new ObjectStep((QuestHelper)this, 2600, new WorldPoint(2929, 9652, 0), "Go through the magenta door.", new Requirement[0]);
        this.killLesserDemon = new NpcStep((QuestHelper)this, 3982, new WorldPoint(2936, 9652, 0), "Kill the lesser demon. You can safe spot it from the spot east of the magenta door.", this.demonKey);
        this.openGreenDoor = new ObjectStep((QuestHelper)this, 2601, new WorldPoint(2936, 9655, 0), "Go through the green door.", this.demonKey);
        this.openMelzarChest = new ObjectStep((QuestHelper)this, 2603, new WorldPoint(2935, 9657, 0), "Open the chest and get Melzar's map part.", new Requirement[0]);
        this.getShield = new NpcStep((QuestHelper)this, 815, new WorldPoint(3210, 3220, 1), "Talk to Duke Horacio on the first floor of Lumbridge castle for the anti-dragon shield if you don't have one.", new Requirement[0]);
        this.getShield.addDialogStep("I seek a shield that will protect me from dragonbreath.");
        this.getShield.addDialogStep("Elvarg, the dragon of Crandor island!");
        this.getShield.addDialogStep("Yes");
        this.getShield.addDialogStep("So, are you going to give me the shield or not?");
        this.talkToKlarense = new NpcStep((QuestHelper)this, 819, new WorldPoint(3044, 3203, 0), "Talk to Klarense on the south Port Sarim docks and buy his boat.", this.planks3, this.nails90, this.hammer, this.twoThousandCoins);
        this.talkToKlarense.addDialogStep("I'd like to buy her.");
        this.talkToKlarense.addDialogStep("Yep, sounds good.");
        this.boardShip1 = new ObjectStep((QuestHelper)this, 2593, new WorldPoint(3047, 3205, 0), "Board your new ship.", this.nails90, this.planks3, this.hammer);
        this.boardShip2 = new ObjectStep((QuestHelper)this, 2593, new WorldPoint(3047, 3205, 0), "Board your new ship.", this.nails60, this.planks2, this.hammer);
        this.boardShip3 = new ObjectStep((QuestHelper)this, 2593, new WorldPoint(3047, 3205, 0), "Board your new ship.", this.nails30, this.planks1, this.hammer);
        this.boardShip1.addSubSteps(this.boardShip2, this.boardShip3);
        this.goDownShipLadder = new ObjectStep((QuestHelper)this, 2590, new WorldPoint(3049, 3208, 1), "Go down into the ship's hull.", new Requirement[0]);
        this.repairShip = new ObjectStep((QuestHelper)this, 25036, new WorldPoint(3047, 9639, 1), "Repair the hole in the hull 3 times.", this.nails90, this.planks3, this.hammer);
        this.repairShip2 = new ObjectStep((QuestHelper)this, 25036, new WorldPoint(3047, 9639, 1), "Repair the hole in the hull 2 more times.", this.nails60, this.planks2, this.hammer);
        this.repairShip3 = new ObjectStep((QuestHelper)this, 25036, new WorldPoint(3047, 9639, 1), "Repair the hole in the hull 1 more time.", this.nails30, this.planks1, this.hammer);
        this.repairShip.addSubSteps(this.repairShip2, this.repairShip3);
        this.repairMap = new DetailedQuestStep((QuestHelper)this, "Use the three map parts together to repair the map.", this.mapPart1, this.mapPart2, this.mapPart3);
        this.talkToNed = new NpcStep((QuestHelper)this, 4280, new WorldPoint(3098, 3257, 0), "Bring Ned your map and ask him to be your captain.", this.fullMap);
        this.talkToNed.addDialogStep("You're a sailor? Could you take me to Crandor?");
        this.boardShipToGo = new ObjectStep((QuestHelper)this, 2593, new WorldPoint(3047, 3205, 0), "Prepare to fight Elvarg (level 83). When you're ready, go board your boat in Port Sarim and talk to Ned.", this.antidragonShield, this.combatGear);
        this.talkToNedOnShip = new NpcStep((QuestHelper)this, 5864, new WorldPoint(3048, 3208, 1), "Talk to Ned to go to Crandor.", new Requirement[0]);
        this.talkToNedOnShip.addDialogStep("Yes, let's go!");
        this.boardShipToGo.addSubSteps(this.talkToNedOnShip);
        this.enterCrandorHole = new ObjectStep((QuestHelper)this, 25154, new WorldPoint(2834, 3256, 0), "Go to the center of the island and go down the hole.", new Requirement[0]);
        this.unlockShortcut = new ObjectStep((QuestHelper)this, 2606, new WorldPoint(2836, 9600, 0), "Go all the way south and through the wall to unlock the shortcut to return here if needed.", new Requirement[0]);
        this.returnThroughShortcut = new ObjectStep((QuestHelper)this, 2606, new WorldPoint(2836, 9600, 0), "Return back through the shortcut.", new Requirement[0]);
        this.enterElvargArea = new ObjectStep((QuestHelper)this, 25161, new WorldPoint(2846, 9635, 0), "Enter Elvarg's area and kill her.", this.antidragonShieldEquipped);
        this.goDownIntoKaramjaVolcano = new ObjectStep((QuestHelper)this, 11441, new WorldPoint(2857, 3169, 0), "Prepare to fight Elvarg again, and go to the Karamja volcano and enter it.", this.antidragonShieldEquipped, this.combatGear);
        this.repairShipAgainAndSail = new DetailedQuestStep((QuestHelper)this, "As you did not unlock the shortcut, you will need to repair your ship again and sail to Crandor.", this.planks3, this.nails90, this.hammer);
        this.enterElvargArea.addSubSteps(this.goDownIntoKaramjaVolcano, this.repairShipAgainAndSail);
        this.killElvarg = new NpcStep((QuestHelper)this, 8033, new WorldPoint(2855, 9637, 0), "Kill Elvarg.", new Requirement[0]);
        this.finishQuest = new NpcStep((QuestHelper)this, 822, new WorldPoint(3068, 3517, 0), "Talk to Oziach in his house in north western Edgeville to finish the quest.", new Requirement[0]);
    }

    @Override
    public List<String> getCombatRequirements() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("Zombie rats (level 3)");
        reqs.add("Ghosts (level 19)");
        reqs.add("Skeletons (level 22)");
        reqs.add("Zombies (level 24)");
        reqs.add("Melzar the Mad (level 43)");
        reqs.add("Lesser demon (level 82) (safespottable)");
        reqs.add("Elvarg (level 83)");
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.unfiredBowl);
        reqs.add(this.mindBomb);
        reqs.add(this.lobsterPot);
        reqs.add(this.silk);
        reqs.add(this.telegrabOrTenK);
        reqs.add(this.hammer);
        reqs.add(this.planks3);
        reqs.add(this.nails90);
        reqs.add(this.twoThousandCoins);
        reqs.add(this.combatGear);
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.chronicle);
        reqs.add(this.rimmingtonTeleport);
        reqs.add(this.edgevilleTeleport);
        reqs.add(this.ringsOfRecoil);
        reqs.add(this.antifirePotion);
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.STRENGTH, 18650), new ExperienceReward(Skill.DEFENCE, 18650));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("The abiltiy to equip a Green D'hide Body, Rune Platebody & Dragon Platebody"), new UnlockReward("Access to Crandor"), new UnlockReward("Access to the Corsair Cove Resource Area."), new UnlockReward("Ability to receive dragons as a slayer task."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.startQuest, this.talkToOziach, this.returnToGuildmaster), new Requirement[0]));
        PanelDetails thalzarPanel = new PanelDetails("Thalzar's map piece", Arrays.asList(this.talkToOracle, this.goIntoDwarvenMine, this.useSilkOnDoor, this.usePotOnDoor, this.useUnfiredBowlOnDoor, this.useMindBombOnDoor, this.searchThalzarChest), this.silk, this.lobsterPot, this.unfiredBowl, this.mindBomb);
        thalzarPanel.setLockingStep(this.getThalzarPiece);
        allSteps.add(thalzarPanel);
        PanelDetails lozarPanel = new PanelDetails("Lozar's map piece", Collections.singletonList(this.optionsForLozarPiece), this.telegrabOrTenK);
        lozarPanel.setLockingStep(this.getLozarPiece);
        allSteps.add(lozarPanel);
        PanelDetails melzarPanel = new PanelDetails("Melzar's map piece", Arrays.asList(this.enterMelzarsMaze, this.killRat, this.openRedDoor, this.goUpRatLadder, this.killGhost, this.openOrangeDoor, this.goUpGhostLadder, this.killSkeleton, this.openYellowDoor, this.goDownSkeletonLadder, this.goDownLadderRoomLadder, this.goDownBasementEntryLadder, this.killZombie, this.openBlueDoor, this.killMelzar, this.openMagntaDoor, this.killLesserDemon, this.openGreenDoor, this.openMelzarChest), this.melzarsKey, this.combatGear, this.food);
        melzarPanel.setLockingStep(this.getMelzarPiece);
        allSteps.add(melzarPanel);
        PanelDetails antiDragonPanel = new PanelDetails("Get an anti-dragon shield", Collections.singletonList(this.getShield), new Requirement[0]);
        antiDragonPanel.setLockingStep(this.getShieldSteps);
        allSteps.add(antiDragonPanel);
        PanelDetails boatPanel = new PanelDetails("Get a boat", Arrays.asList(this.talkToKlarense, this.boardShip1, this.goDownShipLadder, this.repairShip), this.hammer, this.planks3, this.nails90, this.twoThousandCoins);
        allSteps.add(boatPanel);
        PanelDetails captainPanel = new PanelDetails("Get a captain ready", Arrays.asList(this.repairMap, this.talkToNed), new Requirement[0]);
        allSteps.add(captainPanel);
        allSteps.add(new PanelDetails("Slaying Elvarg", Arrays.asList(this.boardShipToGo, this.enterCrandorHole, this.unlockShortcut, this.returnThroughShortcut, this.enterElvargArea, this.killElvarg), this.combatGear, this.antidragonShield, this.food));
        allSteps.add(new PanelDetails("Finish the quest", Collections.singletonList(this.finishQuest), new Requirement[0]));
        return allSteps;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        return Collections.singletonList(new QuestPointRequirement(32));
    }
}

