/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.doricsquest;

import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.DORICS_QUEST)
public class DoricsQuest
extends BasicQuestHelper {
    ItemRequirement clay;
    ItemRequirement copper;
    ItemRequirement iron;
    QuestStep talkToDoric;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToDoric);
        steps.put(10, this.talkToDoric);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.clay = new ItemRequirement("Clay (UNNOTED)", 434, 6);
        this.copper = new ItemRequirement("Copper ore (UNNOTED)", 436, 4);
        this.iron = new ItemRequirement("Iron ore (UNNOTED)", 440, 2);
    }

    public void setupSteps() {
        this.talkToDoric = new NpcStep((QuestHelper)this, 3893, new WorldPoint(2951, 3451, 0), "Bring Doric north of Falador all the required items. You can mine them all in the Dwarven Mines, or buy them from the Grand Exchange.", this.clay, this.copper, this.iron);
        this.talkToDoric.addDialogStep("I wanted to use your anvils.");
        this.talkToDoric.addDialogStep("Yes, I will get you the materials.");
    }

    @Override
    public List<Requirement> getGeneralRecommended() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new SkillRequirement(Skill.MINING, 15, true, "15 Mining to get ores yourself"));
        return req;
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.clay);
        reqs.add(this.copper);
        reqs.add(this.iron);
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.MINING, 1300));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Coins", 995, 180));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Use of Doric's Anvil"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Help Doric", Collections.singletonList(this.talkToDoric), this.clay, this.copper, this.iron));
        return allSteps;
    }
}

