/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.deviousminds;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.DEVIOUS_MINDS)
public class DeviousMinds
extends BasicQuestHelper {
    ItemRequirement fallyTele;
    ItemRequirement lumberTele;
    ItemRequirement glory;
    ItemRequirement mith2h;
    ItemRequirement bowString;
    ItemRequirement largePouch;
    ItemRequirement slenderBlade;
    ItemRequirement bowSword;
    ItemRequirement orb;
    ItemRequirement illumPouch;
    ItemRequirement noEquipment;
    QuestStep talkToMonk;
    QuestStep talkToMonk2;
    QuestStep teleToAbyss;
    QuestStep enterLawRift;
    QuestStep leaveLawAltar;
    QuestStep talkToHighPriest;
    QuestStep talkToSirTiffy;
    QuestStep talkToEntranaMonk;
    QuestStep makeBlade;
    QuestStep makeBowSword;
    QuestStep makeIllumPouch;
    QuestStep usePouchOnAltar;
    QuestStep gotoDeadMonk;
    QuestStep useGangPlank;
    Requirement inAbyss;
    Requirement inLawAlter;
    Requirement onEntrana;
    Requirement onEntranaBoat;
    Zone abyss;
    Zone lawAltar;
    Zone entrana;
    Zone entranaBoat;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToMonk);
        ConditionalStep makeEntireBowSword = new ConditionalStep((QuestHelper)this, this.makeBlade, new Requirement[0]);
        makeEntireBowSword.addStep(this.bowSword.alsoCheckBank(this.questBank), this.talkToMonk2);
        makeEntireBowSword.addStep(this.slenderBlade.alsoCheckBank(this.questBank), this.makeBowSword);
        steps.put(10, makeEntireBowSword);
        steps.put(20, this.talkToMonk2);
        ConditionalStep entranaAltarPouch = new ConditionalStep((QuestHelper)this, this.makeIllumPouch, new Requirement[0]);
        entranaAltarPouch.addStep(new Conditions(this.illumPouch.alsoCheckBank(this.questBank), this.onEntrana), this.usePouchOnAltar);
        entranaAltarPouch.addStep(new Conditions(this.illumPouch.alsoCheckBank(this.questBank), this.inLawAlter), this.leaveLawAltar);
        entranaAltarPouch.addStep(new Conditions(this.illumPouch.alsoCheckBank(this.questBank), this.inAbyss), this.enterLawRift);
        entranaAltarPouch.addStep(this.illumPouch.alsoCheckBank(this.questBank), this.teleToAbyss);
        steps.put(30, entranaAltarPouch);
        steps.put(40, entranaAltarPouch);
        steps.put(50, this.gotoDeadMonk);
        ConditionalStep backToEntrana = new ConditionalStep((QuestHelper)this, this.talkToEntranaMonk, new Requirement[0]);
        backToEntrana.addStep(this.onEntrana, this.talkToHighPriest);
        backToEntrana.addStep(this.onEntranaBoat, this.useGangPlank);
        steps.put(60, backToEntrana);
        steps.put(70, this.talkToSirTiffy);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.fallyTele = new ItemRequirement("Falador Teleports", 8009);
        this.lumberTele = new ItemRequirement("Lumberyard Teleports", 12642);
        this.glory = new ItemRequirement("Amulet of Glory", ItemCollections.AMULET_OF_GLORIES);
        this.mith2h = new ItemRequirement("Mithril 2h Sword", 1315);
        this.mith2h.setHighlightInInventory(true);
        this.bowString = new ItemRequirement("Bow String", 1777);
        this.bowString.setHighlightInInventory(true);
        this.largePouch = new ItemRequirement("Large/Colossal Pouch (non-degraded)", 5512);
        this.largePouch.addAlternates(6819, 26784, 26906);
        this.largePouch.setHighlightInInventory(true);
        this.slenderBlade = new ItemRequirement("Slender Blade", 6817);
        this.slenderBlade.setHighlightInInventory(true);
        this.bowSword = new ItemRequirement("Bow Sword", 6818);
        this.orb = new ItemRequirement("Orb", 6821);
        this.orb.setHighlightInInventory(true);
        this.illumPouch = new ItemRequirement("Illuminated Pouch", 6819);
        this.illumPouch.addAlternates(26906);
        this.noEquipment = new ItemRequirement("Banked all equipment and weapons", -1, -1);
    }

    public void setupConditions() {
        this.inAbyss = new ZoneRequirement(this.abyss);
        this.inLawAlter = new ZoneRequirement(this.lawAltar);
        this.onEntrana = new ZoneRequirement(this.entrana);
        this.onEntranaBoat = new ZoneRequirement(this.entranaBoat);
    }

    public void loadZones() {
        this.abyss = new Zone(new WorldPoint(3005, 4800, 0), new WorldPoint(3070, 4860, 0));
        this.lawAltar = new Zone(new WorldPoint(2429, 4801, 0), new WorldPoint(2480, 4850, 0));
        this.entrana = new Zone(new WorldPoint(2799, 3393, 0), new WorldPoint(2880, 3330, 0));
        this.entranaBoat = new Zone(new WorldPoint(2824, 3333, 1), new WorldPoint(2841, 3328, 1));
    }

    public void setupSteps() {
        this.talkToMonk = new NpcStep((QuestHelper)this, 4563, new WorldPoint(3406, 3494, 0), "Start by talking to the Monk outside the Paterdomus temple, east of Varrock.", new Requirement[0]);
        this.talkToMonk.addDialogStep("Sure thing, what do you need?");
        this.makeBlade = new ObjectStep((QuestHelper)this, 10641, new WorldPoint(2953, 3452, 0), "Use the Mithril 2H sword on Doric's Whetstone. (Doric is located north of Falador).", this.mith2h);
        this.makeBlade.addIcon(1315);
        this.makeBowSword = new DetailedQuestStep((QuestHelper)this, "Use the bow-string on the Slender blade to make the Bow-sword.", this.bowString, this.slenderBlade);
        this.talkToMonk2 = new NpcStep((QuestHelper)this, 4563, new WorldPoint(3406, 3494, 0), "Return to the monk near the Paterdomus temple with the bow-sword.", this.bowSword);
        this.talkToMonk2.addDialogStep("Yep, got it right here for you.");
        this.makeIllumPouch = new DetailedQuestStep((QuestHelper)this, "Use the Orb on the Large/Colossal Pouch.", this.orb, this.largePouch);
        this.teleToAbyss = new NpcStep((QuestHelper)this, 2581, new WorldPoint(3106, 3556, 0), "Teleport with the Mage of Zamorak IN THE WILDERNESS to the Abyss. You will be attacked by monsters upon entering, and your prayer drained to 0!", this.illumPouch, this.noEquipment);
        this.enterLawRift = new ObjectStep((QuestHelper)this, 25034, new WorldPoint(3049, 4839, 0), "Enter the central area through a gap/passage/eyes. Enter the Law Rift.", this.illumPouch, this.noEquipment);
        this.leaveLawAltar = new ObjectStep((QuestHelper)this, 34755, new WorldPoint(2464, 4817, 0), "Enter the portal to leave the Law Altar.", this.illumPouch, this.noEquipment);
        this.usePouchOnAltar = new ObjectStep((QuestHelper)this, 10638, new WorldPoint(2853, 3349, 0), "Use the illuminated pouch on the Altar in the Entrana Church.", this.illumPouch.highlighted());
        this.usePouchOnAltar.addIcon(6819);
        this.gotoDeadMonk = new NpcStep((QuestHelper)this, 4564, new WorldPoint(3406, 3494, 0), "Go back to the monk near Paterdomus temple and search the dead monk's body.", new Requirement[0]);
        this.talkToEntranaMonk = new NpcStep((QuestHelper)this, 1165, new WorldPoint(3045, 3236, 0), "Talk to the Monk of Entrana to go to Entrana.", this.noEquipment);
        this.useGangPlank = new ObjectStep((QuestHelper)this, 2415, new WorldPoint(2834, 3333, 1), "Use the gangplank to disembark the boat.", new Requirement[0]);
        this.talkToHighPriest = new NpcStep((QuestHelper)this, 4062, new WorldPoint(2851, 3349, 0), "Talk to the High Priest in the Entrana Church (Rat Pits Port Sarim Minigame teleport is the closest teleport).", new Requirement[0]);
        this.talkToHighPriest.addSubSteps(this.useGangPlank);
        this.talkToHighPriest.addSubSteps(this.talkToEntranaMonk);
        this.talkToSirTiffy = new NpcStep((QuestHelper)this, 4687, new WorldPoint(2997, 3373, 0), "Talk to Sir Tiffy Cashien in Falador park to complete the quest.", new Requirement[0]);
        this.talkToSirTiffy.addDialogStep("Devious Minds.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return new ArrayList<ItemRequirement>(Arrays.asList(this.mith2h, this.bowString, this.largePouch));
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return new ArrayList<ItemRequirement>(Arrays.asList(this.fallyTele, this.lumberTele, this.glory));
    }

    @Override
    public List<String> getCombatRequirements() {
        return new ArrayList<String>(Collections.singletonList("Survive against Abyssal Creatures in multicombat in the Abyss"));
    }

    @Override
    public List<String> getNotes() {
        return Arrays.asList("You will need to enter the Wilderness briefly during the quest. Other players can attack and kill you here, so don't bring anything you're not willing to lose!", "You will enter the Abyss briefly during this quest. This is full of aggressive monsters in multi-combat, and your prayer will be drained to 0 upon entering!");
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new SkillRequirement(Skill.SMITHING, 65, true));
        reqs.add(new SkillRequirement(Skill.RUNECRAFT, 50, false));
        reqs.add(new SkillRequirement(Skill.FLETCHING, 50, true));
        reqs.add(new QuestRequirement(QuestHelperQuest.WANTED, QuestState.FINISHED));
        reqs.add(new QuestRequirement(QuestHelperQuest.TROLL_STRONGHOLD, QuestState.FINISHED));
        reqs.add(new QuestRequirement(QuestHelperQuest.DORICS_QUEST, QuestState.FINISHED));
        reqs.add(new QuestRequirement(QuestHelperQuest.ENTER_THE_ABYSS, QuestState.FINISHED));
        reqs.add(new VarbitRequirement(626, Operation.GREATER_EQUAL, 1, "Talked to the Zamorak Mage in Varrock after Enter the Abyss"));
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.FLETCHING, 5000), new ExperienceReward(Skill.RUNECRAFT, 5000), new ExperienceReward(Skill.SMITHING, 6500));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Collections.singletonList(this.talkToMonk), new Requirement[0]));
        allSteps.add(new PanelDetails("Making the Bow-sword", Arrays.asList(this.makeBlade, this.makeBowSword), this.mith2h, this.bowString));
        allSteps.add(new PanelDetails("A Gift for Entrana", Arrays.asList(this.talkToMonk2, this.makeIllumPouch, this.teleToAbyss, this.enterLawRift, this.leaveLawAltar, this.usePouchOnAltar), this.largePouch));
        allSteps.add(new PanelDetails("Surprise!", Arrays.asList(this.gotoDeadMonk, this.talkToHighPriest, this.talkToSirTiffy), new Requirement[0]));
        return allSteps;
    }
}

