/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.deserttreasureii;

import com.questhelper.bank.QuestBank;
import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questhelpers.QuestUtil;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.Arrays;
import java.util.List;
import net.runelite.api.coords.WorldPoint;

public class VardorvisSteps
extends ConditionalStep {
    ItemRequirement xericTalisman;
    ItemRequirement combatGear;
    ItemRequirement nardahTeleport;
    DetailedQuestStep talkToElissa;
    DetailedQuestStep talkToBarus;
    DetailedQuestStep searchDesk;
    DetailedQuestStep readPotionNote;
    DetailedQuestStep drinkPotion;
    DetailedQuestStep boardBoat;
    DetailedQuestStep runIntoStanglewood;
    DetailedQuestStep talkToKasonde;
    DetailedQuestStep enterEntry;
    DetailedQuestStep defendKasonde;
    DetailedQuestStep defendKasondeSidebar;
    DetailedQuestStep leaveTowerDefenseRoom;
    DetailedQuestStep talkToKasondeAfterTowerDefense;
    DetailedQuestStep getBerry;
    DetailedQuestStep getHerb;
    DetailedQuestStep getHerbSidebar;
    DetailedQuestStep goDownToKasonde;
    DetailedQuestStep defendKasondeHerb;
    DetailedQuestStep talkToKasondeWithHerbAndBerry;
    DetailedQuestStep addHerb;
    DetailedQuestStep addBerry;
    DetailedQuestStep drinkStranglewoodPotion;
    DetailedQuestStep goToRitualSite;
    DetailedQuestStep fightVardorvis;
    DetailedQuestStep fightVardorvisSidebar;
    DetailedQuestStep pickUpTempleKey;
    DetailedQuestStep getTempleKeyFromRocks;
    DetailedQuestStep returnToDesertWithVardorvisMedallion;
    DetailedQuestStep useVardorvisMedallionOnStatue;
    ConditionalStep returnToKasondeWithTempleKey;
    ConditionalStep defeatKasonde;
    ConditionalStep goTalkToKasondeAfterFight;
    ConditionalStep goGetVardorvisMedallion;
    Requirement talkedToElissa;
    Requirement talkedToBarus;
    Requirement haveReadPotionNote;
    Requirement haveDrunkPotion;
    Requirement inStrangewood;
    Requirement finishedStranglewoodCutscene;
    Requirement talkedToKasonde;
    Requirement inTowerDefenseRoom;
    Requirement defendedKasonde;
    Requirement toldAboutHerbAndBerry;
    Requirement herbTaken;
    Requirement berryTaken;
    Requirement inStranglewoodPyramidRoom;
    Requirement defendedKasondeWithHerb;
    Requirement receivedSerum;
    Requirement addedHerb;
    Requirement addedBerry;
    Requirement drankPotion;
    Requirement inAnyStranglewood;
    Requirement inVardorvisArea;
    Requirement defeatedVardorvis;
    Requirement templeKeyNearby;
    Requirement kasondeAggressive;
    Requirement givenKasondeKey;
    Requirement defeatedKasonde;
    Requirement kasondeRevealedMedallion;
    Requirement gotVardorvisMedallion;
    Requirement inVault;
    ItemRequirement potionNote;
    ItemRequirement strangePotion;
    ItemRequirement freezes;
    ItemRequirement berry;
    ItemRequirement herb;
    ItemRequirement unfinishedSerum;
    ItemRequirement serumWithHerb;
    ItemRequirement stranglerSerum;
    ItemRequirement templeKey;
    ItemRequirement vardorvisMedallion;
    Zone stranglewood;
    Zone towerDefenseRoom;
    Zone stranglewoodPyramidRoom;
    Zone vardorvisArea;
    Zone vault;
    QuestBank questBank;

    public VardorvisSteps(QuestHelper questHelper, NpcStep defaultStep, QuestBank questBank) {
        super(questHelper, (QuestStep)defaultStep, new Requirement[0]);
        this.questBank = questBank;
        this.talkToElissa = defaultStep;
        this.setupItemRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        this.addStep(new Conditions(this.gotVardorvisMedallion, this.inVault), this.useVardorvisMedallionOnStatue);
        this.addStep(this.gotVardorvisMedallion, this.returnToDesertWithVardorvisMedallion);
        this.addStep(this.kasondeRevealedMedallion, this.goGetVardorvisMedallion);
        this.addStep(this.defeatedKasonde, this.goTalkToKasondeAfterFight);
        this.addStep(this.kasondeAggressive, this.defeatKasonde);
        this.addStep(this.defeatedVardorvis, this.returnToKasondeWithTempleKey);
        this.addStep(new Conditions(this.inVardorvisArea, this.defeatedVardorvis), this.pickUpTempleKey);
        this.addStep(new Conditions(this.inVardorvisArea, this.drankPotion), this.fightVardorvis);
        this.addStep(new Conditions(this.inAnyStranglewood, this.drankPotion), this.goToRitualSite);
        this.addStep(new Conditions(this.inAnyStranglewood, this.addedBerry), this.drinkStranglewoodPotion);
        this.addStep(new Conditions(this.inAnyStranglewood, this.addedHerb), this.addBerry);
        this.addStep(new Conditions(this.inAnyStranglewood, this.receivedSerum), this.addHerb);
        this.addStep(new Conditions(this.inStranglewoodPyramidRoom, this.defendedKasondeWithHerb, this.herbTaken, this.berryTaken), this.talkToKasondeWithHerbAndBerry);
        this.addStep(new Conditions(this.inStranglewoodPyramidRoom, this.herbTaken, this.berryTaken), this.defendKasondeHerb);
        this.addStep(new Conditions(this.inStrangewood, this.herbTaken, this.berryTaken), this.goDownToKasonde);
        this.addStep(new Conditions(this.inStrangewood, this.herbTaken), this.getBerry);
        this.addStep(new Conditions(this.inStrangewood, this.toldAboutHerbAndBerry), this.getHerb);
        this.addStep(new Conditions(this.inTowerDefenseRoom, this.defendedKasonde), this.leaveTowerDefenseRoom);
        this.addStep(new Conditions(this.inStrangewood, this.defendedKasonde), this.talkToKasondeAfterTowerDefense);
        this.addStep(new Conditions(this.inTowerDefenseRoom), this.defendKasonde);
        this.addStep(new Conditions(this.inStrangewood, this.talkedToKasonde), this.enterEntry);
        this.addStep(new Conditions(this.inStrangewood, this.finishedStranglewoodCutscene), this.talkToKasonde);
        this.addStep(new Conditions(this.inStrangewood), this.runIntoStanglewood);
        this.addStep(new Conditions(this.haveDrunkPotion), this.boardBoat);
        this.addStep(new Conditions(this.haveReadPotionNote, this.strangePotion.alsoCheckBank(questBank)), this.drinkPotion);
        this.addStep(new Conditions(new Conditions(LogicType.NOR, this.haveReadPotionNote), this.potionNote.alsoCheckBank(questBank)), this.readPotionNote);
        this.addStep(this.talkedToBarus, this.searchDesk);
        this.addStep(this.talkedToElissa, this.talkToBarus);
    }

    protected void setupZones() {
        this.vault = new Zone(new WorldPoint(3925, 9620, 1), new WorldPoint(3949, 9643, 1));
        this.stranglewood = new Zone(new WorldPoint(1087, 3264, 0), new WorldPoint(1261, 3458, 0));
        this.towerDefenseRoom = new Zone(new WorldPoint(1160, 9740, 0), new WorldPoint(1210, 9780, 0));
        this.stranglewoodPyramidRoom = new Zone(new WorldPoint(1177, 9810, 0), new WorldPoint(1190, 9846, 0));
        this.vardorvisArea = new Zone(new WorldPoint(1119, 3405, 0), new WorldPoint(1140, 3430, 0));
    }

    protected void setupItemRequirements() {
        VarbitRequirement nardahTeleportInBook = new VarbitRequirement(5672, 1, Operation.GREATER_EQUAL);
        this.nardahTeleport = new ItemRequirement("Nardah teleport, or Fairy Ring to DLQ", 13136);
        this.nardahTeleport.setAdditionalOptions(nardahTeleportInBook);
        this.nardahTeleport.addAlternates(13135, 12402, 13134);
        this.nardahTeleport.addAlternates(ItemCollections.FAIRY_STAFF);
        this.combatGear = new ItemRequirement("Combat gear", -1, -1);
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.xericTalisman = new ItemRequirement("Xeric's talisman", 13393);
        this.potionNote = new ItemRequirement("Potion note", 28382);
        this.strangePotion = new ItemRequirement("Strange potion", 28383);
        this.freezes = new ItemRequirement("Freezing spells STRONGLY recommended + reasonable mage accuracy", -1);
        this.berry = new ItemRequirement("Argian berries", 28385);
        this.berry.setTooltip("You can get another from the south-west corner of The Stranglewood");
        this.herb = new ItemRequirement("Korbal herb", 28384);
        this.herb.setTooltip("You can get another from the north-west corner of The Stranglewood");
        this.unfinishedSerum = new ItemRequirement("Unfinished serum", 28386);
        this.serumWithHerb = new ItemRequirement("Unfinished serum (herb added)", 28387);
        this.stranglerSerum = new ItemRequirement("Strangler serum", 28388);
        this.templeKey = new ItemRequirement("Temple key", 28389);
        this.vardorvisMedallion = new ItemRequirement("Vardorvis' medallion", 28404);
        this.vardorvisMedallion.setTooltip("You can get another from Kasonde's hideout");
    }

    protected void setupConditions() {
        this.inVault = new ZoneRequirement(this.vault);
        this.talkedToElissa = new VarbitRequirement(15125, 4, Operation.GREATER_EQUAL);
        this.talkedToBarus = new VarbitRequirement(15125, 6, Operation.GREATER_EQUAL);
        this.haveReadPotionNote = new VarbitRequirement(15125, 8, Operation.GREATER_EQUAL);
        this.haveDrunkPotion = new VarbitRequirement(15125, 10, Operation.GREATER_EQUAL);
        this.inStrangewood = new ZoneRequirement(this.stranglewood);
        this.finishedStranglewoodCutscene = new VarbitRequirement(15125, 16, Operation.GREATER_EQUAL);
        this.talkedToKasonde = new VarbitRequirement(15125, 18, Operation.GREATER_EQUAL);
        this.inTowerDefenseRoom = new ZoneRequirement(this.towerDefenseRoom);
        this.defendedKasonde = new VarbitRequirement(15125, 22, Operation.GREATER_EQUAL);
        this.toldAboutHerbAndBerry = new VarbitRequirement(15125, 24, Operation.GREATER_EQUAL);
        this.herbTaken = new VarbitRequirement(15136, 2);
        this.berryTaken = new VarbitRequirement(15137, 1);
        this.inStranglewoodPyramidRoom = new ZoneRequirement(this.stranglewoodPyramidRoom);
        this.defendedKasondeWithHerb = new VarbitRequirement(15125, 34, Operation.GREATER_EQUAL);
        this.receivedSerum = new VarbitRequirement(15125, 36, Operation.GREATER_EQUAL);
        this.addedHerb = this.serumWithHerb.alsoCheckBank(this.questBank);
        this.addedBerry = this.stranglerSerum.alsoCheckBank(this.questBank);
        this.drankPotion = new VarbitRequirement(15125, 38, Operation.GREATER_EQUAL);
        this.inAnyStranglewood = new Conditions(LogicType.OR, this.inStranglewoodPyramidRoom, this.inStrangewood);
        this.defeatedVardorvis = new VarbitRequirement(15125, 42, Operation.GREATER_EQUAL);
        this.inVardorvisArea = new ZoneRequirement(this.vardorvisArea);
        this.templeKeyNearby = new ItemOnTileRequirement(this.templeKey);
        this.givenKasondeKey = new VarbitRequirement(15125, 46, Operation.GREATER_EQUAL);
        this.kasondeAggressive = new VarbitRequirement(15125, 48, Operation.GREATER_EQUAL);
        this.defeatedKasonde = new VarbitRequirement(15125, 50, Operation.GREATER_EQUAL);
        this.kasondeRevealedMedallion = new VarbitRequirement(15125, 52, Operation.GREATER_EQUAL);
        this.gotVardorvisMedallion = new VarbitRequirement(15125, 54, Operation.GREATER_EQUAL);
    }

    protected void setupSteps() {
        this.talkToBarus = new NpcStep(this.getQuestHelper(), 12255, new WorldPoint(1459, 3782, 0), "Talk to Barus near the burning man in south-west Lovakengj.", new Requirement[0]);
        this.talkToBarus.addTeleport(this.xericTalisman.named("Xeric's talisman ([3] Xeric's Inferno)"));
        this.searchDesk = new ObjectStep(this.getQuestHelper(), 49490, new WorldPoint(1781, 3619, 0), "Search the desk in the house south of the Hosidius Estate Agent.", new Requirement[0]);
        this.searchDesk.addTeleport(this.xericTalisman.named("Xeric's talisman ([2] Xeric's Glade)"));
        this.readPotionNote = new ItemStep(this.getQuestHelper(), "Read the potion note.", this.potionNote.highlighted());
        this.drinkPotion = new ItemStep(this.getQuestHelper(), "Drink the strange potion.", this.strangePotion.highlighted());
        this.boardBoat = new ObjectStep(this.getQuestHelper(), 49491, new WorldPoint(1227, 3470, 0), "Board the boat south of Quidamortem into The Stranglewood. You can use the Fairy Ring BLS to get nearby, or travel with the Mountain Guide.", new Requirement[0]);
        this.runIntoStanglewood = new DetailedQuestStep(this.getQuestHelper(), new WorldPoint(1194, 3394, 0), "Run deeper into Stranglewood. Be careful of the Strangled, as they'll bind you and deal damage.", new Requirement[0]);
        this.talkToKasonde = new NpcStep(this.getQuestHelper(), 12256, new WorldPoint(1191, 3404, 0), "Talk to Kasonde.", new Requirement[0]);
        this.enterEntry = new ObjectStep(this.getQuestHelper(), 48722, new WorldPoint(1191, 3411, 0), "Hide away in the Entry in the north-west of the room.", new Requirement[0]);
        this.defendKasondeSidebar = new NpcStep(this.getQuestHelper(), 12275, "Defend Kasonde! There are barricades in the stone chests you can set up to block routes. There are also satchels you can place on the floor, and detonate using the Detonator. This will kill all of the Strangled in a 7x7 area, as well as damaging you or Kasonde if either of you are in the blast radius.", true, new Requirement[0]);
        this.defendKasondeSidebar.addText("Closed chests require you to guess the correct code to open, with correct numbers in the correct place being marked in green, and correct numbers in the wrong places being marked with blue.");
        this.defendKasondeSidebar.addText("It's recommended to also use freezes if you have ancient magicks with you to keep them off of Kasonde. If you have freezes, you can largely ignore the barricading and explosives.");
        ((NpcStep)this.defendKasondeSidebar).addAlternateNpcs(12276, 12277, 12278);
        this.defendKasonde = new DetailedQuestStep(this.getQuestHelper(), "Defend Kasonde! Read the sidebar for more details.", new Requirement[0]);
        this.defendKasonde.addRecommended(this.freezes);
        this.defendKasondeSidebar.addSubSteps(this.defendKasonde);
        this.leaveTowerDefenseRoom = new ObjectStep(this.getQuestHelper(), 48732, new WorldPoint(1187, 9764, 0), "Leave the dungeon up the ladder.", new Requirement[0]);
        this.talkToKasondeAfterTowerDefense = new NpcStep(this.getQuestHelper(), 12256, new WorldPoint(1191, 3404, 0), "Talk to Kasonde on the surface.", new Requirement[0]);
        this.getHerb = new ObjectStep(this.getQuestHelper(), 48738, new WorldPoint(1155, 3447, 0), "Go get the herb from the north-west corner of the area. The stangled will attack you, so bring food and freezes to trap them. More info in the sidebar.", new Requirement[0]);
        this.getHerb.setLinePoints(Arrays.asList(new WorldPoint(1193, 3403, 0), new WorldPoint(1193, 3395, 0), new WorldPoint(1186, 3395, 0), new WorldPoint(1186, 3416, 0), new WorldPoint(1165, 3415, 0), new WorldPoint(1161, 3415, 0), new WorldPoint(1161, 3426, 0), new WorldPoint(1159, 3426, 0), new WorldPoint(1159, 3428, 0), new WorldPoint(1161, 3441, 0)));
        this.getHerbSidebar = new ObjectStep(this.getQuestHelper(), 48738, new WorldPoint(1111, 3434, 0), "Go get the herb. The Strangled will attack you, so have food. If your infected bar reaches full, you'll be teleported to the starting room again. ", new Requirement[0]);
        this.getHerbSidebar.addText("You can get some stink bombs from the chest in the south-east corner of Kasonde's room, which when used attract the Strangled to the location. This can be useful for avoiding them.");
        this.getHerbSidebar.addText("Freezes and blood spells are useful for trapping them and healing up.");
        this.getHerbSidebar.addSubSteps(this.getHerb);
        this.getBerry = new ObjectStep(this.getQuestHelper(), 48736, new WorldPoint(1126, 3323, 0), "Get the berry from the south-west part of the area. Beware the Strangled still.", new Requirement[0]);
        this.getBerry.setLinePoints(Arrays.asList(new WorldPoint(1161, 3441, 0), new WorldPoint(1159, 3428, 0), new WorldPoint(1159, 3426, 0), new WorldPoint(1161, 3426, 0), new WorldPoint(1162, 3415, 0), new WorldPoint(1162, 3404, 0), new WorldPoint(1162, 3399, 0), new WorldPoint(1163, 3399, 0), new WorldPoint(1163, 3381, 0), new WorldPoint(1148, 3378, 0), new WorldPoint(1145, 3373, 0), new WorldPoint(1144, 3342, 0), new WorldPoint(1126, 3323, 0)));
        this.goDownToKasonde = new ObjectStep(this.getQuestHelper(), 48723, new WorldPoint(1174, 3428, 0), "Go to Kasonde, who is inside the main pyramid of the area to the north. Be ready to fight a few Strangled.", this.combatGear, this.berry, this.herb);
        this.goDownToKasonde.setLinePoints(Arrays.asList(new WorldPoint(1126, 3323, 0), new WorldPoint(1144, 3342, 0), new WorldPoint(1144, 3357, 0), new WorldPoint(1145, 3373, 0), new WorldPoint(1148, 3378, 0), new WorldPoint(1163, 3381, 0), new WorldPoint(1163, 3399, 0), new WorldPoint(1162, 3399, 0), new WorldPoint(1162, 3404, 0), new WorldPoint(1162, 3415, 0), new WorldPoint(1174, 3416, 0), new WorldPoint(1174, 3427, 0)));
        this.defendKasondeHerb = new NpcStep(this.getQuestHelper(), 12280, new WorldPoint(1183, 9824, 0), "Defeat the Strangled attacking Kasonde.", true, new Requirement[0]);
        ((NpcStep)this.defendKasondeHerb).addAlternateNpcs(12279);
        this.talkToKasondeWithHerbAndBerry = new NpcStep(this.getQuestHelper(), 12258, new WorldPoint(1183, 9824, 0), "Talk to Kasonde.", this.berry, this.herb);
        this.addHerb = new DetailedQuestStep(this.getQuestHelper(), "Add the herb to unfinished serum.", this.herb.highlighted(), this.unfinishedSerum.highlighted());
        this.addBerry = new DetailedQuestStep(this.getQuestHelper(), "Add the berries to the serum.", this.serumWithHerb.highlighted(), this.berry.highlighted());
        this.drinkStranglewoodPotion = new DetailedQuestStep(this.getQuestHelper(), "Drink the strangler serum.", this.stranglerSerum.highlighted());
        this.goToRitualSite = new ObjectStep(this.getQuestHelper(), 49495, new WorldPoint(1118, 3428, 0), "Go to the ritual site to the west, ready to fight the boss of the area.", this.combatGear);
        this.goToRitualSite.setLinePoints(Arrays.asList(new WorldPoint(1174, 3427, 0), new WorldPoint(1174, 3416, 0), new WorldPoint(1162, 3415, 0), new WorldPoint(1162, 3404, 0), new WorldPoint(1162, 3399, 0), new WorldPoint(1162, 3399, 0), new WorldPoint(1163, 3399, 0), new WorldPoint(1163, 3381, 0), new WorldPoint(1148, 3378, 0), new WorldPoint(1145, 3373, 0), new WorldPoint(1144, 3357, 0), new WorldPoint(1144, 3342, 0), new WorldPoint(1126, 3344, 0), new WorldPoint(1116, 3344, 0), new WorldPoint(1115, 3355, 0), new WorldPoint(1109, 3356, 0), new WorldPoint(1109, 3383, 0), new WorldPoint(1111, 3400, 0), new WorldPoint(1106, 3410, 0), new WorldPoint(1106, 3434, 0), new WorldPoint(1112, 3435, 0), new WorldPoint(1124, 3423, 0), new WorldPoint(0, 0, 0), new WorldPoint(1196, 3450, 0), new WorldPoint(1197, 3428, 0), new WorldPoint(1216, 3412, 0), new WorldPoint(1215, 3395, 0), new WorldPoint(1188, 3395, 0), new WorldPoint(1163, 3395, 0)));
        this.fightVardorvis = new NpcStep(this.getQuestHelper(), 12223, new WorldPoint(1129, 3419, 0), "Defeat Vardorvis, who's weak to slash. Look at the sidebar for more details. Protect from Melee when he's not using a special attack.", new Requirement[0]);
        ((NpcStep)this.fightVardorvis).addAlternateNpcs(12224, 12228, 12425, 12426);
        this.fightVardorvisSidebar = new DetailedQuestStep(this.getQuestHelper(), "Defeat Vardorvis. He's weak to slash weapons, and uses Melee. It's recommended to watch a video to get an understanding of his abilities.", new Requirement[0]);
        this.fightVardorvisSidebar.addText("Swinging axes: He will spawn axes around the arena, which will go to the opposite corner to which they appear. Avoid them.");
        this.fightVardorvisSidebar.addText("Homing spikes: Vardorvis hits the ground, causing a spike to appear under you. Move off the tile to avoid.");
        this.fightVardorvisSidebar.addText("Head projectile: A tentacle will appear with a head on it, firing a green projectile. Protect from Missiles should be flicked to.");
        this.fightVardorvisSidebar.addText("Virus cells: Red splotches appear on the screen. Click them all within the time limit to avoid damage.");
        this.fightVardorvisSidebar.addSubSteps(this.fightVardorvis);
        this.pickUpTempleKey = new ItemStep(this.getQuestHelper(), "Pick up the Temple Key in the Vardorvis arena.", this.templeKey);
        this.getTempleKeyFromRocks = new ObjectStep(this.getQuestHelper(), 49495, new WorldPoint(1118, 3428, 0), "Go to the ritual site to the west, and search the rocks to get another Temple Key.", new Requirement[0]);
        ObjectStep enterKasondeWithKey = new ObjectStep(this.getQuestHelper(), 48723, new WorldPoint(1174, 3428, 0), "", new Requirement[0]);
        NpcStep giveKasondeKey = new NpcStep(this.getQuestHelper(), 12258, new WorldPoint(1183, 9824, 0), "", new Requirement[0]);
        this.returnToKasondeWithTempleKey = new ConditionalStep(this.getQuestHelper(), (QuestStep)this.boardBoat, "Return to Kasonde with the temple key, who is inside the main pyramid of the area to the north. Be ready for another fight.", this.combatGear, this.templeKey);
        this.returnToKasondeWithTempleKey.addStep(new Conditions(this.inStranglewoodPyramidRoom, this.templeKey.alsoCheckBank(this.questBank).hideConditioned(this.givenKasondeKey)), giveKasondeKey);
        this.returnToKasondeWithTempleKey.addStep(new Conditions(this.inAnyStranglewood, this.templeKey.alsoCheckBank(this.questBank)), enterKasondeWithKey);
        this.returnToKasondeWithTempleKey.addStep(this.templeKeyNearby, this.pickUpTempleKey);
        this.returnToKasondeWithTempleKey.addStep(this.inAnyStranglewood, this.getTempleKeyFromRocks);
        NpcStep kasondeFight = new NpcStep(this.getQuestHelper(), 12262, new WorldPoint(1183, 9824, 0), "", new Requirement[0]);
        kasondeFight.addAlternateNpcs(12263);
        this.defeatKasonde = new ConditionalStep(this.getQuestHelper(), (QuestStep)this.boardBoat, "Defeat Kasonde in the pyramid. Avoid the potions he throws. If he throws his hands up, hide behind a pillar.", this.combatGear);
        this.defeatKasonde.addStep(new Conditions(this.inStranglewoodPyramidRoom), kasondeFight);
        this.defeatKasonde.addStep(new Conditions(this.inAnyStranglewood), enterKasondeWithKey);
        NpcStep talkToKasondeAfterFight = new NpcStep(this.getQuestHelper(), 12264, new WorldPoint(1183, 9824, 0), "", new Requirement[0]);
        this.goTalkToKasondeAfterFight = new ConditionalStep(this.getQuestHelper(), (QuestStep)this.boardBoat, "Talk to Kasonde again in the pyramid.", new Requirement[0]);
        this.goTalkToKasondeAfterFight.addStep(new Conditions(this.inStranglewoodPyramidRoom), talkToKasondeAfterFight);
        this.goTalkToKasondeAfterFight.addStep(new Conditions(this.inAnyStranglewood), enterKasondeWithKey);
        ObjectStep searchChestForVardorvisMedallion = new ObjectStep(this.getQuestHelper(), 49496, new WorldPoint(1196, 3411, 0), "", new Requirement[0]);
        ObjectStep leavePyramid = new ObjectStep(this.getQuestHelper(), 48730, new WorldPoint(1183, 9809, 0), "", new Requirement[0]);
        this.goGetVardorvisMedallion = new ConditionalStep(this.getQuestHelper(), (QuestStep)this.boardBoat, "Search the north-east chest in Kadsone's initial hideout for a medallion.", new Requirement[0]);
        this.goGetVardorvisMedallion.addStep(this.inStranglewoodPyramidRoom, leavePyramid);
        this.goGetVardorvisMedallion.addStep(new Conditions(this.inAnyStranglewood), searchChestForVardorvisMedallion);
        this.returnToDesertWithVardorvisMedallion = new ObjectStep(this.getQuestHelper(), 46743, new WorldPoint(3511, 2971, 0), "Return to the Vault door north-east of Nardah.", this.vardorvisMedallion);
        this.returnToDesertWithVardorvisMedallion.addTeleport(this.nardahTeleport);
        this.useVardorvisMedallionOnStatue = new ObjectStep(this.getQuestHelper(), 49499, new WorldPoint(3942, 9636, 1), "Use the medallion on the north-east statue.", this.vardorvisMedallion.highlighted());
        this.useVardorvisMedallionOnStatue.addIcon(28404);
    }

    public List<QuestStep> getDisplaySteps() {
        return QuestUtil.toArrayList(this.talkToElissa, this.talkToBarus, this.searchDesk, this.readPotionNote, this.drinkPotion, this.boardBoat, this.runIntoStanglewood, this.talkToKasonde, this.enterEntry, this.defendKasondeSidebar, this.leaveTowerDefenseRoom, this.talkToKasondeAfterTowerDefense, this.getHerbSidebar, this.getBerry, this.goDownToKasonde, this.defendKasondeHerb, this.talkToKasondeWithHerbAndBerry, this.addHerb, this.addBerry, this.drinkStranglewoodPotion, this.goToRitualSite, this.fightVardorvisSidebar, this.pickUpTempleKey, this.returnToKasondeWithTempleKey, this.defeatKasonde, this.goTalkToKasondeAfterFight, this.goGetVardorvisMedallion, this.returnToDesertWithVardorvisMedallion, this.useVardorvisMedallionOnStatue);
    }
}

