/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.deserttreasureii;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.helpers.quests.deserttreasureii.ChestCodeStep;
import com.questhelper.helpers.quests.secretsofthenorth.ArrowChestPuzzleStep;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questhelpers.QuestUtil;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.util.LogicHelper;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.widget.WidgetTextRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.Arrays;
import java.util.List;
import net.runelite.api.coords.WorldPoint;

public class SucellusSteps
extends ConditionalStep {
    DetailedQuestStep moveToWeissCave;
    DetailedQuestStep enterWeissCave;
    DetailedQuestStep enterPrison;
    DetailedQuestStep getKnockedOut;
    DetailedQuestStep inspectWall;
    DetailedQuestStep searchSkeleton;
    DetailedQuestStep readPrisonersLetter;
    DetailedQuestStep searchBucket;
    DetailedQuestStep giveKnifeToSoldier;
    DetailedQuestStep searchBed;
    DetailedQuestStep giveSoldierLockpick;
    DetailedQuestStep talkToAssassin;
    DetailedQuestStep lockpickGate;
    DetailedQuestStep searchAltar;
    DetailedQuestStep readWarningLetter;
    DetailedQuestStep unlockChest;
    DetailedQuestStep goToAdminRoom;
    DetailedQuestStep enterCrevice;
    DetailedQuestStep openArrowChest;
    DetailedQuestStep enterCreviceToStart;
    DetailedQuestStep openDiamondChest;
    DetailedQuestStep getGear;
    DetailedQuestStep talkToAssassinWithGear;
    DetailedQuestStep goLightFirecrackers;
    DetailedQuestStep goLightFirecrackersThroughCrevice;
    DetailedQuestStep survive3Mins;
    DetailedQuestStep talkToAssassinAfterJhallanFight;
    DetailedQuestStep enterDukeArena;
    DetailedQuestStep enterDukeBossArea;
    DetailedQuestStep defeatDuke;
    DetailedQuestStep defeatDukeSidebar;
    DetailedQuestStep pickUpOddKey;
    DetailedQuestStep enterRoomWestOfDuke;
    DetailedQuestStep retrieveKeyFromDoor;
    DetailedQuestStep talkToAssassinAfterDuke;
    DetailedQuestStep openDukeChest;
    DetailedQuestStep returnToDesertWithSucellusMedallion;
    DetailedQuestStep useSucellusMedallionOnStatue;
    QuestStep unlockChestStep;
    QuestStep unlockChest2;
    QuestStep openArrowChestStep;
    QuestStep openDiamondChestStep;
    ItemRequirement meleeCombatGear;
    ItemRequirement food;
    ItemRequirement prayerPotions;
    ItemRequirement icyBasalt;
    ItemRequirement staminaPotions;
    ItemRequirement nardahTeleport;
    ItemRequirement prisonersLetter;
    ItemRequirement lockpick;
    ItemRequirement chisel;
    ItemRequirement knife;
    ItemRequirement warningLetter;
    ItemRequirement sapphireKey;
    ItemRequirement emeraldKey;
    ItemRequirement rubyKey;
    ItemRequirement diamondKey;
    ItemRequirement oddKey;
    ItemRequirement sucellusMedallion;
    Requirement inWeissCave;
    Requirement inMahjarratCave;
    Requirement inPrisonF2;
    Requirement inPrisonCell;
    Requirement haveReadPrisonersLetter;
    Requirement givenKnifeToSoldier;
    Requirement talkedToSoldier;
    Requirement foundLockpick;
    Requirement escapedCell;
    Requirement assassinGone;
    Requirement pickedDoor;
    Requirement inChestInterface;
    Requirement atLiesChest;
    Requirement inPrisonNW;
    Requirement inArrowPuzzle;
    Requirement atDiamondChest;
    Requirement inPrisonNE;
    Requirement gotGear;
    Requirement unlockedSECrevice;
    Requirement talkedToAssassinWithGear;
    Requirement inJhallanFight;
    Requirement defeatedJhallan;
    Requirement dukeArenaUnlocked;
    Requirement inDukeEntrance;
    Requirement inDukeBossArena;
    Requirement killedDuke;
    Requirement oddKeyNearby;
    Requirement oddKeyDoorUnlocked;
    Requirement talkedToAssassinAfterDuke;
    Requirement inVault;
    Zone weissCave;
    Zone mahjarratCave;
    Zone prisonF0;
    Zone prisonF1;
    Zone prisonF2;
    Zone prisonCell;
    Zone liesChest;
    Zone prisonNW;
    Zone prisonNW2;
    Zone diamondChest;
    Zone prisonNE;
    Zone dukeBossArena;
    Zone dukeEntrance;
    Zone vault;

    public SucellusSteps(QuestHelper questHelper, QuestStep defaultStep) {
        super(questHelper, defaultStep, new Requirement[0]);
        this.setupItemRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        this.addStep(LogicHelper.and(this.inVault, this.sucellusMedallion), this.useSucellusMedallionOnStatue);
        this.addStep(this.sucellusMedallion, this.returnToDesertWithSucellusMedallion);
        this.addStep(LogicHelper.and(this.talkedToAssassinAfterDuke, LogicHelper.or(this.inDukeBossArena, this.inDukeEntrance)), this.openDukeChest);
        this.addStep(LogicHelper.and(this.oddKeyDoorUnlocked, LogicHelper.or(this.inDukeBossArena, this.inDukeEntrance)), this.talkToAssassinAfterDuke);
        this.addStep(LogicHelper.and(this.oddKey, LogicHelper.or(this.inDukeBossArena, this.inDukeEntrance)), this.enterRoomWestOfDuke);
        this.addStep(LogicHelper.and(this.inDukeEntrance, this.killedDuke), this.retrieveKeyFromDoor);
        this.addStep(LogicHelper.and(this.oddKeyNearby), this.pickUpOddKey);
        this.addStep(LogicHelper.and(this.inDukeBossArena), this.defeatDuke);
        this.addStep(LogicHelper.and(this.inDukeEntrance), this.enterDukeBossArea);
        this.addStep(LogicHelper.and(this.inPrisonF2, this.dukeArenaUnlocked), this.enterDukeArena);
        this.addStep(LogicHelper.and(this.inPrisonF2, this.defeatedJhallan), this.talkToAssassinAfterJhallanFight);
        this.addStep(LogicHelper.and(this.inPrisonF2, this.inJhallanFight), this.survive3Mins);
        this.addStep(LogicHelper.and(this.inPrisonF2, this.talkedToAssassinWithGear, this.unlockedSECrevice), this.goLightFirecrackersThroughCrevice);
        this.addStep(LogicHelper.and(this.inPrisonF2, this.talkedToAssassinWithGear, this.unlockedSECrevice), this.goLightFirecrackersThroughCrevice);
        this.addStep(LogicHelper.and(this.inPrisonF2, this.talkedToAssassinWithGear), this.goLightFirecrackers);
        this.addStep(LogicHelper.and(this.inPrisonF2, this.gotGear), this.talkToAssassinWithGear);
        this.addStep(LogicHelper.and(this.inPrisonF2, this.diamondKey), this.getGear);
        this.addStep(LogicHelper.and(this.inPrisonNE, this.rubyKey), this.enterCreviceToStart);
        this.addStep(LogicHelper.and(this.atDiamondChest, this.rubyKey, this.inChestInterface), this.openDiamondChestStep);
        this.addStep(LogicHelper.and(this.inPrisonF2, this.rubyKey), this.openDiamondChest);
        this.addStep(LogicHelper.and(this.inPrisonF2, this.inArrowPuzzle), this.openArrowChestStep);
        this.addStep(LogicHelper.and(this.inPrisonNW, this.sapphireKey, this.emeraldKey), this.enterCrevice);
        this.addStep(LogicHelper.and(this.inPrisonF2, this.sapphireKey, this.emeraldKey), this.openArrowChest);
        this.addStep(LogicHelper.and(this.inPrisonF2, this.atLiesChest, this.inChestInterface), this.unlockChest2);
        this.addStep(LogicHelper.and(this.inPrisonF2, this.sapphireKey), this.goToAdminRoom);
        this.addStep(LogicHelper.and(this.inPrisonF2, this.pickedDoor, this.inChestInterface), this.unlockChestStep);
        this.addStep(LogicHelper.and(this.inPrisonF2, this.pickedDoor), this.unlockChest);
        this.addStep(LogicHelper.and(this.inPrisonF2, this.assassinGone), this.lockpickGate);
        this.addStep(LogicHelper.and(this.inPrisonF2, this.escapedCell), this.talkToAssassin);
        this.addStep(LogicHelper.and(this.inPrisonCell, this.lockpick), this.giveSoldierLockpick);
        this.addStep(LogicHelper.and(this.inPrisonCell, LogicHelper.or(this.chisel, this.foundLockpick)), this.searchBed);
        this.addStep(LogicHelper.and(this.inPrisonCell, LogicHelper.or(this.knife, this.givenKnifeToSoldier)), this.giveKnifeToSoldier);
        this.addStep(LogicHelper.and(this.inPrisonCell, this.haveReadPrisonersLetter), this.searchBucket);
        this.addStep(LogicHelper.and(this.inPrisonCell, this.prisonersLetter), this.readPrisonersLetter);
        this.addStep(LogicHelper.and(this.inPrisonCell, this.talkedToSoldier), this.searchSkeleton);
        this.addStep(this.inPrisonCell, this.inspectWall);
        this.addStep(this.inPrisonF2, this.getKnockedOut);
        this.addStep(this.inMahjarratCave, this.enterPrison);
        this.addStep(this.inWeissCave, this.enterWeissCave);
        this.addStep(null, this.moveToWeissCave);
    }

    protected void setupItemRequirements() {
        this.meleeCombatGear = new ItemRequirement("Melee combat gear", -1, -1);
        this.meleeCombatGear.setDisplayItemId(BankSlotIcons.getMeleeCombatGear());
        this.food = new ItemRequirement("Food, as much as you can bring", ItemCollections.GOOD_EATING_FOOD);
        this.prayerPotions = new ItemRequirement("Prayer potions", ItemCollections.PRAYER_POTIONS);
        this.icyBasalt = new ItemRequirement("Icy basalt", 22599);
        this.staminaPotions = new ItemRequirement("Stamina potions", ItemCollections.STAMINA_POTIONS);
        VarbitRequirement nardahTeleportInBook = new VarbitRequirement(5672, 1, Operation.GREATER_EQUAL);
        this.nardahTeleport = new ItemRequirement("Nardah teleport, or Fairy Ring to DLQ", 13136);
        this.nardahTeleport.setAdditionalOptions(nardahTeleportInBook);
        this.nardahTeleport.addAlternates(13135, 12402, 13134);
        this.nardahTeleport.addAlternates(ItemCollections.FAIRY_STAFF);
        this.prisonersLetter = new ItemRequirement("Prisoner's letter", 28412);
        this.lockpick = new ItemRequirement("Lockpick", 28415);
        this.lockpick.setTooltip("You can obtain another from the bed in the cell you started in");
        this.chisel = new ItemRequirement("Chisel", 28414);
        this.knife = new ItemRequirement("Knife", 28413);
        this.warningLetter = new ItemRequirement("Warning letter", 28429);
        this.sapphireKey = new ItemRequirement("Sapphire key", 28416);
        this.emeraldKey = new ItemRequirement("Emerald key", 28417);
        this.rubyKey = new ItemRequirement("Ruby key", 28418);
        this.diamondKey = new ItemRequirement("Diamond key", 28419);
        this.oddKey = new ItemRequirement("Odd key", 28430);
        this.sucellusMedallion = new ItemRequirement("Sucellus medallion", 28406);
    }

    protected void setupZones() {
        this.weissCave = new Zone(new WorldPoint(2825, 10355, 0), new WorldPoint(2860, 10323, 0));
        this.mahjarratCave = new Zone(new WorldPoint(2890, 10290, 0), new WorldPoint(2936, 10360, 0));
        this.prisonF0 = new Zone(new WorldPoint(2872, 6334, 0), new WorldPoint(3009, 6463, 0));
        this.prisonF1 = new Zone(new WorldPoint(2872, 6334, 1), new WorldPoint(3009, 6463, 1));
        this.prisonF2 = new Zone(new WorldPoint(2872, 6334, 2), new WorldPoint(3009, 6463, 2));
        this.prisonCell = new Zone(new WorldPoint(3035, 6364, 0), new WorldPoint(3044, 6373, 0));
        this.liesChest = new Zone(new WorldPoint(2903, 6445, 2));
        this.prisonNW = new Zone(new WorldPoint(2889, 6398, 2), new WorldPoint(2948, 6457, 2));
        this.prisonNW2 = new Zone(new WorldPoint(2949, 6420, 2), new WorldPoint(2961, 6450, 2));
        this.diamondChest = new Zone(new WorldPoint(2889, 6375, 2));
        this.prisonNE = new Zone(new WorldPoint(2947, 6345, 2), new WorldPoint(3005, 6446, 2));
        this.dukeBossArena = new Zone(new WorldPoint(3025, 6433, 0), new WorldPoint(3053, 6461, 0));
        this.dukeEntrance = new Zone(new WorldPoint(3010, 6414, 0), new WorldPoint(3069, 6432, 0));
        this.vault = new Zone(new WorldPoint(3925, 9620, 1), new WorldPoint(3949, 9643, 1));
    }

    protected void setupConditions() {
        this.inWeissCave = new ZoneRequirement(this.weissCave);
        this.inMahjarratCave = new ZoneRequirement(this.mahjarratCave);
        this.inDukeEntrance = new ZoneRequirement(this.dukeEntrance);
        this.inDukeBossArena = new ZoneRequirement(this.dukeBossArena);
        this.inPrisonF2 = new ZoneRequirement(this.prisonF2);
        this.inPrisonCell = new ZoneRequirement(this.prisonCell);
        this.inPrisonNW = new ZoneRequirement(this.prisonNW, this.prisonNW2);
        this.inPrisonNE = new ZoneRequirement(this.prisonNE);
        this.inVault = new ZoneRequirement(this.vault);
        this.talkedToSoldier = new VarbitRequirement(15127, 10, Operation.GREATER_EQUAL);
        this.haveReadPrisonersLetter = new VarbitRequirement(15127, 12, Operation.GREATER_EQUAL);
        this.givenKnifeToSoldier = new VarbitRequirement(15127, 14, Operation.GREATER_EQUAL);
        this.foundLockpick = new VarbitRequirement(15127, 18, Operation.GREATER_EQUAL);
        this.escapedCell = new VarbitRequirement(15127, 20, Operation.GREATER_EQUAL);
        this.assassinGone = new VarbitRequirement(15127, 22, Operation.GREATER_EQUAL);
        this.pickedDoor = new VarbitRequirement(15127, 24, Operation.GREATER_EQUAL);
        this.inChestInterface = new WidgetTextRequirement(809, 5, 9, "Confirm");
        this.atLiesChest = new ZoneRequirement(this.liesChest);
        this.inArrowPuzzle = new WidgetTextRequirement(810, 15, 9, "Confirm");
        this.atDiamondChest = new ZoneRequirement(this.diamondChest);
        this.gotGear = new VarbitRequirement(15127, 50, Operation.GREATER_EQUAL);
        this.talkedToAssassinWithGear = new VarbitRequirement(15127, 52, Operation.GREATER_EQUAL);
        this.unlockedSECrevice = new VarbitRequirement(15177, 1);
        this.inJhallanFight = new VarbitRequirement(15127, 54, Operation.GREATER_EQUAL);
        this.defeatedJhallan = new VarbitRequirement(15127, 56, Operation.GREATER_EQUAL);
        this.dukeArenaUnlocked = new VarbitRequirement(15127, 58, Operation.GREATER_EQUAL);
        this.killedDuke = new VarbitRequirement(15127, 64, Operation.GREATER_EQUAL);
        this.oddKeyNearby = new ItemOnTileRequirement(this.oddKey);
        this.oddKeyDoorUnlocked = new VarbitRequirement(15179, 1);
        this.talkedToAssassinAfterDuke = new VarbitRequirement(15127, 66, Operation.GREATER_EQUAL);
    }

    protected void setupSteps() {
        this.moveToWeissCave = new ObjectStep(this.getQuestHelper(), 33234, new WorldPoint(2867, 3940, 0), "Enter the basalt cave in Weiss.", this.meleeCombatGear, this.food, this.prayerPotions);
        this.moveToWeissCave.addRecommended(this.staminaPotions);
        this.moveToWeissCave.addTeleport(this.icyBasalt);
        this.enterWeissCave = new ObjectStep(this.getQuestHelper(), 46905, new WorldPoint(2846, 10332, 0), "Enter the cave to the south.", new Requirement[0]);
        this.enterWeissCave.addDialogStep("Yes.");
        this.enterPrison = new ObjectStep(this.getQuestHelper(), 49513, new WorldPoint(2927, 10354, 0), "Enter the heavy door in the north-eastern room.", new Requirement[0]);
        this.getKnockedOut = new DetailedQuestStep(this.getQuestHelper(), new WorldPoint(2912, 6348, 2), "Move deeper into the prison.", new Requirement[0]);
        this.inspectWall = new ObjectStep(this.getQuestHelper(), 49099, new WorldPoint(3040, 6370, 0), "Inspect the wall to the north in the prison cell.", new Requirement[0]);
        this.searchSkeleton = new ObjectStep(this.getQuestHelper(), 49094, new WorldPoint(3042, 6369, 0), "Search the skeleton in the cell.", new Requirement[0]);
        this.readPrisonersLetter = new DetailedQuestStep(this.getQuestHelper(), "Read the prisoner's letter.", this.prisonersLetter.highlighted());
        this.searchBucket = new ObjectStep(this.getQuestHelper(), 49095, new WorldPoint(3039, 6367, 0), "Search the bucket for a knife.", new Requirement[0]);
        this.giveKnifeToSoldier = new ObjectStep(this.getQuestHelper(), 49099, new WorldPoint(3040, 6370, 0), "Give the knife to the soldier.", new Requirement[0]);
        this.searchBed = new ObjectStep(this.getQuestHelper(), 49514, new WorldPoint(3041, 6367, 0), "Search the bed.", new Requirement[0]);
        this.giveSoldierLockpick = new ObjectStep(this.getQuestHelper(), 49099, new WorldPoint(3040, 6370, 0), "Give the lockpick to the soldier.", new Requirement[0]);
        this.talkToAssassin = new NpcStep(this.getQuestHelper(), 12348, new WorldPoint(2920, 6375, 2), "Talk to the Assassin outside the cell.", new Requirement[0]);
        this.lockpickGate = new ObjectStep(this.getQuestHelper(), 49120, new WorldPoint(2945, 6389, 2), "Head north from the assassin to the junction, and then east. Lockpick the gate you end up at.", this.lockpick);
        this.lockpickGate.setLinePoints(Arrays.asList(new WorldPoint(2919, 6362, 2), new WorldPoint(2919, 6388, 2), new WorldPoint(2913, 6388, 2), new WorldPoint(2913, 6395, 2), new WorldPoint(2932, 6395, 2), new WorldPoint(2932, 6389, 2), new WorldPoint(2945, 6389, 2)));
        this.searchAltar = new ObjectStep(this.getQuestHelper(), 49150, new WorldPoint(2975, 6347, 2), "Head south from the gate, and all the way around until you enter the large area. Search the altar in the south room.", new Requirement[0]);
        this.searchAltar.setLinePoints(Arrays.asList(new WorldPoint(2919, 6362, 2), new WorldPoint(2919, 6388, 2), new WorldPoint(2913, 6388, 2), new WorldPoint(2913, 6395, 2), new WorldPoint(2932, 6395, 2), new WorldPoint(2932, 6389, 2), new WorldPoint(2945, 6389, 2), new WorldPoint(2950, 6389, 2), new WorldPoint(2950, 6382, 2), new WorldPoint(3001, 6382, 2), new WorldPoint(3001, 6356, 2), new WorldPoint(2993, 6356, 2), new WorldPoint(2993, 6365, 2), new WorldPoint(2979, 6365, 2), new WorldPoint(2979, 6360, 2), new WorldPoint(2975, 6360, 2), new WorldPoint(2975, 6348, 2)));
        this.readWarningLetter = new DetailedQuestStep(this.getQuestHelper(), "Read the warning letter.", this.warningLetter.highlighted());
        this.unlockChest = new ObjectStep(this.getQuestHelper(), 49111, new WorldPoint(2980, 6346, 2), "Head south from the gate, and all the way around until you enter the large area. Unlock the chest east of the altar in the south room. The code is '214013'.", new Requirement[0]);
        this.unlockChest.setLinePoints(Arrays.asList(new WorldPoint(2919, 6362, 2), new WorldPoint(2919, 6388, 2), new WorldPoint(2913, 6388, 2), new WorldPoint(2913, 6395, 2), new WorldPoint(2932, 6395, 2), new WorldPoint(2932, 6389, 2), new WorldPoint(2945, 6389, 2), new WorldPoint(2950, 6389, 2), new WorldPoint(2950, 6382, 2), new WorldPoint(3001, 6382, 2), new WorldPoint(3001, 6356, 2), new WorldPoint(2993, 6356, 2), new WorldPoint(2993, 6365, 2), new WorldPoint(2979, 6365, 2), new WorldPoint(2979, 6360, 2), new WorldPoint(2975, 6360, 2), new WorldPoint(2975, 6348, 2)));
        this.unlockChestStep = new ChestCodeStep(this.getQuestHelper(), "214013", 5, 2, 1, 4, 0, 1, 3);
        this.unlockChest.addSubSteps(this.unlockChestStep);
        this.goToAdminRoom = new ObjectStep(this.getQuestHelper(), 49112, new WorldPoint(2902, 6445, 2), "Go to the most north-western room. Open the chest closest to the room's west door. The code for it is 'LIES'.", new Requirement[0]);
        this.goToAdminRoom.addDialogStep("Attempt to open the chest.");
        this.goToAdminRoom.setLinePoints(Arrays.asList(new WorldPoint(2975, 6531, 2), new WorldPoint(2975, 6361, 2), new WorldPoint(2971, 6361, 2), new WorldPoint(2971, 6369, 2), new WorldPoint(2975, 6369, 2), new WorldPoint(2975, 6382, 2), new WorldPoint(2950, 6382, 2), new WorldPoint(2950, 6389, 2), new WorldPoint(2932, 6389, 2), new WorldPoint(2932, 6395, 2), new WorldPoint(2912, 6395, 2), new WorldPoint(2912, 6423, 2), new WorldPoint(2923, 6423, 2), new WorldPoint(2923, 6454, 2), new WorldPoint(2916, 6454, 2), new WorldPoint(2916, 6444, 2), new WorldPoint(2907, 6444, 2), new WorldPoint(0, 0, 0), new WorldPoint(2914, 6348, 2), new WorldPoint(2919, 6348, 2), new WorldPoint(2919, 6388, 2), new WorldPoint(2912, 6388, 2), new WorldPoint(2912, 6395, 2)));
        this.unlockChest2 = new ChestCodeStep(this.getQuestHelper(), "LIES", 10, 0, 4, 1, 5);
        this.goToAdminRoom.addSubSteps(this.unlockChest2);
        this.enterCrevice = new ObjectStep(this.getQuestHelper(), 49517, new WorldPoint(2960, 6428, 2), "When you're not in a room, Jhallan will now chase you down. Use Protect from Magic to reduce his damage.", new Requirement[0]);
        this.enterCrevice.addText("Run east into the room with a crevice. Clear it, and go through it.");
        this.enterCrevice.setLinePoints(Arrays.asList(new WorldPoint(2907, 6444, 2), new WorldPoint(2916, 6444, 2), new WorldPoint(2916, 6454, 2), new WorldPoint(2923, 6454, 2), new WorldPoint(2923, 6442, 2), new WorldPoint(2951, 6442, 2), new WorldPoint(2951, 6428, 2), new WorldPoint(2959, 6428, 2)));
        this.enterCrevice.addDialogStep("Yes.");
        this.openArrowChestStep = new ArrowChestPuzzleStep(this.getQuestHelper());
        this.openArrowChest = new ObjectStep(this.getQuestHelper(), 49113, new WorldPoint(2968, 6414, 2), "Enter the room with beds in it, south of the crevice. Open the south-eastern chest, next to the crates. The code is 'UP RIGHT LEFT DOWN RIGHT UP'.", new Requirement[0]);
        this.openArrowChest.addSubSteps(this.openArrowChestStep);
        this.enterCreviceToStart = new ObjectStep(this.getQuestHelper(), 49108, new WorldPoint(2984, 6399, 2), "Enter the crevice to the south to shortcut back to the main room.", new Requirement[0]);
        this.enterCreviceToStart.setLinePoints(Arrays.asList(new WorldPoint(2974, 6418, 2), new WorldPoint(2984, 6418, 2), new WorldPoint(2984, 6400, 2)));
        this.openDiamondChest = new ObjectStep(this.getQuestHelper(), 49114, new WorldPoint(2890, 6375, 2), "Open the chest in the cell to the west of the main room, through the Ruby Gate. The code for it is 'WRATH'.", new Requirement[0]);
        this.openDiamondChest.setLinePoints(Arrays.asList(new WorldPoint(2901, 6361, 2), new WorldPoint(2905, 6361, 2), new WorldPoint(2905, 6354, 2), new WorldPoint(2891, 6354, 2), new WorldPoint(2891, 6366, 2), new WorldPoint(2884, 6366, 2), new WorldPoint(2884, 6374, 2), new WorldPoint(2889, 6375, 2)));
        this.openDiamondChestStep = new ChestCodeStep(this.getQuestHelper(), "WRATH", 10, 2, 3, 5, 9, 5);
        this.openDiamondChest.addSubSteps(this.openDiamondChestStep);
        this.getGear = new ObjectStep(this.getQuestHelper(), 49115, new WorldPoint(2899, 6376, 2), "Get your equipment back from the chest in the cell next to the Assassin. You'll need to go through some dialog with him to enter.", new Requirement[0]);
        this.talkToAssassinWithGear = new NpcStep(this.getQuestHelper(), 12348, new WorldPoint(2903, 6383, 2), "Talk to the assassin.", new Requirement[0]);
        this.goLightFirecrackers = new ObjectStep(this.getQuestHelper(), 49515, new WorldPoint(2972, 6367, 2), "Get a full inventory of food, and return to the refugee camp in the south-eastern room. Light the firecrackers there. Once you do, you'll need to survive Jhallan attacking you for 3 minutes.", new Requirement[0]);
        this.goLightFirecrackers.setLinePoints(Arrays.asList(new WorldPoint(2905, 6375, 2), new WorldPoint(2905, 6348, 2), new WorldPoint(2919, 6348, 2), new WorldPoint(2919, 6354, 2), new WorldPoint(2933, 6367, 2), new WorldPoint(2938, 6367, 2), new WorldPoint(2938, 6389, 2), new WorldPoint(2950, 6389, 2), new WorldPoint(2950, 6382, 2), new WorldPoint(2975, 6382, 2), new WorldPoint(2975, 6369, 2), new WorldPoint(2972, 6368, 2)));
        this.goLightFirecrackers.addDialogStep("Yes.");
        this.goLightFirecrackersThroughCrevice = new ObjectStep(this.getQuestHelper(), 49515, new WorldPoint(2972, 6367, 2), "Get a full inventory of food, and return to the refugee camp in the south-eastern room. Light the firecrackers there. Once you do, you'll need to survive Jhallan attacking you for 3 minutes.", new Requirement[0]);
        this.goLightFirecrackersThroughCrevice.setLinePoints(Arrays.asList(new WorldPoint(2905, 6375, 2), new WorldPoint(2905, 6348, 2), new WorldPoint(2919, 6348, 2), new WorldPoint(2919, 6354, 2), new WorldPoint(2954, 6354, 2), new WorldPoint(2954, 6365, 2), new WorldPoint(2971, 6365, 2), new WorldPoint(2971, 6367, 2)));
        this.goLightFirecrackersThroughCrevice.addDialogStep("Yes.");
        this.goLightFirecrackers.addSubSteps(this.goLightFirecrackersThroughCrevice);
        this.survive3Mins = new NpcStep(this.getQuestHelper(), 12355, new WorldPoint(2975, 6362, 2), "Survive Jhallan's attacks for 3 minutes. Protect from Mage, keep your health high, and avoid the shadow attacks.", new Requirement[0]);
        ((NpcStep)this.survive3Mins).addAlternateNpcs(12064, 12065, 12354, 12353);
        this.talkToAssassinAfterJhallanFight = new NpcStep(this.getQuestHelper(), 12349, new WorldPoint(2978, 6371, 2), "Talk to the assassin after the fight.", new Requirement[0]);
        this.enterDukeArena = new ObjectStep(this.getQuestHelper(), 49100, new WorldPoint(2974, 6440, 2), "Go down the stairs in the far north-east of the prison. Be prepared for fighting the boss of the area.", this.meleeCombatGear, this.food, this.prayerPotions);
        this.enterDukeArena.setLinePoints(Arrays.asList(new WorldPoint(2975, 6372, 2), new WorldPoint(2975, 6382, 2), new WorldPoint(2950, 6382, 2), new WorldPoint(2950, 6406, 2), new WorldPoint(2974, 6406, 2), new WorldPoint(2974, 6439, 2), null, new WorldPoint(2912, 6344, 2), new WorldPoint(2912, 6348, 2), new WorldPoint(2905, 6348, 2), new WorldPoint(2905, 6361, 2), new WorldPoint(2899, 6361, 2), null, new WorldPoint(2984, 6400, 2), new WorldPoint(2984, 6406, 2), new WorldPoint(2974, 6406, 2)));
        this.enterDukeBossArea = new ObjectStep(this.getQuestHelper(), 49138, new WorldPoint(3039, 6433, 0), "Enter the boss arena. Before entering you can also preview the boss's attacks by right-clicking it from outside.", new Requirement[0]);
        this.defeatDuke = new NpcStep(this.getQuestHelper(), 12194, new WorldPoint(3039, 6454, 0), "Defeat the Duke. Check the sidebar for more details.", new Requirement[0]);
        ((NpcStep)this.defeatDuke).addAlternateNpcs(12167, 12191, 12192, 12193, 12194, 12195, 12196);
        this.defeatDukeSidebar = new DetailedQuestStep(this.getQuestHelper(), "Defeat the Duke. You must first wake him with two 'Arder-musca poison'.", new Requirement[0]);
        this.defeatDukeSidebar.addText("Make sure to avoid any of the enviromental effects, such as gas, lightning, and the Extremitys' vision.");
        this.defeatDukeSidebar.addText("To make the poison, get 3 Arder mushrooms from the north-eastern corner, and 3 Musca from the north-western corner.");
        this.defeatDukeSidebar.addText("Grab the pestle and mortar from the shelves west of the entrance, and a pickaxe from the east of it.");
        this.defeatDukeSidebar.addText("Use the pestle and mortar on the mushrooms, and then mine 12 salt from the salt deposits in the middle of the room.");
        this.defeatDukeSidebar.addText("With the ground mushrooms and salts, add them to the fermentation vats near the entrance. Empty them for 2 poisons.");
        this.defeatDukeSidebar.addText("Use both poisons on the boss to start the fight. Stay close to him where possible, and Protect from Melee. He will use the following attacks:");
        this.defeatDukeSidebar.addText("Blue orb: Magic attack.");
        this.defeatDukeSidebar.addText("Spikes: the Duke hits the floor, causing spikes to appear. Avoid them.");
        this.defeatDukeSidebar.addText("Gas vent: the Duke activates one of the gas vents. Keep away from it.");
        this.defeatDukeSidebar.addText("Duke's gaze: the duke opens his eye to deal massive damage. Hide behind a pillar to avoid this.");
        this.defeatDukeSidebar.addSubSteps(this.defeatDuke);
        this.pickUpOddKey = new ItemStep(this.getQuestHelper(), "Pick up the odd key.", this.oddKey);
        this.enterRoomWestOfDuke = new ObjectStep(this.getQuestHelper(), 49140, new WorldPoint(3023, 6425, 0), "Enter the room south-west of the Duke.", new Requirement[0]);
        this.retrieveKeyFromDoor = new ObjectStep(this.getQuestHelper(), 49138, new WorldPoint(3039, 6433, 0), "Attempt to enter the Duke's room to retrieve the odd key.", new Requirement[0]);
        this.pickUpOddKey.addSubSteps(this.retrieveKeyFromDoor);
        this.talkToAssassinAfterDuke = new NpcStep(this.getQuestHelper(), 12349, new WorldPoint(3017, 6427, 0), "Talk to the assassin in the room.", new Requirement[0]);
        this.openDukeChest = new ObjectStep(this.getQuestHelper(), 49116, new WorldPoint(3021, 6420, 0), "Open the chest in the south-east of the room for sucellus' medallion.", new Requirement[0]);
        this.returnToDesertWithSucellusMedallion = new ObjectStep(this.getQuestHelper(), 46743, new WorldPoint(3511, 2971, 0), "Return to the Vault door north-east of Nardah. Be wary of an assassin coming to kill you! They can run, freeze, and teleblock you.", this.sucellusMedallion);
        this.returnToDesertWithSucellusMedallion.addTeleport(this.nardahTeleport);
        this.useSucellusMedallionOnStatue = new ObjectStep(this.getQuestHelper(), 49503, new WorldPoint(3932, 9626, 1), "Use the medallion on the south-west statue.", this.sucellusMedallion.highlighted());
        this.useSucellusMedallionOnStatue.addIcon(28406);
        this.useSucellusMedallionOnStatue.addDialogStep("Yes.");
    }

    protected List<QuestStep> getDisplaySteps() {
        return QuestUtil.toArrayList(this.moveToWeissCave, this.enterWeissCave, this.enterPrison, this.getKnockedOut, this.inspectWall, this.searchSkeleton, this.readPrisonersLetter, this.searchBucket, this.giveKnifeToSoldier, this.searchBed, this.giveSoldierLockpick, this.talkToAssassin, this.lockpickGate, this.unlockChest, this.goToAdminRoom, this.enterCrevice, this.openArrowChest, this.enterCreviceToStart, this.openDiamondChest, this.getGear, this.talkToAssassinWithGear, this.goLightFirecrackers, this.survive3Mins, this.talkToAssassinAfterJhallanFight, this.enterDukeArena, this.enterDukeBossArea, this.defeatDukeSidebar, this.pickUpOddKey, this.enterRoomWestOfDuke, this.talkToAssassinAfterDuke, this.openDukeChest, this.returnToDesertWithSucellusMedallion, this.useSucellusMedallionOnStatue);
    }
}

