/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.deserttreasureii;

import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.steps.DetailedOwnerStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.Arrays;
import java.util.Collection;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.eventbus.Subscribe;

public class MemoryPuzzle
extends DetailedOwnerStep {
    DetailedQuestStep neStep;
    DetailedQuestStep nwStep;
    DetailedQuestStep seStep;
    DetailedQuestStep swStep;
    QuestStep[] steps;

    public MemoryPuzzle(QuestHelper questHelper) {
        super(questHelper, "Solve the memory puzzle. Make sure to go into air bubbles whenever your air meter is low.", new Requirement[0]);
    }

    @Override
    public void startUp() {
        this.updateSteps();
    }

    @Override
    protected void setupSteps() {
        this.swStep = new ObjectStep(this.getQuestHelper(), 49391, new WorldPoint(1903, 6431, 0), "Touch the south-western growth.", new Requirement[0]);
        this.nwStep = new ObjectStep(this.getQuestHelper(), 49391, new WorldPoint(1900, 6442, 0), "Touch the north-western growth.", new Requirement[0]);
        this.neStep = new ObjectStep(this.getQuestHelper(), 49391, new WorldPoint(1909, 6441, 0), "Touch the north-eastern growth.", new Requirement[0]);
        this.seStep = new ObjectStep(this.getQuestHelper(), 49391, new WorldPoint(1914, 6434, 0), "Touch the south-eastern growth.", new Requirement[0]);
        this.steps = new QuestStep[4];
        this.steps[0] = this.swStep;
        this.steps[1] = this.nwStep;
        this.steps[2] = this.neStep;
        this.steps[3] = this.seStep;
    }

    @Override
    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        this.updateSteps();
    }

    @Override
    public void shutDown() {
        this.shutDownStep();
        this.currentStep = null;
    }

    @Override
    protected void updateSteps() {
        int currentStep = this.client.getVarbitValue(15217);
        int thingToPress = this.client.getVarbitValue(15212 + currentStep);
        this.startUpStep(this.steps[thingToPress]);
    }

    @Override
    public Collection<QuestStep> getSteps() {
        return Arrays.asList(this.seStep, this.swStep, this.neStep, this.nwStep);
    }
}

