/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.deserttreasureii;

import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.steps.ObjectStep;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.eventbus.Subscribe;

public class GrowthPuzzleStep
extends ObjectStep {
    int BASE_VARBIT_FOR_RUNES = 15203;
    int[] runeIDs = new int[]{49189, 49190, 49191, 49192, 49193, 49194};
    int highestPointReached = 0;

    public GrowthPuzzleStep(QuestHelper questHelper) {
        super(questHelper, -1, "Work out the correct order to activate the runes through trial and error.", new Requirement[0]);
        this.addAlternateObjects(49189, 49190, 49191, 49192, 49193, 49194);
    }

    @Override
    public void startUp() {
        super.startUp();
        this.setupHighlights();
    }

    @Override
    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        super.onVarbitChanged(varbitChanged);
        this.setupHighlights();
    }

    private void setupHighlights() {
        int currentRunesActive = this.client.getVarbitValue(15209);
        if (this.highestPointReached < currentRunesActive) {
            this.highestPointReached = currentRunesActive;
        }
        this.alternateObjectIDs.clear();
        if (currentRunesActive < this.highestPointReached) {
            int runeToHighlight = this.client.getVarbitValue(this.BASE_VARBIT_FOR_RUNES + currentRunesActive) - 1;
            this.addAlternateObjects(this.runeIDs[runeToHighlight]);
            this.loadObjects();
            return;
        }
        for (int i = this.BASE_VARBIT_FOR_RUNES + currentRunesActive; i < this.BASE_VARBIT_FOR_RUNES + 6; ++i) {
            int runeToHighlight = this.client.getVarbitValue(i) - 1;
            this.alternateObjectIDs.add(this.runeIDs[runeToHighlight]);
        }
        this.loadObjects();
    }
}

