/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.deserttreasureii;

import com.questhelper.QuestHelperPlugin;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.steps.QuestStep;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;

public class GolemPuzzleStep
extends QuestStep {
    int firstTileForSwapping;
    int secondTileForSwapping;
    boolean completed = false;
    int[] goalPositions = new int[]{47, 62, 5, 52, 33, 27, 10, 16};

    public GolemPuzzleStep(QuestHelper questHelper) {
        super(questHelper, "Drag the charges to the right tiles.");
    }

    @Override
    public void startUp() {
        this.updateSolvedPositionState();
    }

    @Override
    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        this.updateSolvedPositionState();
    }

    private void updateSolvedPositionState() {
        for (int i = 15165; i < 15173; ++i) {
            int goalPos;
            int currentPos = this.client.getVarbitValue(i);
            if (currentPos == (goalPos = this.goalPositions[15172 - i])) continue;
            this.completed = false;
            this.firstTileForSwapping = currentPos;
            this.secondTileForSwapping = goalPos;
            return;
        }
        this.completed = true;
        this.setText("Click the power-on button to finish the puzzle.");
    }

    @Override
    public void makeWidgetOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        super.makeWidgetOverlayHint(graphics, plugin);
        Widget widgetWrapper = this.client.getWidget(838, 32);
        if (this.completed) {
            Widget powerOnButton = this.client.getWidget(838, 4);
            if (powerOnButton == null) {
                return;
            }
            graphics.setColor(new Color(0, 255, 255, 65));
            graphics.fill(powerOnButton.getBounds());
            graphics.setColor(this.questHelper.getConfig().targetOverlayColor());
            graphics.draw(powerOnButton.getBounds());
            return;
        }
        if (widgetWrapper != null && this.firstTileForSwapping != -1 && this.secondTileForSwapping != -1) {
            Widget widget1 = widgetWrapper.getChild(this.firstTileForSwapping);
            Widget widget2 = widgetWrapper.getChild(this.secondTileForSwapping);
            if (widget1 != null && widget2 != null) {
                Line2D.Double line = new Line2D.Double((float)widget1.getCanvasLocation().getX() + (float)widget1.getWidth() / 2.0f, (float)widget1.getCanvasLocation().getY() + (float)widget1.getHeight() / 2.0f, (float)widget2.getCanvasLocation().getX() + (float)widget2.getWidth() / 2.0f, (float)widget2.getCanvasLocation().getY() + (float)widget2.getHeight() / 2.0f);
                graphics.setColor(new Color(0, 255, 255, 65));
                graphics.fill(widget1.getBounds());
                graphics.setColor(this.questHelper.getConfig().targetOverlayColor());
                graphics.draw(widget1.getBounds());
                graphics.setColor(new Color(0, 255, 255, 65));
                graphics.fill(widget2.getBounds());
                graphics.setColor(this.questHelper.getConfig().targetOverlayColor());
                graphics.draw(widget2.getBounds());
                graphics.setStroke(new BasicStroke(3.0f));
                graphics.draw(line);
                this.drawArrowHead(graphics, line);
            }
        }
    }

    private void drawArrowHead(Graphics2D g2d, Line2D.Double line) {
        AffineTransform tx = new AffineTransform();
        Polygon arrowHead = new Polygon();
        arrowHead.addPoint(0, 4);
        arrowHead.addPoint(-6, -5);
        arrowHead.addPoint(6, -5);
        tx.setToIdentity();
        double angle = Math.atan2(line.y2 - line.y1, line.x2 - line.x1);
        tx.translate(line.x2, line.y2);
        tx.rotate(angle - 1.5707963267948966);
        Graphics2D g = (Graphics2D)g2d.create();
        g.setTransform(tx);
        g.fill(arrowHead);
        g.dispose();
    }
}

