/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.deserttreasureii;

import com.questhelper.QuestHelperPlugin;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.steps.QuestStep;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import net.runelite.api.events.VarClientIntChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.ui.FontManager;

public class ChestCodeStep
extends QuestStep {
    private final int NUMBER_OF_DIALS;
    private final int SIZE_OF_LOOP;
    private final int[] buttonToPress;
    private final int[] distance;
    private final int[] goalValues;
    private boolean SHOULD_PRESS_CONFIRM;

    public ChestCodeStep(QuestHelper questHelper, String answer, int sizeOfLoop, int ... targets) {
        super(questHelper, "Open the chest using the code " + answer + ".");
        this.SIZE_OF_LOOP = sizeOfLoop;
        this.NUMBER_OF_DIALS = targets.length;
        this.buttonToPress = new int[this.NUMBER_OF_DIALS];
        this.distance = new int[this.NUMBER_OF_DIALS];
        this.goalValues = new int[this.NUMBER_OF_DIALS];
        for (int i = 0; i < this.NUMBER_OF_DIALS; ++i) {
            this.buttonToPress[i] = 0;
            this.distance[i] = 0;
            this.goalValues[i] = targets[i];
        }
    }

    @Subscribe
    public void onVarClientIntChanged(VarClientIntChanged varClientIntChanged) {
        this.updateSolvedPositionState();
    }

    private void updateSolvedPositionState() {
        for (int i = 0; i < this.NUMBER_OF_DIALS; ++i) {
            int START_VARCLIENTINT_POS = 1113;
            int varcIntID = START_VARCLIENTINT_POS + i;
            int START_DOWN_ARROW = 3;
            int ARROW_INTERVAL = 7;
            int arrowDownID = START_DOWN_ARROW + ARROW_INTERVAL * i;
            int arrowUPID = START_DOWN_ARROW + 1 + ARROW_INTERVAL * i;
            this.buttonToPress[i] = this.matchStateToSolution(varcIntID, this.goalValues[i], arrowDownID, arrowUPID);
            this.distance[i] = this.matchStateToDistance(varcIntID, this.goalValues[i]);
        }
        this.SHOULD_PRESS_CONFIRM = true;
        for (int d : this.distance) {
            if (d == 0) continue;
            this.SHOULD_PRESS_CONFIRM = false;
            break;
        }
    }

    private int matchStateToSolution(int slot, int target, int arrowDownId, int arrowUpId) {
        int id;
        int currentValue = this.client.getVarcIntValue(slot);
        int n = id = Math.floorMod(currentValue - target, this.SIZE_OF_LOOP) < Math.floorMod(target - currentValue, this.SIZE_OF_LOOP) ? arrowDownId : arrowUpId;
        if (currentValue != target) {
            return id;
        }
        return 0;
    }

    private int matchStateToDistance(int slot, int target) {
        int currentValue = this.client.getVarcIntValue(slot);
        return Math.min(Math.floorMod(currentValue - target, this.SIZE_OF_LOOP), Math.floorMod(target - currentValue, this.SIZE_OF_LOOP));
    }

    @Override
    public void makeWidgetOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        Widget widget;
        super.makeWidgetOverlayHint(graphics, plugin);
        if (this.SHOULD_PRESS_CONFIRM && (widget = this.client.getWidget(809, 5)) != null) {
            graphics.setColor(new Color(this.questHelper.getConfig().targetOverlayColor().getRed(), this.questHelper.getConfig().targetOverlayColor().getGreen(), this.questHelper.getConfig().targetOverlayColor().getBlue(), 65));
            graphics.fill(widget.getBounds());
            graphics.setColor(this.questHelper.getConfig().targetOverlayColor());
            graphics.draw(widget.getBounds());
        }
        for (int i = 0; i < this.NUMBER_OF_DIALS; ++i) {
            Widget widget2;
            int button = this.buttonToPress[i];
            if (button == 0 || (widget2 = this.client.getWidget(809, 4)) == null) continue;
            Widget arrow = widget2.getChild(button);
            if (arrow == null) break;
            graphics.setColor(new Color(this.questHelper.getConfig().targetOverlayColor().getRed(), this.questHelper.getConfig().targetOverlayColor().getGreen(), this.questHelper.getConfig().targetOverlayColor().getBlue(), 65));
            graphics.fill(arrow.getBounds());
            graphics.setColor(this.questHelper.getConfig().targetOverlayColor());
            graphics.draw(arrow.getBounds());
            int widgetX = arrow.getCanvasLocation().getX() + arrow.getWidth() / 2 - 30;
            int widgetY = arrow.getCanvasLocation().getY() + arrow.getHeight() / 2 + 4;
            Font font = FontManager.getRunescapeFont().deriveFont(1, 16.0f);
            graphics.setFont(font);
            graphics.drawString(Integer.toString(this.distance[i]), widgetX, widgetY);
        }
    }
}

