/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.deserttreasure;

import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.steps.NpcStep;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.eventbus.Subscribe;

public class GiveItems
extends NpcStep {
    int magicLogId = 365;
    int steelBarsId = 366;
    int moltenGlassId = 367;
    int bonesId = 368;
    int ashesId = 369;
    int charcoalId = 370;
    int bloodRuneId = 371;
    ItemRequirement magicLogs = new ItemRequirement("Magic logs", 1513, 12);
    ItemRequirement steelBars;
    ItemRequirement moltenGlass;
    ItemRequirement ashes;
    ItemRequirement charcoal;
    ItemRequirement bloodRune;
    ItemRequirement bones;

    public GiveItems(QuestHelper questHelper, int npcID, WorldPoint worldPoint, String text, ItemRequirement ... itemRequirements) {
        super(questHelper, npcID, worldPoint, text, (Requirement[])itemRequirements);
        this.magicLogs.addAlternates(1514);
        this.steelBars = new ItemRequirement("Steel bar", 2353, 6);
        this.steelBars.addAlternates(2354);
        this.moltenGlass = new ItemRequirement("Molten glass", 1775, 6);
        this.moltenGlass.addAlternates(1776);
        this.ashes = new ItemRequirement("Ashes", 592);
        this.charcoal = new ItemRequirement("Charcoal", 973);
        this.bloodRune = new ItemRequirement("Blood rune", 565);
        this.bones = new ItemRequirement("Bones", 526);
    }

    @Override
    public void startUp() {
        super.startUp();
        this.itemQuantitiesLeft();
    }

    @Override
    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        super.onVarbitChanged(varbitChanged);
        this.itemQuantitiesLeft();
    }

    private void itemQuantitiesLeft() {
        this.emptyRequirements();
        if (this.client.getVarbitValue(this.bonesId) != 1) {
            this.addRequirement((Requirement)this.bones);
        }
        if (this.client.getVarbitValue(this.bloodRuneId) != 1) {
            this.addRequirement((Requirement)this.bloodRune);
        }
        if (this.client.getVarbitValue(this.ashesId) != 1) {
            this.addRequirement((Requirement)this.ashes);
        }
        if (this.client.getVarbitValue(this.charcoalId) != 1) {
            this.addRequirement((Requirement)this.charcoal);
        }
        if (this.client.getVarbitValue(this.magicLogId) != 12) {
            this.magicLogs.setQuantity(12 - this.client.getVarbitValue(this.magicLogId));
            this.addRequirement((Requirement)this.magicLogs);
        }
        if (this.client.getVarbitValue(this.steelBarsId) != 6) {
            this.steelBars.setQuantity(6 - this.client.getVarbitValue(this.steelBarsId));
            this.addRequirement((Requirement)this.steelBars);
        }
        if (this.client.getVarbitValue(this.moltenGlassId) != 6) {
            this.moltenGlass.setQuantity(6 - this.client.getVarbitValue(this.moltenGlassId));
            this.addRequirement((Requirement)this.moltenGlass);
        }
        if (this.getRequirements().isEmpty()) {
            this.setText("Talk to Eblis in the east of the Bandit Camp.");
        }
    }
}

