/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.deserttreasure;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.helpers.quests.deserttreasure.GiveItems;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.ComplexRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.TeleportItemRequirement;
import com.questhelper.requirements.npc.NpcInteractingRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.DESERT_TREASURE)
public class DesertTreasure
extends BasicQuestHelper {
    ItemRequirement combatGear;
    ItemRequirement food;
    ItemRequirement prayerPotions;
    ItemRequirement restorePotions;
    ItemRequirement energyOrStaminas;
    ItemRequirement digTele;
    ItemRequirement canifisTeleport;
    ItemRequirement bedabinTeleport;
    ItemRequirement pollnivneachTeleport;
    ItemRequirement waterfallTeleport;
    ItemRequirement banditCampTeleport;
    ItemRequirement draynorTeleport;
    ItemRequirement trollheimTeleport;
    ItemRequirement pyramidTeleport;
    ItemRequirement coins650;
    ItemRequirement magicLogs12;
    ItemRequirement steelBars6;
    ItemRequirement moltenGlass6;
    ItemRequirement ashes;
    ItemRequirement charcoal;
    ItemRequirement bloodRune;
    ItemRequirement bones;
    ItemRequirement silverBar;
    ItemRequirement garlicPowder;
    ItemRequirement spice;
    ItemRequirement cake;
    ItemRequirement spikedBoots;
    ItemRequirement climbingBoots;
    ItemRequirement faceMask;
    ItemRequirement tinderbox;
    ItemRequirement manyLockpicks;
    ItemRequirement etchings;
    ItemRequirement translation;
    ItemRequirement warmKey;
    ItemRequirement smokeDiamond;
    ItemRequirement shadowDiamond;
    ItemRequirement iceDiamond;
    ItemRequirement bloodDiamond;
    ItemRequirement iceGloves;
    ItemRequirement waterSpellOrMelee;
    ItemRequirement cross;
    ItemRequirement ringOfVisibility;
    ItemRequirement antipoison;
    ItemRequirement silverPot;
    ItemRequirement silverPot2;
    ItemRequirement potOfBlood;
    ItemRequirement potWithGarlic;
    ItemRequirement potWithSpice;
    ItemRequirement potComplete;
    ItemRequirement fireSpells;
    ItemRequirement spikedBootsEquipped;
    ItemRequirement iceDiamondHighlighted;
    ItemRequirement bloodDiamondHighlighted;
    ItemRequirement smokeDiamondHighlighted;
    ItemRequirement shadowDiamondHighlighted;
    Requirement gotBloodDiamond;
    Requirement hadSmokeDiamond;
    Requirement gotIceDiamond;
    Requirement killedDamis;
    Requirement inSmokeDungeon;
    Requirement inFareedRoom;
    Requirement litTorch1;
    Requirement litTorch2;
    Requirement litTorch3;
    Requirement inDraynorSewer;
    Requirement litTorch4;
    Requirement unlockedFareedDoor;
    Requirement killedFareed;
    Requirement talkedToRasolo;
    Requirement unlockedCrossChest;
    Requirement gotRing;
    Requirement inShadowDungeon;
    Requirement damis1Nearby;
    Requirement damis2Nearby;
    Requirement talkedToMalak;
    Requirement askedAboutKillingDessous;
    Requirement dessousNearby;
    Requirement killedDessous;
    Requirement gaveCake;
    Requirement talkedToTrollChild;
    Requirement killedTrolls;
    Requirement inTrollArea;
    Requirement inPath;
    Requirement killedKamil;
    Requirement onIcePath;
    Requirement onIceBridge;
    Requirement smashedIce1;
    Requirement freedTrolls;
    Requirement placedBlood;
    Requirement placedIce;
    Requirement placedSmoke;
    Requirement placedShadow;
    Requirement inFloor1;
    Requirement inFloor2;
    Requirement inFloor3;
    Requirement inFloor4;
    Requirement inAzzRoom;
    DetailedQuestStep talkToArchaeologist;
    DetailedQuestStep talkToExpert;
    DetailedQuestStep talkToExpertAgain;
    DetailedQuestStep bringTranslationToArchaeologist;
    DetailedQuestStep talkToArchaeologistAgainAfterTranslation;
    DetailedQuestStep buyDrink;
    DetailedQuestStep talkToBartender;
    DetailedQuestStep talkToEblis;
    DetailedQuestStep bringItemsToEblis;
    DetailedQuestStep talkToEblisAtMirrors;
    DetailedQuestStep enterSmokeDungeon;
    DetailedQuestStep lightTorch1;
    DetailedQuestStep lightTorch2;
    DetailedQuestStep lightTorch3;
    DetailedQuestStep lightTorch4;
    DetailedQuestStep openChest;
    DetailedQuestStep useWarmKey;
    DetailedQuestStep enterFareedRoom;
    DetailedQuestStep killFareed;
    DetailedQuestStep talkToRasolo;
    DetailedQuestStep giveCakeToTroll;
    DetailedQuestStep talkToMalak;
    DetailedQuestStep askAboutKillingDessous;
    DetailedQuestStep talkToRuantun;
    DetailedQuestStep blessPot;
    DetailedQuestStep talkToMalakWithPot;
    DetailedQuestStep addSpice;
    DetailedQuestStep addPowder;
    DetailedQuestStep addPowderToFinish;
    DetailedQuestStep usePotOnGrave;
    DetailedQuestStep killDessous;
    DetailedQuestStep talkToMalakForDiamond;
    DetailedQuestStep getCross;
    DetailedQuestStep returnCross;
    DetailedQuestStep enterShadowDungeon;
    DetailedQuestStep waitForDamis;
    DetailedQuestStep killDamis1;
    DetailedQuestStep killDamis2;
    DetailedQuestStep talkToChildTroll;
    DetailedQuestStep enterIceGate;
    DetailedQuestStep enterTrollCave;
    DetailedQuestStep killKamil;
    DetailedQuestStep climbOnToLedge;
    DetailedQuestStep goThroughPathGate;
    DetailedQuestStep breakIce1;
    DetailedQuestStep breakIce2;
    DetailedQuestStep talkToTrolls;
    DetailedQuestStep talkToChildTrollAfterFreeing;
    DetailedQuestStep placeBlood;
    DetailedQuestStep placeShadow;
    DetailedQuestStep placeSmoke;
    DetailedQuestStep placeIce;
    DetailedQuestStep enterPyramid;
    DetailedQuestStep goDownFromFirstFloor;
    DetailedQuestStep goDownFromSecondFloor;
    DetailedQuestStep goDownFromThirdFloor;
    DetailedQuestStep enterMiddleOfPyramid;
    DetailedQuestStep talkToAzz;
    ObjectStep enterSewer;
    NpcStep killIceTrolls;
    ConditionalStep getSmokeDiamond;
    ConditionalStep getBloodDiamond;
    ConditionalStep getIceDiamond;
    ConditionalStep getShadowDiamond;
    ConditionalStep getDiamonds;
    Zone smokeDungeon;
    Zone fareedRoom;
    Zone shadowDungeon;
    Zone draynorSewer;
    Zone trollArea;
    Zone path1;
    Zone path2;
    Zone icePath;
    Zone iceBridge;
    Zone floor1;
    Zone floor2;
    Zone floor3;
    Zone floor4;
    Zone azzRoom;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToArchaeologist);
        steps.put(1, this.talkToExpert);
        steps.put(2, this.talkToExpertAgain);
        steps.put(3, this.talkToExpertAgain);
        steps.put(4, this.bringTranslationToArchaeologist);
        steps.put(5, this.talkToArchaeologistAgainAfterTranslation);
        steps.put(6, this.buyDrink);
        steps.put(7, this.talkToBartender);
        steps.put(8, this.talkToEblis);
        steps.put(9, this.bringItemsToEblis);
        steps.put(10, this.talkToEblisAtMirrors);
        this.getSmokeDiamond = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterSmokeDungeon, new Requirement[0]);
        this.getSmokeDiamond.addStep(new Conditions(this.inFareedRoom), this.killFareed);
        this.getSmokeDiamond.addStep(new Conditions(this.inSmokeDungeon, this.unlockedFareedDoor), this.enterFareedRoom);
        this.getSmokeDiamond.addStep(new Conditions(this.inSmokeDungeon, this.warmKey), this.useWarmKey);
        this.getSmokeDiamond.addStep(new Conditions(this.inSmokeDungeon, this.litTorch1, this.litTorch2, this.litTorch3, this.litTorch4), this.openChest);
        this.getSmokeDiamond.addStep(new Conditions(this.inSmokeDungeon, this.litTorch1, this.litTorch2, this.litTorch3), this.lightTorch4);
        this.getSmokeDiamond.addStep(new Conditions(this.inSmokeDungeon, this.litTorch1, this.litTorch2), this.lightTorch3);
        this.getSmokeDiamond.addStep(new Conditions(this.inSmokeDungeon, this.litTorch1), this.lightTorch2);
        this.getSmokeDiamond.addStep(this.inSmokeDungeon, this.lightTorch1);
        this.getSmokeDiamond.setLockingCondition(this.killedFareed);
        this.getShadowDiamond = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToRasolo, new Requirement[0]);
        this.getShadowDiamond.addStep(this.damis2Nearby, this.killDamis2);
        this.getShadowDiamond.addStep(this.damis1Nearby, this.killDamis1);
        this.getShadowDiamond.addStep(this.inShadowDungeon, this.waitForDamis);
        this.getShadowDiamond.addStep(this.gotRing, this.enterShadowDungeon);
        this.getShadowDiamond.addStep(this.unlockedCrossChest, this.returnCross);
        this.getShadowDiamond.addStep(this.talkedToRasolo, this.getCross);
        this.getShadowDiamond.setLockingCondition(this.killedDamis);
        this.getBloodDiamond = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToMalak, new Requirement[0]);
        this.getBloodDiamond.addStep(this.killedDessous, this.talkToMalakForDiamond);
        this.getBloodDiamond.addStep(this.dessousNearby, this.killDessous);
        this.getBloodDiamond.addStep(this.potComplete, this.usePotOnGrave);
        this.getBloodDiamond.addStep(this.potWithGarlic, this.addSpice);
        this.getBloodDiamond.addStep(this.potWithSpice, this.addPowderToFinish);
        this.getBloodDiamond.addStep(this.potOfBlood, this.addPowder);
        this.getBloodDiamond.addStep(this.silverPot2, this.talkToMalakWithPot);
        this.getBloodDiamond.addStep(this.silverPot, this.blessPot);
        this.getBloodDiamond.addStep(new Conditions(this.askedAboutKillingDessous, this.inDraynorSewer), this.talkToRuantun);
        this.getBloodDiamond.addStep(this.askedAboutKillingDessous, this.enterSewer);
        this.getBloodDiamond.addStep(this.talkedToMalak, this.askAboutKillingDessous);
        this.getBloodDiamond.setLockingCondition(this.gotBloodDiamond);
        this.getIceDiamond = new ConditionalStep((QuestHelper)this, (QuestStep)this.giveCakeToTroll, new Requirement[0]);
        this.getIceDiamond.addStep(new Conditions(this.onIceBridge, this.freedTrolls), this.talkToTrolls);
        this.getIceDiamond.addStep(new Conditions(this.freedTrolls), this.talkToChildTrollAfterFreeing);
        this.getIceDiamond.addStep(new Conditions(this.onIceBridge, this.killedKamil, this.smashedIce1), this.breakIce2);
        this.getIceDiamond.addStep(new Conditions(this.onIceBridge, this.killedKamil), this.breakIce1);
        this.getIceDiamond.addStep(new Conditions(this.onIcePath, this.killedKamil), this.goThroughPathGate);
        this.getIceDiamond.addStep(new Conditions(this.inPath, this.killedKamil), this.climbOnToLedge);
        this.getIceDiamond.addStep(this.inPath, this.killKamil);
        this.getIceDiamond.addStep(new Conditions(this.killedTrolls, this.inTrollArea), this.enterTrollCave);
        this.getIceDiamond.addStep(this.inTrollArea, this.killIceTrolls);
        this.getIceDiamond.addStep(this.talkedToTrollChild, this.enterIceGate);
        this.getIceDiamond.addStep(this.gaveCake, this.talkToChildTroll);
        this.getIceDiamond.setLockingCondition(this.gotIceDiamond);
        this.getDiamonds = new ConditionalStep((QuestHelper)this, (QuestStep)this.getSmokeDiamond, new Requirement[0]);
        this.getDiamonds.addStep(new Conditions(this.hadSmokeDiamond, this.killedDamis, this.gotBloodDiamond), this.getIceDiamond);
        this.getDiamonds.addStep(new Conditions(this.hadSmokeDiamond, this.killedDamis), this.getBloodDiamond);
        this.getDiamonds.addStep(this.killedFareed, this.getShadowDiamond);
        steps.put(11, this.getDiamonds);
        ConditionalStep placeDiamonds = new ConditionalStep((QuestHelper)this, (QuestStep)this.placeBlood, new Requirement[0]);
        placeDiamonds.addStep(new Conditions(this.placedBlood, this.placedSmoke, this.placedIce), this.placeShadow);
        placeDiamonds.addStep(new Conditions(this.placedBlood, this.placedSmoke), this.placeIce);
        placeDiamonds.addStep(this.placedBlood, this.placeSmoke);
        steps.put(12, placeDiamonds);
        ConditionalStep finishQuest = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterPyramid, new Requirement[0]);
        finishQuest.addStep(this.inAzzRoom, this.talkToAzz);
        finishQuest.addStep(this.inFloor4, this.enterMiddleOfPyramid);
        finishQuest.addStep(this.inFloor3, this.goDownFromThirdFloor);
        finishQuest.addStep(this.inFloor2, this.goDownFromSecondFloor);
        finishQuest.addStep(this.inFloor1, this.goDownFromFirstFloor);
        steps.put(13, finishQuest);
        steps.put(14, finishQuest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.coins650 = new ItemRequirement("Coins", ItemCollections.COINS, 650);
        this.magicLogs12 = new ItemRequirement("Magic logs (can be noted)", 1513, 12);
        this.magicLogs12.addAlternates(1514);
        this.steelBars6 = new ItemRequirement("Steel bar (can be noted)", 2353, 6);
        this.steelBars6.addAlternates(2354);
        this.moltenGlass6 = new ItemRequirement("Molten glass (can be noted)", 1775, 6);
        this.moltenGlass6.addAlternates(1776);
        this.ashes = new ItemRequirement("Ashes", 592);
        this.charcoal = new ItemRequirement("Charcoal", 973);
        this.bloodRune = new ItemRequirement("Blood rune", 565);
        this.bones = new ItemRequirement("Bones", 526);
        this.silverBar = new ItemRequirement("Silver bar", 2355);
        this.garlicPowder = new ItemRequirement("Garlic powder", 4668);
        this.garlicPowder.setHighlightInInventory(true);
        this.garlicPowder.setTooltip("Use a pestle and mortar on a garlic to make powder");
        this.spice = new ItemRequirement("Spice", 2007);
        this.spice.setHighlightInInventory(true);
        this.cake = new ItemRequirement("Cake", 1891);
        this.cake.addAlternates(1897);
        this.cake.setDisplayMatchedItemName(true);
        this.cake.setHighlightInInventory(true);
        this.spikedBoots = new ItemRequirement("Spiked boots", 3107).isNotConsumed();
        this.spikedBoots.setTooltip("Bring Dunstan in Burthorpe climbing boots and an iron bar to make these");
        this.spikedBootsEquipped = this.spikedBoots.equipped();
        this.climbingBoots = new ItemRequirement("Climbing boots", 3105).isNotConsumed();
        this.faceMask = new ItemRequirement("Facemask (or other face covering)", 4164).equipped().isNotConsumed();
        this.faceMask.setTooltip("Slayer mask and gas mask can also be used.");
        this.faceMask.addAlternates(4164, 11864, 11865, 25177, 1506);
        this.faceMask.setDisplayMatchedItemName(true);
        this.tinderbox = new ItemRequirement("Tinderbox", 590).isNotConsumed();
        this.manyLockpicks = new ItemRequirement("Many lockpicks", 1523, -1);
        this.etchings = new ItemRequirement("Etchings", 4654);
        this.etchings.setTooltip("You can get another from the Archaeologist in the Bedabin Camp");
        this.translation = new ItemRequirement("Translation", 4655);
        this.translation.setTooltip("You can get another from the Archaeological expert in the Exam Centre");
        this.warmKey = new ItemRequirement("Warm key", 4656);
        this.warmKey.setHighlightInInventory(true);
        this.smokeDiamond = new ItemRequirement("Smoke diamond", 4672);
        this.smokeDiamond.setTooltip("You can get another from the room you killed Fareed in inside the Smoke Dungeon");
        this.shadowDiamond = new ItemRequirement("Shadow diamond", 4673);
        this.shadowDiamond.setTooltip("You can get another from the east room of the Shadow Dungeon");
        this.iceDiamond = new ItemRequirement("Ice diamond", 4671);
        this.iceDiamond.setTooltip("You can get another from the Troll Child north of Trollheim");
        this.bloodDiamond = new ItemRequirement("Blood diamond", 4670);
        this.bloodDiamond.setTooltip("You can get another from Malak in Canifis");
        this.smokeDiamondHighlighted = new ItemRequirement("Smoke diamond", 4672).highlighted();
        this.smokeDiamondHighlighted.setTooltip("You can get another from the room you killed Fareed in inside the Smoke Dungeon");
        this.shadowDiamondHighlighted = new ItemRequirement("Shadow diamond", 4673).highlighted();
        this.shadowDiamondHighlighted.setTooltip("You can get another from the east room of the Shadow Dungeon");
        this.iceDiamondHighlighted = new ItemRequirement("Ice diamond", 4671).highlighted();
        this.iceDiamondHighlighted.setTooltip("You can get another from the Troll Child north of Trollheim");
        this.bloodDiamondHighlighted = new ItemRequirement("Blood diamond", 4670).highlighted();
        this.bloodDiamondHighlighted.setTooltip("You can get another from Malak in Canifis");
        this.iceGloves = new ItemRequirement("Ice gloves/smiths gloves(i)", 1580).equipped().isNotConsumed();
        this.iceGloves.setTooltip("to be able to wield a weapon against Fareed if not using water spells with runes only");
        this.iceGloves.addAlternates(27031);
        this.waterSpellOrMelee = new ItemRequirement("Water spells or melee gear", -1, -1);
        this.waterSpellOrMelee.setDisplayItemId(555);
        this.cross = new ItemRequirement("Gilded cross", 4674);
        this.cross.setTooltip("You can get another from the chest in the south of the Bandit Camp");
        this.ringOfVisibility = new ItemRequirement("Ring of visibility", 4657, 1, true).isNotConsumed();
        this.ringOfVisibility.setTooltip("You can get another from Rasolo south of Baxtorian Falls");
        this.antipoison = new ItemRequirement("Antipoisons", ItemCollections.ANTIPOISONS);
        this.silverPot = new ItemRequirement("Silver pot", 4658);
        this.silverPot2 = new ItemRequirement("Blessed pot", 4659);
        this.potOfBlood = new ItemRequirement("Blessed pot", 4661);
        this.potOfBlood.setHighlightInInventory(true);
        this.potWithGarlic = new ItemRequirement("Blessed pot", 4663);
        this.potWithGarlic.setHighlightInInventory(true);
        this.potWithSpice = new ItemRequirement("Blessed pot", 4667);
        this.potWithSpice.setHighlightInInventory(true);
        this.potComplete = new ItemRequirement("Blessed pot", 4665);
        this.potComplete.setHighlightInInventory(true);
        this.fireSpells = new ItemRequirement("Fire spells", -1, -1);
        this.fireSpells.setDisplayItemId(554);
        this.combatGear = new ItemRequirement("Decent combat gear", -1, -1);
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.digTele = new ItemRequirement("Digsite pendant/teleport", ItemCollections.DIGSITE_PENDANTS);
        this.digTele.addAlternates(12403);
        this.prayerPotions = new ItemRequirement("Prayer potions", ItemCollections.PRAYER_POTIONS);
        this.restorePotions = new ItemRequirement("Restore potions", ItemCollections.RESTORE_POTIONS);
        this.energyOrStaminas = new ItemRequirement("Energy/Stamina potions", ItemCollections.RUN_RESTORE_ITEMS);
        this.canifisTeleport = new TeleportItemRequirement("Teleport to Canifis. Fairy Ring (CKS), Fenkenstrain's teleport", ItemCollections.FAIRY_STAFF);
        this.canifisTeleport.addAlternates(19621);
        this.bedabinTeleport = new TeleportItemRequirement("Teleport to Bedabin Camp. Fairy Ring (BIQ), Camulet", ItemCollections.FAIRY_STAFF);
        this.bedabinTeleport.addAlternates(6707);
        this.pollnivneachTeleport = new TeleportItemRequirement("Teleport to Pollnivneach. Pollnivneach house teleport", 11743);
        this.waterfallTeleport = new TeleportItemRequirement("Teleport to the Waterfall. Skills necklace (Fishing Guild [1]), Games necklace (Barbarian Outpost [2])", ItemCollections.SKILLS_NECKLACES);
        this.waterfallTeleport.addAlternates(ItemCollections.GAMES_NECKLACES);
        this.banditCampTeleport = new TeleportItemRequirement("Teleport to Bandit Camp (desert). Fairy Ring (BIQ), Camulet", ItemCollections.FAIRY_STAFF);
        this.banditCampTeleport.addAlternates(6707);
        this.draynorTeleport = new TeleportItemRequirement("Teleport to Draynor Village. Amulet of Glory (Draynor Village [3]), Draynor Manor Teleport", ItemCollections.AMULET_OF_GLORIES);
        this.draynorTeleport.addAlternates(19615);
        this.trollheimTeleport = new TeleportItemRequirement("Teleport to Trollheim. Trollheim teleport, Ghommal's hilt (any tier)", 11747);
        this.trollheimTeleport.addAlternates(ItemCollections.GHOMMALS_HILT);
        this.pyramidTeleport = new TeleportItemRequirement("Teleport to Jaldraocht Pyramid. Camulet, Pollnivneach house teleport", 6707);
        this.pyramidTeleport.addAlternates(11743);
    }

    public void loadZones() {
        this.smokeDungeon = new Zone(new WorldPoint(3199, 9345, 0), new WorldPoint(3328, 9412, 0));
        this.fareedRoom = new Zone(new WorldPoint(3305, 9360, 0), new WorldPoint(3326, 9393, 0));
        this.shadowDungeon = new Zone(new WorldPoint(2624, 5051, 0), new WorldPoint(2757, 5125, 0));
        this.draynorSewer = new Zone(new WorldPoint(3078, 9641, 0), new WorldPoint(3129, 9699, 0));
        this.trollArea = new Zone(new WorldPoint(2839, 3716, 0), new WorldPoint(2868, 3741, 0));
        this.path1 = new Zone(new WorldPoint(2872, 3714, 0), new WorldPoint(2903, 3771, 0));
        this.path2 = new Zone(new WorldPoint(2817, 3748, 0), new WorldPoint(2892, 3869, 0));
        this.icePath = new Zone(new WorldPoint(2830, 3785, 1), new WorldPoint(2870, 3825, 1));
        this.iceBridge = new Zone(new WorldPoint(2823, 3807, 2), new WorldPoint(2855, 3812, 2));
        this.floor1 = new Zone(new WorldPoint(2893, 4944, 3), new WorldPoint(2931, 4973, 3));
        this.floor2 = new Zone(new WorldPoint(2823, 4936, 2), new WorldPoint(2874, 4977, 2));
        this.floor3 = new Zone(new WorldPoint(2758, 4935, 1), new WorldPoint(2811, 4980, 1));
        this.floor4 = new Zone(new WorldPoint(3186, 9269, 0), new WorldPoint(3266, 9339, 0));
        this.azzRoom = new Zone(new WorldPoint(3227, 9310, 0), new WorldPoint(3239, 9323, 0));
    }

    public void setupConditions() {
        this.killedDamis = new VarbitRequirement(383, 5);
        this.hadSmokeDiamond = new Conditions(true, this.smokeDiamond);
        this.gotIceDiamond = new Conditions(true, this.iceDiamond);
        this.gotBloodDiamond = new VarbitRequirement(373, 4);
        this.inSmokeDungeon = new ZoneRequirement(this.smokeDungeon);
        this.inFareedRoom = new ZoneRequirement(this.fareedRoom);
        this.litTorch1 = new VarbitRequirement(360, 1);
        this.litTorch2 = new VarbitRequirement(361, 1);
        this.litTorch3 = new VarbitRequirement(363, 1);
        this.litTorch4 = new VarbitRequirement(362, 1);
        this.unlockedFareedDoor = new VarbitRequirement(386, 1);
        this.killedFareed = new VarbitRequirement(376, 1);
        this.talkedToRasolo = new VarbitRequirement(383, 2);
        this.gotRing = new VarbitRequirement(383, 3, Operation.GREATER_EQUAL);
        this.unlockedCrossChest = new VarbitRequirement(384, 1);
        this.inShadowDungeon = new ZoneRequirement(this.shadowDungeon);
        this.damis1Nearby = new NpcInteractingRequirement(682);
        this.damis2Nearby = new NpcInteractingRequirement(683);
        this.talkedToMalak = new VarbitRequirement(373, 1);
        this.askedAboutKillingDessous = new VarbitRequirement(373, 2);
        this.inDraynorSewer = new ZoneRequirement(this.draynorSewer);
        this.dessousNearby = new NpcCondition(3459);
        this.killedDessous = new VarbitRequirement(373, 3);
        this.gaveCake = new VarbitRequirement(382, 1);
        this.talkedToTrollChild = new VarbitRequirement(382, 2, Operation.GREATER_EQUAL);
        this.killedKamil = new VarbitRequirement(382, 3, Operation.GREATER_EQUAL);
        this.freedTrolls = new VarbitRequirement(382, 4);
        this.gotIceDiamond = new VarbitRequirement(382, 5);
        this.killedTrolls = new VarbitRequirement(378, 5);
        this.inTrollArea = new ZoneRequirement(this.trollArea);
        this.inPath = new ZoneRequirement(this.path1, this.path2);
        this.onIcePath = new ZoneRequirement(this.icePath);
        this.onIceBridge = new ZoneRequirement(this.iceBridge);
        this.smashedIce1 = new VarbitRequirement(380, 1);
        this.placedSmoke = new VarbitRequirement(387, 1);
        this.placedShadow = new VarbitRequirement(388, 1);
        this.placedIce = new VarbitRequirement(389, 1);
        this.placedBlood = new VarbitRequirement(390, 1);
        this.inFloor1 = new ZoneRequirement(this.floor1);
        this.inFloor2 = new ZoneRequirement(this.floor2);
        this.inFloor3 = new ZoneRequirement(this.floor3);
        this.inFloor4 = new ZoneRequirement(this.floor4);
        this.inAzzRoom = new ZoneRequirement(this.azzRoom);
    }

    public void setupSteps() {
        this.talkToArchaeologist = new NpcStep((QuestHelper)this, 12162, new WorldPoint(3177, 3043, 0), "Talk to the Archaeologist in the Bedabin Camp. You can use the flying carpet service from the Shantay Pass to get here.", new Requirement[0]);
        this.talkToArchaeologist.addDialogStep("Do you have any quests?");
        this.talkToArchaeologist.addDialogStep("Yes.");
        this.talkToArchaeologist.addDialogStep("Yes, I'll help you.");
        this.talkToArchaeologist.addTeleport(this.bedabinTeleport);
        this.talkToExpert = new NpcStep((QuestHelper)this, 3639, new WorldPoint(3359, 3334, 0), "Talk to the Terry Balando in the Exam Centre found south-east of Varrock, directly south of the Digsite.", this.etchings);
        this.talkToExpert.addDialogStep("Ask about the Desert Treasure quest.");
        this.talkToExpert.addTeleport(this.digTele);
        this.talkToExpertAgain = new NpcStep((QuestHelper)this, 3639, new WorldPoint(3359, 3334, 0), "Talk to the Terry Balando again.", new Requirement[0]);
        this.talkToExpertAgain.addDialogStep("Ask about the Desert Treasure quest.");
        this.bringTranslationToArchaeologist = new NpcStep((QuestHelper)this, 12162, new WorldPoint(3177, 3043, 0), "Bring the translation to the Archaeologist in the Bedabin Camp.", this.translation);
        this.bringTranslationToArchaeologist.addDialogStep("Don't read book");
        this.talkToArchaeologistAgainAfterTranslation = new NpcStep((QuestHelper)this, 12162, new WorldPoint(3177, 3043, 0), "Talk to the Archaeologist again.", new Requirement[0]);
        this.talkToArchaeologistAgainAfterTranslation.addDialogStep("Help him");
        this.talkToArchaeologistAgainAfterTranslation.addTeleport(this.bedabinTeleport);
        this.buyDrink = new NpcStep((QuestHelper)this, 687, new WorldPoint(3159, 2978, 0), "Buy a drink from the pub in the Bandit Camp, then talk to the Bartender again.", this.coins650);
        this.buyDrink.addDialogStep("Buy a drink");
        this.buyDrink.addDialogStep("Buy a beer");
        this.talkToBartender = new NpcStep((QuestHelper)this, 687, new WorldPoint(3159, 2978, 0), "Talk to the bartender in the Bandit Camp again.", new Requirement[0]);
        this.talkToBartender.addDialogStep("I heard about four diamonds...");
        this.talkToEblis = new NpcStep((QuestHelper)this, 688, new WorldPoint(3184, 2989, 0), "Talk to Eblis in the east of the Bandit Camp.", new Requirement[0]);
        this.talkToEblis.addDialogStep("Tell me of The four diamonds of Azzanadra");
        this.talkToEblis.addDialogStep("Yes");
        this.bringItemsToEblis = new GiveItems((QuestHelper)this, 688, new WorldPoint(3184, 2989, 0), "Use the items on Eblis in the east of the Bandit Camp. Items can be noted.", this.ashes, this.bloodRune, this.bones, this.charcoal, this.moltenGlass6, this.magicLogs12, this.steelBars6);
        this.talkToEblisAtMirrors = new NpcStep((QuestHelper)this, 689, new WorldPoint(3214, 2954, 0), "Talk to Eblis at the mirrors south east of the Bandit Camp.", new Requirement[0]);
        this.enterSmokeDungeon = new ObjectStep((QuestHelper)this, 6279, new WorldPoint(3310, 2962, 0), "Enter the smokey well west of Pollnivneach. You'll need to run a lot, so bring energy/stamina potions if you can.", this.tinderbox, this.faceMask, this.iceGloves, this.waterSpellOrMelee);
        this.enterSmokeDungeon.addTeleport(this.pollnivneachTeleport);
        this.lightTorch1 = new ObjectStep((QuestHelper)this, 6405, new WorldPoint(3323, 9398, 0), "Light all the torches in the corners of the dungeon. This is timed, so try to do it as fast as possible. Start with the north east torch, and work your way to the south west.", this.tinderbox.highlighted());
        this.lightTorch1.addIcon(590);
        this.lightTorch2 = new ObjectStep((QuestHelper)this, 6407, new WorldPoint(3321, 9355, 0), "Light all the torches in the corners of the dungeon.", this.tinderbox.highlighted());
        this.lightTorch2.addIcon(590);
        this.lightTorch3 = new ObjectStep((QuestHelper)this, 6411, new WorldPoint(3207, 9395, 0), "Light all the torches in the corners of the dungeon.", this.tinderbox.highlighted());
        this.lightTorch3.addIcon(590);
        this.lightTorch4 = new ObjectStep((QuestHelper)this, 6409, new WorldPoint(3204, 9350, 0), "Light all the torches in the corners of the dungeon.", this.tinderbox.highlighted());
        this.lightTorch4.addIcon(590);
        this.lightTorch1.addSubSteps(this.lightTorch2, this.lightTorch3, this.lightTorch4);
        this.openChest = new ObjectStep((QuestHelper)this, 6420, new WorldPoint(3248, 9364, 0), "Open the chest in the middle of the dungeon.", new Requirement[0]);
        this.useWarmKey = new ObjectStep((QuestHelper)this, 6452, new WorldPoint(3305, 9376, 0), "Use the warm key on the gate in the east of the dungeon. Be prepared to fight Fareed. If you aren't wearing ice gloves he'll unequip your weapon.", this.warmKey, this.iceGloves, this.waterSpellOrMelee);
        this.useWarmKey.addIcon(4656);
        this.enterFareedRoom = new ObjectStep((QuestHelper)this, 6452, new WorldPoint(3305, 9376, 0), "Enter the gate in the east of the dungeon. Be prepared to fight Fareed. If you aren't wearing ice gloves he'll unequip your weapon.", this.iceGloves, this.waterSpellOrMelee);
        this.useWarmKey.addSubSteps(this.enterFareedRoom);
        this.killFareed = new NpcStep((QuestHelper)this, 3456, new WorldPoint(3315, 9375, 0), "Kill Fareed. Either use melee with ice gloves, or water spells.", this.iceGloves, this.waterSpellOrMelee);
        this.talkToRasolo = new NpcStep((QuestHelper)this, 679, new WorldPoint(2531, 3420, 0), "Talk to Rasolo south of Baxtorian Falls.", new Requirement[0]);
        this.talkToRasolo.addDialogStepWithExclusion("Yes", "Ask about the Diamonds of Azzanadra");
        this.talkToRasolo.addDialogStep("Ask about the Diamonds of Azzanadra");
        this.talkToRasolo.addTeleport(this.waterfallTeleport);
        this.getCross = new ObjectStep((QuestHelper)this, 6448, new WorldPoint(3169, 2967, 0), "Bring antipoison, food, and as many lockpicks as you can to the Bandit Camp, and try opening the chest in the south of the Bandit Camp. Keep trying until you succeed.", this.manyLockpicks, this.antipoison);
        this.getCross.addTeleport(this.banditCampTeleport);
        this.talkToMalak = new NpcStep((QuestHelper)this, 686, new WorldPoint(3496, 3479, 0), "Talk to Malak in the pub in Canifis.", new Requirement[0]);
        this.talkToMalak.addDialogStep("I am looking for a special Diamond...");
        this.talkToMalak.addDialogStep("Yes");
        this.talkToMalak.addTeleport(this.canifisTeleport);
        this.askAboutKillingDessous = new NpcStep((QuestHelper)this, 686, new WorldPoint(3496, 3479, 0), "Ask Malek in the pub in Canifis how to kill Dessous.", new Requirement[0]);
        this.askAboutKillingDessous.addDialogStep("How can I kill Dessous?");
        this.returnCross = new NpcStep((QuestHelper)this, 679, new WorldPoint(2531, 3420, 0), "Return the cross to Rasolo south of Baxtorian Falls.", this.cross);
        this.returnCross.addTeleport(this.waterfallTeleport);
        this.enterShadowDungeon = new ObjectStep((QuestHelper)this, 6560, new WorldPoint(2547, 3421, 0), "Equip the Ring of Visibility, then go down the ladder in the area east of Rasolo. It's recommended you bring combat gear to safe spot Damis.", this.ringOfVisibility);
        this.enterShadowDungeon.addTeleport(this.waterfallTeleport);
        this.waitForDamis = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2745, 5115, 0), "Go to the far eastern room of the dungeon, and wait for Damis to spawn.", new Requirement[0]);
        this.killDamis1 = new NpcStep((QuestHelper)this, 682, new WorldPoint(2745, 5115, 0), "Kill both phases of Damis. You can safespot him by attacking a bat and keeping the bat between the two of you.", new Requirement[0]);
        this.killDamis2 = new NpcStep((QuestHelper)this, 683, new WorldPoint(2745, 5115, 0), "Kill both phases of Damis. You can safespot him by attacking a bat and keeping the bat between the two of you.", new Requirement[0]);
        this.killDamis1.addSubSteps(this.killDamis2);
        this.enterSewer = new ObjectStep((QuestHelper)this, 6434, new WorldPoint(3084, 3272, 0), "Bring a silver bar to Ruantun in Draynor Sewer.", this.silverBar);
        this.enterSewer.addAlternateObjects(6435);
        this.enterSewer.addDialogStep("Actually, I don't need to know anything.");
        this.enterSewer.addTeleport(this.draynorTeleport);
        this.talkToRuantun = new NpcStep((QuestHelper)this, 3461, new WorldPoint(3112, 9690, 0), "Bring a silver bar to Ruantun in Draynor Sewer.", this.silverBar);
        this.talkToRuantun.addSubSteps(this.enterSewer);
        this.blessPot = new NpcStep((QuestHelper)this, 4062, new WorldPoint(2851, 3350, 0), "Travel to Entrana with the silver pot and have the High Priest enchant it.", this.silverPot);
        this.talkToMalakWithPot = new NpcStep((QuestHelper)this, 686, new WorldPoint(3496, 3479, 0), "Bring the blessed pot to Malak in the pub in Canifis. He'll bite you for a small bit of damage.", this.silverPot2);
        this.talkToMalakWithPot.addTeleport(this.canifisTeleport);
        this.addSpice = new DetailedQuestStep((QuestHelper)this, "Use the spice on the blessed pot.", this.potWithGarlic, this.spice);
        this.addPowder = new DetailedQuestStep((QuestHelper)this, "Add the garlic powder to the blessed pot.", this.potOfBlood, this.garlicPowder);
        this.addPowderToFinish = new DetailedQuestStep((QuestHelper)this, "Add the garlic powder to the blessed pot.", this.potWithSpice, this.garlicPowder);
        this.addPowder.addSubSteps(this.addPowderToFinish);
        this.usePotOnGrave = new ObjectStep((QuestHelper)this, 6437, new WorldPoint(3570, 3402, 0), "Use the blessed pot on the vampyre tomb in the graveyard south east of Canifis. Be prepared to fight Dessous.", this.potComplete);
        this.usePotOnGrave.addIcon(4665);
        this.killDessous = new NpcStep((QuestHelper)this, 3459, new WorldPoint(3570, 3403, 0), "Kill Dessous.", new Requirement[0]);
        this.talkToMalakForDiamond = new NpcStep((QuestHelper)this, 686, new WorldPoint(3496, 3479, 0), "Return to Malak in Canifis to get the Blood Diamond.", new Requirement[0]);
        this.talkToMalakForDiamond.addTeleport(this.canifisTeleport);
        this.giveCakeToTroll = new NpcStep((QuestHelper)this, 697, new WorldPoint(2835, 3740, 0), "Use a cake on the Troll Child north of Trollheim.", this.cake, this.spikedBoots);
        this.giveCakeToTroll.addIcon(1891);
        this.giveCakeToTroll.addTeleport(this.trollheimTeleport);
        this.talkToChildTroll = new NpcStep((QuestHelper)this, 696, new WorldPoint(2835, 3740, 0), "Talk to the Troll Child north of Trollheim.", new Requirement[0]);
        this.talkToChildTroll.addDialogStep("Yes");
        this.enterIceGate = new ObjectStep((QuestHelper)this, 5043, new WorldPoint(2838, 3740, 0), "Enter the ice gate east of the troll child. Make sure you're prepared for combat, and your stats to be continually drained.", this.fireSpells, this.spikedBoots);
        this.killIceTrolls = new NpcStep((QuestHelper)this, 699, new WorldPoint(2854, 3733, 0), "Kill 5 ice trolls.", true, new Requirement[0]);
        this.killIceTrolls.addAlternateNpcs(700, 701, 702, 703, 704, 705);
        this.enterTrollCave = new ObjectStep((QuestHelper)this, 6440, new WorldPoint(2869, 3719, 0), "Continue along the path through the cave to the east.", new Requirement[0]);
        this.killKamil = new NpcStep((QuestHelper)this, 3458, new WorldPoint(2863, 3757, 0), "Continue along the path until you find Kamil. Kill him with fire spells. Get into melee distance and protect from melee.", this.fireSpells);
        this.climbOnToLedge = new ObjectStep((QuestHelper)this, 6455, new WorldPoint(2837, 3804, 0), "Equip the spiked boots, then continue along the path until you reach an ice ledge. Climb up it.", this.spikedBootsEquipped);
        this.goThroughPathGate = new ObjectStep((QuestHelper)this, 6462, new WorldPoint(2854, 3811, 1), "Follow the Ice Path up to the top and enter the gate there.", new Requirement[0]);
        this.breakIce1 = new NpcStep((QuestHelper)this, 706, new WorldPoint(2826, 3808, 2), "Break the ice surrounding the trolls at the end of the path. Fire spells are effective for this.", this.fireSpells);
        this.breakIce2 = new NpcStep((QuestHelper)this, 707, new WorldPoint(2826, 3812, 2), "Break the ice surrounding the trolls at the end of the path. Fire spells are effective for this.", this.fireSpells);
        this.talkToTrolls = new NpcStep((QuestHelper)this, 709, new WorldPoint(2826, 3812, 2), "Talk to the troll parents at the end of the Ice Path.", new Requirement[0]);
        this.talkToChildTrollAfterFreeing = new NpcStep((QuestHelper)this, 696, new WorldPoint(2835, 3740, 0), "Talk to the Troll Child north of Trollheim to get the ice diamond.", new Requirement[0]);
        this.placeBlood = new ObjectStep((QuestHelper)this, 6482, new WorldPoint(3221, 2910, 0), "Place all the diamonds in the obelisks around the pyramid south east of the Bandit Camp. Note a mysterious stranger can appear and attack you whilst you're holding the diamonds.", this.bloodDiamondHighlighted, this.smokeDiamond, this.iceDiamond, this.shadowDiamond);
        this.placeBlood.addIcon(4670);
        this.placeBlood.addTeleport(this.pyramidTeleport);
        this.placeSmoke = new ObjectStep((QuestHelper)this, 6485, new WorldPoint(3245, 2910, 0), "Place all the diamonds in the obelisks around the pyramid south east of the Bandit Camp. Note a mysterious stranger can appear and attack you whilst you're holding the diamonds.", this.smokeDiamondHighlighted, this.iceDiamond, this.shadowDiamond);
        this.placeSmoke.addIcon(4672);
        this.placeIce = new ObjectStep((QuestHelper)this, 6488, new WorldPoint(3245, 2886, 0), "Place all the diamonds in the obelisks around the pyramid south east of the Bandit Camp. Note a mysterious stranger can appear and attack you whilst you're holding the diamonds.", this.iceDiamondHighlighted, this.shadowDiamond);
        this.placeIce.addIcon(4671);
        this.placeShadow = new ObjectStep((QuestHelper)this, 6491, new WorldPoint(3221, 2886, 0), "Place all the diamonds in the obelisks around the pyramid south east of the Bandit Camp. Note a mysterious stranger can appear and attack you whilst you're holding the diamonds.", this.shadowDiamondHighlighted);
        this.placeShadow.addIcon(4673);
        this.placeBlood.addSubSteps(this.placeSmoke, this.placeShadow, this.placeIce);
        this.enterPyramid = new ObjectStep((QuestHelper)this, 6497, new WorldPoint(3233, 2897, 0), "Bring any energy/stamina potions you have, some food, and enter the pyramid south east of the Bandit Camp.", this.energyOrStaminas, this.food, this.antipoison);
        this.goDownFromFirstFloor = new ObjectStep((QuestHelper)this, 6498, new WorldPoint(2909, 4964, 3), "Go down to the bottom of the pyramid. You may randomly fall out of the pyramid as you traverse it and need to start again.", new Requirement[0]);
        this.goDownFromSecondFloor = new ObjectStep((QuestHelper)this, 6499, new WorldPoint(2846, 4973, 2), "Go down to the bottom of the pyramid.", new Requirement[0]);
        this.goDownFromThirdFloor = new ObjectStep((QuestHelper)this, 6500, new WorldPoint(2784, 4941, 1), "Go down to the bottom of the pyramid.", new Requirement[0]);
        this.goDownFromFirstFloor.addSubSteps(this.goDownFromSecondFloor, this.goDownFromThirdFloor);
        this.enterMiddleOfPyramid = new ObjectStep((QuestHelper)this, 6553, new WorldPoint(3234, 9324, 0), "Enter the central room of the bottom floor.", new Requirement[0]);
        this.talkToAzz = new NpcStep((QuestHelper)this, 730, new WorldPoint(3232, 9317, 0), "Talk to Azzanadra to finish the quest!", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.coins650, this.magicLogs12, this.steelBars6, this.moltenGlass6, this.ashes, this.charcoal, this.bloodRune, this.bones, this.silverBar, this.garlicPowder, this.spice, this.cake, this.spikedBoots, this.climbingBoots, this.faceMask, this.tinderbox, this.iceGloves, this.manyLockpicks);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.combatGear, this.food, this.prayerPotions, this.energyOrStaminas, this.restorePotions, this.digTele, this.bedabinTeleport.quantity(2), this.pollnivneachTeleport, this.waterfallTeleport.quantity(2), this.banditCampTeleport.quantity(2), this.canifisTeleport.quantity(3), this.draynorTeleport, this.trollheimTeleport, this.pyramidTeleport);
    }

    @Override
    public List<String> getCombatRequirements() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("Dessous (level 139)");
        reqs.add("Kamil (level 154)");
        reqs.add("Fareed (level 167)");
        reqs.add("Damis (level 103, then level 174 in second phase)");
        reqs.add("5 ice trolls (level 120-124)");
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(3);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.MAGIC, 20000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Ring of Visibility", 4657, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Ability to use Ancient Magicks."), new UnlockReward("Ability to purchase an Ancient Staff."), new UnlockReward("Access to Smoke Dungeon."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.talkToArchaeologist, this.talkToExpert, this.talkToExpertAgain, this.bringTranslationToArchaeologist, this.talkToArchaeologistAgainAfterTranslation, this.buyDrink, this.talkToBartender, this.talkToEblis, this.bringItemsToEblis), Arrays.asList(this.coins650, this.ashes, this.bloodRune, this.bones, this.charcoal, this.moltenGlass6, this.magicLogs12, this.steelBars6), Arrays.asList(this.digTele, this.bedabinTeleport)));
        PanelDetails smokeDiamondPanel = new PanelDetails("Smoke diamond", Arrays.asList(this.enterSmokeDungeon, this.lightTorch1, this.openChest, this.useWarmKey, this.killFareed), Arrays.asList(this.faceMask, this.tinderbox, this.iceGloves, this.waterSpellOrMelee, this.energyOrStaminas), Collections.singletonList(this.pollnivneachTeleport));
        smokeDiamondPanel.setLockingStep(this.getSmokeDiamond);
        PanelDetails shadowDiamondPanel = new PanelDetails("Shadow diamond", Arrays.asList(this.talkToRasolo, this.getCross, this.returnCross, this.enterShadowDungeon, this.waitForDamis, this.killDamis1), Arrays.asList(this.manyLockpicks, this.antipoison, this.combatGear, this.food), Arrays.asList(this.waterfallTeleport.quantity(2), this.banditCampTeleport));
        shadowDiamondPanel.setLockingStep(this.getShadowDiamond);
        PanelDetails bloodDiamondPanel = new PanelDetails("Blood diamond", Arrays.asList(this.talkToMalak, this.askAboutKillingDessous, this.talkToRuantun, this.blessPot, this.talkToMalakWithPot, this.addPowder, this.addSpice, this.usePotOnGrave, this.killDessous, this.talkToMalakForDiamond), Arrays.asList(this.silverBar, this.spice, this.garlicPowder, this.combatGear, this.food), Arrays.asList(this.canifisTeleport.quantity(3), this.draynorTeleport));
        bloodDiamondPanel.setLockingStep(this.getBloodDiamond);
        PanelDetails iceDiamondPanel = new PanelDetails("Ice diamond", Arrays.asList(this.giveCakeToTroll, this.talkToChildTroll, this.enterIceGate, this.killIceTrolls, this.enterTrollCave, this.killKamil, this.climbOnToLedge, this.goThroughPathGate, this.breakIce1, this.breakIce2, this.talkToTrolls, this.talkToChildTrollAfterFreeing), Arrays.asList(this.cake, this.spikedBoots, this.combatGear, this.food, this.restorePotions, this.prayerPotions, this.energyOrStaminas, this.fireSpells), Collections.singletonList(this.trollheimTeleport));
        iceDiamondPanel.setLockingStep(this.getIceDiamond);
        PanelDetails finishingPanel = new PanelDetails("Freeing Azzanadra", Arrays.asList(this.placeBlood, this.enterPyramid, this.goDownFromFirstFloor, this.enterMiddleOfPyramid, this.talkToAzz), Arrays.asList(this.smokeDiamond, this.shadowDiamond, this.bloodDiamond, this.iceDiamond), Arrays.asList(this.pyramidTeleport, this.energyOrStaminas, this.food, this.prayerPotions, this.antipoison));
        allSteps.add(smokeDiamondPanel);
        allSteps.add(shadowDiamondPanel);
        allSteps.add(bloodDiamondPanel);
        allSteps.add(iceDiamondPanel);
        allSteps.add(finishingPanel);
        return allSteps;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.THE_DIG_SITE, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.TEMPLE_OF_IKOV, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.THE_TOURIST_TRAP, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.TROLL_STRONGHOLD, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.PRIEST_IN_PERIL, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.WATERFALL_QUEST, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.THIEVING, 53));
        req.add(new SkillRequirement(Skill.MAGIC, 50));
        req.add(new SkillRequirement(Skill.FIREMAKING, 50, true));
        req.add(new ComplexRequirement(LogicType.OR, "10 Slayer for face mask, or started Plague City for Gas mask", new SkillRequirement(Skill.SLAYER, 10, false), new QuestRequirement(QuestHelperQuest.PLAGUE_CITY, QuestState.IN_PROGRESS)));
        return req;
    }
}

