/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.demonslayer;

import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.QuestStep;
import java.util.HashMap;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;

public class IncantationStep
extends ConditionalStep {
    private final HashMap<Integer, String> words = new HashMap<Integer, String>(){
        {
            this.put(0, "Carlem");
            this.put(1, "Aber");
            this.put(2, "Camerinthum");
            this.put(3, "Purchai");
            this.put(4, "Gabindo");
        }
    };
    private final String RESET_INCANTATION_TEXT = "Now what was that incantation again?";
    private String[] incantationOrder;
    private int incantationPosition = 0;
    private QuestStep incantationStep;

    public IncantationStep(QuestHelper questHelper, QuestStep incantationStep) {
        super(questHelper, incantationStep, new Requirement[0]);
        this.incantationStep = incantationStep;
        ((QuestStep)this.steps.get(null)).getText().add("Incantation is currently unknown.");
    }

    @Override
    public void onWidgetLoaded(WidgetLoaded event) {
        int groupId = event.getGroupId();
        if (groupId == 217) {
            this.clientThread.invokeLater(this::resetIncarnationIfRequired);
        } else if (groupId == 219) {
            this.clientThread.invokeLater(this::updateChoiceIfRequired);
        }
        super.onWidgetLoaded(event);
    }

    private void resetIncarnationIfRequired() {
        Widget widget = this.client.getWidget(217, 4);
        if (widget == null) {
            return;
        }
        String text = widget.getText();
        if ("Now what was that incantation again?".equals(text)) {
            this.incantationPosition = 0;
        }
    }

    private void updateChoiceIfRequired() {
        if (!this.shouldUpdateChoice()) {
            return;
        }
        this.choices.resetChoices();
        this.addDialogStep(this.incantationOrder[this.incantationPosition]);
        ++this.incantationPosition;
    }

    private boolean shouldUpdateChoice() {
        Widget widget = this.client.getWidget(219, 1);
        if (widget == null) {
            return false;
        }
        Widget[] children = widget.getChildren();
        if (children == null || children.length < 3) {
            return false;
        }
        Widget childWidget = widget.getChild(2);
        return childWidget != null && "Aber".equals(childWidget.getText());
    }

    @Override
    protected void updateSteps() {
        if (this.incantationOrder != null || this.client.getVarbitValue(2562) == 0 && this.client.getVarbitValue(2563) == 0) {
            this.startUpStep(this.incantationStep);
            return;
        }
        this.incantationOrder = new String[]{this.words.get(this.client.getVarbitValue(2562)), this.words.get(this.client.getVarbitValue(2563)), this.words.get(this.client.getVarbitValue(2564)), this.words.get(this.client.getVarbitValue(2565)), this.words.get(this.client.getVarbitValue(2566))};
        String incantString = "Say the following in order: " + String.join((CharSequence)", ", this.incantationOrder);
        ((QuestStep)this.steps.get(null)).getText().set(1, incantString);
        this.startUpStep(this.incantationStep);
    }
}

