/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.demonslayer;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.helpers.quests.demonslayer.IncantationStep;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.DEMON_SLAYER)
public class DemonSlayer
extends BasicQuestHelper {
    ItemRequirement bucket;
    ItemRequirement bucketOfWater;
    ItemRequirement key1;
    ItemRequirement key2;
    ItemRequirement key3;
    ItemRequirement bones;
    ItemRequirement silverlight;
    ItemRequirement combatGear;
    ItemRequirement silverlightEquipped;
    ItemRequirement coin;
    ItemRequirement food;
    ItemRequirement bucketOfWaterOptional;
    ItemRequirement varrockTeleport;
    ItemRequirement wizardsTowerTeleport;
    Requirement inVarrockSewer;
    Requirement inCastleNWFloor1;
    Requirement inCastleNWFloor2;
    Requirement inCastleNEFloor1;
    Requirement hasPouredWaterIntoDrain;
    Requirement inTowerFloor1;
    Requirement obtainedSilverlight;
    Requirement delrithNearby;
    Requirement delrithWeakenedNearby;
    Requirement inInstance;
    QuestStep talkToPrysin;
    QuestStep goUpToRovin;
    QuestStep goUpToRovin2;
    QuestStep talkToRovin;
    QuestStep goDownstairsFromRovin;
    QuestStep goDownstairsFromRovin2;
    QuestStep goUpToBucket;
    QuestStep pickupBucket;
    QuestStep goDownFromBucket;
    QuestStep fillBucket;
    QuestStep useFilledBucketOnDrain;
    QuestStep goDownManhole;
    QuestStep pickupSecondKey;
    QuestStep goUpManhole;
    QuestStep goUpstairsWizard;
    QuestStep talkToTraiborn;
    QuestStep returnToPrysin;
    QuestStep getSilverlightBack;
    QuestStep killDelrith;
    QuestStep killDelrithStep;
    NpcStep talkToAris;
    ConditionalStep getFirstKey;
    ConditionalStep getSecondKey;
    ConditionalStep getThirdKey;
    ConditionalStep goAndKillDelrith;
    Zone varrockSewer;
    Zone castleNWFloor1;
    Zone castleNWFloor2;
    Zone castleNEFloor1;
    Zone towerFloor1;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToAris);
        steps.put(1, this.talkToPrysin);
        this.getFirstKey = new ConditionalStep((QuestHelper)this, this.goUpToRovin, new Requirement[0]);
        this.getFirstKey.addStep(this.inCastleNWFloor2, this.talkToRovin);
        this.getFirstKey.addStep(this.inCastleNWFloor1, this.goUpToRovin2);
        this.getFirstKey.setLockingCondition(new Conditions(LogicType.OR, this.obtainedSilverlight, this.key1.alsoCheckBank(this.questBank)));
        this.getSecondKey = new ConditionalStep((QuestHelper)this, this.goUpToBucket, new Requirement[0]);
        this.getSecondKey.addStep(new Conditions(this.hasPouredWaterIntoDrain, this.inVarrockSewer), this.pickupSecondKey);
        this.getSecondKey.addStep(this.hasPouredWaterIntoDrain, this.goDownManhole);
        this.getSecondKey.addStep(this.inCastleNWFloor1, this.goDownstairsFromRovin2);
        this.getSecondKey.addStep(this.inCastleNWFloor2, this.goDownstairsFromRovin);
        this.getSecondKey.addStep(this.bucketOfWater, this.useFilledBucketOnDrain);
        this.getSecondKey.addStep(new Conditions(this.inCastleNEFloor1, this.bucketOfWater), this.goDownFromBucket);
        this.getSecondKey.addStep(this.bucket, this.fillBucket);
        this.getSecondKey.addStep(this.inCastleNEFloor1, this.pickupBucket);
        this.getSecondKey.setLockingCondition(new Conditions(LogicType.OR, this.obtainedSilverlight, this.key2.alsoCheckBank(this.questBank)));
        this.getThirdKey = new ConditionalStep((QuestHelper)this, this.goUpstairsWizard, new Requirement[0]);
        this.getThirdKey.addStep(this.inTowerFloor1, this.talkToTraiborn);
        this.getThirdKey.addStep(this.inVarrockSewer, this.goUpManhole);
        this.getThirdKey.setLockingCondition(new Conditions(LogicType.OR, this.obtainedSilverlight, this.key3.alsoCheckBank(this.questBank)));
        this.goAndKillDelrith = new ConditionalStep((QuestHelper)this, this.getSilverlightBack, new Requirement[0]);
        this.goAndKillDelrith.addStep(this.silverlight.alsoCheckBank(this.questBank), this.killDelrith);
        ConditionalStep getKeys = new ConditionalStep((QuestHelper)this, (QuestStep)this.getFirstKey, new Requirement[0]);
        getKeys.addStep(this.obtainedSilverlight, this.goAndKillDelrith);
        getKeys.addStep(new Conditions(this.key1, this.key2, this.key3), this.returnToPrysin);
        getKeys.addStep(new Conditions(this.key1, this.key2), this.getThirdKey);
        getKeys.addStep(this.key1, this.getSecondKey);
        steps.put(2, getKeys);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.bucket = new ItemRequirement("Bucket", 1925).isNotConsumed();
        this.bucket.setHighlightInInventory(true);
        this.bucketOfWater = new ItemRequirement("Bucket of water", 1929);
        this.bucketOfWater.setHighlightInInventory(true);
        this.key1 = new ItemRequirement("Silverlight key", 2400);
        this.key2 = new ItemRequirement("Silverlight key", 2401);
        this.key3 = new ItemRequirement("Silverlight key", 2399);
        this.bones = new ItemRequirement("Bones (UNNOTED)", 526, 25);
        this.silverlight = new ItemRequirement("Silverlight", 2402).isNotConsumed();
        this.silverlightEquipped = new ItemRequirement("Silverlight", 2402, 1, true).isNotConsumed();
        this.combatGear = new ItemRequirement("Armour", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getArmour());
        this.bucketOfWaterOptional = new ItemRequirement("Bucket of water", 1929);
        this.bucketOfWaterOptional.canBeObtainedDuringQuest();
        this.varrockTeleport = new ItemRequirement("Varrock teleport", 8007);
        this.wizardsTowerTeleport = new ItemRequirement("Teleport to the Wizards' Tower", 21146);
        this.coin = new ItemRequirement("Coin", ItemCollections.COINS);
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
    }

    public void setupConditions() {
        this.inCastleNEFloor1 = new ZoneRequirement(this.castleNEFloor1);
        this.inCastleNWFloor1 = new ZoneRequirement(this.castleNWFloor1);
        this.inCastleNWFloor2 = new ZoneRequirement(this.castleNWFloor2);
        this.inVarrockSewer = new ZoneRequirement(this.varrockSewer);
        this.inTowerFloor1 = new ZoneRequirement(this.towerFloor1);
        this.hasPouredWaterIntoDrain = new VarbitRequirement(2568, 1);
        this.obtainedSilverlight = new VarbitRequirement(2567, 1);
        this.delrithNearby = new NpcCondition(5079);
        this.delrithWeakenedNearby = new NpcCondition(5080);
        this.inInstance = new VarbitRequirement(2569, 1);
    }

    public void setupZones() {
        this.varrockSewer = new Zone(new WorldPoint(3151, 9855, 0), new WorldPoint(3290, 9919, 0));
        this.castleNWFloor1 = new Zone(new WorldPoint(3200, 3490, 1), new WorldPoint(3206, 3500, 1));
        this.castleNWFloor2 = new Zone(new WorldPoint(3200, 3494, 2), new WorldPoint(3206, 3500, 2));
        this.castleNEFloor1 = new Zone(new WorldPoint(3207, 3487, 1), new WorldPoint(3225, 3497, 1));
        this.towerFloor1 = new Zone(new WorldPoint(3102, 3154, 1), new WorldPoint(3114, 3165, 1));
    }

    public void setupSteps() {
        this.talkToAris = new NpcStep((QuestHelper)this, 11868, new WorldPoint(3204, 3424, 0), "Talk to Aris in her tent in Varrock Square.", this.coin);
        this.talkToAris.addDialogStep("Yes.");
        this.talkToAris.addDialogStep("Ok, here you go.");
        this.talkToAris.addDialogStep("Okay, where is he? I'll kill him for you!");
        this.talkToAris.addDialogStep("So how did Wally kill Delrith?");
        this.talkToAris.addAlternateNpcs(11868);
        this.talkToPrysin = new NpcStep((QuestHelper)this, 5083, new WorldPoint(3203, 3472, 0), "Talk to Sir Prysin in the south west corner of Varrock Castle.", new Requirement[0]);
        this.talkToPrysin.addDialogStep("Aris said I should come and talk to you.");
        this.talkToPrysin.addDialogStep("I need to find Silverlight.");
        this.talkToPrysin.addDialogStep("He's back and unfortunately I've got to deal with him.");
        this.talkToPrysin.addDialogStep("So give me the keys!");
        this.talkToPrysin.addDialogStep("Can you give me your key?");
        this.goUpToRovin = new ObjectStep((QuestHelper)this, 11790, new WorldPoint(3203, 3498, 0), "Talk to Captain Rovin upstairs in the north west of Varrock Castle.", new Requirement[0]);
        this.goUpToRovin2 = new ObjectStep((QuestHelper)this, 11792, new WorldPoint(3203, 3498, 1), "Talk to Captain Rovin upstairs in the north west of Varrock Castle.", new Requirement[0]);
        this.talkToRovin = new NpcStep((QuestHelper)this, 5085, new WorldPoint(3205, 3498, 2), "Talk to Captain Rovin upstairs in the north west of Varrock Castle.", new Requirement[0]);
        this.talkToRovin.addDialogStep("Yes I know, but this is important.");
        this.talkToRovin.addDialogStep("There's a demon who wants to invade this city.");
        this.talkToRovin.addDialogStep("Yes, very.");
        this.talkToRovin.addDialogStep("It's not them who are going to fight the demon, it's me.");
        this.talkToRovin.addDialogStep("Sir Prysin said you would give me the key.");
        this.talkToRovin.addDialogStep("Why did he give you one of the keys then?");
        this.talkToRovin.addSubSteps(this.goUpToRovin, this.goUpToRovin2);
        this.goDownstairsFromRovin = new ObjectStep((QuestHelper)this, 11793, new WorldPoint(3203, 3498, 2), "Go to the Varrock Castle kitchen.", new Requirement[0]);
        this.goDownstairsFromRovin2 = new ObjectStep((QuestHelper)this, 11792, new WorldPoint(3203, 3498, 1), "Go to the Varrock Castle kitchen.", new Requirement[0]);
        this.goUpToBucket = new ObjectStep((QuestHelper)this, 11789, new WorldPoint(3219, 3497, 0), "Get a bucket from above the Varrock Castle kitchen.", new Requirement[0]);
        this.pickupBucket = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3221, 3497, 1), "Pick up the bucket nearby.", this.bucket);
        this.goDownFromBucket = new ObjectStep((QuestHelper)this, 11793, new WorldPoint(3219, 3497, 1), "Go back down to the kitchen.", new Requirement[0]);
        this.fillBucket = new ObjectStep((QuestHelper)this, 7422, new WorldPoint(3224, 3495, 0), "Use the bucket on the sink.", this.bucket);
        this.fillBucket.addIcon(1925);
        this.useFilledBucketOnDrain = new ObjectStep((QuestHelper)this, 17424, new WorldPoint(3225, 3496, 0), "Use the bucket of water on the drain outside the kitchen.", this.bucketOfWater);
        ((ObjectStep)this.useFilledBucketOnDrain).addAlternateObjects(17423);
        this.useFilledBucketOnDrain.addIcon(1929);
        this.useFilledBucketOnDrain.addSubSteps(this.goDownstairsFromRovin, this.goDownstairsFromRovin2, this.goUpToBucket, this.pickupBucket, this.goDownFromBucket, this.fillBucket);
        this.goDownManhole = new ObjectStep((QuestHelper)this, 882, new WorldPoint(3237, 3458, 0), "Go down into Varrock Sewer via the Manhole south east of Varrock Castle.", new Requirement[0]);
        ((ObjectStep)this.goDownManhole).addAlternateObjects(881);
        this.pickupSecondKey = new ObjectStep((QuestHelper)this, 17431, new WorldPoint(3225, 9897, 0), "Pick up the Rusty Key north of the Sewer entrance.", new Requirement[0]);
        this.goUpManhole = new ObjectStep((QuestHelper)this, 11806, new WorldPoint(3237, 9858, 0), "Bring Wizard Traiborn 25 bones in the Wizards' Tower.", this.bones);
        this.goUpstairsWizard = new ObjectStep((QuestHelper)this, 12536, new WorldPoint(3104, 3160, 0), "Bring Wizard Traiborn 25 bones in the Wizards' Tower.", this.bones);
        this.talkToTraiborn = new NpcStep((QuestHelper)this, 5081, new WorldPoint(3114, 3163, 1), "Bring Wizard Traiborn 25 bones in the Wizards' Tower. You don't need to bring them all at once.", this.bones);
        this.talkToTraiborn.addDialogStep("Talk about Demon Slayer.");
        this.talkToTraiborn.addDialogStep("I need to get a key given to you by Sir Prysin.");
        this.talkToTraiborn.addDialogStep("Well, have you got any keys knocking around?");
        this.talkToTraiborn.addDialogStep("I'll get the bones for you.");
        this.talkToTraiborn.addSubSteps(this.goUpManhole, this.goUpstairsWizard);
        this.returnToPrysin = new NpcStep((QuestHelper)this, 5083, new WorldPoint(3203, 3472, 0), "Return to Sir Prysin in the south west of Varrock Castle.", this.key1, this.key2, this.key3);
        this.getSilverlightBack = new NpcStep((QuestHelper)this, 5083, new WorldPoint(3203, 3472, 0), "Get Silverlight back from Sir Prysin in the south west of Varrock Castle.", new Requirement[0]);
        this.returnToPrysin.addSubSteps(this.getSilverlightBack);
        this.killDelrithStep = new NpcStep((QuestHelper)this, 5079, new WorldPoint(3227, 3370, 0), "Kill Delrith (level 27) using Silverlight at the dark wizards south of Varrock. Once defeated, you'll need to say the magic words to banish him.", this.silverlightEquipped, this.combatGear);
        this.killDelrith = new IncantationStep((QuestHelper)this, this.killDelrithStep);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.coin, this.bones, this.bucketOfWaterOptional, this.combatGear, this.food);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.varrockTeleport, this.wizardsTowerTeleport);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Delrith (level 27)");
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(3);
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Silverlight", 2402, 1));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.talkToAris, this.talkToPrysin), this.coin, this.bucketOfWaterOptional));
        PanelDetails rovinPanel = new PanelDetails("Get Rovin's key", Collections.singletonList(this.talkToRovin), this.bucketOfWaterOptional);
        rovinPanel.setLockingStep(this.getFirstKey);
        allSteps.add(rovinPanel);
        PanelDetails prysinPanel = new PanelDetails("Get Prysin's key", Arrays.asList(this.useFilledBucketOnDrain, this.goDownManhole, this.pickupSecondKey), new Requirement[0]);
        prysinPanel.setLockingStep(this.getSecondKey);
        allSteps.add(prysinPanel);
        PanelDetails traibornPanel = new PanelDetails("Get Traiborn's key", Collections.singletonList(this.talkToTraiborn), this.bones);
        traibornPanel.setLockingStep(this.getThirdKey);
        allSteps.add(traibornPanel);
        PanelDetails killDelrithPanel = new PanelDetails("Kill Delrith", Arrays.asList(this.returnToPrysin, this.killDelrithStep), this.silverlight, this.combatGear, this.food);
        allSteps.add(killDelrithPanel);
        return allSteps;
    }
}

