/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.deathtothedorgeshuun;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.npc.FollowerRequirement;
import com.questhelper.requirements.npc.NpcInteractingRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.DEATH_TO_THE_DORGESHUUN)
public class DeathToTheDorgeshuun
extends BasicQuestHelper {
    ItemRequirement pickaxe;
    ItemRequirement lightSource;
    ItemRequirement brooch;
    ItemRequirement book;
    ItemRequirement key;
    ItemRequirement silverware;
    ItemRequirement treaty;
    ItemRequirement varrockTeleport;
    ItemRequirement faladorTeleport;
    ItemRequirement lumbridgeTeleports;
    ItemRequirement hamShirt2;
    ItemRequirement hamRobe2;
    ItemRequirement hamHood2;
    ItemRequirement hamBoot2;
    ItemRequirement hamGloves2;
    ItemRequirement hamLogo2;
    ItemRequirement hamCloak2;
    ItemRequirement hamSet2;
    ItemRequirement hamShirt;
    ItemRequirement hamRobe;
    ItemRequirement hamHood;
    ItemRequirement hamBoot;
    ItemRequirement hamGloves;
    ItemRequirement hamLogo;
    ItemRequirement hamCloak;
    ItemRequirement hamSet;
    ItemRequirement zanik;
    ItemRequirement pickaxeHighlighted;
    ItemRequirement tinderbox;
    ItemRequirement crate;
    ItemRequirement combatGear;
    ItemRequirement gamesNecklace;
    FollowerRequirement zanikFollower;
    Requirement inBasement;
    Requirement inLumbridgeF0;
    Requirement inLumbridgeF1;
    Requirement inLumbridgeF2;
    Requirement inTunnels;
    Requirement inMines;
    Requirement inHamBase;
    Requirement zanikIsFollowing;
    Requirement talkedToShopkeeper;
    Requirement talkedToWoman;
    Requirement talkedToDuke;
    Requirement talkedToAereck;
    Requirement talkedToGoblins;
    Requirement goneOutside;
    Requirement heardSpeaker;
    Requirement isBehindGuard1;
    Requirement killedGuard1;
    Requirement isNearGuard4;
    Requirement isNearGuard5;
    Requirement inStoreroom;
    Requirement killedGuard2;
    Requirement killedGuard3;
    Requirement killedGuard4;
    Requirement killedGuard5;
    Requirement zanikWaitingFor4;
    Requirement zanikWaitingFor5;
    Requirement isDisguisedZanikFollowing;
    Requirement zanikPickedUp;
    Requirement ropeAddedToHole;
    Requirement minedRocks;
    Requirement inSwamp;
    Requirement inJunaRoom;
    Requirement inMill;
    Requirement killedGuards;
    Requirement talkedToJohn;
    DetailedQuestStep goDownFromF2;
    DetailedQuestStep talkToMistag;
    DetailedQuestStep talkToZanik;
    DetailedQuestStep talkToMistagToTravel;
    DetailedQuestStep talkToCook;
    DetailedQuestStep talkToDuke;
    DetailedQuestStep talkToHans;
    DetailedQuestStep talkToWoman;
    DetailedQuestStep talkToBob;
    DetailedQuestStep talkToAereck;
    DetailedQuestStep talkToGuide;
    DetailedQuestStep approachGoblins;
    DetailedQuestStep talkToShopkeeper;
    DetailedQuestStep goOutside;
    DetailedQuestStep talkToZanikAboutOrigin;
    DetailedQuestStep listenToSpeaker;
    DetailedQuestStep standNearTrapdoor;
    DetailedQuestStep goDownTrapdoor;
    DetailedQuestStep standBehindGuard1;
    DetailedQuestStep talkToGuard1;
    DetailedQuestStep talkToGuard2;
    DetailedQuestStep tellZanikToKillGuard3;
    DetailedQuestStep talkToJohanhus;
    DetailedQuestStep standNearGuard4;
    DetailedQuestStep tellZanikToWaitForGuard4;
    DetailedQuestStep runSouthToLureGuard4;
    DetailedQuestStep standNearGuard5;
    DetailedQuestStep tellZanikToWaitForGuard5;
    DetailedQuestStep lureGuard5;
    DetailedQuestStep listenToDoor;
    DetailedQuestStep checkZanikCorpse;
    DetailedQuestStep mineRocks;
    DetailedQuestStep climbIntoSwamp;
    DetailedQuestStep enterJunaArea;
    DetailedQuestStep talkToJuna;
    DetailedQuestStep talkToJunaMore;
    DetailedQuestStep searchCrate;
    DetailedQuestStep enterMill;
    DetailedQuestStep killGuards;
    DetailedQuestStep killSigmund;
    DetailedQuestStep smashDrill;
    DetailedQuestStep enterExit;
    DetailedQuestStep goDownFromF1;
    DetailedQuestStep goUpToF1;
    DetailedQuestStep goDownIntoBasement;
    DetailedQuestStep climbThroughHole;
    DetailedQuestStep goUpFromBasement;
    DetailedQuestStep enterHamLair;
    DetailedQuestStep talkToKazgar;
    ConditionalStep goTalkToMistag;
    ConditionalStep goTalkToZanik;
    ConditionalStep goHaveZanikFollow;
    ConditionalStep goTalkToCook;
    ConditionalStep goTalkToDuke;
    ConditionalStep goTalkToHans;
    ConditionalStep goTalkToWoman;
    ConditionalStep goTalkToBob;
    ConditionalStep goTalkToAereck;
    ConditionalStep goTalkToGuide;
    ConditionalStep goNearGoblins;
    ConditionalStep goTalkToShopkeeper;
    ConditionalStep goOutsideSteps;
    ConditionalStep goIntoHamLair;
    ConditionalStep goClearRocks;
    ConditionalStep goToJunaSteps;
    ConditionalStep learnZanikStory;
    ConditionalStep goGetZanikForMill;
    Zone basement;
    Zone lumbridgeF0;
    Zone lumbridgeF1;
    Zone lumbridgeF2;
    Zone tunnels;
    Zone mines;
    Zone hamBase;
    Zone behindGuard1;
    Zone nearGuard4;
    Zone nearGuard5;
    Zone storeRoom;
    Zone swamp;
    Zone junaRoom;
    Zone mill1;
    Zone mill2;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        this.setupConditionalSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.goTalkToMistag);
        steps.put(1, this.goTalkToZanik);
        steps.put(2, this.goTalkToZanik);
        ConditionalStep takeZanikAbout = new ConditionalStep((QuestHelper)this, (QuestStep)this.goHaveZanikFollow, new Requirement[0]);
        takeZanikAbout.addStep(new Conditions(this.zanikIsFollowing, this.goneOutside, this.talkedToDuke, this.talkedToWoman, this.talkedToAereck, this.talkedToGoblins, this.talkedToShopkeeper), this.talkToZanikAboutOrigin);
        takeZanikAbout.addStep(new Conditions(this.zanikIsFollowing, this.goneOutside, this.talkedToDuke, this.talkedToWoman, this.talkedToAereck, this.talkedToGoblins), this.goTalkToShopkeeper);
        takeZanikAbout.addStep(new Conditions(this.zanikIsFollowing, this.goneOutside, this.talkedToDuke, this.talkedToWoman, this.talkedToAereck), this.goNearGoblins);
        takeZanikAbout.addStep(new Conditions(this.zanikIsFollowing, this.goneOutside, this.talkedToDuke, this.talkedToWoman), this.goTalkToAereck);
        takeZanikAbout.addStep(new Conditions(this.zanikIsFollowing, this.goneOutside, this.talkedToDuke), this.goTalkToWoman);
        takeZanikAbout.addStep(new Conditions(this.zanikIsFollowing, this.talkedToDuke), this.goOutsideSteps);
        takeZanikAbout.addStep(this.zanikIsFollowing, this.goTalkToDuke);
        steps.put(3, takeZanikAbout);
        ConditionalStep infiltrateTheHam = new ConditionalStep((QuestHelper)this, (QuestStep)this.goHaveZanikFollow, new Requirement[0]);
        infiltrateTheHam.addStep(new Conditions(this.zanikIsFollowing, this.inHamBase, this.talkedToJohn, this.heardSpeaker), this.standNearTrapdoor);
        infiltrateTheHam.addStep(new Conditions(this.zanikIsFollowing, this.inHamBase, this.talkedToJohn), this.listenToSpeaker);
        infiltrateTheHam.addStep(new Conditions(this.zanikIsFollowing, this.inHamBase), this.talkToJohanhus);
        infiltrateTheHam.addStep(this.zanikIsFollowing, this.goIntoHamLair);
        steps.put(4, infiltrateTheHam);
        ConditionalStep findingTheHamMeeting = new ConditionalStep((QuestHelper)this, (QuestStep)this.goHaveZanikFollow, new Requirement[0]);
        findingTheHamMeeting.addStep(new Conditions(this.inStoreroom, this.killedGuard5), this.listenToDoor);
        findingTheHamMeeting.addStep(new Conditions(this.inStoreroom, this.killedGuard4, this.zanikWaitingFor5), this.lureGuard5);
        findingTheHamMeeting.addStep(new Conditions(this.isNearGuard5, this.killedGuard4), this.tellZanikToWaitForGuard5);
        findingTheHamMeeting.addStep(new Conditions(this.inStoreroom, this.killedGuard4), this.standNearGuard5);
        findingTheHamMeeting.addStep(new Conditions(this.inStoreroom, this.killedGuard3, this.zanikWaitingFor4), this.runSouthToLureGuard4);
        findingTheHamMeeting.addStep(new Conditions(this.isNearGuard4, this.killedGuard3), this.tellZanikToWaitForGuard4);
        findingTheHamMeeting.addStep(new Conditions(this.inStoreroom, this.killedGuard3), this.standNearGuard4);
        findingTheHamMeeting.addStep(new Conditions(this.inStoreroom, this.killedGuard2), this.tellZanikToKillGuard3);
        findingTheHamMeeting.addStep(new Conditions(this.inStoreroom, this.killedGuard1), this.talkToGuard2);
        findingTheHamMeeting.addStep(new Conditions(this.isBehindGuard1), this.talkToGuard1);
        findingTheHamMeeting.addStep(new Conditions(this.inStoreroom), this.standBehindGuard1);
        findingTheHamMeeting.addStep(new Conditions(this.zanikIsFollowing, this.inHamBase), this.goDownTrapdoor);
        findingTheHamMeeting.addStep(this.zanikIsFollowing, this.goIntoHamLair);
        steps.put(5, findingTheHamMeeting);
        ConditionalStep savingZanik = new ConditionalStep((QuestHelper)this, (QuestStep)this.checkZanikCorpse, new Requirement[0]);
        savingZanik.addStep(new Conditions(this.zanikPickedUp, this.inJunaRoom), this.talkToJuna);
        savingZanik.addStep(new Conditions(this.zanikPickedUp, this.inSwamp), this.enterJunaArea);
        savingZanik.addStep(new Conditions(this.zanikPickedUp, this.minedRocks), this.goToJunaSteps);
        savingZanik.addStep(new Conditions(this.zanikPickedUp, this.inTunnels), this.mineRocks);
        savingZanik.addStep(this.zanikPickedUp, this.goClearRocks);
        steps.put(6, savingZanik);
        steps.put(7, this.talkToJunaMore);
        steps.put(8, this.learnZanikStory);
        ConditionalStep infiltrateMill = new ConditionalStep((QuestHelper)this, (QuestStep)this.goGetZanikForMill, new Requirement[0]);
        infiltrateMill.addStep(this.inMill, this.killGuards);
        infiltrateMill.addStep(this.crate, this.enterMill);
        infiltrateMill.addStep(this.zanikIsFollowing, this.searchCrate);
        steps.put(9, infiltrateMill);
        ConditionalStep defeatSigmund = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterMill, new Requirement[0]);
        defeatSigmund.addStep(new Conditions(this.inMill, this.killedGuards), this.killSigmund);
        defeatSigmund.addStep(this.inMill, this.killGuards);
        steps.put(10, defeatSigmund);
        ConditionalStep goSmashMachine = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterMill, new Requirement[0]);
        goSmashMachine.addStep(this.inMill, this.smashDrill);
        steps.put(11, goSmashMachine);
        ConditionalStep goFinishQuest = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterMill, new Requirement[0]);
        goFinishQuest.addStep(this.inMill, this.enterExit);
        steps.put(12, goFinishQuest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.pickaxe = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES).isNotConsumed();
        this.pickaxeHighlighted = this.pickaxe.highlighted().isNotConsumed();
        this.lightSource = new ItemRequirement("A light source", ItemCollections.LIGHT_SOURCES).isNotConsumed();
        this.brooch = new ItemRequirement("Brooch", 5008);
        this.book = new ItemRequirement("Goblin symbol book", 5009);
        this.book.setHighlightInInventory(true);
        this.key = new ItemRequirement("Key", 5010);
        this.silverware = new ItemRequirement("Silverware", 5011);
        this.silverware.setTooltip("You can get another from the crate in the entrance of the H.A.M. hideout");
        this.treaty = new ItemRequirement("Peace treaty", 5012);
        this.treaty.setTooltip("You can get another from Duke Horacio");
        this.varrockTeleport = new ItemRequirement("Varrock teleport", 8007);
        this.lumbridgeTeleports = new ItemRequirement("Lumbridge teleports", 8008, 3);
        this.faladorTeleport = new ItemRequirement("Falador teleports", 8009);
        this.hamShirt = new ItemRequirement("Ham shirt", 4298, 1, true).isNotConsumed();
        this.hamRobe = new ItemRequirement("Ham robe", 4300, 1, true).isNotConsumed();
        this.hamHood = new ItemRequirement("Ham hood", 4302, 1, true).isNotConsumed();
        this.hamBoot = new ItemRequirement("Ham boots", 4310, 1, true).isNotConsumed();
        this.hamGloves = new ItemRequirement("Ham gloves", 4308, 1, true).isNotConsumed();
        this.hamLogo = new ItemRequirement("Ham logo", 4306, 1, true).isNotConsumed();
        this.hamCloak = new ItemRequirement("Ham cloak", 4304, 1, true).isNotConsumed();
        this.hamShirt2 = new ItemRequirement("Ham shirt", 4298, 2).isNotConsumed();
        this.hamRobe2 = new ItemRequirement("Ham robe", 4300, 2).isNotConsumed();
        this.hamHood2 = new ItemRequirement("Ham hood", 4302, 2).isNotConsumed();
        this.hamBoot2 = new ItemRequirement("Ham boots", 4310, 2).isNotConsumed();
        this.hamGloves2 = new ItemRequirement("Ham gloves", 4308, 2).isNotConsumed();
        this.hamLogo2 = new ItemRequirement("Ham logo", 4306, 2).isNotConsumed();
        this.hamCloak2 = new ItemRequirement("Ham cloak", 4304, 2).isNotConsumed();
        this.hamSet = new ItemRequirements("Full ham robe sets (7 pieces)(equipped)", this.hamShirt, this.hamRobe, this.hamHood, this.hamBoot, this.hamGloves, this.hamLogo, this.hamCloak).isNotConsumed();
        this.hamSet2 = new ItemRequirements("2 full ham robe sets (7 pieces/set)", this.hamShirt2, this.hamRobe2, this.hamHood2, this.hamBoot2, this.hamGloves2, this.hamLogo2, this.hamCloak2).isNotConsumed();
        this.hamSet2.setTooltip("The chance of thieving a ham clothing piece increases massively AFTER starting the quest");
        this.zanik = new ItemRequirement("Zanik", 8870);
        this.zanikFollower = new FollowerRequirement("Zanik following you. If she's not, retrieve her from Lumbridge Basement", 4508);
        this.tinderbox = new ItemRequirement("Tinderbox", 590).isNotConsumed();
        this.crate = new ItemRequirement("Crate with Zanik", 8871, 1, true);
        this.combatGear = new ItemRequirement("Magic or melee combat gear", -1, -1).isNotConsumed();
        this.gamesNecklace = new ItemRequirement("Games necklace (requires Tears of Guthix to teleport to Juna)", 3853);
    }

    public void loadZones() {
        this.basement = new Zone(new WorldPoint(3208, 9614, 0), new WorldPoint(3219, 9625, 0));
        this.lumbridgeF0 = new Zone(new WorldPoint(3136, 3136, 0), new WorldPoint(3328, 3328, 0));
        this.lumbridgeF1 = new Zone(new WorldPoint(3203, 3206, 1), new WorldPoint(3217, 3231, 1));
        this.lumbridgeF2 = new Zone(new WorldPoint(3203, 3206, 2), new WorldPoint(3217, 3231, 2));
        this.tunnels = new Zone(new WorldPoint(3221, 9602, 0), new WorldPoint(3308, 9661, 0));
        this.mines = new Zone(new WorldPoint(3309, 9600, 0), new WorldPoint(3327, 9655, 0));
        this.hamBase = new Zone(new WorldPoint(3140, 9600, 0), new WorldPoint(3190, 9655, 0));
        this.behindGuard1 = new Zone(new WorldPoint(2569, 5189, 0), new WorldPoint(2569, 5189, 0));
        this.nearGuard4 = new Zone(new WorldPoint(2576, 5195, 0), new WorldPoint(2576, 5195, 0));
        this.nearGuard5 = new Zone(new WorldPoint(2577, 5200, 0), new WorldPoint(2577, 5200, 0));
        this.storeRoom = new Zone(new WorldPoint(2566, 5185, 0), new WorldPoint(2577, 5203, 0));
        this.swamp = new Zone(new WorldPoint(3138, 9536, 0), new WorldPoint(3261, 9601, 0));
        this.junaRoom = new Zone(new WorldPoint(3205, 9484, 0), new WorldPoint(3263, 9537, 2));
        this.mill1 = new Zone(new WorldPoint(3204, 9661, 0), new WorldPoint(3246, 9663, 0));
        this.mill2 = new Zone(new WorldPoint(1991, 5056, 0), new WorldPoint(2030, 5097, 0));
    }

    public void setupConditions() {
        this.inBasement = new ZoneRequirement(this.basement);
        this.inLumbridgeF0 = new ZoneRequirement(this.lumbridgeF0);
        this.inLumbridgeF1 = new ZoneRequirement(this.lumbridgeF1);
        this.inLumbridgeF2 = new ZoneRequirement(this.lumbridgeF2);
        this.inTunnels = new ZoneRequirement(this.tunnels);
        this.inMines = new ZoneRequirement(this.mines);
        this.inHamBase = new ZoneRequirement(this.hamBase);
        this.isBehindGuard1 = new ZoneRequirement(this.behindGuard1);
        this.isNearGuard4 = new ZoneRequirement(this.nearGuard4);
        this.isNearGuard5 = new ZoneRequirement(this.nearGuard5);
        this.inStoreroom = new ZoneRequirement(this.storeRoom);
        this.inSwamp = new ZoneRequirement(this.swamp);
        this.inJunaRoom = new ZoneRequirement(this.junaRoom);
        this.inMill = new ZoneRequirement(this.mill1, this.mill2);
        this.talkedToDuke = new VarbitRequirement(2259, 1);
        this.talkedToAereck = new VarbitRequirement(2260, 1);
        this.talkedToGoblins = new VarbitRequirement(2261, 1);
        this.talkedToWoman = new VarbitRequirement(2262, 1);
        this.goneOutside = new VarbitRequirement(2263, 1);
        this.zanikIsFollowing = new Conditions(LogicType.OR, new VarbitRequirement(2264, 0));
        this.talkedToShopkeeper = new VarbitRequirement(2265, 1);
        this.heardSpeaker = new VarbitRequirement(2268, 1);
        this.talkedToJohn = new VarbitRequirement(2269, 1);
        this.killedGuard1 = new VarbitRequirement(2275, 1);
        this.killedGuard2 = new VarbitRequirement(2277, 1);
        this.killedGuard3 = new VarbitRequirement(2278, 1);
        this.killedGuard4 = new VarbitRequirement(2280, 1);
        this.killedGuard5 = new VarbitRequirement(2282, 1);
        this.isDisguisedZanikFollowing = new NpcInteractingRequirement(4509);
        this.zanikWaitingFor4 = new Conditions(new Conditions(LogicType.NOR, this.isDisguisedZanikFollowing), new NpcCondition(4509, new Zone(new WorldPoint(2575, 5195, 0), new WorldPoint(2576, 5195, 0))));
        this.zanikWaitingFor5 = new Conditions(new Conditions(LogicType.NOR, this.isDisguisedZanikFollowing), new NpcCondition(4509, new Zone(new WorldPoint(2577, 5199, 0), new WorldPoint(2577, 5200, 0))));
        this.zanikPickedUp = new VarbitRequirement(2271, 0);
        this.ropeAddedToHole = new VarbitRequirement(279, 1);
        this.minedRocks = new VarbitRequirement(538, 1);
        this.killedGuards = new VarbitRequirement(2283, 3);
    }

    public void setupSteps() {
        this.goDownIntoBasement = new ObjectStep((QuestHelper)this, 14880, new WorldPoint(3209, 3216, 0), "Enter the Lumbridge Castle basement.", new Requirement[0]);
        this.goDownFromF1 = new ObjectStep((QuestHelper)this, 16672, new WorldPoint(3205, 3208, 1), "Go down the staircase.", new Requirement[0]);
        this.goDownFromF1.addDialogStep("Climb down the stairs.");
        this.goUpToF1 = new ObjectStep((QuestHelper)this, 16671, new WorldPoint(3205, 3208, 0), "Go up to the first floor of Lumbridge Castle.", new Requirement[0]);
        this.goUpFromBasement = new ObjectStep((QuestHelper)this, 17385, new WorldPoint(3209, 9616, 0), "Go up to the surface.", new Requirement[0]);
        this.goDownFromF2 = new ObjectStep((QuestHelper)this, 16673, new WorldPoint(3205, 3208, 2), "Go downstairs.", new Requirement[0]);
        this.talkToKazgar = new NpcStep((QuestHelper)this, 7300, new WorldPoint(3230, 9610, 0), "Travel with Kazgar to shortcut to Mistag.", new Requirement[0]);
        this.talkToMistag = new NpcStep((QuestHelper)this, 7298, new WorldPoint(3319, 9615, 0), "", new Requirement[0]);
        this.talkToMistagToTravel = new NpcStep((QuestHelper)this, 7298, new WorldPoint(3319, 9615, 0), "Travel with Mistag back to Lumbridge.", new Requirement[0]);
        this.talkToZanik = new NpcStep((QuestHelper)this, 4506, new WorldPoint(3212, 9620, 0), "", new Requirement[0]);
        this.talkToCook = new NpcStep((QuestHelper)this, 4626, new WorldPoint(3209, 3215, 0), "", new Requirement[0]);
        this.talkToDuke = new NpcStep((QuestHelper)this, 815, new WorldPoint(3210, 3222, 1), "", new Requirement[0]);
        this.talkToHans = new NpcStep((QuestHelper)this, 3105, new WorldPoint(3222, 3218, 0), "", new Requirement[0]);
        this.talkToWoman = new NpcStep((QuestHelper)this, 1119, new WorldPoint(3224, 3218, 0), "", true, new Requirement[0]);
        ((NpcStep)this.talkToWoman).addAlternateNpcs(3108, 3106, 3111);
        this.talkToGuide = new NpcStep((QuestHelper)this, 306, new WorldPoint(3238, 3220, 0), "", new Requirement[0]);
        this.talkToBob = new NpcStep((QuestHelper)this, 10619, new WorldPoint(3231, 3208, 0), "", new Requirement[0]);
        this.talkToAereck = new NpcStep((QuestHelper)this, 2812, new WorldPoint(3244, 3210, 0), "", new Requirement[0]);
        this.approachGoblins = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3247, 3235, 0), "", new Requirement[0]);
        this.talkToShopkeeper = new NpcStep((QuestHelper)this, 2813, new WorldPoint(3211, 3247, 0), "", new Requirement[0]);
        this.talkToZanikAboutOrigin = new NpcStep((QuestHelper)this, 4508, "Talk to Zanik about her head sign.", new Requirement[0]);
        this.talkToZanikAboutOrigin.addDialogSteps("Have you seen enough of Lumbridge yet?", "Yes please!");
        this.goOutside = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3217, 3219, 0), "", new Requirement[0]);
        this.climbThroughHole = new ObjectStep((QuestHelper)this, 6898, new WorldPoint(3219, 9618, 0), "", new Requirement[0]);
        this.enterHamLair = new ObjectStep((QuestHelper)this, 5492, new WorldPoint(3166, 3252, 0), "", new Requirement[0]);
        this.talkToJohanhus = new NpcStep((QuestHelper)this, 2535, new WorldPoint(3173, 9619, 0), "Talk to Johanhus in the south east of the base.", new Requirement[0]);
        this.talkToJohanhus.addDialogStep("Are you planning to do anything about the cave goblins?");
        this.listenToSpeaker = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3166, 9623, 0), "Go stand at the south of the stage until Zanik talks about the speaker. Don't skip the dialog.", new Requirement[0]);
        this.standNearTrapdoor = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3166, 9623, 0), "Go stand next to the rubble south of the stage until Zanik notices it.", new Requirement[0]);
        this.goDownTrapdoor = new ObjectStep((QuestHelper)this, 15766, new WorldPoint(3166, 9622, 0), "Picklock the trapdoor south of the stage and go down it.", new Requirement[0]);
        this.standBehindGuard1 = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2569, 5189, 0), "Stand behind the guard and talk to them so they turn their back to Zanik.", new Requirement[0]);
        this.talkToGuard1 = new NpcStep((QuestHelper)this, 4516, new WorldPoint(2570, 5189, 0), "Talk to them so they turn their back to Zanik.", new Requirement[0]);
        this.standBehindGuard1.addSubSteps(this.talkToGuard1);
        this.talkToGuard2 = new NpcStep((QuestHelper)this, 4517, new WorldPoint(2566, 5192, 0), "Go through the nearby crack, then out the other side. Talk to the second guard to turn them around so Zanik can kill them.", new Requirement[0]);
        this.talkToGuard2.setLinePoints(Arrays.asList(new WorldPoint(2569, 5189, 0), new WorldPoint(2569, 5195, 0), new WorldPoint(2566, 5195, 0), new WorldPoint(2566, 5193, 0)));
        this.tellZanikToKillGuard3 = new NpcStep((QuestHelper)this, 4509, "Wait for the third guard to be walking away, then tell Zanik to kill them.", new Requirement[0]);
        this.tellZanikToKillGuard3.addDialogStep("Now!");
        this.standNearGuard4 = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2576, 5195, 0), "Stand near to the next guard, then tell Zanik to wait there.", new Requirement[0]);
        this.tellZanikToWaitForGuard4 = new NpcStep((QuestHelper)this, 4509, "Tell Zanik to wait.", new Requirement[0]);
        this.tellZanikToWaitForGuard4.addDialogStep("Wait here.");
        this.runSouthToLureGuard4 = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2577, 5191, 0), "Run east then south to lure the guard past Zanik.", new Requirement[0]);
        this.standNearGuard5 = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2577, 5200, 0), "Stand in the north east, just out of sight of the last guard, and tell Zanik to wait there.", new Requirement[0]);
        this.tellZanikToWaitForGuard5 = new NpcStep((QuestHelper)this, 4509, "Tell Zanik to wait.", new Requirement[0]);
        this.tellZanikToWaitForGuard5.addDialogStep("Wait here.");
        this.lureGuard5 = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2566, 5201, 0), "Approach the final guard from the west so Zanik can kill them.", new Requirement[0]);
        this.lureGuard5.setLinePoints(Arrays.asList(new WorldPoint(2577, 5199, 0), new WorldPoint(2577, 5195, 0), new WorldPoint(2566, 5195, 0), new WorldPoint(2566, 5201, 0)));
        this.checkZanikCorpse = new ObjectStep((QuestHelper)this, 15712, new WorldPoint(3161, 3246, 0), "Inspect Zanik outside the H.A.M base.", new Requirement[0]);
        this.listenToDoor = new ObjectStep((QuestHelper)this, 15757, new WorldPoint(2571, 5204, 0), "Listen to the large door.", new Requirement[0]);
        this.mineRocks = new ObjectStep((QuestHelper)this, 6912, new WorldPoint(3224, 9602, 0), "Use a pickaxe on the rocks to the south.", this.pickaxeHighlighted, this.lightSource);
        this.mineRocks.addIcon(1265);
        this.climbIntoSwamp = new ObjectStep((QuestHelper)this, 6912, new WorldPoint(3224, 9602, 0), "Climb into the Lumbridge Swamp.", new Requirement[0]);
        this.enterJunaArea = new ObjectStep((QuestHelper)this, 6659, new WorldPoint(3226, 9540, 0), "Enter the cave in the south east corner of the swamp.", this.lightSource, this.zanik);
        this.talkToJuna = new ObjectStep((QuestHelper)this, 3193, new WorldPoint(3252, 9517, 2), "Talk to Juna.", this.lightSource, this.zanik);
        this.talkToJunaMore = new ObjectStep((QuestHelper)this, 3193, new WorldPoint(3252, 9517, 2), "Talk to Juna with both hands free. Collect 20 tears of Guthix.", this.lightSource);
        this.talkToJunaMore.addDialogStep("Yes.");
        this.searchCrate = new ObjectStep((QuestHelper)this, 15704, new WorldPoint(3228, 3280, 0), "Search a crate south of the farm east of the Lumbridge.", this.zanikFollower, this.combatGear, this.hamSet);
        this.searchCrate.addDialogSteps("I don't know, what are you thinking?", "Good idea.");
        this.enterMill = new ObjectStep((QuestHelper)this, 15765, new WorldPoint(3230, 3286, 0), "Enter the trapdoor outside the farm.", this.combatGear, this.hamSet);
        this.killGuards = new NpcStep((QuestHelper)this, 397, new WorldPoint(2000, 5087, 0), "Kill the guards to the west.", true, new Requirement[0]);
        this.killSigmund = new NpcStep((QuestHelper)this, 991, new WorldPoint(2000, 5087, 0), "Defeat Sigmund. You need to use magic or melee to hurt him.", this.combatGear);
        this.smashDrill = new ObjectStep((QuestHelper)this, 15713, new WorldPoint(1998, 5088, 0), "Destroy the drilling machine.", new Requirement[0]);
        this.enterExit = new ObjectStep((QuestHelper)this, 15764, new WorldPoint(3245, 9661, 0), "Leave the area via the exit to the south to finish the quest.", new Requirement[0]);
    }

    private void setupConditionalSteps() {
        ConditionalStep goToF1Steps = new ConditionalStep((QuestHelper)this, (QuestStep)this.goUpToF1, new Requirement[0]);
        goToF1Steps.addStep(this.inLumbridgeF2, this.goDownFromF2);
        goToF1Steps.addStep(this.inBasement, this.goUpFromBasement);
        ConditionalStep goDownToBasement = new ConditionalStep((QuestHelper)this, (QuestStep)this.goDownIntoBasement, new Requirement[0]);
        goDownToBasement.addStep(this.inLumbridgeF2, this.goDownFromF2);
        goDownToBasement.addStep(this.inLumbridgeF1, this.goDownFromF1);
        this.goTalkToMistag = new ConditionalStep((QuestHelper)this, (QuestStep)goDownToBasement, "Travel through the tunnels under Lumbridge Castle until you reach Mistag, then talk to him.", this.lightSource);
        this.goTalkToMistag.addStep(this.inMines, this.talkToMistag);
        this.goTalkToMistag.addStep(this.inTunnels, this.talkToKazgar);
        this.goTalkToMistag.addStep(this.inBasement, this.climbThroughHole);
        this.goTalkToMistag.addDialogSteps("What is this favour?", "I'll act as a guide.", "Can you show me the way out of the mines?");
        this.goTalkToZanik = new ConditionalStep((QuestHelper)this, (QuestStep)goDownToBasement, "Talk to Zanik in Lumbridge Castle's basement.", this.hamHood2, this.hamShirt2, this.hamRobe2, this.hamBoot2, this.hamGloves2, this.hamCloak2, this.hamLogo2);
        this.goTalkToZanik.addStep(this.inMines, this.talkToMistagToTravel);
        this.goTalkToZanik.addStep(this.inTunnels, this.climbThroughHole);
        this.goTalkToZanik.addStep(this.inBasement, this.talkToZanik);
        if (this.client.getLocalPlayer() != null) {
            this.goTalkToZanik.addDialogStep("Yes, I'm " + this.client.getLocalPlayer().getName() + "!");
            this.goTalkToZanik.addDialogStep("Yes, I have two sets of robes!");
        }
        this.goHaveZanikFollow = new ConditionalStep((QuestHelper)this, (QuestStep)goDownToBasement, "Talk to Zanik in Lumbridge Castle's basement.", new Requirement[0]);
        this.goHaveZanikFollow.addStep(this.inBasement, this.talkToZanik);
        this.goHaveZanikFollow.addDialogSteps("Yes.", "Yes please!");
        this.goTalkToCook = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToCook, "Talk to the Lumbridge Cook.", this.zanikFollower);
        this.goTalkToCook.addStep(this.inLumbridgeF2, this.goDownFromF2);
        this.goTalkToCook.addStep(this.inLumbridgeF1, this.goDownFromF1);
        this.goTalkToCook.addStep(this.inBasement, this.goUpFromBasement);
        this.goTalkToDuke = new ConditionalStep((QuestHelper)this, (QuestStep)this.goUpToF1, "Talk to the Duke.", this.zanikFollower);
        this.goTalkToDuke.addStep(this.inLumbridgeF1, this.talkToDuke);
        this.goOutsideSteps = new ConditionalStep((QuestHelper)this, (QuestStep)this.goOutside, "Leave the castle, and go through the entire leaving cutscene. If you cut it short, enter/leave again.", this.zanikFollower);
        this.goOutsideSteps.addStep(this.inLumbridgeF2, this.goDownFromF2);
        this.goOutsideSteps.addStep(this.inLumbridgeF1, this.goDownFromF1);
        this.goOutsideSteps.addStep(this.inBasement, this.goUpFromBasement);
        this.goTalkToHans = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToHans, "Talk to Hans.", this.zanikFollower);
        this.goTalkToHans.addStep(this.inLumbridgeF2, this.goDownFromF2);
        this.goTalkToHans.addStep(this.inLumbridgeF1, this.goDownFromF1);
        this.goTalkToHans.addStep(this.inBasement, this.goUpFromBasement);
        this.goTalkToWoman = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToWoman, "Talk to any man or woman around Lumbridge.", this.zanikFollower);
        this.goTalkToWoman.addStep(this.inLumbridgeF2, this.goDownFromF2);
        this.goTalkToWoman.addStep(this.inLumbridgeF1, this.goDownFromF1);
        this.goTalkToWoman.addStep(this.inBasement, this.goUpFromBasement);
        this.goTalkToGuide = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToGuide, "Talk to the Lumbridge Guide.", this.zanikFollower);
        this.goTalkToGuide.addStep(this.inLumbridgeF2, this.goDownFromF2);
        this.goTalkToGuide.addStep(this.inLumbridgeF1, this.goDownFromF1);
        this.goTalkToGuide.addStep(this.inBasement, this.goUpFromBasement);
        this.goTalkToBob = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToBob, "Talk to Bob in south Lumbridge.", this.zanikFollower);
        this.goTalkToBob.addStep(this.inLumbridgeF2, this.goDownFromF2);
        this.goTalkToBob.addStep(this.inLumbridgeF1, this.goDownFromF1);
        this.goTalkToBob.addStep(this.inBasement, this.goUpFromBasement);
        this.goTalkToAereck = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToAereck, "Talk to Father Aereck.", this.zanikFollower);
        this.goTalkToAereck.addStep(this.inLumbridgeF2, this.goDownFromF2);
        this.goTalkToAereck.addStep(this.inLumbridgeF1, this.goDownFromF1);
        this.goTalkToAereck.addStep(this.inBasement, this.goUpFromBasement);
        this.goNearGoblins = new ConditionalStep((QuestHelper)this, (QuestStep)this.approachGoblins, "Approach the goblins east of the River Lum.", this.zanikFollower);
        this.goNearGoblins.addStep(this.inLumbridgeF2, this.goDownFromF2);
        this.goNearGoblins.addStep(this.inLumbridgeF1, this.goDownFromF1);
        this.goNearGoblins.addStep(this.inBasement, this.goUpFromBasement);
        this.goTalkToShopkeeper = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToShopkeeper, "Talk to the Lumbridge General Store shopkeeper.", this.zanikFollower);
        this.goTalkToShopkeeper.addStep(this.inLumbridgeF2, this.goDownFromF2);
        this.goTalkToShopkeeper.addStep(this.inLumbridgeF1, this.goDownFromF1);
        this.goTalkToShopkeeper.addStep(this.inBasement, this.goUpFromBasement);
        this.goIntoHamLair = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterHamLair, "Enter the H.A.M lair west of Lumbridge.", this.hamHood, this.hamShirt, this.hamRobe, this.hamBoot, this.hamGloves, this.hamCloak, this.hamLogo);
        this.goIntoHamLair.addStep(this.inLumbridgeF2, this.goDownFromF2);
        this.goIntoHamLair.addStep(this.inLumbridgeF1, this.goDownFromF1);
        this.goIntoHamLair.addStep(this.inBasement, this.goUpFromBasement);
        this.goClearRocks = new ConditionalStep((QuestHelper)this, (QuestStep)goDownToBasement, "Take Zanik to Juna in the Lumbridge Swamp. Using a games necklace is recommended.", this.pickaxe, this.lightSource, this.tinderbox, this.zanik);
        this.goClearRocks.addStep(this.inBasement, this.climbThroughHole);
        this.goToJunaSteps = new ConditionalStep((QuestHelper)this, (QuestStep)goDownToBasement, "Take Zanik to Juna in the Lumbridge Swamp. Using a games necklace is recommended.", this.lightSource, this.tinderbox, this.zanik);
        this.goToJunaSteps.addStep(this.inTunnels, this.climbIntoSwamp);
        this.goToJunaSteps.addStep(this.inBasement, this.climbThroughHole);
        this.goToJunaSteps.addSubSteps(this.goClearRocks, this.mineRocks, this.enterJunaArea, this.talkToJuna, this.talkToJunaMore);
        this.learnZanikStory = new ConditionalStep((QuestHelper)this, (QuestStep)this.goHaveZanikFollow, "Talk to Zanik about what happened to her.", new Requirement[0]);
        this.learnZanikStory.addStep(this.zanikIsFollowing, this.talkToZanik);
        this.goGetZanikForMill = new ConditionalStep((QuestHelper)this, (QuestStep)this.goHaveZanikFollow, "Talk to Zanik under the Lumbridge Castle.", new Requirement[0]);
        this.goGetZanikForMill.addDialogStep("Let's go!");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.lightSource, this.hamSet2, this.tinderbox, this.pickaxe, this.combatGear);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.lumbridgeTeleports, this.gamesNecklace);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Arrays.asList("3 H.A.M. Guards (level 22)", "Sigmund (level 50, melee or magic only)");
    }

    @Override
    public List<String> getNotes() {
        return Collections.singletonList("If you plan on getting the H.A.M. robes yourself rather than buying them, make sure to do so after starting the quest. The drop rate for robes is considerably increased during the quest.");
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.THIEVING, 2000), new ExperienceReward(Skill.RANGED, 2000));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Ability to use Dorgeshuun Special Attacks"), new UnlockReward("Access to H.A.M. Store Rooms."), new UnlockReward("Access to Dorgesh-Kann."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.goTalkToMistag, this.goTalkToZanik), this.lightSource, this.hamSet2));
        allSteps.add(new PanelDetails("Exploring Lumbridge", Arrays.asList(this.goTalkToCook, this.goTalkToDuke, this.goOutsideSteps, this.goTalkToWoman, this.goTalkToGuide, this.goTalkToBob, this.goTalkToAereck, this.goNearGoblins, this.goTalkToShopkeeper, this.talkToZanikAboutOrigin), this.lightSource, this.hamSet2));
        allSteps.add(new PanelDetails("Infiltrate the H.A.M", Arrays.asList(this.goIntoHamLair, this.talkToJohanhus, this.listenToSpeaker, this.standNearTrapdoor, this.goDownTrapdoor), this.lightSource, this.hamSet));
        allSteps.add(new PanelDetails("Reaching the meeting", Arrays.asList(this.standBehindGuard1, this.talkToGuard2, this.tellZanikToKillGuard3, this.standNearGuard4, this.tellZanikToWaitForGuard4, this.runSouthToLureGuard4, this.standNearGuard5, this.tellZanikToWaitForGuard5, this.lureGuard5, this.listenToDoor), new Requirement[0]));
        allSteps.add(new PanelDetails("Saving Zanik", Arrays.asList(this.checkZanikCorpse, this.goToJunaSteps, this.learnZanikStory), this.lightSource, this.tinderbox, this.pickaxe));
        allSteps.add(new PanelDetails("Foiling H.A.M", Arrays.asList(this.goGetZanikForMill, this.searchCrate, this.enterMill, this.killGuards, this.killSigmund, this.smashDrill, this.enterExit), this.hamSet, this.combatGear));
        return allSteps;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.THE_LOST_TRIBE, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.AGILITY, 23, true));
        req.add(new SkillRequirement(Skill.THIEVING, 23));
        return req;
    }
}

