/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.deathplateau;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.ChatMessageRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.npc.DialogRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.DEATH_PLATEAU)
public class DeathPlateau
extends BasicQuestHelper {
    ItemRequirement gamesNecklace;
    ItemRequirement asgarnianAle;
    ItemRequirement premadeBlurbOrCoins;
    ItemRequirement coins;
    ItemRequirement bread;
    ItemRequirement trout;
    ItemRequirement ironBar;
    ItemRequirement iou;
    ItemRequirement iouHighlight;
    ItemRequirement redStone;
    ItemRequirement blueStone;
    ItemRequirement yellowStone;
    ItemRequirement pinkStone;
    ItemRequirement greenStone;
    ItemRequirement certificate;
    ItemRequirement climbingBoots;
    ItemRequirement spikedBoots;
    ItemRequirement secretMap;
    ItemRequirement combination;
    Requirement inCastleDownstairs;
    Requirement inCastleUpstairs;
    Requirement inBarDownstairs;
    Requirement inBarUpstairs;
    Requirement inHaroldsRoom;
    Requirement givenHaroldBlurberry;
    Requirement isRedStoneDone;
    Requirement isBlueStoneDone;
    Requirement isYellowStoneDone;
    Requirement isPinkStoneDone;
    Requirement isGreenStoneDone;
    Requirement inSabaCave;
    Requirement isFarEnough;
    Requirement talkedToSaba;
    Requirement talkedToDunstan;
    QuestStep talkToDenulth1;
    QuestStep goToEohric1;
    QuestStep talkToEohric1;
    QuestStep goToHaroldStairs1;
    QuestStep goToHaroldDoor1;
    QuestStep talkToHarold1;
    QuestStep goToEohric2;
    QuestStep talkToEohric2;
    QuestStep takeAsgarnianAle;
    QuestStep goToHaroldStairs2;
    QuestStep goToHaroldDoor2;
    QuestStep talkToHarold2;
    QuestStep giveHaroldBlurberry;
    QuestStep gambleWithHarold;
    QuestStep readIou;
    QuestStep placeRedStone;
    QuestStep placeBlueStone;
    QuestStep placeYellowStone;
    QuestStep placePinkStone;
    QuestStep placeGreenStone;
    QuestStep placeStones;
    QuestStep enterSabaCave;
    QuestStep talkToSaba;
    QuestStep leaveSabaCave;
    QuestStep talkToTenzing1;
    QuestStep talkToDunstan1;
    QuestStep talkToDenulthForDunstan;
    QuestStep talkToDunstan2;
    QuestStep talkToTenzing2;
    QuestStep goNorth;
    QuestStep talkToDenulth3;
    QuestStep goToHaroldStairs3;
    QuestStep goToHaroldDoor3;
    QuestStep talkToHarold3;
    Zone castleDownstairs;
    Zone castleUpstairs;
    Zone barDownstairs;
    Zone barUpstairs;
    Zone haroldsRoom1;
    Zone haroldsRoom2;
    Zone sabaCave;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToDenulth1);
        ConditionalStep talkToEohricSteps1 = new ConditionalStep((QuestHelper)this, this.goToEohric1, new Requirement[0]);
        talkToEohricSteps1.addStep(this.inCastleUpstairs, this.talkToEohric1);
        steps.put(10, talkToEohricSteps1);
        ConditionalStep talkToHaroldSteps1 = new ConditionalStep((QuestHelper)this, this.goToHaroldStairs1, new Requirement[0]);
        talkToHaroldSteps1.addStep(this.inHaroldsRoom, this.talkToHarold1);
        talkToHaroldSteps1.addStep(this.inBarUpstairs, this.goToHaroldDoor1);
        steps.put(20, talkToHaroldSteps1);
        ConditionalStep talkToEohricSteps2 = new ConditionalStep((QuestHelper)this, this.goToEohric2, new Requirement[0]);
        talkToEohricSteps2.addStep(this.inCastleUpstairs, this.talkToEohric2);
        steps.put(30, talkToEohricSteps2);
        ConditionalStep talkToHaroldSteps2 = new ConditionalStep((QuestHelper)this, this.takeAsgarnianAle, new Requirement[0]);
        talkToHaroldSteps2.addStep(new Conditions(this.asgarnianAle, this.inHaroldsRoom), this.talkToHarold2);
        talkToHaroldSteps2.addStep(new Conditions(this.asgarnianAle, this.inBarUpstairs), this.goToHaroldDoor2);
        talkToHaroldSteps2.addStep(new Conditions(this.asgarnianAle), this.goToHaroldStairs2);
        steps.put(40, talkToHaroldSteps2);
        ConditionalStep gambleSteps = new ConditionalStep((QuestHelper)this, this.giveHaroldBlurberry, new Requirement[0]);
        gambleSteps.addStep(this.givenHaroldBlurberry, this.gambleWithHarold);
        steps.put(50, gambleSteps);
        steps.put(55, this.readIou);
        ConditionalStep stoneSteps = new ConditionalStep((QuestHelper)this, this.placeStones, new Requirement[0]);
        stoneSteps.addStep(new Conditions(this.inCastleDownstairs, this.isRedStoneDone, this.isBlueStoneDone, this.isYellowStoneDone, this.isPinkStoneDone), this.placeGreenStone);
        stoneSteps.addStep(new Conditions(this.inCastleDownstairs, this.isRedStoneDone, this.isBlueStoneDone, this.isYellowStoneDone), this.placePinkStone);
        stoneSteps.addStep(new Conditions(this.inCastleDownstairs, this.isRedStoneDone, this.isBlueStoneDone), this.placeYellowStone);
        stoneSteps.addStep(new Conditions(this.inCastleDownstairs, this.isRedStoneDone), this.placeBlueStone);
        stoneSteps.addStep(new Conditions(this.inCastleDownstairs), this.placeRedStone);
        steps.put(60, stoneSteps);
        ConditionalStep finalSteps = new ConditionalStep((QuestHelper)this, this.enterSabaCave, new Requirement[0]);
        finalSteps.addStep(new Conditions(this.isFarEnough, this.combination), this.talkToDenulth3);
        finalSteps.addStep(new Conditions(this.isFarEnough, this.inHaroldsRoom), this.talkToHarold3);
        finalSteps.addStep(new Conditions(this.isFarEnough, this.inBarUpstairs), this.goToHaroldDoor3);
        finalSteps.addStep(new Conditions(this.isFarEnough), this.goToHaroldDoor3);
        finalSteps.addStep(new Conditions(this.secretMap), this.goNorth);
        finalSteps.addStep(new Conditions(this.spikedBoots.alsoCheckBank(this.questBank)), this.talkToTenzing2);
        finalSteps.addStep(new Conditions(this.climbingBoots, this.certificate.alsoCheckBank(this.questBank)), this.talkToDunstan2);
        finalSteps.addStep(new Conditions(this.climbingBoots, this.talkedToDunstan), this.talkToDenulthForDunstan);
        finalSteps.addStep(new Conditions(this.climbingBoots), this.talkToDunstan1);
        finalSteps.addStep(new Conditions(this.talkedToSaba, this.inSabaCave), this.leaveSabaCave);
        finalSteps.addStep(this.talkedToSaba, this.talkToTenzing1);
        finalSteps.addStep(this.inSabaCave, this.talkToSaba);
        steps.put(70, finalSteps);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.asgarnianAle = new ItemRequirement("Asgarnian ale", 1905);
        ItemRequirement premadeBlurb = new ItemRequirement("Premade blurb' sp.", 2028);
        premadeBlurb.addAlternates(2064);
        ItemRequirement coins500 = new ItemRequirement("Coins", ItemCollections.COINS, 500);
        this.premadeBlurbOrCoins = new ItemRequirements(LogicType.OR, "Premade blurb' sp. (or a Blurberry special, or 500 coins to gamble with)", premadeBlurb, coins500);
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS, 60);
        this.bread = new ItemRequirement("Bread (UNNOTED)", 2309, 10);
        this.trout = new ItemRequirement("Trout (UNNOTED)", 333, 10);
        this.ironBar = new ItemRequirement("Iron bar", 2351);
        this.iou = new ItemRequirement("IOU", 3103);
        this.iouHighlight = new ItemRequirement("IOU", 3103);
        this.iouHighlight.setHighlightInInventory(true);
        this.redStone = new ItemRequirement("Stone ball", 3109);
        this.redStone.setHighlightInInventory(true);
        this.blueStone = new ItemRequirement("Stone ball", 3110);
        this.blueStone.setHighlightInInventory(true);
        this.yellowStone = new ItemRequirement("Stone ball", 3111);
        this.yellowStone.setHighlightInInventory(true);
        this.pinkStone = new ItemRequirement("Stone ball", 3112);
        this.pinkStone.setHighlightInInventory(true);
        this.greenStone = new ItemRequirement("Stone ball", 3113);
        this.greenStone.setHighlightInInventory(true);
        this.certificate = new ItemRequirement("Certificate", 3114);
        this.climbingBoots = new ItemRequirement("Climbing boots", ItemCollections.CLIMBING_BOOTS);
        this.spikedBoots = new ItemRequirement("Spiked boots", 3107);
        this.secretMap = new ItemRequirement("Secret way map", 3104);
        this.combination = new ItemRequirement("Combination", 3102);
        this.combination.setTooltip("You can get another by talking to Harold upstairs in Burthorpe's Pub");
        this.gamesNecklace = new ItemRequirement("Games necklace", ItemCollections.GAMES_NECKLACES);
    }

    public void setupZones() {
        this.castleDownstairs = new Zone(new WorldPoint(2893, 3558, 0), new WorldPoint(2904, 3569, 0));
        this.castleUpstairs = new Zone(new WorldPoint(2891, 3556, 1), new WorldPoint(2906, 3571, 1));
        this.barDownstairs = new Zone(new WorldPoint(2905, 3536, 0), new WorldPoint(2915, 3543, 0));
        this.barUpstairs = new Zone(new WorldPoint(2905, 3536, 1), new WorldPoint(2915, 3544, 1));
        this.haroldsRoom1 = new Zone(new WorldPoint(2905, 3536, 1), new WorldPoint(2906, 3542, 1));
        this.haroldsRoom2 = new Zone(new WorldPoint(2907, 3542, 1), new WorldPoint(2907, 3542, 1));
        this.sabaCave = new Zone(new WorldPoint(2266, 4752, 0), new WorldPoint(2273, 4762, 0));
    }

    public void setupConditions() {
        this.inCastleDownstairs = new ZoneRequirement(this.castleDownstairs);
        this.inCastleUpstairs = new ZoneRequirement(this.castleUpstairs);
        this.inBarDownstairs = new ZoneRequirement(this.barDownstairs);
        this.inBarUpstairs = new ZoneRequirement(this.barUpstairs);
        this.inHaroldsRoom = new ZoneRequirement(this.haroldsRoom1, this.haroldsRoom2);
        this.givenHaroldBlurberry = new ChatMessageRequirement("You give Harold a Blurberry Special.");
        this.isRedStoneDone = new ItemOnTileRequirement(this.redStone, new WorldPoint(2894, 3563, 0));
        this.isBlueStoneDone = new ItemOnTileRequirement(this.blueStone, new WorldPoint(2894, 3562, 0));
        this.isYellowStoneDone = new ItemOnTileRequirement(this.yellowStone, new WorldPoint(2895, 3562, 0));
        this.isPinkStoneDone = new ItemOnTileRequirement(this.pinkStone, new WorldPoint(2895, 3563, 0));
        this.isGreenStoneDone = new ItemOnTileRequirement(this.greenStone, new WorldPoint(2895, 3564, 0));
        this.inSabaCave = new ZoneRequirement(this.sabaCave);
        this.isFarEnough = new ChatMessageRequirement("You should go and speak to Denulth.");
        this.talkedToSaba = new Conditions(true, LogicType.OR, new DialogRequirement("Before the trolls came there used to be a nettlesome"), new DialogRequirement("Have you got rid of those pesky trolls yet?"));
        this.talkedToDunstan = new Conditions(true, LogicType.OR, new DialogRequirement("My son has just turned 16"), new DialogRequirement("Have you managed to get my son"));
    }

    public void setupSteps() {
        this.talkToDenulth1 = new NpcStep((QuestHelper)this, 4083, new WorldPoint(2896, 3529, 0), "Talk to Denulth in Burthorpe. You can get there with the Burthorpe minigame teleport or a games necklace.", new Requirement[0]);
        this.talkToDenulth1.addDialogStep(1, "Do you have any quests for me?");
        this.talkToDenulth1.addDialogStep(1, "Yes.");
        this.goToEohric1 = new ObjectStep((QuestHelper)this, 4626, new WorldPoint(2898, 3567, 0), "Ask Eohric, upstairs in Burthorpe castle, about the guard that was on duty last night.", new Requirement[0]);
        this.talkToEohric1 = new NpcStep((QuestHelper)this, 4103, new WorldPoint(2900, 3566, 1), "Ask Eohric, upstairs in Burthorpe castle, about the guard that was on duty last night.", new Requirement[0]);
        this.talkToEohric1.addDialogStep(1, "I'm looking for the guard that was on last night.");
        this.talkToEohric1.addSubSteps(this.goToEohric1);
        this.goToHaroldStairs1 = new ObjectStep((QuestHelper)this, 15645, new WorldPoint(2915, 3540, 0), "Talk to Harold, upstairs in the bar in Burthorpe.", new Requirement[0]);
        this.goToHaroldDoor1 = new ObjectStep((QuestHelper)this, 3747, new WorldPoint(2906, 3543, 1), "Talk to Harold, upstairs in the bar in Burthorpe.", new Requirement[0]);
        this.talkToHarold1 = new NpcStep((QuestHelper)this, 4101, new WorldPoint(2906, 3540, 1), "Talk to Harold, upstairs in the bar in Burthorpe.", new Requirement[0]);
        this.talkToHarold1.addDialogStep(1, "You're the guard that was on duty last night?");
        this.talkToHarold1.addSubSteps(this.goToHaroldStairs1, this.goToHaroldDoor1);
        this.goToEohric2 = new ObjectStep((QuestHelper)this, 4626, new WorldPoint(2898, 3567, 0), "Talk to Eohric.", new Requirement[0]);
        this.talkToEohric2 = new NpcStep((QuestHelper)this, 4103, new WorldPoint(2900, 3566, 1), "Talk to Eohric.", new Requirement[0]);
        this.talkToEohric2.addSubSteps(this.goToEohric2);
        this.takeAsgarnianAle = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2906, 3538, 0), "Take an Asgarnian ale from the bar.", this.coins, this.asgarnianAle, this.premadeBlurbOrCoins);
        this.goToHaroldStairs2 = new ObjectStep((QuestHelper)this, 15645, new WorldPoint(2915, 3540, 0), "Talk to Harold.", this.coins, this.asgarnianAle, this.premadeBlurbOrCoins);
        this.goToHaroldDoor2 = new ObjectStep((QuestHelper)this, 3747, new WorldPoint(2906, 3543, 1), "Talk to Harold.", this.coins, this.asgarnianAle, this.premadeBlurbOrCoins);
        this.talkToHarold2 = new NpcStep((QuestHelper)this, 4101, new WorldPoint(2906, 3540, 1), "Talk to Harold.", this.coins, this.asgarnianAle, this.premadeBlurbOrCoins);
        this.talkToHarold2.addSubSteps(this.goToHaroldStairs2, this.goToHaroldDoor2);
        this.giveHaroldBlurberry = new NpcStep((QuestHelper)this, 4101, new WorldPoint(2906, 3540, 1), "Talk to Harold to give him a Blurberry Special.", this.coins, this.premadeBlurbOrCoins);
        this.giveHaroldBlurberry.addDialogStep(3, "Can I buy you a drink?");
        this.gambleWithHarold = new NpcStep((QuestHelper)this, 4101, new WorldPoint(2906, 3540, 1), "Gamble with Harold (101 coins to immediately bankrupt him).", this.coins);
        this.gambleWithHarold.addDialogStep(2, "Would you like to gamble?");
        this.readIou = new DetailedQuestStep((QuestHelper)this, "Read the IOU, and then keep the Combination for the end of the quest.", this.iouHighlight);
        this.placeRedStone = new ObjectStep((QuestHelper)this, 3677, new WorldPoint(2894, 3563, 0), "Use the red stone on the mechanism.", this.redStone);
        this.placeBlueStone = new ObjectStep((QuestHelper)this, 3676, new WorldPoint(2894, 3562, 0), "Use the blue stone on the mechanism.", this.blueStone);
        this.placeYellowStone = new ObjectStep((QuestHelper)this, 3676, new WorldPoint(2895, 3562, 0), "Use the yellow stone on the mechanism.", this.yellowStone);
        this.placePinkStone = new ObjectStep((QuestHelper)this, 3677, new WorldPoint(2895, 3563, 0), "Use the pink stone on the mechanism.", this.pinkStone);
        this.placeGreenStone = new ObjectStep((QuestHelper)this, 3676, new WorldPoint(2895, 3564, 0), "Use the green stone on the mechanism.", this.greenStone);
        this.placeStones = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2896, 3563, 0), "Go back to Burthorpe castle, and place the coloured stone balls in the correct spots on the mechanism.", new Requirement[0]);
        this.placeStones.addSubSteps(this.placeRedStone, this.placeBlueStone, this.placeYellowStone, this.placePinkStone, this.placeGreenStone);
        this.enterSabaCave = new ObjectStep((QuestHelper)this, 3735, new WorldPoint(2858, 3579, 0), "Enter the cave north west of Burthorpe.", new Requirement[0]);
        this.talkToSaba = new NpcStep((QuestHelper)this, 4093, new WorldPoint(2270, 4757, 0), "Talk to Saba.", new Requirement[0]);
        this.talkToSaba.addDialogStep("Do you know of another way up Death Plateau?");
        this.leaveSabaCave = new ObjectStep((QuestHelper)this, 3736, new WorldPoint(2269, 4751, 0), "Leave Saba's cave.", new Requirement[0]);
        this.talkToTenzing1 = new NpcStep((QuestHelper)this, 4094, new WorldPoint(2820, 3555, 0), "Go northwest of Burthorpe, then south at the fork, and talk to Tenzing.", new Requirement[0]);
        this.talkToTenzing1.addDialogStep(1, "OK, I'll get those for you.");
        this.talkToTenzing1.addSubSteps(this.leaveSabaCave);
        this.talkToDenulthForDunstan = new NpcStep((QuestHelper)this, 4083, new WorldPoint(2896, 3529, 0), "Ask Denulth about Dunstan's son.", new Requirement[0]);
        this.talkToDunstan1 = new NpcStep((QuestHelper)this, 4105, new WorldPoint(2920, 3573, 0), "Talk to Dunstan at the anvil in Burthorpe, then talk to Denulth, where you started the quest.", this.climbingBoots);
        this.talkToDunstan1.addSubSteps(this.talkToDenulthForDunstan);
        this.talkToDunstan2 = new NpcStep((QuestHelper)this, 4105, new WorldPoint(2920, 3573, 0), "Talk to Dunstan to exchange the climbing boots for spiked boots.", this.climbingBoots, this.certificate, this.ironBar);
        this.talkToTenzing2 = new NpcStep((QuestHelper)this, 4094, new WorldPoint(2820, 3555, 0), "Bring the spiked boots, along with (unnoted) 10 bread and 10 trout to Tenzing.", this.spikedBoots, this.bread, this.trout);
        this.goNorth = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2865, 3609, 0), "Exit Tenzing's house through the north door, and go north, past the Death Plateau warning, and around to the east until you stop and say you've gone far enough.", this.secretMap);
        this.goToHaroldStairs3 = new ObjectStep((QuestHelper)this, 15645, new WorldPoint(2915, 3540, 0), "If you lost the Combination, retrieve it from Harold.", new Requirement[0]);
        this.goToHaroldDoor3 = new ObjectStep((QuestHelper)this, 3747, new WorldPoint(2906, 3543, 1), "If you lost the Combination, retrieve it from Harold.", new Requirement[0]);
        this.talkToHarold3 = new NpcStep((QuestHelper)this, 4101, new WorldPoint(2906, 3540, 1), "If you lost the Combination, retrieve it from Harold.", new Requirement[0]);
        this.talkToDenulth3 = new NpcStep((QuestHelper)this, 4083, new WorldPoint(2896, 3529, 0), "Go back and talk to Denulth, giving him the secret map and Combination.", this.secretMap, this.combination);
        this.talkToDenulth3.addSubSteps(this.goToHaroldStairs3, this.goToHaroldDoor3, this.talkToHarold3);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.coins, this.premadeBlurbOrCoins, this.ironBar, this.bread, this.trout);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Collections.singletonList(this.gamesNecklace);
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.ATTACK, 3000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("A pair of Steel Claws", 3097, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("The ability to craft claws."), new UnlockReward("The ability to purchase and equip Climbing Boots."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("The equipment room", Arrays.asList(this.talkToDenulth1, this.talkToEohric1, this.talkToHarold1, this.talkToEohric2, this.takeAsgarnianAle, this.talkToHarold2, this.giveHaroldBlurberry, this.gambleWithHarold, this.readIou, this.placeStones), this.coins, this.premadeBlurbOrCoins));
        allSteps.add(new PanelDetails("Get spiked boots", Arrays.asList(this.enterSabaCave, this.talkToSaba, this.talkToTenzing1, this.talkToDunstan1, this.talkToDunstan2), this.ironBar));
        allSteps.add(new PanelDetails("The secret path", Arrays.asList(this.talkToTenzing2, this.goNorth, this.talkToDenulth3), this.bread, this.trout));
        return allSteps;
    }
}

