/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.darknessofhallowvale;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.player.InInstanceRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.player.SpellbookRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.util.Spellbook;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.widget.WidgetTextRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.DARKNESS_OF_HALLOWVALE)
public class DarknessOfHallowvale
extends BasicQuestHelper {
    ItemRequirement airRune;
    ItemRequirement lawRune;
    ItemRequirement nails8;
    ItemRequirement nails4;
    ItemRequirement planks2;
    ItemRequirement planks1;
    ItemRequirement hammer;
    ItemRequirement pickaxe;
    ItemRequirement knife;
    ItemRequirement doorKey;
    ItemRequirement ladderPiece;
    ItemRequirement message;
    ItemRequirement charcoal;
    ItemRequirement papyrus;
    ItemRequirement sketch1;
    ItemRequirement sketch2;
    ItemRequirement sketch3;
    ItemRequirement largeOrnateKey;
    ItemRequirement messageFromFireplace;
    ItemRequirement haemBook;
    ItemRequirement sealedMessage;
    Requirement normalSpellbook;
    Requirement inNewBase;
    Requirement inTemple;
    Requirement inMeiyditch;
    Requirement inMyrequeBase;
    Requirement inMine;
    Requirement inNorthMeiy;
    Requirement inRandomRoom;
    Requirement atBarricade;
    Requirement pushedBoat;
    Requirement onEntryWall;
    Requirement onSecondWall;
    Requirement onThirdWall;
    Requirement onFourthWall;
    Requirement onDrakanWalls;
    Requirement inVanstromFight;
    Requirement knockedDownBoard;
    Requirement pathDoorOpen;
    Requirement fixedLadder;
    Requirement wallPressed;
    Requirement searchedRockySurface;
    Requirement hasSketches;
    Requirement cutPortrait;
    Requirement handedInSketches;
    Requirement tapestryCut;
    Requirement keyPlaced;
    Requirement hasTeleGrabRunesOrSearchedCase;
    Requirement searchedRuneCase;
    Requirement inLab;
    DetailedQuestStep enterBurghPubBasement;
    DetailedQuestStep talkToVeliaf;
    DetailedQuestStep leavePubBasement;
    DetailedQuestStep usePlankOnBoat;
    DetailedQuestStep usePlankOnChute;
    DetailedQuestStep pushBoat;
    DetailedQuestStep boardBoat;
    DetailedQuestStep kickBoard;
    DetailedQuestStep climbDownBoard;
    DetailedQuestStep talkToCitizen;
    DetailedQuestStep talkToRal;
    DetailedQuestStep travelToPots;
    DetailedQuestStep travelToLadderPart;
    DetailedQuestStep travelToFixLadder;
    DetailedQuestStep travelToMyrequeBase;
    DetailedQuestStep pressDecoratedWall;
    DetailedQuestStep enterRug;
    DetailedQuestStep talkToVertida;
    DetailedQuestStep goDownToDrezel;
    DetailedQuestStep talkToDrezel;
    DetailedQuestStep leaveDrezelToBushes;
    DetailedQuestStep searchBushes;
    DetailedQuestStep returnFromBushesToDrezel;
    DetailedQuestStep talkToRoald;
    DetailedQuestStep goToMines;
    DetailedQuestStep mineDaeyaltThenLeave;
    DetailedQuestStep returnToMeiyBase;
    DetailedQuestStep goDownFromRandomRoom;
    DetailedQuestStep climbUpFloor;
    DetailedQuestStep climbDownWallLadder;
    DetailedQuestStep searchRockySurface;
    DetailedQuestStep goThroughBarricade;
    DetailedQuestStep climbLadderSecondWall;
    DetailedQuestStep climbDownFromThirdWall;
    DetailedQuestStep climbUpDrakanWalls;
    DetailedQuestStep talkToSafalaan;
    DetailedQuestStep drawNorthWall;
    DetailedQuestStep drawWestWall;
    DetailedQuestStep drawSouthWall;
    DetailedQuestStep tankVanstrom;
    DetailedQuestStep finishSouthSketch;
    DetailedQuestStep talkToSarius;
    DetailedQuestStep talkToSafalaanInBase;
    DetailedQuestStep useKnifeOnFireplace;
    DetailedQuestStep readMessage;
    DetailedQuestStep inspectPortrait;
    DetailedQuestStep useKnifeOnPortrait;
    DetailedQuestStep leaveMeiyerBase;
    DetailedQuestStep useKnifeOnTapestry;
    DetailedQuestStep useKeyOnStatue;
    DetailedQuestStep goDownToLab;
    DetailedQuestStep getRunes;
    DetailedQuestStep telegrabBook;
    DetailedQuestStep leaveLab;
    ConditionalStep startQuest;
    ConditionalStep goTravelToMyrequeBase;
    ConditionalStep talkToVeliafAfterContact;
    ConditionalStep talkToVeliafAfterLetter;
    ConditionalStep talkToDrezelAfterVeliaf;
    ConditionalStep talkToDrezelAfterBushes;
    ConditionalStep talkToVeliafAfterDrezel;
    ConditionalStep returnToMeiyerditch;
    ConditionalStep goToSafalaan;
    ConditionalStep goSketchNorth;
    ConditionalStep goSketchWest;
    ConditionalStep goSketchSouth;
    ConditionalStep goTalkToSarius;
    ConditionalStep goFinishSouthSketch;
    ConditionalStep goOpenFireplace;
    ConditionalStep returnToSafalaanInBase;
    ConditionalStep returnToSafalaanInBaseNoSketches;
    ConditionalStep goUnlockLab;
    ConditionalStep getHaemBook;
    ConditionalStep bringSafalaanBook;
    ConditionalStep bringMessageToVeliafToFinish;
    Zone newBase;
    Zone temple;
    Zone entryWall;
    Zone entryWall2;
    Zone meiyerditch;
    Zone myrequeBase;
    Zone mine;
    Zone northMeiy;
    Zone randomRoom;
    Zone barricade1;
    Zone barricade2;
    Zone barricade3;
    Zone secondWall;
    Zone secondWall2;
    Zone thirdWall;
    Zone fourthWall;
    Zone fourthWall2;
    Zone drakanWalls;
    Zone drakanWalls2;
    Zone lab;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        this.setupConditionalSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.startQuest);
        ConditionalStep goRepairBoat = new ConditionalStep((QuestHelper)this, (QuestStep)this.usePlankOnBoat, new Requirement[0]);
        goRepairBoat.addStep(this.inNewBase, this.leavePubBasement);
        steps.put(10, goRepairBoat);
        steps.put(20, this.usePlankOnChute);
        ConditionalStep infiltrateMeiyer = new ConditionalStep((QuestHelper)this, (QuestStep)this.pushBoat, new Requirement[0]);
        infiltrateMeiyer.addStep(new Conditions(this.onEntryWall, this.knockedDownBoard), this.climbDownBoard);
        infiltrateMeiyer.addStep(this.onEntryWall, this.kickBoard);
        infiltrateMeiyer.addStep(this.inMeiyditch, this.talkToCitizen);
        infiltrateMeiyer.addStep(this.pushedBoat, this.boardBoat);
        steps.put(30, infiltrateMeiyer);
        steps.put(40, infiltrateMeiyer);
        steps.put(50, infiltrateMeiyer);
        steps.put(52, infiltrateMeiyer);
        steps.put(54, infiltrateMeiyer);
        ConditionalStep goTalkToRal = new ConditionalStep((QuestHelper)this, (QuestStep)this.pushBoat, new Requirement[0]);
        goTalkToRal.addStep(this.onEntryWall, this.climbDownBoard);
        goTalkToRal.addStep(this.inMeiyditch, this.talkToRal);
        goTalkToRal.addStep(this.pushedBoat, this.boardBoat);
        steps.put(60, goTalkToRal);
        steps.put(65, this.goTravelToMyrequeBase);
        ConditionalStep enterBase = new ConditionalStep((QuestHelper)this, (QuestStep)this.pressDecoratedWall, new Requirement[0]);
        enterBase.addStep(this.inMyrequeBase, this.talkToVertida);
        enterBase.addStep(this.wallPressed, this.enterRug);
        steps.put(70, enterBase);
        steps.put(80, enterBase);
        steps.put(90, this.talkToVeliafAfterContact);
        steps.put(100, this.talkToVeliafAfterLetter);
        steps.put(110, this.talkToDrezelAfterVeliaf);
        ConditionalStep goSearchBushes = new ConditionalStep((QuestHelper)this, (QuestStep)this.searchBushes, new Requirement[0]);
        goSearchBushes.addStep(this.inTemple, this.leaveDrezelToBushes);
        steps.put(120, goSearchBushes);
        steps.put(130, this.talkToDrezelAfterBushes);
        steps.put(135, this.talkToRoald);
        steps.put(140, this.talkToRoald);
        steps.put(150, this.talkToRoald);
        steps.put(160, this.talkToRoald);
        steps.put(170, this.talkToVeliafAfterDrezel);
        steps.put(180, this.returnToMeiyerditch);
        steps.put(190, this.goToSafalaan);
        steps.put(195, this.goToSafalaan);
        steps.put(200, this.goSketchNorth);
        steps.put(210, this.goSketchWest);
        steps.put(220, this.goSketchSouth);
        steps.put(230, this.goSketchSouth);
        steps.put(240, this.goTalkToSarius);
        ConditionalStep finishSketchAndGetMessage = new ConditionalStep((QuestHelper)this, (QuestStep)this.goFinishSouthSketch, new Requirement[0]);
        finishSketchAndGetMessage.addStep(this.hasSketches, this.goOpenFireplace);
        steps.put(250, finishSketchAndGetMessage);
        ConditionalStep goGiveSafalaanItems = new ConditionalStep((QuestHelper)this, (QuestStep)this.returnToSafalaanInBase, new Requirement[0]);
        goGiveSafalaanItems.addStep(this.handedInSketches, this.returnToSafalaanInBaseNoSketches);
        steps.put(260, goGiveSafalaanItems);
        steps.put(270, this.goUnlockLab);
        steps.put(280, this.goUnlockLab);
        steps.put(290, this.getHaemBook);
        steps.put(300, this.getHaemBook);
        steps.put(310, this.bringMessageToVeliafToFinish);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.hammer = new ItemRequirement("Hammer", ItemCollections.HAMMER).isNotConsumed();
        this.planks2 = new ItemRequirement("Plank", 960, 2);
        this.planks1 = new ItemRequirement("Plank", 960);
        this.nails8 = new ItemRequirement("Nails", ItemCollections.NAILS, 8);
        this.nails4 = new ItemRequirement("Nails", ItemCollections.NAILS, 4);
        this.pickaxe = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES).isNotConsumed();
        this.pickaxe.setTooltip("You can get one from one of the miners in the mine");
        this.knife = new ItemRequirement("Knife", 946).isNotConsumed();
        this.airRune = new ItemRequirement("Air rune", 556);
        this.lawRune = new ItemRequirement("Law rune", 563);
        this.doorKey = new ItemRequirement("Door key", 9654);
        this.ladderPiece = new ItemRequirement("Ladder top", 9655);
        this.message = new ItemRequirement("Message", 9633);
        this.message.setTooltip("You can get another from Vertida in the Meiyerditch Myreque base");
        this.charcoal = new ItemRequirement("Charcoal", 973);
        this.charcoal.setHighlightInInventory(true);
        this.papyrus = new ItemRequirement("Papyrus", 970);
        this.papyrus.setHighlightInInventory(true);
        this.sketch1 = new ItemRequirement("Castle sketch 1", 9646);
        this.sketch2 = new ItemRequirement("Castle sketch 2", 9647);
        this.sketch3 = new ItemRequirement("Castle sketch 3", 9648);
        this.largeOrnateKey = new ItemRequirement("Large ornate key", 9651);
        this.messageFromFireplace = new ItemRequirement("Message", 9649);
        this.messageFromFireplace.setHighlightInInventory(true);
        this.haemBook = new ItemRequirement("Haemalchemy volume 1", 9652);
        this.sealedMessage = new ItemRequirement("Sealed message", 9653);
        this.sealedMessage.setTooltip("You can get another from Safalaan");
        this.normalSpellbook = new SpellbookRequirement(Spellbook.NORMAL);
    }

    public void loadZones() {
        this.newBase = new Zone(new WorldPoint(3489, 9622, 0), new WorldPoint(3500, 9632, 1));
        this.temple = new Zone(new WorldPoint(3402, 9880, 0), new WorldPoint(3443, 9907, 0));
        this.entryWall = new Zone(new WorldPoint(3586, 3160, 1), new WorldPoint(3611, 3192, 1));
        this.entryWall2 = new Zone(new WorldPoint(3587, 3193, 1), new WorldPoint(3592, 3212, 1));
        this.meiyerditch = new Zone(new WorldPoint(3586, 3157, 0), new WorldPoint(3643, 3330, 3));
        this.myrequeBase = new Zone(new WorldPoint(3616, 9616, 0), new WorldPoint(3640, 9647, 0));
        this.mine = new Zone(new WorldPoint(2376, 4616, 2), new WorldPoint(2399, 4638, 2));
        this.northMeiy = new Zone(new WorldPoint(3595, 3240, 0), new WorldPoint(3644, 3328, 2));
        this.randomRoom = new Zone(new WorldPoint(3594, 3198, 1), new WorldPoint(3608, 3216, 1));
        this.barricade1 = new Zone(new WorldPoint(3588, 3205, 0), new WorldPoint(3590, 3233, 0));
        this.barricade2 = new Zone(new WorldPoint(3591, 3230, 0), new WorldPoint(3593, 3234, 0));
        this.barricade3 = new Zone(new WorldPoint(3591, 3211, 0), new WorldPoint(3591, 3216, 0));
        this.secondWall = new Zone(new WorldPoint(3585, 3215, 1), new WorldPoint(3592, 3257, 1));
        this.secondWall2 = new Zone(new WorldPoint(3593, 3229, 1), new WorldPoint(3613, 3243, 1));
        this.thirdWall = new Zone(new WorldPoint(3587, 3252, 2), new WorldPoint(3588, 3259, 2));
        this.fourthWall = new Zone(new WorldPoint(3587, 3252, 1), new WorldPoint(3588, 3289, 1));
        this.fourthWall2 = new Zone(new WorldPoint(3589, 3258, 1), new WorldPoint(3604, 3310, 1));
        this.drakanWalls = new Zone(new WorldPoint(3583, 3311, 0), new WorldPoint(3605, 3400, 0));
        this.drakanWalls2 = new Zone(new WorldPoint(3520, 3331, 0), new WorldPoint(3582, 3387, 0));
        this.lab = new Zone(new WorldPoint(3623, 9681, 0), new WorldPoint(3639, 9702, 0));
    }

    public void setupConditions() {
        this.inNewBase = new ZoneRequirement(this.newBase);
        this.inTemple = new ZoneRequirement(this.temple);
        this.onEntryWall = new ZoneRequirement(this.entryWall, this.entryWall2);
        this.inMeiyditch = new ZoneRequirement(this.meiyerditch, this.drakanWalls, this.drakanWalls2);
        this.inMyrequeBase = new ZoneRequirement(this.myrequeBase);
        this.inMine = new ZoneRequirement(this.mine);
        this.inNorthMeiy = new ZoneRequirement(this.northMeiy);
        this.inRandomRoom = new ZoneRequirement(this.randomRoom);
        this.atBarricade = new ZoneRequirement(this.barricade1, this.barricade2, this.barricade3);
        this.onSecondWall = new ZoneRequirement(this.secondWall, this.secondWall2);
        this.onThirdWall = new ZoneRequirement(this.thirdWall);
        this.onFourthWall = new ZoneRequirement(this.fourthWall, this.fourthWall2);
        this.onDrakanWalls = new ZoneRequirement(this.drakanWalls, this.drakanWalls2);
        this.inVanstromFight = new Conditions(this.onDrakanWalls, new InInstanceRequirement());
        this.inLab = new ZoneRequirement(this.lab);
        this.pushedBoat = new VarbitRequirement(2587, 1);
        this.knockedDownBoard = new VarbitRequirement(2589, 1);
        this.pathDoorOpen = new VarbitRequirement(2578, 1);
        this.fixedLadder = new VarbitRequirement(2598, 2);
        this.wallPressed = new VarbitRequirement(2590, 1, Operation.GREATER_EQUAL);
        this.searchedRockySurface = new Conditions(true, new WidgetTextRequirement(229, 1, "a mechanical click."));
        this.hasSketches = new ItemRequirements(this.sketch1, this.sketch2, this.sketch3);
        this.cutPortrait = new VarbitRequirement(2595, 1, Operation.GREATER_EQUAL);
        this.handedInSketches = new VarbitRequirement(2575, 1);
        this.tapestryCut = new VarbitRequirement(2594, 1);
        this.keyPlaced = new VarbitRequirement(2596, 1);
        this.searchedRuneCase = new VarbitRequirement(2584, 1);
        this.hasTeleGrabRunesOrSearchedCase = new Conditions(LogicType.OR, this.searchedRuneCase, new ItemRequirements(this.lawRune, this.airRune));
    }

    public void setupSteps() {
        this.enterBurghPubBasement = new ObjectStep((QuestHelper)this, 12743, new WorldPoint(3490, 3232, 0), "", new Requirement[0]);
        this.talkToVeliaf = new NpcStep((QuestHelper)this, 9489, new WorldPoint(3494, 9628, 0), "", new Requirement[0]);
        this.talkToVeliaf.addDialogSteps("Is there something I can do to help out?", "Yes.");
        this.leavePubBasement = new ObjectStep((QuestHelper)this, 12779, new WorldPoint(3490, 9632, 0), "Leave the Myreque base.", new Requirement[0]);
        this.usePlankOnBoat = new ObjectStep((QuestHelper)this, 12944, new WorldPoint(3524, 3178, 0), "Fix the boat in south Burgh de Rott.", this.hammer, this.planks2, this.nails8);
        this.usePlankOnBoat.addDialogStep("Yes.");
        this.usePlankOnChute = new ObjectStep((QuestHelper)this, 12947, new WorldPoint(3523, 3175, 0), "Fix the boat chute.", this.hammer, this.planks1, this.nails4);
        this.usePlankOnChute.addDialogStep("Yes.");
        this.pushBoat = new ObjectStep((QuestHelper)this, 12944, new WorldPoint(3524, 3178, 0), "Push the boat.", new Requirement[0]);
        this.boardBoat = new ObjectStep((QuestHelper)this, 12945, new WorldPoint(3523, 3170, 0), "Board the boat.", new Requirement[0]);
        this.kickBoard = new ObjectStep((QuestHelper)this, 18122, new WorldPoint(3589, 3173, 1), "Climb up the walls and search the marked floor.", new Requirement[0]);
        this.kickBoard.addDialogStep("Yes.");
        this.climbDownBoard = new ObjectStep((QuestHelper)this, 18122, new WorldPoint(3589, 3173, 1), "Climb down the floorboard.", new Requirement[0]);
        this.talkToCitizen = new NpcStep((QuestHelper)this, 3780, new WorldPoint(3601, 3189, 0), "Talk to a Meiyerditch citizen.", true, new Requirement[0]);
        this.talkToCitizen.addDialogSteps("(whisper) Do you know about the Myreque?", "(whisper) I really need to meet the Myreque.", "How can Old Man Ral help me?");
        ((NpcStep)this.talkToCitizen).addAlternateNpcs(3781, 3782, 3783, 3784, 3785, 3786, 3787, 3788, 3789, 3790, 3791, 3792, 3793, 3794, 3795, 3796, 3797, 3798, 3799, 3800, 3801, 3802, 3803, 3804, 3805, 3806, 3807, 3808);
        this.talkToRal = new NpcStep((QuestHelper)this, 3772, new WorldPoint(3604, 3208, 0), "Talk to Old Man Ral in south western Meiyerditch.", new Requirement[0]);
        this.talkToRal.addDialogSteps("Someone said you could help me.", "Old Man Ral, the sage of Sanguinesti.");
        this.travelToPots = new ObjectStep((QuestHelper)this, 18065, new WorldPoint(3608, 3222, 0), "Follow the path to the Meiyerditch Myreque base. When you reach some pots, search them for a key to open the door.", new Requirement[0]);
        List<WorldPoint> pathToPots = Arrays.asList(new WorldPoint(3602, 3207, 0), new WorldPoint(3597, 3207, 0), new WorldPoint(3597, 3204, 0), new WorldPoint(3595, 3204, 0), new WorldPoint(3595, 3204, 1), new WorldPoint(3598, 3203, 1), new WorldPoint(3598, 3201, 1), new WorldPoint(3599, 3200, 1), new WorldPoint(3601, 3200, 1), new WorldPoint(3605, 3203, 1), new WorldPoint(3605, 3206, 1), new WorldPoint(3606, 3207, 1), new WorldPoint(3606, 3214, 1), new WorldPoint(3601, 3214, 1), new WorldPoint(3601, 3215, 1), new WorldPoint(3601, 3214, 0), new WorldPoint(3598, 3214, 0), new WorldPoint(3598, 3216, 0), new WorldPoint(3598, 3216, 3), new WorldPoint(3598, 3219, 0), new WorldPoint(3594, 3223, 0), new WorldPoint(3594, 3223, 1), new WorldPoint(3597, 3223, 1), new WorldPoint(3598, 3222, 1), new WorldPoint(3601, 3222, 1), new WorldPoint(3601, 3223, 1), new WorldPoint(3603, 3223, 1), new WorldPoint(3603, 3221, 0), new WorldPoint(3608, 3221, 0));
        this.travelToPots.setLinePoints(pathToPots);
        ArrayList<WorldPoint> pathToLadderDivision = new ArrayList<WorldPoint>();
        pathToLadderDivision.addAll(pathToPots);
        pathToLadderDivision.addAll(Arrays.asList(new WorldPoint(3612, 3221, 0), new WorldPoint(3615, 3223, 0), new WorldPoint(3615, 3220, 0), new WorldPoint(3618, 3220, 0), new WorldPoint(3618, 3219, 0), new WorldPoint(3617, 3219, 1), new WorldPoint(3615, 3218, 1), new WorldPoint(3615, 3216, 1), new WorldPoint(3618, 3215, 1), new WorldPoint(3618, 3212, 1), new WorldPoint(3615, 3210, 1), new WorldPoint(3614, 3210, 2), new WorldPoint(3610, 3210, 2), new WorldPoint(3610, 3209, 3), new WorldPoint(3610, 3208, 3), new WorldPoint(3613, 3208, 3), new WorldPoint(3613, 3203, 3), new WorldPoint(3612, 3203, 3), new WorldPoint(3611, 3203, 2), new WorldPoint(3611, 3202, 2), new WorldPoint(3625, 3202, 2), new WorldPoint(3625, 3203, 2), new WorldPoint(3625, 3204, 1), new WorldPoint(3623, 3204, 1), new WorldPoint(3623, 3217, 1), new WorldPoint(3623, 3218, 2), new WorldPoint(3625, 3221, 2), new WorldPoint(3626, 3221, 1), new WorldPoint(3626, 3223, 1), new WorldPoint(3623, 3223, 1), new WorldPoint(3623, 3226, 1), new WorldPoint(3622, 3230, 1), new WorldPoint(3622, 3235, 1), new WorldPoint(3623, 3235, 1), new WorldPoint(3623, 3238, 1), new WorldPoint(3621, 3238, 1), new WorldPoint(3621, 3240, 1), new WorldPoint(3626, 3240, 1)));
        ArrayList<WorldPoint> pathToLadderPiece = new ArrayList<WorldPoint>();
        pathToLadderPiece.addAll(pathToLadderDivision);
        pathToLadderPiece.addAll(Arrays.asList(new WorldPoint(3626, 3238, 1), new WorldPoint(3628, 3238, 1), new WorldPoint(3629, 3238, 1), new WorldPoint(3629, 3239, 1), new WorldPoint(3630, 3239, 1), new WorldPoint(3631, 3239, 2), new WorldPoint(3631, 3241, 2), new WorldPoint(3627, 3241, 2), new WorldPoint(3626, 3240, 2)));
        this.travelToLadderPart = new ObjectStep((QuestHelper)this, 18115, new WorldPoint(3625, 3240, 2), "Continue until you reach a wall with a ladder piece, and take it.", new Requirement[0]);
        this.travelToLadderPart.setLinePoints(pathToLadderPiece);
        List<WorldPoint> pathToPlaceLadder = Arrays.asList(new WorldPoint(3627, 3241, 2), new WorldPoint(3631, 3241, 2), new WorldPoint(3631, 3239, 2), new WorldPoint(3630, 3239, 2), new WorldPoint(3629, 3239, 1), new WorldPoint(3629, 3238, 1), new WorldPoint(3626, 3238, 1), new WorldPoint(3626, 3240, 1), new WorldPoint(3629, 3240, 1));
        this.travelToFixLadder = new ObjectStep((QuestHelper)this, 18116, new WorldPoint(3629, 3240, 1), "Repair the ladder downstairs.", new Requirement[0]);
        this.travelToFixLadder.setLinePoints(pathToPlaceLadder);
        ArrayList<WorldPoint> pathToBase = new ArrayList<WorldPoint>();
        pathToBase.addAll(pathToLadderDivision);
        pathToBase.addAll(Arrays.asList(new WorldPoint(3629, 3240, 1), new WorldPoint(3630, 3240, 0), new WorldPoint(3633, 3240, 0), new WorldPoint(3635, 3242, 0), new WorldPoint(3635, 3247, 0), new WorldPoint(3631, 3247, 0), new WorldPoint(3629, 3250, 0), new WorldPoint(3625, 3250, 0), new WorldPoint(3625, 3252, 0), new WorldPoint(3624, 3252, 0), new WorldPoint(3624, 3261, 0), new WorldPoint(3631, 3261, 0), new WorldPoint(3631, 3258, 0), new WorldPoint(3630, 3258, 1), new WorldPoint(3630, 3259, 1), new WorldPoint(3633, 3259, 1), new WorldPoint(3633, 3256, 1), new WorldPoint(3636, 3256, 1), new WorldPoint(3638, 3256, 1), new WorldPoint(3638, 3255, 1), new WorldPoint(3639, 3255, 1), new WorldPoint(3639, 3256, 1), new WorldPoint(3639, 3258, 0), new WorldPoint(3640, 3258, 0), new WorldPoint(3640, 3253, 0)));
        this.travelToMyrequeBase = new ObjectStep((QuestHelper)this, 17980, new WorldPoint(3640, 3253, 0), "Use a knife on the wall you eventually reach.", new Requirement[0]);
        this.travelToMyrequeBase.setLinePoints(pathToBase);
        this.travelToMyrequeBase.addIcon(946);
        this.pressDecoratedWall = new ObjectStep((QuestHelper)this, 18146, new WorldPoint(3638, 3251, 0), "Press the decorated wall.", new Requirement[0]);
        this.pressDecoratedWall.setLinePoints(pathToBase);
        this.enterRug = new ObjectStep((QuestHelper)this, 18120, new WorldPoint(3639, 3249, 0), "Open the rug and enter the trapdoor.", new Requirement[0]);
        this.talkToVertida = new NpcStep((QuestHelper)this, 8220, new WorldPoint(3627, 9644, 0), "Talk to Vertida in the north room.", new Requirement[0]);
        this.goDownToDrezel = new ObjectStep((QuestHelper)this, 3432, new WorldPoint(3422, 3485, 0), "", new Requirement[0]);
        ((ObjectStep)this.goDownToDrezel).addAlternateObjects(3433);
        this.talkToDrezel = new NpcStep((QuestHelper)this, 9636, new WorldPoint(3439, 9896, 0), "", new Requirement[0]);
        this.leaveDrezelToBushes = new ObjectStep((QuestHelper)this, 17385, new WorldPoint(3405, 9907, 0), "Go up the west ladder.", new Requirement[0]);
        this.searchBushes = new ObjectStep((QuestHelper)this, 18121, new WorldPoint(3390, 3480, 0), "Search the bushes west of Paterdomus.", new Requirement[0]);
        this.searchBushes.addSubSteps(this.leaveDrezelToBushes);
        this.returnFromBushesToDrezel = new ObjectStep((QuestHelper)this, 1579, new WorldPoint(3405, 3507, 0), "", new Requirement[0]);
        this.talkToRoald = new NpcStep((QuestHelper)this, 5215, new WorldPoint(3222, 3473, 0), "Talk to King Roald in Varrock Castle.", new Requirement[0]);
        this.talkToRoald.addDialogSteps("Talk to the king about Morytania.", "What should I do now?", "Yes thanks. I'll accept the free teleport.");
        this.goToMines = new NpcStep((QuestHelper)this, 3709, new WorldPoint(3615, 3263, 0), "Talk to a Vyrewatch to be sent to the mines.", true, new Requirement[0]);
        this.goToMines.addDialogSteps("Send me to the mines.", "Send me to the mines! (Do a bit of menial work)");
        ((NpcStep)this.goToMines).setMaxRoamRange(1000);
        ((NpcStep)this.goToMines).addAlternateNpcs(3710, 3711, 3712, 3713, 3714, 3715, 3716, 3717, 3718, 3719, 3720, 3721, 3722, 3723, 3724, 3725, 3726, 3727, 3728, 3729, 3730, 3748, 3749, 3750, 3751, 3752, 3753, 3754, 3755, 3756, 3757, 3758, 3759, 3760, 3761, 3762, 3763);
        this.mineDaeyaltThenLeave = new NpcStep((QuestHelper)this, 3690, new WorldPoint(2389, 4624, 2), "Mine Daeyalt ore from the walls and put them into the mine carts. If you have no pickaxe, talk to a miner to obtain a bronze one. Once you've mined 15, talk to the vampyres to leave.", this.pickaxe);
        this.mineDaeyaltThenLeave.addDialogStep("Do you have a spare pick?");
        List<WorldPoint> pathFromMineToBase = Arrays.asList(new WorldPoint(3623, 3324, 0), new WorldPoint(3631, 3324, 0), new WorldPoint(3631, 3303, 0), new WorldPoint(3628, 3300, 0), new WorldPoint(3628, 3294, 0), new WorldPoint(3633, 3294, 0), new WorldPoint(3633, 3288, 0), new WorldPoint(3635, 3288, 0), new WorldPoint(3635, 3284, 0), new WorldPoint(3632, 3284, 0), new WorldPoint(3632, 3277, 0), new WorldPoint(3634, 3277, 0), new WorldPoint(3634, 3267, 0), new WorldPoint(3631, 3267, 0), new WorldPoint(3631, 3258, 0), new WorldPoint(3631, 3258, 1), new WorldPoint(3633, 3256, 1), new WorldPoint(3639, 3256, 1), new WorldPoint(3639, 3256, 0), new WorldPoint(3640, 3256, 0), new WorldPoint(3640, 3250, 0));
        this.returnToMeiyBase = new ObjectStep((QuestHelper)this, 18146, new WorldPoint(3638, 3251, 0), "Press the decorated wall to unlock the base's entrance.", new Requirement[0]);
        this.returnToMeiyBase.setLinePoints(pathFromMineToBase);
        this.goDownFromRandomRoom = new ObjectStep((QuestHelper)this, 17975, new WorldPoint(3595, 3204, 1), "Climb down the ladder.", new Requirement[0]);
        this.climbUpFloor = new ObjectStep((QuestHelper)this, 18124, new WorldPoint(3589, 3173, 0), "Climb up to the floor in the wall to the south west.", new Requirement[0]);
        this.climbDownWallLadder = new ObjectStep((QuestHelper)this, 17999, new WorldPoint(3588, 3210, 1), "Climb down the ladder to the north.", new Requirement[0]);
        this.searchRockySurface = new ObjectStep((QuestHelper)this, 18056, new WorldPoint(3592, 3211, 0), "Search the rocky surface nearby.", new Requirement[0]);
        this.goThroughBarricade = new ObjectStep((QuestHelper)this, 18000, new WorldPoint(3593, 3230, 0), "Go through the barricade and up the ladder to the north.", new Requirement[0]);
        this.climbLadderSecondWall = new ObjectStep((QuestHelper)this, 18002, new WorldPoint(3588, 3251, 1), "Climb up the ladder to the north.", new Requirement[0]);
        this.climbDownFromThirdWall = new ObjectStep((QuestHelper)this, 18001, new WorldPoint(3588, 3259, 2), "Climb down the ladder to the north.", new Requirement[0]);
        this.climbUpDrakanWalls = new ObjectStep((QuestHelper)this, 39173, new WorldPoint(3595, 3310, 1), "Climb up the wall to the north.", new Requirement[0]);
        this.talkToSafalaan = new NpcStep((QuestHelper)this, 3775, new WorldPoint(3585, 3331, 0), "Talk to Safalaan on the walls.", new Requirement[0]);
        this.drawNorthWall = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3556, 3379, 0), "", new Requirement[0]);
        this.drawWestWall = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3522, 3357, 0), "", new Requirement[0]);
        this.drawSouthWall = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3572, 3331, 0), "", new Requirement[0]);
        this.tankVanstrom = new NpcStep((QuestHelper)this, 3735, new WorldPoint(3572, 3331, 0), "Tank Vanstrom for 5 hits or use Protect from Melee.", new Requirement[0]);
        ((NpcStep)this.tankVanstrom).addAlternateNpcs(3734);
        this.finishSouthSketch = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3572, 3331, 0), "", new Requirement[0]);
        this.talkToSarius = new NpcStep((QuestHelper)this, 3776, new WorldPoint(3572, 3331, 0), "", new Requirement[0]);
        this.talkToSafalaanInBase = new NpcStep((QuestHelper)this, 3775, new WorldPoint(3627, 9644, 0), "Talk to Safalaan in the north room.", new Requirement[0]);
        List<WorldPoint> pathFromMineToFireplace = Arrays.asList(new WorldPoint(3623, 3324, 0), new WorldPoint(3631, 3324, 0), new WorldPoint(3631, 3303, 0), new WorldPoint(3628, 3300, 0), new WorldPoint(3628, 3294, 0), new WorldPoint(3633, 3294, 0), new WorldPoint(3633, 3288, 0), new WorldPoint(3635, 3288, 0), new WorldPoint(3635, 3284, 0), new WorldPoint(3632, 3284, 0), new WorldPoint(3632, 3277, 0), new WorldPoint(3634, 3277, 0), new WorldPoint(3634, 3267, 0), new WorldPoint(3631, 3267, 0), new WorldPoint(3631, 3261, 0), new WorldPoint(3624, 3261, 0), new WorldPoint(3624, 3252, 0), new WorldPoint(2627, 3252, 0));
        this.useKnifeOnFireplace = new ObjectStep((QuestHelper)this, 18039, new WorldPoint(3627, 3253, 0), "", new Requirement[0]);
        this.useKnifeOnFireplace.setLinePoints(pathFromMineToFireplace);
        this.useKnifeOnFireplace.addIcon(946);
        this.readMessage = new DetailedQuestStep((QuestHelper)this, "Read the message.", this.messageFromFireplace);
        this.useKnifeOnPortrait = new ObjectStep((QuestHelper)this, 18126, new WorldPoint(3627, 3248, 0), "Use a knife on the portrait south of the fireplace.", new Requirement[0]);
        this.useKnifeOnPortrait.addIcon(946);
        this.inspectPortrait = new ObjectStep((QuestHelper)this, 18126, new WorldPoint(3627, 3248, 0), "Inspect the portrait south of the fireplace.", new Requirement[0]);
        this.useKnifeOnPortrait.addSubSteps(this.inspectPortrait);
        this.leaveMeiyerBase = new ObjectStep((QuestHelper)this, 17986, new WorldPoint(3626, 9617, 0), "Go up to the surface.", new Requirement[0]);
        List<WorldPoint> pathFromBaseToTapestry = Arrays.asList(new WorldPoint(3640, 3253, 0), new WorldPoint(3640, 3258, 0), new WorldPoint(3639, 3258, 0), new WorldPoint(3639, 3255, 1), new WorldPoint(3636, 3256, 1), new WorldPoint(3632, 3256, 1), new WorldPoint(3631, 3258, 1), new WorldPoint(3631, 3259, 0), new WorldPoint(3631, 3267, 0), new WorldPoint(3634, 3267, 0), new WorldPoint(3634, 3278, 0), new WorldPoint(3632, 3278, 0), new WorldPoint(3632, 3283, 0), new WorldPoint(3635, 3283, 0), new WorldPoint(3635, 3289, 0), new WorldPoint(3633, 3289, 0), new WorldPoint(3633, 3293, 0), new WorldPoint(3635, 3293, 0), new WorldPoint(3635, 3300, 0), new WorldPoint(3640, 3300, 0), new WorldPoint(3640, 3302, 0));
        this.useKnifeOnTapestry = new ObjectStep((QuestHelper)this, 18125, new WorldPoint(3638, 3304, 0), "Slash the tapestry in the building in north east Meiyerditch.", this.knife.highlighted());
        this.useKnifeOnTapestry.setLinePoints(pathFromBaseToTapestry);
        this.useKnifeOnTapestry.addIcon(946);
        this.useKeyOnStatue = new ObjectStep((QuestHelper)this, 18127, new WorldPoint(3641, 3304, 0), "Use the ornate key on the nearby statue.", this.largeOrnateKey.highlighted());
        this.useKeyOnStatue.addIcon(9651);
        this.goDownToLab = new ObjectStep((QuestHelper)this, 18049, new WorldPoint(3643, 3305, 0), "Go down the staircase to the lab.", new Requirement[0]);
        this.getRunes = new ObjectStep((QuestHelper)this, 18052, new WorldPoint(3629, 9695, 0), "Search the broken rune case.", new Requirement[0]);
        this.telegrabBook = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3624, 9690, 0), "Telegrab the Haemalchemy book.", this.haemBook, this.lawRune, this.airRune);
        this.leaveLab = new ObjectStep((QuestHelper)this, 18050, new WorldPoint(3637, 9697, 0), "Leave the lab.", new Requirement[0]);
    }

    public void setupConditionalSteps() {
        this.startQuest = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterBurghPubBasement, "Talk to Veliaf in the Myreque base under Burgh de Rott.", new Requirement[0]);
        this.startQuest.addStep(this.inNewBase, this.talkToVeliaf);
        this.goTravelToMyrequeBase = new ConditionalStep((QuestHelper)this, (QuestStep)this.travelToPots, "Follow the path to the Meiyerditch Myreque base.", this.knife);
        this.goTravelToMyrequeBase.addStep(this.fixedLadder, this.travelToMyrequeBase);
        this.goTravelToMyrequeBase.addStep(this.ladderPiece, this.travelToFixLadder);
        this.goTravelToMyrequeBase.addStep(new Conditions(LogicType.OR, this.doorKey, this.pathDoorOpen), this.travelToLadderPart);
        this.talkToVeliafAfterContact = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterBurghPubBasement, "Bring the message to Veliaf in the Myreque base under Burgh de Rott.", this.message);
        this.talkToVeliafAfterContact.addStep(this.inNewBase, this.talkToVeliaf);
        this.talkToVeliafAfterContact.addDialogStep("What should I do now?");
        this.talkToVeliafAfterLetter = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterBurghPubBasement, "Talk to Veliaf in the Myreque base under Burgh de Rott.", new Requirement[0]);
        this.talkToVeliafAfterLetter.addStep(this.inNewBase, this.talkToVeliaf);
        this.talkToVeliafAfterContact.addSubSteps(this.talkToVeliafAfterLetter);
        this.talkToDrezelAfterVeliaf = new ConditionalStep((QuestHelper)this, (QuestStep)this.goDownToDrezel, "Talk to Drezel under the Paterdomus Temple.", new Requirement[0]);
        this.talkToDrezelAfterVeliaf.addStep(this.inTemple, this.talkToDrezel);
        this.talkToDrezelAfterBushes = new ConditionalStep((QuestHelper)this, (QuestStep)this.returnFromBushesToDrezel, "Return to Drezel.", new Requirement[0]);
        this.talkToDrezelAfterBushes.addStep(this.inTemple, this.talkToDrezel);
        this.talkToVeliafAfterDrezel = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterBurghPubBasement, "Return to Veliaf in the Myreque base under Burgh de Rott.", new Requirement[0]);
        this.talkToVeliafAfterDrezel.addStep(this.inNewBase, this.talkToVeliaf);
        ConditionalStep getToNorthMeiy = new ConditionalStep((QuestHelper)this, (QuestStep)this.boardBoat, new Requirement[0]);
        getToNorthMeiy.addStep(this.inMine, this.mineDaeyaltThenLeave);
        getToNorthMeiy.addStep(this.inMeiyditch, this.goToMines);
        this.returnToMeiyerditch = new ConditionalStep((QuestHelper)this, (QuestStep)getToNorthMeiy, "Return to the Meiyerditch Myreque base.", new Requirement[0]);
        this.returnToMeiyerditch.addStep(this.inMyrequeBase, this.talkToVertida);
        this.returnToMeiyerditch.addStep(this.wallPressed, this.enterRug);
        this.returnToMeiyerditch.addStep(this.inNorthMeiy, this.returnToMeiyBase);
        ConditionalStep navigateWalls = new ConditionalStep((QuestHelper)this, (QuestStep)this.boardBoat, new Requirement[0]);
        navigateWalls.addStep(this.onFourthWall, this.climbUpDrakanWalls);
        navigateWalls.addStep(this.onThirdWall, this.climbDownFromThirdWall);
        navigateWalls.addStep(this.onSecondWall, this.climbLadderSecondWall);
        navigateWalls.addStep(new Conditions(this.atBarricade, this.searchedRockySurface), this.goThroughBarricade);
        navigateWalls.addStep(this.atBarricade, this.searchRockySurface);
        navigateWalls.addStep(this.inRandomRoom, this.goDownFromRandomRoom);
        navigateWalls.addStep(this.onEntryWall, this.climbDownWallLadder);
        navigateWalls.addStep(this.inMeiyditch, this.climbUpFloor);
        this.goToSafalaan = new ConditionalStep((QuestHelper)this, (QuestStep)navigateWalls, "Climb along the western wall until you reach Safalaan.", new Requirement[0]);
        this.goToSafalaan.addStep(this.onDrakanWalls, this.talkToSafalaan);
        this.goToSafalaan.addDialogStep("Okay, lead the way.");
        this.goSketchNorth = new ConditionalStep((QuestHelper)this, (QuestStep)navigateWalls, "Sketch the north side of Castle Drakan by using the charcoal on some papyrus.", this.papyrus, this.charcoal);
        this.goSketchNorth.addStep(this.onDrakanWalls, this.drawNorthWall);
        this.goSketchWest = new ConditionalStep((QuestHelper)this, (QuestStep)navigateWalls, "Sketch the west side of Castle Drakan by using the charcoal on some papyrus.", this.papyrus, this.charcoal);
        this.goSketchWest.addStep(this.onDrakanWalls, this.drawWestWall);
        this.goSketchSouth = new ConditionalStep((QuestHelper)this, (QuestStep)navigateWalls, "Sketch the south side of Castle Drakan. Be prepared to tank some hits from Vanstrom Klause.", this.papyrus, this.charcoal);
        this.goSketchSouth.addStep(this.inVanstromFight, this.tankVanstrom);
        this.goSketchSouth.addStep(this.onDrakanWalls, this.drawSouthWall);
        this.goTalkToSarius = new ConditionalStep((QuestHelper)this, (QuestStep)navigateWalls, "Talk to Sarius on the walls around Castle Drakan.", new Requirement[0]);
        this.goTalkToSarius.addStep(this.onDrakanWalls, this.talkToSarius);
        this.goFinishSouthSketch = new ConditionalStep((QuestHelper)this, (QuestStep)navigateWalls, "Finish sketching the south side of Castle Drakan.", this.papyrus, this.charcoal);
        this.goFinishSouthSketch.addStep(this.onDrakanWalls, this.finishSouthSketch);
        this.goOpenFireplace = new ConditionalStep((QuestHelper)this, (QuestStep)getToNorthMeiy, "Go use a knife on the fireplace near the Meiyerditch Myreque base.", this.knife, this.sketch1, this.sketch2, this.sketch3);
        this.goOpenFireplace.addStep(this.inNorthMeiy, this.useKnifeOnFireplace);
        this.returnToSafalaanInBaseNoSketches = new ConditionalStep((QuestHelper)this, (QuestStep)getToNorthMeiy, "Return to Safalaan in the Meiyerditch Myreque base.", this.knife);
        this.returnToSafalaanInBaseNoSketches.addStep(this.inMyrequeBase, this.talkToSafalaanInBase);
        this.returnToSafalaanInBaseNoSketches.addStep(this.wallPressed, this.enterRug);
        this.returnToSafalaanInBaseNoSketches.addStep(new Conditions(this.inNorthMeiy, this.largeOrnateKey), this.returnToMeiyBase);
        this.returnToSafalaanInBaseNoSketches.addStep(new Conditions(this.inNorthMeiy, this.cutPortrait), this.inspectPortrait);
        this.returnToSafalaanInBaseNoSketches.addStep(this.inNorthMeiy, this.useKnifeOnPortrait);
        this.returnToSafalaanInBase = new ConditionalStep((QuestHelper)this, (QuestStep)this.returnToSafalaanInBaseNoSketches, this.sketch1, this.sketch2, this.sketch3);
        ConditionalStep travelToLab = new ConditionalStep((QuestHelper)this, (QuestStep)getToNorthMeiy, "Travel to the labs in Meiyerditch.", this.knife);
        this.goUnlockLab = new ConditionalStep((QuestHelper)this, (QuestStep)travelToLab, new Requirement[0]);
        this.goUnlockLab.addStep(new Conditions(this.inNorthMeiy, this.largeOrnateKey, this.tapestryCut), this.useKeyOnStatue);
        this.goUnlockLab.addStep(new Conditions(this.inNorthMeiy, this.largeOrnateKey), this.useKnifeOnTapestry);
        this.goUnlockLab.addStep(new Conditions(this.inNorthMeiy, this.cutPortrait), this.inspectPortrait);
        this.goUnlockLab.addStep(this.inNorthMeiy, this.useKnifeOnPortrait);
        this.goUnlockLab.addStep(this.inMyrequeBase, this.leaveMeiyerBase);
        this.bringSafalaanBook = new ConditionalStep((QuestHelper)this, (QuestStep)this.returnToMeiyBase, "Return to Safalaan with the Haemalchemy book.", this.haemBook);
        this.bringSafalaanBook.addStep(this.inMyrequeBase, this.talkToSafalaanInBase);
        this.bringSafalaanBook.addStep(this.inLab, this.leaveLab);
        this.bringSafalaanBook.addStep(this.wallPressed, this.enterRug);
        this.getHaemBook = new ConditionalStep((QuestHelper)this, (QuestStep)travelToLab, new Requirement[0]);
        this.getHaemBook.addStep(this.haemBook, this.bringSafalaanBook);
        this.getHaemBook.addStep(new Conditions(this.inLab, this.hasTeleGrabRunesOrSearchedCase), this.telegrabBook);
        this.getHaemBook.addStep(this.inLab, this.getRunes);
        this.getHaemBook.addStep(this.inNorthMeiy, this.goDownToLab);
        this.bringMessageToVeliafToFinish = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterBurghPubBasement, "Bring the letter to Veliaf in the Myreque base under Burgh de Rott to complete the quest.", this.sealedMessage);
        this.bringMessageToVeliafToFinish.addStep(this.inNewBase, this.talkToVeliaf);
    }

    @Override
    public List<Requirement> getGeneralRecommended() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(this.normalSpellbook);
        return req;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.IN_AID_OF_THE_MYREQUE, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.CONSTRUCTION, 5));
        req.add(new SkillRequirement(Skill.MINING, 20));
        req.add(new SkillRequirement(Skill.THIEVING, 22));
        req.add(new SkillRequirement(Skill.AGILITY, 26));
        req.add(new SkillRequirement(Skill.CRAFTING, 32));
        req.add(new SkillRequirement(Skill.MAGIC, 33));
        req.add(new SkillRequirement(Skill.STRENGTH, 40));
        return req;
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.hammer, this.planks2, this.nails8, this.knife);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.lawRune, this.airRune, this.pickaxe);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Able to survive 5 hits from Vanstrom Klause (level 169) or use Protect from Melee to negate all his damage.");
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.AGILITY, 7000), new ExperienceReward(Skill.THIEVING, 6000), new ExperienceReward(Skill.CONSTRUCTION, 2000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("2,000 Experience Tomes (Any skill over level 30).", 4447, 3));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Infiltrating Meiyerditch", Arrays.asList(this.startQuest, this.leavePubBasement, this.usePlankOnBoat, this.usePlankOnChute, this.pushBoat, this.boardBoat, this.kickBoard, this.climbDownBoard, this.talkToCitizen, this.talkToRal, this.goTravelToMyrequeBase, this.pressDecoratedWall, this.enterRug, this.talkToVertida, this.talkToVeliafAfterContact), this.hammer, this.planks2, this.nails8, this.knife));
        allSteps.add(new PanelDetails("Murder at Paterdomus", Arrays.asList(this.talkToDrezelAfterVeliaf, this.searchBushes, this.talkToDrezelAfterBushes, this.talkToRoald, this.talkToVeliafAfterDrezel), new Requirement[0]));
        allSteps.add(new PanelDetails("Mapping Castle Drakan", Arrays.asList(this.returnToMeiyerditch, this.goToSafalaan, this.goSketchNorth, this.goSketchWest, this.goSketchSouth, this.tankVanstrom, this.goTalkToSarius, this.goFinishSouthSketch, this.goOpenFireplace, this.useKnifeOnPortrait, this.readMessage, this.returnToSafalaanInBaseNoSketches), this.knife));
        allSteps.add(new PanelDetails("Investigate the lab", Arrays.asList(this.useKnifeOnTapestry, this.useKeyOnStatue, this.goDownToLab, this.telegrabBook, this.bringSafalaanBook, this.bringMessageToVeliafToFinish), this.knife));
        return allSteps;
    }
}

