/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.creatureoffenkenstrain;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.DigStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.CREATURE_OF_FENKENSTRAIN)
public class CreatureOfFenkenstrain
extends BasicQuestHelper {
    ItemRequirement armor;
    ItemRequirement hammer;
    ItemRequirement ghostSpeakAmulet;
    ItemRequirement silverBar;
    ItemRequirement bronzeWire;
    ItemRequirement needle;
    ItemRequirement thread;
    ItemRequirement spade;
    ItemRequirement coins;
    ItemRequirement telegrabOrCoins;
    ItemRequirement pickledBrain;
    ItemRequirement obsidianAmulet;
    ItemRequirement marbleAmulet;
    ItemRequirement starAmulet;
    ItemRequirement decapitatedHead;
    ItemRequirement decapitatedHeadWithBrain;
    ItemRequirement cavernKey;
    ItemRequirement torso;
    ItemRequirement legs;
    ItemRequirement arms;
    ItemRequirement shedKey;
    ItemRequirement brush;
    ItemRequirement canes;
    ItemRequirement extendedBrush3;
    ItemRequirement conductorMould;
    ItemRequirement lightningRod;
    ItemRequirement towerKey;
    ItemRequirement fenkenstrainTeleports;
    ItemRequirement teleportToFurnace;
    ItemRequirement staminaPotion;
    Zone barZone;
    Zone castleZoneFloor0;
    Zone castleZoneFloor1;
    Zone experimentCave;
    Zone graveIsland;
    Zone castleTower;
    Zone monsterTower;
    Requirement inCanifisBar;
    Requirement inCastleFloor0;
    Requirement inCastleFloor1;
    Requirement followingGardenerForHead;
    Requirement putStarOnGrave;
    Requirement inExperiementCave;
    Requirement inGraveIsland;
    Requirement inCastleTower;
    Requirement usedTowerKey;
    Requirement inMonsterTower;
    Requirement keyNearby;
    Requirement hasDecapitatedHeadWithBrain;
    Requirement hasArm;
    Requirement hasLegs;
    Requirement hasTorso;
    Requirement hasCavernKey;
    Requirement hasStarAmulet;
    Requirement hasObsidianAmulet;
    Requirement hasMarbleAmulet;
    Requirement usedShedKey;
    QuestStep getPickledBrain;
    QuestStep talkToFrenkenstrain;
    QuestStep goUpstairsForStar;
    QuestStep getBook1;
    QuestStep getBook2;
    QuestStep combineAmulet;
    QuestStep pickupKey;
    QuestStep goDownstairsForStar;
    QuestStep talkToGardenerForHead;
    QuestStep goToHeadGrave;
    QuestStep combinedHead;
    QuestStep useStarOnGrave;
    QuestStep killExperiment;
    QuestStep leaveExperimentCave;
    QuestStep getTorso;
    QuestStep getArm;
    QuestStep getLeg;
    QuestStep deliverBodyParts;
    QuestStep gatherNeedleAndThread;
    QuestStep talkToGardenerForKey;
    QuestStep searchForBrush;
    QuestStep grabCanes;
    QuestStep extendBrush;
    QuestStep goUpWestStairs;
    QuestStep searchFirePlace;
    QuestStep makeLightningRod;
    QuestStep goUpWestStairsWithRod;
    QuestStep goUpTowerLadder;
    QuestStep repairConductor;
    QuestStep goBackToFirstFloor;
    QuestStep talkToFenkenstrainAfterFixingRod;
    QuestStep goToMonsterFloor1;
    QuestStep openLockedDoor;
    QuestStep goToMonsterFloor2;
    QuestStep talkToMonster;
    QuestStep pickPocketFenkenstrain;
    QuestStep enterExperimentCave;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep grabTheBrain = new ConditionalStep((QuestHelper)this, this.getPickledBrain, new Requirement[0]);
        grabTheBrain.addStep(this.pickledBrain, this.talkToFrenkenstrain);
        steps.put(0, grabTheBrain);
        ConditionalStep gatherBodyParts = new ConditionalStep((QuestHelper)this, this.goUpstairsForStar, new Requirement[0]);
        gatherBodyParts.addStep(new Conditions(this.hasDecapitatedHeadWithBrain, this.hasArm, this.hasLegs, this.hasTorso), this.deliverBodyParts);
        gatherBodyParts.addStep(new Conditions(this.inGraveIsland, this.hasTorso, this.hasArm, this.hasDecapitatedHeadWithBrain), this.getLeg);
        gatherBodyParts.addStep(new Conditions(this.inGraveIsland, this.hasTorso, this.hasDecapitatedHeadWithBrain), this.getArm);
        gatherBodyParts.addStep(new Conditions(this.inGraveIsland, this.hasDecapitatedHeadWithBrain), this.getTorso);
        gatherBodyParts.addStep(new Conditions(this.inExperiementCave, this.hasDecapitatedHeadWithBrain, this.hasCavernKey), this.leaveExperimentCave);
        gatherBodyParts.addStep(new Conditions(this.inExperiementCave, this.hasDecapitatedHeadWithBrain, this.keyNearby), this.pickupKey);
        gatherBodyParts.addStep(new Conditions(this.inExperiementCave, this.hasDecapitatedHeadWithBrain), this.killExperiment);
        gatherBodyParts.addStep(new Conditions(this.hasDecapitatedHeadWithBrain, this.putStarOnGrave), this.enterExperimentCave);
        gatherBodyParts.addStep(new Conditions(this.hasDecapitatedHeadWithBrain, this.hasStarAmulet), this.useStarOnGrave);
        gatherBodyParts.addStep(new Conditions(this.decapitatedHead, this.pickledBrain), this.combinedHead);
        gatherBodyParts.addStep(new Conditions(this.decapitatedHead), this.getPickledBrain);
        gatherBodyParts.addStep(this.followingGardenerForHead, this.goToHeadGrave);
        gatherBodyParts.addStep(new Conditions(this.inCastleFloor1, this.hasStarAmulet), this.goDownstairsForStar);
        gatherBodyParts.addStep(new Conditions(this.hasStarAmulet), this.talkToGardenerForHead);
        gatherBodyParts.addStep(new Conditions(this.hasObsidianAmulet, this.hasMarbleAmulet), this.combineAmulet);
        gatherBodyParts.addStep(new Conditions(this.inCastleFloor1, this.hasObsidianAmulet), this.getBook2);
        gatherBodyParts.addStep(new Conditions(this.inCastleFloor1), this.getBook1);
        ConditionalStep fixLightningRod = new ConditionalStep((QuestHelper)this, this.talkToGardenerForKey, new Requirement[0]);
        fixLightningRod.addStep(new Conditions(this.inCastleTower, this.lightningRod), this.repairConductor);
        fixLightningRod.addStep(new Conditions(this.lightningRod, this.inCastleFloor1), this.goUpTowerLadder);
        fixLightningRod.addStep(new Conditions(this.lightningRod), this.goUpWestStairs);
        fixLightningRod.addStep(new Conditions(this.conductorMould), this.makeLightningRod);
        fixLightningRod.addStep(new Conditions(this.inCastleFloor1, this.extendedBrush3), this.searchFirePlace);
        fixLightningRod.addStep(new Conditions(this.extendedBrush3), this.goUpWestStairs);
        fixLightningRod.addStep(new Conditions(LogicType.AND, this.brush, this.canes), this.extendBrush);
        fixLightningRod.addStep(new Conditions(this.brush), this.grabCanes);
        fixLightningRod.addStep(new Conditions(LogicType.OR, this.usedShedKey, this.shedKey), this.searchForBrush);
        ConditionalStep talkToFenkentrain = new ConditionalStep((QuestHelper)this, this.goBackToFirstFloor, new Requirement[0]);
        talkToFenkentrain.addStep(this.inCastleFloor0, this.talkToFenkenstrainAfterFixingRod);
        ConditionalStep goToMonster = new ConditionalStep((QuestHelper)this, this.goToMonsterFloor1, new Requirement[0]);
        goToMonster.addStep(this.inMonsterTower, this.talkToMonster);
        goToMonster.addStep(new Conditions(this.usedTowerKey, this.inCastleFloor1), this.goToMonsterFloor2);
        goToMonster.addStep(new Conditions(this.towerKey, this.inCastleFloor1), this.openLockedDoor);
        steps.put(1, gatherBodyParts);
        steps.put(2, this.gatherNeedleAndThread);
        steps.put(3, fixLightningRod);
        steps.put(4, talkToFenkentrain);
        steps.put(5, goToMonster);
        steps.put(6, this.pickPocketFenkenstrain);
        return steps;
    }

    @Override
    public void setupRequirements() {
        ItemRequirements telegrab = new ItemRequirements("Telegrab runes", new ItemRequirement("Law rune", 563), new ItemRequirement("Air rune", 556));
        ItemRequirement coins50 = new ItemRequirement("Coins", ItemCollections.COINS, 50);
        this.telegrabOrCoins = new ItemRequirements(LogicType.OR, "33 Magic and runes to cast telegrab, or 50 coins", coins50, telegrab);
        this.hammer = new ItemRequirement("Hammer", ItemCollections.HAMMER).isNotConsumed();
        this.ghostSpeakAmulet = new ItemRequirement("Ghostspeak amulet", ItemCollections.GHOSTSPEAK).isNotConsumed();
        this.silverBar = new ItemRequirement("Silver bar", 2355);
        this.bronzeWire = new ItemRequirement("Bronze wires", 1794, 3);
        this.needle = new ItemRequirement("Needle", 1733).isNotConsumed();
        this.thread = new ItemRequirement("Threads", 1734, 5);
        this.spade = new ItemRequirement("Spade", 952).isNotConsumed();
        this.coins = new ItemRequirement("Coins at least", ItemCollections.COINS, 100);
        this.pickledBrain = new ItemRequirement("Pickled Brain", 4199);
        this.obsidianAmulet = new ItemRequirement("Obsidian Amulet", 4188);
        this.marbleAmulet = new ItemRequirement("Marble Amulet", 4187);
        this.starAmulet = new ItemRequirement("Star Amulet", 4183);
        this.decapitatedHead = new ItemRequirement("Decapitated Head", 4197);
        this.decapitatedHeadWithBrain = new ItemRequirement("Decapitated Head (with brain)", 4198);
        this.armor = new ItemRequirement("Armour and weapons defeat a level 51 monster and run past level 72 monsters", -1, -1).isNotConsumed();
        this.armor.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.cavernKey = new ItemRequirement("Cavern Key", 4184);
        this.torso = new ItemRequirement("Torso", 4194);
        this.legs = new ItemRequirement("Legs", 4196);
        this.arms = new ItemRequirement("Arms", 4195);
        this.shedKey = new ItemRequirement("Shed key", 4186);
        this.brush = new ItemRequirement("Brush", 4190);
        this.brush.addAlternates(4191, 4192);
        this.canes = new ItemRequirement("Garden Cane", 4189);
        this.extendedBrush3 = new ItemRequirement("Extended Brush", 4193);
        this.conductorMould = new ItemRequirement("Conductor Mold", 4200);
        this.lightningRod = new ItemRequirement("Lightning Rod", 4201);
        this.towerKey = new ItemRequirement("Tower Key", 4185);
        this.fenkenstrainTeleports = new ItemRequirement("Fenkenstrain's Castle Teleport", 19621, 2);
        this.teleportToFurnace = new ItemRequirement("Teleport to any furnace such as glory for Edgeville teleport, Ectophial to Port Phasmatys or a Falador teleport", ItemCollections.AMULET_OF_GLORIES);
        this.teleportToFurnace.addAlternates(4251, 8009);
        this.staminaPotion = new ItemRequirement("Stamina potions", ItemCollections.STAMINA_POTIONS, -1);
    }

    public void setupZones() {
        this.barZone = new Zone(new WorldPoint(3488, 3477, 0), new WorldPoint(3504, 3471, 0));
        this.castleZoneFloor0 = new Zone(new WorldPoint(3526, 3574, 0), new WorldPoint(3566, 3531, 0));
        this.castleZoneFloor1 = new Zone(new WorldPoint(3526, 3574, 1), new WorldPoint(3566, 3531, 1));
        this.experimentCave = new Zone(new WorldPoint(3466, 9921, 0), new WorldPoint(3582, 9982, 0));
        this.graveIsland = new Zone(new WorldPoint(3484, 3585, 0), new WorldPoint(3517, 3561, 0));
        this.castleTower = new Zone(new WorldPoint(3544, 3543, 2), new WorldPoint(3552, 3536, 2));
        this.monsterTower = new Zone(new WorldPoint(3544, 3558, 2), new WorldPoint(3553, 3551, 2));
    }

    public void setupConditions() {
        this.inCanifisBar = new ZoneRequirement(this.barZone);
        this.inCastleFloor0 = new ZoneRequirement(this.castleZoneFloor0);
        this.inCastleFloor1 = new ZoneRequirement(this.castleZoneFloor1);
        this.putStarOnGrave = new VarbitRequirement(192, 1);
        this.hasMarbleAmulet = new Conditions(LogicType.OR, this.marbleAmulet, this.putStarOnGrave);
        this.hasObsidianAmulet = new Conditions(LogicType.OR, this.obsidianAmulet, this.putStarOnGrave);
        this.hasStarAmulet = new Conditions(LogicType.OR, this.starAmulet, this.putStarOnGrave);
        this.followingGardenerForHead = new VarbitRequirement(185, 1);
        this.hasDecapitatedHeadWithBrain = new Conditions(LogicType.OR, this.decapitatedHeadWithBrain, new VarbitRequirement(189, 1));
        this.inExperiementCave = new ZoneRequirement(this.experimentCave);
        this.inGraveIsland = new ZoneRequirement(this.graveIsland);
        this.hasCavernKey = new Conditions(LogicType.OR, this.cavernKey, new VarbitRequirement(199, 1));
        this.keyNearby = new ItemOnTileRequirement(this.cavernKey);
        this.hasTorso = new Conditions(LogicType.OR, this.torso, new VarbitRequirement(188, 1));
        this.hasLegs = new Conditions(LogicType.OR, this.legs, new VarbitRequirement(187, 1));
        this.hasArm = new Conditions(LogicType.OR, this.arms, new VarbitRequirement(186, 1));
        this.usedShedKey = new VarbitRequirement(200, 1);
        this.inCastleTower = new ZoneRequirement(this.castleTower);
        this.usedTowerKey = new VarbitRequirement(198, 1);
        this.inMonsterTower = new ZoneRequirement(this.monsterTower);
    }

    public void setupSteps() {
        this.getPickledBrain = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3492, 3474, 0), "Head to the Canifis bar and either buy the pickled brain for 50 coins, or telegrab it.", this.telegrabOrCoins);
        this.getPickledBrain.addDialogStep("I'll buy one.");
        this.talkToFrenkenstrain = new NpcStep((QuestHelper)this, 1269, new WorldPoint(3551, 3548, 0), "Talk to Dr.Fenkenstrain to start the quest", new Requirement[0]);
        this.talkToFrenkenstrain.addDialogStep("Yes.");
        this.talkToFrenkenstrain.addDialogStep("Braindead");
        this.talkToFrenkenstrain.addDialogStep("Grave-digging");
        this.goUpstairsForStar = new ObjectStep((QuestHelper)this, 5206, new WorldPoint(3560, 3552, 0), "Go up the staircase to grab the items you will need.", new Requirement[0]);
        this.getBook1 = new ObjectStep((QuestHelper)this, 5166, new WorldPoint(3555, 3558, 1), "Search the nearby bookcase for Handy Maggot Avoidance Techniques.", new Requirement[0]);
        this.getBook1.addDialogSteps("Handy Maggot Avoidance Techniques");
        this.getBook2 = new ObjectStep((QuestHelper)this, 5166, new WorldPoint(3542, 3558, 1), "Search the west bookcase for The Joy of Grave Digging.", new Requirement[0]);
        this.getBook2.addDialogSteps("The Joy of Gravedigging");
        this.combineAmulet = new ItemStep((QuestHelper)this, "Combine the two amulet by using one on the other.", this.marbleAmulet.highlighted(), this.obsidianAmulet.highlighted());
        this.goDownstairsForStar = new ObjectStep((QuestHelper)this, 5207, new WorldPoint(3573, 3553, 1), "Go back to the ground floor", new Requirement[0]);
        this.talkToGardenerForHead = new NpcStep((QuestHelper)this, 1272, new WorldPoint(3548, 3562, 0), "Talk to the Gardener Ghost.", this.ghostSpeakAmulet.equipped());
        this.talkToGardenerForHead.addDialogStep("What happened to your head?");
        this.goToHeadGrave = new DigStep((QuestHelper)this, new WorldPoint(3608, 3490, 0), "Go to the grave of the gardener and dig for his head.", new Requirement[0]);
        this.combinedHead = new ItemStep((QuestHelper)this, "Use the decapitated head on the pickled brain to create a decapitated head.", this.decapitatedHead.highlighted(), this.pickledBrain.highlighted());
        this.useStarOnGrave = new ObjectStep((QuestHelper)this, 5167, new WorldPoint(3578, 3528, 0), "Use the Star Amulet on the memorial and push it to go in the caves.", this.starAmulet.highlighted());
        this.useStarOnGrave.addIcon(4183);
        this.enterExperimentCave = new ObjectStep((QuestHelper)this, 5167, new WorldPoint(3578, 3528, 0), "Push the memorial south east of the castle.", new Requirement[0]);
        this.killExperiment = new NpcStep((QuestHelper)this, 1273, new WorldPoint(3557, 9946, 0), "Kill the level 51 Experiment north-west of the ladder to get a key.", true, new Requirement[0]);
        this.pickupKey = new ItemStep((QuestHelper)this, "Pick up the key.", this.cavernKey);
        this.killExperiment.addSubSteps(this.pickupKey);
        this.leaveExperimentCave = new ObjectStep((QuestHelper)this, 17387, new WorldPoint(3504, 9970, 0), "Leave the caves by going north-west, be sure to pick up the key from the level 51 experiment.", new Requirement[0]);
        this.getTorso = new DigStep((QuestHelper)this, new WorldPoint(3503, 3576, 0), "Use your spade on this tile to get torsos.", new Requirement[0]);
        this.getArm = new DigStep((QuestHelper)this, new WorldPoint(3504, 3576, 0), "Use your spade on this tile to get arms.", new Requirement[0]);
        this.getLeg = new DigStep((QuestHelper)this, new WorldPoint(3505, 3576, 0), "Use your spade on this tile to get legs.", new Requirement[0]);
        this.deliverBodyParts = new NpcStep((QuestHelper)this, 1269, new WorldPoint(3551, 3548, 0), "Deliver the body parts to Dr.Fenkenstrain, use a teleport to Fenkenstrain's castle or run back through the caves.", new Requirement[0]);
        this.deliverBodyParts.addDialogStep("I have some body parts for you.");
        this.gatherNeedleAndThread = new NpcStep((QuestHelper)this, 1269, new WorldPoint(3551, 3548, 0), "Get a needle and 5 threads and deliver them to Dr.Fenkenstrain.", this.needle, this.thread);
        this.talkToGardenerForKey = new NpcStep((QuestHelper)this, 1272, new WorldPoint(3548, 3562, 0), "Talk to the Gardener Ghost and ask for the shed key.", this.ghostSpeakAmulet.equipped(), this.bronzeWire, this.silverBar);
        this.talkToGardenerForKey.addDialogStep("Do you know where the key to the shed is?");
        this.searchForBrush = new ObjectStep((QuestHelper)this, 5156, new WorldPoint(3546, 3564, 0), "Open the cupboard and search it for a brush.", this.bronzeWire, this.silverBar);
        ((ObjectStep)this.searchForBrush).addAlternateObjects(5157);
        this.grabCanes = new ObjectStep((QuestHelper)this, 5158, new WorldPoint(3551, 3564, 0), "Grab 3 canes from the pile.", this.bronzeWire, this.silverBar);
        this.extendBrush = new DetailedQuestStep((QuestHelper)this, "Use 3 canes on the brush one at a time.", this.canes.highlighted(), this.brush.highlighted(), this.bronzeWire, this.silverBar);
        this.goUpWestStairs = new ObjectStep((QuestHelper)this, 5206, new WorldPoint(3538, 3552, 0), "Go up to the second floor of the castle.", new Requirement[0]);
        this.searchFirePlace = new ObjectStep((QuestHelper)this, 5165, new WorldPoint(3544, 3555, 1), "Use the extended brush on the fireplace to get the conductor mould.", this.extendedBrush3.highlighted());
        this.searchFirePlace.addIcon(4193);
        this.makeLightningRod = new DetailedQuestStep((QuestHelper)this, "Go to any furnace make a lightning rod.", this.silverBar, this.conductorMould);
        this.goUpWestStairsWithRod = new ObjectStep((QuestHelper)this, 5206, new WorldPoint(3537, 3553, 0), "Return to the castle and go upstairs.", new Requirement[0]);
        this.goUpTowerLadder = new ObjectStep((QuestHelper)this, 16683, new WorldPoint(3548, 3539, 1), "Go up to the third floor using the ladder in the middle of the castle.", new Requirement[0]);
        this.repairConductor = new ObjectStep((QuestHelper)this, 5176, new WorldPoint(3549, 3537, 2), "Repair the lightning Conductor.", new Requirement[0]);
        this.goBackToFirstFloor = new DetailedQuestStep((QuestHelper)this, "Go back to the first floor of the castle and talk to Dr.Fenkenstrain.", new Requirement[0]);
        this.talkToFenkenstrainAfterFixingRod = new NpcStep((QuestHelper)this, 1269, new WorldPoint(3551, 3548, 0), "Go back to the first floor of the castle and talk to Dr.Fenkenstrain.", new Requirement[0]);
        this.goToMonsterFloor1 = new ObjectStep((QuestHelper)this, 5206, new WorldPoint(3538, 3552, 0), "Go up to the second floor to confront Fenkenstrain's monster.", new Requirement[0]);
        this.openLockedDoor = new ObjectStep((QuestHelper)this, 5172, new WorldPoint(3548, 3551, 1), "Use the Tower Key on the door.", new Requirement[0]);
        this.goToMonsterFloor2 = new ObjectStep((QuestHelper)this, 16683, new WorldPoint(3548, 3554, 1), "Go up the ladder", new Requirement[0]);
        this.talkToMonster = new NpcStep((QuestHelper)this, 1270, new WorldPoint(3548, 3555, 2), "Talk to Fenkenstrain's monster.", new Requirement[0]);
        this.pickPocketFenkenstrain = new NpcStep((QuestHelper)this, 1269, new WorldPoint(3551, 3548, 0), "Go back to Dr.Fenkenstrain, instead of talking to him right click and pickpocket him.", new Requirement[0]);
    }

    public ArrayList<ItemRequirement> getItemRequirements() {
        return new ArrayList<ItemRequirement>(Arrays.asList(this.hammer, this.ghostSpeakAmulet, this.silverBar, this.bronzeWire, this.needle, this.thread, this.spade, this.coins, this.telegrabOrCoins, this.armor));
    }

    public ArrayList<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.fenkenstrainTeleports);
        reqs.add(this.teleportToFurnace);
        reqs.add(this.staminaPotion);
        return reqs;
    }

    public ArrayList<String> getCombatRequirements() {
        return new ArrayList<String>(Collections.singletonList("Able to defeat an experiment (level 51)"));
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.PRIEST_IN_PERIL, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.THE_RESTLESS_GHOST, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.CRAFTING, 20, true));
        req.add(new SkillRequirement(Skill.THIEVING, 25, true));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.THIEVING, 1000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Ring of Charos", 4202, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Access to the Werewolf Agility Course"));
    }

    public ArrayList<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.getPickledBrain, this.talkToFrenkenstrain), this.telegrabOrCoins));
        allSteps.add(new PanelDetails("Graverobbing", Arrays.asList(this.goUpstairsForStar, this.getBook1, this.getBook2, this.combineAmulet, this.goDownstairsForStar, this.talkToGardenerForHead, this.goToHeadGrave, this.combinedHead, this.useStarOnGrave, this.enterExperimentCave, this.killExperiment, this.leaveExperimentCave, this.getTorso, this.getArm, this.getLeg, this.deliverBodyParts), this.ghostSpeakAmulet, this.spade, this.armor, this.needle, this.thread));
        allSteps.add(new PanelDetails("Getting tools", Collections.singletonList(this.gatherNeedleAndThread), this.ghostSpeakAmulet, this.needle, this.thread));
        allSteps.add(new PanelDetails("Attracting lightning", Arrays.asList(this.talkToGardenerForKey, this.searchForBrush, this.grabCanes, this.extendBrush, this.goUpWestStairs, this.searchFirePlace, this.makeLightningRod, this.goUpWestStairsWithRod, this.goUpTowerLadder, this.repairConductor, this.goBackToFirstFloor, this.talkToFenkenstrainAfterFixingRod), this.ghostSpeakAmulet, this.bronzeWire, this.silverBar, this.hammer));
        allSteps.add(new PanelDetails("Facing the monster", Arrays.asList(this.goToMonsterFloor1, this.openLockedDoor, this.goToMonsterFloor2, this.talkToMonster), new Requirement[0]));
        allSteps.add(new PanelDetails("Finishing off", Collections.singletonList(this.pickPocketFenkenstrain), new Requirement[0]));
        return allSteps;
    }
}

