/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.cooksassistant;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.COOKS_ASSISTANT)
public class CooksAssistant
extends BasicQuestHelper {
    ItemRequirement egg;
    ItemRequirement milk;
    ItemRequirement flour;
    ItemRequirement bucket;
    ItemRequirement pot;
    ItemRequirement coins;
    ItemRequirement grain;
    Requirement controlsUsed;
    QuestStep getEgg;
    QuestStep getWheat;
    QuestStep milkCow;
    QuestStep climbLadderOne;
    QuestStep climbLadderTwoUp;
    QuestStep climbLadderTwoDown;
    QuestStep climbLadderThree;
    QuestStep fillHopper;
    QuestStep operateControls;
    QuestStep collectFlour;
    QuestStep finishQuest;
    NpcStep getPot;
    NpcStep getBucket;
    Zone millSecond;
    Zone millThird;
    Requirement inMillSecond;
    Requirement inMillThird;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupConditions();
        this.setupRequirements();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep doQuest = new ConditionalStep((QuestHelper)this, (QuestStep)this.getBucket, new Requirement[0]);
        doQuest.addStep(new Conditions(this.milk, this.flour, this.egg), this.finishQuest);
        doQuest.addStep(new Conditions(this.milk, this.pot, this.egg, this.controlsUsed, this.inMillThird), this.climbLadderThree);
        doQuest.addStep(new Conditions(this.milk, this.pot, this.egg, this.controlsUsed, this.inMillSecond), this.climbLadderTwoDown);
        doQuest.addStep(new Conditions(this.milk, this.pot, this.egg, this.controlsUsed), this.collectFlour);
        doQuest.addStep(new Conditions(this.milk, this.pot, this.egg, this.grain, this.inMillThird), this.fillHopper);
        doQuest.addStep(new Conditions(this.milk, this.pot, this.egg, this.inMillThird), this.operateControls);
        doQuest.addStep(new Conditions(this.milk, this.pot, this.egg, this.grain, this.inMillSecond), this.climbLadderTwoUp);
        doQuest.addStep(new Conditions(this.milk, this.pot, this.egg, this.grain), this.climbLadderOne);
        doQuest.addStep(new Conditions(this.milk, this.pot, this.egg), this.getWheat);
        doQuest.addStep(new Conditions(this.milk, this.pot), this.getEgg);
        doQuest.addStep(new Conditions(this.bucket, this.pot), this.milkCow);
        doQuest.addStep(this.bucket, this.getPot);
        steps.put(0, doQuest);
        steps.put(1, doQuest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.egg = new ItemRequirement("Egg", 1944);
        this.egg.canBeObtainedDuringQuest();
        this.milk = new ItemRequirement("Bucket of milk", 1927);
        this.milk.canBeObtainedDuringQuest();
        this.flour = new ItemRequirement("Pot of flour", 1933);
        this.flour.canBeObtainedDuringQuest();
        this.bucket = new ItemRequirement("Bucket", 1925);
        this.pot = new ItemRequirement("Pot", 1931);
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS);
        this.coins.setTooltip("Necessary if you do not have a pot / bucket");
        this.grain = new ItemRequirement("Grain", 1947);
        this.controlsUsed = new VarbitRequirement(4920, 1);
    }

    public void loadZones() {
        this.millSecond = new Zone(new WorldPoint(3162, 3311, 1), new WorldPoint(3171, 3302, 1));
        this.millThird = new Zone(new WorldPoint(3162, 3311, 2), new WorldPoint(3171, 3302, 2));
    }

    public void setupConditions() {
        this.inMillSecond = new ZoneRequirement(this.millSecond);
        this.inMillThird = new ZoneRequirement(this.millThird);
    }

    public void setupSteps() {
        this.getEgg = new ItemStep((QuestHelper)this, new WorldPoint(3177, 3296, 0), "Grab an egg from the farm north of Lumbridge.", this.egg);
        this.getBucket = new NpcStep((QuestHelper)this, 2813, new WorldPoint(3212, 3246, 0), "Purchase a bucket from the Lumbridge General Store.", this.coins.quantity(3));
        this.getBucket.addWidgetHighlightWithItemIdRequirement(300, 16, 1925, true);
        this.getBucket.addAlternateNpcs(2814);
        this.getPot = new NpcStep((QuestHelper)this, 2813, new WorldPoint(3212, 3246, 0), "Purchase a pot from the Lumbridge General Store.", this.coins.quantity(3));
        this.getPot.addAlternateNpcs(2814);
        this.milkCow = new ObjectStep((QuestHelper)this, 8689, new WorldPoint(3254, 3272, 0), "Milk the cow north-east of Lumbridge.", this.bucket);
        this.getWheat = new ObjectStep((QuestHelper)this, 15507, new WorldPoint(3161, 3292, 0), "Pick some wheat north of Lumbridge.", new Requirement[0]);
        this.climbLadderOne = new ObjectStep((QuestHelper)this, 12964, new WorldPoint(3164, 3307, 0), "Climb up the ladder in the Mill north of Lumbridge to the top floor.", this.pot, this.grain);
        this.climbLadderTwoUp = new ObjectStep((QuestHelper)this, 12965, new WorldPoint(3164, 3307, 1), "Climb up the ladder in the Mill north of Lumbridge to the top floor.", this.pot, this.grain);
        this.climbLadderTwoUp.addDialogStep("Climb Up.");
        this.climbLadderOne.addSubSteps(this.climbLadderTwoUp);
        this.fillHopper = new ObjectStep((QuestHelper)this, 24961, new WorldPoint(3166, 3307, 2), "Fill the hopper with your grain.", this.pot, this.grain.highlighted());
        this.fillHopper.addIcon(1947);
        this.operateControls = new ObjectStep((QuestHelper)this, 24964, new WorldPoint(3166, 3305, 2), "Operate the hopper controls.", this.pot);
        this.climbLadderThree = new ObjectStep((QuestHelper)this, 12966, new WorldPoint(3164, 3307, 2), "Climb down the ladder in the Mill to the ground floor.", this.pot);
        this.climbLadderTwoDown = new ObjectStep((QuestHelper)this, 12965, new WorldPoint(3164, 3307, 1), "Climb down the ladder in the Mill to the ground floor.", this.pot);
        this.climbLadderTwoDown.addDialogStep("Climb Down.");
        this.climbLadderThree.addSubSteps(this.climbLadderTwoDown);
        this.collectFlour = new ObjectStep((QuestHelper)this, 1782, new WorldPoint(3166, 3306, 0), "Collect the flour in the bin.", this.pot.highlighted());
        this.collectFlour.addIcon(1931);
        this.finishQuest = new NpcStep((QuestHelper)this, 4626, new WorldPoint(3206, 3214, 0), "Give the Cook in Lumbridge Castle's kitchen the required items to finish the quest.", this.egg, this.milk, this.flour);
        this.finishQuest.addDialogSteps("What's wrong?", "Can I help?", "Yes.");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.egg);
        reqs.add(this.flour);
        reqs.add(this.milk);
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Collections.singletonList(this.coins);
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.COOKING, 300));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Permission to use The Cook's range."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.getBucket, this.getPot), this.coins.quantity(3)));
        allSteps.add(new PanelDetails("Getting the Milk", Collections.singletonList(this.milkCow), this.bucket));
        allSteps.add(new PanelDetails("Getting the Egg", Collections.singletonList(this.getEgg), new Requirement[0]));
        allSteps.add(new PanelDetails("Getting the Flour", Arrays.asList(this.getWheat, this.climbLadderOne, this.fillHopper, this.operateControls, this.climbLadderThree, this.collectFlour), this.pot));
        allSteps.add(new PanelDetails("Finishing up", Collections.singletonList(this.finishQuest), this.egg, this.flour, this.milk));
        return allSteps;
    }
}

