/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.contact;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemOnTileRequirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.ItemStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.CONTACT)
public class Contact
extends BasicQuestHelper {
    ItemRequirement lightSource;
    ItemRequirement tinderbox;
    ItemRequirement combatGear;
    ItemRequirement parchment;
    ItemRequirement keris;
    ItemRequirement food;
    ItemRequirement prayerPotions;
    ItemRequirement coins;
    ItemRequirement glory;
    ItemRequirement antipoison;
    ItemRequirement waterskin;
    Requirement inBank;
    Requirement inDungeon;
    Requirement inChasm;
    Requirement hasReadParchment;
    Requirement kerisNearby;
    QuestStep talkToHighPriest;
    QuestStep talkToJex;
    QuestStep goDownToBank;
    QuestStep goDownToDungeon;
    QuestStep goDownToChasm;
    QuestStep searchKaleef;
    QuestStep readParchment;
    QuestStep talkToMaisa;
    QuestStep talkToOsman;
    QuestStep talkToOsmanOutsideSoph;
    QuestStep goDownToBankAgain;
    QuestStep goDownToDungeonAgain;
    QuestStep goDownToChasmAgain;
    QuestStep killGiantScarab;
    QuestStep pickUpKeris;
    QuestStep talkToOsmanChasm;
    QuestStep returnToHighPriest;
    Zone bank;
    Zone dungeon;
    Zone chasm;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToHighPriest);
        steps.put(10, this.talkToHighPriest);
        steps.put(20, this.talkToHighPriest);
        steps.put(30, this.talkToJex);
        ConditionalStep goInvestigate = new ConditionalStep((QuestHelper)this, this.goDownToBank, new Requirement[0]);
        goInvestigate.addStep(new Conditions(this.inChasm, this.hasReadParchment), this.talkToMaisa);
        goInvestigate.addStep(this.parchment, this.readParchment);
        goInvestigate.addStep(this.inChasm, this.searchKaleef);
        goInvestigate.addStep(this.inDungeon, this.goDownToChasm);
        goInvestigate.addStep(this.inBank, this.goDownToDungeon);
        steps.put(40, goInvestigate);
        steps.put(50, goInvestigate);
        steps.put(60, this.talkToOsman);
        steps.put(70, this.talkToOsmanOutsideSoph);
        ConditionalStep scarabBattle = new ConditionalStep((QuestHelper)this, this.goDownToBankAgain, new Requirement[0]);
        scarabBattle.addStep(this.inChasm, this.killGiantScarab);
        scarabBattle.addStep(this.inDungeon, this.goDownToChasmAgain);
        scarabBattle.addStep(this.inBank, this.goDownToDungeonAgain);
        steps.put(80, scarabBattle);
        steps.put(90, scarabBattle);
        steps.put(100, scarabBattle);
        ConditionalStep talkToOsmanInCrevice = new ConditionalStep((QuestHelper)this, this.goDownToBankAgain, new Requirement[0]);
        talkToOsmanInCrevice.addStep(this.kerisNearby, this.pickUpKeris);
        talkToOsmanInCrevice.addStep(this.inChasm, this.talkToOsmanChasm);
        talkToOsmanInCrevice.addStep(this.inDungeon, this.goDownToChasmAgain);
        talkToOsmanInCrevice.addStep(this.inBank, this.goDownToDungeonAgain);
        steps.put(110, talkToOsmanInCrevice);
        ConditionalStep finishOff = new ConditionalStep((QuestHelper)this, this.returnToHighPriest, new Requirement[0]);
        finishOff.addStep(this.kerisNearby, this.pickUpKeris);
        steps.put(120, finishOff);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.lightSource = new ItemRequirement("A light source", ItemCollections.LIGHT_SOURCES).isNotConsumed();
        this.tinderbox = new ItemRequirement("Tinderbox", 590).isNotConsumed();
        this.parchment = new ItemRequirement("Parchment", 10585);
        this.parchment.setHighlightInInventory(true);
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.prayerPotions = new ItemRequirement("Prayer potions", ItemCollections.PRAYER_POTIONS, -1);
        this.antipoison = new ItemRequirement("Antipoisons", ItemCollections.ANTIPOISONS);
        this.waterskin = new ItemRequirement("Waterskins for desert travel", ItemCollections.WATERSKIN);
        this.keris = new ItemRequirement("Keris", 10581);
        this.coins = new ItemRequirement("Coins for carpet rides", ItemCollections.COINS);
        this.glory = new ItemRequirement("Amulet of glory for getting to Osman", ItemCollections.AMULET_OF_GLORIES);
    }

    public void setupZones() {
        this.bank = new Zone(new WorldPoint(2772, 5129, 0), new WorldPoint(2758, 5145, 0));
        this.dungeon = new Zone(8516);
        this.chasm = new Zone(new WorldPoint(3216, 9217, 0), new WorldPoint(3265, 9277, 0));
    }

    public void setupConditions() {
        this.inBank = new ZoneRequirement(this.bank);
        this.inDungeon = new ZoneRequirement(this.dungeon);
        this.inChasm = new ZoneRequirement(this.chasm, new Zone(9027));
        this.hasReadParchment = new VarbitRequirement(3274, 50, Operation.GREATER_EQUAL);
        this.kerisNearby = new ItemOnTileRequirement(this.keris);
    }

    public void setupSteps() {
        this.talkToHighPriest = new NpcStep((QuestHelper)this, 4206, new WorldPoint(3281, 2772, 0), "Talk to the High Priest in Sophanem.", new Requirement[0]);
        this.talkToHighPriest.addDialogStep("Yes.");
        this.talkToHighPriest.addDialogStep("Sounds like a quest for me; I can't turn that down!");
        this.talkToHighPriest.addDialogStep("Is there any way into Menaphos from below?");
        this.talkToJex = new NpcStep((QuestHelper)this, 3875, new WorldPoint(3312, 2799, 0), "Talk to Jex in the building in north east Sophanem.", new Requirement[0]);
        this.goDownToBank = new ObjectStep((QuestHelper)this, 20275, new WorldPoint(3315, 2797, 0), "Go down the ladder east of Jex.", this.lightSource);
        this.goDownToDungeon = new ObjectStep((QuestHelper)this, 20340, new WorldPoint(2766, 5130, 0), "Go down the trapdoor.", this.lightSource);
        this.goDownToChasm = new ObjectStep((QuestHelper)this, 20287, new WorldPoint(2116, 4365, 2), "Be careful of traps, and follow the path to the south west ladder. Disarm traps where the path breaks, and use protection prayers against the monsters.", new Requirement[0]);
        List<WorldPoint> path = Arrays.asList(new WorldPoint(2166, 4409, 2), new WorldPoint(2166, 4401, 2), new WorldPoint(2161, 4401, 2), new WorldPoint(2161, 4408, 2), new WorldPoint(2154, 4408, 2), new WorldPoint(2154, 4410, 2), new WorldPoint(2144, 4410, 2), new WorldPoint(2144, 4404, 2), new WorldPoint(2147, 4404, 2), new WorldPoint(0, 0, 0), new WorldPoint(2150, 4404, 2), new WorldPoint(2152, 4404, 2), new WorldPoint(2152, 4400, 2), new WorldPoint(2156, 4400, 2), new WorldPoint(2156, 4396, 2), new WorldPoint(2158, 4396, 2), new WorldPoint(2159, 4395, 2), new WorldPoint(2160, 4395, 2), new WorldPoint(2161, 4396, 2), new WorldPoint(2162, 4396, 2), new WorldPoint(2163, 4395, 2), new WorldPoint(2164, 4395, 2), new WorldPoint(2165, 4396, 2), new WorldPoint(2169, 4396, 2), new WorldPoint(2169, 4390, 2), new WorldPoint(0, 0, 0), new WorldPoint(2169, 4387, 2), new WorldPoint(2169, 4382, 2), new WorldPoint(2160, 4382, 2), new WorldPoint(2160, 4388, 2), new WorldPoint(2153, 4388, 2), new WorldPoint(2153, 4391, 2), new WorldPoint(2145, 4391, 2), new WorldPoint(2145, 4387, 2), new WorldPoint(2149, 4387, 2), new WorldPoint(2149, 4374, 2), new WorldPoint(2151, 4374, 2), new WorldPoint(0, 0, 0), new WorldPoint(2154, 4374, 2), new WorldPoint(2157, 4374, 2), new WorldPoint(2157, 4369, 2), new WorldPoint(2145, 4369, 2), new WorldPoint(2145, 4365, 2), new WorldPoint(2144, 4364, 2), new WorldPoint(2144, 4361, 2), new WorldPoint(2132, 4361, 2), new WorldPoint(2132, 4363, 2), new WorldPoint(2127, 4363, 2), new WorldPoint(2127, 4362, 2), new WorldPoint(2124, 4362, 2), new WorldPoint(2124, 4364, 2), new WorldPoint(2116, 4364, 2));
        ((DetailedQuestStep)this.goDownToChasm).setLinePoints(path);
        this.searchKaleef = new ObjectStep((QuestHelper)this, 44597, new WorldPoint(2284, 4315, 0), "Follow the path along, and search Kaleef's corpse there.", new Requirement[0]);
        this.readParchment = new DetailedQuestStep((QuestHelper)this, "Read the parchment", this.parchment);
        this.talkToMaisa = new NpcStep((QuestHelper)this, 3876, new WorldPoint(2258, 4317, 0), "Talk to Maisa on the west side of the chasm.", new Requirement[0]);
        this.talkToMaisa.addDialogStep("Draynor Village.");
        this.talkToMaisa.addDialogStep("Leela.");
        this.talkToOsman = new NpcStep((QuestHelper)this, 4286, new WorldPoint(3287, 3179, 0), "Talk to Osman in Al Kharid.", new Requirement[0]);
        this.talkToOsman.addDialogStep("I want to talk to you about Sophanem.");
        this.talkToOsman.addDialogStep("It could drive a wedge between the Menaphite cities.");
        this.talkToOsmanOutsideSoph = new NpcStep((QuestHelper)this, 4286, new WorldPoint(3285, 2812, 0), "Talk to Osman north of Sophanem.", new Requirement[0]);
        this.talkToOsmanOutsideSoph.addDialogStep("I know of a secret entrance to the north.");
        this.goDownToBankAgain = new ObjectStep((QuestHelper)this, 20275, new WorldPoint(3315, 2797, 0), "Prepare to fight a level 191 Giant Scarab. Go down the ladder east of Jex.", this.lightSource, this.combatGear);
        this.goDownToDungeonAgain = new ObjectStep((QuestHelper)this, 20340, new WorldPoint(2766, 5130, 0), "Go down the trapdoor.", this.lightSource);
        this.goDownToChasmAgain = new ObjectStep((QuestHelper)this, 20287, new WorldPoint(2116, 4365, 2), "Be careful of traps, and follow the path to the south west ladder. Disarm traps where the path breaks, and use protection prayers against the monsters.", new Requirement[0]);
        ((DetailedQuestStep)this.goDownToChasmAgain).setLinePoints(path);
        this.killGiantScarab = new NpcStep((QuestHelper)this, 797, new WorldPoint(2272, 4323, 0), "Kill the Giant Scarab near the chasm. It can extinguish your light source and poison you, so be careful. Pray melee if you are meleeing it, range if you are attacking it from a distance.", new Requirement[0]);
        this.pickUpKeris = new ItemStep((QuestHelper)this, "Pick up the Keris.", this.keris);
        this.talkToOsmanChasm = new NpcStep((QuestHelper)this, 4286, new WorldPoint(2272, 4323, 0), "Talk to Osman in the chasm.", new Requirement[0]);
        this.returnToHighPriest = new NpcStep((QuestHelper)this, 4206, new WorldPoint(3281, 2772, 0), "Report back to the High Priest in Sophanem.", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.lightSource);
        reqs.add(this.tinderbox);
        reqs.add(this.combatGear);
        reqs.add(this.food);
        reqs.add(this.prayerPotions);
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.coins.quantity(1000));
        reqs.add(this.glory);
        reqs.add(this.antipoison);
        reqs.add(this.waterskin);
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("Giant Scarab (level 191)");
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.THIEVING, 7000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("7,000 Experience Lamps (Combat Skills)", 4447, 2), new ItemReward("Keris", 10581, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Access to Sophanem's Bank"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.talkToHighPriest, this.talkToJex), this.lightSource, this.tinderbox));
        allSteps.add(new PanelDetails("Explore the dungeon", Arrays.asList(this.goDownToBank, this.goDownToDungeon, this.goDownToChasm, this.searchKaleef, this.readParchment, this.talkToMaisa, this.talkToOsman), this.lightSource, this.tinderbox));
        allSteps.add(new PanelDetails("Help Osman", Arrays.asList(this.talkToOsmanOutsideSoph, this.goDownToBankAgain, this.goDownToDungeonAgain, this.goDownToChasmAgain, this.killGiantScarab, this.talkToOsmanChasm, this.returnToHighPriest), this.combatGear, this.food, this.prayerPotions, this.lightSource, this.tinderbox));
        return allSteps;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.PRINCE_ALI_RESCUE, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.ICTHLARINS_LITTLE_HELPER, QuestState.FINISHED));
        return req;
    }
}

