/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.coldwar;

import com.questhelper.collections.ItemCollections;
import com.questhelper.helpers.quests.coldwar.PenguinEmote;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.ObjectCondition;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import com.questhelper.steps.TileStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.COLD_WAR)
public class ColdWar
extends BasicQuestHelper {
    ItemRequirement oakPlanks;
    ItemRequirement oakPlankHighlight;
    ItemRequirement steelNails;
    ItemRequirement hammer;
    ItemRequirement spade;
    ItemRequirement spadeHighlight;
    ItemRequirement clockworkOrSteelBar;
    ItemRequirement clockwork;
    ItemRequirement steelBar;
    ItemRequirement plank;
    ItemRequirement silk;
    ItemRequirement rawCodOrCharos;
    ItemRequirement swampTar;
    ItemRequirement feathers;
    ItemRequirement mahoganyPlank;
    ItemRequirement leather;
    ItemRequirement cowbell;
    ItemRequirement clockworkBookHighlight;
    ItemRequirement clockworkSuit;
    ItemRequirement clockworkSuitHighlight;
    ItemRequirement missionReportHighlight;
    ItemRequirement lumbridgeMissionReport;
    ItemRequirement mahoganyPlankHighlight;
    ItemRequirement leatherHighlight;
    ItemRequirement bongos;
    ItemRequirement kgpId;
    ItemRequirement combatGear;
    ItemRequirement teleportArdougne;
    ItemRequirement teleportLumbridge2;
    ItemRequirement teleportHouse;
    Requirement isOnIceberg;
    Requirement birdHideBuilt;
    Requirement tableNearby;
    Requirement isPenguin;
    Requirement isInPenguinPen;
    Requirement isAtZoo;
    Requirement isAtLumbridgeSheepFarm;
    Requirement isInAgilityStart;
    Requirement isInAgilityWater;
    Requirement isInAgilityStones;
    Requirement isInAgilityTreadSoftly;
    Requirement isInAgilityCrossIce;
    Requirement isInAgilityDone;
    Requirement isInPingPongRoom;
    Requirement isPreWarRoom;
    Requirement isInIcelordPit;
    Requirement isInIcelordRoom;
    Requirement isEmoting;
    Requirement isInPenguinRooms;
    Requirement guardMoved;
    QuestStep talkToLarry;
    QuestStep talkToLarryAgain;
    QuestStep usePlankOnFirmSnow;
    QuestStep useSpadeOnBirdHide;
    QuestStep learnPenguinEmotes;
    QuestStep talkToLarryAfterEmotes;
    QuestStep returnToRelleka;
    QuestStep talkToLarryInRelleka;
    QuestStep enterPoh;
    QuestStep makeClockwork;
    QuestStep makePenguin;
    QuestStep bringSuitToLarry;
    QuestStep talkToLarryOnIcebergWithSuit;
    QuestStep tuxedoTime;
    QuestStep enterPenguinPen;
    QuestStep talkToZooPenguin;
    QuestStep emoteAtPenguin;
    QuestStep exitSuit;
    QuestStep talkToLarryMissionReport;
    QuestStep readMissionReport;
    QuestStep tuxedoTimeLumbridge;
    QuestStep talkToThing;
    QuestStep emoteAtPenguinInLumbridge;
    QuestStep returnToZooPenguin;
    QuestStep returnToThing;
    QuestStep fredTheFarmer;
    QuestStep stealCowbell;
    QuestStep askThingAboutOutpost;
    QuestStep tellLarryAboutOutpost;
    QuestStep kgpAgent;
    QuestStep emoteAtPenguinOutpost;
    QuestStep noodle1;
    QuestStep noodle2;
    QuestStep kgpAgent2;
    QuestStep enterAvalanche;
    QuestStep kgpAgentInAvalanche;
    QuestStep enterAgilityCourse;
    QuestStep agilityCourse;
    QuestStep agilityEnterWater;
    QuestStep agilityExitWater;
    QuestStep agilityJumpStones;
    QuestStep agilityTreadSoftly;
    QuestStep agilityCrossIce;
    QuestStep agilityDone;
    QuestStep tellLarryAboutArmy;
    QuestStep kgpBeforePingPong;
    QuestStep pingPong1;
    QuestStep removePenguinSuitForBongos;
    QuestStep makeBongos;
    QuestStep pingPong2;
    QuestStep pingPong3;
    QuestStep openControlDoor;
    QuestStep enterWarRoom;
    QuestStep exitIcelordPen;
    QuestStep killIcelords;
    QuestStep useChasm;
    QuestStep tellLarryPlans;
    QuestStep enterAvalanche2;
    QuestStep enterAvalanche3;
    Zone onIceberg;
    Zone inPenguinPen;
    Zone inPenguinPen2;
    Zone atZoo;
    Zone atLumbridgeSheepFarm;
    Zone inAgilityStart;
    Zone inAgilityWater;
    Zone inAgilityStones;
    Zone inAgilityTreadSoftly;
    Zone inAgilityCrossIce;
    Zone inAgilityDone;
    Zone inPingPongRoom;
    Zone preWarRoom;
    Zone inIcelordPit;
    Zone inIcelordRoom;
    Zone inPenguinRooms;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToLarry);
        ConditionalStep settingUpTheBirdHide = new ConditionalStep((QuestHelper)this, this.talkToLarryAgain, new Requirement[0]);
        settingUpTheBirdHide.addStep(this.birdHideBuilt, this.useSpadeOnBirdHide);
        settingUpTheBirdHide.addStep(this.isOnIceberg, this.usePlankOnFirmSnow);
        steps.put(5, settingUpTheBirdHide);
        steps.put(10, this.learnPenguinEmotes);
        ConditionalStep larryInAfterEmotes = new ConditionalStep((QuestHelper)this, this.talkToLarryInRelleka, new Requirement[0]);
        larryInAfterEmotes.addStep(this.isOnIceberg, this.talkToLarryAfterEmotes);
        steps.put(15, larryInAfterEmotes);
        ConditionalStep larryInRelleka = new ConditionalStep((QuestHelper)this, this.talkToLarryInRelleka, new Requirement[0]);
        larryInRelleka.addStep(this.isOnIceberg, this.returnToRelleka);
        steps.put(20, larryInRelleka);
        ConditionalStep clockworkPenguin = new ConditionalStep((QuestHelper)this, this.enterPoh, new Requirement[0]);
        clockworkPenguin.addStep(this.clockworkSuit, this.bringSuitToLarry);
        clockworkPenguin.addStep(new Conditions(this.tableNearby, this.clockwork), this.makePenguin);
        clockworkPenguin.addStep(new Conditions(this.tableNearby), this.makeClockwork);
        steps.put(25, clockworkPenguin);
        steps.put(30, this.talkToLarryOnIcebergWithSuit);
        ConditionalStep zooPenguinTrust = new ConditionalStep((QuestHelper)this, this.tuxedoTime, new Requirement[0]);
        zooPenguinTrust.addStep(this.isEmoting, this.emoteAtPenguin);
        zooPenguinTrust.addStep(this.isInPenguinPen, this.talkToZooPenguin);
        zooPenguinTrust.addStep(this.isPenguin, this.enterPenguinPen);
        steps.put(35, zooPenguinTrust);
        steps.put(40, this.talkToZooPenguin);
        ConditionalStep lumbridgeVisit1 = new ConditionalStep((QuestHelper)this, this.tuxedoTimeLumbridge, new Requirement[0]);
        lumbridgeVisit1.addStep(new Conditions(this.isEmoting), this.emoteAtPenguinInLumbridge);
        lumbridgeVisit1.addStep(new Conditions(this.isPenguin, this.isAtLumbridgeSheepFarm), this.talkToThing);
        lumbridgeVisit1.addStep(new Conditions(this.isPenguin, this.isAtZoo), this.exitSuit);
        steps.put(45, lumbridgeVisit1);
        steps.put(50, this.returnToZooPenguin);
        steps.put(55, this.returnToThing);
        steps.put(60, this.fredTheFarmer);
        ConditionalStep outpostInfo = new ConditionalStep((QuestHelper)this, this.stealCowbell, new Requirement[0]);
        outpostInfo.addStep(this.cowbell, this.askThingAboutOutpost);
        steps.put(65, outpostInfo);
        ConditionalStep enterTheIceberg = new ConditionalStep((QuestHelper)this, this.tellLarryAboutOutpost, new Requirement[0]);
        enterTheIceberg.addStep(this.isEmoting, this.emoteAtPenguinOutpost);
        enterTheIceberg.addStep(this.isOnIceberg, this.kgpAgent);
        steps.put(70, enterTheIceberg);
        steps.put(75, this.noodle1);
        steps.put(80, this.noodle2);
        steps.put(85, this.kgpAgent2);
        ConditionalStep debriefSteps = new ConditionalStep((QuestHelper)this, this.enterAvalanche, new Requirement[0]);
        debriefSteps.addStep(this.isInPenguinRooms, this.kgpAgentInAvalanche);
        steps.put(90, debriefSteps);
        steps.put(95, debriefSteps);
        ConditionalStep agilityCourse = new ConditionalStep((QuestHelper)this, this.enterAgilityCourse, new Requirement[0]);
        agilityCourse.addStep(this.isInAgilityStart, this.agilityEnterWater);
        agilityCourse.addStep(this.isInAgilityWater, this.agilityExitWater);
        agilityCourse.addStep(this.isInAgilityStones, this.agilityJumpStones);
        agilityCourse.addStep(this.isInAgilityTreadSoftly, this.agilityTreadSoftly);
        agilityCourse.addStep(this.isInAgilityCrossIce, this.agilityCrossIce);
        agilityCourse.addStep(this.isInAgilityDone, this.agilityDone);
        steps.put(100, agilityCourse);
        steps.put(105, this.tellLarryAboutArmy);
        ConditionalStep goTalkToPingPong = new ConditionalStep((QuestHelper)this, this.enterAvalanche2, new Requirement[0]);
        goTalkToPingPong.addStep(this.isInPenguinRooms, this.pingPong1);
        steps.put(110, goTalkToPingPong);
        ConditionalStep gatherInstruments = new ConditionalStep((QuestHelper)this, this.makeBongos, new Requirement[0]);
        gatherInstruments.addStep(new Conditions(this.bongos, this.cowbell, this.isInPenguinRooms), this.pingPong2);
        gatherInstruments.addStep(new Conditions(this.bongos, this.cowbell), this.enterAvalanche3);
        gatherInstruments.addStep(this.bongos, this.stealCowbell);
        gatherInstruments.addStep(this.isPenguin, this.removePenguinSuitForBongos);
        steps.put(115, gatherInstruments);
        ConditionalStep enterControlRoom = new ConditionalStep((QuestHelper)this, this.enterAvalanche3, new Requirement[0]);
        enterControlRoom.addStep(this.isPreWarRoom, this.enterWarRoom);
        enterControlRoom.addStep(this.guardMoved, this.openControlDoor);
        enterControlRoom.addStep(this.isInPenguinRooms, this.pingPong3);
        steps.put(120, enterControlRoom);
        steps.put(125, this.killIcelords);
        ConditionalStep escape = new ConditionalStep((QuestHelper)this, this.tellLarryPlans, new Requirement[0]);
        escape.addStep(this.isInIcelordPit, this.exitIcelordPen);
        escape.addStep(this.isInIcelordRoom, this.useChasm);
        steps.put(130, escape);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.oakPlanks = new ItemRequirement("Oak Planks (unnoted)", 8778, 10);
        this.oakPlankHighlight = new ItemRequirement("Oak Plank", 8778, 1);
        this.oakPlankHighlight.setHighlightInInventory(true);
        this.steelNails = new ItemRequirement("Steel Nails", 1539, 10);
        this.hammer = new ItemRequirement("Hammer", ItemCollections.HAMMER).isNotConsumed();
        this.spade = new ItemRequirement("Spade", 952, 1).isNotConsumed();
        this.spadeHighlight = this.spade.highlighted();
        this.clockworkOrSteelBar = new ItemRequirement("Clockwork or Steel Bar", 2353);
        this.clockworkOrSteelBar.addAlternates(8792);
        this.clockworkOrSteelBar.setDisplayMatchedItemName(true);
        this.steelBar = new ItemRequirement("Steel Bar", 8792, 1);
        this.clockwork = new ItemRequirement("Clockwork", 8792, 1);
        this.plank = new ItemRequirement("Normal Plank", 960, 1);
        this.silk = new ItemRequirement("Silk", 950, 1);
        this.rawCodOrCharos = new ItemRequirement("Raw Cod", 341).doNotAggregate();
        this.rawCodOrCharos.addAlternates(6465);
        this.rawCodOrCharos.setDisplayMatchedItemName(true);
        this.rawCodOrCharos.setTooltip("Ring of Charos (a) can also be used.");
        this.swampTar = new ItemRequirement("Swamp Tar", 1939, 1);
        this.feathers = new ItemRequirement("Feathers", 314, 5);
        this.mahoganyPlank = new ItemRequirement("Mahogany Plank", 8782, 1);
        this.leather = new ItemRequirement("Leather", 1741, 1);
        this.cowbell = new ItemRequirement("Cowbell", 10593, 1);
        this.teleportLumbridge2 = new ItemRequirement("Teleports to Lumbridge", 8008, 2);
        this.teleportHouse = new ItemRequirement("Teleport to PoH with a clockwork table", 8013, 1);
        this.teleportArdougne = new ItemRequirement("Teleport to Ardougne", 8011, 4);
        this.clockworkBookHighlight = new ItemRequirement("Clockwork book", 10594);
        this.clockworkBookHighlight.setHighlightInInventory(true);
        this.clockworkSuit = new ItemRequirement("Clockwork suit", 10595);
        this.clockworkSuitHighlight = new ItemRequirement("Clockwork suit", 10595);
        this.clockworkSuitHighlight.setHighlightInInventory(true);
        this.missionReportHighlight = new ItemRequirement("Mission report", 10597);
        this.missionReportHighlight.setHighlightInInventory(true);
        this.lumbridgeMissionReport = new ItemRequirement("Lumbridge mission report", 10598);
        this.mahoganyPlankHighlight = new ItemRequirement("Mahogany Plank", 8782);
        this.mahoganyPlankHighlight.setHighlightInInventory(true);
        this.leatherHighlight = new ItemRequirement("Leather", 1741);
        this.leatherHighlight.setHighlightInInventory(true);
        this.bongos = new ItemRequirement("Penguin bongos", 10592);
        this.kgpId = new ItemRequirement("Kgp id card", 10600);
        this.kgpId.setTooltip("You can get another from Noodle");
        this.combatGear = new ItemRequirement("Combat gear and food", -1, -1).isNotConsumed();
    }

    public void setupZones() {
        this.onIceberg = new Zone(new WorldPoint(2641, 3978, 1), new WorldPoint(2681, 4011, 1));
        this.inPenguinPen = new Zone(new WorldPoint(2592, 3267, 0), new WorldPoint(2597, 3271, 0));
        this.inPenguinPen2 = new Zone(new WorldPoint(2592, 3272, 0), new WorldPoint(2595, 3273, 0));
        this.atZoo = new Zone(new WorldPoint(2592, 3260, 0), new WorldPoint(2650, 3290, 0));
        this.atLumbridgeSheepFarm = new Zone(new WorldPoint(3170, 3253, 0), new WorldPoint(3215, 3285, 0));
        this.inAgilityStart = new Zone(new WorldPoint(2638, 4032, 1), new WorldPoint(2648, 4056, 1));
        this.inAgilityWater = new Zone(new WorldPoint(2628, 4053, 0), new WorldPoint(2635, 4065, 0));
        this.inAgilityStones = new Zone(new WorldPoint(2630, 4057, 1), new WorldPoint(2635, 4065, 1));
        this.inAgilityTreadSoftly = new Zone(new WorldPoint(2635, 4064, 1), new WorldPoint(2662, 4088, 1));
        this.inAgilityCrossIce = new Zone(new WorldPoint(2663, 4068, 1), new WorldPoint(2666, 4084, 1));
        this.inAgilityDone = new Zone(new WorldPoint(2652, 4035, 1), new WorldPoint(2666, 4042, 1));
        this.inPingPongRoom = new Zone(new WorldPoint(2664, 10394, 0), new WorldPoint(2672, 10399, 0));
        this.preWarRoom = new Zone(new WorldPoint(2641, 10410, 0), new WorldPoint(2671, 10419, 0));
        this.inIcelordPit = new Zone(new WorldPoint(2639, 10422, 0), new WorldPoint(2652, 10428, 0));
        this.inIcelordRoom = new Zone(new WorldPoint(2636, 10418, 0), new WorldPoint(2656, 10429, 0));
        this.inPenguinRooms = new Zone(new WorldPoint(2631, 10370, 0), new WorldPoint(2672, 10408, 0));
    }

    public void setupConditions() {
        this.isOnIceberg = new ZoneRequirement(this.onIceberg);
        this.birdHideBuilt = new VarbitRequirement(3294, 1);
        this.tableNearby = new Conditions(LogicType.OR, new ObjectCondition(6798), new ObjectCondition(6799));
        this.isPenguin = new VarbitRequirement(3306, 1);
        this.isInPenguinPen = new ZoneRequirement(this.inPenguinPen, this.inPenguinPen2);
        this.isEmoting = new VarbitRequirement(3308, 1);
        this.isAtZoo = new ZoneRequirement(this.atZoo);
        this.isAtLumbridgeSheepFarm = new ZoneRequirement(this.atLumbridgeSheepFarm);
        this.isInAgilityStart = new ZoneRequirement(this.inAgilityStart);
        this.isInAgilityWater = new ZoneRequirement(this.inAgilityWater);
        this.isInAgilityStones = new ZoneRequirement(this.inAgilityStones);
        this.isInAgilityTreadSoftly = new ZoneRequirement(this.inAgilityTreadSoftly);
        this.isInAgilityCrossIce = new ZoneRequirement(this.inAgilityCrossIce);
        this.isInAgilityDone = new ZoneRequirement(this.inAgilityDone);
        this.isInPingPongRoom = new ZoneRequirement(this.inPingPongRoom);
        this.isPreWarRoom = new ZoneRequirement(this.preWarRoom);
        this.isInIcelordPit = new ZoneRequirement(this.inIcelordPit);
        this.isInIcelordRoom = new ZoneRequirement(this.inIcelordRoom);
        this.isInPenguinRooms = new ZoneRequirement(this.inPenguinRooms);
        this.guardMoved = new VarbitRequirement(3299, 2, Operation.GREATER_EQUAL);
    }

    public void setupSteps() {
        this.talkToLarry = new NpcStep((QuestHelper)this, 827, new WorldPoint(2597, 3266, 0), "Talk to Larry at the Ardougne Zoo.", new Requirement[0]);
        this.talkToLarry.addDialogStep("Okay, why not!");
        this.talkToLarryAgain = new NpcStep((QuestHelper)this, 827, new WorldPoint(2597, 3266, 0), "Talk to Larry again.", this.oakPlanks, this.steelNails, this.hammer, this.spade);
        this.talkToLarryAgain.addDialogStep("Yes, I have all the materials.");
        this.talkToLarryAgain.addDialogStep("Yes");
        this.usePlankOnFirmSnow = new ObjectStep((QuestHelper)this, 21246, new WorldPoint(2666, 3991, 1), "Use an oak plank on the firm snow patch.", this.oakPlankHighlight);
        this.usePlankOnFirmSnow.addIcon(8778);
        this.useSpadeOnBirdHide = new ObjectStep((QuestHelper)this, 21246, new WorldPoint(2666, 3991, 1), "Use a spade on the bird hide to cover it in snow.", this.spadeHighlight);
        this.useSpadeOnBirdHide.addIcon(952);
        this.learnPenguinEmotes = new NpcStep((QuestHelper)this, 829, new WorldPoint(2670, 3988, 1), "Talk to Larry on the iceberg to enter the bird hide.", new Requirement[0]);
        this.talkToLarryAfterEmotes = new NpcStep((QuestHelper)this, 829, new WorldPoint(2670, 3988, 1), "Talk to Larry again.", new Requirement[0]);
        this.talkToLarryAfterEmotes.addDialogStep("That's crazy!");
        this.returnToRelleka = new ObjectStep((QuestHelper)this, 21175, "Click the boat to return to Relleka.", new Requirement[0]);
        this.talkToLarryInRelleka = new NpcStep((QuestHelper)this, 828, new WorldPoint(2707, 3732, 0), "Talk to Larry in Relleka.", new Requirement[0]);
        this.enterPoh = new DetailedQuestStep((QuestHelper)this, "Travel to your POH or another POH with a Crafting table 3 or 4.", this.clockworkOrSteelBar, this.plank, this.silk);
        this.makeClockwork = new ObjectStep((QuestHelper)this, 6798, "Craft a steel bar into a clockwork at a crafting table 3.", this.steelBar);
        this.makeClockwork.addDialogStep("Clockwork mechanism");
        ((ObjectStep)this.makeClockwork).addAlternateObjects(6799);
        this.makePenguin = new ObjectStep((QuestHelper)this, 6798, "Craft a clockwork penguin at a crafting table 3 or 4.", this.clockwork, this.plank, this.silk);
        this.makePenguin.addDialogStep("Clockwork toy");
        this.makePenguin.addDialogStep("Clockwork penguin");
        ((ObjectStep)this.makePenguin).addAlternateObjects(6799);
        this.bringSuitToLarry = new NpcStep((QuestHelper)this, 827, new WorldPoint(2597, 3266, 0), "Talk to Larry back in the Ardougne Zoo.", new Requirement[0]);
        this.bringSuitToLarry.addDialogStep("Yes, I have it.");
        this.bringSuitToLarry.addDialogStep("Yes");
        this.talkToLarryOnIcebergWithSuit = new NpcStep((QuestHelper)this, 829, new WorldPoint(2670, 3988, 1), "Talk to Larry on the iceberg.", new Requirement[0]);
        this.talkToLarryOnIcebergWithSuit.addDialogSteps("It looks like a warning message to keep us away.", "Yes");
        this.readMissionReport = new DetailedQuestStep((QuestHelper)this, "Read the mission report.", this.missionReportHighlight);
        this.tuxedoTime = new NpcStep((QuestHelper)this, 827, new WorldPoint(2597, 3266, 0), "Unequip cape and weapons and right-click Tuxedo-time Larry at the Ardougne Zoo.", new Requirement[0]);
        this.tuxedoTime.addDialogStep("Yes");
        this.enterPenguinPen = new ObjectStep((QuestHelper)this, 21243, new WorldPoint(2594, 3266, 0), "Enter the penguin pen.", new Requirement[0]);
        this.talkToZooPenguin = new NpcStep((QuestHelper)this, 845, new WorldPoint(2596, 3270, 0), "Talk to the zoo penguin.", new Requirement[0]);
        this.emoteAtPenguin = new PenguinEmote(this);
        this.exitSuit = new NpcStep((QuestHelper)this, 827, new WorldPoint(2597, 3266, 0), "Talk to Larry to exit the penguin suit.", new Requirement[0]);
        this.talkToLarryMissionReport = new NpcStep((QuestHelper)this, 827, new WorldPoint(2597, 3266, 0), "Talk to Larry about the mission report, then travel to the sheep farm in Lumbridge.", new Requirement[0]);
        this.talkToLarryMissionReport.addSubSteps(this.exitSuit);
        this.tuxedoTimeLumbridge = new NpcStep((QuestHelper)this, 827, new WorldPoint(3212, 3263, 0), "Tuxedo-time Larry in the Lumbridge sheep farm.", new Requirement[0]);
        this.talkToThing = new NpcStep((QuestHelper)this, 731, new WorldPoint(3201, 3266, 0), "Talk to the penguins disguised as a sheep in the Lumbridge sheep farm. You will need to use the same 3 emotes as the penguin from the bird hide cutscene.", new Requirement[0]);
        this.emoteAtPenguinInLumbridge = new PenguinEmote(this);
        this.returnToZooPenguin = new NpcStep((QuestHelper)this, 845, new WorldPoint(2596, 3270, 0), "Return to the Ardougne Zoo penguin with either a raw cod, or wearing the ring of charos.", this.rawCodOrCharos);
        this.returnToZooPenguin.addDialogSteps("I need that phrase!", "The penguins in Lumbridge refuse to talk to me.", "I must have left the outpost before they gave out the phrase.", "Sure!");
        this.returnToThing = new NpcStep((QuestHelper)this, 731, new WorldPoint(3201, 3266, 0), "Speak to the sheep-penguins again in the Lumbridge sheep farm.", this.clockworkSuit);
        this.fredTheFarmer = new NpcStep((QuestHelper)this, 732, new WorldPoint(3189, 3273, 0), "Talk to Fred the Farmer without the penguin suit.", new Requirement[0]);
        this.fredTheFarmer.addDialogStep("I need to talk to you about penguins.");
        this.fredTheFarmer.addDialogStep("Bully Fred");
        this.stealCowbell = new ObjectStep((QuestHelper)this, 8689, new WorldPoint(3172, 3318, 0), "Steal a cowbell from a dairy cow.", new Requirement[0]);
        this.askThingAboutOutpost = new NpcStep((QuestHelper)this, 731, new WorldPoint(3201, 3266, 0), "Speak to the sheep-penguins once again in the Lumbridge sheep farm to learn about the outpost.", this.clockworkSuit);
        this.askThingAboutOutpost.addDialogStep("The Farmer is harmless.");
        this.tellLarryAboutOutpost = new NpcStep((QuestHelper)this, 827, new WorldPoint(3212, 3263, 0), "Tell Larry about the outpost and travel back to the iceberg.", this.swampTar, this.feathers, this.lumbridgeMissionReport);
        this.tellLarryAboutOutpost.addDialogStep("Yes");
        this.kgpAgent = new NpcStep((QuestHelper)this, 841, new WorldPoint(2639, 4008, 1), "Jump in the penguin suit and talk to the KGP Agent on the north west portion of the iceberg.", new Requirement[0]);
        this.emoteAtPenguinOutpost = new PenguinEmote(this);
        this.noodle1 = new NpcStep((QuestHelper)this, 844, new WorldPoint(2644, 4008, 1), "Talk to Noodle.", new Requirement[0]);
        this.noodle2 = new NpcStep((QuestHelper)this, 844, new WorldPoint(2644, 4008, 1), "Give Noodle the swamp tar to get an ID card and a mission report.", this.swampTar, this.feathers);
        this.noodle2.addDialogStep("Yeah, I got it.");
        this.kgpAgent2 = new NpcStep((QuestHelper)this, 841, new WorldPoint(2639, 4008, 1), "Talk to the KGP Agent again.", this.kgpId);
        this.enterAvalanche = new ObjectStep((QuestHelper)this, 21158, new WorldPoint(2638, 4011, 1), "Enter the avalanche.", new Requirement[0]);
        this.enterAvalanche2 = new ObjectStep((QuestHelper)this, 21158, new WorldPoint(2638, 4011, 1), "Enter the avalanche as a penguin.", new Requirement[0]);
        this.enterAvalanche3 = new ObjectStep((QuestHelper)this, 21158, new WorldPoint(2638, 4011, 1), "Enter the avalanche as a penguin.", new Requirement[0]);
        this.kgpAgentInAvalanche = new NpcStep((QuestHelper)this, 841, new WorldPoint(2647, 10384, 0), "Talk to the KGP Agent in the first room to the west of the entrance.", new Requirement[0]);
        ((NpcStep)this.kgpAgentInAvalanche).setMaxRoamRange(12);
        this.enterAgilityCourse = new ObjectStep((QuestHelper)this, 21169, new WorldPoint(2633, 10404, 0), "Enter the door to the west of the KGP Agent to begin the agility course.", new Requirement[0]);
        this.agilityCourse = new DetailedQuestStep((QuestHelper)this, "Complete the agility course.", new Requirement[0]);
        this.agilityEnterWater = new TileStep((QuestHelper)this, new WorldPoint(2636, 4054, 1), "Walk up to the start of the agility course.", new Requirement[0]);
        this.agilityExitWater = new ObjectStep((QuestHelper)this, 21120, new WorldPoint(2630, 4057, 0), "Avoid the ice and exit the water.", new Requirement[0]);
        this.agilityJumpStones = new TileStep((QuestHelper)this, new WorldPoint(2635, 4065, 1), "Jump across the stepping stones.", new Requirement[0]);
        this.agilityTreadSoftly = new TileStep((QuestHelper)this, new WorldPoint(2663, 4082, 1), "Tread-softly across the icicles.", new Requirement[0]);
        this.agilityCrossIce = new TileStep((QuestHelper)this, new WorldPoint(2664, 4068, 1), "Cross ice to get up the hill.", new Requirement[0]);
        this.agilityDone = new NpcStep((QuestHelper)this, 847, "Talk to the Agility Instructor.", new Requirement[0]);
        this.agilityCourse.addSubSteps(this.enterAgilityCourse, this.agilityEnterWater, this.agilityExitWater, this.agilityJumpStones, this.agilityTreadSoftly, this.agilityCrossIce, this.agilityDone);
        this.tellLarryAboutArmy = new NpcStep((QuestHelper)this, 829, new WorldPoint(2670, 3988, 1), "Return to Larry to tell him about the penguin army. You can quickly return to him by removing the penguin suit.", new Requirement[0]);
        this.kgpBeforePingPong = new NpcStep((QuestHelper)this, 841, new WorldPoint(2655, 10408, 0), "Re-enter the outpost and talk to the KGP agent north of the entrance.", new Requirement[0]);
        ((NpcStep)this.kgpBeforePingPong).setMaxRoamRange(2);
        this.pingPong1 = new NpcStep((QuestHelper)this, 839, new WorldPoint(2668, 10396, 0), "Talk to Ping or Pong in the room to the east.", new Requirement[0]);
        ((NpcStep)this.pingPong1).addAlternateNpcs(840);
        this.removePenguinSuitForBongos = new DetailedQuestStep((QuestHelper)this, "Remove the penguin suit.", new Requirement[0]);
        this.makeBongos = new DetailedQuestStep((QuestHelper)this, "Use the mahogany plank on the leather to make bongos.", this.mahoganyPlankHighlight, this.leatherHighlight);
        this.makeBongos.addSubSteps(this.removePenguinSuitForBongos);
        this.pingPong2 = new NpcStep((QuestHelper)this, 839, new WorldPoint(2668, 10396, 0), "Return to Ping or Pong to give them the bongos and cowbells.", this.bongos, this.cowbell);
        ((NpcStep)this.pingPong2).addAlternateNpcs(840);
        this.pingPong2.addDialogStep("Yes.");
        this.pingPong3 = new NpcStep((QuestHelper)this, 839, new WorldPoint(2668, 10396, 0), "Return to Ping or Pong.", new Requirement[0]);
        ((NpcStep)this.pingPong3).addAlternateNpcs(840);
        this.pingPong3.addDialogStep("Yes.");
        this.pingPong2.addSubSteps(this.pingPong3);
        this.openControlDoor = new ObjectStep((QuestHelper)this, 21055, "Open the control room doors via the control panel.", new Requirement[0]);
        this.enterWarRoom = new ObjectStep((QuestHelper)this, 21160, new WorldPoint(2671, 10418, 0), "Enter the war room and walk a few steps in to be captured.", new Requirement[0]);
        this.killIcelords = new NpcStep((QuestHelper)this, 852, new WorldPoint(2647, 10425, 0), "Kill icelords until you are able to leave through the door to the west. May take up to 3 kills.", true, new Requirement[0]);
        ((NpcStep)this.killIcelords).addAlternateNpcs(853, 854, 855);
        this.exitIcelordPen = new ObjectStep((QuestHelper)this, 21167, new WorldPoint(2639, 10424, 0), "Leave through the door to the west.", new Requirement[0]);
        this.killIcelords.addSubSteps(this.killIcelords);
        this.useChasm = new ObjectStep((QuestHelper)this, 21035, new WorldPoint(2657, 10423, 0), "Use the chasm to exit the cave.", new Requirement[0]);
        this.tellLarryPlans = new NpcStep((QuestHelper)this, 829, new WorldPoint(2670, 3988, 1), "Return to Larry to finish the quest.", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.oakPlanks, this.steelNails, this.hammer, this.spade, this.clockworkOrSteelBar, this.plank, this.silk, this.rawCodOrCharos, this.swampTar, this.feathers, this.mahoganyPlank, this.leather);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.teleportArdougne);
        reqs.add(this.teleportHouse);
        reqs.add(this.teleportLumbridge2);
        reqs.add(this.combatGear);
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("1-3 Icelords (level 51)");
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.CRAFTING, 2000), new ExperienceReward(Skill.AGILITY, 5000), new ExperienceReward(Skill.CONSTRUCTION, 1500));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Ability to create Penguin Suits"), new UnlockReward("Ability to use the Penguin Agility Course"), new UnlockReward("Abillity to make Bongo Drums"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Larry's Story", Arrays.asList(this.talkToLarry, this.talkToLarryAgain), this.oakPlanks, this.steelNails, this.hammer, this.spade));
        allSteps.add(new PanelDetails("Penguin Stake-out", Arrays.asList(this.usePlankOnFirmSnow, this.useSpadeOnBirdHide, this.learnPenguinEmotes, this.talkToLarryAfterEmotes, this.returnToRelleka), this.oakPlanks, this.steelNails, this.hammer, this.spade));
        allSteps.add(new PanelDetails("A Clockwork Penguin", Arrays.asList(this.talkToLarryInRelleka, this.enterPoh, this.makeClockwork, this.makePenguin, this.bringSuitToLarry, this.talkToLarryOnIcebergWithSuit), this.plank, this.clockworkOrSteelBar, this.silk));
        allSteps.add(new PanelDetails("Ardougne Mission Report", Arrays.asList(this.tuxedoTime, this.enterPenguinPen, this.talkToZooPenguin, this.talkToLarryMissionReport), this.clockworkSuit));
        allSteps.add(new PanelDetails("Lumbridge Mission Report", Arrays.asList(this.tuxedoTimeLumbridge, this.talkToThing, this.returnToZooPenguin, this.returnToThing, this.fredTheFarmer, this.stealCowbell, this.askThingAboutOutpost), this.clockworkSuit, this.rawCodOrCharos, this.feathers, this.swampTar, this.mahoganyPlank, this.leather, this.combatGear));
        allSteps.add(new PanelDetails("Penguin Outpost", Arrays.asList(this.tellLarryAboutOutpost, this.kgpAgent, this.noodle1, this.noodle2, this.kgpAgent2, this.enterAvalanche), this.clockworkSuit, this.feathers, this.swampTar, this.mahoganyPlank, this.leather, this.combatGear));
        allSteps.add(new PanelDetails("Briefing and Agility", Arrays.asList(this.kgpAgentInAvalanche, this.agilityCourse, this.tellLarryAboutArmy), this.clockworkSuit, this.mahoganyPlank, this.leather, this.combatGear));
        allSteps.add(new PanelDetails("Musical Penguins", Arrays.asList(this.pingPong1, this.makeBongos, this.pingPong2), this.clockworkSuit, this.mahoganyPlank, this.leather, this.combatGear));
        allSteps.add(new PanelDetails("The War Room", Arrays.asList(this.openControlDoor, this.enterWarRoom, this.killIcelords, this.useChasm, this.tellLarryPlans), this.clockworkSuit, this.combatGear));
        return allSteps;
    }

    @Override
    public List<Requirement> getGeneralRecommended() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new ItemRequirement("Access to a Crafting Table 3", -1));
        return req;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new SkillRequirement(Skill.HUNTER, 10, true));
        req.add(new SkillRequirement(Skill.AGILITY, 30));
        req.add(new SkillRequirement(Skill.CRAFTING, 30));
        req.add(new SkillRequirement(Skill.CONSTRUCTION, 34));
        req.add(new SkillRequirement(Skill.THIEVING, 15));
        return req;
    }
}

