/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.clocktower;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.questinfo.QuestVarPlayer;
import com.questhelper.requirements.ChatMessageRequirement;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.ObjectCondition;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarplayerRequirement;
import com.questhelper.requirements.widget.WidgetTextRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.CLOCK_TOWER)
public class ClockTower
extends BasicQuestHelper {
    ItemRequirement bucketOfWater;
    ItemRequirement noteAboutWater;
    ItemRequirement staminaPotions;
    ItemRequirement ardougneCloak;
    ItemRequirement redCog;
    ItemRequirement blueCog;
    ItemRequirement blackCog;
    ItemRequirement whiteCog;
    ItemRequirement ratPoison;
    Zone basement;
    Zone firstFloor;
    Zone secondFloor;
    Zone groundFloor;
    Zone secretPath;
    Zone secretPath2;
    Zone secretPath3;
    Zone secretPath4;
    Zone secretPath5;
    Zone secretPath6;
    Zone cell;
    Requirement inBasement;
    Requirement inGroundFloor;
    Requirement inFirstFloor;
    Requirement inSecondFloor;
    Requirement inSecretPath;
    Requirement inCell;
    Requirement startedQuestDuringSession;
    Requirement synced;
    Requirement firstLeverDown;
    Requirement pulledFirstLeverUp;
    Requirement secondLeverUp;
    Requirement poisonedRats;
    Requirement placedRedCog;
    Requirement placedBlueCog;
    Requirement placedWhiteCog;
    Requirement placedBlackCog;
    QuestStep talkToKojo;
    QuestStep syncStep;
    QuestStep enterBasement;
    QuestStep pickUpRedCog;
    QuestStep climbToGroundFloorFromBasement;
    QuestStep redCogOnRedSpindle;
    QuestStep goToLadderCedric;
    QuestStep pushWall;
    QuestStep climbCellLadder;
    QuestStep pickUpBlueCog;
    QuestStep climbToFirstFloor;
    QuestStep blueCogOnBlueSpindle;
    QuestStep climbFromFirstFloorToGround;
    QuestStep pickupBlackCog;
    QuestStep blackCogOnBlackSpindle;
    QuestStep northWesternDoor;
    QuestStep pickUpRatPoison;
    QuestStep pullFirstLever;
    QuestStep ratPoisonFood;
    QuestStep westernGate;
    QuestStep pickUpWhiteCog;
    QuestStep climbWhiteLadder;
    QuestStep climbToSecondFloor;
    QuestStep whiteCogOnWhiteSpindle;
    QuestStep climbFromSecondFloorToFirst;
    QuestStep kojoReward;
    ConditionalStep getRedCog;
    ConditionalStep getBlueCog;
    ConditionalStep getBlackCog;
    ConditionalStep getWhiteCog;
    ConditionalStep goToBasementForRed;
    ConditionalStep goToBasementForBlue;
    ConditionalStep goToBasementForBlack;
    ConditionalStep goToBasementForWhite;
    ConditionalStep goToFirstFloorWithBlueCog;
    ConditionalStep goToGroundFloorWithRedCog;
    ConditionalStep goToBasementWithBlackCog;
    ConditionalStep goToSecondFloorWithWhiteCog;
    ConditionalStep goFinishQuest;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupZones();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep goStart = new ConditionalStep((QuestHelper)this, this.talkToKojo, new Requirement[0]);
        goStart.addStep(this.startedQuestDuringSession, this.talkToKojo);
        steps.put(0, this.talkToKojo);
        this.getRedCog = new ConditionalStep((QuestHelper)this, (QuestStep)this.goToBasementForRed, new Requirement[0]);
        this.getRedCog.addStep(this.redCog, this.goToGroundFloorWithRedCog);
        this.getRedCog.addStep(this.inBasement, this.pickUpRedCog);
        this.getBlueCog = new ConditionalStep((QuestHelper)this, (QuestStep)this.goToBasementForBlue, new Requirement[0]);
        this.getBlueCog.addStep(this.blueCog, this.goToFirstFloorWithBlueCog);
        this.getBlueCog.addStep(this.inCell, this.pickUpBlueCog);
        this.getBlueCog.addStep(this.inSecretPath, this.pushWall);
        this.getBlackCog = new ConditionalStep((QuestHelper)this, (QuestStep)this.goToBasementForBlack, new Requirement[0]);
        this.getBlackCog.addStep(this.blackCog, this.goToBasementWithBlackCog);
        this.getBlackCog.addStep(this.inBasement, this.pickupBlackCog);
        this.getWhiteCog = new ConditionalStep((QuestHelper)this, (QuestStep)this.goToBasementForWhite, new Requirement[0]);
        this.getWhiteCog.addStep(new Conditions(this.whiteCog, this.inBasement), this.climbWhiteLadder);
        this.getWhiteCog.addStep(new Conditions(this.whiteCog), this.goToSecondFloorWithWhiteCog);
        this.getWhiteCog.addStep(new Conditions(this.inBasement, this.pulledFirstLeverUp, this.poisonedRats), this.pickUpWhiteCog);
        this.getWhiteCog.addStep(new Conditions(this.inBasement, this.ratPoison, this.pulledFirstLeverUp), this.ratPoisonFood);
        this.getWhiteCog.addStep(new Conditions(this.inBasement, this.ratPoison), this.pullFirstLever);
        this.getWhiteCog.addStep(this.inBasement, this.pickUpRatPoison);
        ConditionalStep doQuest = new ConditionalStep((QuestHelper)this, this.syncStep, new Requirement[0]);
        doQuest.addStep(new Conditions(this.placedRedCog, this.placedBlueCog, this.placedBlackCog, this.placedWhiteCog, this.synced), this.goFinishQuest);
        doQuest.addStep(new Conditions(this.placedRedCog, this.placedBlueCog, this.placedBlackCog, this.synced), this.getWhiteCog);
        doQuest.addStep(new Conditions(this.placedRedCog, this.placedBlueCog, this.synced), this.getBlackCog);
        doQuest.addStep(new Conditions(this.placedRedCog, this.synced), this.getBlueCog);
        doQuest.addStep(this.synced, this.getRedCog);
        steps.put(1, doQuest);
        steps.put(2, doQuest);
        steps.put(3, doQuest);
        steps.put(4, doQuest);
        steps.put(5, this.goFinishQuest);
        steps.put(6, this.goFinishQuest);
        steps.put(7, this.goFinishQuest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.bucketOfWater = new ItemRequirement("Bucket of Water or a pair of ice gloves or smiths gloves(i)", 1929);
        this.bucketOfWater.addAlternates(1580, 27031);
        this.bucketOfWater.setTooltip("There is a bucket spawn next to the well east of the Clocktower. You can fill it on the well");
        this.noteAboutWater = new ItemRequirement("There's a bucket and a well and just next to brother cedric for the black cog", -1, -1);
        this.staminaPotions = new ItemRequirement("Stamina Potions", ItemCollections.STAMINA_POTIONS);
        this.ardougneCloak = new ItemRequirement("Ardougne Cloak to teleport to monastery", 13121);
        this.ardougneCloak.addAlternates(13122, 13123, 13124);
        this.redCog = new ItemRequirement("Red Cog", 23);
        this.blueCog = new ItemRequirement("Blue Cog", 22);
        this.whiteCog = new ItemRequirement("White Cog", 20);
        this.blackCog = new ItemRequirement("Black Cog", 21);
        this.ratPoison = new ItemRequirement("Rat Poison", 24);
    }

    public void setupZones() {
        this.groundFloor = new Zone(new WorldPoint(2563, 3239, 0), new WorldPoint(2573, 3245, 0));
        this.secondFloor = new Zone(new WorldPoint(2563, 3239, 2), new WorldPoint(2573, 3245, 2));
        this.firstFloor = new Zone(new WorldPoint(2563, 3239, 1), new WorldPoint(2573, 3245, 1));
        this.basement = new Zone(new WorldPoint(2000, 9573, 0), new WorldPoint(3000, 9700, 0));
        this.secretPath = new Zone(new WorldPoint(2614, 9625, 0), new WorldPoint(2622, 9662, 0));
        this.secretPath2 = new Zone(new WorldPoint(2611, 9647, 0), new WorldPoint(2613, 9661, 0));
        this.secretPath3 = new Zone(new WorldPoint(2596, 9600, 0), new WorldPoint(2613, 9631, 0));
        this.secretPath4 = new Zone(new WorldPoint(2580, 9600, 0), new WorldPoint(9595, 9603, 0));
        this.secretPath5 = new Zone(new WorldPoint(2580, 9600, 0), new WorldPoint(2580, 9628, 0));
        this.secretPath6 = new Zone(new WorldPoint(2576, 9629, 0), new WorldPoint(2580, 9631, 0));
        this.cell = new Zone(new WorldPoint(2571, 9630, 0), new WorldPoint(2575, 9633, 0));
    }

    public void setupConditions() {
        this.inSecondFloor = new ZoneRequirement(this.secondFloor);
        this.inFirstFloor = new ZoneRequirement(this.firstFloor);
        this.inGroundFloor = new ZoneRequirement(this.groundFloor);
        this.inBasement = new ZoneRequirement(this.basement);
        this.inCell = new ZoneRequirement(this.cell);
        this.inSecretPath = new ZoneRequirement(this.secretPath, this.secretPath2, this.secretPath3, this.secretPath4, this.secretPath5, this.secretPath6);
        this.startedQuestDuringSession = new Conditions(true, new VarplayerRequirement(QuestVarPlayer.QUEST_CLOCK_TOWER.getId(), 0));
        this.synced = new Conditions(true, LogicType.OR, new WidgetTextRequirement(119, 2, "<col=7f0000>Clock Tower</col>"), this.startedQuestDuringSession);
        this.firstLeverDown = new ObjectCondition(33, new WorldPoint(2591, 9661, 0));
        this.pulledFirstLeverUp = new ObjectCondition(35, new WorldPoint(2591, 9661, 0));
        this.secondLeverUp = new ObjectCondition(34, new WorldPoint(2593, 9661, 0));
        this.poisonedRats = new ChatMessageRequirement("The rats swarm towards the poisoned food...");
        this.placedRedCog = new Conditions(true, LogicType.OR, new WidgetTextRequirement(119, 3, true, "<str>I have successfully placed the Red Cog on its spindle"), new ChatMessageRequirement(this.inGroundFloor, "The cog fits perfectly."));
        this.placedBlueCog = new Conditions(true, LogicType.OR, new WidgetTextRequirement(119, 3, true, "<str>I have successfully placed the Blue Cog on its spindle"), new ChatMessageRequirement(this.inFirstFloor, "The cog fits perfectly."));
        this.placedBlackCog = new Conditions(true, LogicType.OR, new WidgetTextRequirement(119, 3, true, "<str>I have successfully placed the Black Cog on its spindle"), new ChatMessageRequirement(this.inBasement, "The cog fits perfectly."));
        this.placedWhiteCog = new Conditions(true, LogicType.OR, new WidgetTextRequirement(119, 3, true, "<str>I have successfully placed the White Cog on its spindle"), new ChatMessageRequirement(this.inSecondFloor, "The cog fits perfectly."));
    }

    public void setupSteps() {
        this.talkToKojo = new NpcStep((QuestHelper)this, 3606, new WorldPoint(2570, 3245, 0), "Talk to Brother Kojo at the clock tower.", new Requirement[0]);
        this.talkToKojo.addDialogStep("OK old monk, what can I do?");
        this.syncStep = new DetailedQuestStep((QuestHelper)this, "Open your Quest Journal to sync your current state.", new Requirement[0]);
        this.pickUpRedCog = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2583, 9613, 0), "Go through the south east door and pick up the red cog.", this.redCog);
        this.redCogOnRedSpindle = new ObjectStep((QuestHelper)this, 29, new WorldPoint(2568, 3243, 0), "Use the red cog on the red spindle.", this.redCog.highlighted());
        this.redCogOnRedSpindle.addIcon(23);
        this.goToLadderCedric = new ObjectStep((QuestHelper)this, 17384, new WorldPoint(2621, 3261, 0), "", new Requirement[0]);
        this.pushWall = new ObjectStep((QuestHelper)this, 1597, new WorldPoint(2575, 9631, 0), "Follow the tunnel and push the wall at the end.", new Requirement[0]);
        this.pickUpBlueCog = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2574, 9633, 0), "Pick up the blue cog.", this.blueCog);
        this.climbCellLadder = new ObjectStep((QuestHelper)this, 17385, new WorldPoint(2572, 9631, 0), "", new Requirement[0]);
        this.blueCogOnBlueSpindle = new ObjectStep((QuestHelper)this, 32, new WorldPoint(2569, 3240, 1), "Use the blue cog on the blue spindle.", this.blueCog.highlighted());
        this.blueCogOnBlueSpindle.addIcon(22);
        this.pickupBlackCog = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2613, 9639, 0), "Enter the north east door, and pick up the black cog with a bucket of water, alternatively you can equip ice gloves or smith gloves(i).", this.bucketOfWater, this.blackCog);
        this.blackCogOnBlackSpindle = new ObjectStep((QuestHelper)this, 30, new WorldPoint(2570, 9642, 0), "", this.blackCog.highlighted());
        this.blackCogOnBlackSpindle.addIcon(21);
        this.northWesternDoor = new ObjectStep((QuestHelper)this, 1535, new WorldPoint(2575, 9651, 0), "Go through the north-western door.", new Requirement[0]);
        this.pickUpRatPoison = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2564, 9662, 0), "Pick up the rat poison in the north west of the dungeon.", this.ratPoison);
        this.pullFirstLever = new ObjectStep((QuestHelper)this, 33, new WorldPoint(2591, 9661, 0), "Pull the marked lever up.", new Requirement[0]);
        this.ratPoisonFood = new ObjectStep((QuestHelper)this, 40, new WorldPoint(2587, 9654, 0), "Use the rat poison on the food trough. Wait till the rats have died.", this.ratPoison.highlighted());
        this.ratPoisonFood.addIcon(24);
        this.westernGate = new ObjectStep((QuestHelper)this, 39, new WorldPoint(2579, 9656, 0), "Go through the gate.", new Requirement[0]);
        this.pickUpWhiteCog = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2577, 9655, 0), "Pick up the white cog.", this.whiteCog);
        this.climbWhiteLadder = new ObjectStep((QuestHelper)this, 17385, new WorldPoint(2575, 9655, 0), "Head up the ladder.", new Requirement[0]);
        this.whiteCogOnWhiteSpindle = new ObjectStep((QuestHelper)this, 31, new WorldPoint(2567, 3241, 2), "", this.whiteCog.highlighted());
        this.whiteCogOnWhiteSpindle.addIcon(20);
        this.kojoReward = new NpcStep((QuestHelper)this, 3606, new WorldPoint(2570, 3245, 0), "Talk to Brother Kojo for your reward.", new Requirement[0]);
        this.enterBasement = new ObjectStep((QuestHelper)this, 17384, new WorldPoint(2566, 3242, 0), "", new Requirement[0]);
        this.climbFromFirstFloorToGround = new ObjectStep((QuestHelper)this, 16672, new WorldPoint(2573, 3241, 1), "", new Requirement[0]);
        this.climbFromFirstFloorToGround.addDialogStep("Climb down the stairs.");
        this.climbFromSecondFloorToFirst = new ObjectStep((QuestHelper)this, 16673, new WorldPoint(2572, 3241, 2), "", new Requirement[0]);
        this.climbToGroundFloorFromBasement = new ObjectStep((QuestHelper)this, 17385, new WorldPoint(2566, 9642, 0), "", new Requirement[0]);
        this.climbToFirstFloor = new ObjectStep((QuestHelper)this, 16671, new WorldPoint(2573, 3241, 0), "", new Requirement[0]);
        this.climbToSecondFloor = new ObjectStep((QuestHelper)this, 16672, new WorldPoint(2573, 3241, 1), "", new Requirement[0]);
        this.climbToSecondFloor.addDialogStep("Climb up the stairs.");
        ConditionalStep goToBasementSteps = new ConditionalStep((QuestHelper)this, this.enterBasement, new Requirement[0]);
        goToBasementSteps.addStep(this.inSecondFloor, this.climbFromSecondFloorToFirst);
        goToBasementSteps.addStep(this.inFirstFloor, this.climbFromFirstFloorToGround);
        goToBasementSteps.addStep(new Conditions(LogicType.OR, this.inSecretPath, this.inCell), this.climbCellLadder);
        ConditionalStep goToCellSteps = new ConditionalStep((QuestHelper)this, this.goToLadderCedric, new Requirement[0]);
        goToCellSteps.addStep(this.inBasement, this.climbToGroundFloorFromBasement);
        goToCellSteps.addStep(this.inSecondFloor, this.climbFromSecondFloorToFirst);
        goToCellSteps.addStep(this.inFirstFloor, this.climbFromFirstFloorToGround);
        ConditionalStep goToGroundFloor = new ConditionalStep((QuestHelper)this, (QuestStep)new DetailedQuestStep((QuestHelper)this, "", new Requirement[0]), new Requirement[0]);
        goToGroundFloor.addStep(new Conditions(LogicType.OR, this.inSecretPath, this.inCell), this.climbCellLadder);
        goToGroundFloor.addStep(this.inBasement, this.climbToGroundFloorFromBasement);
        goToGroundFloor.addStep(this.inSecondFloor, this.climbFromSecondFloorToFirst);
        goToGroundFloor.addStep(this.inFirstFloor, this.climbFromFirstFloorToGround);
        ConditionalStep goToFirstFloor = new ConditionalStep((QuestHelper)this, this.climbToFirstFloor, new Requirement[0]);
        goToFirstFloor.addStep(new Conditions(LogicType.OR, this.inSecretPath, this.inCell), this.climbCellLadder);
        goToFirstFloor.addStep(this.inBasement, this.climbToGroundFloorFromBasement);
        goToFirstFloor.addStep(this.inSecondFloor, this.climbFromSecondFloorToFirst);
        ConditionalStep goToSecondFloor = new ConditionalStep((QuestHelper)this, this.climbToFirstFloor, new Requirement[0]);
        goToSecondFloor.addStep(new Conditions(LogicType.OR, this.inSecretPath, this.inCell), this.climbCellLadder);
        goToSecondFloor.addStep(this.inBasement, this.climbToGroundFloorFromBasement);
        goToSecondFloor.addStep(this.inFirstFloor, this.climbToSecondFloor);
        this.goToBasementForRed = new ConditionalStep((QuestHelper)this, (QuestStep)goToBasementSteps, "Enter the clocktower's basement for the red cog.", new Requirement[0]);
        this.goToBasementForBlue = new ConditionalStep((QuestHelper)this, (QuestStep)goToCellSteps, "Climb down the ladder to the east of the Clocktower, next to Brother Cedric.", new Requirement[0]);
        this.goToBasementForWhite = new ConditionalStep((QuestHelper)this, (QuestStep)goToBasementSteps, "Enter the clocktower's basement for the white cog.", new Requirement[0]);
        this.goToBasementForBlack = new ConditionalStep((QuestHelper)this, (QuestStep)goToBasementSteps, "Enter the clocktower's basement for the black cog.", new Requirement[0]);
        this.goToFirstFloorWithBlueCog = new ConditionalStep((QuestHelper)this, (QuestStep)goToFirstFloor, "Place the blue cog on the peg on the first floor.", new Requirement[0]);
        this.goToFirstFloorWithBlueCog.addStep(this.inFirstFloor, this.blueCogOnBlueSpindle);
        this.goToGroundFloorWithRedCog = goToGroundFloor.copy();
        this.goToGroundFloorWithRedCog.setText("Place the red cog on the peg on the ground floor.");
        this.goToGroundFloorWithRedCog.addStep(null, this.redCogOnRedSpindle);
        this.goToBasementWithBlackCog = new ConditionalStep((QuestHelper)this, (QuestStep)goToBasementSteps, "Place the black cog on the peg in the basement.", new Requirement[0]);
        this.goToBasementWithBlackCog.addStep(new Conditions(this.inBasement, new Conditions(LogicType.NOR, this.inSecretPath, this.inCell)), this.blackCogOnBlackSpindle);
        this.goToSecondFloorWithWhiteCog = new ConditionalStep((QuestHelper)this, (QuestStep)goToSecondFloor, "Place the white cog on the peg on the second floor.", new Requirement[0]);
        this.goToSecondFloorWithWhiteCog.addStep(this.inSecondFloor, this.whiteCogOnWhiteSpindle);
        this.goToSecondFloorWithWhiteCog.addSubSteps(this.climbWhiteLadder);
        this.goFinishQuest = goToGroundFloor.copy();
        this.goFinishQuest.setText("Talk to Kojo for your reward.");
        this.goFinishQuest.addStep(null, this.kojoReward);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Collections.singletonList(this.bucketOfWater);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.staminaPotions, this.ardougneCloak);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Able to survive a hit or 2 from an Ogre (level 53)");
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Coins", 995, 500));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        PanelDetails gettingStarted = new PanelDetails("Getting Started", new ArrayList<QuestStep>(Collections.singletonList(this.talkToKojo)), new Requirement[0]);
        allSteps.add(gettingStarted);
        PanelDetails redCog = new PanelDetails("Obtaining the red cog", new ArrayList<QuestStep>(Arrays.asList(this.goToBasementForRed, this.pickUpRedCog, this.goToGroundFloorWithRedCog)), new Requirement[0]);
        allSteps.add(redCog);
        PanelDetails blueCog = new PanelDetails("Obtaining the blue cog", new ArrayList<QuestStep>(Arrays.asList(this.goToBasementForBlue, this.pushWall, this.pickUpBlueCog, this.goToFirstFloorWithBlueCog)), this.noteAboutWater);
        allSteps.add(blueCog);
        PanelDetails blackCog = new PanelDetails("Obtaining the black cog", new ArrayList<QuestStep>(Arrays.asList(this.goToBasementForBlack, this.pickupBlackCog, this.goToBasementWithBlackCog)), this.bucketOfWater);
        allSteps.add(blackCog);
        PanelDetails whiteCog = new PanelDetails("Obtaining the white cog", new ArrayList<QuestStep>(Arrays.asList(this.goToBasementForWhite, this.pickUpRatPoison, this.pullFirstLever, this.ratPoisonFood, this.westernGate, this.pickUpWhiteCog, this.goToSecondFloorWithWhiteCog)), new Requirement[0]);
        allSteps.add(whiteCog);
        PanelDetails finishingOff = new PanelDetails("Finishing off", new ArrayList<QuestStep>(Collections.singletonList(this.goFinishQuest)), new Requirement[0]);
        allSteps.add(finishingOff);
        return allSteps;
    }
}

