/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.clientofkourend;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.CLIENT_OF_KOUREND)
public class ClientOfKourend
extends BasicQuestHelper {
    ItemRequirement feather;
    ItemRequirement gamesNecklace;
    ItemRequirement enchantedScroll;
    ItemRequirement enchantedQuill;
    ItemRequirement mysteriousOrb;
    Requirement talkedToLeenz;
    Requirement talkedToHorace;
    Requirement talkedToJennifer;
    Requirement talkedToMunty;
    Requirement talkedToRegath;
    QuestStep talkToVeos;
    QuestStep useFeatherOnScroll;
    QuestStep talkToLeenz;
    QuestStep talkToHorace;
    QuestStep talkToJennifer;
    QuestStep talkToMunty;
    QuestStep talkToRegath;
    QuestStep returnToVeos;
    QuestStep goToAltar;
    QuestStep finishQuest;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToVeos);
        ConditionalStep makeEnchantedQuill = new ConditionalStep((QuestHelper)this, this.talkToVeos, new Requirement[0]);
        makeEnchantedQuill.addStep(new Conditions(this.enchantedQuill, this.talkedToLeenz, this.talkedToRegath, this.talkedToMunty, this.talkedToJennifer), this.talkToHorace);
        makeEnchantedQuill.addStep(new Conditions(this.enchantedQuill, this.talkedToLeenz, this.talkedToRegath, this.talkedToMunty), this.talkToJennifer);
        makeEnchantedQuill.addStep(new Conditions(this.enchantedQuill, this.talkedToLeenz, this.talkedToRegath), this.talkToMunty);
        makeEnchantedQuill.addStep(new Conditions(this.enchantedQuill, this.talkedToLeenz), this.talkToRegath);
        makeEnchantedQuill.addStep(new Conditions(this.enchantedQuill), this.talkToLeenz);
        makeEnchantedQuill.addStep(this.enchantedScroll, this.useFeatherOnScroll);
        steps.put(1, makeEnchantedQuill);
        steps.put(2, this.returnToVeos);
        ConditionalStep takeOrbToAltar = new ConditionalStep((QuestHelper)this, this.returnToVeos, new Requirement[0]);
        takeOrbToAltar.addStep(this.mysteriousOrb, this.goToAltar);
        steps.put(3, this.returnToVeos);
        steps.put(4, takeOrbToAltar);
        steps.put(5, this.finishQuest);
        steps.put(6, this.finishQuest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.feather = new ItemRequirement("Feather", 314);
        this.feather.setTooltip("Can be purchased from Gerrant's Fishy Business in Port Sarim.");
        this.feather.addAlternates(10089, 10091, 10088, 10090, 10167, 10087);
        this.feather.setHighlightInInventory(true);
        this.gamesNecklace = new ItemRequirement("Games necklace", ItemCollections.GAMES_NECKLACES);
        this.enchantedScroll = new ItemRequirement("Enchanted scroll", 21259);
        this.enchantedScroll.setHighlightInInventory(true);
        this.mysteriousOrb = new ItemRequirement("Mysterious orb", 21261);
        this.mysteriousOrb.setHighlightInInventory(true);
        this.enchantedQuill = new ItemRequirement("Enchanted quill", 21260);
    }

    public void setupConditions() {
        this.talkedToLeenz = new VarbitRequirement(5620, 1);
        this.talkedToRegath = new VarbitRequirement(5621, 1);
        this.talkedToMunty = new VarbitRequirement(5622, 1);
        this.talkedToJennifer = new VarbitRequirement(5623, 1);
        this.talkedToHorace = new VarbitRequirement(5624, 1);
    }

    public void setupSteps() {
        this.talkToVeos = new NpcStep((QuestHelper)this, 10727, new WorldPoint(1824, 3690, 0), "Talk to Veos on the Port Piscarilius docks. You can travel to him by talking to Veos in Port Sarim.", new Requirement[0]);
        this.talkToVeos.addDialogStep("Sounds interesting! How can I help?");
        this.talkToVeos.addDialogStep("Can you take me to Great Kourend?");
        this.talkToVeos.addDialogStep("Have you got any quests for me?");
        this.talkToVeos.addDialogStep("Let's talk about your client...");
        this.talkToVeos.addDialogStep("I've lost something you've given me.");
        this.useFeatherOnScroll = new DetailedQuestStep((QuestHelper)this, "Use a feather on the Enchanted Scroll", this.feather, this.enchantedScroll);
        this.talkToLeenz = new NpcStep((QuestHelper)this, 6986, new WorldPoint(1807, 3726, 0), "Talk to Leenz in Port Piscarilius general store.", this.enchantedQuill);
        this.talkToLeenz.addDialogStep("Can I ask you about Port Piscarilius?");
        this.talkToLeenz.addDialogStep("Why should I gain favour with Port Piscarilius?");
        this.talkToHorace = new NpcStep((QuestHelper)this, 6943, new WorldPoint(1774, 3589, 0), "Talk to Horace in the Hosidius general store.", this.enchantedQuill);
        this.talkToHorace.addDialogStep("Can I ask you about Hosidius?");
        this.talkToHorace.addDialogStep("Why should I gain favour with Hosidius?");
        this.talkToJennifer = new NpcStep((QuestHelper)this, 305, new WorldPoint(1518, 3586, 0), "Talk to Jennifer in Shayzien general store.", this.enchantedQuill);
        this.talkToJennifer.addDialogStep("Can I ask you about Shayzien?");
        this.talkToJennifer.addDialogStep("Why should I gain favour with Shayzien?");
        this.talkToMunty = new NpcStep((QuestHelper)this, 7088, new WorldPoint(1551, 3752, 0), "Talk to Munty in Lovakengj general store.", this.enchantedQuill);
        this.talkToMunty.addDialogStep("Can I ask you about Lovakengj?");
        this.talkToMunty.addDialogStep("Why should I gain favour with Lovakengj?");
        this.talkToRegath = new NpcStep((QuestHelper)this, 7056, new WorldPoint(1720, 3724, 0), "Talk to Regath in Arceuus general store.", this.enchantedQuill);
        this.talkToRegath.addDialogStep("Can I ask you about Arceuus?");
        this.talkToRegath.addDialogStep("Why should I gain favour with Arceuus?");
        this.returnToVeos = new NpcStep((QuestHelper)this, 10727, new WorldPoint(1824, 3690, 0), "Return to Veos on Piscarilius docks.", new Requirement[0]);
        this.returnToVeos.addDialogStep("Let's talk about your client...");
        this.returnToVeos.addDialogStep("I've lost something you've given me.");
        this.goToAltar = new DetailedQuestStep((QuestHelper)this, new WorldPoint(1712, 3883, 0), "Activate the mysterious orb at the Dark Altar. You can either run there through Arceuus, teleport to Wintertodt with the Games Necklace and run south, or teleport straight there on the Arceuus spellbook.", this.mysteriousOrb);
        this.finishQuest = new NpcStep((QuestHelper)this, 10727, new WorldPoint(1824, 3690, 0), "Return to Veos on Piscarilius docks.", new Requirement[0]);
        this.finishQuest.addDialogStep("Let's talk about your client...");
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.feather);
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.gamesNecklace);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        reqs.add(new QuestRequirement(QuestHelperQuest.X_MARKS_THE_SPOT, QuestState.FINISHED));
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Arrays.asList(new ItemReward("500 Experience Lamps (Any Skill)", 4447, 2), new ItemReward("20% Kourend Favour Certificate", 22367, 1), new ItemReward("Kharedst's Memoirs", 21760, 1));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Arrays.asList(this.talkToVeos, this.useFeatherOnScroll), this.feather));
        allSteps.add(new PanelDetails("Learn about Kourend", Arrays.asList(this.talkToLeenz, this.talkToRegath, this.talkToMunty, this.talkToJennifer, this.talkToHorace, this.returnToVeos), new Requirement[0]));
        allSteps.add(new PanelDetails("The Dark Altar", Arrays.asList(this.goToAltar, this.finishQuest), new Requirement[0]));
        return allSteps;
    }
}

