/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.bonevoyage;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.TeleportItemRequirement;
import com.questhelper.requirements.player.Favour;
import com.questhelper.requirements.player.FavourRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.Operation;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.GameState;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.BONE_VOYAGE)
public class BoneVoyage
extends BasicQuestHelper {
    ItemRequirement vodka2;
    ItemRequirement marrentillPotionUnf;
    ItemRequirement digsiteTeleport;
    ItemRequirement woodcuttingGuildTeleport;
    ItemRequirement varrockTeleport;
    ItemRequirement sarimTeleport;
    ItemRequirement lumberyardTeleport;
    ItemRequirement hammer;
    ItemRequirement ironBar;
    ItemRequirement oakPlanks;
    ItemRequirement nails;
    ItemRequirement sawmillAgreement;
    ItemRequirement boneCharm;
    ItemRequirement potionOfSealegs;
    ItemRequirement sawmillProposal;
    Requirement canEnterGuild;
    Requirement onBoat;
    Requirement gottenCharm;
    Requirement givenCharm;
    Requirement talkedToApoth;
    Requirement gottenPotion;
    Requirement givenPotion;
    QuestStep talkToHaig;
    QuestStep talkToForeman;
    QuestStep talkToSawmillOperator;
    QuestStep talkToOperatorInGuild;
    QuestStep talkToOperatorInGuildFromGate;
    QuestStep talkToOperatorInGuildGeneric;
    QuestStep returnWithAgreement;
    QuestStep talkToForemanAgain;
    QuestStep boardBarge;
    QuestStep talkToNavigator;
    QuestStep talkToJack;
    QuestStep boardBargeAfterJack;
    QuestStep talkToNavigatorAgain;
    QuestStep talkToOddOldMan;
    QuestStep talkToApoth;
    QuestStep talkToApothAgain;
    QuestStep boardBargeWithPotionAndCharm;
    QuestStep giveLeadPotion;
    QuestStep giveJuniorBone;
    QuestStep boardBargeWithCharm;
    QuestStep boardBargeWithPotion;
    QuestStep boardBargeToSail;
    QuestStep navigateShip;
    Zone boat;
    Zone boatSailing;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToHaig);
        steps.put(5, this.talkToForeman);
        steps.put(10, this.talkToSawmillOperator);
        ConditionalStep goTalkToOperatorInGuild = new ConditionalStep((QuestHelper)this, this.talkToOperatorInGuildFromGate, new Requirement[0]);
        goTalkToOperatorInGuild.addStep(this.canEnterGuild, this.talkToOperatorInGuild);
        steps.put(11, goTalkToOperatorInGuild);
        steps.put(15, this.returnWithAgreement);
        steps.put(20, this.talkToForemanAgain);
        ConditionalStep goTalkToLead = new ConditionalStep((QuestHelper)this, this.boardBarge, new Requirement[0]);
        goTalkToLead.addStep(this.onBoat, this.talkToNavigator);
        steps.put(21, goTalkToLead);
        steps.put(22, this.talkToJack);
        ConditionalStep goReturnToLead = new ConditionalStep((QuestHelper)this, this.boardBargeAfterJack, new Requirement[0]);
        goReturnToLead.addStep(this.onBoat, this.talkToNavigatorAgain);
        steps.put(23, goReturnToLead);
        ConditionalStep goGetItems = new ConditionalStep((QuestHelper)this, this.talkToOddOldMan, new Requirement[0]);
        goGetItems.addStep(new Conditions(this.onBoat, this.givenCharm, this.gottenPotion), this.giveLeadPotion);
        goGetItems.addStep(new Conditions(this.onBoat, this.gottenCharm, this.gottenPotion), this.giveJuniorBone);
        goGetItems.addStep(new Conditions(this.gottenCharm, this.givenPotion), this.boardBargeWithCharm);
        goGetItems.addStep(new Conditions(this.givenCharm, this.gottenPotion), this.boardBargeWithPotion);
        goGetItems.addStep(new Conditions(this.gottenCharm, this.gottenPotion), this.boardBargeWithPotionAndCharm);
        goGetItems.addStep(new Conditions(this.gottenCharm, this.talkedToApoth), this.talkToApothAgain);
        goGetItems.addStep(this.gottenCharm, this.talkToApoth);
        steps.put(25, goGetItems);
        ConditionalStep goSail = new ConditionalStep((QuestHelper)this, this.boardBargeToSail, new Requirement[0]);
        goSail.addStep(this.onBoat, this.navigateShip);
        steps.put(30, goSail);
        steps.put(35, goSail);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.canEnterGuild = new Conditions(new SkillRequirement(Skill.WOODCUTTING, 60, true), new FavourRequirement(Favour.HOSIDIUS, 75));
        this.onBoat = new ZoneRequirement(this.boat, this.boatSailing);
        this.gottenCharm = new VarbitRequirement(5796, 1, Operation.GREATER_EQUAL);
        this.givenCharm = new VarbitRequirement(5796, 2, Operation.GREATER_EQUAL);
        this.talkedToApoth = new VarbitRequirement(5797, 1, Operation.GREATER_EQUAL);
        this.gottenPotion = new VarbitRequirement(5797, 2, Operation.GREATER_EQUAL);
        this.givenPotion = new VarbitRequirement(5797, 3, Operation.GREATER_EQUAL);
        this.vodka2 = new ItemRequirement("Vodka", 2015, 2);
        this.marrentillPotionUnf = new ItemRequirement("Marrentill potion (unf)", 93);
        this.digsiteTeleport = new TeleportItemRequirement("Teleports to the Digsite", 11193);
        this.digsiteTeleport.addAlternates(11194, 12403);
        this.woodcuttingGuildTeleport = new TeleportItemRequirement("Teleport to the Woodcutting Guild", ItemCollections.SKILLS_NECKLACES);
        this.woodcuttingGuildTeleport.addAlternates(13393, 21760);
        this.varrockTeleport = new TeleportItemRequirement("Varrock teleport", 8007);
        this.sarimTeleport = new TeleportItemRequirement("Port Sarim teleport", ItemCollections.AMULET_OF_GLORIES);
        this.sarimTeleport.addAlternates(19615);
        this.lumberyardTeleport = new TeleportItemRequirement("Lumberyard teleport", 12642);
        this.hammer = new ItemRequirement("Hammer", ItemCollections.HAMMER);
        this.ironBar = new ItemRequirement("Iron bar", 2351);
        this.oakPlanks = new ItemRequirement("Oak plank", 8778, 2);
        this.nails = new ItemRequirement("Nails", ItemCollections.NAILS, 5);
        this.sawmillProposal = new ItemRequirement("Sawmill proposal", 21528);
        this.sawmillProposal.setTooltip("You can get another from the sawmill operator near Varrock");
        this.sawmillAgreement = new ItemRequirement("Sawmill agreement", 21529);
        if (this.client.getGameState() == GameState.LOGGED_IN && this.canEnterGuild.check(this.client)) {
            this.sawmillAgreement.setTooltip("You can get another from the sawmill operator in the Woodcutting Guild");
        } else {
            this.sawmillAgreement.setTooltip("You can get another by trying to enter the Woodcutting Guild");
        }
        this.boneCharm = new ItemRequirement("Bone charm", 21530);
        this.boneCharm.setTooltip("You can get another from the Odd Old Man north of the Dig Site");
        this.potionOfSealegs = new ItemRequirement("Potion of sealegs", 21531);
        this.potionOfSealegs.setTooltip("You can get another from the Apothecary in Varrock");
    }

    public void loadZones() {
        this.boat = new Zone(new WorldPoint(3355, 3451, 1), new WorldPoint(3366, 3455, 1));
        this.boatSailing = new Zone(new WorldPoint(1812, 4750, 0), new WorldPoint(1840, 4774, 2));
    }

    public void setupSteps() {
        this.talkToHaig = new NpcStep((QuestHelper)this, 5214, new WorldPoint(3257, 3448, 0), "Talk to Curator Haig in the Varrock Museum.", new Requirement[0]);
        this.talkToHaig.addDialogSteps("Have you any interesting news?", "Sign me up!", "Yes.");
        this.talkToForeman = new NpcStep((QuestHelper)this, 1938, new WorldPoint(3364, 3445, 0), "Talk to the Barge Foreman north of the Dig Site.", new Requirement[0]);
        this.talkToSawmillOperator = new NpcStep((QuestHelper)this, 3101, new WorldPoint(3302, 3492, 0), "Talk to the Sawmill Operator north east of Varrock.", new Requirement[0]);
        this.talkToSawmillOperator.addDialogStep("I'm here on behalf of the museum archaeological team.");
        this.talkToOperatorInGuild = new NpcStep((QuestHelper)this, 9140, new WorldPoint(1620, 3499, 0), "Talk to the Sawmill Operator in the Woodcutting Guild on Zeah.", this.sawmillProposal);
        this.talkToOperatorInGuild.addDialogStep("I'm here on behalf of the museum archaeological team.");
        this.talkToOperatorInGuildGeneric = this.talkToOperatorInGuildFromGate = new ObjectStep((QuestHelper)this, 28852, new WorldPoint(1657, 3504, 0), "Attempt to enter the Woodcutting Guild on Zeah to talk to the guild's sawmill operator.", this.sawmillProposal);
        if (this.canEnterGuild.check(this.client)) {
            this.talkToOperatorInGuildGeneric = this.talkToOperatorInGuild;
        }
        this.returnWithAgreement = new NpcStep((QuestHelper)this, 3101, new WorldPoint(3302, 3492, 0), "Return to the Sawmill Operator north east of Varrock.", this.sawmillAgreement);
        this.returnWithAgreement.addDialogStep("I'm here on behalf of the museum archaeological team.");
        this.talkToForemanAgain = new NpcStep((QuestHelper)this, 1938, new WorldPoint(3364, 3445, 0), "Return to the Barge Foreman north of the Dig Site.", new Requirement[0]);
        this.boardBarge = new NpcStep((QuestHelper)this, 8013, new WorldPoint(3362, 3446, 0), "Board the barge.", new Requirement[0]);
        this.boardBarge.addDialogStep("Can I go onto the barge?");
        this.talkToNavigator = new NpcStep((QuestHelper)this, 7761, new WorldPoint(3363, 3453, 1), "Talk to the Lead Navigator.", new Requirement[0]);
        this.talkToNavigator.addDialogStep("Yep, that would be me.");
        this.talkToNavigator.addDialogStep("No, what happened?");
        this.talkToJack = new NpcStep((QuestHelper)this, 1335, new WorldPoint(3050, 3257, 0), "Talk to Jack Seagull in the Port Sarim Pub.", new Requirement[0]);
        this.talkToJack.addDialogStep("Ever made any cursed voyages?");
        this.boardBargeAfterJack = new NpcStep((QuestHelper)this, 8013, new WorldPoint(3362, 3446, 0), "Return to the barge.", new Requirement[0]);
        this.boardBargeAfterJack.addDialogStep("Can I go onto the barge?");
        this.talkToNavigatorAgain = new NpcStep((QuestHelper)this, 7761, new WorldPoint(3363, 3453, 1), "Talk to the Lead Navigator again.", new Requirement[0]);
        this.talkToOddOldMan = new NpcStep((QuestHelper)this, 1259, new WorldPoint(3360, 3505, 0), "Talk to the Odd Old Man north of the Dig Site.", new Requirement[0]);
        this.talkToOddOldMan.addDialogSteps("Talk about lucky charms.", "I'm making a cursed voyage.");
        this.talkToApoth = new NpcStep((QuestHelper)this, 5036, new WorldPoint(3195, 3405, 0), "Talk the Apothecary in south west Varrock.", this.marrentillPotionUnf, this.vodka2);
        this.talkToApoth.addDialogSteps("Talk about something else.", "Talk about Bone Voyage.");
        this.talkToApothAgain = new NpcStep((QuestHelper)this, 5036, new WorldPoint(3195, 3405, 0), "Talk the Apothecary again.", this.marrentillPotionUnf, this.vodka2);
        this.talkToApothAgain.addDialogSteps("Talk about something else.", "Talk about Bone Voyage.");
        this.boardBargeWithPotionAndCharm = new NpcStep((QuestHelper)this, 8013, new WorldPoint(3362, 3446, 0), "Board the barge.", this.boneCharm, this.potionOfSealegs);
        this.boardBargeWithPotionAndCharm.addDialogStep("Can I go onto the barge?");
        this.boardBargeWithPotion = new NpcStep((QuestHelper)this, 8013, new WorldPoint(3362, 3446, 0), "Board the barge.", this.potionOfSealegs);
        this.boardBargeWithPotion.addDialogStep("Can I go onto the barge?");
        this.boardBargeWithCharm = new NpcStep((QuestHelper)this, 8013, new WorldPoint(3362, 3446, 0), "Board the barge.", this.boneCharm);
        this.boardBargeWithCharm.addDialogStep("Can I go onto the barge?");
        this.boardBargeWithPotionAndCharm.addSubSteps(this.boardBargeWithCharm, this.boardBargeWithPotion);
        this.giveLeadPotion = new NpcStep((QuestHelper)this, 7761, new WorldPoint(3363, 3453, 1), "Give the Lead Navigator the potion.", this.potionOfSealegs);
        this.giveJuniorBone = new NpcStep((QuestHelper)this, 7763, new WorldPoint(3363, 3453, 1), "Give the Junior Navigator the bone charm.", this.boneCharm);
        this.boardBargeToSail = new NpcStep((QuestHelper)this, 8013, new WorldPoint(3362, 3446, 0), "Board the barge.", new Requirement[0]);
        this.boardBargeToSail.addDialogStep("Can I go onto the barge?");
        this.navigateShip = new NpcStep((QuestHelper)this, 7761, new WorldPoint(3363, 3453, 1), "Talk to the Lead Navigator to set sail. Navigate the ship by keeping the arrow in the middle. Raise the sails to go faster.", new Requirement[0]);
        this.navigateShip.addDialogStep("I'm ready, let's go.");
        this.navigateShip.addSubSteps(this.boardBargeToSail);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.vodka2, this.marrentillPotionUnf);
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        return Arrays.asList(this.digsiteTeleport.quantity(4), this.woodcuttingGuildTeleport, this.varrockTeleport, this.sarimTeleport, this.lumberyardTeleport.quantity(2), this.hammer, this.ironBar, this.oakPlanks, this.nails);
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        int KUDOS_VARBIT = 3637;
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new VarbitRequirement(3637, Operation.GREATER_EQUAL, 100, "100 Kudos"));
        req.add(new QuestRequirement(QuestHelperQuest.THE_DIG_SITE, QuestState.FINISHED));
        return req;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(1);
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Collections.singletonList(new UnlockReward("Access to Fossil Island"));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Collections.singletonList(this.talkToHaig), new Requirement[0]));
        allSteps.add(new PanelDetails("Securing materials", Arrays.asList(this.talkToForeman, this.talkToSawmillOperator, this.talkToOperatorInGuildGeneric, this.returnWithAgreement, this.talkToForemanAgain), new Requirement[0]));
        allSteps.add(new PanelDetails("Lucky charms", Arrays.asList(this.boardBarge, this.talkToNavigator, this.talkToJack, this.boardBargeAfterJack, this.talkToNavigatorAgain, this.talkToOddOldMan, this.talkToApoth, this.talkToApothAgain, this.boardBargeWithPotionAndCharm, this.giveJuniorBone, this.giveLeadPotion), this.marrentillPotionUnf, this.vodka2));
        allSteps.add(new PanelDetails("The voyage", Collections.singletonList(this.navigateShip), new Requirement[0]));
        return allSteps;
    }

    @Override
    public List<String> getNotes() {
        return Collections.singletonList("After quest completion you can use the iron bar, oak planks, nails and hammer to build a bank chest on Fossil Island (requires 21 Construction).");
    }
}

