/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.blackknightfortress;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.quest.QuestPointRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.BLACK_KNIGHTS_FORTRESS)
public class BlackKnightFortress
extends BasicQuestHelper {
    ItemRequirement ironChainbody;
    ItemRequirement cabbage;
    ItemRequirement bronzeMed;
    ItemRequirement teleportFalador;
    ItemRequirement armour;
    ItemRequirement food;
    Requirement onTopOfFortress;
    Requirement inBasement;
    Requirement inSecretRoomGroundFloor;
    Requirement inSecretRoomFirstFloor;
    Requirement inSecretRoomSecondFloor;
    Requirement inCentralAreaFloor1;
    Requirement inMainEntrance;
    Requirement inWestRoomFloor1;
    Requirement inEastRoomFloor0;
    Requirement inEastRoomFloor1;
    Requirement inEastRoomFloor2;
    Requirement inListeningRoom;
    Requirement inCabbageHoleRoom;
    Requirement inPathToCabbageRoom;
    Requirement inEastTurret;
    Requirement inFaladorF1;
    Requirement inFaladorF2;
    Zone secretRoomFloor0;
    Zone secretRoomFloor1;
    Zone secretRoomFloor2;
    Zone secretRoomFloor3;
    Zone secretBasement;
    Zone mainEntrance1;
    Zone mainEntrance2;
    Zone mainEntrance3;
    Zone mainEntrance4;
    Zone westFloor1;
    Zone eastRoom1Floor0;
    Zone eastRoom2Floor0;
    Zone listeningRoom1;
    Zone listeningRoom2;
    Zone eastRoomFloor2;
    Zone centralArea1Floor1;
    Zone centralArea2Floor1;
    Zone centralArea3Floor1;
    Zone northPathToCabbageHole1;
    Zone northPathToCabbageHole2;
    Zone northPathToCabbageHole3;
    Zone cabbageHoleRoom;
    Zone eastRoom1Floor1;
    Zone eastRoom2Floor1;
    Zone eastRoom3Floor1;
    Zone eastRoom4Floor1;
    Zone eastTurret;
    Zone whiteKnightsCastleF1;
    Zone whiteKnightsCastleF2;
    QuestStep speakToAmik;
    QuestStep enterFortress;
    QuestStep pushWall;
    QuestStep climbUpLadder1;
    QuestStep climbUpLadder2;
    QuestStep climbUpLadder3;
    QuestStep climbUpLadder4;
    QuestStep climbUpLadder5;
    QuestStep climbUpLadder6;
    QuestStep climbDownLadder1;
    QuestStep climbDownLadder2;
    QuestStep climbDownLadder3;
    QuestStep climbDownLadder4;
    QuestStep climbDownLadder5;
    QuestStep climbDownLadder6;
    QuestStep listenAtGrill;
    QuestStep pushWall2;
    QuestStep returnToAmik;
    QuestStep exitBasement;
    QuestStep exitTopOfFortress;
    QuestStep exitEastTurret;
    QuestStep exitWestRoomFirstFloor;
    QuestStep goBackDownFromCabbageZone;
    QuestStep goUpLadderToCabbageZone;
    QuestStep climbToWhiteKnightsCastleF1;
    QuestStep climbToWhiteKnightsCastleF2;
    QuestStep climbToWhiteKnightsCastleF1ToFinish;
    QuestStep climbToWhiteKnightsCastleF2ToFinish;
    ObjectStep useCabbageOnHole;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        this.setupZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        ConditionalStep goStartQuest = new ConditionalStep((QuestHelper)this, this.climbToWhiteKnightsCastleF1, new Requirement[0]);
        goStartQuest.addStep(this.inFaladorF2, this.speakToAmik);
        goStartQuest.addStep(this.inFaladorF1, this.climbToWhiteKnightsCastleF2);
        steps.put(0, goStartQuest);
        ConditionalStep infiltrateTheFortress = new ConditionalStep((QuestHelper)this, this.enterFortress, new Requirement[0]);
        infiltrateTheFortress.addStep(this.inListeningRoom, this.listenAtGrill);
        infiltrateTheFortress.addStep(this.inEastRoomFloor1, this.climbDownLadder6);
        infiltrateTheFortress.addStep(this.inEastRoomFloor2, this.climbDownLadder5);
        infiltrateTheFortress.addStep(this.inCentralAreaFloor1, this.climbUpLadder4);
        infiltrateTheFortress.addStep(this.inSecretRoomSecondFloor, this.climbDownLadder3);
        infiltrateTheFortress.addStep(this.inSecretRoomFirstFloor, this.climbUpLadder2);
        infiltrateTheFortress.addStep(this.inSecretRoomGroundFloor, this.climbUpLadder1);
        infiltrateTheFortress.addStep(new Conditions(false, LogicType.OR, this.inMainEntrance, this.inEastRoomFloor0), this.pushWall);
        infiltrateTheFortress.addStep(this.inWestRoomFloor1, this.exitWestRoomFirstFloor);
        infiltrateTheFortress.addStep(this.inBasement, this.exitBasement);
        infiltrateTheFortress.addStep(this.onTopOfFortress, this.exitTopOfFortress);
        infiltrateTheFortress.addStep(this.inEastTurret, this.exitEastTurret);
        infiltrateTheFortress.addStep(new Conditions(false, LogicType.OR, this.inCabbageHoleRoom, this.inPathToCabbageRoom), this.goBackDownFromCabbageZone);
        steps.put(1, infiltrateTheFortress);
        ConditionalStep sabotageThePotion = new ConditionalStep((QuestHelper)this, this.enterFortress, new Requirement[0]);
        sabotageThePotion.addStep(new Conditions(false, LogicType.OR, this.inSecretRoomGroundFloor, this.inMainEntrance, this.inEastRoomFloor0), this.goUpLadderToCabbageZone);
        sabotageThePotion.addStep(this.inCabbageHoleRoom, this.useCabbageOnHole);
        sabotageThePotion.addStep(this.inPathToCabbageRoom, this.pushWall2);
        sabotageThePotion.addStep(this.inSecretRoomFirstFloor, this.climbDownLadder1);
        sabotageThePotion.addStep(this.inSecretRoomSecondFloor, this.climbDownLadder2);
        sabotageThePotion.addStep(this.inCentralAreaFloor1, this.climbUpLadder3);
        sabotageThePotion.addStep(this.inEastRoomFloor2, this.climbDownLadder4);
        sabotageThePotion.addStep(this.inEastRoomFloor1, this.climbUpLadder5);
        sabotageThePotion.addStep(this.inListeningRoom, this.climbUpLadder6);
        sabotageThePotion.addStep(this.inWestRoomFloor1, this.exitWestRoomFirstFloor);
        sabotageThePotion.addStep(this.inBasement, this.exitBasement);
        sabotageThePotion.addStep(this.onTopOfFortress, this.exitTopOfFortress);
        sabotageThePotion.addStep(this.inEastTurret, this.exitEastTurret);
        steps.put(2, sabotageThePotion);
        ConditionalStep goFinishQuest = new ConditionalStep((QuestHelper)this, this.climbToWhiteKnightsCastleF1ToFinish, new Requirement[0]);
        goFinishQuest.addStep(this.inFaladorF2, this.returnToAmik);
        goFinishQuest.addStep(this.inFaladorF1, this.climbToWhiteKnightsCastleF2ToFinish);
        steps.put(3, goFinishQuest);
        return steps;
    }

    private void setupZones() {
        this.whiteKnightsCastleF1 = new Zone(new WorldPoint(2954, 3353, 1), new WorldPoint(2998, 3327, 1));
        this.whiteKnightsCastleF2 = new Zone(new WorldPoint(2954, 3353, 2), new WorldPoint(2998, 3327, 2));
        this.secretRoomFloor0 = new Zone(new WorldPoint(3015, 3517, 0), new WorldPoint(3016, 3519, 0));
        this.secretRoomFloor1 = new Zone(new WorldPoint(3015, 3517, 1), new WorldPoint(3016, 3519, 1));
        this.secretRoomFloor2 = new Zone(new WorldPoint(3007, 3513, 2), new WorldPoint(3018, 3519, 2));
        this.secretRoomFloor3 = new Zone(new WorldPoint(3009, 3514, 3), new WorldPoint(3012, 3517, 3));
        this.secretBasement = new Zone(new WorldPoint(1862, 4264, 0), new WorldPoint(1873, 4229, 0));
        this.mainEntrance1 = new Zone(new WorldPoint(3008, 3513, 0), new WorldPoint(3012, 3518, 0));
        this.mainEntrance2 = new Zone(new WorldPoint(3012, 3514, 0), new WorldPoint(3014, 3516, 0));
        this.mainEntrance3 = new Zone(new WorldPoint(3015, 3515, 0), new WorldPoint(3019, 3516, 0));
        this.mainEntrance4 = new Zone(new WorldPoint(3019, 3513, 0), new WorldPoint(3019, 3517, 0));
        this.eastRoom1Floor0 = new Zone(new WorldPoint(3020, 3513, 0), new WorldPoint(3030, 3518, 0));
        this.eastRoom2Floor0 = new Zone(new WorldPoint(3021, 3511, 0), new WorldPoint(3030, 3512, 0));
        this.eastRoom1Floor1 = new Zone(new WorldPoint(3021, 3506, 1), new WorldPoint(3025, 3512, 1));
        this.eastRoom2Floor1 = new Zone(new WorldPoint(3021, 3513, 1), new WorldPoint(3021, 3513, 1));
        this.eastRoom3Floor1 = new Zone(new WorldPoint(3026, 3510, 1), new WorldPoint(3029, 3515, 1));
        this.eastRoom4Floor1 = new Zone(new WorldPoint(3025, 3513, 1), new WorldPoint(3025, 3516, 1));
        this.eastRoomFloor2 = new Zone(new WorldPoint(3021, 3504, 2), new WorldPoint(3031, 3516, 2));
        this.listeningRoom1 = new Zone(new WorldPoint(3021, 3510, 0), new WorldPoint(3026, 3510, 0));
        this.listeningRoom2 = new Zone(new WorldPoint(3025, 3506, 0), new WorldPoint(3026, 3509, 0));
        this.westFloor1 = new Zone(new WorldPoint(3007, 3513, 1), new WorldPoint(3014, 3519, 1));
        this.centralArea1Floor1 = new Zone(new WorldPoint(3015, 3514, 1), new WorldPoint(3024, 3516, 1));
        this.centralArea2Floor1 = new Zone(new WorldPoint(3019, 3517, 1), new WorldPoint(3021, 3518, 1));
        this.centralArea3Floor1 = new Zone(new WorldPoint(3022, 3513, 1), new WorldPoint(3024, 3513, 1));
        this.northPathToCabbageHole1 = new Zone(new WorldPoint(3022, 3517, 1), new WorldPoint(3030, 3518, 1));
        this.northPathToCabbageHole2 = new Zone(new WorldPoint(3030, 3510, 1), new WorldPoint(3030, 3516, 1));
        this.northPathToCabbageHole3 = new Zone(new WorldPoint(3029, 3516, 1), new WorldPoint(3029, 3516, 1));
        this.cabbageHoleRoom = new Zone(new WorldPoint(3026, 3504, 1), new WorldPoint(3032, 3509, 1));
        this.eastTurret = new Zone(new WorldPoint(3027, 3505, 3), new WorldPoint(3031, 3508, 3));
    }

    @Override
    public void setupRequirements() {
        this.ironChainbody = new ItemRequirement("Iron chainbody", 1101, 1, true).isNotConsumed();
        this.ironChainbody.setTooltip("You can buy one from the Chainmail Shop in south Falador");
        this.cabbage = new ItemRequirement("Cabbage (NOT from Draynor Manor)", 1965);
        this.cabbage.setTooltip("You can get one from the Edgeville Monastery east of the Black Knights' Fortress.");
        this.bronzeMed = new ItemRequirement("Bronze med helm", 1139, 1, true).isNotConsumed();
        this.bronzeMed.setTooltip("You can get one from the helmet shop in Barbarian Village.");
        this.teleportFalador = new ItemRequirement("Teleport to Falador", 8009);
        this.armour = new ItemRequirement("Armour", -1, -1).isNotConsumed();
        this.armour.setDisplayItemId(BankSlotIcons.getArmour());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
    }

    private void setupConditions() {
        this.inFaladorF1 = new ZoneRequirement(this.whiteKnightsCastleF1);
        this.inFaladorF2 = new ZoneRequirement(this.whiteKnightsCastleF2);
        this.onTopOfFortress = new ZoneRequirement(this.secretRoomFloor3);
        this.inBasement = new ZoneRequirement(this.secretBasement);
        this.inEastTurret = new ZoneRequirement(this.eastTurret);
        this.inSecretRoomGroundFloor = new ZoneRequirement(this.secretRoomFloor0);
        this.inSecretRoomFirstFloor = new ZoneRequirement(this.secretRoomFloor1);
        this.inSecretRoomSecondFloor = new ZoneRequirement(this.secretRoomFloor2);
        this.inMainEntrance = new ZoneRequirement(this.mainEntrance1, this.mainEntrance2, this.mainEntrance3, this.mainEntrance4);
        this.inCentralAreaFloor1 = new ZoneRequirement(this.centralArea1Floor1, this.centralArea2Floor1, this.centralArea3Floor1);
        this.inWestRoomFloor1 = new ZoneRequirement(this.westFloor1);
        this.inEastRoomFloor0 = new ZoneRequirement(this.eastRoom1Floor0, this.eastRoom2Floor0);
        this.inEastRoomFloor1 = new ZoneRequirement(this.eastRoom1Floor1, this.eastRoom2Floor1, this.eastRoom3Floor1, this.eastRoom4Floor1);
        this.inEastRoomFloor2 = new ZoneRequirement(this.eastRoomFloor2);
        this.inListeningRoom = new ZoneRequirement(this.listeningRoom1, this.listeningRoom2);
        this.inPathToCabbageRoom = new ZoneRequirement(this.northPathToCabbageHole1, this.northPathToCabbageHole2, this.northPathToCabbageHole3);
        this.inCabbageHoleRoom = new ZoneRequirement(this.cabbageHoleRoom);
    }

    private void setupSteps() {
        this.climbToWhiteKnightsCastleF1 = new ObjectStep((QuestHelper)this, 24072, new WorldPoint(2955, 3339, 0), "Speak to Sir Amik Varze on the 2nd floor of Falador Castle.", new Requirement[0]);
        this.climbToWhiteKnightsCastleF2 = new ObjectStep((QuestHelper)this, 24072, new WorldPoint(2961, 3339, 1), "Speak to Sir Amik Varze on the 2nd floor of Falador Castle.", new Requirement[0]);
        this.speakToAmik = new NpcStep((QuestHelper)this, 4771, new WorldPoint(2959, 3339, 2), "Speak to Sir Amik Varze on the 2nd floor of Falador Castle.", new Requirement[0]);
        this.speakToAmik.addDialogStep("I seek a quest!");
        this.speakToAmik.addDialogStep("I laugh in the face of danger!");
        this.speakToAmik.addDialogStep("Ok, I'll do my best.");
        this.speakToAmik.addSubSteps(this.climbToWhiteKnightsCastleF1, this.climbToWhiteKnightsCastleF2);
        this.enterFortress = new ObjectStep((QuestHelper)this, 2337, new WorldPoint(3016, 3514, 0), "Enter the Black Knights' Fortress. Be prepared for multiple level 33 Black Knights to attack you.", this.ironChainbody, this.bronzeMed, this.cabbage);
        this.pushWall = new ObjectStep((QuestHelper)this, 2341, new WorldPoint(3016, 3517, 0), "Push the wall to enter a secret room.", new Requirement[0]);
        this.climbUpLadder1 = new ObjectStep((QuestHelper)this, 17148, new WorldPoint(3015, 3519, 0), "Climb up the ladder.", new Requirement[0]);
        this.climbUpLadder2 = new ObjectStep((QuestHelper)this, 17148, new WorldPoint(3016, 3519, 1), "Climb up the next ladder.", new Requirement[0]);
        this.climbDownLadder3 = new ObjectStep((QuestHelper)this, 17149, new WorldPoint(3017, 3516, 2), "Climb down the ladder south of you.", new Requirement[0]);
        this.climbUpLadder4 = new ObjectStep((QuestHelper)this, 17148, new WorldPoint(3023, 3513, 1), "Climb up the ladder east of you.", new Requirement[0]);
        this.climbDownLadder5 = new ObjectStep((QuestHelper)this, 17149, new WorldPoint(3025, 3513, 2), "Climb down the next ladder east of you.", new Requirement[0]);
        this.climbDownLadder6 = new ObjectStep((QuestHelper)this, 17149, new WorldPoint(3021, 3510, 1), "Climb down the ladder west of you.", new Requirement[0]);
        this.listenAtGrill = new ObjectStep((QuestHelper)this, 2342, new WorldPoint(3026, 3507, 0), "Listen at the grill.", new Requirement[0]);
        this.climbUpLadder6 = new ObjectStep((QuestHelper)this, 17148, new WorldPoint(3021, 3510, 0), "Climb back up the ladder from the listening room.", this.cabbage);
        this.climbUpLadder5 = new ObjectStep((QuestHelper)this, 17148, new WorldPoint(3025, 3513, 1), "Climb up the ladder in the chapel room east of you.", this.cabbage);
        this.climbDownLadder4 = new ObjectStep((QuestHelper)this, 17149, new WorldPoint(3023, 3513, 2), "Climb down the ladder west of you.", this.cabbage);
        this.climbUpLadder3 = new ObjectStep((QuestHelper)this, 17148, new WorldPoint(3017, 3516, 1), "Climb up the ladder west of you.", this.cabbage);
        this.climbDownLadder2 = new ObjectStep((QuestHelper)this, 17149, new WorldPoint(3016, 3519, 2), "Climb down the ladder north of you.", this.cabbage);
        this.climbDownLadder1 = new ObjectStep((QuestHelper)this, 17149, new WorldPoint(3015, 3519, 1), "Climb down the next ladder.", this.cabbage);
        this.goUpLadderToCabbageZone = new ObjectStep((QuestHelper)this, 17159, new WorldPoint(3022, 3518, 0), "Go into the east room and climb the ladder there. When trying to go through the door to the room, you'll have to go through some dialog. Select option 2.", this.cabbage);
        this.goUpLadderToCabbageZone.addDialogStep("I don't care. I'm going in anyway.");
        this.pushWall2 = new ObjectStep((QuestHelper)this, 2341, new WorldPoint(3030, 3510, 1), "Push the wall to enter the storage room", this.cabbage);
        this.useCabbageOnHole = new ObjectStep((QuestHelper)this, 2336, new WorldPoint(3031, 3507, 1), "USE the cabbage on the hole here. Be careful not to eat it.", this.cabbage.highlighted());
        this.useCabbageOnHole.addIcon(1965);
        this.goBackDownFromCabbageZone = new ObjectStep((QuestHelper)this, 17160, new WorldPoint(3022, 3518, 1), "Climb back down the ladder to continue.", new Requirement[0]);
        this.exitEastTurret = new ObjectStep((QuestHelper)this, 17155, new WorldPoint(3029, 3507, 3), "Go back downstairs to continue.", new Requirement[0]);
        this.exitBasement = new ObjectStep((QuestHelper)this, 25844, new WorldPoint(1867, 4244, 0), "Leave the basement to continue.", new Requirement[0]);
        this.exitTopOfFortress = new ObjectStep((QuestHelper)this, 17155, new WorldPoint(3010, 3516, 3), "Leave the basement to continue.", new Requirement[0]);
        this.exitWestRoomFirstFloor = new ObjectStep((QuestHelper)this, 17155, new WorldPoint(3011, 3515, 1), "Go back downstairs to continue", new Requirement[0]);
        this.climbToWhiteKnightsCastleF1ToFinish = new ObjectStep((QuestHelper)this, 24072, new WorldPoint(2955, 3339, 0), "Return to Sir Amik Varze in Falador Castle to complete the quest.", new Requirement[0]);
        this.climbToWhiteKnightsCastleF2ToFinish = new ObjectStep((QuestHelper)this, 24072, new WorldPoint(2961, 3339, 1), "Return to Sir Amik Varze in Falador Castle to complete the quest.", new Requirement[0]);
        this.returnToAmik = new NpcStep((QuestHelper)this, 4771, new WorldPoint(2959, 3339, 2), "Return to Sir Amik Varze in Falador Castle to complete the quest.", new Requirement[0]);
        this.returnToAmik.addSubSteps(this.climbToWhiteKnightsCastleF1ToFinish, this.climbToWhiteKnightsCastleF2ToFinish);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.bronzeMed);
        reqs.add(this.ironChainbody);
        reqs.add(this.cabbage);
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.teleportFalador);
        reqs.add(this.food);
        reqs.add(this.armour);
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Able to survive being attacked by multiple level 33 Black Knights");
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(3);
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("Coins", 995, 2500));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Talk to Sir Amik Varze", Collections.singletonList(this.speakToAmik), new Requirement[0]));
        allSteps.add(new PanelDetails("Infiltrate the fortress", Arrays.asList(this.enterFortress, this.pushWall, this.climbUpLadder1, this.climbUpLadder2, this.climbDownLadder3, this.climbUpLadder4, this.climbDownLadder5, this.climbDownLadder6, this.listenAtGrill), this.bronzeMed, this.ironChainbody, this.cabbage));
        allSteps.add(new PanelDetails("Sabotage the potion", Arrays.asList(this.climbUpLadder6, this.climbUpLadder5, this.climbDownLadder4, this.climbUpLadder3, this.climbDownLadder2, this.climbDownLadder1, this.goUpLadderToCabbageZone, this.pushWall2, this.useCabbageOnHole), new Requirement[0]));
        allSteps.add(new PanelDetails("Return to Sir Amik Varze", Collections.singletonList(this.returnToAmik), new Requirement[0]));
        return allSteps;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        return Collections.singletonList(new QuestPointRequirement(12));
    }
}

