/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.biohazard;

import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.steps.DetailedOwnerStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.QuestStep;
import java.util.Arrays;
import java.util.Collection;
import net.runelite.api.NPC;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.InteractingChanged;
import net.runelite.client.eventbus.Subscribe;

public class GiveIngredientsToHelpersStep
extends DetailedOwnerStep {
    DetailedQuestStep giveHopsBroline;
    DetailedQuestStep giveVinciEthenea;
    DetailedQuestStep giveChancyHoney;
    ItemRequirement ethenea;
    ItemRequirement liquidHoney;
    ItemRequirement sulphuricBroline;
    int lastNpcInteractedWith;

    public GiveIngredientsToHelpersStep(QuestHelper questHelper) {
        super(questHelper, new Requirement[0]);
    }

    @Override
    protected void updateSteps() {
        if (this.sulphuricBroline.check(this.client)) {
            this.startUpStep(this.giveHopsBroline);
        } else if (this.liquidHoney.check(this.client)) {
            this.startUpStep(this.giveChancyHoney);
        } else if (this.ethenea.check(this.client)) {
            this.startUpStep(this.giveVinciEthenea);
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.currentStep == this.giveHopsBroline && !this.sulphuricBroline.check(this.client) || this.currentStep == this.giveChancyHoney && !this.liquidHoney.check(this.client) || this.currentStep == this.giveVinciEthenea && !this.ethenea.check(this.client)) {
            this.updateSteps();
        }
    }

    @Subscribe
    public void onInteractingChanged(InteractingChanged event) {
        if (event.getSource() == this.client.getLocalPlayer() && event.getTarget() instanceof NPC) {
            int npcID = ((NPC)event.getTarget()).getId();
            if (npcID == 1107 && this.sulphuricBroline.check(this.client)) {
                this.lastNpcInteractedWith = npcID;
                this.startUpStep(this.giveHopsBroline);
            } else if (npcID == 1105 && this.liquidHoney.check(this.client)) {
                this.lastNpcInteractedWith = npcID;
                this.startUpStep(this.giveChancyHoney);
            } else if (npcID == 1103 && this.ethenea.check(this.client)) {
                this.lastNpcInteractedWith = npcID;
                this.startUpStep(this.giveVinciEthenea);
            }
        }
    }

    @Override
    protected void setupSteps() {
        this.ethenea = new ItemRequirement("Ethenea", 415);
        this.ethenea.setTooltip("You can get another from Elena in East Ardougne.");
        this.liquidHoney = new ItemRequirement("Liquid honey", 416);
        this.liquidHoney.setTooltip("You can get another from Elena in East Ardougne.");
        this.sulphuricBroline = new ItemRequirement("Sulphuric broline", 417);
        this.sulphuricBroline.setTooltip("You can get another from Elena in East Ardougne.");
        this.giveHopsBroline = new NpcStep(this.getQuestHelper(), 1107, new WorldPoint(2930, 3220, 0), "Give Hops the Sulphuric Broline.", this.sulphuricBroline);
        this.giveHopsBroline.addDialogStep("You give him the vial of sulphuric broline...");
        this.giveChancyHoney = new NpcStep(this.getQuestHelper(), 1105, new WorldPoint(2930, 3220, 0), "Give Chancy the Liquid honey.", this.liquidHoney);
        this.giveChancyHoney.addDialogStep("You give him the vial of liquid honey...");
        this.giveVinciEthenea = new NpcStep(this.getQuestHelper(), 1103, new WorldPoint(2930, 3220, 0), "Give Da Vinci the Ethenea.", this.ethenea);
        this.giveVinciEthenea.addDialogStep("You give him the vial of ethenea...");
    }

    @Override
    public Collection<QuestStep> getSteps() {
        return Arrays.asList(this.giveHopsBroline, this.giveChancyHoney, this.giveVinciEthenea);
    }

    public Collection<DetailedQuestStep> getDisplaySteps() {
        return Arrays.asList(this.giveHopsBroline, this.giveChancyHoney, this.giveVinciEthenea);
    }
}

