/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.biohazard;

import com.questhelper.collections.ItemCollections;
import com.questhelper.helpers.quests.biohazard.GiveIngredientsToHelpersStep;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questhelpers.QuestUtil;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.ObjectCondition;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.item.ItemRequirements;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.BIOHAZARD)
public class Biohazard
extends BasicQuestHelper {
    ItemRequirement gasMask;
    ItemRequirement birdFeed;
    ItemRequirement birdCage;
    ItemRequirement rottenApple;
    ItemRequirement medicalGown;
    ItemRequirement key;
    ItemRequirement distillator;
    ItemRequirement plagueSample;
    ItemRequirement ethenea;
    ItemRequirement liquidHoney;
    ItemRequirement sulphuricBroline;
    ItemRequirement touchPaper;
    ItemRequirement priestGownTop;
    ItemRequirement priestGownBottom;
    ItemRequirement priestGownBottomEquipped;
    ItemRequirement priestGownTopEquipped;
    ItemRequirement medicalGownEquipped;
    ItemRequirement birdCageHighlighted;
    ItemRequirement teleportVarrock;
    ItemRequirement teleportArdougne;
    ItemRequirement teleportRimmington;
    ItemRequirement coins;
    Requirement inMournerBackyard;
    Requirement inWestArdougne;
    Requirement inMournerBuilding;
    Requirement upstairsInMournerBuilding;
    Requirement inVarrockSouthEast;
    Requirement hasPriestSet;
    Requirement isUpstairsArdougneCastle;
    Requirement hasChemicals;
    QuestStep talkToElena;
    QuestStep talkToJerico;
    QuestStep getBirdFeed;
    QuestStep getBirdFeed2;
    QuestStep getPigeonCage;
    QuestStep investigateWatchtower;
    QuestStep clickPigeonCage;
    QuestStep talkToOmartAgain;
    QuestStep talkToOmartToReturnToWest;
    QuestStep talkToKilron;
    QuestStep enterBackyardOfHeadquarters;
    QuestStep pickupRottenApple;
    QuestStep useRottenAppleOnCauldron;
    QuestStep searchSarahsCupboard;
    QuestStep searchSarahsCupboard2;
    QuestStep enterMournerHeadquarters;
    QuestStep goUpstairsInMournerBuilding;
    QuestStep killMourner;
    QuestStep searchCrateForDistillator;
    QuestStep goBackDownstairsInMournersHeadquarters;
    QuestStep talkToElenaWithDistillator;
    QuestStep talkToTheChemist;
    QuestStep goToVarrock;
    QuestStep vinciVarrock;
    QuestStep chancyVarrock;
    QuestStep hopsVarrock;
    QuestStep talkToAsyff;
    QuestStep talkToGuidor;
    QuestStep returnToElenaAfterSampling;
    QuestStep informTheKing;
    QuestStep informTheKingGoUpstairs;
    GiveIngredientsToHelpersStep giveChemicals;
    Zone westArdougne1;
    Zone westArdougne2;
    Zone westArdougne3;
    Zone mournerBackyard;
    Zone mournerBuilding1;
    Zone mournerBuilding2;
    Zone mournersBuildingUpstairs;
    Zone varrockSouthEast;
    Zone upstairsArdougneCastle;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToElena);
        steps.put(1, this.talkToJerico);
        ConditionalStep prepareADistraction = new ConditionalStep((QuestHelper)this, this.getBirdFeed, new Requirement[0]);
        prepareADistraction.addStep(new Conditions(this.birdCage, this.birdFeed), this.investigateWatchtower);
        prepareADistraction.addStep(this.birdFeed, this.getPigeonCage);
        prepareADistraction.addStep(new ObjectCondition(2057), this.getBirdFeed2);
        steps.put(2, prepareADistraction);
        ConditionalStep causeADistraction = new ConditionalStep((QuestHelper)this, this.getPigeonCage, new Requirement[0]);
        causeADistraction.addStep(this.birdCage, this.clickPigeonCage);
        steps.put(3, causeADistraction);
        steps.put(4, this.talkToOmartAgain);
        ConditionalStep poisonFood = new ConditionalStep((QuestHelper)this, this.talkToOmartToReturnToWest, new Requirement[0]);
        poisonFood.addStep(new Conditions(this.inMournerBackyard, this.rottenApple), this.useRottenAppleOnCauldron);
        poisonFood.addStep(this.inMournerBackyard, this.pickupRottenApple);
        poisonFood.addStep(this.inWestArdougne, this.enterBackyardOfHeadquarters);
        steps.put(5, poisonFood);
        ConditionalStep infiltrateMourners = new ConditionalStep((QuestHelper)this, this.talkToOmartToReturnToWest, new Requirement[0]);
        infiltrateMourners.addStep(new Conditions(this.key, this.upstairsInMournerBuilding), this.searchCrateForDistillator);
        infiltrateMourners.addStep(this.upstairsInMournerBuilding, this.killMourner);
        infiltrateMourners.addStep(this.inMournerBuilding, this.goUpstairsInMournerBuilding);
        infiltrateMourners.addStep(new Conditions(this.inWestArdougne, this.medicalGown), this.enterMournerHeadquarters);
        infiltrateMourners.addStep(new Conditions(this.inWestArdougne, new ObjectCondition(2063)), this.searchSarahsCupboard2);
        infiltrateMourners.addStep(this.inWestArdougne, this.searchSarahsCupboard);
        steps.put(6, infiltrateMourners);
        ConditionalStep returnToElenaWithDistillator = new ConditionalStep((QuestHelper)this, this.talkToOmartToReturnToWest, new Requirement[0]);
        returnToElenaWithDistillator.addStep(new Conditions(this.upstairsInMournerBuilding, this.distillator), this.goBackDownstairsInMournersHeadquarters);
        returnToElenaWithDistillator.addStep(new Conditions(this.distillator, this.inWestArdougne), this.talkToKilron);
        returnToElenaWithDistillator.addStep(this.distillator, this.talkToElenaWithDistillator);
        returnToElenaWithDistillator.addStep(new Conditions(this.key, this.upstairsInMournerBuilding), this.searchCrateForDistillator);
        returnToElenaWithDistillator.addStep(this.upstairsInMournerBuilding, this.killMourner);
        returnToElenaWithDistillator.addStep(this.inMournerBuilding, this.goUpstairsInMournerBuilding);
        returnToElenaWithDistillator.addStep(new Conditions(this.inWestArdougne, this.medicalGown), this.enterMournerHeadquarters);
        returnToElenaWithDistillator.addStep(new Conditions(this.inWestArdougne, new ObjectCondition(2063)), this.searchSarahsCupboard2);
        returnToElenaWithDistillator.addStep(this.inWestArdougne, this.searchSarahsCupboard);
        steps.put(7, returnToElenaWithDistillator);
        steps.put(10, this.talkToTheChemist);
        ConditionalStep smuggleInChemicals = new ConditionalStep((QuestHelper)this, this.goToVarrock, new Requirement[0]);
        smuggleInChemicals.addStep(new Conditions(this.inVarrockSouthEast, this.liquidHoney, this.ethenea, this.sulphuricBroline, this.hasPriestSet), this.talkToGuidor);
        smuggleInChemicals.addStep(new Conditions(this.inVarrockSouthEast, this.liquidHoney, this.ethenea, this.sulphuricBroline), this.talkToAsyff);
        smuggleInChemicals.addStep(new Conditions(this.inVarrockSouthEast, this.liquidHoney, this.ethenea), this.hopsVarrock);
        smuggleInChemicals.addStep(new Conditions(this.inVarrockSouthEast, this.liquidHoney), this.vinciVarrock);
        smuggleInChemicals.addStep(this.inVarrockSouthEast, this.chancyVarrock);
        smuggleInChemicals.addStep(this.hasChemicals, this.giveChemicals);
        steps.put(12, smuggleInChemicals);
        steps.put(14, this.returnToElenaAfterSampling);
        ConditionalStep talkToTheKing = new ConditionalStep((QuestHelper)this, this.informTheKingGoUpstairs, new Requirement[0]);
        talkToTheKing.addStep(this.isUpstairsArdougneCastle, this.informTheKing);
        steps.put(15, talkToTheKing);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.gasMask = new ItemRequirement("Gas mask", 1506, 1, true).isNotConsumed();
        this.gasMask.setTooltip("You can get another from the cupboard in Edmond's house west of Elena's house.");
        this.birdCage = new ItemRequirement("Pigeon cage", 424);
        this.birdCageHighlighted = new ItemRequirement("Pigeon cage", 424);
        this.birdCageHighlighted.setHighlightInInventory(true);
        this.birdFeed = new ItemRequirement("Bird feed", 422);
        this.rottenApple = new ItemRequirement("Rotten apple", 1984);
        this.rottenApple.setHighlightInInventory(true);
        this.medicalGown = new ItemRequirement("Medical gown", 430).isNotConsumed();
        this.medicalGownEquipped = new ItemRequirement("Medical gown", 430, 1, true);
        this.key = new ItemRequirement("Key", 423);
        this.distillator = new ItemRequirement("Distillator", 420);
        this.plagueSample = new ItemRequirement("Plague sample", 418);
        this.plagueSample.setTooltip("You can get another from Elena in East Ardougne.");
        this.ethenea = new ItemRequirement("Ethenea", 415);
        this.ethenea.setTooltip("You can get another from Elena in East Ardougne.");
        this.liquidHoney = new ItemRequirement("Liquid honey", 416);
        this.liquidHoney.setTooltip("You can get another from Elena in East Ardougne.");
        this.sulphuricBroline = new ItemRequirement("Sulphuric broline", 417);
        this.sulphuricBroline.setTooltip("You can get another from Elena in East Ardougne.");
        this.touchPaper = new ItemRequirement("Touch paper", 419);
        this.touchPaper.setTooltip("You can get more from the Chemist in Rimmington.");
        this.priestGownBottom = new ItemRequirement("Priest gown (bottom)", 428).isNotConsumed();
        this.priestGownTop = new ItemRequirement("Priest gown (top)", 426).isNotConsumed();
        this.priestGownBottomEquipped = this.priestGownBottom.equipped();
        this.priestGownTopEquipped = this.priestGownTop.equipped();
        this.teleportVarrock = new ItemRequirement("Teleport to Varrock", 8007);
        this.teleportArdougne = new ItemRequirement("Teleport to Ardougne", 8011, 3);
        this.teleportRimmington = new ItemRequirement("Teleport to Rimmington", 11741);
        this.coins = new ItemRequirement("Coins", ItemCollections.COINS, 30);
    }

    public void loadZones() {
        this.mournerBackyard = new Zone(new WorldPoint(2542, 3328, 0), new WorldPoint(2555, 3333, 0));
        this.westArdougne1 = new Zone(new WorldPoint(2460, 3279, 0), new WorldPoint(2556, 3334, 2));
        this.westArdougne2 = new Zone(new WorldPoint(2434, 3305, 0), new WorldPoint(2464, 3323, 2));
        this.westArdougne3 = new Zone(new WorldPoint(2510, 3265, 0), new WorldPoint(2556, 3280, 2));
        this.mournerBuilding1 = new Zone(new WorldPoint(2547, 3321, 0), new WorldPoint(2555, 3327, 0));
        this.mournerBuilding2 = new Zone(new WorldPoint(2542, 3324, 0), new WorldPoint(2546, 3327, 0));
        this.mournersBuildingUpstairs = new Zone(new WorldPoint(2542, 3321, 1), new WorldPoint(2555, 3327, 1));
        this.varrockSouthEast = new Zone(new WorldPoint(3265, 3376, 0), new WorldPoint(3287, 3407, 1));
        this.upstairsArdougneCastle = new Zone(new WorldPoint(2570, 3283, 1), new WorldPoint(2590, 3310, 1));
    }

    public void setupConditions() {
        this.inWestArdougne = new ZoneRequirement(this.westArdougne1, this.westArdougne2, this.westArdougne3);
        this.inMournerBackyard = new ZoneRequirement(this.mournerBackyard);
        this.inMournerBuilding = new ZoneRequirement(this.mournerBuilding1, this.mournerBuilding2);
        this.upstairsInMournerBuilding = new ZoneRequirement(this.mournersBuildingUpstairs);
        this.hasChemicals = new Conditions(LogicType.OR, this.ethenea, this.liquidHoney, this.sulphuricBroline);
        this.inVarrockSouthEast = new ZoneRequirement(this.varrockSouthEast);
        this.hasPriestSet = new ItemRequirements(this.priestGownBottom, this.priestGownTop);
        this.isUpstairsArdougneCastle = new ZoneRequirement(this.upstairsArdougneCastle);
    }

    public void setupSteps() {
        this.talkToElena = new NpcStep((QuestHelper)this, 1102, new WorldPoint(2592, 3336, 0), "Talk to Elena in her house west of the northern Ardougne bank.", new Requirement[0]);
        this.talkToElena.addDialogStep("Yes.");
        this.talkToJerico = new NpcStep((QuestHelper)this, 1145, new WorldPoint(2612, 3324, 0), "Talk to Jerico in his house south of the northern Ardougne bank", new Requirement[0]);
        this.getBirdFeed = new ObjectStep((QuestHelper)this, 2056, new WorldPoint(2612, 3326, 0), "Get birdfeed from the cupboard in Jerico's house.", new Requirement[0]);
        this.getBirdFeed2 = new ObjectStep((QuestHelper)this, 2057, new WorldPoint(2612, 3326, 0), "Get birdfeed from the cupboard in Jerico's house.", new Requirement[0]);
        this.getBirdFeed.addSubSteps(this.getBirdFeed2);
        this.getPigeonCage = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2618, 3325, 0), "Get a pigeon cage from behind Jerico's house.", this.birdCage, this.birdFeed);
        this.investigateWatchtower = new ObjectStep((QuestHelper)this, 35947, new WorldPoint(2562, 3301, 0), "Investigate the watchtower near the entrance to West Ardougne.", this.birdFeed, this.birdCage);
        this.clickPigeonCage = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2562, 3300, 0), "Open the Pigeon cage next to the watchtower.", this.birdCageHighlighted);
        this.talkToOmartAgain = new NpcStep((QuestHelper)this, 9002, new WorldPoint(2559, 3266, 0), "Talk to Omart to enter West Ardougne.", this.gasMask);
        this.talkToOmartAgain.addDialogStep("Okay, lets do it.");
        this.talkToOmartToReturnToWest = new NpcStep((QuestHelper)this, 9002, new WorldPoint(2559, 3266, 0), "Talk to Omart to return to West Ardougne", new Requirement[0]);
        this.talkToOmartToReturnToWest.addDialogStep("Okay, lets do it.");
        this.talkToOmartAgain.addSubSteps(this.talkToOmartToReturnToWest);
        this.enterBackyardOfHeadquarters = new ObjectStep((QuestHelper)this, 2068, new WorldPoint(2541, 3331, 0), "Squeeze through the fence to enter the Mourner's Headquarters yard in the north east of West Ardougne.", new Requirement[0]);
        this.pickupRottenApple = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2549, 3332, 0), "Pick up the rotten apple in the yard.", this.rottenApple);
        this.useRottenAppleOnCauldron = new ObjectStep((QuestHelper)this, 37327, new WorldPoint(2543, 3332, 0), "Use the rotten apple on the cauldron.", this.rottenApple);
        this.useRottenAppleOnCauldron.addIcon(1984);
        this.searchSarahsCupboard = new ObjectStep((QuestHelper)this, 2062, new WorldPoint(2518, 3276, 0), "Search the cupboard in Sarah's house south-west of the West Ardougne church.", new Requirement[0]);
        this.searchSarahsCupboard2 = new ObjectStep((QuestHelper)this, 2063, new WorldPoint(2518, 3276, 0), "Search the cupboard in Sarah's house south-west of the West Ardougne church.", new Requirement[0]);
        this.searchSarahsCupboard.addSubSteps(this.searchSarahsCupboard2);
        this.enterMournerHeadquarters = new ObjectStep((QuestHelper)this, 2036, new WorldPoint(2551, 3320, 0), "Enter the Mourners' Headquarters whilst wearing the medical gown.", this.medicalGownEquipped);
        this.goUpstairsInMournerBuilding = new ObjectStep((QuestHelper)this, 16671, new WorldPoint(2543, 3325, 0), "Go upstairs and kill the mourner there.", new Requirement[0]);
        this.killMourner = new NpcStep((QuestHelper)this, 9008, new WorldPoint(2549, 3325, 1), "Kill the mourner here for a key to the caged area.", new Requirement[0]);
        this.goUpstairsInMournerBuilding.addSubSteps(this.killMourner);
        this.searchCrateForDistillator = new ObjectStep((QuestHelper)this, 2064, new WorldPoint(2554, 3327, 1), "Search the crate in the caged area for Elena's Distillator.", new Requirement[0]);
        this.goBackDownstairsInMournersHeadquarters = new ObjectStep((QuestHelper)this, 16673, new WorldPoint(2543, 3325, 1), "Return to Elena. Go back downstairs or teleport out.", new Requirement[0]);
        this.talkToKilron = new NpcStep((QuestHelper)this, 9001, new WorldPoint(2556, 3266, 0), "Return to Elena. Talk to Kilron to return back to East Ardougne.", new Requirement[0]);
        this.talkToKilron.addDialogStep("Yes I do.");
        this.talkToElenaWithDistillator = new NpcStep((QuestHelper)this, 1102, new WorldPoint(2592, 3336, 0), "Return to Elena.", new Requirement[0]);
        this.talkToElenaWithDistillator.addSubSteps(this.goBackDownstairsInMournersHeadquarters, this.talkToKilron);
        this.talkToTheChemist = new NpcStep((QuestHelper)this, 1146, new WorldPoint(2933, 3210, 0), "Take the Plague Sample to the Chemist in Rimmington. You can take a boat from Ardougne Dock to Rimmington for 30gp.", this.plagueSample, this.liquidHoney, this.sulphuricBroline, this.ethenea);
        this.talkToTheChemist.addDialogStep("Your quest.");
        this.giveChemicals = new GiveIngredientsToHelpersStep(this);
        this.goToVarrock = new DetailedQuestStep((QuestHelper)this, new WorldPoint(3270, 3390, 0), "Go speak to Hops, Da Vinci and Chancy in the pub in the south east of Varrock. If you lost any of the chemicals, return to Elena to get more.", this.plagueSample, this.touchPaper);
        this.vinciVarrock = new NpcStep((QuestHelper)this, 1104, new WorldPoint(3270, 3390, 0), "Talk to Da Vinci for the Ethenea.", new Requirement[0]);
        this.hopsVarrock = new NpcStep((QuestHelper)this, 1108, new WorldPoint(3270, 3390, 0), "Talk to Hops for the Sulphuric Broline.", new Requirement[0]);
        this.chancyVarrock = new NpcStep((QuestHelper)this, 1106, new WorldPoint(3270, 3390, 0), "Talk to Chancy for the Liquid honey.", new Requirement[0]);
        this.goToVarrock.addSubSteps(this.vinciVarrock, this.hopsVarrock, this.chancyVarrock);
        this.talkToAsyff = new NpcStep((QuestHelper)this, 2887, new WorldPoint(3277, 3397, 0), "Talk to Asyff to get a free priest gown. You can only get the free set once.", new Requirement[0]);
        this.talkToAsyff.addDialogStep("Do you have a spare Priest Gown?");
        this.talkToGuidor = new NpcStep((QuestHelper)this, 1110, new WorldPoint(3284, 3382, 0), "Talk to Guidor in his house to the south.", this.priestGownBottomEquipped, this.priestGownTopEquipped, this.plagueSample, this.sulphuricBroline, this.liquidHoney, this.ethenea, this.touchPaper);
        this.talkToGuidor.addDialogStep("I've come to ask your assistance in stopping a plague.");
        this.returnToElenaAfterSampling = new NpcStep((QuestHelper)this, 1102, new WorldPoint(2592, 3336, 0), "Return to Elena and inform her that the plague is a hoax.", new Requirement[0]);
        this.informTheKing = new NpcStep((QuestHelper)this, 9005, new WorldPoint(2578, 3293, 1), "Tell King Lathas that the Plague is a hoax.", new Requirement[0]);
        this.informTheKingGoUpstairs = new ObjectStep((QuestHelper)this, 15645, new WorldPoint(2572, 3296, 0), "Tell King Lathas that the Plague is a hoax.", new Requirement[0]);
        this.informTheKing.addSubSteps(this.informTheKingGoUpstairs);
    }

    @Override
    public List<String> getCombatRequirements() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("Mourner (level 13)");
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.gasMask);
        return reqs;
    }

    @Override
    public List<ItemRequirement> getItemRecommended() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.teleportArdougne);
        reqs.add(this.teleportRimmington);
        reqs.add(this.teleportVarrock);
        reqs.add(this.coins);
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(3);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Collections.singletonList(new ExperienceReward(Skill.THIEVING, 1250));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Start the quest", Collections.singletonList(this.talkToElena), this.gasMask));
        allSteps.add(new PanelDetails("Getting back into West Ardougne", Arrays.asList(this.talkToJerico, this.getBirdFeed, this.getPigeonCage, this.investigateWatchtower, this.clickPigeonCage, this.talkToOmartAgain), new Requirement[0]));
        allSteps.add(new PanelDetails("Getting the Distillator", this.enterBackyardOfHeadquarters, this.pickupRottenApple, this.useRottenAppleOnCauldron, this.searchSarahsCupboard, this.enterMournerHeadquarters, this.goUpstairsInMournerBuilding, this.searchCrateForDistillator, this.talkToElenaWithDistillator));
        List<QuestStep> testingSteps = QuestUtil.toArrayList(this.talkToTheChemist);
        testingSteps.addAll(this.giveChemicals.getDisplaySteps());
        testingSteps.addAll(Arrays.asList(this.goToVarrock, this.talkToAsyff, this.talkToGuidor));
        allSteps.add(new PanelDetails("Testing the plague sample", testingSteps, this.plagueSample, this.liquidHoney, this.ethenea, this.sulphuricBroline));
        allSteps.add(new PanelDetails("Revealing the truth", this.returnToElenaAfterSampling, this.informTheKing));
        return allSteps;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> requirements = new ArrayList<Requirement>();
        requirements.add(new QuestRequirement(QuestHelperQuest.PLAGUE_CITY, QuestState.FINISHED));
        return requirements;
    }
}

