/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.bigchompybirdhunting;

import com.questhelper.collections.ItemCollections;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.npc.DialogRequirement;
import com.questhelper.requirements.npc.NpcHintArrowRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.BIG_CHOMPY_BIRD_HUNTING)
public class BigChompyBirdHunting
extends BasicQuestHelper {
    ItemRequirement axe;
    ItemRequirement feathers;
    ItemRequirement knife;
    ItemRequirement hammer;
    ItemRequirement chisel;
    ItemRequirement wolfBones4;
    ItemRequirement acheyLogs;
    ItemRequirement chompy;
    ItemRequirement bloatedToad;
    ItemRequirement knifeHighlighted;
    ItemRequirement feathersHighlighted;
    ItemRequirement shaftsHighlighted;
    ItemRequirement wolfBonesHighlighted;
    ItemRequirement tipsHighlighted;
    ItemRequirement flightedArrowsHighlighted;
    ItemRequirement emptyBellow;
    ItemRequirement fullBellow;
    ItemRequirement ogreArrows6Highlighted;
    ItemRequirement ogreArrows;
    ItemRequirement ogreBow;
    ItemRequirement ogreBowInventory;
    ItemRequirement onion;
    ItemRequirement tomato;
    ItemRequirement potato;
    ItemRequirement doogle;
    ItemRequirement equa;
    ItemRequirement cabbage;
    ItemRequirement chompyHighlighted;
    ItemRequirement seasonedChompy;
    ItemRequirement seasonedChompyHighlighted;
    ItemRequirement bellow;
    Requirement inCave;
    Requirement chompyNearby;
    Requirement deadChompyNearby;
    Requirement rantzWantsOnion;
    Requirement rantzWantsPotato;
    Requirement knowWhatRantzWants;
    Requirement bugsWantsEqua;
    Requirement bugsWantsCabbage;
    Requirement knowWhatBugsWants;
    Requirement fycieWantsDoogle;
    Requirement fycieWantsTomato;
    Requirement knowWhatFycieWants;
    Requirement hasRantzItem;
    Requirement hasFycieItem;
    Requirement hasBugsItem;
    DetailedQuestStep talkToRantz;
    DetailedQuestStep getLogs;
    DetailedQuestStep makeShafts;
    DetailedQuestStep useFeathersOnShafts;
    DetailedQuestStep useChiselOnBones;
    DetailedQuestStep useTipsOnShafts;
    DetailedQuestStep useArrowsOnRantz;
    DetailedQuestStep askRantzQuestions;
    DetailedQuestStep enterCave;
    DetailedQuestStep getBellow;
    DetailedQuestStep leaveCave;
    DetailedQuestStep fillBellows;
    DetailedQuestStep inflateToad;
    DetailedQuestStep talkToRantzWithToad;
    DetailedQuestStep dropToad;
    DetailedQuestStep waitForChompy;
    DetailedQuestStep talkToRantzForBow;
    DetailedQuestStep placeAnotherToad;
    DetailedQuestStep killChompy;
    DetailedQuestStep pluckCarcass;
    DetailedQuestStep talkToRantzWithChompy;
    DetailedQuestStep enterCaveAgain;
    DetailedQuestStep talkToFycie;
    DetailedQuestStep talkToBugs;
    DetailedQuestStep leaveCaveAgain;
    DetailedQuestStep getPotato;
    DetailedQuestStep getOnion;
    DetailedQuestStep getTomato;
    DetailedQuestStep getEqua;
    DetailedQuestStep getDoogle;
    DetailedQuestStep getCabbage;
    DetailedQuestStep getIngredients;
    DetailedQuestStep cookChompy;
    DetailedQuestStep giveRantzSeasonedChompy;
    Zone cave;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        steps.put(0, this.talkToRantz);
        ConditionalStep makeArrows = new ConditionalStep((QuestHelper)this, (QuestStep)this.getLogs, new Requirement[0]);
        makeArrows.addStep(this.ogreArrows6Highlighted, this.useArrowsOnRantz);
        makeArrows.addStep(new Conditions(this.flightedArrowsHighlighted, this.tipsHighlighted), this.useTipsOnShafts);
        makeArrows.addStep(this.flightedArrowsHighlighted, this.useChiselOnBones);
        makeArrows.addStep(this.shaftsHighlighted, this.useFeathersOnShafts);
        makeArrows.addStep(this.acheyLogs, this.makeShafts);
        steps.put(5, makeArrows);
        steps.put(10, this.askRantzQuestions);
        ConditionalStep goGetBellows = new ConditionalStep((QuestHelper)this, (QuestStep)this.enterCave, new Requirement[0]);
        goGetBellows.addStep(this.inCave, this.getBellow);
        steps.put(15, goGetBellows);
        ConditionalStep goInflateToad = new ConditionalStep((QuestHelper)this, (QuestStep)this.fillBellows, new Requirement[0]);
        goInflateToad.addStep(new Conditions(this.inCave, this.bellow), this.leaveCave);
        goInflateToad.addStep(this.inCave, this.getBellow);
        goInflateToad.addStep(this.bloatedToad, this.talkToRantzWithToad);
        goInflateToad.addStep(this.fullBellow, this.inflateToad);
        steps.put(20, goInflateToad);
        steps.put(25, this.dropToad);
        steps.put(30, this.waitForChompy);
        steps.put(35, this.waitForChompy);
        steps.put(40, this.talkToRantzForBow);
        ConditionalStep getChompy = new ConditionalStep((QuestHelper)this, (QuestStep)this.placeAnotherToad, new Requirement[0]);
        getChompy.addStep(this.chompyNearby, this.killChompy);
        steps.put(45, getChompy);
        ConditionalStep bringChompyToRantz = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToRantzWithChompy, new Requirement[0]);
        bringChompyToRantz.addStep(this.deadChompyNearby, this.pluckCarcass);
        steps.put(50, bringChompyToRantz);
        ConditionalStep seasonChompy = new ConditionalStep((QuestHelper)this, (QuestStep)this.talkToRantzWithChompy, new Requirement[0]);
        seasonChompy.addStep(new Conditions(this.knowWhatFycieWants, this.knowWhatBugsWants, this.inCave), this.leaveCave);
        seasonChompy.addStep(new Conditions(this.hasFycieItem, this.hasBugsItem, this.hasRantzItem), this.cookChompy);
        seasonChompy.addStep(new Conditions(this.fycieWantsTomato, this.hasBugsItem, this.hasRantzItem), this.getTomato);
        seasonChompy.addStep(new Conditions(this.fycieWantsDoogle, this.hasBugsItem, this.hasRantzItem), this.getDoogle);
        seasonChompy.addStep(new Conditions(this.knowWhatFycieWants, this.bugsWantsCabbage, this.hasRantzItem), this.getCabbage);
        seasonChompy.addStep(new Conditions(this.knowWhatFycieWants, this.bugsWantsEqua, this.hasRantzItem), this.getEqua);
        seasonChompy.addStep(new Conditions(this.knowWhatFycieWants, this.knowWhatBugsWants, this.rantzWantsOnion), this.getOnion);
        seasonChompy.addStep(new Conditions(this.knowWhatFycieWants, this.knowWhatBugsWants, this.rantzWantsPotato), this.getPotato);
        seasonChompy.addStep(new Conditions(this.knowWhatBugsWants, this.inCave), this.talkToFycie);
        seasonChompy.addStep(new Conditions(this.inCave), this.talkToBugs);
        seasonChompy.addStep(this.knowWhatRantzWants, this.enterCaveAgain);
        steps.put(55, seasonChompy);
        steps.put(60, this.giveRantzSeasonedChompy);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.axe = new ItemRequirement("Any axe", ItemCollections.AXES).isNotConsumed();
        this.feathers = new ItemRequirement("Feathers", 314, 100);
        this.knife = new ItemRequirement("Knife", 946).isNotConsumed();
        this.hammer = new ItemRequirement("Hammer", ItemCollections.HAMMER).isNotConsumed();
        this.chisel = new ItemRequirement("Chisel", 1755).isNotConsumed();
        this.chisel.setHighlightInInventory(true);
        this.wolfBones4 = new ItemRequirement("Wolf bones", 2859, 4);
        this.wolfBones4.setTooltip("You can kill wolves (level 64) around Feldip for bones");
        this.acheyLogs = new ItemRequirement("Achey tree logs", 2862);
        this.acheyLogs.setHighlightInInventory(true);
        this.chompy = new ItemRequirement("Raw chompy", 2876);
        this.chompyHighlighted = new ItemRequirement("Raw chompy", 2876);
        this.chompyHighlighted.setHighlightInInventory(true);
        this.bloatedToad = new ItemRequirement("Bloated toad", 2875);
        this.knifeHighlighted = new ItemRequirement("Knife", 946);
        this.knifeHighlighted.setHighlightInInventory(true);
        this.feathersHighlighted = new ItemRequirement("Feathers", 314);
        this.feathersHighlighted.setHighlightInInventory(true);
        this.shaftsHighlighted = new ItemRequirement("Ogre arrow shafts (make more for later)", 2864, 6);
        this.shaftsHighlighted.setHighlightInInventory(true);
        this.wolfBonesHighlighted = new ItemRequirement("Wolf bones", 2859);
        this.wolfBonesHighlighted.setHighlightInInventory(true);
        this.tipsHighlighted = new ItemRequirement("Wolfbone arrowtips", 2861);
        this.tipsHighlighted.setHighlightInInventory(true);
        this.flightedArrowsHighlighted = new ItemRequirement("Flighted ogre arrow", 2865);
        this.flightedArrowsHighlighted.setHighlightInInventory(true);
        this.ogreArrows6Highlighted = new ItemRequirement("Ogre arrow", 2866, 6);
        this.ogreArrows6Highlighted.setHighlightInInventory(true);
        this.ogreArrows = new ItemRequirement("Ogre arrow", 2866, 1, true);
        this.ogreBow = new ItemRequirement("Ogre bow", 2883, 1, true).isNotConsumed();
        this.ogreBowInventory = new ItemRequirement("Ogre bow", 2883).isNotConsumed();
        this.emptyBellow = new ItemRequirement("Ogre bellows (empty)", 2871);
        this.emptyBellow.setTooltip("You can get more from the chest in Rantz's cave");
        this.emptyBellow.setHighlightInInventory(true);
        this.fullBellow = new ItemRequirement("Ogre bellows", 2874);
        this.fullBellow.addAlternates(2873, 2872);
        this.bellow = new ItemRequirement("Ogre bellows", 2871);
        this.bellow.addAlternates(2874, 2873, 2872);
        this.onion = new ItemRequirement("Onion", 1957);
        this.tomato = new ItemRequirement("Tomato", 1982);
        this.potato = new ItemRequirement("Potato", 1942);
        this.doogle = new ItemRequirement("Doogle leaves", 1573);
        this.equa = new ItemRequirement("Equa leaves", 2128);
        this.cabbage = new ItemRequirement("Cabbage", 1965);
        this.seasonedChompy = new ItemRequirement("Seasoned chompy", 2882);
        this.seasonedChompyHighlighted = new ItemRequirement("Seasoned chompy", 2882);
        this.seasonedChompyHighlighted.setHighlightInInventory(true);
    }

    public void loadZones() {
        this.cave = new Zone(new WorldPoint(2627, 9377, 0), new WorldPoint(2663, 9406, 0));
    }

    public void setupConditions() {
        this.inCave = new ZoneRequirement(this.cave);
        this.chompyNearby = new NpcHintArrowRequirement(1475);
        this.deadChompyNearby = new NpcCondition(1476);
        this.rantzWantsOnion = new Conditions(true, new DialogRequirement("wants Onion wiv mine"));
        this.rantzWantsPotato = new Conditions(true, new DialogRequirement("wants Potato wiv mine"));
        this.knowWhatRantzWants = new Conditions(LogicType.OR, this.rantzWantsOnion, this.rantzWantsPotato);
        this.bugsWantsCabbage = new Conditions(true, new DialogRequirement("has to have cabbage wiv mine"));
        this.bugsWantsEqua = new Conditions(true, new DialogRequirement("has to have equa leaves wiv mine"));
        this.knowWhatBugsWants = new Conditions(LogicType.OR, this.bugsWantsCabbage, this.bugsWantsEqua);
        this.fycieWantsTomato = new Conditions(true, new DialogRequirement("Me's wants tomato wiv mine!"));
        this.fycieWantsDoogle = new Conditions(true, new DialogRequirement("Me's wants doogle leaves wiv mine!"));
        this.knowWhatFycieWants = new Conditions(LogicType.OR, this.fycieWantsTomato, this.fycieWantsDoogle);
        this.hasRantzItem = new Conditions(LogicType.OR, new Conditions(this.rantzWantsOnion, this.onion), new Conditions(this.rantzWantsPotato, this.potato));
        this.hasFycieItem = new Conditions(LogicType.OR, new Conditions(this.fycieWantsDoogle, this.doogle), new Conditions(this.fycieWantsTomato, this.tomato));
        this.hasBugsItem = new Conditions(LogicType.OR, new Conditions(this.bugsWantsCabbage, this.cabbage), new Conditions(this.bugsWantsEqua, this.equa));
    }

    public void setupSteps() {
        this.talkToRantz = new NpcStep((QuestHelper)this, 1470, new WorldPoint(2631, 2982, 0), "Talk to Rantz in the east of Feldip Hills.", new Requirement[0]);
        this.talkToRantz.addDialogStep("Ok, I'll make you some 'stabbers'.");
        this.getLogs = new ObjectStep((QuestHelper)this, 2023, new WorldPoint(2627, 2975, 0), "Get some achey tree logs near Rantz.", this.axe);
        this.makeShafts = new DetailedQuestStep((QuestHelper)this, "Use your knife on the achey logs to make arrow shafts.", this.knifeHighlighted, this.acheyLogs);
        this.useFeathersOnShafts = new DetailedQuestStep((QuestHelper)this, "Use the feathers on the arrow shafts.", this.feathersHighlighted, this.shaftsHighlighted);
        this.useChiselOnBones = new DetailedQuestStep((QuestHelper)this, "Use a chisel on some wolf bones.", this.chisel, this.wolfBonesHighlighted, this.hammer);
        this.useTipsOnShafts = new DetailedQuestStep((QuestHelper)this, "Add the bone arrow tips to the flighted ogre arrows.", this.tipsHighlighted, this.flightedArrowsHighlighted);
        this.useArrowsOnRantz = new NpcStep((QuestHelper)this, 1470, new WorldPoint(2631, 2982, 0), "Use at least 6 ogre arrows on Rantz.", this.ogreArrows6Highlighted);
        this.useArrowsOnRantz.addIcon(2866);
        this.askRantzQuestions = new NpcStep((QuestHelper)this, 1470, new WorldPoint(2631, 2982, 0), "Ask Rantz all the available questions.", new Requirement[0]);
        this.askRantzQuestions.addDialogStep("How do we make the chompys come?");
        this.enterCave = new ObjectStep((QuestHelper)this, 3379, new WorldPoint(2630, 2999, 0), "Enter Rantz's cave.", new Requirement[0]);
        this.getBellow = new ObjectStep((QuestHelper)this, 3377, new WorldPoint(2638, 9398, 0), "Open the chest in the cave for some ogre bellows.", new Requirement[0]);
        ((ObjectStep)this.getBellow).addAlternateObjects(3378);
        this.leaveCave = new ObjectStep((QuestHelper)this, 3381, new WorldPoint(2647, 9377, 0), "Leave the cave.", new Requirement[0]);
        this.fillBellows = new ObjectStep((QuestHelper)this, 684, new WorldPoint(2601, 2967, 0), "Fill the bellows on swamp bubbles.", this.emptyBellow);
        this.inflateToad = new NpcStep((QuestHelper)this, 1473, new WorldPoint(2602, 2967, 0), "Inflate 3 toads near the swamp.", this.fullBellow);
        this.talkToRantzWithToad = new NpcStep((QuestHelper)this, 1470, new WorldPoint(2631, 2982, 0), "Bring the toads to Rantz.", this.bloatedToad);
        this.dropToad = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2635, 2967, 0), "Drop the bloated toad in the clearing south of Rantz.", new Requirement[0]);
        this.waitForChompy = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2635, 2967, 0), "Wait for a chompy to spawn. If the frog despawns, you'll need to place another one in the clearing south of Rantz.", new Requirement[0]);
        this.talkToRantzForBow = new NpcStep((QuestHelper)this, 1470, new WorldPoint(2631, 2982, 0), "Talk to Rantz again for an ogre bow.", new Requirement[0]);
        this.talkToRantzForBow.addDialogSteps("Come on, let me have a go...", "I'm actually quite strong...please let me try.");
        this.placeAnotherToad = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2635, 2967, 0), "Drop another bloated toad in the clearing south of Rantz, and wait for a chompy to come.", this.ogreBow, this.ogreArrows);
        this.killChompy = new NpcStep((QuestHelper)this, 1475, new WorldPoint(2635, 2966, 0), "Kill the chompy. You can only hurt it with an ogre bow + ogre arrows.", this.ogreBow, this.ogreArrows);
        this.pluckCarcass = new NpcStep((QuestHelper)this, 1476, new WorldPoint(2635, 2966, 0), "Pluck the chompy.", new Requirement[0]);
        this.talkToRantzWithChompy = new NpcStep((QuestHelper)this, 1470, new WorldPoint(2631, 2982, 0), "Talk to Rantz in the east of Feldip Hills.", this.chompy);
        this.enterCaveAgain = new ObjectStep((QuestHelper)this, 3379, new WorldPoint(2630, 2999, 0), "Enter Rantz's cave.", new Requirement[0]);
        this.talkToFycie = new NpcStep((QuestHelper)this, 1471, new WorldPoint(2649, 9391, 0), "Talk to Fycie.", new Requirement[0]);
        this.talkToBugs = new NpcStep((QuestHelper)this, 1472, new WorldPoint(2640, 9391, 0), "Talk to Bugs.", new Requirement[0]);
        this.leaveCaveAgain = new ObjectStep((QuestHelper)this, 3381, new WorldPoint(2647, 9377, 0), "Leave the cave.", new Requirement[0]);
        this.getPotato = new ObjectStep((QuestHelper)this, 312, new WorldPoint(2642, 2959, 0), "Pick a potato south east of Rantz.", new Requirement[0]);
        this.getOnion = new ObjectStep((QuestHelper)this, 3366, new WorldPoint(2583, 2965, 0), "Pick an onion from west of Rantz.", new Requirement[0]);
        this.getTomato = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2584, 2966, 0), "Get a tomato from west of Rantz.", this.tomato);
        this.getEqua = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2648, 2963, 0), "Get some equa leaves from south east of Rantz.", this.equa);
        this.getDoogle = new DetailedQuestStep((QuestHelper)this, new WorldPoint(2565, 2972, 0), "Get some doogle leaves from west of Rantz.", this.doogle);
        this.getCabbage = new ObjectStep((QuestHelper)this, 1161, new WorldPoint(2572, 2967, 0), "Get some cabbage from west of Rantz.", new Requirement[0]);
        this.getIngredients = new DetailedQuestStep((QuestHelper)this, "Collect the ingredients Rantz and his children want for the chompy.", new Requirement[0]);
        this.getIngredients.addSubSteps(this.getPotato, this.getOnion, this.getTomato, this.getEqua, this.getDoogle, this.getCabbage);
        this.cookChompy = new ObjectStep((QuestHelper)this, 6895, new WorldPoint(2631, 2990, 0), "Cook the chompy on Rantz's spit-roast.", this.chompyHighlighted);
        this.cookChompy.addIcon(2876);
        this.giveRantzSeasonedChompy = new NpcStep((QuestHelper)this, 1470, new WorldPoint(2631, 2982, 0), "Bring Rantz the seasoned chompy to finish the quest.", this.seasonedChompyHighlighted);
        this.giveRantzSeasonedChompy.addIcon(2882);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        return Arrays.asList(this.axe, this.feathers, this.knife, this.hammer, this.chisel, this.wolfBones4);
    }

    @Override
    public List<String> getCombatRequirements() {
        return Collections.singletonList("Chompy");
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.FLETCHING, 262), new ExperienceReward(Skill.COOKING, 1470), new ExperienceReward(Skill.RANGED, 735));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("An Ogre Bow", 2883, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("The ability to fletch Ogre Arrows."), new UnlockReward("The ability to hunt and cook Chompy Birds."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Getting Rantz Arrows", Arrays.asList(this.talkToRantz, this.getLogs, this.makeShafts, this.useFeathersOnShafts, this.useChiselOnBones, this.useTipsOnShafts, this.useArrowsOnRantz), this.axe, this.knife, this.feathers, this.chisel, this.hammer, this.wolfBones4));
        allSteps.add(new PanelDetails("Making Bloated Toads", Arrays.asList(this.askRantzQuestions, this.enterCave, this.getBellow, this.leaveCave, this.fillBellows, this.inflateToad, this.talkToRantzWithToad), new Requirement[0]));
        allSteps.add(new PanelDetails("Hunting Chompy", Arrays.asList(this.dropToad, this.waitForChompy, this.talkToRantzForBow, this.placeAnotherToad, this.killChompy, this.talkToRantzWithChompy), new Requirement[0]));
        allSteps.add(new PanelDetails("Cooking Chompy", Arrays.asList(this.enterCaveAgain, this.talkToBugs, this.talkToFycie, this.leaveCaveAgain, this.getIngredients, this.cookChompy, this.giveRantzSeasonedChompy), new Requirement[0]));
        return allSteps;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new SkillRequirement(Skill.RANGED, 30));
        req.add(new SkillRequirement(Skill.COOKING, 30, true));
        req.add(new SkillRequirement(Skill.FLETCHING, 5, true));
        return req;
    }
}

