/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.betweenarock;

import com.questhelper.QuestHelperPlugin;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.steps.DetailedQuestStep;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.Map;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;

public class PuzzleStep
extends DetailedQuestStep {
    private final int DOWN_BUTTON = 34;
    private final int LEFT_BUTTON = 33;
    private final int RIGHT_BUTTON = 32;
    private final int UP_BUTTON = 31;
    private final int ROTATE_BUTTON = 30;
    private final int HORIZONTAL = 0;
    private final int VERTICAL = 1;
    private final int FLIP = 2;
    private final int ROTATE = 3;
    private final int SELECTED = 4;
    private final int SELECT_BUTTON = 5;
    private final int PIECE_ID = 6;
    private HashMap<Integer, Integer> highlightButtons = new HashMap();
    private final HashMap<Integer, Integer>[] pieces = new HashMap[3];
    private final HashMap<Integer, Integer>[] solvedPieces = new HashMap[3];

    public PuzzleStep(QuestHelper questHelper, ItemRequirement item) {
        super(questHelper, "Click the highlighted boxes to move the pieces to the correct spots.", item);
        this.pieces[0] = new HashMap();
        this.pieces[0].put(6, 11);
        this.pieces[0].put(4, 261);
        this.pieces[0].put(5, 24);
        this.solvedPieces[0] = new HashMap();
        this.solvedPieces[0].put(0, 240);
        this.solvedPieces[0].put(1, 170);
        this.solvedPieces[0].put(3, 1856);
        this.pieces[1] = new HashMap();
        this.pieces[1].put(6, 6);
        this.pieces[1].put(4, 262);
        this.pieces[1].put(5, 25);
        this.solvedPieces[1] = new HashMap();
        this.solvedPieces[1].put(0, 235);
        this.solvedPieces[1].put(1, 170);
        this.solvedPieces[1].put(3, 1860);
        this.pieces[2] = new HashMap();
        this.pieces[2].put(6, 8);
        this.pieces[2].put(4, 263);
        this.pieces[2].put(5, 26);
        this.solvedPieces[2] = new HashMap();
        this.solvedPieces[2].put(0, 235);
        this.solvedPieces[2].put(1, 175);
        this.solvedPieces[2].put(3, 1864);
        this.highlightButtons.put(34, 0);
        this.highlightButtons.put(33, 0);
        this.highlightButtons.put(32, 0);
        this.highlightButtons.put(31, 0);
        this.highlightButtons.put(30, 0);
        int SELECT_1_BUTTON = 23;
        this.highlightButtons.put(SELECT_1_BUTTON, 0);
        int SELECT_2_BUTTON = 25;
        this.highlightButtons.put(SELECT_2_BUTTON, 0);
        int SELECT_3_BUTTON = 26;
        this.highlightButtons.put(SELECT_3_BUTTON, 0);
    }

    @Override
    public void startUp() {
        this.updateSolvedPositionState();
    }

    @Override
    @Subscribe
    public void onGameTick(GameTick event) {
        this.updateSolvedPositionState();
    }

    private void updateSolvedPositionState() {
        HashMap[] piecesCurrentState = new HashMap[3];
        HashMap<Integer, Integer> highlightButtonsTmp = new HashMap<Integer, Integer>();
        Widget widget0 = this.client.getWidget(113, this.pieces[0].get(6).intValue());
        Widget widget1 = this.client.getWidget(113, this.pieces[1].get(6).intValue());
        Widget widget2 = this.client.getWidget(113, this.pieces[2].get(6).intValue());
        piecesCurrentState[0] = new HashMap();
        if (widget0 == null) {
            return;
        }
        piecesCurrentState[0].put(0, widget0.getOriginalX());
        piecesCurrentState[0].put(1, widget0.getOriginalY());
        piecesCurrentState[0].put(3, widget0.getAnimationId());
        if (widget1 == null) {
            return;
        }
        piecesCurrentState[1] = new HashMap();
        piecesCurrentState[1].put(0, widget1.getOriginalX());
        piecesCurrentState[1].put(1, widget1.getOriginalY());
        piecesCurrentState[1].put(3, widget1.getAnimationId());
        if (widget2 == null) {
            return;
        }
        piecesCurrentState[2] = new HashMap();
        piecesCurrentState[2].put(0, widget2.getOriginalX());
        piecesCurrentState[2].put(1, widget2.getOriginalY());
        piecesCurrentState[2].put(3, widget2.getAnimationId());
        int currentPiece = Math.abs((Integer)piecesCurrentState[0].get(0) - this.solvedPieces[0].get(0)) > 4 || Math.abs((Integer)piecesCurrentState[0].get(1) - this.solvedPieces[0].get(1)) > 4 || !((Integer)piecesCurrentState[0].get(3)).equals(this.solvedPieces[0].get(3)) ? 0 : (Math.abs((Integer)piecesCurrentState[1].get(0) - this.solvedPieces[1].get(0)) > 4 || Math.abs((Integer)piecesCurrentState[1].get(1) - this.solvedPieces[1].get(1)) > 4 || !((Integer)piecesCurrentState[1].get(3)).equals(this.solvedPieces[1].get(3)) ? 1 : 2);
        boolean onlyCurrentSelected = true;
        if (this.client.getVarpValue(this.pieces[currentPiece].get(4).intValue()) == 0) {
            highlightButtonsTmp.put(this.pieces[currentPiece].get(5), 1);
            onlyCurrentSelected = false;
        }
        if (this.client.getVarpValue(this.pieces[(currentPiece + 1) % 3].get(4).intValue()) == 1) {
            highlightButtonsTmp.put(this.pieces[(currentPiece + 1) % 3].get(5), 1);
            onlyCurrentSelected = false;
        }
        if (this.client.getVarpValue(this.pieces[Math.floorMod(currentPiece - 1, 3)].get(4).intValue()) == 1) {
            highlightButtonsTmp.put(this.pieces[Math.floorMod(currentPiece - 1, 3)].get(5), 1);
            onlyCurrentSelected = false;
        }
        if (onlyCurrentSelected) {
            if (!((Integer)piecesCurrentState[currentPiece].get(3)).equals(this.solvedPieces[currentPiece].get(3))) {
                highlightButtonsTmp.put(30, 1);
            } else if ((Integer)piecesCurrentState[currentPiece].get(0) < this.solvedPieces[currentPiece].get(0) - 4) {
                highlightButtonsTmp.put(32, 1);
            } else if ((Integer)piecesCurrentState[currentPiece].get(0) > this.solvedPieces[currentPiece].get(0) + 4) {
                highlightButtonsTmp.put(33, 1);
            } else if ((Integer)piecesCurrentState[currentPiece].get(1) > this.solvedPieces[currentPiece].get(1) + 4) {
                highlightButtonsTmp.put(31, 1);
            } else if ((Integer)piecesCurrentState[currentPiece].get(1) < this.solvedPieces[currentPiece].get(1) - 4) {
                highlightButtonsTmp.put(34, 1);
            }
        }
        this.highlightButtons = highlightButtonsTmp;
    }

    @Override
    public void makeWidgetOverlayHint(Graphics2D graphics, QuestHelperPlugin plugin) {
        super.makeWidgetOverlayHint(graphics, plugin);
        for (Map.Entry<Integer, Integer> entry : this.highlightButtons.entrySet()) {
            Widget widget;
            if (entry.getValue() == 0 || (widget = this.client.getWidget(114, entry.getKey().intValue())) == null) continue;
            graphics.setColor(new Color(this.getQuestHelper().getConfig().targetOverlayColor().getRed(), this.getQuestHelper().getConfig().targetOverlayColor().getGreen(), this.getQuestHelper().getConfig().targetOverlayColor().getBlue(), 65));
            graphics.fill(widget.getBounds());
            graphics.setColor(this.questHelper.getConfig().targetOverlayColor());
            graphics.draw(widget.getBounds());
        }
    }
}

