/*
 * Decompiled with CFR 0.152.
 */
package com.questhelper.helpers.quests.betweenarock;

import com.questhelper.bank.banktab.BankSlotIcons;
import com.questhelper.collections.ItemCollections;
import com.questhelper.helpers.quests.betweenarock.PuzzleStep;
import com.questhelper.panel.PanelDetails;
import com.questhelper.questhelpers.BasicQuestHelper;
import com.questhelper.questhelpers.QuestHelper;
import com.questhelper.questinfo.QuestDescriptor;
import com.questhelper.questinfo.QuestHelperQuest;
import com.questhelper.requirements.Requirement;
import com.questhelper.requirements.conditional.Conditions;
import com.questhelper.requirements.conditional.NpcCondition;
import com.questhelper.requirements.item.ItemRequirement;
import com.questhelper.requirements.player.SkillRequirement;
import com.questhelper.requirements.quest.QuestRequirement;
import com.questhelper.requirements.util.LogicType;
import com.questhelper.requirements.var.VarbitRequirement;
import com.questhelper.requirements.zone.Zone;
import com.questhelper.requirements.zone.ZoneRequirement;
import com.questhelper.rewards.ExperienceReward;
import com.questhelper.rewards.ItemReward;
import com.questhelper.rewards.QuestPointReward;
import com.questhelper.rewards.UnlockReward;
import com.questhelper.steps.ConditionalStep;
import com.questhelper.steps.DetailedQuestStep;
import com.questhelper.steps.NpcStep;
import com.questhelper.steps.ObjectStep;
import com.questhelper.steps.QuestStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;

@QuestDescriptor(quest=QuestHelperQuest.BETWEEN_A_ROCK)
public class BetweenARock
extends BasicQuestHelper {
    ItemRequirement coins5;
    ItemRequirement pickaxe;
    ItemRequirement page1;
    ItemRequirement page2;
    ItemRequirement page3;
    ItemRequirement pages;
    ItemRequirement dwarvenLore;
    ItemRequirement dwarvenLoreHighlight;
    ItemRequirement goldBar;
    ItemRequirement goldBarHighlight;
    ItemRequirement goldCannonball;
    ItemRequirement cannonMould;
    ItemRequirement goldCannonballHighlight;
    ItemRequirement schematic;
    ItemRequirement baseSchematic;
    ItemRequirement schematicEngineer;
    ItemRequirement khorvakSchematic;
    ItemRequirement goldHelmet;
    ItemRequirement hammer;
    ItemRequirement goldBars3;
    ItemRequirement schematicHighlight;
    ItemRequirement solvedSchematic;
    ItemRequirement combatGear;
    ItemRequirement goldOre6;
    ItemRequirement goldBars4;
    ItemRequirement coins1000;
    ItemRequirement goldHelmetEquipped;
    ItemRequirement food;
    Requirement inTrollRoom;
    Requirement inDwarfEntrance;
    Requirement inDwarfMine;
    Requirement inKeldagrim;
    Requirement inDwarvenMine;
    Requirement hasUsedGoldBar;
    Requirement hasCannonball;
    Requirement shotGoldCannonball;
    Requirement inKhorvakRoom;
    Requirement inRealm;
    Requirement avatarNearby;
    Requirement hasSolvedSchematic;
    QuestStep enterDwarfCave;
    QuestStep enterDwarfCave2;
    QuestStep talkToFerryman;
    QuestStep talkToDondakan;
    QuestStep travelBackWithFerryman;
    QuestStep talkToBoatman;
    QuestStep talkToEngineer;
    QuestStep talkToRolad;
    QuestStep enterDwarvenMine;
    QuestStep killScorpion;
    QuestStep searchCart;
    ObjectStep mineRock;
    QuestStep goBackUpToRolad;
    QuestStep returnToRolad;
    QuestStep readEntireBook;
    QuestStep travelToKeldagrim;
    QuestStep enterDwarfCaveWithBook;
    QuestStep enterDwarfCave2WithBook;
    QuestStep talkToFerrymanWithBook;
    QuestStep talkToDondakanWithBook;
    QuestStep useGoldBarOnDondakan;
    QuestStep makeGoldCannonball;
    QuestStep enterDwarfCaveWithCannonball;
    QuestStep enterDwarfCave2WithCannonball;
    QuestStep talkToFerrymanWithCannonball;
    QuestStep useGoldCannonballOnDondakan;
    QuestStep talkToDondakanAfterShot;
    QuestStep readBookAgain;
    QuestStep talkToEngineerAgain;
    QuestStep travelBackWithFerrymanAgain;
    QuestStep travelToKeldagrimAgain;
    QuestStep talkToBoatmanAgain;
    QuestStep useGoldBarOnAnvil;
    QuestStep enterKhorvakRoom;
    QuestStep talkToKhorvak;
    QuestStep assembleSchematic;
    QuestStep enterDwarfCaveWithHelmet;
    QuestStep enterDwarfCave2WithHelmet;
    QuestStep talkToFerrymanWithHelmet;
    QuestStep talkToDondakanWithHelmet;
    QuestStep mine6GoldOre;
    QuestStep talkToDondakanForEnd;
    QuestStep talkToSecondFlame;
    QuestStep finishQuest;
    NpcStep killAvatar;
    Zone trollRoom;
    Zone dwarfEntrance;
    Zone dwarfMine;
    Zone keldagrim;
    Zone keldagrim2;
    Zone dwarvenMine;
    Zone khorvakRoom;
    Zone realm;

    @Override
    public Map<Integer, QuestStep> loadSteps() {
        this.loadZones();
        this.setupRequirements();
        this.setupConditions();
        this.setupSteps();
        HashMap<Integer, QuestStep> steps = new HashMap<Integer, QuestStep>();
        ConditionalStep goToDondakan = new ConditionalStep((QuestHelper)this, this.enterDwarfCave, new Requirement[0]);
        goToDondakan.addStep(this.inDwarfMine, this.talkToDondakan);
        goToDondakan.addStep(this.inDwarfEntrance, this.talkToFerryman);
        goToDondakan.addStep(this.inTrollRoom, this.enterDwarfCave2);
        steps.put(0, goToDondakan);
        ConditionalStep talkToDwarvenEngineer = new ConditionalStep((QuestHelper)this, this.travelToKeldagrim, new Requirement[0]);
        talkToDwarvenEngineer.addStep(this.inKeldagrim, this.talkToEngineer);
        talkToDwarvenEngineer.addStep(this.inDwarfEntrance, this.talkToBoatman);
        talkToDwarvenEngineer.addStep(this.inDwarfMine, this.travelBackWithFerryman);
        steps.put(10, talkToDwarvenEngineer);
        steps.put(20, this.talkToRolad);
        ConditionalStep getPages = new ConditionalStep((QuestHelper)this, this.enterDwarvenMine, new Requirement[0]);
        getPages.addStep(new Conditions(this.inDwarvenMine, this.pages), this.goBackUpToRolad);
        getPages.addStep(new Conditions(this.pages), this.returnToRolad);
        getPages.addStep(new Conditions(this.inDwarvenMine, this.page2, this.page1), this.mineRock);
        getPages.addStep(new Conditions(this.inDwarvenMine, this.page2), this.killScorpion);
        getPages.addStep(this.inDwarvenMine, this.searchCart);
        steps.put(30, getPages);
        steps.put(40, this.readEntireBook);
        ConditionalStep returnToDondakan = new ConditionalStep((QuestHelper)this, this.enterDwarfCaveWithBook, new Requirement[0]);
        returnToDondakan.addStep(this.inDwarfMine, this.talkToDondakanWithBook);
        returnToDondakan.addStep(this.inDwarfEntrance, this.talkToFerrymanWithBook);
        returnToDondakan.addStep(this.inTrollRoom, this.enterDwarfCave2WithBook);
        steps.put(50, returnToDondakan);
        ConditionalStep giveGoldBar = new ConditionalStep((QuestHelper)this, this.enterDwarfCaveWithBook, new Requirement[0]);
        giveGoldBar.addStep(this.shotGoldCannonball, this.talkToDondakanAfterShot);
        giveGoldBar.addStep(new Conditions(this.inDwarfMine, this.hasCannonball), this.useGoldCannonballOnDondakan);
        giveGoldBar.addStep(new Conditions(this.inDwarfEntrance, this.hasCannonball), this.talkToFerrymanWithCannonball);
        giveGoldBar.addStep(new Conditions(this.inTrollRoom, this.hasCannonball), this.enterDwarfCave2WithCannonball);
        giveGoldBar.addStep(this.hasCannonball, this.enterDwarfCaveWithCannonball);
        giveGoldBar.addStep(this.hasUsedGoldBar, this.makeGoldCannonball);
        giveGoldBar.addStep(this.inDwarfMine, this.useGoldBarOnDondakan);
        giveGoldBar.addStep(this.inDwarfEntrance, this.talkToFerrymanWithBook);
        giveGoldBar.addStep(this.inTrollRoom, this.enterDwarfCave2WithBook);
        steps.put(60, giveGoldBar);
        steps.put(70, this.talkToDondakanAfterShot);
        ConditionalStep sortSchematics = new ConditionalStep((QuestHelper)this, this.readBookAgain, new Requirement[0]);
        sortSchematics.addStep(new Conditions(this.hasSolvedSchematic, this.goldHelmet, this.inDwarfMine), this.talkToDondakanWithHelmet);
        sortSchematics.addStep(new Conditions(this.hasSolvedSchematic, this.goldHelmet, this.inDwarfEntrance), this.talkToFerrymanWithHelmet);
        sortSchematics.addStep(new Conditions(this.hasSolvedSchematic, this.goldHelmet, this.inTrollRoom), this.enterDwarfCave2WithHelmet);
        sortSchematics.addStep(new Conditions(this.hasSolvedSchematic, this.goldHelmet), this.enterDwarfCaveWithHelmet);
        sortSchematics.addStep(new Conditions(this.hasSolvedSchematic), this.useGoldBarOnAnvil);
        sortSchematics.addStep(new Conditions(this.baseSchematic, this.schematicEngineer, this.khorvakSchematic), this.assembleSchematic);
        sortSchematics.addStep(new Conditions(this.baseSchematic, this.schematicEngineer, this.khorvakSchematic), this.assembleSchematic);
        sortSchematics.addStep(new Conditions(this.baseSchematic, this.schematicEngineer, this.inKhorvakRoom), this.talkToKhorvak);
        sortSchematics.addStep(new Conditions(this.baseSchematic, this.schematicEngineer, this.goldHelmet), this.enterKhorvakRoom);
        sortSchematics.addStep(new Conditions(this.baseSchematic, this.schematicEngineer), this.useGoldBarOnAnvil);
        sortSchematics.addStep(new Conditions(this.baseSchematic, this.inKeldagrim), this.talkToEngineerAgain);
        sortSchematics.addStep(new Conditions(this.baseSchematic, this.inDwarfEntrance), this.talkToBoatmanAgain);
        sortSchematics.addStep(new Conditions(this.baseSchematic, this.inDwarfMine), this.travelBackWithFerrymanAgain);
        sortSchematics.addStep(this.baseSchematic, this.travelToKeldagrimAgain);
        steps.put(80, sortSchematics);
        ConditionalStep completeQuest = new ConditionalStep((QuestHelper)this, this.talkToDondakanForEnd, new Requirement[0]);
        completeQuest.addStep(this.avatarNearby, this.killAvatar);
        completeQuest.addStep(new Conditions(this.inRealm, this.goldOre6), this.talkToSecondFlame);
        completeQuest.addStep(this.inRealm, this.mine6GoldOre);
        steps.put(90, completeQuest);
        steps.put(100, this.finishQuest);
        return steps;
    }

    @Override
    public void setupRequirements() {
        this.pickaxe = new ItemRequirement("Any pickaxe", ItemCollections.PICKAXES).isNotConsumed();
        this.hammer = new ItemRequirement("Hammer", ItemCollections.HAMMER).isNotConsumed();
        this.coins5 = new ItemRequirement("Coins", ItemCollections.COINS, 5);
        this.page1 = new ItemRequirement("Book page 1", 4569);
        this.page2 = new ItemRequirement("Book page 2", 4570);
        this.page3 = new ItemRequirement("Book page 3", 4571);
        this.pages = new ItemRequirement("Pages", 4573);
        this.dwarvenLore = new ItemRequirement("Dwarven lore", 4568);
        this.dwarvenLore.setTooltip("You can get another from Rolad south of Ice Mountain");
        this.dwarvenLoreHighlight = new ItemRequirement("Dwarven lore", 4568);
        this.dwarvenLoreHighlight.setTooltip("You can get another from Rolad south of Ice Mountain");
        this.dwarvenLoreHighlight.setHighlightInInventory(true);
        this.goldBar = new ItemRequirement("Gold bar", 2357);
        this.goldBars3 = new ItemRequirement("Gold bars", 2357, 3);
        this.goldBarHighlight = new ItemRequirement("Gold bar", 2357);
        this.goldBarHighlight.setHighlightInInventory(true);
        this.goldCannonball = new ItemRequirement("Cannon ball", 4579);
        this.goldCannonballHighlight = new ItemRequirement("Cannon ball", 4579);
        this.goldCannonballHighlight.setHighlightInInventory(true);
        this.cannonMould = new ItemRequirement("Ammo mould", 4);
        this.cannonMould.setTooltip("You can buy one from Nulodion above the Dwarven Mine for 5 coins");
        this.schematic = new ItemRequirement("Schematic", 4575);
        this.schematicHighlight = new ItemRequirement("Schematic", 4575);
        this.schematicHighlight.setHighlightInInventory(true);
        this.baseSchematic = new ItemRequirement("Base schematics", 4574);
        this.schematicEngineer = new ItemRequirement("Schematics", 4576);
        this.goldHelmet = new ItemRequirement("Gold helmet", 4567);
        this.goldHelmetEquipped = new ItemRequirement("Gold helmet", 4567, 1, true);
        this.khorvakSchematic = new ItemRequirement("Khorvak schematic", 4577);
        this.solvedSchematic = new ItemRequirement("Schematic", 4578);
        this.combatGear = new ItemRequirement("Combat gear", -1, -1).isNotConsumed();
        this.combatGear.setDisplayItemId(BankSlotIcons.getCombatGear());
        this.food = new ItemRequirement("Food", ItemCollections.GOOD_EATING_FOOD, -1);
        this.goldOre6 = new ItemRequirement("Gold ores", 444, 6);
        this.goldBars4 = new ItemRequirement("Gold bars", 2357, 4);
        this.coins1000 = new ItemRequirement("Coins for travelling", ItemCollections.COINS, 1000);
    }

    public void loadZones() {
        this.trollRoom = new Zone(new WorldPoint(2762, 10123, 0), new WorldPoint(2804, 10164, 0));
        this.dwarfEntrance = new Zone(new WorldPoint(2814, 10121, 0), new WorldPoint(2884, 10139, 0));
        this.dwarfMine = new Zone(new WorldPoint(2816, 10139, 0), new WorldPoint(2878, 10176, 0));
        this.keldagrim = new Zone(new WorldPoint(2816, 10177, 0), new WorldPoint(2943, 10239, 0));
        this.keldagrim2 = new Zone(new WorldPoint(2901, 10150, 0), new WorldPoint(2943, 10177, 0));
        this.dwarvenMine = new Zone(new WorldPoint(2960, 9696, 0), new WorldPoint(3062, 9854, 0));
        this.khorvakRoom = new Zone(new WorldPoint(2815, 9856, 0), new WorldPoint(2880, 9888, 0));
        this.realm = new Zone(new WorldPoint(2306, 4928, 0), new WorldPoint(2440, 4990, 0));
    }

    public void setupConditions() {
        this.inTrollRoom = new ZoneRequirement(this.trollRoom);
        this.inDwarfEntrance = new ZoneRequirement(this.dwarfEntrance);
        this.inDwarfMine = new ZoneRequirement(this.dwarfMine);
        this.inKeldagrim = new ZoneRequirement(this.keldagrim, this.keldagrim2);
        this.inDwarvenMine = new ZoneRequirement(this.dwarvenMine);
        this.inKhorvakRoom = new ZoneRequirement(this.khorvakRoom);
        this.hasUsedGoldBar = new VarbitRequirement(301, 1);
        this.shotGoldCannonball = new VarbitRequirement(313, 1);
        this.hasCannonball = new Conditions(LogicType.OR, this.goldCannonball, this.shotGoldCannonball);
        this.hasSolvedSchematic = new VarbitRequirement(305, 1);
        this.inRealm = new ZoneRequirement(this.realm);
        this.avatarNearby = new Conditions(LogicType.OR, new NpcCondition(1233), new NpcCondition(1234), new NpcCondition(1235), new NpcCondition(1230), new NpcCondition(1231), new NpcCondition(1232), new NpcCondition(1227), new NpcCondition(1228), new NpcCondition(1229));
    }

    public void setupSteps() {
        this.enterDwarfCave = new ObjectStep((QuestHelper)this, 5008, new WorldPoint(2732, 3713, 0), "Travel to the Keldagrim south mines and talk to Dondakan there.", this.coins5);
        this.enterDwarfCave2 = new ObjectStep((QuestHelper)this, 5973, new WorldPoint(2781, 10161, 0), "Travel to the Keldagrim south mines and talk to Dondakan there.", this.coins5);
        this.talkToFerryman = new NpcStep((QuestHelper)this, 4896, new WorldPoint(2829, 10129, 0), "Pay the Dwarven Ferryman 5 coins to travel across the water.", this.coins5);
        this.talkToFerryman.addDialogStep("Yes please.");
        this.talkToDondakan = new NpcStep((QuestHelper)this, 4890, new WorldPoint(2822, 10167, 0), "Talk to Dondakan in the north of the mine.", new Requirement[0]);
        this.talkToDondakan.addDialogStep("Why are you firing a cannon at a wall?");
        this.talkToDondakan.addDialogStep("So why were you trying to get through the rock again?");
        this.talkToDondakan.addDialogStep("Sounds interesting!");
        this.talkToDondakan.addSubSteps(this.enterDwarfCave, this.enterDwarfCave2, this.talkToFerryman);
        this.travelBackWithFerryman = new NpcStep((QuestHelper)this, 4897, new WorldPoint(2854, 10142, 0), "Talk to the Dwarven Engineer in west Keldagrim.", new Requirement[0]);
        this.talkToBoatman = new NpcStep((QuestHelper)this, 7726, new WorldPoint(2842, 10129, 0), "Talk to the Dwarven Engineer in west Keldagrim.", new Requirement[0]);
        this.travelToKeldagrim = new DetailedQuestStep((QuestHelper)this, "Talk to the Dwarven Engineer in west Keldagrim.", new Requirement[0]);
        this.talkToEngineer = new NpcStep((QuestHelper)this, 4893, new WorldPoint(2870, 10199, 0), "Talk to the Dwarven Engineer in west Keldagrim.", new Requirement[0]);
        this.talkToEngineer.addSubSteps(this.travelBackWithFerryman, this.talkToBoatman, this.travelToKeldagrim);
        this.talkToRolad = new NpcStep((QuestHelper)this, 4894, new WorldPoint(3022, 3453, 0), "Talk to Rolad at the Ice Mountain entrance to the Dwarven Mine. If you don't have an ammo mould, buy one from Nulodion whilst you're here.", this.pickaxe);
        this.talkToRolad.addDialogStep("I'll be back later.");
        this.enterDwarvenMine = new ObjectStep((QuestHelper)this, 11867, new WorldPoint(3019, 3450, 0), "Enter the Dwarven Mine.", this.pickaxe);
        this.searchCart = new ObjectStep((QuestHelper)this, 6045, "Search the mine carts for a page.", new Requirement[0]);
        this.killScorpion = new NpcStep((QuestHelper)this, 3024, new WorldPoint(3043, 9796, 0), "Kill scorpions for a page.", true, new Requirement[0]);
        this.mineRock = new ObjectStep((QuestHelper)this, 11361, "Mine low level rocks for a page.", true, this.pickaxe);
        this.mineRock.setOverlayText("Mine low level rocks for a page.\n\nYou can continue mining the same rocks.");
        this.mineRock.addAlternateObjects(11360, 11362, 11363, 11364, 11365, 11161, 10943);
        this.goBackUpToRolad = new ObjectStep((QuestHelper)this, 17387, new WorldPoint(3019, 9850, 0), "Go back up to Rolad.", this.pages);
        this.returnToRolad = new NpcStep((QuestHelper)this, 4894, new WorldPoint(3022, 3453, 0), "Talk to Rolad again.", this.pages);
        this.returnToRolad.addSubSteps(this.goBackUpToRolad);
        this.readEntireBook = new DetailedQuestStep((QuestHelper)this, "Read the entire dwarven lore book.", this.dwarvenLoreHighlight);
        this.enterDwarfCaveWithBook = new ObjectStep((QuestHelper)this, 5008, new WorldPoint(2732, 3713, 0), "Return to Dondakan with the book and a gold bar.", this.coins5, this.goldBar, this.dwarvenLore);
        this.enterDwarfCave2WithBook = new ObjectStep((QuestHelper)this, 5973, new WorldPoint(2781, 10161, 0), "Return to Dondakan with the book and a gold bar.", this.coins5, this.goldBar, this.dwarvenLore);
        this.talkToFerrymanWithBook = new NpcStep((QuestHelper)this, 4896, new WorldPoint(2829, 10129, 0), "Return to Dondakan with the book and a gold bar.", this.coins5, this.goldBar, this.dwarvenLore);
        this.talkToFerrymanWithBook.addDialogStep("Yes please.");
        this.talkToDondakanWithBook = new NpcStep((QuestHelper)this, 4890, new WorldPoint(2822, 10167, 0), "Return to Dondakan with the book and a gold bar.", this.goldBar, this.dwarvenLore);
        this.talkToDondakanWithBook.addSubSteps(this.enterDwarfCaveWithBook, this.enterDwarfCave2WithBook, this.talkToFerrymanWithBook);
        this.useGoldBarOnDondakan = new NpcStep((QuestHelper)this, 4890, new WorldPoint(2822, 10167, 0), "Use a gold bar on Dondakan.", this.goldBarHighlight);
        this.useGoldBarOnDondakan.addIcon(2357);
        this.makeGoldCannonball = new DetailedQuestStep((QuestHelper)this, "Use a gold bar on a furnace to make a gold cannonball.", this.goldBar, this.cannonMould);
        this.enterDwarfCaveWithCannonball = new ObjectStep((QuestHelper)this, 5008, new WorldPoint(2732, 3713, 0), "Return to Dondakan with the book and the gold cannonball.", this.coins5, this.goldCannonball, this.dwarvenLore);
        this.enterDwarfCave2WithCannonball = new ObjectStep((QuestHelper)this, 5973, new WorldPoint(2781, 10161, 0), "Return to Dondakan with the book and the gold cannonball.", this.coins5, this.goldCannonball, this.dwarvenLore);
        this.talkToFerrymanWithCannonball = new NpcStep((QuestHelper)this, 4896, new WorldPoint(2829, 10129, 0), "Return to Dondakan with the book and the gold cannonball.", this.coins5, this.goldCannonball, this.dwarvenLore);
        this.talkToFerrymanWithCannonball.addDialogStep("Yes please.");
        this.useGoldCannonballOnDondakan = new NpcStep((QuestHelper)this, 4890, new WorldPoint(2822, 10167, 0), "Use a gold cannon ball on Dondakan.", this.goldCannonballHighlight);
        this.useGoldCannonballOnDondakan.addIcon(4579);
        this.useGoldCannonballOnDondakan.addDialogStep("Yes, I'm sure this will crack open the rock.");
        this.useGoldCannonballOnDondakan.addSubSteps(this.enterDwarfCaveWithCannonball, this.enterDwarfCave2WithCannonball, this.talkToFerrymanWithCannonball);
        this.talkToDondakanAfterShot = new NpcStep((QuestHelper)this, 4890, new WorldPoint(2822, 10167, 0), "Talk to Dondakan.", new Requirement[0]);
        this.talkToDondakanAfterShot.addDialogStep("So you want to... fire me into the rock?");
        this.talkToDondakanAfterShot.addDialogStep("I can't argue with that, shoot me in!");
        this.readBookAgain = new DetailedQuestStep((QuestHelper)this, "Read the last page of the dwarven lore book again for a base schematic.", this.dwarvenLoreHighlight);
        this.readBookAgain.addDialogStep("Yes.");
        this.travelBackWithFerrymanAgain = new NpcStep((QuestHelper)this, 4897, new WorldPoint(2854, 10142, 0), "Talk to the Dwarven Engineer in west Keldagrim.", this.schematic, this.baseSchematic);
        this.talkToBoatmanAgain = new NpcStep((QuestHelper)this, 7726, new WorldPoint(2842, 10129, 0), "Talk to the Dwarven Engineer in west Keldagrim.", this.schematic, this.baseSchematic);
        this.travelToKeldagrimAgain = new DetailedQuestStep((QuestHelper)this, "Talk to the Dwarven Engineer in west Keldagrim.", this.schematic, this.baseSchematic);
        this.talkToEngineerAgain = new NpcStep((QuestHelper)this, 4893, new WorldPoint(2870, 10199, 0), "Talk to the Dwarven Engineer in west Keldagrim.", this.schematic, this.baseSchematic);
        this.talkToEngineerAgain.addSubSteps(this.travelBackWithFerrymanAgain, this.talkToBoatmanAgain, this.travelToKeldagrimAgain);
        this.useGoldBarOnAnvil = new ObjectStep((QuestHelper)this, 6150, new WorldPoint(2869, 10202, 0), "Use 3 gold bars on an anvil to make a gold helmet.", this.goldBars3, this.hammer);
        this.useGoldBarOnAnvil.addDialogStep("Golden helmet.");
        this.useGoldBarOnAnvil.addDialogStep("Yes.");
        this.enterKhorvakRoom = new ObjectStep((QuestHelper)this, 55, new WorldPoint(2821, 3485, 0), "Talk to Khorvak under White Wolf Mountain.", new Requirement[0]);
        this.talkToKhorvak = new NpcStep((QuestHelper)this, 4895, new WorldPoint(2867, 9876, 0), "Talk to Khorvak under White Wolf Mountain.", new Requirement[0]);
        this.talkToKhorvak.addDialogStep("No, I've had enough of buying drinks for people!");
        this.talkToKhorvak.addSubSteps(this.enterKhorvakRoom);
        this.assembleSchematic = new PuzzleStep((QuestHelper)this, this.schematicHighlight);
        this.enterDwarfCaveWithHelmet = new ObjectStep((QuestHelper)this, 5008, new WorldPoint(2732, 3713, 0), "Prepare to for a fight, then return to Dondakan.", this.coins5, this.goldHelmetEquipped, this.solvedSchematic, this.pickaxe, this.combatGear, this.food);
        this.enterDwarfCave2WithHelmet = new ObjectStep((QuestHelper)this, 5973, new WorldPoint(2781, 10161, 0), "Prepare for a fight, then return to Dondakan.", this.coins5, this.goldHelmetEquipped, this.solvedSchematic, this.pickaxe, this.combatGear, this.food);
        this.talkToFerrymanWithHelmet = new NpcStep((QuestHelper)this, 4896, new WorldPoint(2829, 10129, 0), "Prepare for a fight, then return to Dondakan.", this.coins5, this.goldHelmetEquipped, this.solvedSchematic, this.pickaxe, this.combatGear, this.food);
        this.talkToFerrymanWithHelmet.addDialogStep("Yes please.");
        this.talkToDondakanWithHelmet = new NpcStep((QuestHelper)this, 4890, new WorldPoint(2822, 10167, 0), "Prepare for a fight, then return to Dondakan.", this.coins5, this.goldHelmetEquipped, this.solvedSchematic, this.pickaxe, this.combatGear, this.food);
        this.talkToDondakanWithHelmet.addDialogStep("You may fire when ready!");
        this.talkToDondakanForEnd = new NpcStep((QuestHelper)this, 4890, new WorldPoint(2822, 10167, 0), "Prepare for a fight, then return to Dondakan.", this.coins5, this.goldHelmetEquipped, this.pickaxe, this.combatGear, this.food);
        this.talkToDondakanForEnd.addDialogStep("Ready as I'll ever be.");
        this.talkToDondakanWithHelmet.addSubSteps(this.enterDwarfCaveWithHelmet, this.enterDwarfCave2WithHelmet, this.talkToFerrymanWithHelmet, this.talkToDondakanForEnd);
        this.mine6GoldOre = new DetailedQuestStep((QuestHelper)this, "Mine 6 gold ores. If you want the Avatar to be level 75 vs 125, get 15. Keep these in your inventory for the boss fight. Do not remove your gold helmet.", this.pickaxe, this.goldHelmetEquipped);
        this.talkToSecondFlame = new ObjectStep((QuestHelper)this, 5979, new WorldPoint(2373, 4956, 0), "TALK to the central wall of flame.", this.goldHelmetEquipped);
        this.killAvatar = new NpcStep((QuestHelper)this, 1233, new WorldPoint(2375, 4953, 0), "Kill the avatar. Make sure to keep the gold ores in your inventory.", this.goldHelmetEquipped);
        this.killAvatar.addAlternateNpcs(1234, 1235, 1230, 1231, 1232, 1227, 1228, 1229);
        this.finishQuest = new NpcStep((QuestHelper)this, 4890, new WorldPoint(2822, 10167, 0), "Talk to Dondakan to finish the quest.", new Requirement[0]);
    }

    @Override
    public List<ItemRequirement> getItemRequirements() {
        ArrayList<ItemRequirement> reqs = new ArrayList<ItemRequirement>();
        reqs.add(this.pickaxe);
        reqs.add(this.goldBars4);
        reqs.add(this.hammer);
        reqs.add(this.cannonMould);
        reqs.add(this.coins1000);
        return reqs;
    }

    @Override
    public List<String> getCombatRequirements() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("Scorpion (level 14)");
        reqs.add("Arzinian Being of Bordanzan (level 75 - 125)");
        return reqs;
    }

    @Override
    public QuestPointReward getQuestPointReward() {
        return new QuestPointReward(2);
    }

    @Override
    public List<ExperienceReward> getExperienceRewards() {
        return Arrays.asList(new ExperienceReward(Skill.DEFENCE, 5000), new ExperienceReward(Skill.MINING, 5000), new ExperienceReward(Skill.SMITHING, 5000));
    }

    @Override
    public List<ItemReward> getItemRewards() {
        return Collections.singletonList(new ItemReward("A Rune Pickaxe.", 1275, 1));
    }

    @Override
    public List<UnlockReward> getUnlockRewards() {
        return Arrays.asList(new UnlockReward("Ability to Teleport to Dondakan's Rock using a Ring of Wealth."), new UnlockReward("Access to Arzinian Mine."));
    }

    @Override
    public List<PanelDetails> getPanels() {
        ArrayList<PanelDetails> allSteps = new ArrayList<PanelDetails>();
        allSteps.add(new PanelDetails("Starting off", Collections.singletonList(this.talkToDondakan), new Requirement[0]));
        allSteps.add(new PanelDetails("Research", Arrays.asList(this.talkToEngineer, this.talkToRolad, this.enterDwarvenMine, this.searchCart, this.killScorpion, this.mineRock, this.returnToRolad, this.readEntireBook), this.coins5, this.pickaxe));
        allSteps.add(new PanelDetails("Experiment", Arrays.asList(this.talkToDondakanWithBook, this.useGoldBarOnDondakan, this.makeGoldCannonball, this.useGoldCannonballOnDondakan), this.cannonMould, this.goldBar));
        allSteps.add(new PanelDetails("Solving the schematic", Arrays.asList(this.readBookAgain, this.talkToEngineerAgain, this.useGoldBarOnAnvil, this.talkToKhorvak, this.assembleSchematic), this.goldBars3, this.hammer));
        allSteps.add(new PanelDetails("Into the hard place", Arrays.asList(this.talkToDondakanWithHelmet, this.mine6GoldOre, this.talkToSecondFlame, this.killAvatar, this.finishQuest), this.goldHelmet, this.solvedSchematic, this.coins5, this.pickaxe, this.combatGear, this.food));
        return allSteps;
    }

    @Override
    public List<Requirement> getGeneralRequirements() {
        ArrayList<Requirement> req = new ArrayList<Requirement>();
        req.add(new QuestRequirement(QuestHelperQuest.DWARF_CANNON, QuestState.FINISHED));
        req.add(new QuestRequirement(QuestHelperQuest.FISHING_CONTEST, QuestState.FINISHED));
        req.add(new SkillRequirement(Skill.DEFENCE, 30));
        req.add(new SkillRequirement(Skill.MINING, 40, true));
        req.add(new SkillRequirement(Skill.SMITHING, 50, true));
        return req;
    }
}

